<?php

namespace App\Tec\Actions;

use App\Models\User;

class SaveUser
{
    /**
     * Save transfers with relationships
     *
     * @param  array<string, string>  $input
     * @param  User  $input
     */
    public function execute(array $data, User $user = new User): User
    {
        $roles = $data['roles'] ?? [];
        $stores = $data['stores'] ?? [];
        $settings = $data['settings'] ?? [];
        unset($data['roles'], $data['stores'], $data['settings']);

        // $user->email_verified_at = now();

        $user->fill($data)->save();

        $user->syncRoles($roles);
        $user->stores()->sync($stores);
        if (! empty($settings)) {
            $settings = collect($settings)->transform(fn ($item) => ['key' => $item['key'], 'value' => $item['value'], 'user_id' => $user->id])->toArray();
            $user->settings()->upsert($settings, uniqueBy: ['key', 'user_id'], update: ['value']);
        }

        if ($user->customer_id) {
            $user->assignRole('Customer');
        }

        return $user;
    }
}
