<?php

namespace App\Tec\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class LocaleLength implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  Closure(string, ?string=): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        if (strlen($value) != 2 || strlen($value) != 5) {
            $fail(__('The locale length should be 2 or 5 characters e.g. en or en-US.'));
        }
    }
}
