import { ref, unref, mergeProps, withCtx, createTextVNode, toDisplayString, createVNode, createBlock, openBlock, withModifiers, useSSRContext } from "vue";
import { ssrRenderComponent, ssrRenderClass, ssrInterpolate } from "vue/server-renderer";
import dayjs from "dayjs";
import { useI18n } from "vue-i18n";
import { usePage, useForm } from "@inertiajs/vue3";
import { h as _sfc_main$2, n as $random, b as _sfc_main$3, g as _sfc_main$4 } from "./http-CDixhmav.js";
import "../ssr.js";
import "lodash.debounce";
import { _ as _sfc_main$5 } from "./LoadingButton-DREeyNQW.js";
import "./ActionMessage-cgGHxf5V.js";
import { b as _sfc_main$1 } from "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import "@vuepic/vue-datepicker";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = {
  __name: "AddGiftCard",
  __ssrInlineRender: true,
  props: ["show"],
  emits: ["close"],
  setup(__props, { emit: __emit }) {
    usePage();
    const { t } = useI18n({});
    const emit = __emit;
    ref(false);
    const gist_card_form = useForm({ number: null, amount: null, customer_id: null, expiry_date: dayjs().add(2, "year").format("YYYY-MM-DD") });
    async function addGiftCard(e) {
      gist_card_form.errors = {};
      if (!gist_card_form.number) {
        gist_card_form.errors.number = t("The gift card number is required.");
      }
      if (!gist_card_form.amount) {
        gist_card_form.errors.amount = t("The gift card amount is required.");
      }
      if (!Object.keys(gist_card_form.errors).length) {
        let item = {
          taxes: null,
          quantity: 1,
          type: "Gift Card",
          name: t("Gift Card"),
          code: gist_card_form.number,
          price: gist_card_form.amount,
          net_price: gist_card_form.amount,
          unit_price: gist_card_form.amount,
          customer_id: gist_card_form.customer_id,
          expiry_date: gist_card_form.expiry_date
        };
        gist_card_form.reset();
        emit("close", item);
      }
    }
    return (_ctx, _push, _parent, _attrs) => {
      var _a;
      _push(ssrRenderComponent(unref(_sfc_main$1), mergeProps({
        show: __props.show,
        maxWidth: "xl",
        closeable: true,
        overflow: true,
        round: ((_a = _ctx.$page.props.settings) == null ? void 0 : _a.pos_design) == "Modern"
      }, _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          var _a2, _b;
          if (_push2) {
            _push2(`<div class="${ssrRenderClass([((_a2 = _ctx.$page.props.settings) == null ? void 0 : _a2.pos_design) == "Modern" ? "rounded-2xl" : "rounded-lg", "transition-all"])}"${_scopeId}><div class="relative border-b border-gray-200 dark:border-gray-700 p-4 sm:px-6"${_scopeId}><div class="absolute right-0 top-0 pr-4 pt-4 flex items-center gap-x-4"${_scopeId}><button type="button" class="rounded-md text-gray-400 hover:text-gray-500 focus:outline-hidden focus:ring-2 focus:ring-primary-500 focus:ring-offset-2"${_scopeId}><span class="sr-only"${_scopeId}>${ssrInterpolate(_ctx.$t("Close"))}</span><svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true"${_scopeId}><path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"${_scopeId}></path></svg></button></div><div${_scopeId}><h3 class="text-base font-semibold leading-6 text-gray-900 dark:text-gray-100"${_scopeId}>${ssrInterpolate(_ctx.$t("Sell Gift Card"))}</h3><p class="mt-1 text-sm"${_scopeId}>${ssrInterpolate(_ctx.$t("Please add card details below."))}</p></div></div><form autocomplete="off"${_scopeId}><div class="bg-gray-100 dark:bg-gray-800"${_scopeId}><div class="p-6 grid grid-cols-1 md:grid-cols-6 gap-6"${_scopeId}><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$2), {
              autofocus: "",
              label: unref(t)("Number"),
              "action-text": "Generate",
              modelValue: unref(gist_card_form).number,
              "onUpdate:modelValue": ($event) => unref(gist_card_form).number = $event,
              error: unref(gist_card_form).errors.number,
              action: () => unref(gist_card_form).number = unref($random)(1e11, 1e16)
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$2), {
              type: "number",
              label: unref(t)("Amount Value"),
              modelValue: unref(gist_card_form).amount,
              "onUpdate:modelValue": ($event) => unref(gist_card_form).amount = $event,
              error: unref(gist_card_form).errors.amount
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$3), {
              json: true,
              valueKey: "id",
              labelKey: "name",
              onChange: _ctx.saveForm,
              searchable: true,
              id: "gc_customer_id",
              label: unref(t)("Customer"),
              modelValue: unref(gist_card_form).customer_id,
              "onUpdate:modelValue": ($event) => unref(gist_card_form).customer_id = $event,
              suggestions: _ctx.route("search.customers"),
              error: unref(gist_card_form).errors.customer_id
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$4), {
              label: _ctx.$t("Expiry Date"),
              modelValue: unref(gist_card_form).expiry_date,
              "onUpdate:modelValue": ($event) => unref(gist_card_form).expiry_date = $event,
              error: unref(gist_card_form).errors.expiry_date
            }, null, _parent2, _scopeId));
            _push2(`</div></div></div><div class="py-4 px-6 border-t dark:border-gray-700 flex items-center justify-end"${_scopeId}><button type="button" class="link mr-4"${_scopeId}>${ssrInterpolate(_ctx.$t("Cancel"))}</button>`);
            _push2(ssrRenderComponent(unref(_sfc_main$5), {
              class: "justify-center",
              disabled: unref(gist_card_form).processing,
              loading: unref(gist_card_form).processing
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Add to Order"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Add to Order")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div></form></div>`);
          } else {
            return [
              createVNode("div", {
                class: ["transition-all", ((_b = _ctx.$page.props.settings) == null ? void 0 : _b.pos_design) == "Modern" ? "rounded-2xl" : "rounded-lg"]
              }, [
                createVNode("div", { class: "relative border-b border-gray-200 dark:border-gray-700 p-4 sm:px-6" }, [
                  createVNode("div", { class: "absolute right-0 top-0 pr-4 pt-4 flex items-center gap-x-4" }, [
                    createVNode("button", {
                      type: "button",
                      onClick: ($event) => emit("close"),
                      class: "rounded-md text-gray-400 hover:text-gray-500 focus:outline-hidden focus:ring-2 focus:ring-primary-500 focus:ring-offset-2"
                    }, [
                      createVNode("span", { class: "sr-only" }, toDisplayString(_ctx.$t("Close")), 1),
                      (openBlock(), createBlock("svg", {
                        class: "h-6 w-6",
                        fill: "none",
                        viewBox: "0 0 24 24",
                        "stroke-width": "1.5",
                        stroke: "currentColor",
                        "aria-hidden": "true"
                      }, [
                        createVNode("path", {
                          "stroke-linecap": "round",
                          "stroke-linejoin": "round",
                          d: "M6 18L18 6M6 6l12 12"
                        })
                      ]))
                    ], 8, ["onClick"])
                  ]),
                  createVNode("div", null, [
                    createVNode("h3", { class: "text-base font-semibold leading-6 text-gray-900 dark:text-gray-100" }, toDisplayString(_ctx.$t("Sell Gift Card")), 1),
                    createVNode("p", { class: "mt-1 text-sm" }, toDisplayString(_ctx.$t("Please add card details below.")), 1)
                  ])
                ]),
                createVNode("form", {
                  onSubmit: withModifiers(addGiftCard, ["prevent"]),
                  autocomplete: "off"
                }, [
                  createVNode("div", { class: "bg-gray-100 dark:bg-gray-800" }, [
                    createVNode("div", { class: "p-6 grid grid-cols-1 md:grid-cols-6 gap-6" }, [
                      createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                        createVNode(unref(_sfc_main$2), {
                          autofocus: "",
                          label: unref(t)("Number"),
                          "action-text": "Generate",
                          modelValue: unref(gist_card_form).number,
                          "onUpdate:modelValue": ($event) => unref(gist_card_form).number = $event,
                          error: unref(gist_card_form).errors.number,
                          action: () => unref(gist_card_form).number = unref($random)(1e11, 1e16)
                        }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error", "action"])
                      ]),
                      createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                        createVNode(unref(_sfc_main$2), {
                          type: "number",
                          label: unref(t)("Amount Value"),
                          modelValue: unref(gist_card_form).amount,
                          "onUpdate:modelValue": ($event) => unref(gist_card_form).amount = $event,
                          error: unref(gist_card_form).errors.amount
                        }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
                      ]),
                      createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                        createVNode(unref(_sfc_main$3), {
                          json: true,
                          valueKey: "id",
                          labelKey: "name",
                          onChange: _ctx.saveForm,
                          searchable: true,
                          id: "gc_customer_id",
                          label: unref(t)("Customer"),
                          modelValue: unref(gist_card_form).customer_id,
                          "onUpdate:modelValue": ($event) => unref(gist_card_form).customer_id = $event,
                          suggestions: _ctx.route("search.customers"),
                          error: unref(gist_card_form).errors.customer_id
                        }, null, 8, ["onChange", "label", "modelValue", "onUpdate:modelValue", "suggestions", "error"])
                      ]),
                      createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                        createVNode(unref(_sfc_main$4), {
                          label: _ctx.$t("Expiry Date"),
                          modelValue: unref(gist_card_form).expiry_date,
                          "onUpdate:modelValue": ($event) => unref(gist_card_form).expiry_date = $event,
                          error: unref(gist_card_form).errors.expiry_date
                        }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
                      ])
                    ])
                  ]),
                  createVNode("div", { class: "py-4 px-6 border-t dark:border-gray-700 flex items-center justify-end" }, [
                    createVNode("button", {
                      type: "button",
                      onClick: ($event) => emit("close"),
                      class: "link mr-4"
                    }, toDisplayString(_ctx.$t("Cancel")), 9, ["onClick"]),
                    createVNode(unref(_sfc_main$5), {
                      class: "justify-center",
                      disabled: unref(gist_card_form).processing,
                      loading: unref(gist_card_form).processing
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(_ctx.$t("Add to Order")), 1)
                      ]),
                      _: 1
                    }, 8, ["disabled", "loading"])
                  ])
                ], 32)
              ], 2)
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Pos/Components/AddGiftCard.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
