import { ref, resolveComponent, mergeProps, unref, withCtx, createVNode, createBlock, toDisplayString, openBlock, createTextVNode, Fragment, renderList, createCommentVNode, withModifiers, isRef, useSSRContext, watch, onMounted, nextTick, resolveDynamicComponent, renderSlot } from "vue";
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent, ssrRenderAttr, ssrRenderClass, ssrRenderList, ssrRenderStyle, ssrRenderVNode, ssrRenderSlot } from "vue/server-renderer";
import { usePage, router, Link } from "@inertiajs/vue3";
import { _ as _sfc_main$9 } from "./AppLayout-BRHmSgDa.js";
import { o as $can, p as _sfc_main$8, q as _sfc_main$a } from "./http-CDixhmav.js";
import { T } from "../ssr.js";
import "lodash.debounce";
import "dayjs";
import "./LoadingButton-DREeyNQW.js";
import { createI18n, useI18n } from "vue-i18n";
import "./ActionMessage-cgGHxf5V.js";
import { b as _sfc_main$7 } from "./ActionSection-DLY4AkI5.js";
import { A as ApplicationLogo } from "./AuthenticationCardLogo-BUP7R51z.js";
import { a as _sfc_main$4, _ as _sfc_main$5, b as _sfc_main$6 } from "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
const getMenus = (t) => {
  return [
    {
      name: "main",
      heading: t("Main"),
      menus: [
        {
          name: "dashboard",
          route: "dashboard",
          icon: "home",
          permissions: ["all"],
          label: t("Dashboard")
        },
        // {
        //   name: 'pos',
        //   route: 'pos',
        //   icon: 'pos',
        //   permissions: ['pos'],
        //   label: t('Point of Sale'),
        // },
        {
          name: "pos",
          route: null,
          icon: "pos",
          route_prefix: "pos",
          label: t("Point of Sale"),
          permissions: ["pos", "read-orders"],
          sub_menu: [
            {
              name: "pos",
              route: "pos",
              icon: "pos-o",
              target: "pos",
              permissions: ["pos"],
              label: t("POS Sale")
            },
            {
              name: "settings.pos",
              route: "settings.pos",
              icon: "cog-o",
              target: "pos",
              permissions: ["settings"],
              label: t("POS Settings")
            },
            {
              name: "orders.index",
              route: "orders.index",
              icon: "orders-o",
              target: "pos",
              permissions: ["read-orders"],
              label: t("List POS Orders")
            }
          ]
        },
        {
          name: "orders",
          route: null,
          icon: "squares",
          route_prefix: "orders",
          label: t("Sales & Purchases"),
          permissions: [
            "read-sales",
            "create-sales",
            "read-purchases",
            "create-purchases",
            "read-payments",
            "read-deliveries",
            "read-quotations",
            "read-expenses",
            "read-gift-cards",
            "read-return-orders",
            "read-orders"
          ],
          sub_menu: [
            {
              name: "sales.list",
              route: "sales.index",
              icon: "bag",
              target: "orders",
              permissions: ["read-sales"],
              label: t("List All {x}", { x: t("Sales") })
            },
            {
              name: "sales.create",
              route: "sales.create",
              icon: "bag-o",
              target: "orders",
              permissions: ["create-sales"],
              label: t("Add New {x}", { x: t("Sale") })
            },
            { name: "separator" },
            {
              name: "purchases.list",
              route: "purchases.index",
              icon: "cart",
              target: "orders",
              permissions: ["read-purchases"],
              label: t("List All {x}", { x: t("Purchases") })
            },
            {
              name: "purchases.create",
              route: "purchases.create",
              icon: "cart-o",
              target: "orders",
              permissions: ["create-purchases"],
              label: t("Add New {x}", { x: t("Purchase") })
            },
            { name: "separator" },
            {
              name: "payments.list",
              route: "payments.index",
              icon: "dollar",
              target: "orders",
              permissions: ["read-payments"],
              label: t("Payments")
              //   label: t('List All {x}', { x: t('Payments') }),
            },
            // {
            //   name: 'payments.create',
            //   route: 'payments.create',
            //   icon: 'dollar-o',
            //   target: 'orders',
            //   permissions: ['create-payments'],
            //   label: t('Add New {x}', { x: t('Payment') }),
            // },
            // { name: 'separator' },
            {
              name: "deliveries.list",
              route: "deliveries.index",
              icon: "truck",
              target: "orders",
              permissions: ["read-deliveries"],
              label: t("Deliveries")
              //   label: t('List All {x}', { x: t('Payments') }),
            },
            {
              name: "quotations.list",
              route: "quotations.index",
              icon: "docs",
              target: "orders",
              permissions: ["read-quotations"],
              label: t("Quotations")
              //   label: t('List All {x}', { x: t('Quotations') }),
            },
            {
              name: "expenses.list",
              route: "expenses.index",
              icon: "money",
              target: "orders",
              permissions: ["read-expenses"],
              label: t("Expenses")
              //   label: t('List All {x}', { x: t('Expenses') }),
            },
            // {
            //   name: 'expenses.create',
            //   route: 'expenses.create',
            //   icon: 'money-o',
            //   target: 'orders',
            //   permissions: ['create-expenses'],
            //   label: t('Add New {x}', { x: t('Expense') }),
            // },
            {
              name: "gift_cards.list",
              route: "gift_cards.index",
              icon: "gift",
              target: "orders",
              permissions: ["read-gift-cards"],
              label: t("Gift Cards")
            },
            // { name: 'separator' },
            {
              name: "return_orders.list",
              route: "return_orders.index",
              icon: "return",
              target: "orders",
              permissions: ["read-return-orders"],
              label: t("Return Orders")
              //   label: t('List All {x}', { x: t('Return Orders') }),
            }
            // {
            //   name: 'return_orders.create',
            //   route: 'return_orders.create',
            //   icon: 'add',
            //   target: 'orders',
            //   permissions: ['create-return_orders'],
            //   label: t('Add New {x}', { x: t('Return Order') }),
            // },
          ]
        },
        // {
        //   name: 'sales',
        //   route: null,
        //   icon: 'bag',
        //   route_prefix: 'sales',
        //   label: t('Sales'),
        //   permissions: ['read-sales', 'create-sales', 'update-sales'],
        //   sub_menu: [
        //     {
        //       name: 'sales.list',
        //       route: 'sales.index',
        //       icon: 'list',
        //       target: 'sales',
        //       permissions: ['read-sales'],
        //       label: t('List All {x}', { x: t('Sales') }),
        //     },
        //     {
        //       name: 'sales.create',
        //       route: 'sales.create',
        //       icon: 'add',
        //       target: 'sales',
        //       permissions: ['create-sales'],
        //       label: t('Add New {x}', { x: t('Sale') }),
        //     },
        //     {
        //       name: 'products.edit',
        //       route: 'products.edit',
        //       icon: 'add',
        //       hidden: true,
        //       target: 'products',
        //       permissions: ['update-products'],
        //       label: t('Edit {x}', { x: t('Sale') }),
        //     },
        //     // { name: 'separator' },
        //     // {
        //     //   name: 'expenses.index',
        //     //   route: 'expenses.index',
        //     //   icon: 'adjust-v',
        //     //   target: 'products',
        //     //   permissions: ['read-expenses', 'update-expenses'],
        //     //   label: t('Expenses'),
        //     // },
        //   ],
        // },
        // {
        //   name: 'purchases',
        //   route: null,
        //   icon: 'cart',
        //   route_prefix: 'purchases',
        //   label: t('Purchases'),
        //   permissions: ['read-purchases', 'create-purchases', 'update-purchases'],
        //   sub_menu: [
        //     {
        //       name: 'purchases.list',
        //       route: 'purchases.index',
        //       icon: 'list',
        //       target: 'purchases',
        //       permissions: ['read-purchases'],
        //       label: t('List All {x}', { x: t('Purchases') }),
        //     },
        //     {
        //       name: 'purchases.create',
        //       route: 'purchases.create',
        //       icon: 'add',
        //       target: 'purchases',
        //       permissions: ['create-purchases'],
        //       label: t('Add New {x}', { x: t('Purchase') }),
        //     },
        //     {
        //       name: 'products.edit',
        //       route: 'products.edit',
        //       icon: 'add',
        //       hidden: true,
        //       target: 'products',
        //       permissions: ['update-products'],
        //       label: t('Edit {x}', { x: t('Purchase') }),
        //     },
        //     // { name: 'separator' },
        //     // {
        //     //   name: 'expenses.index',
        //     //   route: 'expenses.index',
        //     //   icon: 'adjust-v',
        //     //   target: 'products',
        //     //   permissions: ['read-expenses', 'update-expenses'],
        //     //   label: t('Expenses'),
        //     // },
        //   ],
        // },
        {
          name: "products",
          route: null,
          icon: "barcode",
          route_prefix: "products",
          label: t("Products"),
          permissions: [
            "read-products",
            "create-products",
            "update-products",
            "import-products",
            "read-adjustments",
            "read-transfers",
            "read-stock-counts",
            "read-brands",
            "read-categories",
            "read-units",
            "read-labels",
            "read-promotions"
          ],
          sub_menu: [
            {
              name: "products.list",
              route: "products.index",
              icon: "barcode",
              target: "products",
              permissions: ["read-products"],
              label: t("List All {x}", { x: t("Products") })
            },
            {
              name: "products.create",
              route: "products.create",
              icon: "barcode-o",
              target: "products",
              permissions: ["create-products"],
              label: t("Add New {x}", { x: t("Product") })
            },
            {
              name: "products.edit",
              route: "products.edit",
              icon: "add",
              hidden: true,
              target: "products",
              permissions: ["update-products"],
              label: t("Edit {x}", { x: t("Product") })
            },
            {
              name: "products.import",
              route: "products.import",
              icon: "import",
              target: "products",
              permissions: ["import-products"],
              label: t("Import {x}", { x: t("Products") })
            },
            { name: "separator" },
            {
              name: "adjustments.index",
              route: "adjustments.index",
              icon: "adjust",
              target: "products",
              permissions: ["read-adjustments"],
              label: t("Adjustments")
            },
            {
              name: "transfers.index",
              route: "transfers.index",
              icon: "transfer",
              target: "products",
              permissions: ["read-transfers"],
              label: t("Transfers")
            },
            {
              name: "stock_counts.index",
              route: "stock_counts.index",
              icon: "check-badge",
              target: "products",
              permissions: ["read-stock-counts"],
              label: t("Stock Counts")
            },
            {
              name: "brands.index",
              route: "brands.index",
              icon: "star",
              target: "products",
              permissions: ["read-brands"],
              label: t("Brands")
            },
            {
              name: "categories.index",
              route: "categories.index",
              icon: "folder",
              target: "products",
              permissions: ["read-categories"],
              label: t("Categories")
            },
            {
              name: "categories.import",
              route: "categories.import",
              icon: "folder",
              hidden: true,
              target: "products",
              permissions: ["import-categories"],
              label: t("Import {x}", { x: t("Categories") })
            },
            {
              name: "units.index",
              route: "units.index",
              icon: "funnel",
              target: "products",
              permissions: ["read-units"],
              label: t("Units")
            },
            {
              name: "labels.index",
              route: "labels.index",
              icon: "print",
              target: "products",
              permissions: ["read-labels"],
              label: t("Labels")
            },
            {
              name: "promotions.index",
              route: "promotions.index",
              icon: "sparkles",
              target: "products",
              permissions: ["read-promotions"],
              label: t("Promotions")
            }
          ]
        },
        {
          name: "people",
          route: null,
          route_prefix: "people",
          icon: "people",
          label: t("People"),
          permissions: [
            "read-customers",
            "create-customers",
            "read-suppliers",
            "create-suppliers",
            "read-users",
            "create-users",
            "read-roles",
            "create-roles",
            "read-price-groups",
            "create-price-groups",
            "read-customer-groups",
            "create-customer-groups"
          ],
          sub_menu: [
            {
              name: "customers.index",
              route: "customers.index",
              icon: "group",
              target: "people",
              permissions: ["read-customers"],
              label: t("Customers")
            },
            {
              name: "suppliers.index",
              route: "suppliers.index",
              icon: "suppliers",
              target: "people",
              permissions: ["read-suppliers"],
              label: t("Suppliers")
            },
            { name: "separator" },
            {
              name: "price_groups.index",
              route: "price_groups.index",
              icon: "people",
              target: "people",
              permissions: ["read-price-groups"],
              label: t("Price Groups")
            },
            {
              name: "customer_groups.index",
              route: "customer_groups.index",
              icon: "people",
              target: "people",
              permissions: ["read-customer-groups"],
              label: t("Customer Groups")
            },
            { name: "separator" },
            {
              name: "users.index",
              route: "users.index",
              icon: "users",
              target: "people",
              permissions: ["read-users"],
              label: t("Users")
            },
            {
              name: "roles.index",
              route: "roles.index",
              icon: "adjust-h",
              target: "people",
              permissions: ["read-roles"],
              label: t("Roles")
            }
          ]
        },
        {
          name: "settings",
          route: null,
          route_prefix: "settings",
          icon: "cog",
          label: t("Settings"),
          permissions: ["settings", "read-accounts", "read-stores", "read-taxes", "read-custom-fields"],
          sub_menu: [
            {
              name: "settings.index",
              route: "settings.index",
              icon: "settings",
              target: "settings",
              permissions: ["settings"],
              label: t("{x} Settings", { x: t("General") })
            },
            {
              name: "settings.mail",
              route: "settings.mail",
              icon: "envelope",
              target: "settings",
              permissions: ["settings"],
              label: t("{x} Settings", { x: t("Mail") })
            },
            {
              name: "settings.payment",
              route: "settings.payment",
              icon: "dollar-o",
              target: "settings",
              permissions: ["settings"],
              label: t("{x} Settings", { x: t("Payment") })
            },
            {
              name: "settings.barcode",
              route: "settings.barcode",
              icon: "scale",
              target: "settings",
              permissions: ["settings"],
              label: t("{x} Settings", { x: t("Scale Barcode") })
            },
            { name: "separator" },
            {
              name: "accounts.index",
              route: "accounts.index",
              icon: "book",
              target: "settings",
              permissions: ["read-accounts"],
              label: t("Accounts")
            },
            {
              name: "stores.index",
              route: "stores.index",
              icon: "store",
              target: "settings",
              permissions: ["read-stores"],
              label: t("Stores")
            },
            {
              name: "taxes.index",
              route: "taxes.index",
              icon: "receipt",
              target: "settings",
              permissions: ["read-taxes"],
              label: t("Taxes")
            },
            {
              name: "custom_fields.index",
              route: "custom_fields.index",
              icon: "textbox",
              target: "settings",
              permissions: ["read-custom-fields"],
              label: t("Custom Fields")
            }
          ]
        },
        {
          name: "reports",
          route: null,
          route_prefix: "reports",
          icon: "bar-chart",
          label: t("Reports"),
          permissions: [
            "sales-report",
            "purchases-report",
            "payments-report",
            "expenses-report",
            "products-report",
            "categories-report",
            "adjustments-report",
            "transfers-report",
            "customers-report",
            "suppliers-report",
            "staff-report",
            "return-order-report"
          ],
          sub_menu: [
            {
              name: "daily_sales.report",
              route: "daily_sales.report",
              icon: "calendar-dots",
              target: "reports",
              permissions: ["sales-report"],
              label: t("{x} Report", { x: t("Daily Sales") })
            },
            {
              name: "monthly_sales.report",
              route: "monthly_sales.report",
              icon: "calendar",
              target: "reports",
              permissions: ["sales-report"],
              label: t("{x} Report", { x: t("Monthly Sales") })
            },
            {
              name: "sales.report",
              route: "sales.report",
              icon: "bag",
              target: "reports",
              permissions: ["sales-report"],
              label: t("{x} Report", { x: t("Sales") })
            },
            {
              name: "registers.report",
              route: "registers.report",
              icon: "register",
              target: "reports",
              permissions: ["registers-report"],
              label: t("{x} Report", { x: t("Registers") })
            },
            {
              name: "purchases.report",
              route: "purchases.report",
              icon: "cart",
              target: "reports",
              permissions: ["purchases-report"],
              label: t("{x} Report", { x: t("Purchases") })
            },
            {
              name: "payments.report",
              route: "payments.report",
              icon: "dollar",
              target: "reports",
              permissions: ["payments-report"],
              label: t("{x} Report", { x: t("Payments") })
            },
            {
              name: "expenses.report",
              route: "expenses.report",
              icon: "money",
              target: "reports",
              permissions: ["expenses-report"],
              label: t("{x} Report", { x: t("Expenses") })
            },
            {
              name: "products.report",
              route: "products.report",
              icon: "barcode",
              target: "reports",
              permissions: ["products-report"],
              label: t("{x} Report", { x: t("Products") })
            },
            {
              name: "brands.report",
              route: "brands.report",
              icon: "star",
              target: "reports",
              permissions: ["brands-report"],
              label: t("{x} Report", { x: t("Brands") })
            },
            {
              name: "categories.report",
              route: "categories.report",
              icon: "folder",
              target: "reports",
              permissions: ["categories-report"],
              label: t("{x} Report", { x: t("Categories") })
            },
            {
              name: "adjustments.report",
              route: "adjustments.report",
              icon: "adjust",
              target: "reports",
              permissions: ["adjustments-report"],
              label: t("{x} Report", { x: t("Adjustments") })
            },
            {
              name: "transfers.report",
              route: "transfers.report",
              icon: "transfer",
              target: "reports",
              permissions: ["transfers-report"],
              label: t("{x} Report", { x: t("Transfers") })
            },
            {
              name: "return_orders.report",
              route: "return_orders.report",
              icon: "return",
              target: "reports",
              permissions: ["return-orders-report"],
              label: t("{x} Report", { x: t("Return Order") })
            },
            {
              name: "customers.report",
              route: "customers.report",
              icon: "group",
              target: "reports",
              permissions: ["customers-report"],
              label: t("{x} Report", { x: t("Customers") })
            },
            {
              name: "suppliers.report",
              route: "suppliers.report",
              icon: "suppliers",
              target: "reports",
              permissions: ["suppliers-report"],
              label: t("{x} Report", { x: t("Suppliers") })
            },
            {
              name: "staff.report",
              route: "staff.report",
              icon: "users",
              target: "reports",
              permissions: ["staff-report"],
              label: t("{x} Report", { x: t("Staff") })
            }
          ]
        }
      ]
    },
    {
      name: "support",
      heading: "Support",
      menus: [
        {
          link: "https://tecdiary.net/support/stock-manager-advance-with-point-of-sale-module",
          name: "support",
          route: "support",
          icon: "support",
          hidden: false,
          sub_menu: false,
          permissions: ["all"],
          label: t("Support")
        },
        {
          link: "https://tecdiary.net/changelogs/stock-manager-advance-with-all-modules",
          name: "changelog",
          route: "changelog",
          icon: "code",
          hidden: false,
          sub_menu: false,
          permissions: ["all"],
          label: t("Chanelog")
        }
      ]
    }
  ];
};
const account = "account";
const Account = "Account";
const Accounts = "Accounts";
const Actions = "Actions";
const Active = "Active";
const Activities = "Activities";
const add = "add";
const Addition = "Addition";
const Address = "Address";
const ADJUSTMENT = "ADJUSTMENT";
const Adjustment = "Adjustment";
const adjustment = "adjustment";
const Adjustments = "Adjustments";
const Adv = "Adv";
const Advance = "Advance";
const Amount = "Amount";
const and = "and";
const Application = "Application";
const Apply = "Apply";
const attachment = "attachment";
const Attachments = "Attachments";
const Balance = "Balance";
const barcode = "barcode";
const Batch = "Batch";
const Bill = "Bill";
const Bookings = "Bookings";
const brand = "brand";
const Brand = "Brand";
const Brands = "Brands";
const BXGY = "BXGY";
const By = "By";
const Calendar = "Calendar";
const Cancel = "Cancel";
const Cash = "Cash";
const Categories = "Categories";
const category = "category";
const Category = "Category";
const Chanelog = "Chanelog";
const Checkbox = "Checkbox";
const City = "City";
const Close = "Close";
const Code = "Code";
const Color = "Color";
const color = "color";
const Combo = "Combo";
const Comment = "Comment";
const Company = "Company";
const Complete = "Complete";
const complete = "complete";
const Compound = "Compound";
const Confirm = "Confirm";
const Contact = "Contact";
const Cost = "Cost";
const Country = "Country";
const Create = "Create";
const created = "created";
const Credit = "Credit";
const Custom = "Custom";
const Customer = "Customer";
const Customers = "Customers";
const Customize = "Customize";
const Dark = "Dark";
const Dashboard = "Dashboard";
const Data = "Data";
const Debit = "Debit";
const Delete = "Delete";
const deleted = "deleted";
const delete_text = "delete_text";
const Deliveries = "Deliveries";
const Delivery = "Delivery";
const delivery = "delivery";
const Description = "Description";
const Design = "Design";
const Details = "Details";
const Difference = "Difference";
const Digital = "Digital";
const Dimensions = "Dimensions";
const Disable = "Disable";
const Discount = "Discount";
const Divide = "Divide";
const Download = "Download";
const Due = "Due";
const edit = "edit";
const Email = "Email";
const Enable = "Enable";
const Event = "Event";
const Exclusive = "Exclusive";
const Expanse = "Expanse";
const Expected = "Expected";
const expense = "expense";
const Expense = "Expense";
const Expenses = "Expenses";
const Expiry = "Expiry";
const Feature = "Feature";
const Featured = "Featured";
const Fees = "Fees";
const File = "File";
const Finalize = "Finalize";
const Fixed = "Fixed";
const For = "For";
const Form = "Form";
const Formula = "Formula";
const Fraction = "Fraction";
const From = "From";
const Full = "Full";
const General = "General";
const Get = "Get";
const GiftCard = "GiftCard";
const Guide = "Guide";
const Hide = "Hide";
const Hold = "Hold";
const Home = "Home";
const Icon = "Icon";
const Id = "Id";
const Impersonated = "Impersonated";
const Import = "Import";
const Included = "Included";
const Inclusive = "Inclusive";
const Initiate = "Initiate";
const item = "item";
const Item = "Item";
const items = "items";
const Items = "Items";
const Keywords = "Keywords";
const Labels = "Labels";
const Language = "Language";
const Light = "Light";
const Load = "Load";
const Logo = "Logo";
const Mail = "Mail";
const Main = "Main";
const Method = "Method";
const Minus = "Minus";
const Models = "Models";
const Modern = "Modern";
const more = "more";
const Multiple = "Multiple";
const Name = "Name";
const New = "New";
const NewLine = "NewLine";
const Next = "Next";
const Nofollow = "Nofollow";
const Noindex = "Noindex";
const Notifications = "Notifications";
const Offline = "Offline";
const Open = "Open";
const Operator = "Operator";
const Option = "Option";
const optional = "optional";
const Options = "Options";
const Order = "Order";
const Orders = "Orders";
const Others = "Others";
const Overview = "Overview";
const Page = "Page";
const Paid = "Paid";
const Partial = "Partial";
const Password = "Password";
const Payable = "Payable";
const payment = "payment";
const Payment = "Payment";
const Payments = "Payments";
const People = "People";
const Percentage = "Percentage";
const Permissions = "Permissions";
const Phone = "Phone";
const Photo = "Photo";
const Photos = "Photos";
const Plus = "Plus";
const points = "points";
const Points = "Points";
const POS = "POS";
const Previous = "Previous";
const Price = "Price";
const Print = "Print";
const product = "product";
const Product = "Product";
const Products = "Products";
const Profile = "Profile";
const Profit = "Profit";
const Promotion = "Promotion";
const Promotions = "Promotions";
const purchase = "purchase";
const Purchase = "Purchase";
const Purchased = "Purchased";
const Purchases = "Purchases";
const Qty = "Qty";
const quantity = "quantity";
const Quantity = "Quantity";
const Quotation = "Quotation";
const quotation = "quotation";
const Quotations = "Quotations";
const Rack = "Rack";
const Radio = "Radio";
const Rate = "Rate";
const Receipt = "Receipt";
const Received = "Received";
const Recipe = "Recipe";
const Record = "Record";
const record = "record";
const Recoverable = "Recoverable";
const Ref = "Ref";
const Reference = "Reference";
const Regards = "Regards";
const Register = "Register";
const Registers = "Registers";
const Remove = "Remove";
const Reports = "Reports";
const Required = "Required";
const Reset = "Reset";
const Resetting = "Resetting";
const return_order = "return_order";
const Role = "Role";
const Roles = "Roles";
const Rounding = "Rounding";
const sale = "sale";
const Sale = "Sale";
const Sales = "Sales";
const Save = "Save";
const saved = "saved";
const Search = "Search";
const Select = "Select";
const Sent = "Sent";
const Serial = "Serial";
const Service = "Service";
const Settings = "Settings";
const Shop = "Shop";
const Sidebar = "Sidebar";
const Simple = "Simple";
const Size = "Size";
const size = "size";
const SKU = "SKU";
const Slug = "Slug";
const Sold = "Sold";
const Staff = "Staff";
const Standard = "Standard";
const start = "start";
const state = "state";
const State = "State";
const Stock = "Stock";
const Store = "Store";
const store = "store";
const Stores = "Stores";
const Street = "Street";
const Sub = "Sub";
const Subcategory = "Subcategory";
const Subtotal = "Subtotal";
const Subtraction = "Subtraction";
const Supplier = "Supplier";
const Suppliers = "Suppliers";
const Support = "Support";
const Surcharge = "Surcharge";
const SXGD = "SXGD";
const Symbology = "Symbology";
const Syncing = "Syncing";
const System = "System";
const Tax = "Tax";
const tax = "tax";
const Taxes = "Taxes";
const Template = "Template";
const Text = "Text";
const Textarea = "Textarea";
const The = "The";
const Till = "Till";
const Time = "Time";
const Timezone = "Timezone";
const Title = "Title";
const To = "To";
const Total = "Total";
const transfer = "transfer";
const Transfer = "Transfer";
const Transfers = "Transfers";
const Trashed = "Trashed";
const Type = "Type";
const Unit = "Unit";
const unit = "unit";
const Units = "Units";
const Unknown = "Unknown";
const Update = "Update";
const updated = "updated";
const Url = "URL";
const User = "User";
const Username = "Username";
const Users = "Users";
const Variant = "Variant";
const Variants = "Variants";
const Variation = "Variation";
const variation = "variation";
const variations = "variations";
const Variations = "Variations";
const View = "View";
const Weight = "Weight";
const en = {
  "10 per sheet (4in x 2in)": "10 per sheet (4in x 2in)",
  "12 per sheet (A4) (2.5in x 2.834in)": "12 per sheet (A4) (2.5in x 2.834in)",
  "18 per sheet (A4) (2.5in x 1.835in)": "18 per sheet (A4) (2.5in x 1.835in)",
  "20 per sheet (4in x 1in)": "20 per sheet (4in x 1in)",
  "24 per sheet (A4) (2.48in x 1.334in)": "24 per sheet (A4) (2.48in x 1.334in)",
  "30 per sheet (2.625in x 1in)": "30 per sheet (2.625in x 1in)",
  "40 per sheet (A4) (1.799in x 1.003in)": "40 per sheet (A4) (1.799in x 1.003in)",
  "403: Forbidden": "403: Forbidden",
  "404: Page Not Found": "404: Page Not Found",
  "500: Server Error": "500: Server Error",
  "503: Service Unavailable": "503: Service Unavailable",
  "Accept Invitation": "Accept Invitation",
  account,
  Account,
  "Account is not active!": "Account is not active!",
  Accounts,
  Actions,
  Active,
  Activities,
  "Activity Logs": "Activity Logs",
  add,
  "Add Account": "Add Account",
  "Add additional security to your account using two factor authentication.": "Add additional security to your account using two factor authentication.",
  "Add Address": "Add Address",
  "Add another Payment": "Add another Payment",
  "add balance to": "add balance to",
  "Add Brand": "Add Brand",
  "Add Category": "Add Category",
  Addition,
  "Addition/Extra/Found": "Addition/Extra/Found",
  "Add More Payment": "Add More Payment",
  "Add New": "Add New",
  "Add new sale": "Add new sale",
  "Add New {x}": "Add New {x}",
  "Add page break after each label": "Add page break after each label",
  Address,
  "Address Line 1": "Address Line 1",
  "Address Line 2": "Address Line 2",
  "Address name with email already exists": "Address name with email already exists",
  "Address name with phone already exists": "Address name with phone already exists",
  "Add to Order": "Add to Order",
  "Add {x}": "Add {x}",
  ADJUSTMENT,
  Adjustment,
  adjustment,
  "Adjustment Items": "Adjustment Items",
  "Adjustment No. {x}": "Adjustment No. {x}",
  Adjustments,
  "Adjust Store Stock?": "Adjust Store Stock?",
  Adv,
  Advance,
  "Advance Payment": "Advance Payment",
  "after all payments": "after all payments",
  "Alert (Low Stock) Quantity": "Alert (Low Stock) Quantity",
  "All-time": "All-time",
  "All of your data will be permanently changed.": "All of your data will be permanently changed.",
  "Allow overselling": "Allow overselling",
  "Allow to change price": "Allow to change price",
  "Allow to change price while selling": "Allow to change price while selling",
  "All Variations": "All Variations",
  "Already registered?": "Already registered?",
  Amount,
  "Amount Paid": "Amount Paid",
  "Amount to spend": "Amount to spend",
  "Amount Value": "Amount Value",
  and,
  "A new verification link has been sent to the email address you provided in your profile settings.": "A new verification link has been sent to the email address you provided in your profile settings.",
  "A new verification link has been sent to your email address.": "A new verification link has been sent to your email address.",
  "Any Notes": "Any Notes",
  "Any sale details": "Any sale details",
  "API Token": "API Token",
  "API Token Permissions": "API Token Permissions",
  "API Tokens": "API Tokens",
  "API tokens allow third-party services to authenticate with our application on your behalf.": "API tokens allow third-party services to authenticate with our application on your behalf.",
  Application,
  "Application Settings": "Application Settings",
  Apply,
  "Apply as discount": "Apply as discount",
  "Apply to": "Apply to",
  "Apply to same state customers": "Apply to same state customers",
  "Apply transaction fees": "Apply transaction fees",
  "Are you sure you want to delete the {record}?": "Are you sure you want to delete the {record}?",
  "Are you sure you want to delete your account? Once your account is deleted, all of its resources and data will be permanently deleted. Please enter your password to confirm you would like to permanently delete your account.": "Are you sure you want to delete your account? Once your account is deleted, all of its resources and data will be permanently deleted. Please enter your password to confirm you would like to permanently delete your account.",
  "Are you sure you want to perform stock adjustments?": "Are you sure you want to perform stock adjustments?",
  "Are you sure you would like to delete this API token?": "Are you sure you would like to delete this API token?",
  "At least one brand or category should be selected for partial stock count.": "At least one brand or category should be selected for partial stock count.",
  attachment,
  "Attachment deleted!": "Attachment deleted!",
  Attachments,
  "Authorize.net Login": "Authorize.net Login",
  "Authorize.net Transaction Key": "Authorize.net Transaction Key",
  "Auto open first order on POS": "Auto open first order on POS",
  "Auto print or open browser print dialog": "Auto print or open browser print dialog",
  "Awarded points for {sale}": "Awarded points for {sale}",
  "Award Point": "Award Point",
  "AWS SES Key": "AWS SES Key",
  "AWS SES Region": "AWS SES Region",
  "AWS SES Secret": "AWS SES Secret",
  "Back to Homepage": "Back to Homepage",
  "Back to Login": "Back to Login",
  Balance,
  "Balance Amount": "Balance Amount",
  barcode,
  "Barcode Contains": "Barcode Contains",
  "Barcode Height": "Barcode Height",
  "Barcode Length": "Barcode Length",
  "Base Unit": "Base Unit",
  Batch,
  "Batch No.": "Batch No.",
  "Before continuing, could you verify your email address by clicking on the link we just emailed to you? If you didn't receive the email, we will gladly send you another.": "Before continuing, could you verify your email address by clicking on the link we just emailed to you? If you didn't receive the email, we will gladly send you another.",
  Bill,
  Bookings,
  "Both (credit & debit)": "Both (credit & debit)",
  brand,
  Brand,
  Brands,
  "Browser Sessions": "Browser Sessions",
  "Bulk Action": "Bulk Action",
  "Bulk actions": "Bulk actions",
  "Buy X get Y (BXGY)": "Buy X get Y (BXGY)",
  BXGY,
  By,
  Calendar,
  "Can be impersonated": "Can be impersonated",
  Cancel,
  "Can remove order items": "Can remove order items",
  "Card Terminal": "Card Terminal",
  Cash,
  "Cash Amount": "Cash Amount",
  "Cash in Hand": "Cash in Hand",
  "Cash in hand": "Cash in hand",
  "Cash in register": "Cash in register",
  "Cash Register": "Cash Register",
  "Cash Submitted": "Cash Submitted",
  Categories,
  category,
  Category,
  "CC Amount": "CC Amount",
  Chanelog,
  "Change file": "Change file",
  "Check/Uncheck All": "Check/Uncheck All",
  Checkbox,
  "Check for Promotions": "Check for Promotions",
  City,
  "Click here to re-send the verification email.": "Click here to re-send the verification email.",
  Close,
  "Closed at": "Closed at",
  "Closed by": "Closed by",
  "Close Register": "Close Register",
  "Close sidebar": "Close sidebar",
  Code,
  Color,
  color,
  Combo,
  "Combo Products": "Combo Products",
  Comment,
  Company,
  "Company already exists": "Company already exists",
  Complete,
  complete,
  "Completed at": "Completed at",
  "Completed by": "Completed by",
  "Complete Stock Count": "Complete Stock Count",
  Compound,
  "Compound: this tax should be applied after other taxes": "Compound: this tax should be applied after other taxes",
  Confirm,
  "Confirm Password": "Confirm Password",
  Contact,
  "Continuous Feed": "Continuous Feed",
  "Converted at": "Converted at",
  Cost,
  Country,
  Create,
  "Create Account": "Create Account",
  "Create All": "Create All",
  "Create API Token": "Create API Token",
  created,
  "Created.": "Created.",
  "Created at": "Created at",
  "Created  by": "Created  by",
  "Created by": "Created by",
  "Create {x}": "Create {x}",
  Credit,
  "Credit Card Amount": "Credit Card Amount",
  "Credit Card Gateway": "Credit Card Gateway",
  "Credit Card Value": "Credit Card Value",
  "Current Password": "Current Password",
  Custom,
  Customer,
  "Customer group": "Customer group",
  "Customer Group": "Customer Group",
  "Customer Group Price Group": "Customer Group Price Group",
  "Customer Groups": "Customer Groups",
  "Customer name with email already exists": "Customer name with email already exists",
  "Customer name with phone already exists": "Customer name with phone already exists",
  Customers,
  "Customer Statement": "Customer Statement",
  "Custom field": "Custom field",
  "Custom Field": "Custom Field",
  "Custom Fieldes": "Custom Fieldes",
  "Custom Fields": "Custom Fields",
  Customize,
  "Customize Report": "Customize Report",
  "Daily Sales": "Daily Sales",
  Dark,
  "Dark Mode Icon": "Dark Mode Icon",
  "Dark Mode Logo": "Dark Mode Logo",
  "Dark side bar": "Dark side bar",
  "Dark top bar": "Dark top bar",
  Dashboard,
  Data,
  "Date": "Date",
  "Date & Number Locale": "Date & Number Locale",
  "Date Format": "Date Format",
  Debit,
  "Default Account": "Default Account",
  "Default Category": "Default Category",
  "Default Currency": "Default Currency",
  "Default Customer": "Default Customer",
  "Default Product Taxes": "Default Product Taxes",
  "Default Store": "Default Store",
  Delete,
  "Delete Account": "Delete Account",
  "Delete All": "Delete All",
  "Delete API Token": "Delete API Token",
  deleted,
  "Delete Order": "Delete Order",
  delete_text,
  "Delete {x}": "Delete {x}",
  "Delivered at": "Delivered at",
  "Delivered by": "Delivered by",
  Deliveries,
  Delivery,
  delivery,
  "Delivery Order No. {x}": "Delivery Order No. {x}",
  Description,
  "Description/Summary": "Description/Summary",
  Design,
  Details,
  Difference,
  Digital,
  Dimensions,
  "Dimension Unit": "Dimension Unit",
  Disable,
  Discount,
  Divide,
  "Done.": "Done.",
  "Do not track stock for this product": "Do not track stock for this product",
  Download,
  "Download excel file to complete": "Download excel file to complete",
  "Download final excel file": "Download final excel file",
  Due,
  "Due Amount": "Due Amount",
  "Due Date": "Due Date",
  "Due Limit": "Due Limit",
  "Each sale amounting to": "Each sale amounting to",
  edit,
  "Edit Account": "Edit Account",
  "Edit all": "Edit all",
  "Edit all records": "Edit all records",
  "Edit Brand": "Edit Brand",
  "Edit Category": "Edit Category",
  "Editing payment": "Editing payment",
  "Edit Profile": "Edit Profile",
  "Edit {x}": "Edit {x}",
  Email,
  "Emailed at": "Emailed at",
  "Email Password Reset Link": "Email Password Reset Link",
  "Email Verification": "Email Verification",
  "Email {x}": "Email {x}",
  Enable,
  "Enable impersonation": "Enable impersonation",
  "Enable onscreen keyboard": "Enable onscreen keyboard",
  "Enable PayPal Payments": "Enable PayPal Payments",
  "Enable restaurant feature for POS i.e, halls, tables & recipes": "Enable restaurant feature for POS i.e, halls, tables & recipes",
  "Enable Stripe Terminal": "Enable Stripe Terminal",
  "End Date": "End Date",
  "Ensure your account is using a long, random password to stay secure.": "Ensure your account is using a long, random password to stay secure.",
  "Estimated Profit": "Estimated Profit",
  Event,
  "Excel File": "Excel File",
  "Excel file should have name & parent_category columns.": "Excel file should have name & parent_category columns.",
  "Excel file should have name, phone, email, company, due_limit, lot_no, street, address_line_1, address_line_2, city, postal_code, state and country columns.": "Excel file should have name, phone, email, company, due_limit, lot_no, street, address_line_1, address_line_2, city, postal_code, state and country columns.",
  "Excel file should have name, phone, email, company, due_limit, price_group, customer_group, lot_no, street, address_line_1, address_line_2, city, postal_code, state and country columns.": "Excel file should have name, phone, email, company, due_limit, price_group, customer_group, lot_no, street, address_line_1, address_line_2, city, postal_code, state and country columns.",
  "Excel file should have name column.": "Excel file should have name column.",
  Exclusive,
  Expanse,
  Expected,
  expense,
  Expense,
  "Expense No. {x}": "Expense No. {x}",
  Expenses,
  Expiry,
  "Expiry Date": "Expiry Date",
  "Export {x}": "Export {x}",
  Feature,
  Featured,
  Fees,
  File,
  "file selected": "file selected",
  "files selected": "files selected",
  "Final File": "Final File",
  Finalize,
  "Finalize Sale": "Finalize Sale",
  "Finish enabling two factor authentication.": "Finish enabling two factor authentication.",
  Fixed,
  "Fixed Fee Amount": "Fixed Fee Amount",
  "Fixed Fees": "Fixed Fees",
  "Flag Characters Length": "Flag Characters Length",
  For,
  "For Customers": "For Customers",
  "Forgot Password": "Forgot Password",
  "Forgot your password?": "Forgot your password?",
  "Forgot your password? No problem. Just let us know your email address and we will email you a password reset link that will allow you to choose a new one.": "Forgot your password? No problem. Just let us know your email address and we will email you a password reset link that will allow you to choose a new one.",
  Form,
  "Form Page": "Form Page",
  Formula,
  "For Staff": "For Staff",
  "For your security, please confirm your password to continue.": "For your security, please confirm your password to continue.",
  Fraction,
  From,
  "From Store": "From Store",
  Full,
  "Full Stock Count": "Full Stock Count",
  General,
  "General Settings": "General Settings",
  "General settings for the application use and views": "General settings for the application use and views",
  "Generate Variations": "Generate Variations",
  Get,
  "Gift Card": "Gift Card",
  GiftCard,
  "gift card": "gift card",
  "Gift card already exists": "Gift card already exists",
  "Gift Card Amount": "Gift Card Amount",
  "Gift card balance is not enough.": "Gift card balance is not enough.",
  "Gift card does not belong to this customer.": "Gift card does not belong to this customer.",
  "Gift card does not have enough balance.": "Gift card does not have enough balance.",
  "Gift Card Logs": "Gift Card Logs",
  "gift card number": "gift card number",
  "Gift Card Number": "Gift Card Number",
  "Gift Cards": "Gift Cards",
  "Gift card used to make payment": "Gift card used to make payment",
  "Go to {x}": "Go to {x}",
  "Grand Total": "Grand Total",
  Guide,
  "Has expiry date": "Has expiry date",
  Hide,
  "Hide ID": "Hide ID",
  "Hide in POS": "Hide in POS",
  "Hide in Shop": "Hide in Shop",
  Hold,
  Home,
  "HSN Number": "HSN Number",
  "I agree to the": "I agree to the",
  Icon,
  Id,
  "If necessary, you may log out of all of your other browser sessions across all of your devices. Some of your recent sessions are listed below; however, this list may not be exhaustive. If you feel your account has been compromised, you should also update your password.": "If necessary, you may log out of all of your other browser sessions across all of your devices. Some of your recent sessions are listed below; however, this list may not be exhaustive. If you feel your account has been compromised, you should also update your password.",
  "If you already have an account, you may accept this invitation by clicking the button below:": "If you already have an account, you may accept this invitation by clicking the button below:",
  "If you did not expect to receive an invitation to this team, you may discard this email.": "If you did not expect to receive an invitation to this team, you may discard this email.",
  "If you do not have an account, you may create one by clicking the button below. After creating an account, you may click the invitation acceptance button in this email to accept the team invitation:": "If you do not have an account, you may create one by clicking the button below. After creating an account, you may click the invitation acceptance button in this email to accept the team invitation:",
  "I have collected payment & saved receipt": "I have collected payment & saved receipt",
  Impersonated,
  Import,
  "Import/Export": "Import/Export",
  "Import {x}": "Import {x}",
  "In Browser (Javascript)": "In Browser (Javascript)",
  Included,
  Inclusive,
  "Inclusive Tax Calculation Formula": "Inclusive Tax Calculation Formula",
  "Initial stock on adjustment": "Initial stock on adjustment",
  Initiate,
  "Initiate Adjustments": "Initiate Adjustments",
  "In Store": "In Store",
  "Invalid pin code!": "Invalid pin code!",
  "Inventory Accounting Method": "Inventory Accounting Method",
  item,
  Item,
  "Item Code Characters Length": "Item Code Characters Length",
  "Item Code Start Position": "Item Code Start Position",
  items,
  Items,
  Keywords,
  "Label Height": "Label Height",
  Labels,
  "Label Width": "Label Width",
  Language,
  "Language has been changed.": "Language has been changed.",
  "Language is not available yet.": "Language is not available yet.",
  "Last 7 days": "Last 7 days",
  "Last 30 days": "Last 30 days",
  "Last 60 days": "Last 60 days",
  "Last active": "Last active",
  "Last used": "Last used",
  Light,
  "List All {x}": "List All {x}",
  "List Open Orders": "List Open Orders",
  "List Orders": "List Orders",
  "List Page": "List Page",
  "List POS Orders": "List POS Orders",
  "List Sales": "List Sales",
  "List {x}": "List {x}",
  Load,
  "Log in": "Log in",
  Logo,
  "Log Out": "Log Out",
  "Log Out Other Browser Sessions": "Log Out Other Browser Sessions",
  "Lot No.": "Lot No.",
  "Low Stock": "Low Stock",
  "Loyalty Points": "Loyalty Points",
  "L x  W x H": "L x  W x H",
  Mail,
  "Mail Driver": "Mail Driver",
  "MailerSend API Key": "MailerSend API Key",
  "Mail From Email Address": "Mail From Email Address",
  "Mail From Name": "Mail From Name",
  "Mailgun Domain": "Mailgun Domain",
  "Mailgun Endpoint": "Mailgun Endpoint",
  "Mailgun Secret": "Mailgun Secret",
  "Mail Settings": "Mail Settings",
  "Mail settings successfully saved.": "Mail settings successfully saved.",
  Main,
  "Manage Account": "Manage Account",
  "Manage API Tokens": "Manage API Tokens",
  "Mark as delivered": "Mark as delivered",
  "Max. Discount": "Max. Discount",
  "Max. Price": "Max. Price",
  "Maximum 1000 labels can be printed at a time!": "Maximum 1000 labels can be printed at a time!",
  "Maximum Discount": "Maximum Discount",
  "Maximum Price": "Maximum Price",
  Method,
  "Method Details": "Method Details",
  "Min. Price": "Min. Price",
  "Minimum Price": "Minimum Price",
  Minus,
  Models,
  Modern,
  "Monthly Sales": "Monthly Sales",
  more,
  Multiple,
  "N/A": "N/A",
  Name,
  New,
  NewLine,
  "New Password": "New Password",
  Next,
  "No data found, the record might not belong to the selected store.": "No data found, the record might not belong to the selected store.",
  Nofollow,
  "No Follow": "No Follow",
  Noindex,
  "No Index": "No Index",
  "No product found with code {code}": "No product found with code {code}",
  "No register is open!": "No register is open!",
  "No suggestions to list.": "No suggestions to list.",
  "No Suspended Orders": "No Suspended Orders",
  Notifications,
  "Not Trashed": "Not Trashed",
  "Number": "Number",
  "Official receipt will be issued after receiving payment.": "Official receipt will be issued after receiving payment.",
  Offline,
  "Once your account is deleted, all of its resources and data will be permanently deleted. Before deleting your account, please download any data or information that you wish to retain.": "Once your account is deleted, all of its resources and data will be permanently deleted. Before deleting your account, please download any data or information that you wish to retain.",
  "Only Trashed": "Only Trashed",
  "On Server Side (PHP)": "On Server Side (PHP)",
  Open,
  "Opened at": "Opened at",
  "Opened by": "Opened by",
  "Opened Orders": "Opened Orders",
  "Opening Balance": "Opening Balance",
  "Open menu": "Open menu",
  "Open New Order": "Open New Order",
  "Open Orders": "Open Orders",
  "Open Orders (on hold)": "Open Orders (on hold)",
  "Open POS Orders": "Open POS Orders",
  "Open Register": "Open Register",
  "Open Sidebar": "Open Sidebar",
  "Open user menu": "Open user menu",
  "Operation Value": "Operation Value",
  Operator,
  Option,
  optional,
  Options,
  "Option {x}": "Option {x}",
  Order,
  "Order Details": "Order Details",
  "Order Discount": "Order Discount",
  "Order No.": "Order No.",
  "Order No. {x}": "Order No. {x}",
  "Order Number": "Order Number",
  "Order Ref": "Order Ref",
  Orders,
  "Order To": "Order To",
  "or drag and drop": "or drag and drop",
  "Other Amount": "Other Amount",
  "Other Countries Percentage": "Other Countries Percentage",
  "Other Payment Amount": "Other Payment Amount",
  "Other Payments Value": "Other Payments Value",
  Others,
  "Other Settigns": "Other Settigns",
  "Overdue {x}": "Overdue {x}",
  Overview,
  "Packing List": "Packing List",
  Page,
  Paid,
  "Paid Amount": "Paid Amount",
  "Parent Category": "Parent Category",
  "parent_category is the name of the parent category.": "parent_category is the name of the parent category.",
  Partial,
  "Partial Stock Count": "Partial Stock Count",
  Password,
  Payable,
  "Payable Amount": "Payable Amount",
  payment,
  Payment,
  "Payment deleted!": "Payment deleted!",
  "Payment Gateways": "Payment Gateways",
  "Payment No. {x}": "Payment No. {x}",
  "Payment Note": "Payment Note",
  "Payment Receipt": "Payment Receipt",
  "Payment Received": "Payment Received",
  "Payment Request": "Payment Request",
  "Payment Requests": "Payment Requests",
  "Payment restored!": "Payment restored!",
  Payments,
  "Payment Settings": "Payment Settings",
  "Payment settings successfully saved.": "Payment settings successfully saved.",
  "Payments Sent": "Payments Sent",
  "Paymes Public Key": "Paymes Public Key",
  "Paymes Secret Key": "Paymes Secret Key",
  "PayPal Client Id": "PayPal Client Id",
  "PayPal Secret": "PayPal Secret",
  People,
  Percentage,
  "Percentage Fees": "Percentage Fees",
  "Perform bulk actions": "Perform bulk actions",
  "Perform Bulk Actions": "Perform Bulk Actions",
  "Permanently delete your account.": "Permanently delete your account.",
  Permissions,
  Phone,
  Photo,
  Photos,
  "Play sound on order item": "Play sound on order item",
  "Please add at least one item to form.": "Please add at least one item to form.",
  "Please add at least one item to the order.": "Please add at least one item to the order.",
  "Please add at least one product!": "Please add at least one product!",
  "Please add at least one product.": "Please add at least one product.",
  "Please add card details below.": "Please add card details below.",
  "Please add products the below to print label.": "Please add products the below to print label.",
  "Please click the order below to load it.": "Please click the order below to load it.",
  "Please configure the mail driver and settings.": "Please configure the mail driver and settings.",
  "Please configure the payment settings.": "Please configure the payment settings.",
  "Please configure the settings to parse scale barcodes.": "Please configure the settings to parse scale barcodes.",
  "Please confirm access to your account by entering one of your emergency recovery codes.": "Please confirm access to your account by entering one of your emergency recovery codes.",
  "Please confirm access to your account by entering the authentication code provided by your authenticator application.": "Please confirm access to your account by entering the authentication code provided by your authenticator application.",
  "Please confirm that you would like to delete the record?": "Please confirm that you would like to delete the record?",
  "Please copy your new API token. For your security, it won't be shown again.": "Please copy your new API token. For your security, it won't be shown again.",
  "Please edit the order item data below.": "Please edit the order item data below.",
  "Please edit to complete the stock count with checked excel file.": "Please edit to complete the stock count with checked excel file.",
  "Please enter your password to confirm you would like to log out of your other browser sessions across all of your devices.": "Please enter your password to confirm you would like to log out of your other browser sessions across all of your devices.",
  "Please fill the discount below to apply to form.": "Please fill the discount below to apply to form.",
  "Please fill the form below to add new record.": "Please fill the form below to add new record.",
  "Please fill the form below to {action} record.": "Please fill the form below to {action} record.",
  "Please fill the form below to {action} {record}.": "Please fill the form below to {action} {record}.",
  "Please fill the payment details to finalize.": "Please fill the payment details to finalize.",
  "Please open a register first!": "Please open a register first!",
  "Please prefer biller name and email": "Please prefer biller name and email",
  "Please provide pin code to remove item from order": "Please provide pin code to remove item from order",
  "Please review the data below": "Please review the data below",
  "Please review the day data below": "Please review the day data below",
  "Please review the details below.": "Please review the details below.",
  "Please review the year data below": "Please review the year data below",
  "Please select a store first!": "Please select a store first!",
  "Please select template!": "Please select template!",
  "Please select the category to load products": "Please select the category to load products",
  "Please select the desired filters below.": "Please select the desired filters below.",
  "Please select the variant to add item to order list.": "Please select the variant to add item to order list.",
  "Please set the settings to parse scale barcodes.": "Please set the settings to parse scale barcodes.",
  "Please type the cash in hand to open register.": "Please type the cash in hand to open register.",
  "Please type the reference to open form.": "Please type the reference to open form.",
  "Please type to search": "Please type to search",
  "Please update setting as you desire": "Please update setting as you desire",
  "Please update the details below": "Please update the details below",
  "Please upload the excel file to import records.": "Please upload the excel file to import records.",
  "Please view the app alerts below": "Please view the app alerts below",
  "Please view the details below": "Please view the details below",
  "Please view the payment by clicking the link below.": "Please view the payment by clicking the link below.",
  "Please view the purchase order by clicking the link below.": "Please view the purchase order by clicking the link below.",
  "Please view the quotation by clicking the link below.": "Please view the quotation by clicking the link below.",
  "Please view the register details below.": "Please view the register details below.",
  "Please view the return order by clicking the link below.": "Please view the return order by clicking the link below.",
  "Please view your sale by clicking the link below.": "Please view your sale by clicking the link below.",
  "Please view your transfer by clicking the link below.": "Please view your transfer by clicking the link below.",
  Plus,
  "Point of Sale": "Point of Sale",
  points,
  Points,
  POS,
  "POS Orders": "POS Orders",
  "POS Sale": "POS Sale",
  "POS Screen": "POS Screen",
  "POS Settings": "POS Settings",
  "Postal/ZIP Code": "Postal/ZIP Code",
  "Postmark Token": "Postmark Token",
  Previous,
  Price,
  "Price * Tax Rate / (100 + Tax Rate) = Tax Amount": "Price * Tax Rate / (100 + Tax Rate) = Tax Amount",
  "Price * Tax Rate / 100 = Tax Amount": "Price * Tax Rate / 100 = Tax Amount",
  "Price Characters Length": "Price Characters Length",
  "Price Divide by": "Price Divide by",
  "Price group": "Price group",
  "Price Group": "Price Group",
  "Price Groups": "Price Groups",
  "Price Start Position": "Price Start Position",
  Print,
  "Print Bill": "Print Bill",
  "Printed at": "Printed at",
  "Printed by": "Printed by",
  "Print Order": "Print Order",
  "Print Receipt": "Print Receipt",
  "Print using POS Print Server": "Print using POS Print Server",
  "Privacy Policy": "Privacy Policy",
  product,
  Product,
  "Product Code": "Product Code",
  "Product Details": "Product Details",
  "Product Labels": "Product Labels",
  "Product quantity sync for adjustment item.": "Product quantity sync for adjustment item.",
  Products,
  "Product to buy": "Product to buy",
  "Product to get": "Product to get",
  "Product Tracks": "Product Tracks",
  Profile,
  "Profile Information": "Profile Information",
  Profit,
  Promotion,
  Promotions,
  purchase,
  Purchase,
  "Purchase Cost": "Purchase Cost",
  Purchased,
  "Purchase Items": "Purchase Items",
  "Purchase No. {x}": "Purchase No. {x}",
  "Purchase Order": "Purchase Order",
  "Purchase Return Orders": "Purchase Return Orders",
  Purchases,
  "Purchases Amount": "Purchases Amount",
  "Purchase Unit": "Purchase Unit",
  Qty,
  "Qty:": "Qty:",
  quantity,
  Quantity,
  "Quantity/Weight": "Quantity/Weight",
  "Quantity Fraction": "Quantity Fraction",
  "Quantity to buy": "Quantity to buy",
  "Quantity to get": "Quantity to get",
  Quotation,
  quotation,
  "Quotation Items": "Quotation Items",
  "Quotation No. {x}": "Quotation No. {x}",
  Quotations,
  "Quote To": "Quote To",
  Rack,
  "Rack Location": "Rack Location",
  Radio,
  Rate,
  "reached due limit": "reached due limit",
  "Read all records": "Read all records",
  "Read All Records": "Read All Records",
  Receipt,
  "Receipt/Sale View": "Receipt/Sale View",
  "Receipt Footer": "Receipt Footer",
  "Receipt Header": "Receipt Header",
  Received,
  "Received Amount": "Received Amount",
  "Received by": "Received by",
  "Received from": "Received from",
  Recipe,
  Record,
  record,
  Recoverable,
  "Recovery Code": "Recovery Code",
  Ref,
  Reference,
  Regards,
  "Regenerate Recovery Codes": "Regenerate Recovery Codes",
  Register,
  "Register already opened!": "Register already opened!",
  "Register Details": "Register Details",
  Registers,
  "Registration Number": "Registration Number",
  "Remember me": "Remember me",
  Remove,
  "Removed from adjustment": "Removed from adjustment",
  "Remove Icon": "Remove Icon",
  "Remove Logo": "Remove Logo",
  "Remove Photo": "Remove Photo",
  "Remove {x}": "Remove {x}",
  Reports,
  "Require Country & State": "Require Country & State",
  Required,
  "Require this field": "Require this field",
  "Resend Key": "Resend Key",
  "Resend Verification Email": "Resend Verification Email",
  Reset,
  "Reset balance for deleting {payment}": "Reset balance for deleting {payment}",
  "Reset balance for Purchase #{id}": "Reset balance for Purchase #{id}",
  "Reset balance for restoring {payment}": "Reset balance for restoring {payment}",
  "Reset balance for Return Order #{id}": "Reset balance for Return Order #{id}",
  "Reset balance for {expense}": "Reset balance for {expense}",
  "Reset balance for {payment}": "Reset balance for {payment}",
  "Reset balance for {purchase}": "Reset balance for {purchase}",
  "Reset balance for {return_order}": "Reset balance for {return_order}",
  "Reset balance for {sale}": "Reset balance for {sale}",
  "Reset Password": "Reset Password",
  "Reset store stock for {stock_count}": "Reset store stock for {stock_count}",
  Resetting,
  "Return Amount": "Return Amount",
  "Returned From": "Returned From",
  "Returned To": "Returned To",
  "Return From": "Return From",
  "return order": "return order",
  "Return Order": "Return Order",
  "Return Order for Purchase": "Return Order for Purchase",
  "Return Order for Sale": "Return Order for Sale",
  "Return Order Items": "Return Order Items",
  "Return Order No. {x}": "Return Order No. {x}",
  "return orders": "return orders",
  "Return Orders": "Return Orders",
  "Return To": "Return To",
  return_order,
  Role,
  "Role can not be modified.": "Role can not be modified.",
  Roles,
  Rounding,
  "Row Per Page": "Row Per Page",
  "SAC Number": "SAC Number",
  sale,
  Sale,
  "Sale Items": "Sale Items",
  "Sale items are loaded, please choose only return ones.": "Sale items are loaded, please choose only return ones.",
  "Sale No.": "Sale No.",
  "Sale No. {x}": "Sale No. {x}",
  "Sale No/Ref": "Sale No/Ref",
  "Sale not found with No./ref {x}.": "Sale not found with No./ref {x}.",
  "Sale Reference": "Sale Reference",
  "Sale Return Orders": "Sale Return Orders",
  Sales,
  "Sales & Orders": "Sales & Orders",
  "Sales & Purchases": "Sales & Purchases",
  "Sales Amount": "Sales Amount",
  "Sale Unit": "Sale Unit",
  "Same Country Percentage": "Same Country Percentage",
  "Same State": "Same State",
  Save,
  "Save & go to listing": "Save & go to listing",
  saved,
  "Saved.": "Saved.",
  "Scale Barcdoe Settings": "Scale Barcdoe Settings",
  "Scale Barcode": "Scale Barcode",
  "Scale Barcode Settings": "Scale Barcode Settings",
  "Scale barcode settings successfully saved.": "Scale barcode settings successfully saved.",
  "Scan barcode or search items for next": "Scan barcode or search items for next",
  "Scan Barcode or Search Product": "Scan Barcode or Search Product",
  "Scan barcode or type the variation code": "Scan barcode or type the variation code",
  "Scan barcode or type to search": "Scan barcode or type to search",
  "Scroll to view on menu & page change": "Scroll to view on menu & page change",
  Search,
  "Search Delay": "Search Delay",
  "Searching for results": "Searching for results",
  "Secondary Name": "Secondary Name",
  "Secure Area": "Secure Area",
  Select,
  "Select A New Icon": "Select A New Icon",
  "Select A New Logo": "Select A New Logo",
  "Select A New Photo": "Select A New Photo",
  "Select a tab": "Select a tab",
  "Selected File": "Selected File",
  "Select file": "Select file",
  "Select {x}": "Select {x}",
  "Sell Gift Card": "Sell Gift Card",
  "Selling Price": "Selling Price",
  "Sell To": "Sell To",
  "SendMail Path": "SendMail Path",
  Sent,
  "Sent at": "Sent at",
  "Sent by": "Sent by",
  "Sent to": "Sent to",
  "SEO Fields": "SEO Fields",
  Serial,
  "Serial Number": "Serial Number",
  "Serial Numbers": "Serial Numbers",
  Service,
  "Set different price, quantity & taxes per stores": "Set different price, quantity & taxes per stores",
  "Set store stock for {stock_count}": "Set store stock for {stock_count}",
  Settings,
  "Setup Key": "Setup Key",
  Shop,
  "Short Name": "Short Name",
  "Show discount column": "Show discount column",
  "show expiry date input while purchasing": "show expiry date input while purchasing",
  "Show Filters": "Show Filters",
  "Show image": "Show image",
  "Show in details": "Show in details",
  "Showing from {from} to {to} of total {total} records": "Showing from {from} to {to} of total {total} records",
  "Show in POS": "Show in POS",
  "Show in Shop": "Show in Shop",
  "Show menus as dropdown": "Show menus as dropdown",
  "Show on details view": "Show on details view",
  "Show Product Image": "Show Product Image",
  "Show Product Name": "Show Product Name",
  "Show Product Price": "Show Product Price",
  "Show Recovery Codes": "Show Recovery Codes",
  "Show Site Name": "Show Site Name",
  "Show tax column": "Show tax column",
  "Show taxes with zero value": "Show taxes with zero value",
  "Show tax summary": "Show tax summary",
  "Show this in offline payments": "Show this in offline payments",
  Sidebar,
  Simple,
  Size,
  size,
  SKU,
  Slug,
  "SMTP Encryption": "SMTP Encryption",
  "SMTP Host": "SMTP Host",
  "SMTP Password": "SMTP Password",
  "SMTP Port": "SMTP Port",
  "SMTP Username": "SMTP Username",
  Sold,
  "Sorry, the page you are looking for could not be found.": "Sorry, the page you are looking for could not be found.",
  "Sorry, we are doing some maintenance. Please check back soon.": "Sorry, we are doing some maintenance. Please check back soon.",
  "Sorry, you are forbidden from accessing this page.": "Sorry, you are forbidden from accessing this page.",
  "So the net price will be 100 - 9.09 = 90.91": "So the net price will be 100 - 9.09 = 90.91",
  "So the net price will be 100 - 10 = 90.00": "So the net price will be 100 - 10 = 90.00",
  "Spend X Get Discount (SXGD)": "Spend X Get Discount (SXGD)",
  Staff,
  Standard,
  start,
  "Start Date": "Start Date",
  "Start Stock Count": "Start Stock Count",
  state,
  State,
  Stock,
  "Stock Count": "Stock Count",
  "stock count": "stock count",
  "Stock count has already completed.": "Stock count has already completed.",
  "Stock Count No. {x}": "Stock Count No. {x}",
  "Stock Counts": "Stock Counts",
  "Stock Tracking": "Stock Tracking",
  Store,
  store,
  "Store Account": "Store Account",
  "Store has been selected.": "Store has been selected.",
  "Store has been unselected.": "Store has been unselected.",
  "Store Price Group": "Store Price Group",
  Stores,
  "Store these recovery codes in a secure password manager. They can be used to recover access to your account if your two factor authentication device is lost.": "Store these recovery codes in a secure password manager. They can be used to recover access to your account if your two factor authentication device is lost.",
  Street,
  "Stripe Amount": "Stripe Amount",
  "Stripe Payments Value": "Stripe Payments Value",
  "Stripe Publishable Key": "Stripe Publishable Key",
  "Stripe Secret Key": "Stripe Secret Key",
  "Stripe Terminal": "Stripe Terminal",
  "Stripe Terminal Amount": "Stripe Terminal Amount",
  Sub,
  Subcategory,
  Subtotal,
  Subtraction,
  "Subtraction/Damage/Expired/Lost": "Subtraction/Damage/Expired/Lost",
  "Super Admin role can not be modified.": "Super Admin role can not be modified.",
  Supplier,
  "Supplier Group": "Supplier Group",
  "Supplier group": "Supplier group",
  "Supplier name with email already exists": "Supplier name with email already exists",
  "Supplier name with phone already exists": "Supplier name with phone already exists",
  "Supplier Part Id": "Supplier Part Id",
  Suppliers,
  "Suppliers Due": "Suppliers Due",
  "Supplier Statement": "Supplier Statement",
  Support,
  "Support Links": "Support Links",
  Surcharge,
  SXGD,
  Symbology,
  "Sync balance for Purchase #{id}": "Sync balance for Purchase #{id}",
  "Sync balance for Return Order #{id}": "Sync balance for Return Order #{id}",
  "Sync balance for {expense}": "Sync balance for {expense}",
  "Sync balance for {payment}": "Sync balance for {payment}",
  "Sync balance for {purchase}": "Sync balance for {purchase}",
  "Sync balance for {return_order}": "Sync balance for {return_order}",
  "Sync balance for {sale}": "Sync balance for {sale}",
  Syncing,
  "Sync {x} quantity for adjustment {id} item {i}": "Sync {x} quantity for adjustment {id} item {i}",
  System,
  "System will update the customer if it has the same name, phone and email otherwise new customer will be added.": "System will update the customer if it has the same name, phone and email otherwise new customer will be added.",
  "System will update the supplier if it has the same name, phone and email otherwise new supplier will be added.": "System will update the supplier if it has the same name, phone and email otherwise new supplier will be added.",
  Tax,
  tax,
  "Tax (Purchase Return)": "Tax (Purchase Return)",
  "Tax (Sale Return)": "Tax (Sale Return)",
  Taxes,
  "Taxes are included in price": "Taxes are included in price",
  "Tax is included in price": "Tax is included in price",
  Template,
  "Tender Amount": "Tender Amount",
  "Terms of Service": "Terms of Service",
  Text,
  Textarea,
  "Thank you very much!": "Thank you very much!",
  The,
  "The :attribute is required.": "The :attribute is required.",
  "The gift card amount is required.": "The gift card amount is required.",
  "The gift card number is required.": "The gift card number is required.",
  "The locale length should be 2 or 5 characters e.g. en or en-US.": "The locale length should be 2 or 5 characters e.g. en or en-US.",
  "The order has been deleted!": "The order has been deleted!",
  "The order has been saved!": "The order has been saved!",
  "The phone number is invalid.": "The phone number is invalid.",
  "The provided password does not match your current password.": "The provided password does not match your current password.",
  "The quantity is invalid.": "The quantity is invalid.",
  "The quantity is not available.": "The quantity is not available.",
  "The record can not be deleted.": "The record can not be deleted.",
  "The register has been closed!": "The register has been closed!",
  "There is no data to display!": "There is no data to display!",
  "There is no product to display": "There is no product to display",
  "There is no suspended order to display.": "There is no suspended order to display.",
  "The store has been selected!": "The store has been selected!",
  "The task has completed, {count} deleted and {failed} failed.": "The task has completed, {count} deleted and {failed} failed.",
  "This action cannot be undone.": "This action cannot be undone.",
  "This action is not reversible!": "This action is not reversible!",
  "This action will delete the data permanently.": "This action will delete the data permanently.",
  "This could result in email failure depending on your mail server and biller email address.": "This could result in email failure depending on your mail server and biller email address.",
  "This device": "This device",
  "This discount will override any products discount.": "This discount will override any products discount.",
  "This is a secure area of the application. Please confirm your password before continuing.": "This is a secure area of the application. Please confirm your password before continuing.",
  "This is not receipt but the bill to collect payment.": "This is not receipt but the bill to collect payment.",
  "This is state tax": "This is state tax",
  "This product has expiry date": "This product has expiry date",
  "This product has serial numbers": "This product has serial numbers",
  "This product has variants": "This product has variants",
  "This quotation has {x}": "This quotation has {x}",
  "This sale has {x}": "This sale has {x}",
  "This tax is recoverable": "This tax is recoverable",
  Till,
  Time,
  Timezone,
  Title,
  To,
  "To Buy": "To Buy",
  "To finish enabling two factor authentication, scan the following QR code using your phone's authenticator application or enter the setup key and provide the generated OTP code.": "To finish enabling two factor authentication, scan the following QR code using your phone's authenticator application or enter the setup key and provide the generated OTP code.",
  "To Get": "To Get",
  "Topup Gift Card": "Topup Gift Card",
  "To Store": "To Store",
  Total,
  "Total Items": "Total Items",
  "Total Payment": "Total Payment",
  "Total Payment Amount": "Total Payment Amount",
  "Total Quantity": "Total Quantity",
  "Total quantity": "Total quantity",
  "Total Sales": "Total Sales",
  "Track stock": "Track stock",
  transfer,
  Transfer,
  "Transfer Items": "Transfer Items",
  "Transfer No. {x}": "Transfer No. {x}",
  "Transfer Order": "Transfer Order",
  Transfers,
  "Transfer To": "Transfer To",
  Trashed,
  "Two-factor Confirmation": "Two-factor Confirmation",
  "Two Factor Authentication": "Two Factor Authentication",
  "Two factor authentication is now enabled. Scan the following QR code using your phone's authenticator application or enter the setup key.": "Two factor authentication is now enabled. Scan the following QR code using your phone's authenticator application or enter the setup key.",
  Type,
  "Unable to close register!": "Unable to close register!",
  "Unable to delete attachment!": "Unable to delete attachment!",
  Unit,
  unit,
  "Unit Cost": "Unit Cost",
  "Unit Price": "Unit Price",
  Units,
  Unknown,
  "Unpaid {x}": "Unpaid {x}",
  "Unselect {x}": "Unselect {x}",
  Update,
  "Update All": "Update All",
  "Update all records": "Update all records",
  "Update All Records": "Update All Records",
  updated,
  "Update Password": "Update Password",
  "Update your account's profile information and email address.": "Update your account's profile information and email address.",
  "Update {x}": "Update {x}",
  Url,
  "Use an authentication code": "Use an authentication code",
  "Use a recovery code": "Use a recovery code",
  User,
  "User :username has been logged in.": "User :username has been logged in.",
  Username,
  Users,
  Variant,
  Variants,
  "Variant {x}": "Variant {x}",
  Variation,
  variation,
  "Variation Code": "Variation Code",
  variations,
  Variations,
  "Video URL": "Video URL",
  View,
  "View Alerts": "View Alerts",
  "View All": "View All",
  "View all": "View all",
  "View all records": "View all records",
  "View Details": "View Details",
  "View notifications": "View notifications",
  "View Open Orders": "View Open Orders",
  "View Orders": "View Orders",
  "View Register Details": "View Register Details",
  "View Sales": "View Sales",
  "View {x}": "View {x}",
  Weight,
  "Weight Characters Length": "Weight Characters Length",
  "Weight Divide by": "Weight Divide by",
  "Weight Start Position": "Weight Start Position",
  "Weight Unit": "Weight Unit",
  "When two factor authentication is enabled, you will be prompted for a secure, random token during authentication. You may retrieve this token from your phone's Google Authenticator application.": "When two factor authentication is enabled, you will be prompted for a secure, random token during authentication. You may retrieve this token from your phone's Google Authenticator application.",
  "Whoops, something went wrong on our servers.": "Whoops, something went wrong on our servers.",
  "will earn": "will earn",
  "With Trashed": "With Trashed",
  "Year Overview": "Year Overview",
  "Yes, delete": "Yes, delete",
  "You already have opened register at {x}.": "You already have opened register at {x}.",
  "You are not allowed to update yourself. Please use profile to update your account OR login with different user to update this account.": "You are not allowed to update yourself. Please use profile to update your account OR login with different user to update this account.",
  "You cannot apply discount more than {x}%": "You cannot apply discount more than {x}%",
  "You have already added maximum number of variants.": "You have already added maximum number of variants.",
  "You have already opened register at another store.!": "You have already opened register at another store.!",
  "You have been invited to join the :team team!": "You have been invited to join the :team team!",
  "You have enabled two factor authentication.": "You have enabled two factor authentication.",
  "You have not enabled two factor authentication.": "You have not enabled two factor authentication.",
  "You may accept this invitation by clicking the button below:": "You may accept this invitation by clicking the button below:",
  "You may delete any of your existing tokens if they are no longer needed.": "You may delete any of your existing tokens if they are no longer needed.",
  "you must enable if you have state level taxes": "you must enable if you have state level taxes",
  "You must fill the name column.": "You must fill the name column.",
  "Your email address is unverified.": "Your email address is unverified.",
  "{a} {x} quantity for {id} item {i}": "{a} {x} quantity for {id} item {i}",
  "{models} have imported or updated.": "{models} have imported or updated.",
  "{model} cannot be {action}.": "{model} cannot be {action}.",
  "{model} cannot be {action}. The record is being used for relationships.": "{model} cannot be {action}. The record is being used for relationships.",
  "{model} has been successfully {action}.": "{model} has been successfully {action}.",
  "{name} does not have {quantity} in stock, available quantity {available}.": "{name} does not have {quantity} in stock, available quantity {available}.",
  "{name} have only {available} quantity available.": "{name} have only {available} quantity available.",
  "{record} has been {action}.": "{record} has been {action}.",
  "{record} has permanently deleted.": "{record} has permanently deleted.",
  "{x} added to order.": "{x} added to order.",
  "{x} Details": "{x} Details",
  "{x} Report": "{x} Report",
  "{x} Settings": "{x} Settings",
  "{x} will be deleted permanently from system.": "{x} will be deleted permanently from system."
};
const available = [{ "value": "en", "label": "English", "flag": "US" }, { "value": "es", "label": "Spanish", "flag": "ES" }, { "value": "fr", "label": "French", "flag": "FR" }];
const languages = {
  available
};
const messages = { en };
const LANGUAGES = languages.available;
languages.available.map((l) => l.value).filter((l) => l != "en");
createI18n({
  messages,
  legacy: false,
  missingWarn: false,
  mode: "composition",
  fallbackWarn: false,
  fallbackLocale: "en",
  warnHtmlMessage: false,
  locale: typeof window === "undefined" ? "en" : window.Locale || "en",
  missing: async (locale, key) => {
    console.log("Add to " + locale + '.json => "' + key + '": "' + key + '",');
  }
});
const __default__ = {
  data() {
    return { currentLang: this.$page.props.language };
  },
  methods: {
    getFlag(lang) {
      var _a;
      return ((_a = LANGUAGES.find((l) => l.value == this.$root.$i18n.locale)) == null ? void 0 : _a.flag) || "US";
    },
    changeLang(language) {
      router.visit(route("language", { language }), {
        onFinish: () => {
          window.Locale = language;
          this.currentLang = language;
          document.querySelector("html").setAttribute("lang", language);
          this.$root.$i18n.locale = language;
        }
      });
    }
  }
};
const _sfc_main$3 = /* @__PURE__ */ Object.assign(__default__, {
  __name: "Topbar",
  __ssrInlineRender: true,
  setup(__props) {
    const page = usePage();
    let currentRoute = ref(route().current());
    router.on("navigate", () => currentRoute.value = route().current());
    let showAlerts = ref(false);
    function isCurrentRoute(r) {
      try {
        return route(currentRoute.value) == route(r);
      } catch (error) {
      }
    }
    const logout = () => {
      router.post(route("logout"));
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Icon = resolveComponent("Icon");
      const _component_Link = resolveComponent("Link");
      _push(`<div${ssrRenderAttrs(mergeProps({
        id: "top-bar",
        class: "top-bar flex flex-1 gap-x-4 self-stretch lg:gap-x-6"
      }, _attrs))}><div class="flex flex-1"><label for="search-field" class="sr-only">${ssrInterpolate(_ctx.$t("Search"))}</label><div class="relative w-full">`);
      _push(ssrRenderComponent(_component_Icon, {
        name: "search",
        size: "pointer-events-none absolute inset-y-0 left-0 h-full w-5 text-mute"
      }, null, _parent));
      _push(`<input type="search" name="search" id="search-field"${ssrRenderAttr("value", unref(page).props.filters.search)}${ssrRenderAttr("placeholder", _ctx.$t("Search") + "...")} class="block h-full w-full border-0 bg-transparent py-0 pl-8 pr-0 text-focus focus:ring-0 sm:text-sm"></div></div><div class="flex items-center gap-x-6">`);
      _push(ssrRenderComponent(_component_Link, {
        href: _ctx.route("dashboard"),
        class: [
          "-m-2.5 p-2.5 hidden md:block",
          isCurrentRoute("dashboard") ? "text-primary-400" : "text-gray-500 dark:text-gray-400 hover:text-gray-600 dark:hover:text-gray-300"
        ]
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<span class="sr-only"${_scopeId}>${ssrInterpolate(_ctx.$t("Dashboard"))}</span><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-5"${_scopeId}><path stroke-linecap="round" stroke-linejoin="round" d="m2.25 12 8.954-8.955c.44-.439 1.152-.439 1.591 0L21.75 12M4.5 9.75v10.125c0 .621.504 1.125 1.125 1.125H9.75v-4.875c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21h4.125c.621 0 1.125-.504 1.125-1.125V9.75M8.25 21h8.25"${_scopeId}></path></svg>`);
          } else {
            return [
              createVNode("span", { class: "sr-only" }, toDisplayString(_ctx.$t("Dashboard")), 1),
              (openBlock(), createBlock("svg", {
                xmlns: "http://www.w3.org/2000/svg",
                fill: "none",
                viewBox: "0 0 24 24",
                "stroke-width": "1.5",
                stroke: "currentColor",
                class: "size-5"
              }, [
                createVNode("path", {
                  "stroke-linecap": "round",
                  "stroke-linejoin": "round",
                  d: "m2.25 12 8.954-8.955c.44-.439 1.152-.439 1.591 0L21.75 12M4.5 9.75v10.125c0 .621.504 1.125 1.125 1.125H9.75v-4.875c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21h4.125c.621 0 1.125-.504 1.125-1.125V9.75M8.25 21h8.25"
                })
              ]))
            ];
          }
        }),
        _: 1
      }, _parent));
      if (unref(page).props.auth.user.store_id) {
        _push(`<div class="flex items-center gap-2 text-gray-500 dark:text-gray-400">`);
        _push(ssrRenderComponent(_component_Icon, {
          name: "store",
          size: "size-5"
        }, null, _parent));
        _push(`<span class="hidden sm:block">${ssrInterpolate(unref(page).props.auth.user.store.name)}</span></div>`);
      } else {
        _push(`<div class="flex items-center text-gray-500 dark:text-gray-400 hover:text-gray-600 dark:hover:text-gray-300"><button type="button" class="${ssrRenderClass(
          unref(page).props.selected_store ? "text-success-600 dark:text-success-400" : "text-gray-500 dark:text-gray-400 hover:text-gray-600 dark:hover:text-gray-300"
        )}"><span class="flex items-center gap-2">`);
        if (unref(page).props.selected_store) {
          _push(`<span class="flex items-center gap-2 font-bold">`);
          _push(ssrRenderComponent(_component_Icon, {
            name: "store",
            size: "size-5"
          }, null, _parent));
          _push(`</span>`);
        } else {
          _push(ssrRenderComponent(_component_Icon, {
            name: "store-o",
            size: "size-5"
          }, null, _parent));
        }
        _push(`</span></button></div>`);
      }
      if (_ctx.route().has("pos")) {
        _push(ssrRenderComponent(_component_Link, {
          class: [
            "-m-2.5 p-2.5",
            isCurrentRoute("pos") ? "text-primary-400" : "text-gray-500 dark:text-gray-400 hover:text-gray-600 dark:hover:text-gray-300"
          ],
          href: _ctx.route("pos")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="sr-only"${_scopeId}>${ssrInterpolate(_ctx.$t("POS"))}</span>`);
              _push2(ssrRenderComponent(_component_Icon, {
                name: "pos-o",
                size: "size-5"
              }, null, _parent2, _scopeId));
            } else {
              return [
                createVNode("span", { class: "sr-only" }, toDisplayString(_ctx.$t("POS")), 1),
                createVNode(_component_Icon, {
                  name: "pos-o",
                  size: "size-5"
                })
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="hidden md:block text-gray-500 dark:text-gray-400 hover:text-gray-600 dark:hover:text-gray-300">`);
      _push(ssrRenderComponent(unref(_sfc_main$4), null, null, _parent));
      _push(`</div><div class="hidden md:block">`);
      _push(ssrRenderComponent(unref(_sfc_main$5), {
        align: "left",
        width: "40"
      }, {
        trigger: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<button class="flex items-center px-2 py-1 mr-2 border-2 border-transparent rounded-md focus transition duration-150 ease-in-out"${_scopeId}><span class="text-xl"${_scopeId}>${_ctx.getFlag(_ctx.currentLang).replace(/./g, (char) => String.fromCodePoint(char.charCodeAt(0) + 127397)) ?? ""}</span></button>`);
          } else {
            return [
              createVNode("button", { class: "flex items-center px-2 py-1 mr-2 border-2 border-transparent rounded-md focus transition duration-150 ease-in-out" }, [
                createVNode("span", {
                  class: "text-xl",
                  innerHTML: _ctx.getFlag(_ctx.currentLang).replace(/./g, (char) => String.fromCodePoint(char.charCodeAt(0) + 127397))
                }, null, 8, ["innerHTML"])
              ])
            ];
          }
        }),
        content: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<!--[-->`);
            ssrRenderList(unref(LANGUAGES), (lang) => {
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                as: "button",
                onClick: ($event) => _ctx.changeLang(lang.value)
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<div class="mr-2 text-lg -my-1"${_scopeId2}>${lang.flag.replace(/./g, (char) => String.fromCodePoint(char.charCodeAt(0) + 127397)) ?? ""}</div> ${ssrInterpolate(lang.label)}`);
                  } else {
                    return [
                      createVNode("div", {
                        class: "mr-2 text-lg -my-1",
                        innerHTML: lang.flag.replace(/./g, (char) => String.fromCodePoint(char.charCodeAt(0) + 127397))
                      }, null, 8, ["innerHTML"]),
                      createTextVNode(" " + toDisplayString(lang.label), 1)
                    ];
                  }
                }),
                _: 2
              }, _parent2, _scopeId));
            });
            _push2(`<!--]-->`);
          } else {
            return [
              (openBlock(true), createBlock(Fragment, null, renderList(unref(LANGUAGES), (lang) => {
                return openBlock(), createBlock(unref(_sfc_main$6), {
                  key: lang.value,
                  as: "button",
                  onClick: ($event) => _ctx.changeLang(lang.value)
                }, {
                  default: withCtx(() => [
                    createVNode("div", {
                      class: "mr-2 text-lg -my-1",
                      innerHTML: lang.flag.replace(/./g, (char) => String.fromCodePoint(char.charCodeAt(0) + 127397))
                    }, null, 8, ["innerHTML"]),
                    createTextVNode(" " + toDisplayString(lang.label), 1)
                  ]),
                  _: 2
                }, 1032, ["onClick"]);
              }), 128))
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><button type="button" class="-m-2.5 p-2.5 text-gray-500 dark:text-gray-400 hover:text-gray-600 dark:hover:text-gray-300"><span class="sr-only">${ssrInterpolate(_ctx.$t("View notifications"))}</span>`);
      _push(ssrRenderComponent(_component_Icon, {
        name: "bell-o",
        size: "size-5"
      }, null, _parent));
      _push(`</button>`);
      if (unref($can)("settings")) {
        _push(ssrRenderComponent(_component_Link, {
          href: _ctx.route("settings.index"),
          class: [
            "-m-2.5 p-2.5 hidden md:block",
            isCurrentRoute("settings.index") ? "text-primary-400" : "text-gray-500 dark:text-gray-400 hover:text-gray-600 dark:hover:text-gray-300"
          ]
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="sr-only"${_scopeId}>${ssrInterpolate(_ctx.$t("Settings"))}</span>`);
              _push2(ssrRenderComponent(_component_Icon, {
                name: "cog-o",
                size: "size-5"
              }, null, _parent2, _scopeId));
            } else {
              return [
                createVNode("span", { class: "sr-only" }, toDisplayString(_ctx.$t("Settings")), 1),
                createVNode(_component_Icon, {
                  name: "cog-o",
                  size: "size-5"
                })
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="hidden lg:block lg:h-6 lg:w-px" aria-hidden="true"></div><div class="relative z-20">`);
      _push(ssrRenderComponent(unref(_sfc_main$5), {
        align: "right",
        width: "40"
      }, {
        trigger: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<button type="button" class="-m-1.5 flex items-center p-1.5"${_scopeId}><span class="sr-only"${_scopeId}>${ssrInterpolate(_ctx.$t("Open user menu"))}</span><span class="w-8 h-8 rounded-full flex items-center overflow-hidden"${_scopeId}><img class="max-h-full max-w-full object-cover"${ssrRenderAttr("src", unref(page).props.auth.user.profile_photo_url)}${ssrRenderAttr("alt", unref(page).props.auth.user.name)}${_scopeId}></span><span class="hidden lg:flex lg:items-center"${_scopeId}><span class="ml-3 text-sm font-semibold leading-6" aria-hidden="true"${_scopeId}>${ssrInterpolate(unref(page).props.auth.user.name)}</span><svg class="ml-2 h-5 w-5 text-gray-400" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true" data-slot="icon"${_scopeId}><path fill-rule="evenodd" d="M5.22 8.22a.75.75 0 0 1 1.06 0L10 11.94l3.72-3.72a.75.75 0 1 1 1.06 1.06l-4.25 4.25a.75.75 0 0 1-1.06 0L5.22 9.28a.75.75 0 0 1 0-1.06Z" clip-rule="evenodd"${_scopeId}></path></svg></span></button>`);
          } else {
            return [
              createVNode("button", {
                type: "button",
                class: "-m-1.5 flex items-center p-1.5"
              }, [
                createVNode("span", { class: "sr-only" }, toDisplayString(_ctx.$t("Open user menu")), 1),
                createVNode("span", { class: "w-8 h-8 rounded-full flex items-center overflow-hidden" }, [
                  createVNode("img", {
                    class: "max-h-full max-w-full object-cover",
                    src: unref(page).props.auth.user.profile_photo_url,
                    alt: unref(page).props.auth.user.name
                  }, null, 8, ["src", "alt"])
                ]),
                createVNode("span", { class: "hidden lg:flex lg:items-center" }, [
                  createVNode("span", {
                    class: "ml-3 text-sm font-semibold leading-6",
                    "aria-hidden": "true"
                  }, toDisplayString(unref(page).props.auth.user.name), 1),
                  (openBlock(), createBlock("svg", {
                    class: "ml-2 h-5 w-5 text-gray-400",
                    viewBox: "0 0 20 20",
                    fill: "currentColor",
                    "aria-hidden": "true",
                    "data-slot": "icon"
                  }, [
                    createVNode("path", {
                      "fill-rule": "evenodd",
                      d: "M5.22 8.22a.75.75 0 0 1 1.06 0L10 11.94l3.72-3.72a.75.75 0 1 1 1.06 1.06l-4.25 4.25a.75.75 0 0 1-1.06 0L5.22 9.28a.75.75 0 0 1 0-1.06Z",
                      "clip-rule": "evenodd"
                    })
                  ]))
                ])
              ])
            ];
          }
        }),
        content: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div${_scopeId}><div class="block px-4 py-2 text-xs text-gray-400"${_scopeId}>${ssrInterpolate(_ctx.$t("Manage Account"))}</div>`);
            _push2(ssrRenderComponent(unref(_sfc_main$6), {
              href: _ctx.route("profile.show")
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Profile"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Profile")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            if (unref(page).props.jetstream.hasApiFeatures) {
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                href: _ctx.route("api-tokens.index")
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(_ctx.$t("API Tokens"))}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(_ctx.$t("API Tokens")), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              _push2(`<!---->`);
            }
            _push2(`<div class="border-t border-gray-200 dark:border-gray-600"${_scopeId}></div><form${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$6), { as: "button" }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Log Out"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Log Out")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</form></div>`);
          } else {
            return [
              createVNode("div", null, [
                createVNode("div", { class: "block px-4 py-2 text-xs text-gray-400" }, toDisplayString(_ctx.$t("Manage Account")), 1),
                createVNode(unref(_sfc_main$6), {
                  href: _ctx.route("profile.show")
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.$t("Profile")), 1)
                  ]),
                  _: 1
                }, 8, ["href"]),
                unref(page).props.jetstream.hasApiFeatures ? (openBlock(), createBlock(unref(_sfc_main$6), {
                  key: 0,
                  href: _ctx.route("api-tokens.index")
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.$t("API Tokens")), 1)
                  ]),
                  _: 1
                }, 8, ["href"])) : createCommentVNode("", true),
                createVNode("div", { class: "border-t border-gray-200 dark:border-gray-600" }),
                createVNode("form", {
                  onSubmit: withModifiers(logout, ["prevent"])
                }, [
                  createVNode(unref(_sfc_main$6), { as: "button" }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(_ctx.$t("Log Out")), 1)
                    ]),
                    _: 1
                  })
                ], 32)
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div>`);
      _push(ssrRenderComponent(unref(_sfc_main$7), {
        show: unref(showAlerts),
        backdrop: false,
        "max-width": "2xl",
        closeable: true,
        onClose: ($event) => isRef(showAlerts) ? showAlerts.value = false : showAlerts = false
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(unref(_sfc_main$8), {
              onClose: ($event) => isRef(showAlerts) ? showAlerts.value = false : showAlerts = false
            }, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(unref(_sfc_main$8), {
                onClose: ($event) => isRef(showAlerts) ? showAlerts.value = false : showAlerts = false
              }, null, 8, ["onClose"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div>`);
    };
  }
});
const _sfc_setup$3 = _sfc_main$3.setup;
_sfc_main$3.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Layouts/Components/Topbar.vue");
  return _sfc_setup$3 ? _sfc_setup$3(props, ctx) : void 0;
};
const _sfc_main$2 = {
  __name: "SidebarMenus",
  __ssrInlineRender: true,
  emits: ["close"],
  setup(__props, { emit: __emit }) {
    const page = usePage();
    const { t, locale } = useI18n();
    router.on("navigate", stateChanged);
    const emits = __emit;
    let menus = ref([]);
    let menuState = ref({});
    let currentParent = ref(null);
    let currentRoute = ref(T().current());
    watch(locale, async () => {
      menus.value = getMenus(t);
    });
    onMounted(async () => {
      menus.value = getMenus(t);
      menus.value.map((menu) => {
        var _a;
        (_a = menu.menus) == null ? void 0 : _a.map((m) => {
          if (m.sub_menu && m.sub_menu.length) {
            menuState.value[m.name] = false;
          }
        });
      });
    });
    function stateChanged() {
      currentParent.value = null;
      currentRoute.value = T().current();
      Object.keys(menuState.value).map((k) => menuState.value[k] = false);
      menus.value.map((menu) => {
        var _a;
        (_a = menu.menus) == null ? void 0 : _a.map((m) => {
          if (m.sub_menu && m.sub_menu.length) {
            let cm = m.sub_menu.find((s) => s.route == currentRoute.value);
            if (cm && cm.target) {
              currentParent.value = m.name;
              menuState.value[cm.target] = true;
              if (page.props.settings.sidebar_scroll_to_view == 1) {
                nextTick().then(() => {
                  document.getElementById(cm.target).parentNode.scrollIntoView({ behavior: "smooth", block: "start" });
                });
              }
            }
          }
        });
      });
      emits("close");
    }
    function isCurrentRoute(r, p) {
      let route_name = currentRoute.value.includes(".edit") ? currentRoute.value.split(".edit")[0] : currentRoute.value;
      if (p) {
        try {
          return T(route_name).includes(p);
        } catch (error) {
          return route_name == p;
        }
      } else if (r) {
        try {
          return T(route_name) == T(r);
        } catch (error) {
        }
      }
      return false;
    }
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Icon = resolveComponent("Icon");
      _push(`<div${ssrRenderAttrs(mergeProps({
        id: "side-bar",
        class: ["side-bar fixed inset-y-0 left-0 w-64 {$$props.class || ''}", unref(page).props.settings.dark_sidebar == 1 ? "dark bg-gray-900" : "bg-white dark:bg-gray-900"]
      }, _attrs))}><div class="absolute z-20 left-full top-0 flex w-16 justify-center pt-5 xl:hidden"><button type="button" class="-m-2.5 p-2.5 rounded-lg"><span class="sr-only">${ssrInterpolate(_ctx.$t("Close sidebar"))}</span><svg class="h-6 w-6 text-focus" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true" data-slot="icon"><path stroke-linecap="round" stroke-linejoin="round" d="M6 18 18 6M6 6l12 12"></path></svg></button></div><nav class="flex h-full min-h-0 flex-col relative z-20 border-r border-gray-200 dark:border-gray-700"><div class="flex flex-col items-start justify-center h-16 px-4 border-b border-gray-200 dark:border-gray-700"><div class="cursor-default flex w-full items-center gap-2.5 rounded-lg px-1 text-left text-base/6 font-medium sm:text-sm dark:text-white"><span data-slot="avatar" class="inline-grid shrink-0 align-middle h-12">`);
      _push(ssrRenderComponent(ApplicationLogo, null, null, _parent));
      _push(`</span><span class="sr-only">${ssrInterpolate(_ctx.$page.props.settings.name)}</span></div></div><div id="side-bar-menus" class="flex flex-1 flex-col overflow-y-auto space-y-6"><!--[-->`);
      ssrRenderList(unref(menus), (menuSection) => {
        _push(`<!--[-->`);
        if (menuSection.name == "separator") {
          _push(`<div class="flex-1"></div>`);
        } else if (menuSection.name == "support") {
          _push(`<!--[--><div class="flex-1"></div>`);
          if (_ctx.$page.props.settings.support_links == 1) {
            _push(`<div class="mt-6"><div data-slot="section" class="${ssrRenderClass([unref(page).props.settings.sidebar_dropdown == 1 ? "gap-0" : "gap-1", "flex flex-col"])}">`);
            if (menuSection.heading) {
              _push(`<h3 class="my-1 px-3 text-xs/6 font-medium text-gray-500 dark:text-gray-400">${ssrInterpolate(menuSection.heading)}</h3>`);
            } else {
              _push(`<!---->`);
            }
            _push(`<!--[-->`);
            ssrRenderList(menuSection.menus, (mainMenu) => {
              _push(`<!--[-->`);
              if (!mainMenu.sub_menu && (mainMenu.link || unref(T)().has(mainMenu.route))) {
                _push(`<span class="relative">`);
                if (!mainMenu.link && isCurrentRoute(mainMenu.route)) {
                  _push(`<span class="absolute inset-y-0 -left-0 w-0.5 rounded-full bg-gray-950 dark:bg-white" style="${ssrRenderStyle({ "transform": "none", "transform-origin": "50% 50% 0px" })}"></span>`);
                } else {
                  _push(`<!---->`);
                }
                ssrRenderVNode(_push, createVNode(resolveDynamicComponent(mainMenu.link ? "a" : unref(Link)), {
                  target: mainMenu.link ? "_blank" : "_self",
                  href: mainMenu.link || unref(T)(mainMenu.route),
                  class: [
                    !mainMenu.link && isCurrentRoute(mainMenu.route) ? "bg-primary-100 dark:bg-primary-800 pointer-events-none" : "",
                    "group hover:bg-primary-50 dark:hover:bg-primary-900 flex w-full items-center gap-3 px-4 py-2.5 text-left text-base/6 font-medium sm:py-2 sm:text-sm/5 data-[slot=icon]:*:size-6 data-[slot=icon]:*:shrink-0 data-[slot=icon]:*:fill-gray-500 sm:data-[slot=icon]:*:size-5 data-[slot=icon]:last:*:ml-auto data-[slot=icon]:last:*:size-5 sm:data-[slot=icon]:last:*:size-4 data-[slot=avatar]:*:-m-0.5 data-[slot=avatar]:*:size-7 data-[slot=avatar]:*:[--ring-opacity:10%] sm:data-[slot=avatar]:*:size-6 data-[hover]:bg-gray-950/5 data-[slot=icon]:*:data-[hover]:fill-gray-950 data-[active]:bg-gray-950/5 data-[slot=icon]:*:data-[active]:fill-gray-950 data-[slot=icon]:*:data-[current]:fill-gray-950 dark:text-white dark:data-[slot=icon]:*:fill-gray-400 dark:data-[hover]:bg-white/5 dark:data-[slot=icon]:*:data-[hover]:fill-white dark:data-[active]:bg-white/5 dark:data-[slot=icon]:*:data-[active]:fill-white dark:data-[slot=icon]:*:data-[current]:fill-white"
                  ]
                }, {
                  default: withCtx((_, _push2, _parent2, _scopeId) => {
                    if (_push2) {
                      _push2(`<span class="absolute left-1/2 top-1/2 size-[max(100%,2.75rem)] -translate-x-1/2 -translate-y-1/2 [@media(pointer:fine)]:hidden" aria-hidden="true"${_scopeId}></span>`);
                      if (mainMenu.icon) {
                        _push2(ssrRenderComponent(_component_Icon, {
                          name: mainMenu.icon
                        }, null, _parent2, _scopeId));
                      } else {
                        _push2(`<!---->`);
                      }
                      _push2(`<span class="truncate grow flex-1"${_scopeId}>${ssrInterpolate(mainMenu.label)}</span>`);
                      if (mainMenu.link) {
                        _push2(ssrRenderComponent(_component_Icon, {
                          name: "external",
                          size: "w-4 h-4 hidden group-hover:block"
                        }, null, _parent2, _scopeId));
                      } else {
                        _push2(`<!---->`);
                      }
                    } else {
                      return [
                        createVNode("span", {
                          class: "absolute left-1/2 top-1/2 size-[max(100%,2.75rem)] -translate-x-1/2 -translate-y-1/2 [@media(pointer:fine)]:hidden",
                          "aria-hidden": "true"
                        }),
                        mainMenu.icon ? (openBlock(), createBlock(_component_Icon, {
                          key: 0,
                          name: mainMenu.icon
                        }, null, 8, ["name"])) : createCommentVNode("", true),
                        createVNode("span", { class: "truncate grow flex-1" }, toDisplayString(mainMenu.label), 1),
                        mainMenu.link ? (openBlock(), createBlock(_component_Icon, {
                          key: 1,
                          name: "external",
                          size: "w-4 h-4 hidden group-hover:block"
                        })) : createCommentVNode("", true)
                      ];
                    }
                  }),
                  _: 2
                }), _parent);
                _push(`</span>`);
              } else {
                _push(`<!---->`);
              }
              _push(`<!--]-->`);
            });
            _push(`<!--]--></div></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<!--]-->`);
        } else {
          _push(`<div data-slot="section" class="${ssrRenderClass([unref(page).props.settings.sidebar_dropdown == 1 ? "gap-0" : "gap-1", "flex flex-col"])}">`);
          if (menuSection.heading) {
            _push(`<h3 class="my-1 px-3 text-xs/6 font-medium text-gray-500 dark:text-gray-400">${ssrInterpolate(menuSection.heading)}</h3>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<!--[-->`);
          ssrRenderList(menuSection.menus, (mainMenu) => {
            _push(`<!--[-->`);
            if (!mainMenu.sub_menu && (mainMenu.link || unref(T)().has(mainMenu.route))) {
              _push(`<span class="relative">`);
              if (!mainMenu.link && isCurrentRoute(mainMenu.route)) {
                _push(`<span class="absolute inset-y-0 -left-0 w-0.5 rounded-full bg-gray-950 dark:bg-white" style="${ssrRenderStyle({ "transform": "none", "transform-origin": "50% 50% 0px" })}"></span>`);
              } else {
                _push(`<!---->`);
              }
              if (unref($can)(mainMenu.permissions)) {
                ssrRenderVNode(_push, createVNode(resolveDynamicComponent(mainMenu.link ? "a" : unref(Link)), {
                  target: mainMenu.link ? "_blank" : "_self",
                  href: mainMenu.link || unref(T)(mainMenu.route),
                  class: [!mainMenu.link && isCurrentRoute(mainMenu.route) ? "bg-primary-100 dark:bg-primary-800 pointer-events-none" : "", "group hover:bg-primary-50 dark:hover:bg-primary-900 flex w-full items-center gap-3 px-4 py-2.5 text-left text-base/6 font-medium sm:py-2 sm:text-sm/5 data-[slot=icon]:*:size-6 data-[slot=icon]:*:shrink-0 data-[slot=icon]:*:fill-gray-500 sm:data-[slot=icon]:*:size-5 data-[slot=icon]:last:*:ml-auto data-[slot=icon]:last:*:size-5 sm:data-[slot=icon]:last:*:size-4 data-[slot=avatar]:*:-m-0.5 data-[slot=avatar]:*:size-7 data-[slot=avatar]:*:[--ring-opacity:10%] sm:data-[slot=avatar]:*:size-6 data-[hover]:bg-gray-950/5 data-[slot=icon]:*:data-[hover]:fill-gray-950 data-[active]:bg-gray-950/5 data-[slot=icon]:*:data-[active]:fill-gray-950 data-[slot=icon]:*:data-[current]:fill-gray-950 dark:text-white dark:data-[slot=icon]:*:fill-gray-400 dark:data-[hover]:bg-white/5 dark:data-[slot=icon]:*:data-[hover]:fill-white dark:data-[active]:bg-white/5 dark:data-[slot=icon]:*:data-[active]:fill-white dark:data-[slot=icon]:*:data-[current]:fill-white"]
                }, {
                  default: withCtx((_, _push2, _parent2, _scopeId) => {
                    if (_push2) {
                      _push2(`<span class="absolute left-1/2 top-1/2 size-[max(100%,2.75rem)] -translate-x-1/2 -translate-y-1/2 [@media(pointer:fine)]:hidden" aria-hidden="true"${_scopeId}></span>`);
                      if (mainMenu.icon) {
                        _push2(ssrRenderComponent(_component_Icon, {
                          name: mainMenu.icon
                        }, null, _parent2, _scopeId));
                      } else {
                        _push2(`<!---->`);
                      }
                      _push2(`<span class="truncate grow flex-1"${_scopeId}>${ssrInterpolate(mainMenu.label)}</span>`);
                      if (mainMenu.link) {
                        _push2(ssrRenderComponent(_component_Icon, {
                          name: "external",
                          size: "w-4 h-4 hidden group-hover:block"
                        }, null, _parent2, _scopeId));
                      } else {
                        _push2(`<!---->`);
                      }
                    } else {
                      return [
                        createVNode("span", {
                          class: "absolute left-1/2 top-1/2 size-[max(100%,2.75rem)] -translate-x-1/2 -translate-y-1/2 [@media(pointer:fine)]:hidden",
                          "aria-hidden": "true"
                        }),
                        mainMenu.icon ? (openBlock(), createBlock(_component_Icon, {
                          key: 0,
                          name: mainMenu.icon
                        }, null, 8, ["name"])) : createCommentVNode("", true),
                        createVNode("span", { class: "truncate grow flex-1" }, toDisplayString(mainMenu.label), 1),
                        mainMenu.link ? (openBlock(), createBlock(_component_Icon, {
                          key: 1,
                          name: "external",
                          size: "w-4 h-4 hidden group-hover:block"
                        })) : createCommentVNode("", true)
                      ];
                    }
                  }),
                  _: 2
                }), _parent);
              } else {
                _push(`<!---->`);
              }
              _push(`</span>`);
            } else if (mainMenu.sub_menu && unref($can)(mainMenu.permissions) && unref(page).props.settings.sidebar_dropdown == 1) {
              _push(`<div class="transition-all overflow-hidden"><div class="${ssrRenderClass([[
                unref(menuState)[mainMenu.name] ? "dark:border-gray-700" : "border-transparent dark:border-transparent",
                isCurrentRoute(mainMenu.route, mainMenu.route_prefix) ? "bg-gray-50 dark:bg-gray-900" : ""
              ], "relative z-10 transition-all border-t"])}">`);
              if (isCurrentRoute(mainMenu.route, mainMenu.route_prefix)) {
                _push(`<div class="absolute inset-y-0 -left-0 w-0.5 rounded-full bg-gray-950 dark:bg-white" style="${ssrRenderStyle({ "transform": "none", "transform-origin": "50% 50% 0px" })}"></div>`);
              } else {
                _push(`<!---->`);
              }
              _push(`<button class="${ssrRenderClass([
                isCurrentRoute(mainMenu.route, mainMenu.route_prefix) || unref(currentParent) == mainMenu.name ? "bg-primary-50 dark:bg-primary-900" : "",
                "hover:bg-primary-50 dark:hover:bg-primary-900 flex w-full items-center gap-3 px-4 py-2.5 text-left text-base/6 font-medium sm:py-2 sm:text-sm/5 data-[slot=icon]:*:size-6 data-[slot=icon]:*:shrink-0 data-[slot=icon]:*:fill-gray-500 sm:data-[slot=icon]:*:size-5 data-[slot=icon]:last:*:ml-auto data-[slot=icon]:last:*:size-5 sm:data-[slot=icon]:last:*:size-4 data-[slot=avatar]:*:-m-0.5 data-[slot=avatar]:*:size-7 data-[slot=avatar]:*:[--ring-opacity:10%] sm:data-[slot=avatar]:*:size-6 data-[hover]:bg-gray-950/5 data-[slot=icon]:*:data-[hover]:fill-gray-950 data-[active]:bg-gray-950/5 data-[slot=icon]:*:data-[active]:fill-gray-950 data-[slot=icon]:*:data-[current]:fill-gray-950 dark:text-white dark:data-[slot=icon]:*:fill-gray-400 dark:data-[hover]:bg-white/5 dark:data-[slot=icon]:*:data-[hover]:fill-white dark:data-[active]:bg-white/5 dark:data-[slot=icon]:*:data-[active]:fill-white dark:data-[slot=icon]:*:data-[current]:fill-white"
              ])}"${ssrRenderAttr("id", mainMenu.name)}><span class="absolute left-1/2 top-1/2 size-[max(100%,2.75rem)] -translate-x-1/2 -translate-y-1/2 [@media(pointer:fine)]:hidden" aria-hidden="true"></span>`);
              if (mainMenu.icon) {
                _push(ssrRenderComponent(_component_Icon, {
                  name: mainMenu.icon
                }, null, _parent));
              } else {
                _push(`<!---->`);
              }
              _push(`<span class="truncate grow flex-1">${ssrInterpolate(mainMenu.label)}</span>`);
              _push(ssrRenderComponent(_component_Icon, {
                name: unref(menuState)[mainMenu.name] ? "c-up" : "c-down",
                size: "w-4 h-4 text-mute"
              }, null, _parent));
              _push(`</button><div style="${ssrRenderStyle(unref(menuState)[mainMenu.name] ? null : { display: "none" })}" class="${ssrRenderClass([unref(menuState)[mainMenu.name] ? "h-auto" : "h-0", "z-1 -ml-5 border-b border-gray-200 dark:border-gray-700 pl-6 transition-all"])}"><!--[-->`);
              ssrRenderList(mainMenu.sub_menu, (sub_menu) => {
                _push(`<!--[-->`);
                if (sub_menu.name == "separator") {
                  _push(`<div class="mx-4 pt-1 mb-1"></div>`);
                } else if (!sub_menu.hidden && unref($can)(sub_menu.permissions) && (sub_menu.link || unref(T)().has(sub_menu.route))) {
                  _push(`<span class="relative">`);
                  if (!sub_menu.link && isCurrentRoute(sub_menu.route)) {
                    _push(`<span class="absolute top-0 -bottom-px -left-0.5 w-0.5 rounded-full bg-gray-950 dark:bg-white" style="${ssrRenderStyle({ "transform": "none", "transform-origin": "50% 50% 0px" })}"></span>`);
                  } else {
                    _push(`<!---->`);
                  }
                  ssrRenderVNode(_push, createVNode(resolveDynamicComponent(sub_menu.link ? "a" : unref(Link)), {
                    target: sub_menu.link ? "_blank" : "_self",
                    href: sub_menu.link || unref(T)(sub_menu.route),
                    class: [
                      !mainMenu.link && isCurrentRoute(sub_menu.route) ? "bg-primary-100 dark:bg-primary-800 pointer-events-none" : "hover:bg-primary-50 dark:hover:bg-primary-900",
                      "group flex w-full items-center gap-3 px-4 py-2.5 text-left text-base/6 font-medium sm:py-2 sm:text-sm/5 data-[slot=icon]:*:size-6 data-[slot=icon]:*:shrink-0 data-[slot=icon]:*:fill-gray-500 sm:data-[slot=icon]:*:size-5 data-[slot=icon]:last:*:ml-auto data-[slot=icon]:last:*:size-5 sm:data-[slot=icon]:last:*:size-4 data-[slot=avatar]:*:-m-0.5 data-[slot=avatar]:*:size-7 data-[slot=avatar]:*:[--ring-opacity:10%] sm:data-[slot=avatar]:*:size-6 data-[hover]:bg-gray-950/5 data-[slot=icon]:*:data-[hover]:fill-gray-950 data-[active]:bg-gray-950/5 data-[slot=icon]:*:data-[active]:fill-gray-950 data-[slot=icon]:*:data-[current]:fill-gray-950 dark:text-white dark:data-[slot=icon]:*:fill-gray-400 dark:data-[hover]:bg-white/5 dark:data-[slot=icon]:*:data-[hover]:fill-white dark:data-[active]:bg-white/5 dark:data-[slot=icon]:*:data-[active]:fill-white dark:data-[slot=icon]:*:data-[current]:fill-white"
                    ]
                  }, {
                    default: withCtx((_, _push2, _parent2, _scopeId) => {
                      if (_push2) {
                        _push2(`<span class="absolute left-1/2 top-1/2 size-[max(100%,2.75rem)] -translate-x-1/2 -translate-y-1/2 [@media(pointer:fine)]:hidden" aria-hidden="true"${_scopeId}></span>`);
                        if (sub_menu.icon) {
                          _push2(ssrRenderComponent(_component_Icon, {
                            name: sub_menu.icon
                          }, null, _parent2, _scopeId));
                        } else {
                          _push2(`<!---->`);
                        }
                        _push2(`<span class="truncate grow flex-1"${_scopeId}>${ssrInterpolate(sub_menu.label)}</span>`);
                        if (mainMenu.link) {
                          _push2(ssrRenderComponent(_component_Icon, {
                            name: "external",
                            size: "w-4 h-4 hidden group-hover:block"
                          }, null, _parent2, _scopeId));
                        } else {
                          _push2(`<!---->`);
                        }
                      } else {
                        return [
                          createVNode("span", {
                            class: "absolute left-1/2 top-1/2 size-[max(100%,2.75rem)] -translate-x-1/2 -translate-y-1/2 [@media(pointer:fine)]:hidden",
                            "aria-hidden": "true"
                          }),
                          sub_menu.icon ? (openBlock(), createBlock(_component_Icon, {
                            key: 0,
                            name: sub_menu.icon
                          }, null, 8, ["name"])) : createCommentVNode("", true),
                          createVNode("span", { class: "truncate grow flex-1" }, toDisplayString(sub_menu.label), 1),
                          mainMenu.link ? (openBlock(), createBlock(_component_Icon, {
                            key: 1,
                            name: "external",
                            size: "w-4 h-4 hidden group-hover:block"
                          })) : createCommentVNode("", true)
                        ];
                      }
                    }),
                    _: 2
                  }), _parent);
                  _push(`</span>`);
                } else {
                  _push(`<!---->`);
                }
                _push(`<!--]-->`);
              });
              _push(`<!--]--></div></div></div>`);
            } else if (mainMenu.sub_menu && unref($can)(mainMenu.permissions)) {
              _push(`<div><div class="relative">`);
              if (isCurrentRoute(mainMenu.route, mainMenu.route_prefix)) {
                _push(`<div class="absolute inset-y-0 -left-0 w-0.5 rounded-full bg-gray-950 dark:bg-white" style="${ssrRenderStyle({ "transform": "none", "transform-origin": "50% 50% 0px" })}"></div>`);
              } else {
                _push(`<!---->`);
              }
              _push(`<div${ssrRenderAttr("id", mainMenu.name)} class="${ssrRenderClass([unref(menuState)[mainMenu.name] ? "text-focus font-bold" : "text-mute", "flex w-full items-center gap-3 px-4 py-2.5 text-left text-base/6 sm:py-2 sm:text-sm/5 data-[slot=icon]:*:size-6 data-[slot=icon]:*:shrink-0 data-[slot=icon]:*:fill-gray-500 sm:data-[slot=icon]:*:size-5 data-[slot=icon]:last:*:ml-auto data-[slot=icon]:last:*:size-5 sm:data-[slot=icon]:last:*:size-4 data-[slot=avatar]:*:-m-0.5 data-[slot=avatar]:*:size-7 data-[slot=avatar]:*:[--ring-opacity:10%] sm:data-[slot=avatar]:*:size-6 data-[hover]:bg-gray-950/5 data-[slot=icon]:*:data-[hover]:fill-gray-950 data-[active]:bg-gray-950/5 data-[slot=icon]:*:data-[active]:fill-gray-950 data-[slot=icon]:*:data-[current]:fill-gray-950 dark:text-white dark:data-[slot=icon]:*:fill-gray-400 dark:data-[hover]:bg-white/5 dark:data-[slot=icon]:*:data-[hover]:fill-white dark:data-[active]:bg-white/5 dark:data-[slot=icon]:*:data-[active]:fill-white dark:data-[slot=icon]:*:data-[current]:fill-white"])}"><span class="absolute left-1/2 top-1/2 size-[max(100%,2.75rem)] -translate-x-1/2 -translate-y-1/2 [@media(pointer:fine)]:hidden" aria-hidden="true"></span>`);
              if (mainMenu.icon) {
                _push(ssrRenderComponent(_component_Icon, {
                  name: mainMenu.icon
                }, null, _parent));
              } else {
                _push(`<!---->`);
              }
              _push(`<span class="truncate grow flex-1">${ssrInterpolate(mainMenu.label)}</span></div><!--[-->`);
              ssrRenderList(mainMenu.sub_menu, (sub_menu) => {
                _push(`<!--[-->`);
                if (sub_menu.name == "separator") {
                  _push(`<div class="mx-4 pt-1 mb-1"></div>`);
                } else if (!sub_menu.hidden && (sub_menu.link || unref(T)().has(sub_menu.route))) {
                  _push(`<div class="relative">`);
                  if (!sub_menu.link && isCurrentRoute(sub_menu.route)) {
                    _push(`<span class="absolute inset-y-0 left-0.5 w-0.5 rounded-full bg-gray-950 dark:bg-white" style="${ssrRenderStyle({ "transform": "none", "transform-origin": "50% 50% 0px" })}"></span>`);
                  } else {
                    _push(`<!---->`);
                  }
                  if (unref($can)(sub_menu.permissions)) {
                    ssrRenderVNode(_push, createVNode(resolveDynamicComponent(sub_menu.link ? "a" : unref(Link)), {
                      target: sub_menu.link ? "_blank" : "_self",
                      href: sub_menu.link || unref(T)(sub_menu.route),
                      class: [
                        !mainMenu.link && isCurrentRoute(sub_menu.route) ? "bg-primary-100 dark:bg-primary-800 pointer-events-none" : "hover:bg-primary-50 dark:hover:bg-primary-900",
                        "group flex w-full items-center gap-3 ml-0.5 pl-6 pr-2 py-2.5 text-left text-base/6 font-medium sm:py-2 sm:text-sm/5 data-[slot=icon]:*:size-6 data-[slot=icon]:*:shrink-0 data-[slot=icon]:*:fill-gray-500 sm:data-[slot=icon]:*:size-5 data-[slot=icon]:last:*:ml-auto data-[slot=icon]:last:*:size-5 sm:data-[slot=icon]:last:*:size-4 data-[slot=avatar]:*:-m-0.5 data-[slot=avatar]:*:size-7 data-[slot=avatar]:*:[--ring-opacity:10%] sm:data-[slot=avatar]:*:size-6 data-[hover]:bg-gray-950/5 data-[slot=icon]:*:data-[hover]:fill-gray-950 data-[active]:bg-gray-950/5 data-[slot=icon]:*:data-[active]:fill-gray-950 data-[slot=icon]:*:data-[current]:fill-gray-950 dark:text-white dark:data-[slot=icon]:*:fill-gray-400 dark:data-[hover]:bg-white/5 dark:data-[slot=icon]:*:data-[hover]:fill-white dark:data-[active]:bg-white/5 dark:data-[slot=icon]:*:data-[active]:fill-white dark:data-[slot=icon]:*:data-[current]:fill-white"
                      ]
                    }, {
                      default: withCtx((_, _push2, _parent2, _scopeId) => {
                        if (_push2) {
                          _push2(`<span class="absolute left-1/2 top-1/2 size-[max(100%,2.75rem)] -translate-x-1/2 -translate-y-1/2 [@media(pointer:fine)]:hidden" aria-hidden="true"${_scopeId}></span>`);
                          if (sub_menu.icon) {
                            _push2(ssrRenderComponent(_component_Icon, {
                              name: sub_menu.icon
                            }, null, _parent2, _scopeId));
                          } else {
                            _push2(`<!---->`);
                          }
                          _push2(`<span class="truncate grow flex-1"${_scopeId}>${ssrInterpolate(sub_menu.label)}</span>`);
                          if (mainMenu.link) {
                            _push2(ssrRenderComponent(_component_Icon, {
                              name: "external",
                              size: "w-4 h-4 hidden group-hover:block"
                            }, null, _parent2, _scopeId));
                          } else {
                            _push2(`<!---->`);
                          }
                        } else {
                          return [
                            createVNode("span", {
                              class: "absolute left-1/2 top-1/2 size-[max(100%,2.75rem)] -translate-x-1/2 -translate-y-1/2 [@media(pointer:fine)]:hidden",
                              "aria-hidden": "true"
                            }),
                            sub_menu.icon ? (openBlock(), createBlock(_component_Icon, {
                              key: 0,
                              name: sub_menu.icon
                            }, null, 8, ["name"])) : createCommentVNode("", true),
                            createVNode("span", { class: "truncate grow flex-1" }, toDisplayString(sub_menu.label), 1),
                            mainMenu.link ? (openBlock(), createBlock(_component_Icon, {
                              key: 1,
                              name: "external",
                              size: "w-4 h-4 hidden group-hover:block"
                            })) : createCommentVNode("", true)
                          ];
                        }
                      }),
                      _: 2
                    }), _parent);
                  } else {
                    _push(`<!---->`);
                  }
                  _push(`</div>`);
                } else {
                  _push(`<!---->`);
                }
                _push(`<!--]-->`);
              });
              _push(`<!--]--></div></div>`);
            } else {
              _push(`<!---->`);
            }
            _push(`<!--]-->`);
          });
          _push(`<!--]--></div>`);
        }
        _push(`<!--]-->`);
      });
      _push(`<!--]--></div></nav></div>`);
    };
  }
};
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Layouts/Components/SidebarMenus.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const _sfc_main$1 = {
  __name: "Sidebar",
  __ssrInlineRender: true,
  props: { open: Boolean },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<!--[--><div class="hidden xl:block">`);
      _push(ssrRenderComponent(_sfc_main$2, null, null, _parent));
      _push(`</div>`);
      if (__props.open) {
        _push(ssrRenderComponent(_sfc_main$2, {
          onClose: ($event) => _ctx.$emit("close"),
          class: "z-30"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      if (__props.open) {
        _push(`<div class="xl:hidden relative z-20"><div class="backdrop-blur-sm fixed inset-0 transform transition-all"><div class="absolute inset-0 bg-gray-100 dark:bg-gray-900 opacity-75"></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<!--]-->`);
    };
  }
};
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Layouts/Components/Sidebar.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const _sfc_main = {
  __name: "AdminLayout",
  __ssrInlineRender: true,
  props: { title: String },
  setup(__props) {
    const isSidebarOpen = ref(false);
    return (_ctx, _push, _parent, _attrs) => {
      _push(ssrRenderComponent(_sfc_main$9, _attrs, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="min-h-screen flex flex-col items-stretch justify-stretch"${_scopeId}>`);
            _push2(ssrRenderComponent(_sfc_main$1, {
              open: isSidebarOpen.value,
              onClose: ($event) => isSidebarOpen.value = false
            }, null, _parent2, _scopeId));
            _push2(`<div class="main-contents xl:pl-64 grow self-stretch flex flex-col items-stretch justify-stretch"${_scopeId}><div class="${ssrRenderClass([
              _ctx.$page.props.settings.dark_topbar == 1 ? "dark text-gray-300 bg-gray-900 border-gray-700" : "bg-white dark:bg-gray-900 dark:border-gray-700",
              "top-bar-con sticky top-0 z-10 flex h-16 shrink-0 items-center gap-x-6 px-4 sm:px-6 lg:px-8 border-b"
            ])}"${_scopeId}><button type="button" class="-m-2.5 p-2.5 text-focus xl:hidden"${_scopeId}><span class="sr-only"${_scopeId}>${ssrInterpolate(_ctx.$t("Open Sidebar"))}</span><svg class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true" data-slot="icon"${_scopeId}><path fill-rule="evenodd" d="M2 4.75A.75.75 0 0 1 2.75 4h14.5a.75.75 0 0 1 0 1.5H2.75A.75.75 0 0 1 2 4.75ZM2 10a.75.75 0 0 1 .75-.75h14.5a.75.75 0 0 1 0 1.5H2.75A.75.75 0 0 1 2 10Zm0 5.25a.75.75 0 0 1 .75-.75h14.5a.75.75 0 0 1 0 1.5H2.75a.75.75 0 0 1-.75-.75Z" clip-rule="evenodd"${_scopeId}></path></svg></button>`);
            _push2(ssrRenderComponent(_sfc_main$3, null, null, _parent2, _scopeId));
            _push2(`</div><main class="bg-gray-50 dark:bg-gray-800 grow self-stretch flex flex-col items-stretch justify-stretch"${_scopeId}>`);
            _push2(ssrRenderComponent(_sfc_main$a, null, null, _parent2, _scopeId));
            ssrRenderSlot(_ctx.$slots, "default", {}, null, _push2, _parent2, _scopeId);
            _push2(`</main></div></div>`);
          } else {
            return [
              createVNode("div", { class: "min-h-screen flex flex-col items-stretch justify-stretch" }, [
                createVNode(_sfc_main$1, {
                  open: isSidebarOpen.value,
                  onClose: ($event) => isSidebarOpen.value = false
                }, null, 8, ["open", "onClose"]),
                createVNode("div", { class: "main-contents xl:pl-64 grow self-stretch flex flex-col items-stretch justify-stretch" }, [
                  createVNode("div", {
                    class: [
                      "top-bar-con sticky top-0 z-10 flex h-16 shrink-0 items-center gap-x-6 px-4 sm:px-6 lg:px-8 border-b",
                      _ctx.$page.props.settings.dark_topbar == 1 ? "dark text-gray-300 bg-gray-900 border-gray-700" : "bg-white dark:bg-gray-900 dark:border-gray-700"
                    ]
                  }, [
                    createVNode("button", {
                      type: "button",
                      onClick: ($event) => isSidebarOpen.value = true,
                      class: "-m-2.5 p-2.5 text-focus xl:hidden"
                    }, [
                      createVNode("span", { class: "sr-only" }, toDisplayString(_ctx.$t("Open Sidebar")), 1),
                      (openBlock(), createBlock("svg", {
                        class: "h-5 w-5",
                        viewBox: "0 0 20 20",
                        fill: "currentColor",
                        "aria-hidden": "true",
                        "data-slot": "icon"
                      }, [
                        createVNode("path", {
                          "fill-rule": "evenodd",
                          d: "M2 4.75A.75.75 0 0 1 2.75 4h14.5a.75.75 0 0 1 0 1.5H2.75A.75.75 0 0 1 2 4.75ZM2 10a.75.75 0 0 1 .75-.75h14.5a.75.75 0 0 1 0 1.5H2.75A.75.75 0 0 1 2 10Zm0 5.25a.75.75 0 0 1 .75-.75h14.5a.75.75 0 0 1 0 1.5H2.75a.75.75 0 0 1-.75-.75Z",
                          "clip-rule": "evenodd"
                        })
                      ]))
                    ], 8, ["onClick"]),
                    createVNode(_sfc_main$3)
                  ], 2),
                  createVNode("main", { class: "bg-gray-50 dark:bg-gray-800 grow self-stretch flex flex-col items-stretch justify-stretch" }, [
                    createVNode(_sfc_main$a),
                    renderSlot(_ctx.$slots, "default")
                  ])
                ])
              ])
            ];
          }
        }),
        _: 3
      }, _parent));
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Layouts/AdminLayout.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
