import { mergeProps, unref, withCtx, createBlock, openBlock, Fragment, renderList, createVNode, createCommentVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderSlot, ssrRenderList, ssrRenderClass, ssrInterpolate } from "vue/server-renderer";
import { Head } from "@inertiajs/vue3";
import { NotificationGroup, Notification } from "notiwind";
const _sfc_main = {
  __name: "AppLayout",
  __ssrInlineRender: true,
  props: { title: String },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "" }, _attrs))}>`);
      _push(ssrRenderComponent(unref(Head), { title: __props.title }, null, _parent));
      _push(`<main class="bg-gray-50 dark:bg-gray-800">`);
      ssrRenderSlot(_ctx.$slots, "default", {}, null, _push, _parent);
      _push(`</main>`);
      _push(ssrRenderComponent(unref(NotificationGroup), { group: "main" }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="z-[99] pointer-events-none fixed inset-0 flex items-end px-4 py-6 sm:items-start sm:p-6 print:hidden"${_scopeId}><div class="flex w-full flex-col items-center space-y-4 sm:items-end"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(Notification), {
              enter: "transform ease-out duration-300 transition",
              "enter-from": "translate-y-2 opacity-0 sm:translate-y-0 sm:translate-x-4",
              "enter-to": "translate-y-0 opacity-100 sm:translate-x-0",
              leave: "transition ease-in duration-500",
              "leave-from": "opacity-100",
              "leave-to": "opacity-0",
              move: "transition duration-500",
              "move-delay": "delay-300"
            }, {
              default: withCtx(({ notifications, close }, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<!--[-->`);
                  ssrRenderList(notifications, (notification) => {
                    _push3(`<div class="${ssrRenderClass([
                      notification.type === "success" ? "bg-green-100" : notification.type === "error" ? "bg-red-100" : "bg-white dark:bg-gray-950",
                      "pointer-events-auto w-full max-w-sm overflow-hidden rounded-lg shadow-lg ring-1 ring-black ring-opacity-5"
                    ])}"${_scopeId2}><div class="p-4"${_scopeId2}>`);
                    if (notification.type === "success") {
                      _push3(`<div class="flex items-start text-green-600"${_scopeId2}><div class="flex-shrink-0"${_scopeId2}><svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true"${_scopeId2}><path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z"${_scopeId2}></path></svg></div><div class="ml-3 w-0 flex-1 pt-0.5"${_scopeId2}>`);
                      if (notification.title) {
                        _push3(`<p class="mb-1 text-sm font-medium"${_scopeId2}>${ssrInterpolate(notification.title)}</p>`);
                      } else {
                        _push3(`<!---->`);
                      }
                      _push3(`<p class="text-sm"${_scopeId2}>${notification.text ?? ""}</p></div><div class="ml-4 flex flex-shrink-0"${_scopeId2}><button type="button" class="inline-flex rounded-md text-gray-400 hover:text-gray-500 focus:outline-none focus:ring-0"${_scopeId2}><span class="sr-only"${_scopeId2}>${ssrInterpolate(_ctx.$t("Close"))}</span><svg class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true"${_scopeId2}><path d="M6.28 5.22a.75.75 0 00-1.06 1.06L8.94 10l-3.72 3.72a.75.75 0 101.06 1.06L10 11.06l3.72 3.72a.75.75 0 101.06-1.06L11.06 10l3.72-3.72a.75.75 0 00-1.06-1.06L10 8.94 6.28 5.22z"${_scopeId2}></path></svg></button></div></div>`);
                    } else {
                      _push3(`<!---->`);
                    }
                    if (notification.type === "error") {
                      _push3(`<div class="flex items-start text-red-600"${_scopeId2}><div class="flex-shrink-0"${_scopeId2}><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-6 h-6"${_scopeId2}><path stroke-linecap="round" stroke-linejoin="round" d="m9.75 9.75 4.5 4.5m0-4.5-4.5 4.5M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z"${_scopeId2}></path></svg></div><div class="ml-3 w-0 flex-1 pt-0.5"${_scopeId2}>`);
                      if (notification.title) {
                        _push3(`<p class="mb-1 text-sm font-medium"${_scopeId2}>${ssrInterpolate(notification.title)}</p>`);
                      } else {
                        _push3(`<!---->`);
                      }
                      _push3(`<p class="text-sm"${_scopeId2}>${notification.text ?? ""}</p></div><div class="ml-4 flex flex-shrink-0"${_scopeId2}><button type="button" class="inline-flex rounded-md text-gray-500 hover:text-gray-600 focus:outline-none focus:ring-0"${_scopeId2}><span class="sr-only"${_scopeId2}>${ssrInterpolate(_ctx.$t("Close"))}</span><svg class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true"${_scopeId2}><path d="M6.28 5.22a.75.75 0 00-1.06 1.06L8.94 10l-3.72 3.72a.75.75 0 101.06 1.06L10 11.06l3.72 3.72a.75.75 0 101.06-1.06L11.06 10l3.72-3.72a.75.75 0 00-1.06-1.06L10 8.94 6.28 5.22z"${_scopeId2}></path></svg></button></div></div>`);
                    } else {
                      _push3(`<!---->`);
                    }
                    _push3(`</div></div>`);
                  });
                  _push3(`<!--]-->`);
                } else {
                  return [
                    (openBlock(true), createBlock(Fragment, null, renderList(notifications, (notification) => {
                      return openBlock(), createBlock("div", {
                        key: notification.id,
                        class: [
                          notification.type === "success" ? "bg-green-100" : notification.type === "error" ? "bg-red-100" : "bg-white dark:bg-gray-950",
                          "pointer-events-auto w-full max-w-sm overflow-hidden rounded-lg shadow-lg ring-1 ring-black ring-opacity-5"
                        ]
                      }, [
                        createVNode("div", { class: "p-4" }, [
                          notification.type === "success" ? (openBlock(), createBlock("div", {
                            key: 0,
                            class: "flex items-start text-green-600"
                          }, [
                            createVNode("div", { class: "flex-shrink-0" }, [
                              (openBlock(), createBlock("svg", {
                                class: "h-6 w-6",
                                fill: "none",
                                viewBox: "0 0 24 24",
                                "stroke-width": "1.5",
                                stroke: "currentColor",
                                "aria-hidden": "true"
                              }, [
                                createVNode("path", {
                                  "stroke-linecap": "round",
                                  "stroke-linejoin": "round",
                                  d: "M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z"
                                })
                              ]))
                            ]),
                            createVNode("div", { class: "ml-3 w-0 flex-1 pt-0.5" }, [
                              notification.title ? (openBlock(), createBlock("p", {
                                key: 0,
                                class: "mb-1 text-sm font-medium"
                              }, toDisplayString(notification.title), 1)) : createCommentVNode("", true),
                              createVNode("p", {
                                class: "text-sm",
                                innerHTML: notification.text
                              }, null, 8, ["innerHTML"])
                            ]),
                            createVNode("div", { class: "ml-4 flex flex-shrink-0" }, [
                              createVNode("button", {
                                type: "button",
                                onClick: ($event) => close(notification.id),
                                class: "inline-flex rounded-md text-gray-400 hover:text-gray-500 focus:outline-none focus:ring-0"
                              }, [
                                createVNode("span", { class: "sr-only" }, toDisplayString(_ctx.$t("Close")), 1),
                                (openBlock(), createBlock("svg", {
                                  class: "h-5 w-5",
                                  viewBox: "0 0 20 20",
                                  fill: "currentColor",
                                  "aria-hidden": "true"
                                }, [
                                  createVNode("path", { d: "M6.28 5.22a.75.75 0 00-1.06 1.06L8.94 10l-3.72 3.72a.75.75 0 101.06 1.06L10 11.06l3.72 3.72a.75.75 0 101.06-1.06L11.06 10l3.72-3.72a.75.75 0 00-1.06-1.06L10 8.94 6.28 5.22z" })
                                ]))
                              ], 8, ["onClick"])
                            ])
                          ])) : createCommentVNode("", true),
                          notification.type === "error" ? (openBlock(), createBlock("div", {
                            key: 1,
                            class: "flex items-start text-red-600"
                          }, [
                            createVNode("div", { class: "flex-shrink-0" }, [
                              (openBlock(), createBlock("svg", {
                                xmlns: "http://www.w3.org/2000/svg",
                                fill: "none",
                                viewBox: "0 0 24 24",
                                "stroke-width": "1.5",
                                stroke: "currentColor",
                                class: "w-6 h-6"
                              }, [
                                createVNode("path", {
                                  "stroke-linecap": "round",
                                  "stroke-linejoin": "round",
                                  d: "m9.75 9.75 4.5 4.5m0-4.5-4.5 4.5M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z"
                                })
                              ]))
                            ]),
                            createVNode("div", { class: "ml-3 w-0 flex-1 pt-0.5" }, [
                              notification.title ? (openBlock(), createBlock("p", {
                                key: 0,
                                class: "mb-1 text-sm font-medium"
                              }, toDisplayString(notification.title), 1)) : createCommentVNode("", true),
                              createVNode("p", {
                                class: "text-sm",
                                innerHTML: notification.text
                              }, null, 8, ["innerHTML"])
                            ]),
                            createVNode("div", { class: "ml-4 flex flex-shrink-0" }, [
                              createVNode("button", {
                                type: "button",
                                onClick: ($event) => close(notification.id),
                                class: "inline-flex rounded-md text-gray-500 hover:text-gray-600 focus:outline-none focus:ring-0"
                              }, [
                                createVNode("span", { class: "sr-only" }, toDisplayString(_ctx.$t("Close")), 1),
                                (openBlock(), createBlock("svg", {
                                  class: "h-5 w-5",
                                  viewBox: "0 0 20 20",
                                  fill: "currentColor",
                                  "aria-hidden": "true"
                                }, [
                                  createVNode("path", { d: "M6.28 5.22a.75.75 0 00-1.06 1.06L8.94 10l-3.72 3.72a.75.75 0 101.06 1.06L10 11.06l3.72 3.72a.75.75 0 101.06-1.06L11.06 10l3.72-3.72a.75.75 0 00-1.06-1.06L10 8.94 6.28 5.22z" })
                                ]))
                              ], 8, ["onClick"])
                            ])
                          ])) : createCommentVNode("", true)
                        ])
                      ], 2);
                    }), 128))
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div></div>`);
          } else {
            return [
              createVNode("div", { class: "z-[99] pointer-events-none fixed inset-0 flex items-end px-4 py-6 sm:items-start sm:p-6 print:hidden" }, [
                createVNode("div", { class: "flex w-full flex-col items-center space-y-4 sm:items-end" }, [
                  createVNode(unref(Notification), {
                    enter: "transform ease-out duration-300 transition",
                    "enter-from": "translate-y-2 opacity-0 sm:translate-y-0 sm:translate-x-4",
                    "enter-to": "translate-y-0 opacity-100 sm:translate-x-0",
                    leave: "transition ease-in duration-500",
                    "leave-from": "opacity-100",
                    "leave-to": "opacity-0",
                    move: "transition duration-500",
                    "move-delay": "delay-300"
                  }, {
                    default: withCtx(({ notifications, close }) => [
                      (openBlock(true), createBlock(Fragment, null, renderList(notifications, (notification) => {
                        return openBlock(), createBlock("div", {
                          key: notification.id,
                          class: [
                            notification.type === "success" ? "bg-green-100" : notification.type === "error" ? "bg-red-100" : "bg-white dark:bg-gray-950",
                            "pointer-events-auto w-full max-w-sm overflow-hidden rounded-lg shadow-lg ring-1 ring-black ring-opacity-5"
                          ]
                        }, [
                          createVNode("div", { class: "p-4" }, [
                            notification.type === "success" ? (openBlock(), createBlock("div", {
                              key: 0,
                              class: "flex items-start text-green-600"
                            }, [
                              createVNode("div", { class: "flex-shrink-0" }, [
                                (openBlock(), createBlock("svg", {
                                  class: "h-6 w-6",
                                  fill: "none",
                                  viewBox: "0 0 24 24",
                                  "stroke-width": "1.5",
                                  stroke: "currentColor",
                                  "aria-hidden": "true"
                                }, [
                                  createVNode("path", {
                                    "stroke-linecap": "round",
                                    "stroke-linejoin": "round",
                                    d: "M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z"
                                  })
                                ]))
                              ]),
                              createVNode("div", { class: "ml-3 w-0 flex-1 pt-0.5" }, [
                                notification.title ? (openBlock(), createBlock("p", {
                                  key: 0,
                                  class: "mb-1 text-sm font-medium"
                                }, toDisplayString(notification.title), 1)) : createCommentVNode("", true),
                                createVNode("p", {
                                  class: "text-sm",
                                  innerHTML: notification.text
                                }, null, 8, ["innerHTML"])
                              ]),
                              createVNode("div", { class: "ml-4 flex flex-shrink-0" }, [
                                createVNode("button", {
                                  type: "button",
                                  onClick: ($event) => close(notification.id),
                                  class: "inline-flex rounded-md text-gray-400 hover:text-gray-500 focus:outline-none focus:ring-0"
                                }, [
                                  createVNode("span", { class: "sr-only" }, toDisplayString(_ctx.$t("Close")), 1),
                                  (openBlock(), createBlock("svg", {
                                    class: "h-5 w-5",
                                    viewBox: "0 0 20 20",
                                    fill: "currentColor",
                                    "aria-hidden": "true"
                                  }, [
                                    createVNode("path", { d: "M6.28 5.22a.75.75 0 00-1.06 1.06L8.94 10l-3.72 3.72a.75.75 0 101.06 1.06L10 11.06l3.72 3.72a.75.75 0 101.06-1.06L11.06 10l3.72-3.72a.75.75 0 00-1.06-1.06L10 8.94 6.28 5.22z" })
                                  ]))
                                ], 8, ["onClick"])
                              ])
                            ])) : createCommentVNode("", true),
                            notification.type === "error" ? (openBlock(), createBlock("div", {
                              key: 1,
                              class: "flex items-start text-red-600"
                            }, [
                              createVNode("div", { class: "flex-shrink-0" }, [
                                (openBlock(), createBlock("svg", {
                                  xmlns: "http://www.w3.org/2000/svg",
                                  fill: "none",
                                  viewBox: "0 0 24 24",
                                  "stroke-width": "1.5",
                                  stroke: "currentColor",
                                  class: "w-6 h-6"
                                }, [
                                  createVNode("path", {
                                    "stroke-linecap": "round",
                                    "stroke-linejoin": "round",
                                    d: "m9.75 9.75 4.5 4.5m0-4.5-4.5 4.5M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z"
                                  })
                                ]))
                              ]),
                              createVNode("div", { class: "ml-3 w-0 flex-1 pt-0.5" }, [
                                notification.title ? (openBlock(), createBlock("p", {
                                  key: 0,
                                  class: "mb-1 text-sm font-medium"
                                }, toDisplayString(notification.title), 1)) : createCommentVNode("", true),
                                createVNode("p", {
                                  class: "text-sm",
                                  innerHTML: notification.text
                                }, null, 8, ["innerHTML"])
                              ]),
                              createVNode("div", { class: "ml-4 flex flex-shrink-0" }, [
                                createVNode("button", {
                                  type: "button",
                                  onClick: ($event) => close(notification.id),
                                  class: "inline-flex rounded-md text-gray-500 hover:text-gray-600 focus:outline-none focus:ring-0"
                                }, [
                                  createVNode("span", { class: "sr-only" }, toDisplayString(_ctx.$t("Close")), 1),
                                  (openBlock(), createBlock("svg", {
                                    class: "h-5 w-5",
                                    viewBox: "0 0 20 20",
                                    fill: "currentColor",
                                    "aria-hidden": "true"
                                  }, [
                                    createVNode("path", { d: "M6.28 5.22a.75.75 0 00-1.06 1.06L8.94 10l-3.72 3.72a.75.75 0 101.06 1.06L10 11.06l3.72 3.72a.75.75 0 101.06-1.06L11.06 10l3.72-3.72a.75.75 0 00-1.06-1.06L10 8.94 6.28 5.22z" })
                                  ]))
                                ], 8, ["onClick"])
                              ])
                            ])) : createCommentVNode("", true)
                          ])
                        ], 2);
                      }), 128))
                    ]),
                    _: 1
                  })
                ])
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(NotificationGroup), { group: "mobile" }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="z-[99] pointer-events-none fixed inset-0 flex items-start px-4 py-6 sm:p-6 lg:hidden print:hidden"${_scopeId}><div class="flex w-full flex-col items-end space-y-4"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(Notification), {
              enter: "transform ease-out duration-300 transition",
              "enter-from": "translate-y-2 opacity-0 sm:translate-y-0 sm:translate-x-4",
              "enter-to": "translate-y-0 opacity-100 sm:translate-x-0",
              leave: "transition ease-in duration-500",
              "leave-from": "opacity-100",
              "leave-to": "opacity-0",
              move: "transition duration-500",
              "move-delay": "delay-300"
            }, {
              default: withCtx(({ notifications, close }, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<!--[-->`);
                  ssrRenderList(notifications, (notification) => {
                    _push3(`<div class="${ssrRenderClass([
                      notification.type === "success" ? "bg-green-100" : notification.type === "error" ? "bg-red-100" : "bg-white dark:bg-gray-950",
                      "pointer-events-auto w-full max-w-[350px] overflow-hidden rounded-lg shadow-lg ring-1 ring-black ring-opacity-5"
                    ])}"${_scopeId2}><div class="p-4"${_scopeId2}>`);
                    if (notification.type === "success") {
                      _push3(`<div class="flex items-start text-green-600"${_scopeId2}><div class="flex-shrink-0"${_scopeId2}><svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true"${_scopeId2}><path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z"${_scopeId2}></path></svg></div><div class="ml-3 w-0 flex-1 pt-0.5"${_scopeId2}>`);
                      if (notification.title) {
                        _push3(`<p class="mb-1 text-sm font-medium"${_scopeId2}>${ssrInterpolate(notification.title)}</p>`);
                      } else {
                        _push3(`<!---->`);
                      }
                      _push3(`<p class="text-sm"${_scopeId2}>${notification.text ?? ""}</p></div><div class="ml-4 flex flex-shrink-0"${_scopeId2}><button type="button" class="inline-flex rounded-md text-gray-400 hover:text-gray-500 focus:outline-none focus:ring-0"${_scopeId2}><span class="sr-only"${_scopeId2}>${ssrInterpolate(_ctx.$t("Close"))}</span><svg class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true"${_scopeId2}><path d="M6.28 5.22a.75.75 0 00-1.06 1.06L8.94 10l-3.72 3.72a.75.75 0 101.06 1.06L10 11.06l3.72 3.72a.75.75 0 101.06-1.06L11.06 10l3.72-3.72a.75.75 0 00-1.06-1.06L10 8.94 6.28 5.22z"${_scopeId2}></path></svg></button></div></div>`);
                    } else {
                      _push3(`<!---->`);
                    }
                    if (notification.type === "error") {
                      _push3(`<div class="flex items-start text-red-600"${_scopeId2}><div class="flex-shrink-0"${_scopeId2}><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-6 h-6"${_scopeId2}><path stroke-linecap="round" stroke-linejoin="round" d="m9.75 9.75 4.5 4.5m0-4.5-4.5 4.5M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z"${_scopeId2}></path></svg></div><div class="ml-3 w-0 flex-1 pt-0.5"${_scopeId2}>`);
                      if (notification.title) {
                        _push3(`<p class="mb-1 text-sm font-medium"${_scopeId2}>${ssrInterpolate(notification.title)}</p>`);
                      } else {
                        _push3(`<!---->`);
                      }
                      _push3(`<p class="text-sm"${_scopeId2}>${notification.text ?? ""}</p></div><div class="ml-4 flex flex-shrink-0"${_scopeId2}><button type="button" class="inline-flex rounded-md text-gray-500 hover:text-gray-600 focus:outline-none focus:ring-0"${_scopeId2}><span class="sr-only"${_scopeId2}>${ssrInterpolate(_ctx.$t("Close"))}</span><svg class="h-5 w-5" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true"${_scopeId2}><path d="M6.28 5.22a.75.75 0 00-1.06 1.06L8.94 10l-3.72 3.72a.75.75 0 101.06 1.06L10 11.06l3.72 3.72a.75.75 0 101.06-1.06L11.06 10l3.72-3.72a.75.75 0 00-1.06-1.06L10 8.94 6.28 5.22z"${_scopeId2}></path></svg></button></div></div>`);
                    } else {
                      _push3(`<!---->`);
                    }
                    _push3(`</div></div>`);
                  });
                  _push3(`<!--]-->`);
                } else {
                  return [
                    (openBlock(true), createBlock(Fragment, null, renderList(notifications, (notification) => {
                      return openBlock(), createBlock("div", {
                        key: notification.id,
                        class: [
                          notification.type === "success" ? "bg-green-100" : notification.type === "error" ? "bg-red-100" : "bg-white dark:bg-gray-950",
                          "pointer-events-auto w-full max-w-[350px] overflow-hidden rounded-lg shadow-lg ring-1 ring-black ring-opacity-5"
                        ]
                      }, [
                        createVNode("div", { class: "p-4" }, [
                          notification.type === "success" ? (openBlock(), createBlock("div", {
                            key: 0,
                            class: "flex items-start text-green-600"
                          }, [
                            createVNode("div", { class: "flex-shrink-0" }, [
                              (openBlock(), createBlock("svg", {
                                class: "h-6 w-6",
                                fill: "none",
                                viewBox: "0 0 24 24",
                                "stroke-width": "1.5",
                                stroke: "currentColor",
                                "aria-hidden": "true"
                              }, [
                                createVNode("path", {
                                  "stroke-linecap": "round",
                                  "stroke-linejoin": "round",
                                  d: "M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z"
                                })
                              ]))
                            ]),
                            createVNode("div", { class: "ml-3 w-0 flex-1 pt-0.5" }, [
                              notification.title ? (openBlock(), createBlock("p", {
                                key: 0,
                                class: "mb-1 text-sm font-medium"
                              }, toDisplayString(notification.title), 1)) : createCommentVNode("", true),
                              createVNode("p", {
                                class: "text-sm",
                                innerHTML: notification.text
                              }, null, 8, ["innerHTML"])
                            ]),
                            createVNode("div", { class: "ml-4 flex flex-shrink-0" }, [
                              createVNode("button", {
                                type: "button",
                                onClick: ($event) => close(notification.id),
                                class: "inline-flex rounded-md text-gray-400 hover:text-gray-500 focus:outline-none focus:ring-0"
                              }, [
                                createVNode("span", { class: "sr-only" }, toDisplayString(_ctx.$t("Close")), 1),
                                (openBlock(), createBlock("svg", {
                                  class: "h-5 w-5",
                                  viewBox: "0 0 20 20",
                                  fill: "currentColor",
                                  "aria-hidden": "true"
                                }, [
                                  createVNode("path", { d: "M6.28 5.22a.75.75 0 00-1.06 1.06L8.94 10l-3.72 3.72a.75.75 0 101.06 1.06L10 11.06l3.72 3.72a.75.75 0 101.06-1.06L11.06 10l3.72-3.72a.75.75 0 00-1.06-1.06L10 8.94 6.28 5.22z" })
                                ]))
                              ], 8, ["onClick"])
                            ])
                          ])) : createCommentVNode("", true),
                          notification.type === "error" ? (openBlock(), createBlock("div", {
                            key: 1,
                            class: "flex items-start text-red-600"
                          }, [
                            createVNode("div", { class: "flex-shrink-0" }, [
                              (openBlock(), createBlock("svg", {
                                xmlns: "http://www.w3.org/2000/svg",
                                fill: "none",
                                viewBox: "0 0 24 24",
                                "stroke-width": "1.5",
                                stroke: "currentColor",
                                class: "w-6 h-6"
                              }, [
                                createVNode("path", {
                                  "stroke-linecap": "round",
                                  "stroke-linejoin": "round",
                                  d: "m9.75 9.75 4.5 4.5m0-4.5-4.5 4.5M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z"
                                })
                              ]))
                            ]),
                            createVNode("div", { class: "ml-3 w-0 flex-1 pt-0.5" }, [
                              notification.title ? (openBlock(), createBlock("p", {
                                key: 0,
                                class: "mb-1 text-sm font-medium"
                              }, toDisplayString(notification.title), 1)) : createCommentVNode("", true),
                              createVNode("p", {
                                class: "text-sm",
                                innerHTML: notification.text
                              }, null, 8, ["innerHTML"])
                            ]),
                            createVNode("div", { class: "ml-4 flex flex-shrink-0" }, [
                              createVNode("button", {
                                type: "button",
                                onClick: ($event) => close(notification.id),
                                class: "inline-flex rounded-md text-gray-500 hover:text-gray-600 focus:outline-none focus:ring-0"
                              }, [
                                createVNode("span", { class: "sr-only" }, toDisplayString(_ctx.$t("Close")), 1),
                                (openBlock(), createBlock("svg", {
                                  class: "h-5 w-5",
                                  viewBox: "0 0 20 20",
                                  fill: "currentColor",
                                  "aria-hidden": "true"
                                }, [
                                  createVNode("path", { d: "M6.28 5.22a.75.75 0 00-1.06 1.06L8.94 10l-3.72 3.72a.75.75 0 101.06 1.06L10 11.06l3.72 3.72a.75.75 0 101.06-1.06L11.06 10l3.72-3.72a.75.75 0 00-1.06-1.06L10 8.94 6.28 5.22z" })
                                ]))
                              ], 8, ["onClick"])
                            ])
                          ])) : createCommentVNode("", true)
                        ])
                      ], 2);
                    }), 128))
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div></div>`);
          } else {
            return [
              createVNode("div", { class: "z-[99] pointer-events-none fixed inset-0 flex items-start px-4 py-6 sm:p-6 lg:hidden print:hidden" }, [
                createVNode("div", { class: "flex w-full flex-col items-end space-y-4" }, [
                  createVNode(unref(Notification), {
                    enter: "transform ease-out duration-300 transition",
                    "enter-from": "translate-y-2 opacity-0 sm:translate-y-0 sm:translate-x-4",
                    "enter-to": "translate-y-0 opacity-100 sm:translate-x-0",
                    leave: "transition ease-in duration-500",
                    "leave-from": "opacity-100",
                    "leave-to": "opacity-0",
                    move: "transition duration-500",
                    "move-delay": "delay-300"
                  }, {
                    default: withCtx(({ notifications, close }) => [
                      (openBlock(true), createBlock(Fragment, null, renderList(notifications, (notification) => {
                        return openBlock(), createBlock("div", {
                          key: notification.id,
                          class: [
                            notification.type === "success" ? "bg-green-100" : notification.type === "error" ? "bg-red-100" : "bg-white dark:bg-gray-950",
                            "pointer-events-auto w-full max-w-[350px] overflow-hidden rounded-lg shadow-lg ring-1 ring-black ring-opacity-5"
                          ]
                        }, [
                          createVNode("div", { class: "p-4" }, [
                            notification.type === "success" ? (openBlock(), createBlock("div", {
                              key: 0,
                              class: "flex items-start text-green-600"
                            }, [
                              createVNode("div", { class: "flex-shrink-0" }, [
                                (openBlock(), createBlock("svg", {
                                  class: "h-6 w-6",
                                  fill: "none",
                                  viewBox: "0 0 24 24",
                                  "stroke-width": "1.5",
                                  stroke: "currentColor",
                                  "aria-hidden": "true"
                                }, [
                                  createVNode("path", {
                                    "stroke-linecap": "round",
                                    "stroke-linejoin": "round",
                                    d: "M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z"
                                  })
                                ]))
                              ]),
                              createVNode("div", { class: "ml-3 w-0 flex-1 pt-0.5" }, [
                                notification.title ? (openBlock(), createBlock("p", {
                                  key: 0,
                                  class: "mb-1 text-sm font-medium"
                                }, toDisplayString(notification.title), 1)) : createCommentVNode("", true),
                                createVNode("p", {
                                  class: "text-sm",
                                  innerHTML: notification.text
                                }, null, 8, ["innerHTML"])
                              ]),
                              createVNode("div", { class: "ml-4 flex flex-shrink-0" }, [
                                createVNode("button", {
                                  type: "button",
                                  onClick: ($event) => close(notification.id),
                                  class: "inline-flex rounded-md text-gray-400 hover:text-gray-500 focus:outline-none focus:ring-0"
                                }, [
                                  createVNode("span", { class: "sr-only" }, toDisplayString(_ctx.$t("Close")), 1),
                                  (openBlock(), createBlock("svg", {
                                    class: "h-5 w-5",
                                    viewBox: "0 0 20 20",
                                    fill: "currentColor",
                                    "aria-hidden": "true"
                                  }, [
                                    createVNode("path", { d: "M6.28 5.22a.75.75 0 00-1.06 1.06L8.94 10l-3.72 3.72a.75.75 0 101.06 1.06L10 11.06l3.72 3.72a.75.75 0 101.06-1.06L11.06 10l3.72-3.72a.75.75 0 00-1.06-1.06L10 8.94 6.28 5.22z" })
                                  ]))
                                ], 8, ["onClick"])
                              ])
                            ])) : createCommentVNode("", true),
                            notification.type === "error" ? (openBlock(), createBlock("div", {
                              key: 1,
                              class: "flex items-start text-red-600"
                            }, [
                              createVNode("div", { class: "flex-shrink-0" }, [
                                (openBlock(), createBlock("svg", {
                                  xmlns: "http://www.w3.org/2000/svg",
                                  fill: "none",
                                  viewBox: "0 0 24 24",
                                  "stroke-width": "1.5",
                                  stroke: "currentColor",
                                  class: "w-6 h-6"
                                }, [
                                  createVNode("path", {
                                    "stroke-linecap": "round",
                                    "stroke-linejoin": "round",
                                    d: "m9.75 9.75 4.5 4.5m0-4.5-4.5 4.5M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z"
                                  })
                                ]))
                              ]),
                              createVNode("div", { class: "ml-3 w-0 flex-1 pt-0.5" }, [
                                notification.title ? (openBlock(), createBlock("p", {
                                  key: 0,
                                  class: "mb-1 text-sm font-medium"
                                }, toDisplayString(notification.title), 1)) : createCommentVNode("", true),
                                createVNode("p", {
                                  class: "text-sm",
                                  innerHTML: notification.text
                                }, null, 8, ["innerHTML"])
                              ]),
                              createVNode("div", { class: "ml-4 flex flex-shrink-0" }, [
                                createVNode("button", {
                                  type: "button",
                                  onClick: ($event) => close(notification.id),
                                  class: "inline-flex rounded-md text-gray-500 hover:text-gray-600 focus:outline-none focus:ring-0"
                                }, [
                                  createVNode("span", { class: "sr-only" }, toDisplayString(_ctx.$t("Close")), 1),
                                  (openBlock(), createBlock("svg", {
                                    class: "h-5 w-5",
                                    viewBox: "0 0 20 20",
                                    fill: "currentColor",
                                    "aria-hidden": "true"
                                  }, [
                                    createVNode("path", { d: "M6.28 5.22a.75.75 0 00-1.06 1.06L8.94 10l-3.72 3.72a.75.75 0 101.06 1.06L10 11.06l3.72 3.72a.75.75 0 101.06-1.06L11.06 10l3.72-3.72a.75.75 0 00-1.06-1.06L10 8.94 6.28 5.22z" })
                                  ]))
                                ], 8, ["onClick"])
                              ])
                            ])) : createCommentVNode("", true)
                          ])
                        ], 2);
                      }), 128))
                    ]),
                    _: 1
                  })
                ])
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Layouts/AppLayout.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
