import { ref, reactive, withCtx, createTextVNode, toDisplayString, createVNode, withKeys, nextTick, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderSlot, ssrRenderComponent, ssrInterpolate } from "vue/server-renderer";
import { a as _sfc_main$1 } from "./ActionSection-DLY4AkI5.js";
import { _ as _sfc_main$4, a as _sfc_main$5 } from "./InputError-DjBtKS5r.js";
import { _ as _sfc_main$3 } from "./PrimaryButton-BFULsO35.js";
import { _ as _sfc_main$2 } from "./SecondaryButton-CI1uhr4A.js";
const _sfc_main = {
  __name: "ConfirmsPassword",
  __ssrInlineRender: true,
  props: {
    title: { type: String },
    content: { type: String },
    button: { type: String }
  },
  emits: ["confirmed"],
  setup(__props, { emit: __emit }) {
    const emit = __emit;
    const confirmingPassword = ref(false);
    const form = reactive({
      password: "",
      error: "",
      processing: false
    });
    const passwordInput = ref(null);
    const confirmPassword = () => {
      form.processing = true;
      axios.post(route("password.confirm"), {
        password: form.password
      }).then(() => {
        form.processing = false;
        closeModal();
        nextTick().then(() => emit("confirmed"));
      }).catch((error) => {
        form.processing = false;
        form.error = error.response.data.errors.password[0];
        passwordInput.value.focus();
      });
    };
    const closeModal = () => {
      confirmingPassword.value = false;
      form.password = "";
      form.error = "";
    };
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<span${ssrRenderAttrs(_attrs)}><span>`);
      ssrRenderSlot(_ctx.$slots, "default", {}, null, _push, _parent);
      _push(`</span>`);
      _push(ssrRenderComponent(_sfc_main$1, {
        show: confirmingPassword.value,
        onClose: closeModal,
        maxWidth: "md"
      }, {
        title: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(__props.title || _ctx.$t("Confirm Password"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(__props.title || _ctx.$t("Confirm Password")), 1)
            ];
          }
        }),
        content: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(__props.content || _ctx.$t("For your security, please confirm your password to continue."))} <div class="mt-4"${_scopeId}>`);
            _push2(ssrRenderComponent(_sfc_main$4, {
              type: "password",
              ref_key: "passwordInput",
              ref: passwordInput,
              placeholder: "Password",
              modelValue: form.password,
              "onUpdate:modelValue": ($event) => form.password = $event,
              class: "mt-1 block w-full",
              autocomplete: "current-password",
              onKeyup: confirmPassword
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(_sfc_main$5, {
              message: form.error,
              class: "mt-2"
            }, null, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createTextVNode(toDisplayString(__props.content || _ctx.$t("For your security, please confirm your password to continue.")) + " ", 1),
              createVNode("div", { class: "mt-4" }, [
                createVNode(_sfc_main$4, {
                  type: "password",
                  ref_key: "passwordInput",
                  ref: passwordInput,
                  placeholder: "Password",
                  modelValue: form.password,
                  "onUpdate:modelValue": ($event) => form.password = $event,
                  class: "mt-1 block w-full",
                  autocomplete: "current-password",
                  onKeyup: withKeys(confirmPassword, ["enter"])
                }, null, 8, ["modelValue", "onUpdate:modelValue"]),
                createVNode(_sfc_main$5, {
                  message: form.error,
                  class: "mt-2"
                }, null, 8, ["message"])
              ])
            ];
          }
        }),
        footer: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_sfc_main$2, { onClick: closeModal }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Cancel"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Cancel")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(ssrRenderComponent(_sfc_main$3, {
              class: ["ms-3", { "opacity-25": form.processing }],
              disabled: form.processing,
              onClick: confirmPassword
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(__props.button || _ctx.$t("Confirm"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(__props.button || _ctx.$t("Confirm")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_sfc_main$2, { onClick: closeModal }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(_ctx.$t("Cancel")), 1)
                ]),
                _: 1
              }),
              createVNode(_sfc_main$3, {
                class: ["ms-3", { "opacity-25": form.processing }],
                disabled: form.processing,
                onClick: confirmPassword
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(__props.button || _ctx.$t("Confirm")), 1)
                ]),
                _: 1
              }, 8, ["class", "disabled"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</span>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Components/Jet/ConfirmsPassword.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as _
};
