import { ref, watch, onMounted, resolveComponent, withCtx, createVNode, unref, toDisplayString, createTextVNode, createBlock, createCommentVNode, openBlock, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderClass, ssrIncludeBooleanAttr } from "vue/server-renderer";
import dayjs from "dayjs";
import { T } from "../ssr.js";
import { useI18n } from "vue-i18n";
import { usePage } from "@inertiajs/vue3";
import ApexCharts from "vue3-apexcharts";
import isToday from "dayjs/plugin/isToday.js";
import isYesterday from "dayjs/plugin/isYesterday.js";
import LocalizedFormat from "dayjs/plugin/LocalizedFormat";
import { $ as $currency, a as axios, _ as _sfc_main$2, b as _sfc_main$3 } from "./http-CDixhmav.js";
import "lodash.debounce";
import "./LoadingButton-DREeyNQW.js";
import { _ as _sfc_main$1 } from "./AdminLayout-DHH3IgME.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./SectionTitle-CrLwNK7a.js";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./InputError-DjBtKS5r.js";
import "./PrimaryButton-BFULsO35.js";
import "./SecondaryButton-CI1uhr4A.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputLabel-DXl8D0gR.js";
import "@vuepic/vue-datepicker";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
import "./AppLayout-BRHmSgDa.js";
const _sfc_main = /* @__PURE__ */ Object.assign({ layout: _sfc_main$1 }, {
  __name: "Dashboard",
  __ssrInlineRender: true,
  setup(__props) {
    var _a;
    dayjs.extend(isToday);
    dayjs.extend(isYesterday);
    dayjs.extend(LocalizedFormat);
    const page = usePage();
    const { t } = useI18n({});
    const data = ref({});
    const data_days = ref(7);
    const loading = ref("true");
    const loadingChart = ref("true");
    const year = ref(dayjs().year());
    const sparkType = ref(((_a = page.props.settings) == null ? void 0 : _a.chart_type) || "area");
    ref(document.querySelector("html").style.colorScheme);
    const barSeries = ref([]);
    const barChartOptions = ref({
      chart: {
        type: "bar",
        height: 450,
        toolbar: {
          show: false
        }
      },
      plotOptions: {
        bar: {
          horizontal: false,
          columnWidth: "55%",
          borderRadius: 5,
          borderRadiusApplication: "end"
        }
      },
      dataLabels: {
        enabled: false
      },
      stroke: {
        show: true,
        width: 2,
        colors: ["transparent"]
      },
      xaxis: {
        categories: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
      },
      yaxis: {
        labels: {
          formatter: function(value) {
            return value;
          }
        }
      },
      fill: {
        opacity: 1
      },
      tooltip: {
        theme: false,
        shared: true,
        intersect: false,
        followCursor: false,
        marker: {
          show: false
        },
        y: {
          formatter: function(val) {
            return $currency(val);
          }
        }
      }
    });
    const salesSpark = ref([]);
    const paymentsSpark = ref([]);
    const expensesSpark = ref([]);
    const purchasesSpark = ref([]);
    const salesSparkOptions = ref({});
    const expensesSparkOptions = ref({});
    const paymentsSparkOptions = ref({});
    const purchasesSparkOptions = ref({});
    const sparkChartOptions = ref({
      chart: {
        type: "bar",
        height: 100,
        sparkline: { enabled: true }
      },
      plotOptions: {
        bar: {
          borderRadius: 5,
          borderRadiusApplication: "end"
        }
      },
      xaxis: {
        type: "datetime",
        labels: {
          formatter: function(value, timestamp) {
            return new Date(timestamp).toLocaleString(window.Locale, { timeZone: "UTC", dateStyle: "medium" });
          }
        }
      },
      tooltip: {
        theme: false,
        marker: { show: false },
        y: {
          formatter: function(y) {
            return y ? $currency(y) : y;
          }
        }
      },
      labels: []
    });
    watch(year, () => getChartData(year.value));
    onMounted(() => {
      getChartData(year.value);
      getDashboardData(data_days.value);
    });
    async function getChartData() {
      loadingChart.value = true;
      await axios.get(T("dashboard.chart", { year: year.value })).then((res) => {
        var _a2, _b, _c, _d, _e;
        barSeries.value = [
          {
            name: t("Sales"),
            data: Object.values(((_a2 = res.data) == null ? void 0 : _a2.sales) || {}) || []
          },
          {
            name: t("Purchases"),
            data: Object.values(((_b = res.data) == null ? void 0 : _b.purchases) || {}) || []
          },
          {
            name: t("Payments"),
            data: Object.values(((_c = res.data) == null ? void 0 : _c.payments) || {}) || []
          },
          {
            name: t("Expenses"),
            data: Object.values(((_d = res.data) == null ? void 0 : _d.expenses) || {}) || []
          }
        ];
        barChartOptions.value = {
          ...barChartOptions.value,
          xaxis: { ...barChartOptions.value.xaxis, categories: (_e = res.data) == null ? void 0 : _e.months }
        };
      }).finally(() => loadingChart.value = false);
    }
    async function getDashboardData(days) {
      var _a2, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p;
      loading.value = true;
      data_days.value = days;
      await axios.get(T("dashboard.data") + "?days=" + (data_days.value === void 0 ? "" : data_days.value)).then((res) => data.value = res.data);
      if (data_days.value) {
        salesSpark.value = [
          {
            name: t("Sales"),
            data: Object.values(((_b = (_a2 = data.value) == null ? void 0 : _a2.spark) == null ? void 0 : _b.sales) || {}) || []
          }
        ];
        salesSparkOptions.value = {
          ...sparkChartOptions.value,
          labels: Object.keys(((_d = (_c = data.value) == null ? void 0 : _c.spark) == null ? void 0 : _d.sales) || {}) || []
        };
        purchasesSpark.value = [
          {
            name: t("Purchases"),
            data: Object.values(((_f = (_e = data.value) == null ? void 0 : _e.spark) == null ? void 0 : _f.purchases) || {}) || []
          }
        ];
        purchasesSparkOptions.value = {
          ...sparkChartOptions.value,
          labels: Object.keys(((_h = (_g = data.value) == null ? void 0 : _g.spark) == null ? void 0 : _h.purchases) || {}) || []
        };
        paymentsSpark.value = [
          {
            name: t("Payments"),
            data: Object.values(((_j = (_i = data.value) == null ? void 0 : _i.spark) == null ? void 0 : _j.payments) || {}) || []
          }
        ];
        paymentsSparkOptions.value = {
          ...sparkChartOptions.value,
          labels: Object.keys(((_l = (_k = data.value) == null ? void 0 : _k.spark) == null ? void 0 : _l.payments) || {}) || [],
          tooltip: {
            ...sparkChartOptions.value.tooltip,
            y: {
              formatter: function(y) {
                if (y !== void 0) {
                  if (y < 0) {
                    return t("Sent") + ": " + $currency(0 - y);
                  }
                  return t("Received") + ": " + $currency(y);
                }
                return y;
              }
            }
          }
        };
        expensesSpark.value = [
          {
            name: t("Expenses"),
            data: Object.values(((_n = (_m = data.value) == null ? void 0 : _m.spark) == null ? void 0 : _n.expenses) || {}) || []
          }
        ];
        expensesSparkOptions.value = {
          ...sparkChartOptions.value,
          labels: Object.keys(((_p = (_o = data.value) == null ? void 0 : _o.spark) == null ? void 0 : _p.expenses) || {}) || []
        };
      } else {
        salesSpark.value = [];
        expensesSpark.value = [];
        paymentsSpark.value = [];
        purchasesSpark.value = [];
        salesSparkOptions.value = { ...sparkChartOptions.value, labels: [] };
        expensesSparkOptions.value = { ...sparkChartOptions.value, labels: [] };
        paymentsSparkOptions.value = { ...sparkChartOptions.value, labels: [] };
        purchasesSparkOptions.value = { ...sparkChartOptions.value, labels: [] };
      }
      loading.value = false;
    }
    return (_ctx, _push, _parent, _attrs) => {
      var _a2, _b, _c, _d, _e, _f, _g, _h;
      const _component_Head = resolveComponent("Head");
      const _component_Header = resolveComponent("Header");
      const _component_Link = resolveComponent("Link");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_Head, null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<title${_scopeId}>Dashboard</title>`);
          } else {
            return [
              createVNode("title", null, "Dashboard")
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_Header, null, {
        menu: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex items-center justify-end gap-4"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_Link, {
              href: unref(T)("sales.create"),
              class: "flex items-center gap-x-1 rounded-md px-3 py-2 text-sm font-semibold hover:bg-gray-100 dark:hover:bg-gray-700"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(unref(t)("Add new sale"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(unref(t)("Add new sale")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            if (unref(T)().has("pos")) {
              _push2(ssrRenderComponent(_component_Link, {
                href: unref(T)("pos"),
                class: "btn-primary"
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(unref(t)("POS"))}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(unref(t)("POS")), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              _push2(`<!---->`);
            }
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "flex items-center justify-end gap-4" }, [
                createVNode(_component_Link, {
                  href: unref(T)("sales.create"),
                  class: "flex items-center gap-x-1 rounded-md px-3 py-2 text-sm font-semibold hover:bg-gray-100 dark:hover:bg-gray-700"
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(unref(t)("Add new sale")), 1)
                  ]),
                  _: 1
                }, 8, ["href"]),
                unref(T)().has("pos") ? (openBlock(), createBlock(_component_Link, {
                  key: 0,
                  href: unref(T)("pos"),
                  class: "btn-primary"
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(unref(t)("POS")), 1)
                  ]),
                  _: 1
                }, 8, ["href"])) : createCommentVNode("", true)
              ])
            ];
          }
        }),
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="w-full flex flex-wrap items-center gap-6 sm:flex-nowrap"${_scopeId}><h1 class="text-base font-bold leading-7 text-gray-900 dark:text-gray-100"${_scopeId}>${ssrInterpolate(unref(t)("Overview"))}</h1><div class="order-last flex w-full gap-x-8 text-sm font-semibold leading-6 sm:order-none sm:w-auto sm:border-l sm:border-gray-200 dark:sm:border-gray-700 sm:pl-6 sm:leading-7"${_scopeId}><button type="button"${ssrIncludeBooleanAttr(data_days.value == 7) ? " disabled" : ""} class="${ssrRenderClass(data_days.value == 7 ? "link" : "")}"${_scopeId}>${ssrInterpolate(unref(t)("Last 7 days"))}</button><button type="button"${ssrIncludeBooleanAttr(data_days.value == 30) ? " disabled" : ""} class="${ssrRenderClass(data_days.value == 30 ? "link" : "")}"${_scopeId}>${ssrInterpolate(unref(t)("Last 30 days"))}</button><button type="button"${ssrIncludeBooleanAttr(data_days.value == 60) ? " disabled" : ""} class="${ssrRenderClass(data_days.value == 60 ? "link" : "")}"${_scopeId}>${ssrInterpolate(unref(t)("Last 60 days"))}</button><button type="button"${ssrIncludeBooleanAttr(data_days.value === void 0) ? " disabled" : ""} class="${ssrRenderClass(data_days.value === void 0 ? "link" : "")}"${_scopeId}>${ssrInterpolate(unref(t)("All-time"))}</button></div></div>`);
          } else {
            return [
              createVNode("div", { class: "w-full flex flex-wrap items-center gap-6 sm:flex-nowrap" }, [
                createVNode("h1", { class: "text-base font-bold leading-7 text-gray-900 dark:text-gray-100" }, toDisplayString(unref(t)("Overview")), 1),
                createVNode("div", { class: "order-last flex w-full gap-x-8 text-sm font-semibold leading-6 sm:order-none sm:w-auto sm:border-l sm:border-gray-200 dark:sm:border-gray-700 sm:pl-6 sm:leading-7" }, [
                  createVNode("button", {
                    type: "button",
                    disabled: data_days.value == 7,
                    onClick: ($event) => getDashboardData(7),
                    class: data_days.value == 7 ? "link" : ""
                  }, toDisplayString(unref(t)("Last 7 days")), 11, ["disabled", "onClick"]),
                  createVNode("button", {
                    type: "button",
                    disabled: data_days.value == 30,
                    onClick: ($event) => getDashboardData(30),
                    class: data_days.value == 30 ? "link" : ""
                  }, toDisplayString(unref(t)("Last 30 days")), 11, ["disabled", "onClick"]),
                  createVNode("button", {
                    type: "button",
                    disabled: data_days.value == 60,
                    onClick: ($event) => getDashboardData(60),
                    class: data_days.value == 60 ? "link" : ""
                  }, toDisplayString(unref(t)("Last 60 days")), 11, ["disabled", "onClick"]),
                  createVNode("button", {
                    type: "button",
                    onClick: ($event) => getDashboardData(),
                    disabled: data_days.value === void 0,
                    class: data_days.value === void 0 ? "link" : ""
                  }, toDisplayString(unref(t)("All-time")), 11, ["onClick", "disabled"])
                ])
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<div>`);
      if (loading.value) {
        _push(`<div class="relative h-64 flex items-center justify-center">`);
        _push(ssrRenderComponent(unref(_sfc_main$2), { loadingClass: "h-10 w-10" }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<dl class="mx-auto grid grid-cols-1 gap-px bg-gray-200 dark:bg-gray-700 sm:grid-cols-2 lg:grid-cols-4 border-b border-gray-200 dark:border-gray-700"><div class="flex flex-wrap items-baseline justify-between gap-x-4 gap-y-2 bg-white dark:bg-gray-900 px-4 py-8 sm:px-6 xl:px-8"><dt class="text-sm font-medium leading-6 text-mute">${ssrInterpolate(_ctx.$t("Sales"))}</dt><dd class="w-full flex-none text-3xl font-medium leading-10 tracking-tight text-focus">${ssrInterpolate(unref($currency)(((_b = (_a2 = data.value) == null ? void 0 : _a2.data) == null ? void 0 : _b.sales) || 0))}</dd>`);
        if (data_days.value) {
          _push(`<div class="max-w-full">`);
          _push(ssrRenderComponent(unref(ApexCharts), {
            type: sparkType.value,
            height: "100",
            options: salesSparkOptions.value,
            series: salesSpark.value
          }, null, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="flex flex-wrap items-baseline justify-between gap-x-4 gap-y-2 bg-white dark:bg-gray-900 px-4 py-8 sm:px-6 xl:px-8"><dt class="text-sm font-medium leading-6 text-mute">${ssrInterpolate(_ctx.$t("Purchases"))}</dt><dd class="w-full flex-none text-3xl font-medium leading-10 tracking-tight text-focus">${ssrInterpolate(unref($currency)(((_d = (_c = data.value) == null ? void 0 : _c.data) == null ? void 0 : _d.purchases) || 0))}</dd>`);
        if (data_days.value) {
          _push(`<div class="max-w-full">`);
          _push(ssrRenderComponent(unref(ApexCharts), {
            type: sparkType.value,
            height: "100",
            options: purchasesSparkOptions.value,
            series: purchasesSpark.value
          }, null, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="flex flex-wrap items-baseline justify-between gap-x-4 gap-y-2 bg-white dark:bg-gray-900 px-4 py-8 sm:px-6 xl:px-8"><dt class="text-sm font-medium leading-6 text-mute">${ssrInterpolate(_ctx.$t("Payments"))}</dt><dd class="w-full flex-none text-3xl font-medium leading-10 tracking-tight text-focus">${ssrInterpolate(unref($currency)(((_f = (_e = data.value) == null ? void 0 : _e.data) == null ? void 0 : _f.paid) || 0))}</dd>`);
        if (data_days.value) {
          _push(`<div class="max-w-full">`);
          _push(ssrRenderComponent(unref(ApexCharts), {
            type: sparkType.value,
            height: "100",
            options: paymentsSparkOptions.value,
            series: paymentsSpark.value
          }, null, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="flex flex-wrap items-baseline justify-between gap-x-4 gap-y-2 bg-white dark:bg-gray-900 px-4 py-8 sm:px-6 xl:px-8"><dt class="text-sm font-medium leading-6 text-mute">${ssrInterpolate(_ctx.$t("Expenses"))}</dt><dd class="w-full flex-none text-3xl font-medium leading-10 tracking-tight text-focus">${ssrInterpolate(unref($currency)(((_h = (_g = data.value) == null ? void 0 : _g.data) == null ? void 0 : _h.expenses) || 0))}</dd>`);
        if (data_days.value) {
          _push(`<div class="max-w-full">`);
          _push(ssrRenderComponent(unref(ApexCharts), {
            type: sparkType.value,
            height: "100",
            options: expensesSparkOptions.value,
            series: expensesSpark.value
          }, null, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></dl>`);
      }
      _push(`<div class="bg-white dark:bg-gray-900"><div class="border-b border-gray-200 dark:border-gray-700 px-4 py-5 sm:px-6"><div class="-ml-4 -mt-2 flex flex-wrap items-center justify-between sm:flex-nowrap"><div class="ml-4 mt-2"><h3 class="text-base font-bold text-focused">${ssrInterpolate(_ctx.$t("Year Overview"))}</h3></div><div class="ml-4 mt-2 shrink-0 max-w-24">`);
      _push(ssrRenderComponent(unref(_sfc_main$3), {
        label: "",
        id: "year",
        modelValue: year.value,
        "onUpdate:modelValue": ($event) => year.value = $event,
        suggestions: [...Array(unref(dayjs)().year() - 2023).keys()].map((i) => 0 - (i - unref(dayjs)().year()))
      }, null, _parent));
      _push(`</div></div></div><div class="h-[535px]">`);
      if (loadingChart.value) {
        _push(`<div class="relative h-[450px] flex items-center justify-center">`);
        _push(ssrRenderComponent(unref(_sfc_main$2), { loadingClass: "h-10 w-10" }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<div id="chart" class="p-6">`);
        _push(ssrRenderComponent(unref(ApexCharts), {
          type: "bar",
          height: "450",
          options: barChartOptions.value,
          series: barSeries.value
        }, null, _parent));
        _push(`</div>`);
      }
      _push(`</div></div></div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Dashboard.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
