import { computed, mergeProps, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrInterpolate } from "vue/server-renderer";
import { useI18n } from "vue-i18n";
const _sfc_main = {
  __name: "Error",
  __ssrInlineRender: true,
  props: { status: Number },
  setup(__props) {
    const { t } = useI18n({});
    const props = __props;
    const title = computed(() => {
      return {
        503: t("503: Service Unavailable"),
        500: t("500: Server Error"),
        404: t("404: Page Not Found"),
        403: t("403: Forbidden")
      }[props.status];
    });
    const description = computed(() => {
      return {
        503: t("Sorry, we are doing some maintenance. Please check back soon."),
        500: t("Whoops, something went wrong on our servers."),
        404: t("Sorry, the page you are looking for could not be found."),
        403: t("Sorry, you are forbidden from accessing this page.")
      }[props.status];
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "min-h-screen min-w-full flex flex-col items-center justify-center text-center" }, _attrs))}><h1 class="text-lg font-bold">${ssrInterpolate(title.value)}</h1><div class="my-2">${ssrInterpolate(description.value)}</div><a href="/" class="mt-4 btn-primary">${ssrInterpolate(_ctx.$t("Back to Homepage"))}</a></div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Error.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
