import { ref, resolveComponent, withCtx, createVNode, toDisplayString, createTextVNode, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderList, ssrRenderClass } from "vue/server-renderer";
import "dayjs";
import _sfc_main$6 from "./Form-BDh7f-pB.js";
import { P as PageSearch } from "./PageSearch-CiHIJpyQ.js";
import "./ActionMessage-cgGHxf5V.js";
import { b as _sfc_main$5 } from "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "@inertiajs/vue3";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import { _ as _sfc_main$1 } from "./AdminLayout-DHH3IgME.js";
import _sfc_main$7 from "./QuickView-CxPfMVvb.js";
import { e as _sfc_main$2, _ as _sfc_main$3, d as _sfc_main$4 } from "./http-CDixhmav.js";
import "./LoadingButton-DREeyNQW.js";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
import "../ssr.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "lodash.debounce";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
import "./AppLayout-BRHmSgDa.js";
const _sfc_main = /* @__PURE__ */ Object.assign({ layout: _sfc_main$1 }, {
  __name: "Expense",
  __ssrInlineRender: true,
  props: ["pagination", "totals", "stores", "users"],
  setup(__props) {
    const form = ref(false);
    const view = ref(false);
    const current = ref(null);
    ref(false);
    const { filters, searching } = PageSearch();
    return (_ctx, _push, _parent, _attrs) => {
      var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p, _q, _r;
      const _component_Head = resolveComponent("Head");
      const _component_Header = resolveComponent("Header");
      const _component_Icon = resolveComponent("Icon");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_Head, null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<title${_scopeId}>${ssrInterpolate(_ctx.$t("{x} Report", { x: _ctx.$t("Expenses") }))}</title>`);
          } else {
            return [
              createVNode("title", null, toDisplayString(_ctx.$t("{x} Report", { x: _ctx.$t("Expenses") })), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_Header, null, {
        subheading: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Please review the data below"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Please review the data below")), 1)
            ];
          }
        }),
        menu: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex items-center justify-center gap-4"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$2), {
              type: "button",
              onClick: ($event) => form.value = true
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Customize"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Customize")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "flex items-center justify-center gap-4" }, [
                createVNode(unref(_sfc_main$2), {
                  type: "button",
                  onClick: ($event) => form.value = true
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.$t("Customize")), 1)
                  ]),
                  _: 1
                }, 8, ["onClick"])
              ])
            ];
          }
        }),
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("{x} Report", { x: _ctx.$t("Expenses") }))} `);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("{x} Report", { x: _ctx.$t("Expenses") })) + " ", 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      if (__props.totals) {
        _push(`<dl class="grid grid-cols-1 gap-px bg-gray-200 dark:bg-gray-700 sm:grid-cols-2 lg:grid-cols-4 border-b border-gray-200 dark:border-gray-700"><div class="flex flex-wrap items-baseline justify-between gap-x-4 gap-y-2 bg-white dark:bg-gray-900 px-4 py-8 sm:px-6 xl:px-8"><dt class="text-sm font-medium leading-6 text-mute">${ssrInterpolate(_ctx.$t("Expenses"))}</dt><dd class="w-full flex-none text-3xl font-medium leading-10 tracking-tight text-focus">${ssrInterpolate(_ctx.$number(((_a = __props.totals) == null ? void 0 : _a.count) || 0, null, { maximumFractionDigits: 0 }))}</dd></div><div class="flex flex-wrap items-baseline justify-between gap-x-4 gap-y-2 bg-white dark:bg-gray-900 px-4 py-8 sm:px-6 xl:px-8"><dt class="text-sm font-medium leading-6 text-mute">${ssrInterpolate(_ctx.$t("Amount"))}</dt><dd class="w-full flex-none text-3xl font-medium leading-10 tracking-tight text-focus">${ssrInterpolate(_ctx.$currency(((_b = __props.totals) == null ? void 0 : _b.total) || 0))}</dd></div></dl>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="relative px-4 sm:px-6 lg:px-8 bg-white dark:bg-gray-800 grow self-stretch flex flex-col items-stretch justify-stretch">`);
      if (unref(searching)) {
        _push(ssrRenderComponent(unref(_sfc_main$3), { "circle-size": "w-10 h-10" }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="flow-root grow"><div class="-mx-4 -my-2 overflow-x-auto sm:-mx-6 lg:-mx-8"><div class="inline-block min-w-full my-2 align-middle border-b border-gray-200 dark:border-gray-700"><table class="min-w-full divide-y dark:divide-gray-700"><thead><tr><th scope="col" class="pl-4 pr-3 sm:pl-6 lg:pl-8 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Date"))} `);
      if ((_d = (_c = unref(filters)) == null ? void 0 : _c.sort) == null ? void 0 : _d.startsWith("date:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "date:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Reference"))} `);
      if ((_f = (_e = unref(filters)) == null ? void 0 : _e.sort) == null ? void 0 : _f.startsWith("reference:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "reference:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Amount"))} `);
      if ((_h = (_g = unref(filters)) == null ? void 0 : _g.sort) == null ? void 0 : _h.startsWith("amount:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "amount:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Supplier"))} `);
      if ((_j = (_i = unref(filters)) == null ? void 0 : _i.sort) == null ? void 0 : _j.startsWith("supplier.name:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "supplier.name:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Store"))} `);
      if ((_l = (_k = unref(filters)) == null ? void 0 : _k.sort) == null ? void 0 : _l.startsWith("store.name:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "store.name:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Created by"))} `);
      if ((_n = (_m = unref(filters)) == null ? void 0 : _m.sort) == null ? void 0 : _n.startsWith("user.name:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "user.name:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="py-3.5 pl-4 pr-3 text-center text-sm font-semibold text-focus sm:pl-6 lg:pl-8 w-16"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Created at"))} `);
      if ((_p = (_o = unref(filters)) == null ? void 0 : _o.sort) == null ? void 0 : _p.startsWith("created_at:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "created_at:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Details"))} `);
      if ((_r = (_q = unref(filters)) == null ? void 0 : _q.sort) == null ? void 0 : _r.startsWith("details:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3",
          name: unref(filters).sort == "details:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th></tr></thead><tbody class="divide-y dark:divide-gray-700 bg-white dark:bg-gray-900">`);
      if (__props.pagination && __props.pagination.data && __props.pagination.data.length) {
        _push(`<!--[-->`);
        ssrRenderList(__props.pagination.data, (row) => {
          var _a2, _b2, _c2, _d2;
          _push(`<tr class="${ssrRenderClass(row.deleted_at ? "bg-red-100 dark:bg-red-950" : "")}"><td class="cursor-pointer whitespace-nowrap pl-4 pr-3 sm:pl-6 lg:pl-8 py-4 text-sm">${ssrInterpolate(_ctx.$date(row.date))}</td><td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm">${ssrInterpolate(row.reference)}</td><td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm">${ssrInterpolate(_ctx.$currency(row.amount))}</td><td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm">${ssrInterpolate(((_a2 = row.supplier) == null ? void 0 : _a2.company) || ((_b2 = row.supplier) == null ? void 0 : _b2.name) || "")}</td><td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm">${ssrInterpolate(((_c2 = row.store) == null ? void 0 : _c2.name) || "")}</td><td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm">${ssrInterpolate(((_d2 = row.user) == null ? void 0 : _d2.name) || "")}</td><td class="cursor-pointer whitespace-nowrap py-4 pl-4 pr-3 text-sm font-medium text-focus sm:pl-6 lg:pl-8 w-14">${ssrInterpolate(_ctx.$datetime(row.created_at))}</td><td class="cursor-pointer px-3 py-4 text-sm"><div class="-my-2 min-w-64 line-clamp-2">${ssrInterpolate(row.details || "")}</div></td></tr>`);
        });
        _push(`<!--]-->`);
      } else {
        _push(`<tr><td colspan="100%"><div class="whitespace-nowrap pl-4 pr-3 py-3.5 text-sm font-light text-mute sm:pl-2 lg:pl-4">${ssrInterpolate(_ctx.$t("There is no data to display!"))}</div></td></tr>`);
      }
      _push(`</tbody></table></div></div></div><div class="-mx-4 sm:-mx-6 lg:-mx-8">`);
      _push(ssrRenderComponent(unref(_sfc_main$4), {
        class: "mt-auto mx-4 sm:mx-6 py-2 text-sm",
        meta: __props.pagination.meta,
        links: __props.pagination.links
      }, null, _parent));
      _push(`</div>`);
      _push(ssrRenderComponent(unref(_sfc_main$5), {
        show: form.value,
        "max-width": "2xl",
        onClose: ($event) => form.value = false,
        overflow: true
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_sfc_main$6, {
              users: __props.users,
              stores: __props.stores,
              filters: unref(filters),
              onClose: ($event) => form.value = false,
              fields: ["customer", "supplier", "store", "user"]
            }, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(_sfc_main$6, {
                users: __props.users,
                stores: __props.stores,
                filters: unref(filters),
                onClose: ($event) => form.value = false,
                fields: ["customer", "supplier", "store", "user"]
              }, null, 8, ["users", "stores", "filters", "onClose"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$5), {
        show: view.value,
        "max-width": "3xl",
        onClose: ($event) => view.value = false
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_sfc_main$7, {
              force: true,
              current: current.value,
              fields: [],
              onClose: ($event) => view.value = false
            }, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(_sfc_main$7, {
                force: true,
                current: current.value,
                fields: [],
                onClose: ($event) => view.value = false
              }, null, 8, ["current", "onClose"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Report/Expense.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
