import { ref, watch, resolveComponent, unref, mergeProps, withCtx, createVNode, createTextVNode, toDisplayString, createBlock, openBlock, withDirectives, vModelText, Fragment, renderList, createCommentVNode, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrRenderList } from "vue/server-renderer";
import { T } from "../ssr.js";
import { notify } from "notiwind";
import { useI18n } from "vue-i18n";
import debounce from "lodash/debounce.js";
import { usePage } from "@inertiajs/vue3";
import { u as $decimal, a as axios, h as _sfc_main$2, b as _sfc_main$3, v as _sfc_main$4, l as _sfc_main$6 } from "./http-CDixhmav.js";
import "lodash.debounce";
import "dayjs";
import { _ as _sfc_main$7 } from "./LoadingButton-DREeyNQW.js";
import "./ActionMessage-cgGHxf5V.js";
import { b as _sfc_main$1 } from "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import { _ as _sfc_main$5 } from "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "@vuepic/vue-datepicker";
import "lodash.isequal";
import "axios";
import "lodash.throttle";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = {
  __name: "FinalizeSale",
  __ssrInlineRender: true,
  props: ["show", "form", "saveForm"],
  emits: ["close"],
  setup(__props, { emit: __emit }) {
    usePage();
    const { t } = useI18n({});
    const emit = __emit;
    const props = __props;
    const saving = ref(false);
    const totalPaymentsAmount = ref(0);
    watch(
      () => props.show,
      (show) => {
        if (show) {
          if (!props.form.payments || !Object.keys(props.form.payments).length) {
            props.form.payments = [
              { amount: $decimal(props.form.items.reduce((a, i) => Number(i.total) + a, 0)), method: "Cash", method_data: {} }
            ];
          } else {
            props.form.payments[0].amount = $decimal(props.form.items.reduce((a, i) => Number(i.total) + a, 0));
            props.form.payments[0].method = "Cash";
          }
          calcTotalPaymentsAmount();
        }
      }
    );
    function addMorePayment() {
      if (!props.form.payments) {
        props.form.payments = [{ amount: props.form.items.reduce((a, i) => Number(i.total) + a, 0), method: "Cash", method_data: {} }];
      }
      props.form.payments = [...props.form.payments, { amount: 0, method: "Cash", method_data: {} }];
    }
    function checkPayments(re) {
      if (!props.form.payments) {
        return false;
      }
      let payments = props.form.payments.map((p) => p);
      payments = payments.filter((p) => p.amount > 0 && p.method != "Stripe Terminal");
      payments = payments.filter((p) => p.method == "Card Terminal" && !p.cc_slip ? false : true);
      payments = payments.filter((p) => {
        if (p.method == "Gift Card") {
          if (!p.gift_card) {
            return false;
          }
          if (Number(p.gift_card.balance) < Number(p.amount)) {
            return false;
          }
          if (p.gift_card.customer_id && p.gift_card.customer_id != props.form.customer_id) {
            return false;
          }
        }
        return true;
      });
      let total_amount = $decimal(payments.reduce((a, p) => a + Number(p.amount), 0));
      {
        return total_amount;
      }
    }
    function calcTotalPaymentsAmount(index = null) {
      var _a;
      totalPaymentsAmount.value = checkPayments();
      if (index !== null) {
        let payment = props.form.payments[index];
        if (payment && payment.method == "Gift Card") {
          payment.method_data = { ...payment.method_data, gift_card_no: ((_a = payment.method_data) == null ? void 0 : _a.gift_card_no) || null };
        }
      }
    }
    const checkGiftCard = debounce((e, index) => {
      if (e.target.value) {
        axios.get(T("gift_cards.details", e.target.value)).then((res) => {
          props.form.payments[index].gift_card = res.data;
          if (props.form.payments[index].amount > res.data.balance) {
            notify({
              group: "main",
              type: "error",
              title: "Error!",
              text: t("Gift card balance is not enough.")
            });
            props.form.payments[index].amount = res.data.balance;
            calcTotalPaymentsAmount();
          }
        });
      }
    }, 500);
    return (_ctx, _push, _parent, _attrs) => {
      var _a;
      const _component_icons = resolveComponent("icons");
      _push(ssrRenderComponent(unref(_sfc_main$1), mergeProps({
        show: __props.show,
        onClose: ($event) => emit("close"),
        maxWidth: "lg",
        closeable: false,
        round: ((_a = _ctx.$page.props.settings) == null ? void 0 : _a.pos_design) == "Modern"
      }, _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div${_scopeId}><div class="relative border-b border-gray-200 dark:border-gray-700 p-4 sm:px-6"${_scopeId}><div class="absolute right-0 top-0 hidden pr-4 pt-4 sm:block"${_scopeId}><button type="button" class="rounded-md text-gray-400 hover:text-gray-500 focus:outline-hidden focus:ring-2 focus:ring-primary-500 focus:ring-offset-2"${_scopeId}><span class="sr-only"${_scopeId}>${ssrInterpolate(_ctx.$t("Close"))}</span><svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" aria-hidden="true"${_scopeId}><path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"${_scopeId}></path></svg></button></div><div${_scopeId}><h3 class="text-base font-semibold leading-6 text-gray-900 dark:text-gray-100"${_scopeId}>${ssrInterpolate(_ctx.$t("Finalize Sale"))}</h3><p class="mt-1 text-sm"${_scopeId}>${ssrInterpolate(_ctx.$t("Please fill the payment details to finalize."))}</p></div></div>`);
            if (__props.form.items && __props.form.items.length) {
              _push2(`<div class="flex flex-col gap-6 mb-6"${_scopeId}><div class="text-base"${_scopeId}><dl class="divide-y divide-gray-100 dark:divide-gray-700"${_scopeId}><div class="bg-gray-50 dark:bg-gray-900/50 px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4"${_scopeId}><dt class="font-medium leading-6"${_scopeId}>${ssrInterpolate(_ctx.$t("Total"))}</dt><dd class="mt-1 font-bold text-right leading-6 sm:col-span-2 sm:mt-0"${_scopeId}>${ssrInterpolate(_ctx.$currency(__props.form.items.reduce((a, i) => Number(i.total) + a, 0)))}</dd></div><div class="px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4"${_scopeId}><dt class="font-medium leading-6"${_scopeId}>${ssrInterpolate(_ctx.$t("Rounding"))}</dt><dd class="mt-1 font-bold text-right leading-6 sm:col-span-2 sm:mt-0"${_scopeId}>${ssrInterpolate(_ctx.$number(__props.form.rounding || 0))}</dd></div><div class="bg-gray-50 dark:bg-gray-900/50 px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4 text-lg"${_scopeId}><dt class="font-medium leading-6"${_scopeId}>${ssrInterpolate(_ctx.$t("Payable Amount"))}</dt><dd class="mt-1 font-bold text-right leading-6 sm:col-span-2 sm:mt-0"${_scopeId}>${ssrInterpolate(_ctx.$currency(__props.form.items.reduce((a, i) => Number(i.total) + a, 0) + (__props.form.rounding || 0)))}</dd></div><div class="px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4"${_scopeId}><dt class="font-medium leading-6"${_scopeId}>${ssrInterpolate(_ctx.$t("Tender Amount"))} <br${_scopeId}> ${ssrInterpolate(Number(__props.form.tendered || 0) < Number((props.form.items.reduce((a, i) => Number(i.total) + a, 0) || 0) + (__props.form.rounding || 0)) ? _ctx.$t("Get") + " " + _ctx.$number(
                0 - (__props.form.tendered - ((props.form.items.reduce((a, i) => Number(i.total) + a, 0) || 0) + (__props.form.rounding || 0)))
              ) + " " + _ctx.$t("more") : "")}</dt><dd class="mt-1 font-bold text-right leading-6 sm:col-span-2 sm:mt-0 flex items-end justify-end"${_scopeId}><input id="tender-amount"${ssrRenderAttr("value", __props.form.tendered)} class="bg-transparent py-0.5 px-2 -mx-2 rounded-sm border-0 border-b border-gray-200 dark:border-gray-700 text-right focus:ring-0"${_scopeId}></dd></div><div class="bg-gray-50 dark:bg-gray-900/50 px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4"${_scopeId}><dt class="font-medium leading-6"${_scopeId}>${ssrInterpolate(_ctx.$t("Return Amount"))}</dt><dd class="mt-1 font-bold text-right leading-6 sm:col-span-2 sm:mt-0"${_scopeId}>${ssrInterpolate(_ctx.$number(
                Number(__props.form.tendered || 0) > Number(__props.form.items.reduce((a, i) => Number(i.total) + a, 0)) + (__props.form.rounding || 0) ? __props.form.tendered - (__props.form.items.reduce((a, i) => Number(i.total) + a, 0) + (__props.form.rounding || 0)) : 0
              ))}</dd></div></dl></div><!--[-->`);
              ssrRenderList(__props.form.payments, (payment, index) => {
                var _a2, _b, _c, _d;
                _push2(`<!--[--><div class="px-6 grid grid-cols-2 gap-4 pt-6 border-t dark:border-gray-700"${_scopeId}><div${_scopeId}>`);
                _push2(ssrRenderComponent(unref(_sfc_main$2), {
                  type: "number",
                  label: _ctx.$t("Amount"),
                  onChange: calcTotalPaymentsAmount,
                  modelValue: __props.form.payments[index].amount,
                  "onUpdate:modelValue": ($event) => __props.form.payments[index].amount = $event,
                  max: Number(__props.form.items.reduce((a, i) => Number(i.total) + a, 0)) - Number(__props.form.rounding || 0)
                }, null, _parent2, _scopeId));
                _push2(`</div><div${_scopeId}>`);
                _push2(ssrRenderComponent(unref(_sfc_main$3), {
                  json: false,
                  placement: "top",
                  searchable: false,
                  label: _ctx.$t("Method"),
                  modelValue: __props.form.payments[index].method,
                  "onUpdate:modelValue": ($event) => __props.form.payments[index].method = $event,
                  onChange: ($event) => calcTotalPaymentsAmount(index),
                  suggestions: ["Cash", "Gift Card", "Card Terminal", "Stripe Terminal", "Others"]
                }, null, _parent2, _scopeId));
                _push2(`</div></div>`);
                if (((_a2 = __props.form.payments[index]) == null ? void 0 : _a2.method) == "Gift Card") {
                  _push2(`<div class="px-6"${_scopeId}>`);
                  _push2(ssrRenderComponent(unref(_sfc_main$2), {
                    label: _ctx.$t("Gift Card Number"),
                    onChange: calcTotalPaymentsAmount,
                    onInput: (e) => unref(checkGiftCard)(e, index),
                    modelValue: __props.form.payments[index].method_data.gift_card_no,
                    "onUpdate:modelValue": ($event) => __props.form.payments[index].method_data.gift_card_no = $event
                  }, null, _parent2, _scopeId));
                  if (__props.form.payments[index].gift_card && __props.form.payments[index].method_data.gift_card_no) {
                    _push2(`<div class="mt-3 border dark:border-gray-700 rounded-md py-2 px-3 text-sm whitespace-pre-wrap"${_scopeId}><div${_scopeId}>${ssrInterpolate(_ctx.$t("Balance Amount"))}: ${ssrInterpolate(_ctx.$number(__props.form.payments[index].gift_card.balance))}</div>`);
                    if (__props.form.payments[index].gift_card.customer) {
                      _push2(`<div${_scopeId}>${ssrInterpolate(_ctx.$t("Customer"))}: ${ssrInterpolate((_b = __props.form.payments[index].gift_card.customer) == null ? void 0 : _b.name)}</div>`);
                    } else {
                      _push2(`<!---->`);
                    }
                    _push2(`</div>`);
                  } else {
                    _push2(`<!---->`);
                  }
                  _push2(`</div>`);
                } else {
                  _push2(`<!---->`);
                }
                if (((_c = __props.form.payments[index]) == null ? void 0 : _c.method) == "Card Terminal") {
                  _push2(`<div class="px-6"${_scopeId}>`);
                  _push2(ssrRenderComponent(unref(_sfc_main$4), {
                    onChange: calcTotalPaymentsAmount,
                    checked: __props.form.payments[index].cc_slip,
                    "onUpdate:checked": ($event) => __props.form.payments[index].cc_slip = $event,
                    label: _ctx.$t("I have collected payment & saved receipt")
                  }, null, _parent2, _scopeId));
                  _push2(`</div>`);
                } else {
                  _push2(`<!---->`);
                }
                if (((_d = __props.form.payments[index]) == null ? void 0 : _d.method) == "Stripe Terminal") {
                  _push2(`<div class="px-6 text-yellow-500 text-sm font-bold"${_scopeId}> Work in Progress </div>`);
                } else {
                  _push2(`<!---->`);
                }
                _push2(`<!--]-->`);
              });
              _push2(`<!--]--><div class="border-t dark:border-gray-700 pt-6"${_scopeId}>`);
              if (Number(totalPaymentsAmount.value) < Number(__props.form.items.reduce((a, i) => Number(i.total) + a, 0))) {
                _push2(`<div class="flex items-center justify-center mb-6"${_scopeId}>`);
                _push2(ssrRenderComponent(unref(_sfc_main$5), {
                  type: "button",
                  onClick: ($event) => addMorePayment(),
                  class: "flex items-center justify-center px-6 py-2 text-sm text-gray-600 hover:text-gray-700 rounded-md"
                }, {
                  default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                    if (_push3) {
                      _push3(ssrRenderComponent(_component_icons, {
                        name: "plus",
                        class: "h-4 w-4 mr-1"
                      }, null, _parent3, _scopeId2));
                      _push3(` ${ssrInterpolate(_ctx.$t("Add another Payment"))}`);
                    } else {
                      return [
                        createVNode(_component_icons, {
                          name: "plus",
                          class: "h-4 w-4 mr-1"
                        }),
                        createTextVNode(" " + toDisplayString(_ctx.$t("Add another Payment")), 1)
                      ];
                    }
                  }),
                  _: 1
                }, _parent2, _scopeId));
                _push2(`</div>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(`<h4 class="px-6 text-center bg-gray-100 dark:bg-slate-800 py-2"${_scopeId}>${ssrInterpolate(_ctx.$t("Total Payment Amount"))}: <strong${_scopeId}>${ssrInterpolate(_ctx.$number(totalPaymentsAmount.value))}</strong></h4></div><div class="px-6"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                label: "",
                modelValue: __props.form.details,
                "onUpdate:modelValue": ($event) => __props.form.details = $event,
                onChange: __props.saveForm,
                placeholder: _ctx.$t("Any sale details")
              }, null, _parent2, _scopeId));
              _push2(`</div><div class="px-6"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$7), {
                type: "button",
                loading: saving.value,
                class: "w-full justify-center",
                onClick: ($event) => emit("finalize", __props.form),
                disabled: saving.value || Number(totalPaymentsAmount.value) != Number(unref($decimal)(__props.form.items.reduce((a, i) => Number(i.total) + a, 0)) + Number(__props.form.rounding || 0))
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<span class="text-base"${_scopeId2}>${ssrInterpolate(_ctx.$t("Save"))}</span>`);
                  } else {
                    return [
                      createVNode("span", { class: "text-base" }, toDisplayString(_ctx.$t("Save")), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(`</div></div>`);
            } else {
              _push2(`<div class="flex flex-col gap-4 m-6 text-yellow-600"${_scopeId}>${ssrInterpolate(_ctx.$t("Please add at least one item to form."))}</div>`);
            }
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", null, [
                createVNode("div", { class: "relative border-b border-gray-200 dark:border-gray-700 p-4 sm:px-6" }, [
                  createVNode("div", { class: "absolute right-0 top-0 hidden pr-4 pt-4 sm:block" }, [
                    createVNode("button", {
                      type: "button",
                      onClick: ($event) => emit("close"),
                      class: "rounded-md text-gray-400 hover:text-gray-500 focus:outline-hidden focus:ring-2 focus:ring-primary-500 focus:ring-offset-2"
                    }, [
                      createVNode("span", { class: "sr-only" }, toDisplayString(_ctx.$t("Close")), 1),
                      (openBlock(), createBlock("svg", {
                        class: "h-6 w-6",
                        fill: "none",
                        viewBox: "0 0 24 24",
                        "stroke-width": "1.5",
                        stroke: "currentColor",
                        "aria-hidden": "true"
                      }, [
                        createVNode("path", {
                          "stroke-linecap": "round",
                          "stroke-linejoin": "round",
                          d: "M6 18L18 6M6 6l12 12"
                        })
                      ]))
                    ], 8, ["onClick"])
                  ]),
                  createVNode("div", null, [
                    createVNode("h3", { class: "text-base font-semibold leading-6 text-gray-900 dark:text-gray-100" }, toDisplayString(_ctx.$t("Finalize Sale")), 1),
                    createVNode("p", { class: "mt-1 text-sm" }, toDisplayString(_ctx.$t("Please fill the payment details to finalize.")), 1)
                  ])
                ]),
                __props.form.items && __props.form.items.length ? (openBlock(), createBlock("div", {
                  key: 0,
                  class: "flex flex-col gap-6 mb-6"
                }, [
                  createVNode("div", { class: "text-base" }, [
                    createVNode("dl", { class: "divide-y divide-gray-100 dark:divide-gray-700" }, [
                      createVNode("div", { class: "bg-gray-50 dark:bg-gray-900/50 px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4" }, [
                        createVNode("dt", { class: "font-medium leading-6" }, toDisplayString(_ctx.$t("Total")), 1),
                        createVNode("dd", { class: "mt-1 font-bold text-right leading-6 sm:col-span-2 sm:mt-0" }, toDisplayString(_ctx.$currency(__props.form.items.reduce((a, i) => Number(i.total) + a, 0))), 1)
                      ]),
                      createVNode("div", { class: "px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4" }, [
                        createVNode("dt", { class: "font-medium leading-6" }, toDisplayString(_ctx.$t("Rounding")), 1),
                        createVNode("dd", { class: "mt-1 font-bold text-right leading-6 sm:col-span-2 sm:mt-0" }, toDisplayString(_ctx.$number(__props.form.rounding || 0)), 1)
                      ]),
                      createVNode("div", { class: "bg-gray-50 dark:bg-gray-900/50 px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4 text-lg" }, [
                        createVNode("dt", { class: "font-medium leading-6" }, toDisplayString(_ctx.$t("Payable Amount")), 1),
                        createVNode("dd", { class: "mt-1 font-bold text-right leading-6 sm:col-span-2 sm:mt-0" }, toDisplayString(_ctx.$currency(__props.form.items.reduce((a, i) => Number(i.total) + a, 0) + (__props.form.rounding || 0))), 1)
                      ]),
                      createVNode("div", { class: "px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4" }, [
                        createVNode("dt", { class: "font-medium leading-6" }, [
                          createTextVNode(toDisplayString(_ctx.$t("Tender Amount")) + " ", 1),
                          createVNode("br"),
                          createTextVNode(" " + toDisplayString(Number(__props.form.tendered || 0) < Number((props.form.items.reduce((a, i) => Number(i.total) + a, 0) || 0) + (__props.form.rounding || 0)) ? _ctx.$t("Get") + " " + _ctx.$number(
                            0 - (__props.form.tendered - ((props.form.items.reduce((a, i) => Number(i.total) + a, 0) || 0) + (__props.form.rounding || 0)))
                          ) + " " + _ctx.$t("more") : ""), 1)
                        ]),
                        createVNode("dd", { class: "mt-1 font-bold text-right leading-6 sm:col-span-2 sm:mt-0 flex items-end justify-end" }, [
                          withDirectives(createVNode("input", {
                            id: "tender-amount",
                            "onUpdate:modelValue": ($event) => __props.form.tendered = $event,
                            onClick: (e) => e.target.select(),
                            onBlur: () => {
                              __props.form.tendered = unref($decimal)(__props.form.tendered);
                              __props.form.change_returned = unref($decimal)(
                                Number(__props.form.tendered || 0) > Number(__props.form.items.reduce((a, i) => Number(i.total) + a, 0)) + (__props.form.rounding || 0) ? __props.form.tendered - (__props.form.items.reduce((a, i) => Number(i.total) + a, 0) + (__props.form.rounding || 0)) : 0
                              );
                              props.saveForm();
                            },
                            class: "bg-transparent py-0.5 px-2 -mx-2 rounded-sm border-0 border-b border-gray-200 dark:border-gray-700 text-right focus:ring-0"
                          }, null, 40, ["onUpdate:modelValue", "onClick", "onBlur"]), [
                            [vModelText, __props.form.tendered]
                          ])
                        ])
                      ]),
                      createVNode("div", { class: "bg-gray-50 dark:bg-gray-900/50 px-6 py-2 sm:grid sm:grid-cols-3 sm:gap-4" }, [
                        createVNode("dt", { class: "font-medium leading-6" }, toDisplayString(_ctx.$t("Return Amount")), 1),
                        createVNode("dd", { class: "mt-1 font-bold text-right leading-6 sm:col-span-2 sm:mt-0" }, toDisplayString(_ctx.$number(
                          Number(__props.form.tendered || 0) > Number(__props.form.items.reduce((a, i) => Number(i.total) + a, 0)) + (__props.form.rounding || 0) ? __props.form.tendered - (__props.form.items.reduce((a, i) => Number(i.total) + a, 0) + (__props.form.rounding || 0)) : 0
                        )), 1)
                      ])
                    ])
                  ]),
                  (openBlock(true), createBlock(Fragment, null, renderList(__props.form.payments, (payment, index) => {
                    var _a2, _b, _c, _d;
                    return openBlock(), createBlock(Fragment, null, [
                      createVNode("div", { class: "px-6 grid grid-cols-2 gap-4 pt-6 border-t dark:border-gray-700" }, [
                        createVNode("div", null, [
                          createVNode(unref(_sfc_main$2), {
                            type: "number",
                            label: _ctx.$t("Amount"),
                            onChange: calcTotalPaymentsAmount,
                            modelValue: __props.form.payments[index].amount,
                            "onUpdate:modelValue": ($event) => __props.form.payments[index].amount = $event,
                            max: Number(__props.form.items.reduce((a, i) => Number(i.total) + a, 0)) - Number(__props.form.rounding || 0)
                          }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "max"])
                        ]),
                        createVNode("div", null, [
                          createVNode(unref(_sfc_main$3), {
                            json: false,
                            placement: "top",
                            searchable: false,
                            label: _ctx.$t("Method"),
                            modelValue: __props.form.payments[index].method,
                            "onUpdate:modelValue": ($event) => __props.form.payments[index].method = $event,
                            onChange: ($event) => calcTotalPaymentsAmount(index),
                            suggestions: ["Cash", "Gift Card", "Card Terminal", "Stripe Terminal", "Others"]
                          }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "onChange"])
                        ])
                      ]),
                      ((_a2 = __props.form.payments[index]) == null ? void 0 : _a2.method) == "Gift Card" ? (openBlock(), createBlock("div", {
                        key: 0,
                        class: "px-6"
                      }, [
                        createVNode(unref(_sfc_main$2), {
                          label: _ctx.$t("Gift Card Number"),
                          onChange: calcTotalPaymentsAmount,
                          onInput: (e) => unref(checkGiftCard)(e, index),
                          modelValue: __props.form.payments[index].method_data.gift_card_no,
                          "onUpdate:modelValue": ($event) => __props.form.payments[index].method_data.gift_card_no = $event
                        }, null, 8, ["label", "onInput", "modelValue", "onUpdate:modelValue"]),
                        __props.form.payments[index].gift_card && __props.form.payments[index].method_data.gift_card_no ? (openBlock(), createBlock("div", {
                          key: 0,
                          class: "mt-3 border dark:border-gray-700 rounded-md py-2 px-3 text-sm whitespace-pre-wrap"
                        }, [
                          createVNode("div", null, toDisplayString(_ctx.$t("Balance Amount")) + ": " + toDisplayString(_ctx.$number(__props.form.payments[index].gift_card.balance)), 1),
                          __props.form.payments[index].gift_card.customer ? (openBlock(), createBlock("div", { key: 0 }, toDisplayString(_ctx.$t("Customer")) + ": " + toDisplayString((_b = __props.form.payments[index].gift_card.customer) == null ? void 0 : _b.name), 1)) : createCommentVNode("", true)
                        ])) : createCommentVNode("", true)
                      ])) : createCommentVNode("", true),
                      ((_c = __props.form.payments[index]) == null ? void 0 : _c.method) == "Card Terminal" ? (openBlock(), createBlock("div", {
                        key: 1,
                        class: "px-6"
                      }, [
                        createVNode(unref(_sfc_main$4), {
                          onChange: calcTotalPaymentsAmount,
                          checked: __props.form.payments[index].cc_slip,
                          "onUpdate:checked": ($event) => __props.form.payments[index].cc_slip = $event,
                          label: _ctx.$t("I have collected payment & saved receipt")
                        }, null, 8, ["checked", "onUpdate:checked", "label"])
                      ])) : createCommentVNode("", true),
                      ((_d = __props.form.payments[index]) == null ? void 0 : _d.method) == "Stripe Terminal" ? (openBlock(), createBlock("div", {
                        key: 2,
                        class: "px-6 text-yellow-500 text-sm font-bold"
                      }, " Work in Progress ")) : createCommentVNode("", true)
                    ], 64);
                  }), 256)),
                  createVNode("div", { class: "border-t dark:border-gray-700 pt-6" }, [
                    Number(totalPaymentsAmount.value) < Number(__props.form.items.reduce((a, i) => Number(i.total) + a, 0)) ? (openBlock(), createBlock("div", {
                      key: 0,
                      class: "flex items-center justify-center mb-6"
                    }, [
                      createVNode(unref(_sfc_main$5), {
                        type: "button",
                        onClick: ($event) => addMorePayment(),
                        class: "flex items-center justify-center px-6 py-2 text-sm text-gray-600 hover:text-gray-700 rounded-md"
                      }, {
                        default: withCtx(() => [
                          createVNode(_component_icons, {
                            name: "plus",
                            class: "h-4 w-4 mr-1"
                          }),
                          createTextVNode(" " + toDisplayString(_ctx.$t("Add another Payment")), 1)
                        ]),
                        _: 1
                      }, 8, ["onClick"])
                    ])) : createCommentVNode("", true),
                    createVNode("h4", { class: "px-6 text-center bg-gray-100 dark:bg-slate-800 py-2" }, [
                      createTextVNode(toDisplayString(_ctx.$t("Total Payment Amount")) + ": ", 1),
                      createVNode("strong", null, toDisplayString(_ctx.$number(totalPaymentsAmount.value)), 1)
                    ])
                  ]),
                  createVNode("div", { class: "px-6" }, [
                    createVNode(unref(_sfc_main$6), {
                      label: "",
                      modelValue: __props.form.details,
                      "onUpdate:modelValue": ($event) => __props.form.details = $event,
                      onChange: __props.saveForm,
                      placeholder: _ctx.$t("Any sale details")
                    }, null, 8, ["modelValue", "onUpdate:modelValue", "onChange", "placeholder"])
                  ]),
                  createVNode("div", { class: "px-6" }, [
                    createVNode(unref(_sfc_main$7), {
                      type: "button",
                      loading: saving.value,
                      class: "w-full justify-center",
                      onClick: ($event) => emit("finalize", __props.form),
                      disabled: saving.value || Number(totalPaymentsAmount.value) != Number(unref($decimal)(__props.form.items.reduce((a, i) => Number(i.total) + a, 0)) + Number(__props.form.rounding || 0))
                    }, {
                      default: withCtx(() => [
                        createVNode("span", { class: "text-base" }, toDisplayString(_ctx.$t("Save")), 1)
                      ]),
                      _: 1
                    }, 8, ["loading", "onClick", "disabled"])
                  ])
                ])) : (openBlock(), createBlock("div", {
                  key: 1,
                  class: "flex flex-col gap-4 m-6 text-yellow-600"
                }, toDisplayString(_ctx.$t("Please add at least one item to form.")), 1))
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Pos/Components/FinalizeSale.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
