import { ref, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent, ssrRenderStyle, ssrRenderAttr } from "vue/server-renderer";
import { T } from "../ssr.js";
import { usePage, useForm, router } from "@inertiajs/vue3";
import { f as $extras, h as _sfc_main$4, b as _sfc_main$5, k as _sfc_main$6, l as _sfc_main$7, v as _sfc_main$8 } from "./http-CDixhmav.js";
import "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import { a as _sfc_main$3 } from "./InputError-DjBtKS5r.js";
import { _ as _sfc_main$1 } from "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import { _ as _sfc_main$2 } from "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import { _ as _sfc_main$9 } from "./LoadingButton-DREeyNQW.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "lodash.debounce";
import "dayjs";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = {
  __name: "Form",
  __ssrInlineRender: true,
  props: ["current", "show", "accounts", "countries", "price_groups", "custom_fields"],
  emits: ["close", "done"],
  setup(__props, { emit: __emit }) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p, _q, _r, _s, _t;
    usePage();
    const emits = __emit;
    const props = __props;
    const logoInput = ref(null);
    const logoPreview = ref(null);
    const country = ref({ states: [] });
    if (((_a = props.current) == null ? void 0 : _a.id) && ((_b = props.current) == null ? void 0 : _b.country_id)) {
      country.value = props.countries.find((c) => c.id == props.current.country_id);
    }
    const form = useForm({
      _method: ((_c = props.current) == null ? void 0 : _c.id) ? "put" : "post",
      logo: null,
      name: (_d = props.current) == null ? void 0 : _d.name,
      phone: (_e = props.current) == null ? void 0 : _e.phone,
      email: (_f = props.current) == null ? void 0 : _f.email,
      account_id: (_g = props.current) == null ? void 0 : _g.account_id,
      price_group_id: (_h = props.current) == null ? void 0 : _h.price_group_id,
      country_id: (_i = props.current) == null ? void 0 : _i.country_id,
      state_id: (_j = props.current) == null ? void 0 : _j.state_id,
      lot_no: (_k = props.current) == null ? void 0 : _k.lot_no,
      street: (_l = props.current) == null ? void 0 : _l.street,
      address_line_1: (_m = props.current) == null ? void 0 : _m.address_line_1,
      address_line_2: (_n = props.current) == null ? void 0 : _n.address_line_2,
      city: (_o = props.current) == null ? void 0 : _o.city,
      postal_code: (_p = props.current) == null ? void 0 : _p.postal_code,
      footer: (_q = props.current) == null ? void 0 : _q.footer,
      header: (_r = props.current) == null ? void 0 : _r.header,
      active: ((_s = props.current) == null ? void 0 : _s.id) ? ((_t = props.current) == null ? void 0 : _t.active) == 1 : true,
      extra_attributes: props.current ? $extras(props.custom_fields, props.current.extra_attributes) : $extras(props.custom_fields)
    });
    const close = () => {
      form.reset();
      logoPreview.value = null;
      clearLogoFileInput();
      emits("close");
    };
    const deleteLogo = (row) => {
      router.delete(T("stores.logo.destroy", { id: row.id }), {
        preserveScroll: true,
        onSuccess: () => {
          logoPreview.value = null;
          clearLogoFileInput();
        }
      });
    };
    const selectNewLogo = () => {
      logoInput.value.click();
    };
    const clearLogoFileInput = () => {
      var _a2;
      if ((_a2 = logoInput.value) == null ? void 0 : _a2.value) {
        logoInput.value.value = null;
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      var _a2, _b2, _c2, _d2, _e2;
      _push(`<form${ssrRenderAttrs(_attrs)}><div class="border-b border-gray-200 dark:border-gray-700 px-6 py-4"><div class="sm:flex sm:items-baseline sm:justify-between"><div class="sm:w-0 sm:flex-1"><h1 class="text-base font-semibold text-focus">${ssrInterpolate(((_a2 = __props.current) == null ? void 0 : _a2.id) ? _ctx.$t("Edit {x}", { x: _ctx.$t("Store") }) : _ctx.$t("Add {x}", { x: _ctx.$t("Store") }))}</h1><p class="mt-1 truncate text-sm text-mute">${ssrInterpolate(_ctx.$t("Please fill the form below to {action} {record}.", {
        record: _ctx.$t("store"),
        action: ((_b2 = __props.current) == null ? void 0 : _b2.id) ? _ctx.$t("edit") : _ctx.$t("add")
      }))}</p></div></div></div><div class="p-6 grid grid-cols-6 gap-6"><div class="col-span-full"><input id="logo" type="file" class="hidden">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        for: "logo",
        value: _ctx.$t("Logo")
      }, null, _parent));
      _push(`<div style="${ssrRenderStyle(!logoPreview.value && ((_c2 = __props.current) == null ? void 0 : _c2.logo) ? null : { display: "none" })}" class="mt-2 p-1 rounded-md"><img${ssrRenderAttr("alt", _ctx.$t("Logo"))}${ssrRenderAttr("src", (_d2 = __props.current) == null ? void 0 : _d2.logo)} class="rounded-md w-full h-full max-w-64 min-h-20 max-h-40 object-contain"></div><div style="${ssrRenderStyle(logoPreview.value ? null : { display: "none" })}" class="mt-2 p-1 rounded-md"><span class="block rounded-md w-full h-full max-w-64 min-h-24 max-h-40 bg-no-repeat bg-contain" style="${ssrRenderStyle("background-image: url('" + logoPreview.value + "');")}"></span></div>`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        class: "mt-2 me-2",
        type: "button",
        onClick: () => selectNewLogo()
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Select A New Logo"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Select A New Logo")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      if ((_e2 = __props.current) == null ? void 0 : _e2.logo) {
        _push(ssrRenderComponent(unref(_sfc_main$2), {
          type: "button",
          onClick: () => deleteLogo(),
          class: "mt-2 p-1 rounded-md bg-gray-50 flex items-center justify-center"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("Remove Logo"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("Remove Logo")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(unref(_sfc_main$3), {
        message: unref(form).errors.logo,
        class: "mt-2"
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$4), {
        id: "name",
        label: _ctx.$t("Name"),
        modelValue: unref(form).name,
        "onUpdate:modelValue": ($event) => unref(form).name = $event,
        error: unref(form).errors.name
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$4), {
        id: "phone",
        label: _ctx.$t("Phone"),
        modelValue: unref(form).phone,
        "onUpdate:modelValue": ($event) => unref(form).phone = $event,
        error: unref(form).errors.phone
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$4), {
        type: "email",
        id: "email",
        label: _ctx.$t("Email"),
        modelValue: unref(form).email,
        "onUpdate:modelValue": ($event) => unref(form).email = $event,
        error: unref(form).errors.email
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$5), {
        json: true,
        id: "account_id",
        searchable: false,
        label: _ctx.$t("Account"),
        suggestions: __props.accounts,
        modelValue: unref(form).account_id,
        "onUpdate:modelValue": ($event) => unref(form).account_id = $event,
        error: unref(form).errors.account_id
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$5), {
        json: true,
        searchable: false,
        id: "price_group_id",
        label: _ctx.$t("Price Group"),
        suggestions: __props.price_groups,
        modelValue: unref(form).price_group_id,
        "onUpdate:modelValue": ($event) => unref(form).price_group_id = $event,
        error: unref(form).errors.price_group_id
      }, null, _parent));
      _push(`</div><div class="col-span-full"></div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$5), {
        json: true,
        id: "country_id",
        label: _ctx.$t("Country"),
        modelValue: unref(form).country_id,
        "onUpdate:modelValue": ($event) => unref(form).country_id = $event,
        error: unref(form).errors.country_id,
        suggestions: __props.countries.map((c) => ({ ...c, value: c.id, label: c.name })),
        onChange: (e) => {
          var _a3;
          country.value = e;
          unref(form).state_id = (_a3 = country.value.states[0]) == null ? void 0 : _a3.id;
        }
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$5), {
        json: true,
        id: "state_id",
        label: _ctx.$t("State"),
        modelValue: unref(form).state_id,
        "onUpdate:modelValue": ($event) => unref(form).state_id = $event,
        error: unref(form).errors.state_id,
        suggestions: country.value.states.length ? country.value.states.map((s) => ({ ...s, value: s.id, label: s.name })) : [{ value: "0", label: _ctx.$t("N/A") }]
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$4), {
        id: "lot_no",
        label: _ctx.$t("Lot No."),
        modelValue: unref(form).lot_no,
        "onUpdate:modelValue": ($event) => unref(form).lot_no = $event,
        error: unref(form).errors.lot_no
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$4), {
        id: "street",
        label: _ctx.$t("Street"),
        modelValue: unref(form).street,
        "onUpdate:modelValue": ($event) => unref(form).street = $event,
        error: unref(form).errors.street
      }, null, _parent));
      _push(`</div><div class="col-span-full">`);
      _push(ssrRenderComponent(unref(_sfc_main$4), {
        id: "address_line_1",
        label: _ctx.$t("Address Line 1"),
        modelValue: unref(form).address_line_1,
        "onUpdate:modelValue": ($event) => unref(form).address_line_1 = $event,
        error: unref(form).errors.address_line_1
      }, null, _parent));
      _push(`</div><div class="col-span-full">`);
      _push(ssrRenderComponent(unref(_sfc_main$4), {
        id: "address_line_2",
        label: _ctx.$t("Address Line 2"),
        modelValue: unref(form).address_line_2,
        "onUpdate:modelValue": ($event) => unref(form).address_line_2 = $event,
        error: unref(form).errors.address_line_2
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$4), {
        id: "city",
        label: _ctx.$t("City"),
        modelValue: unref(form).city,
        "onUpdate:modelValue": ($event) => unref(form).city = $event,
        error: unref(form).errors.city
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$4), {
        id: "postal_code",
        label: _ctx.$t("Postal/ZIP Code"),
        modelValue: unref(form).postal_code,
        "onUpdate:modelValue": ($event) => unref(form).postal_code = $event,
        error: unref(form).errors.postal_code
      }, null, _parent));
      _push(`</div><div class="col-span-full">`);
      _push(ssrRenderComponent(unref(_sfc_main$6), {
        custom_fields: __props.custom_fields,
        errors: unref(form).errors,
        extra_attributes: unref(form).extra_attributes
      }, null, _parent));
      _push(`</div><div class="col-span-full">`);
      _push(ssrRenderComponent(unref(_sfc_main$7), {
        id: "header",
        error: unref(form).errors.header,
        modelValue: unref(form).header,
        "onUpdate:modelValue": ($event) => unref(form).header = $event,
        label: _ctx.$t("Receipt Header")
      }, null, _parent));
      _push(`</div><div class="col-span-full">`);
      _push(ssrRenderComponent(unref(_sfc_main$7), {
        id: "footer",
        error: unref(form).errors.footer,
        modelValue: unref(form).footer,
        "onUpdate:modelValue": ($event) => unref(form).footer = $event,
        label: _ctx.$t("Receipt Footer")
      }, null, _parent));
      _push(`</div><div class="col-span-full">`);
      _push(ssrRenderComponent(unref(_sfc_main$8), {
        id: "active",
        error: unref(form).errors.active,
        checked: unref(form).active,
        "onUpdate:checked": ($event) => unref(form).active = $event,
        label: _ctx.$t("Active")
      }, null, _parent));
      _push(`</div></div><div class="flex flex-row justify-end px-6 py-4 bg-gray-100 dark:bg-gray-950 text-end rounded-b-lg">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), { onClick: close }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Cancel"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Cancel")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$9), {
        class: "ms-3",
        loading: unref(form).processing
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Save"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></form>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Setting/Store/Form.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
