import { mergeProps, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent } from "vue/server-renderer";
import "@inertiajs/vue3";
import "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import { _ as _sfc_main$3 } from "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import { b as _sfc_main$1, g as _sfc_main$2 } from "./http-CDixhmav.js";
import { _ as _sfc_main$4 } from "./LoadingButton-DREeyNQW.js";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
import "../ssr.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "lodash.debounce";
import "dayjs";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
const _sfc_main = {
  __name: "Form",
  __ssrInlineRender: true,
  props: ["fields", "filters", "categories", "brands", "stores", "users"],
  emits: ["close", "done"],
  setup(__props, { emit: __emit }) {
    const emits = __emit;
    const close = () => {
      emits("close");
    };
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<form${ssrRenderAttrs(mergeProps({ method: "get" }, _attrs))}><div class="border-b border-gray-200 dark:border-gray-700 px-6 py-4"><div class="sm:flex sm:items-baseline sm:justify-between"><div class="sm:w-0 sm:flex-1"><h1 class="text-base font-semibold text-focus">${ssrInterpolate(_ctx.$t("Customize Report"))}</h1><p class="mt-1 truncate text-sm text-mute">${ssrInterpolate(_ctx.$t("Please select the desired filters below."))}</p></div></div></div><div class="p-6 grid grid-cols-6 gap-6">`);
      if (__props.fields.includes("brands")) {
        _push(`<div class="col-span-6 sm:col-span-3">`);
        _push(ssrRenderComponent(unref(_sfc_main$1), {
          json: true,
          id: "brands",
          multiple: true,
          searchable: true,
          label: _ctx.$t("Brands"),
          suggestions: __props.brands,
          modelValue: __props.filters.brands,
          "onUpdate:modelValue": ($event) => __props.filters.brands = $event
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      if (__props.fields.includes("categories")) {
        _push(`<div class="col-span-6 sm:col-span-3">`);
        _push(ssrRenderComponent(unref(_sfc_main$1), {
          json: true,
          id: "categories",
          multiple: true,
          searchable: true,
          label: _ctx.$t("Categories"),
          suggestions: __props.categories,
          modelValue: __props.filters.categories,
          "onUpdate:modelValue": ($event) => __props.filters.categories = $event
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      if (__props.fields.includes("products")) {
        _push(`<div class="col-span-6 sm:col-span-3">`);
        _push(ssrRenderComponent(unref(_sfc_main$1), {
          json: true,
          valueKey: "id",
          id: "products",
          labelKey: "name",
          multiple: true,
          searchable: true,
          label: _ctx.$t("Products"),
          modelValue: __props.filters.products,
          "onUpdate:modelValue": ($event) => __props.filters.products = $event,
          suggestions: _ctx.route("search.products")
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      if (__props.fields.includes("customer")) {
        _push(`<div class="col-span-6 sm:col-span-3">`);
        _push(ssrRenderComponent(unref(_sfc_main$1), {
          json: true,
          valueKey: "id",
          id: "customer_id",
          labelKey: "company",
          clearable: true,
          searchable: true,
          label: _ctx.$t("Customer"),
          modelValue: __props.filters.customer_id,
          "onUpdate:modelValue": ($event) => __props.filters.customer_id = $event,
          suggestions: _ctx.route("search.customers")
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      if (__props.fields.includes("supplier")) {
        _push(`<div class="col-span-6 sm:col-span-3">`);
        _push(ssrRenderComponent(unref(_sfc_main$1), {
          json: true,
          valueKey: "id",
          id: "supplier_id",
          labelKey: "company",
          clearable: true,
          searchable: true,
          label: _ctx.$t("Supplier"),
          modelValue: __props.filters.supplier_id,
          "onUpdate:modelValue": ($event) => __props.filters.supplier_id = $event,
          suggestions: _ctx.route("search.suppliers")
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      if (__props.fields.includes("store")) {
        _push(`<div class="col-span-6 sm:col-span-3">`);
        _push(ssrRenderComponent(unref(_sfc_main$1), {
          json: true,
          id: "store_id",
          clearable: true,
          searchable: false,
          label: _ctx.$t("Store"),
          suggestions: __props.stores,
          modelValue: __props.filters.store_id,
          "onUpdate:modelValue": ($event) => __props.filters.store_id = $event
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      if (__props.fields.includes("user")) {
        _push(`<div class="col-span-6 sm:col-span-3">`);
        _push(ssrRenderComponent(unref(_sfc_main$1), {
          json: true,
          id: "user_id",
          clearable: true,
          searchable: false,
          label: _ctx.$t("User"),
          suggestions: __props.users,
          modelValue: __props.filters.user_id,
          "onUpdate:modelValue": ($event) => __props.filters.user_id = $event
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "start_date",
        label: _ctx.$t("Start Date"),
        modelValue: __props.filters.start_date,
        "onUpdate:modelValue": ($event) => __props.filters.start_date = $event
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "end_date",
        label: _ctx.$t("End Date"),
        modelValue: __props.filters.end_date,
        "onUpdate:modelValue": ($event) => __props.filters.end_date = $event
      }, null, _parent));
      _push(`</div></div><div class="flex flex-row justify-end rounded-b-lg px-6 py-4 bg-gray-100 dark:bg-gray-950 text-end">`);
      _push(ssrRenderComponent(unref(_sfc_main$3), { onClick: close }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Cancel"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Cancel")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$4), { class: "ms-3" }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Update"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Update")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></form>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Report/Form.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
