import { ref, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent } from "vue/server-renderer";
import "../ssr.js";
import { usePage, useForm } from "@inertiajs/vue3";
import "lodash.debounce";
import "dayjs";
import { h as _sfc_main$1, v as _sfc_main$2 } from "./http-CDixhmav.js";
import { _ as _sfc_main$4 } from "./LoadingButton-DREeyNQW.js";
import "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import { _ as _sfc_main$3 } from "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = {
  __name: "Form",
  __ssrInlineRender: true,
  props: ["current"],
  emits: ["close", "done"],
  setup(__props, { emit: __emit }) {
    var _a, _b, _c, _d;
    usePage();
    const props = __props;
    const emits = __emit;
    ref([]);
    const form = useForm({
      _method: ((_a = props.current) == null ? void 0 : _a.id) ? "put" : "post",
      name: (_b = props.current) == null ? void 0 : _b.name,
      permissions: ((_d = (_c = props.current) == null ? void 0 : _c.permissions) == null ? void 0 : _d.map((p) => p.name)) || []
    });
    const updatePermissions = (v, force) => {
      if (!force && form.permissions.includes(v)) {
        form.permissions = form.permissions.filter((r) => r != v);
      } else {
        form.permissions = [...form.permissions, v];
      }
    };
    const close = () => {
      form.reset();
      emits("close");
    };
    const toggleAll = (e, type) => {
      var aa = document.querySelectorAll("input[type=checkbox]");
      for (var i = 0; i < aa.length; i++) {
        if (type) {
          if (aa[i].value.includes(type) && !["read-all", "update-all", "read-activity"].includes(aa[i].value)) {
            updatePermissions(aa[i].value, e.target.checked);
          }
        } else {
          updatePermissions(aa[i].value, e.target.checked);
        }
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      var _a2, _b2;
      _push(`<form${ssrRenderAttrs(_attrs)}><div class="border-b border-gray-200 dark:border-gray-700 px-6 py-4"><div class="sm:flex sm:items-baseline sm:justify-between"><div class="sm:w-0 sm:flex-1"><h1 class="text-base font-semibold text-focus">${ssrInterpolate(((_a2 = __props.current) == null ? void 0 : _a2.id) ? _ctx.$t("Edit {x}", { x: _ctx.$t("Role") }) : _ctx.$t("Add {x}", { x: _ctx.$t("Role") }))}</h1><p class="mt-1 truncate text-sm text-mute">${ssrInterpolate(_ctx.$t("Please fill the form below to {action} {record}.", {
        record: _ctx.$t("Role"),
        action: ((_b2 = __props.current) == null ? void 0 : _b2.id) ? _ctx.$t("edit") : _ctx.$t("add")
      }))}</p></div></div></div><div class="px-6 pb-6 grid grid-cols-6 gap-6"><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        id: "name",
        label: _ctx.$t("Name"),
        modelValue: unref(form).name,
        "onUpdate:modelValue": ($event) => unref(form).name = $event,
        error: unref(form).errors.name
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3 xl:col-span-4 mt-3 -mb-3 opacity-80">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "select-all",
        label: _ctx.$t("Check/Uncheck All"),
        onInput: toggleAll
      }, null, _parent));
      _push(`</div><div class="col-span-full overflow-x-auto p-2 -m-2"><table class="w-full"><tbody><tr><td class="pr-6 opacity-80"><div class="mr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "vall",
        onInput: (e) => toggleAll(e, "read"),
        label: _ctx.$t("View All")
      }, null, _parent));
      _push(`</div></td><td class="pr-6 opacity-80"><div class="mr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "call",
        onInput: (e) => toggleAll(e, "create"),
        label: _ctx.$t("Create All")
      }, null, _parent));
      _push(`</div></td><td class="pr-6 opacity-80"><div class="mr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "uall",
        onInput: (e) => toggleAll(e, "update"),
        label: _ctx.$t("Update All")
      }, null, _parent));
      _push(`</div></td><td class="pr-6 opacity-80"><div class="mr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "dall",
        onInput: (e) => toggleAll(e, "delete"),
        label: _ctx.$t("Delete All")
      }, null, _parent));
      _push(`</div></td></tr><tr><td colspan="5" class="pb-3 pt-8"><label class="block w-full font-bold">${ssrInterpolate(_ctx.$t("Sales"))}</label></td></tr><tr><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "read-sales",
        value: "read-sales",
        label: _ctx.$t("View"),
        onInput: ($event) => updatePermissions("read-sales"),
        checked: unref(form).permissions.includes("read-sales")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "create-sales",
        value: "create-sales",
        label: _ctx.$t("Create"),
        onInput: ($event) => updatePermissions("create-sales"),
        checked: unref(form).permissions.includes("create-sales")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "update-sales",
        value: "update-sales",
        label: _ctx.$t("Update"),
        onInput: ($event) => updatePermissions("update-sales"),
        checked: unref(form).permissions.includes("update-sales")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "delete-sales",
        value: "delete-sales",
        label: _ctx.$t("Delete"),
        onInput: ($event) => updatePermissions("delete-sales"),
        checked: unref(form).permissions.includes("delete-sales")
      }, null, _parent));
      _push(`</td></tr>`);
      if (_ctx.$page.props.pos_module) {
        _push(`<tr><td class="pr-6 pt-3" colspan="100%"><div class="flex flex-wrap items-center gap-x-6 gap-y-3">`);
        _push(ssrRenderComponent(unref(_sfc_main$2), {
          id: "read-pos",
          value: "read-pos",
          label: _ctx.$t("POS"),
          onInput: ($event) => updatePermissions("read-pos"),
          checked: unref(form).permissions.includes("read-pos")
        }, null, _parent));
        _push(ssrRenderComponent(unref(_sfc_main$2), {
          id: "delete-order-item",
          value: "delete-order-item",
          label: _ctx.$t("Can remove order items"),
          onInput: ($event) => updatePermissions("delete-order-item"),
          checked: unref(form).permissions.includes("delete-order-item")
        }, null, _parent));
        _push(ssrRenderComponent(unref(_sfc_main$2), {
          id: "delete-orders",
          value: "delete-orders",
          onInput: ($event) => updatePermissions("delete-orders"),
          label: _ctx.$t("Delete {x}", { x: _ctx.$t("Orders") }),
          checked: unref(form).permissions.includes("delete-orders")
        }, null, _parent));
        _push(`</div></td></tr>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<tr><td class="pr-6 pt-3" colspan="100%"><div class="flex flex-wrap items-center gap-x-6 gap-y-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "email-sales",
        value: "email-sales",
        onInput: ($event) => updatePermissions("email-sales"),
        label: _ctx.$t("Email {x}", { x: _ctx.$t("Sales") }),
        checked: unref(form).permissions.includes("email-sales")
      }, null, _parent));
      _push(`</div></td></tr><tr><td colspan="5" class="pb-3 pt-8"><label class="block w-full font-bold">${ssrInterpolate(_ctx.$t("Deliveries"))}</label></td></tr><tr><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        label: _ctx.$t("View"),
        id: "read-deliveries",
        value: "read-deliveries",
        onInput: ($event) => updatePermissions("read-deliveries"),
        checked: unref(form).permissions.includes("read-deliveries")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "create-deliveries",
        value: "create-deliveries",
        label: _ctx.$t("Create"),
        onInput: ($event) => updatePermissions("create-deliveries"),
        checked: unref(form).permissions.includes("create-deliveries")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "update-deliveries",
        value: "update-deliveries",
        label: _ctx.$t("Update"),
        onInput: ($event) => updatePermissions("update-deliveries"),
        checked: unref(form).permissions.includes("update-deliveries")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "delete-deliveries",
        value: "delete-deliveries",
        label: _ctx.$t("Delete"),
        onInput: ($event) => updatePermissions("delete-deliveries"),
        checked: unref(form).permissions.includes("delete-deliveries")
      }, null, _parent));
      _push(`</td></tr><tr><td colspan="5" class="pb-3 pt-8"><label class="block w-full font-bold">${ssrInterpolate(_ctx.$t("Customers"))}</label></td></tr><tr><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        label: _ctx.$t("View"),
        id: "read-customers",
        value: "read-customers",
        onInput: ($event) => updatePermissions("read-customers"),
        checked: unref(form).permissions.includes("read-customers")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "create-customers",
        value: "create-customers",
        label: _ctx.$t("Create"),
        onInput: ($event) => updatePermissions("create-customers"),
        checked: unref(form).permissions.includes("create-customers")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "update-customers",
        value: "update-customers",
        label: _ctx.$t("Update"),
        onInput: ($event) => updatePermissions("update-customers"),
        checked: unref(form).permissions.includes("update-customers")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "delete-customers",
        value: "delete-customers",
        label: _ctx.$t("Delete"),
        onInput: ($event) => updatePermissions("delete-customers"),
        checked: unref(form).permissions.includes("delete-customers")
      }, null, _parent));
      _push(`</td></tr><tr><td class="pr-6 pt-3" colspan="100%"><div class="flex flex-wrap items-center gap-x-6 gap-y-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "export-customers",
        value: "export-customers",
        onInput: ($event) => updatePermissions("export-customers"),
        label: _ctx.$t("Export {x}", { x: _ctx.$t("Customers") }),
        checked: unref(form).permissions.includes("export-customers")
      }, null, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "import-customers",
        value: "import-customers",
        onInput: ($event) => updatePermissions("import-customers"),
        label: _ctx.$t("Import {x}", { x: _ctx.$t("Customers") }),
        checked: unref(form).permissions.includes("import-customers")
      }, null, _parent));
      _push(`</div></td></tr><tr><td colspan="5" class="pb-3 pt-8"><label class="block w-full font-bold">${ssrInterpolate(_ctx.$t("Purchases"))}</label></td></tr><tr><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        label: _ctx.$t("View"),
        id: "read-purchases",
        value: "read-purchases",
        onInput: ($event) => updatePermissions("read-purchases"),
        checked: unref(form).permissions.includes("read-purchases")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "create-purchases",
        value: "create-purchases",
        label: _ctx.$t("Create"),
        onInput: ($event) => updatePermissions("create-purchases"),
        checked: unref(form).permissions.includes("create-purchases")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "update-purchases",
        value: "update-purchases",
        label: _ctx.$t("Update"),
        onInput: ($event) => updatePermissions("update-purchases"),
        checked: unref(form).permissions.includes("update-purchases")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "delete-purchases",
        value: "delete-purchases",
        label: _ctx.$t("Delete"),
        onInput: ($event) => updatePermissions("delete-purchases"),
        checked: unref(form).permissions.includes("delete-purchases")
      }, null, _parent));
      _push(`</td></tr><tr><td class="pr-6 pt-3" colspan="100%"><div class="flex flex-wrap items-center gap-x-6 gap-y-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "email-purchases",
        value: "email-purchases",
        onInput: ($event) => updatePermissions("email-purchases"),
        label: _ctx.$t("Email {x}", { x: _ctx.$t("Purchases") }),
        checked: unref(form).permissions.includes("email-purchases")
      }, null, _parent));
      _push(`</div></td></tr><tr><td colspan="5" class="pb-3 pt-8"><label class="block w-full font-bold">${ssrInterpolate(_ctx.$t("Suppliers"))}</label></td></tr><tr><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        label: _ctx.$t("View"),
        id: "read-suppliers",
        value: "read-suppliers",
        onInput: ($event) => updatePermissions("read-suppliers"),
        checked: unref(form).permissions.includes("read-suppliers")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "create-suppliers",
        value: "create-suppliers",
        label: _ctx.$t("Create"),
        onInput: ($event) => updatePermissions("create-suppliers"),
        checked: unref(form).permissions.includes("create-suppliers")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "update-suppliers",
        value: "update-suppliers",
        label: _ctx.$t("Update"),
        onInput: ($event) => updatePermissions("update-suppliers"),
        checked: unref(form).permissions.includes("update-suppliers")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "delete-suppliers",
        value: "delete-suppliers",
        label: _ctx.$t("Delete"),
        onInput: ($event) => updatePermissions("delete-suppliers"),
        checked: unref(form).permissions.includes("delete-suppliers")
      }, null, _parent));
      _push(`</td></tr><tr><td class="pr-6 pt-3" colspan="100%"><div class="flex flex-wrap items-center gap-x-6 gap-y-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "export-suppliers",
        value: "export-suppliers",
        onInput: ($event) => updatePermissions("export-suppliers"),
        label: _ctx.$t("Export {x}", { x: _ctx.$t("Suppliers") }),
        checked: unref(form).permissions.includes("export-suppliers")
      }, null, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "import-suppliers",
        value: "import-suppliers",
        onInput: ($event) => updatePermissions("import-suppliers"),
        label: _ctx.$t("Import {x}", { x: _ctx.$t("Suppliers") }),
        checked: unref(form).permissions.includes("import-suppliers")
      }, null, _parent));
      _push(`</div></td></tr><tr><td colspan="5" class="pb-3 pt-8"><label class="block w-full font-bold">${ssrInterpolate(_ctx.$t("Payments"))}</label></td></tr><tr><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        label: _ctx.$t("View"),
        id: "read-payments",
        value: "read-payments",
        onInput: ($event) => updatePermissions("read-payments"),
        checked: unref(form).permissions.includes("read-payments")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "create-payments",
        value: "create-payments",
        label: _ctx.$t("Create"),
        onInput: ($event) => updatePermissions("create-payments"),
        checked: unref(form).permissions.includes("create-payments")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "update-payments",
        value: "update-payments",
        label: _ctx.$t("Update"),
        onInput: ($event) => updatePermissions("update-payments"),
        checked: unref(form).permissions.includes("update-payments")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "delete-payments",
        value: "delete-payments",
        label: _ctx.$t("Delete"),
        onInput: ($event) => updatePermissions("delete-payments"),
        checked: unref(form).permissions.includes("delete-payments")
      }, null, _parent));
      _push(`</td></tr><tr><td class="pr-6 pt-3" colspan="100%"><div class="flex flex-wrap items-center gap-x-6 gap-y-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "email-payments",
        value: "email-payments",
        onInput: ($event) => updatePermissions("email-payments"),
        label: _ctx.$t("Email {x}", { x: _ctx.$t("Payments") }),
        checked: unref(form).permissions.includes("email-payments")
      }, null, _parent));
      _push(`</div></td></tr><tr><td colspan="5" class="pb-3 pt-8"><label class="block w-full font-bold">${ssrInterpolate(_ctx.$t("Quotations"))}</label></td></tr><tr><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        label: _ctx.$t("View"),
        id: "read-quotations",
        value: "read-quotations",
        onInput: ($event) => updatePermissions("read-quotations"),
        checked: unref(form).permissions.includes("read-quotations")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "create-quotations",
        value: "create-quotations",
        label: _ctx.$t("Create"),
        onInput: ($event) => updatePermissions("create-quotations"),
        checked: unref(form).permissions.includes("create-quotations")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "update-quotations",
        value: "update-quotations",
        label: _ctx.$t("Update"),
        onInput: ($event) => updatePermissions("update-quotations"),
        checked: unref(form).permissions.includes("update-quotations")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "delete-quotations",
        value: "delete-quotations",
        label: _ctx.$t("Delete"),
        onInput: ($event) => updatePermissions("delete-quotations"),
        checked: unref(form).permissions.includes("delete-quotations")
      }, null, _parent));
      _push(`</td></tr><tr><td class="pr-6 pt-3" colspan="100%"><div class="flex flex-wrap items-center gap-x-6 gap-y-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "email-quotations",
        value: "email-quotations",
        onInput: ($event) => updatePermissions("email-quotations"),
        label: _ctx.$t("Email {x}", { x: _ctx.$t("Quotations") }),
        checked: unref(form).permissions.includes("email-quotations")
      }, null, _parent));
      _push(`</div></td></tr><tr><td colspan="5" class="pb-3 pt-8"><label class="block w-full font-bold">${ssrInterpolate(_ctx.$t("Expenses"))}</label></td></tr><tr><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        label: _ctx.$t("View"),
        id: "read-expenses",
        value: "read-expenses",
        onInput: ($event) => updatePermissions("read-expenses"),
        checked: unref(form).permissions.includes("read-expenses")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "create-expenses",
        value: "create-expenses",
        label: _ctx.$t("Create"),
        onInput: ($event) => updatePermissions("create-expenses"),
        checked: unref(form).permissions.includes("create-expenses")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "update-expenses",
        value: "update-expenses",
        label: _ctx.$t("Update"),
        onInput: ($event) => updatePermissions("update-expenses"),
        checked: unref(form).permissions.includes("update-expenses")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "delete-expenses",
        value: "delete-expenses",
        label: _ctx.$t("Delete"),
        onInput: ($event) => updatePermissions("delete-expenses"),
        checked: unref(form).permissions.includes("delete-expenses")
      }, null, _parent));
      _push(`</td></tr><tr><td colspan="5" class="pb-3 pt-8"><label class="block w-full font-bold">${ssrInterpolate(_ctx.$t("Return Orders"))}</label></td></tr><tr><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        label: _ctx.$t("View"),
        id: "read-return-orders",
        value: "read-return-orders",
        onInput: ($event) => updatePermissions("read-return-orders"),
        checked: unref(form).permissions.includes("read-return-orders")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "create-return-orders",
        value: "create-return-orders",
        label: _ctx.$t("Create"),
        onInput: ($event) => updatePermissions("create-return-orders"),
        checked: unref(form).permissions.includes("create-return-orders")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "update-return-orders",
        value: "update-return-orders",
        label: _ctx.$t("Update"),
        onInput: ($event) => updatePermissions("update-return-orders"),
        checked: unref(form).permissions.includes("update-return-orders")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "delete-return-orders",
        value: "delete-return-orders",
        label: _ctx.$t("Delete"),
        onInput: ($event) => updatePermissions("delete-return-orders"),
        checked: unref(form).permissions.includes("delete-return-orders")
      }, null, _parent));
      _push(`</td></tr><tr><td class="pr-6 pt-3" colspan="100%"><div class="flex flex-wrap items-center gap-x-6 gap-y-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "email-return-order",
        value: "email-return-order",
        onInput: ($event) => updatePermissions("email-return-order"),
        label: _ctx.$t("Email {x}", { x: _ctx.$t("Return Order") }),
        checked: unref(form).permissions.includes("email-return-order")
      }, null, _parent));
      _push(`</div></td></tr><tr><td colspan="5" class="pb-3 pt-8"><label class="block w-full font-bold">${ssrInterpolate(_ctx.$t("Gift Cards"))}</label></td></tr><tr><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        label: _ctx.$t("View"),
        id: "read-gift-cards",
        value: "read-gift-cards",
        onInput: ($event) => updatePermissions("read-gift-cards"),
        checked: unref(form).permissions.includes("read-gift-cards")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "create-gift-cards",
        value: "create-gift-cards",
        label: _ctx.$t("Create"),
        onInput: ($event) => updatePermissions("create-gift-cards"),
        checked: unref(form).permissions.includes("create-gift-cards")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "update-gift-cards",
        value: "update-gift-cards",
        label: _ctx.$t("Update"),
        onInput: ($event) => updatePermissions("update-gift-cards"),
        checked: unref(form).permissions.includes("update-gift-cards")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "delete-gift-cards",
        value: "delete-gift-cards",
        label: _ctx.$t("Delete"),
        onInput: ($event) => updatePermissions("delete-gift-cards"),
        checked: unref(form).permissions.includes("delete-gift-cards")
      }, null, _parent));
      _push(`</td></tr><tr><td colspan="5" class="pb-3 pt-8"><label class="block w-full font-bold">${ssrInterpolate(_ctx.$t("Products"))}</label></td></tr><tr><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        label: _ctx.$t("View"),
        id: "read-products",
        value: "read-products",
        onInput: ($event) => updatePermissions("read-products"),
        checked: unref(form).permissions.includes("read-products")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "create-products",
        value: "create-products",
        label: _ctx.$t("Create"),
        onInput: ($event) => updatePermissions("create-products"),
        checked: unref(form).permissions.includes("create-products")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "update-products",
        value: "update-products",
        label: _ctx.$t("Update"),
        onInput: ($event) => updatePermissions("update-products"),
        checked: unref(form).permissions.includes("update-products")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "delete-products",
        value: "delete-products",
        label: _ctx.$t("Delete"),
        onInput: ($event) => updatePermissions("delete-products"),
        checked: unref(form).permissions.includes("delete-products")
      }, null, _parent));
      _push(`</td></tr><tr><td class="pr-6 pt-3" colspan="100%"><div class="flex flex-wrap items-center gap-x-6 gap-y-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "export-products",
        value: "export-products",
        onInput: ($event) => updatePermissions("export-products"),
        label: _ctx.$t("Export {x}", { x: _ctx.$t("Products") }),
        checked: unref(form).permissions.includes("export-products")
      }, null, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "import-products",
        value: "import-products",
        onInput: ($event) => updatePermissions("import-products"),
        label: _ctx.$t("Import {x}", { x: _ctx.$t("Products") }),
        checked: unref(form).permissions.includes("import-products")
      }, null, _parent));
      _push(`</div></td></tr><tr><td colspan="5" class="pb-3 pt-8"><label class="block w-full font-bold">${ssrInterpolate(_ctx.$t("Stock Counts"))}</label></td></tr><tr><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        label: _ctx.$t("View"),
        id: "read-stock-counts",
        value: "read-stock-counts",
        onInput: ($event) => updatePermissions("read-stock-counts"),
        checked: unref(form).permissions.includes("read-stock-counts")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "create-stock-counts",
        value: "create-stock-counts",
        label: _ctx.$t("Initiate"),
        onInput: ($event) => updatePermissions("create-stock-counts"),
        checked: unref(form).permissions.includes("create-stock-counts")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "update-stock-counts",
        value: "update-stock-counts",
        label: _ctx.$t("Complete"),
        onInput: ($event) => updatePermissions("update-stock-counts"),
        checked: unref(form).permissions.includes("update-stock-counts")
      }, null, _parent));
      _push(`</td><td class="pr-6"></td></tr><tr><td colspan="5" class="pb-3 pt-8"><label class="block w-full font-bold">${ssrInterpolate(_ctx.$t("Adjustments"))}</label></td></tr><tr><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        label: _ctx.$t("View"),
        id: "read-adjustments",
        value: "read-adjustments",
        onInput: ($event) => updatePermissions("read-adjustments"),
        checked: unref(form).permissions.includes("read-adjustments")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "create-adjustments",
        value: "create-adjustments",
        label: _ctx.$t("Create"),
        onInput: ($event) => updatePermissions("create-adjustments"),
        checked: unref(form).permissions.includes("create-adjustments")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "update-adjustments",
        value: "update-adjustments",
        label: _ctx.$t("Update"),
        onInput: ($event) => updatePermissions("update-adjustments"),
        checked: unref(form).permissions.includes("update-adjustments")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "delete-adjustments",
        value: "delete-adjustments",
        label: _ctx.$t("Delete"),
        onInput: ($event) => updatePermissions("delete-adjustments"),
        checked: unref(form).permissions.includes("delete-adjustments")
      }, null, _parent));
      _push(`</td></tr><tr><td colspan="5" class="pb-3 pt-8"><label class="block w-full font-bold">${ssrInterpolate(_ctx.$t("Transfers"))}</label></td></tr><tr><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        label: _ctx.$t("View"),
        id: "read-transfers",
        value: "read-transfers",
        onInput: ($event) => updatePermissions("read-transfers"),
        checked: unref(form).permissions.includes("read-transfers")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "create-transfers",
        value: "create-transfers",
        label: _ctx.$t("Create"),
        onInput: ($event) => updatePermissions("create-transfers"),
        checked: unref(form).permissions.includes("create-transfers")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "update-transfers",
        value: "update-transfers",
        label: _ctx.$t("Update"),
        onInput: ($event) => updatePermissions("update-transfers"),
        checked: unref(form).permissions.includes("update-transfers")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "delete-transfers",
        value: "delete-transfers",
        label: _ctx.$t("Delete"),
        onInput: ($event) => updatePermissions("delete-transfers"),
        checked: unref(form).permissions.includes("delete-transfers")
      }, null, _parent));
      _push(`</td></tr><tr><td colspan="5" class="pb-3 pt-8"><label class="block w-full font-bold">${ssrInterpolate(_ctx.$t("Promotions"))}</label></td></tr><tr><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        label: _ctx.$t("View"),
        id: "read-promotions",
        value: "read-promotions",
        onInput: ($event) => updatePermissions("read-promotions"),
        checked: unref(form).permissions.includes("read-promotions")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "create-promotions",
        value: "create-promotions",
        label: _ctx.$t("Create"),
        onInput: ($event) => updatePermissions("create-promotions"),
        checked: unref(form).permissions.includes("create-promotions")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "update-promotions",
        value: "update-promotions",
        label: _ctx.$t("Update"),
        onInput: ($event) => updatePermissions("update-promotions"),
        checked: unref(form).permissions.includes("update-promotions")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "delete-promotions",
        value: "delete-promotions",
        label: _ctx.$t("Delete"),
        onInput: ($event) => updatePermissions("delete-promotions"),
        checked: unref(form).permissions.includes("delete-promotions")
      }, null, _parent));
      _push(`</td></tr><tr><td colspan="5" class="pb-3 pt-8"><label class="block w-full font-bold">${ssrInterpolate(_ctx.$t("Brands"))}</label></td></tr><tr><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        label: _ctx.$t("View"),
        id: "read-brands",
        value: "read-brands",
        onInput: ($event) => updatePermissions("read-brands"),
        checked: unref(form).permissions.includes("read-brands")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "create-brands",
        value: "create-brands",
        label: _ctx.$t("Create"),
        onInput: ($event) => updatePermissions("create-brands"),
        checked: unref(form).permissions.includes("create-brands")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "update-brands",
        value: "update-brands",
        label: _ctx.$t("Update"),
        onInput: ($event) => updatePermissions("update-brands"),
        checked: unref(form).permissions.includes("update-brands")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "delete-brands",
        value: "delete-brands",
        label: _ctx.$t("Delete"),
        onInput: ($event) => updatePermissions("delete-brands"),
        checked: unref(form).permissions.includes("delete-brands")
      }, null, _parent));
      _push(`</td></tr><tr><td class="pr-6 pt-3" colspan="100%"><div class="flex flex-wrap items-center gap-x-6 gap-y-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "export-brands",
        value: "export-brands",
        onInput: ($event) => updatePermissions("export-brands"),
        label: _ctx.$t("Export {x}", { x: _ctx.$t("Brands") }),
        checked: unref(form).permissions.includes("export-brands")
      }, null, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "import-brands",
        value: "import-brands",
        onInput: ($event) => updatePermissions("import-brands"),
        label: _ctx.$t("Import {x}", { x: _ctx.$t("Brands") }),
        checked: unref(form).permissions.includes("import-brands")
      }, null, _parent));
      _push(`</div></td></tr><tr><td colspan="5" class="pb-3 pt-8"><label class="block w-full font-bold">${ssrInterpolate(_ctx.$t("Categories"))}</label></td></tr><tr><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        label: _ctx.$t("View"),
        id: "read-categories",
        value: "read-categories",
        onInput: ($event) => updatePermissions("read-categories"),
        checked: unref(form).permissions.includes("read-categories")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "create-categories",
        value: "create-categories",
        label: _ctx.$t("Create"),
        onInput: ($event) => updatePermissions("create-categories"),
        checked: unref(form).permissions.includes("create-categories")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "update-categories",
        value: "update-categories",
        label: _ctx.$t("Update"),
        onInput: ($event) => updatePermissions("update-categories"),
        checked: unref(form).permissions.includes("update-categories")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "delete-categories",
        value: "delete-categories",
        label: _ctx.$t("Delete"),
        onInput: ($event) => updatePermissions("delete-categories"),
        checked: unref(form).permissions.includes("delete-categories")
      }, null, _parent));
      _push(`</td></tr><tr><td class="pr-6 pt-3" colspan="100%"><div class="flex flex-wrap items-center gap-x-6 gap-y-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "export-categories",
        value: "export-categories",
        onInput: ($event) => updatePermissions("export-categories"),
        label: _ctx.$t("Export {x}", { x: _ctx.$t("Categories") }),
        checked: unref(form).permissions.includes("export-categories")
      }, null, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "import-categories",
        value: "import-categories",
        onInput: ($event) => updatePermissions("import-categories"),
        label: _ctx.$t("Import {x}", { x: _ctx.$t("Categories") }),
        checked: unref(form).permissions.includes("import-categories")
      }, null, _parent));
      _push(`</div></td></tr><tr><td colspan="5" class="pb-3 pt-8"><label class="block w-full font-bold">${ssrInterpolate(_ctx.$t("Units"))}</label></td></tr><tr><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        label: _ctx.$t("View"),
        id: "read-units",
        value: "read-units",
        onInput: ($event) => updatePermissions("read-units"),
        checked: unref(form).permissions.includes("read-units")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "create-units",
        value: "create-units",
        label: _ctx.$t("Create"),
        onInput: ($event) => updatePermissions("create-units"),
        checked: unref(form).permissions.includes("create-units")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "update-units",
        value: "update-units",
        label: _ctx.$t("Update"),
        onInput: ($event) => updatePermissions("update-units"),
        checked: unref(form).permissions.includes("update-units")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "delete-units",
        value: "delete-units",
        label: _ctx.$t("Delete"),
        onInput: ($event) => updatePermissions("delete-units"),
        checked: unref(form).permissions.includes("delete-units")
      }, null, _parent));
      _push(`</td></tr><tr><td colspan="5" class="pb-3 pt-8"><label class="block w-full font-bold">${ssrInterpolate(_ctx.$t("Taxes"))}</label></td></tr><tr><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        label: _ctx.$t("View"),
        id: "read-taxes",
        value: "read-taxes",
        onInput: ($event) => updatePermissions("read-taxes"),
        checked: unref(form).permissions.includes("read-taxes")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "create-taxes",
        value: "create-taxes",
        label: _ctx.$t("Create"),
        onInput: ($event) => updatePermissions("create-taxes"),
        checked: unref(form).permissions.includes("create-taxes")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "update-taxes",
        value: "update-taxes",
        label: _ctx.$t("Update"),
        onInput: ($event) => updatePermissions("update-taxes"),
        checked: unref(form).permissions.includes("update-taxes")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "delete-taxes",
        value: "delete-taxes",
        label: _ctx.$t("Delete"),
        onInput: ($event) => updatePermissions("delete-taxes"),
        checked: unref(form).permissions.includes("delete-taxes")
      }, null, _parent));
      _push(`</td></tr><tr><td colspan="5" class="pb-3 pt-8"><label class="block w-full font-bold">${ssrInterpolate(_ctx.$t("Accounts"))}</label></td></tr><tr><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        label: _ctx.$t("View"),
        id: "read-accounts",
        value: "read-accounts",
        onInput: ($event) => updatePermissions("read-accounts"),
        checked: unref(form).permissions.includes("read-accounts")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "create-accounts",
        value: "create-accounts",
        label: _ctx.$t("Create"),
        onInput: ($event) => updatePermissions("create-accounts"),
        checked: unref(form).permissions.includes("create-accounts")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "update-accounts",
        value: "update-accounts",
        label: _ctx.$t("Update"),
        onInput: ($event) => updatePermissions("update-accounts"),
        checked: unref(form).permissions.includes("update-accounts")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "delete-accounts",
        value: "delete-accounts",
        label: _ctx.$t("Delete"),
        onInput: ($event) => updatePermissions("delete-accounts"),
        checked: unref(form).permissions.includes("delete-accounts")
      }, null, _parent));
      _push(`</td></tr><tr><td colspan="5" class="pb-3 pt-8"><label class="block w-full font-bold">${ssrInterpolate(_ctx.$t("Stores"))}</label></td></tr><tr><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        label: _ctx.$t("View"),
        id: "read-stores",
        value: "read-stores",
        onInput: ($event) => updatePermissions("read-stores"),
        checked: unref(form).permissions.includes("read-stores")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "create-stores",
        value: "create-stores",
        label: _ctx.$t("Create"),
        onInput: ($event) => updatePermissions("create-stores"),
        checked: unref(form).permissions.includes("create-stores")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "update-stores",
        value: "update-stores",
        label: _ctx.$t("Update"),
        onInput: ($event) => updatePermissions("update-stores"),
        checked: unref(form).permissions.includes("update-stores")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "delete-stores",
        value: "delete-stores",
        label: _ctx.$t("Delete"),
        onInput: ($event) => updatePermissions("delete-stores"),
        checked: unref(form).permissions.includes("delete-stores")
      }, null, _parent));
      _push(`</td></tr><tr><td colspan="5" class="pb-3 pt-8"><label class="block w-full font-bold">${ssrInterpolate(_ctx.$t("Custom Fields"))}</label></td></tr><tr><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        label: _ctx.$t("View"),
        id: "read-custom-fields",
        value: "read-custom-fields",
        onInput: ($event) => updatePermissions("read-custom-fields"),
        checked: unref(form).permissions.includes("read-custom-fields")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "create-custom-fields",
        value: "create-custom-fields",
        label: _ctx.$t("Create"),
        onInput: ($event) => updatePermissions("create-custom-fields"),
        checked: unref(form).permissions.includes("create-custom-fields")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "update-custom-fields",
        value: "update-custom-fields",
        label: _ctx.$t("Update"),
        onInput: ($event) => updatePermissions("update-custom-fields"),
        checked: unref(form).permissions.includes("update-custom-fields")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "delete-custom-fields",
        value: "delete-custom-fields",
        label: _ctx.$t("Delete"),
        onInput: ($event) => updatePermissions("delete-custom-fields"),
        checked: unref(form).permissions.includes("delete-custom-fields")
      }, null, _parent));
      _push(`</td></tr><tr><td colspan="5" class="pb-3 pt-8"><label class="block w-full font-bold">${ssrInterpolate(_ctx.$t("Users"))}</label></td></tr><tr><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        label: _ctx.$t("View"),
        id: "read-users",
        value: "read-users",
        onInput: ($event) => updatePermissions("read-users"),
        checked: unref(form).permissions.includes("read-users")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "create-users",
        value: "create-users",
        label: _ctx.$t("Create"),
        onInput: ($event) => updatePermissions("create-users"),
        checked: unref(form).permissions.includes("create-users")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "update-users",
        value: "update-users",
        label: _ctx.$t("Update"),
        onInput: ($event) => updatePermissions("update-users"),
        checked: unref(form).permissions.includes("update-users")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "delete-users",
        value: "delete-users",
        label: _ctx.$t("Delete"),
        onInput: ($event) => updatePermissions("delete-users"),
        checked: unref(form).permissions.includes("delete-users")
      }, null, _parent));
      _push(`</td></tr><tr><td colspan="5" class="pb-3 pt-8"><label class="block w-full font-bold">${ssrInterpolate(_ctx.$t("Roles"))}</label></td></tr><tr><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        label: _ctx.$t("View"),
        id: "read-roles",
        value: "read-roles",
        onInput: ($event) => updatePermissions("read-roles"),
        checked: unref(form).permissions.includes("read-roles")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "create-roles",
        value: "create-roles",
        label: _ctx.$t("Create"),
        onInput: ($event) => updatePermissions("create-roles"),
        checked: unref(form).permissions.includes("create-roles")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "update-roles",
        value: "update-roles",
        label: _ctx.$t("Update"),
        onInput: ($event) => updatePermissions("update-roles"),
        checked: unref(form).permissions.includes("update-roles")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "delete-roles",
        value: "delete-roles",
        label: _ctx.$t("Delete"),
        onInput: ($event) => updatePermissions("delete-roles"),
        checked: unref(form).permissions.includes("delete-roles")
      }, null, _parent));
      _push(`</td></tr><tr><td colspan="5" class="pb-3 pt-8"><label class="block w-full font-bold">${ssrInterpolate(_ctx.$t("Customer Groups"))}</label></td></tr><tr><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        label: _ctx.$t("View"),
        id: "read-customer-groups",
        value: "read-customer-groups",
        onInput: ($event) => updatePermissions("read-customer-groups"),
        checked: unref(form).permissions.includes("read-customer-groups")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "create-customer-groups",
        value: "create-customer-groups",
        label: _ctx.$t("Create"),
        onInput: ($event) => updatePermissions("create-customer-groups"),
        checked: unref(form).permissions.includes("create-customer-groups")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "update-customer-groups",
        value: "update-customer-groups",
        label: _ctx.$t("Update"),
        onInput: ($event) => updatePermissions("update-customer-groups"),
        checked: unref(form).permissions.includes("update-customer-groups")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "delete-customer-groups",
        value: "delete-customer-groups",
        label: _ctx.$t("Delete"),
        onInput: ($event) => updatePermissions("delete-customer-groups"),
        checked: unref(form).permissions.includes("delete-customer-groups")
      }, null, _parent));
      _push(`</td></tr><tr><td colspan="5" class="pb-3 pt-8"><label class="block w-full font-bold">${ssrInterpolate(_ctx.$t("Price Groups"))}</label></td></tr><tr><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        label: _ctx.$t("View"),
        id: "read-price-groups",
        value: "read-price-groups",
        onInput: ($event) => updatePermissions("read-price-groups"),
        checked: unref(form).permissions.includes("read-price-groups")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "create-price-groups",
        value: "create-price-groups",
        label: _ctx.$t("Create"),
        onInput: ($event) => updatePermissions("create-price-groups"),
        checked: unref(form).permissions.includes("create-price-groups")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "update-price-groups",
        value: "update-price-groups",
        label: _ctx.$t("Update"),
        onInput: ($event) => updatePermissions("update-price-groups"),
        checked: unref(form).permissions.includes("update-price-groups")
      }, null, _parent));
      _push(`</td><td class="pr-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "delete-price-groups",
        value: "delete-price-groups",
        label: _ctx.$t("Delete"),
        onInput: ($event) => updatePermissions("delete-price-groups"),
        checked: unref(form).permissions.includes("delete-price-groups")
      }, null, _parent));
      _push(`</td></tr></tbody></table><div class="flex flex-wrap items-center gap-x-6 gap-y-3 mt-8"><label class="block w-full font-bold">${ssrInterpolate(_ctx.$t("Settings"))}</label>`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "settings",
        value: "settings",
        label: _ctx.$t("Settings"),
        onInput: ($event) => updatePermissions("settings"),
        checked: unref(form).permissions.includes("settings")
      }, null, _parent));
      _push(`</div><div class="flex flex-wrap items-center gap-x-6 gap-y-3 mt-8"><label class="block w-full font-bold">${ssrInterpolate(_ctx.$t("Others"))}</label>`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "read-all",
        value: "read-all",
        label: _ctx.$t("Read all records"),
        onInput: ($event) => updatePermissions("read-all"),
        checked: unref(form).permissions.includes("read-all")
      }, null, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "update-all",
        value: "update-all",
        label: _ctx.$t("Update all records"),
        onInput: ($event) => updatePermissions("update-all"),
        checked: unref(form).permissions.includes("update-all")
      }, null, _parent));
      _push(`</div><div class="flex flex-wrap items-center gap-x-6 gap-y-3 mt-8"><label class="block w-full font-bold">${ssrInterpolate(_ctx.$t("Reports"))}</label>`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "sales-report",
        value: "sales-report",
        onInput: ($event) => updatePermissions("sales-report"),
        label: _ctx.$t("{x} Report", { x: _ctx.$t("Sales") }),
        checked: unref(form).permissions.includes("sales-report")
      }, null, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "purchases-report",
        value: "purchases-report",
        onInput: ($event) => updatePermissions("purchases-report"),
        label: _ctx.$t("{x} Report", { x: _ctx.$t("Purchases") }),
        checked: unref(form).permissions.includes("purchases-report")
      }, null, _parent));
      if (_ctx.$page.props.pos_module) {
        _push(ssrRenderComponent(unref(_sfc_main$2), {
          id: "registers-report",
          value: "registers-report",
          onInput: ($event) => updatePermissions("registers-report"),
          label: _ctx.$t("{x} Report", { x: _ctx.$t("Registers") }),
          checked: unref(form).permissions.includes("registers-report")
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "payments-report",
        value: "payments-report",
        onInput: ($event) => updatePermissions("payments-report"),
        label: _ctx.$t("{x} Report", { x: _ctx.$t("Payments") }),
        checked: unref(form).permissions.includes("payments-report")
      }, null, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "expenses-report",
        value: "expenses-report",
        onInput: ($event) => updatePermissions("expenses-report"),
        label: _ctx.$t("{x} Report", { x: _ctx.$t("Expenses") }),
        checked: unref(form).permissions.includes("expenses-report")
      }, null, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "return-orders-report",
        value: "return-orders-report",
        onInput: ($event) => updatePermissions("return-orders-report"),
        label: _ctx.$t("{x} Report", { x: _ctx.$t("Return Orders") }),
        checked: unref(form).permissions.includes("return-orders-report")
      }, null, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "products-report",
        value: "products-report",
        onInput: ($event) => updatePermissions("products-report"),
        label: _ctx.$t("{x} Report", { x: _ctx.$t("Products") }),
        checked: unref(form).permissions.includes("products-report")
      }, null, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "categories-report",
        value: "categories-report",
        onInput: ($event) => updatePermissions("categories-report"),
        label: _ctx.$t("{x} Report", { x: _ctx.$t("Categories") }),
        checked: unref(form).permissions.includes("categories-report")
      }, null, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "adjustments-report",
        value: "adjustments-report",
        onInput: ($event) => updatePermissions("adjustments-report"),
        label: _ctx.$t("{x} Report", { x: _ctx.$t("Adjustments") }),
        checked: unref(form).permissions.includes("adjustments-report")
      }, null, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "transfers-report",
        value: "transfers-report",
        onInput: ($event) => updatePermissions("transfers-report"),
        label: _ctx.$t("{x} Report", { x: _ctx.$t("Transfers") }),
        checked: unref(form).permissions.includes("transfers-report")
      }, null, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "customers-report",
        value: "customers-report",
        onInput: ($event) => updatePermissions("customers-report"),
        label: _ctx.$t("{x} Report", { x: _ctx.$t("Customers") }),
        checked: unref(form).permissions.includes("customers-report")
      }, null, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "staff-report",
        value: "staff-report",
        onInput: ($event) => updatePermissions("staff-report"),
        label: _ctx.$t("{x} Report", { x: _ctx.$t("Staff") }),
        checked: unref(form).permissions.includes("staff-report")
      }, null, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "activities-report",
        value: "activities-report",
        onInput: ($event) => updatePermissions("activities-report"),
        label: _ctx.$t("{x} Report", { x: _ctx.$t("Activities") }),
        checked: unref(form).permissions.includes("activities-report")
      }, null, _parent));
      _push(`</div></div></div><div class="flex flex-row justify-end px-6 py-4 bg-gray-100 dark:bg-gray-950 text-end rounded-b-lg">`);
      _push(ssrRenderComponent(unref(_sfc_main$3), { onClick: close }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Cancel"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Cancel")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$4), {
        class: "ms-3",
        loading: unref(form).processing
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Save"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></form>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/People/Role/Form.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
