import { ref, watch, onMounted, mergeProps, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrInterpolate, ssrRenderList, ssrRenderAttr, ssrIncludeBooleanAttr, ssrLooseEqual } from "vue/server-renderer";
import dayjs from "dayjs";
import { T } from "../ssr.js";
import { usePage, useForm } from "@inertiajs/vue3";
import { f as $extras, _ as _sfc_main$1, g as _sfc_main$2, h as _sfc_main$3, r as $address, e as _sfc_main$4, i as _sfc_main$6, j as _sfc_main$7, k as _sfc_main$8, l as _sfc_main$9, s as _sfc_main$a } from "./http-CDixhmav.js";
import "lodash.debounce";
import { _ as _sfc_main$c } from "./LoadingButton-DREeyNQW.js";
import "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import { a as _sfc_main$5 } from "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import { _ as _sfc_main$b } from "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = {
  __name: "Form",
  __ssrInlineRender: true,
  props: ["current", "countries", "customer", "sale_id", "custom_fields", "get_addresses"],
  emits: ["close", "done", "address"],
  setup(__props, { emit: __emit }) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n;
    usePage();
    const emits = __emit;
    const props = __props;
    const loading = ref(true);
    const address = ref(null);
    const addresses = ref(null);
    const form = useForm({
      _method: ((_a = props.current) == null ? void 0 : _a.id) ? "put" : "post",
      attachments: null,
      reference: (_b = props.current) == null ? void 0 : _b.reference,
      details: (_c = props.current) == null ? void 0 : _c.details,
      sale_id: ((_d = props.current) == null ? void 0 : _d.sale_id) || props.sale_id,
      customer_id: ((_e = props.current) == null ? void 0 : _e.customer_id) || ((_f = props.customer) == null ? void 0 : _f.id),
      address_id: ((_g = props.current) == null ? void 0 : _g.address_id) || (((_i = (_h = props.customer) == null ? void 0 : _h.addresses) == null ? void 0 : _i.length) ? props.customer.addresses[0].id : null),
      received_by: (_j = props.current) == null ? void 0 : _j.received_by,
      delivered_by: (_k = props.current) == null ? void 0 : _k.delivered_by,
      delivered: ((_l = props.current) == null ? void 0 : _l.delivered) == 1,
      delivered_at: (_m = props.current) == null ? void 0 : _m.delivered_at,
      date: dayjs((_n = props.current) == null ? void 0 : _n.date).format("YYYY-MM-DD"),
      extra_attributes: props.current ? $extras(props.custom_fields, props.current.extra_attributes) : $extras(props.custom_fields)
    });
    watch(
      () => props.get_addresses,
      async (v) => {
        if (v) {
          await getCustomer();
        }
      }
    );
    onMounted(async () => {
      var _a2, _b2, _c2;
      if (!props.countries) {
        await axios.post(T("search.countries")).then((res) => {
          props.countries = res.data;
        });
      }
      if ((_a2 = props.customer) == null ? void 0 : _a2.id) {
        await getCustomer();
      }
      if (props.current && ((_b2 = addresses.value) == null ? void 0 : _b2.length)) {
        address.value = (_c2 = addresses.value) == null ? void 0 : _c2.find((a) => a.id == props.current.address_id);
        addresses.value = addresses.value;
      }
      loading.value = false;
    });
    const close = () => {
      form.reset();
      emits("close");
    };
    async function getCustomer() {
      await axios.get(T("customers.show", { customer: props.customer.id, with: "addresses" })).then((res) => {
        var _a2, _b2, _c2, _d2;
        addresses.value = res.data.addresses;
        if (!form.address_id) {
          if ((_a2 = props.current) == null ? void 0 : _a2.address_id) {
            address.value = (_b2 = addresses.value) == null ? void 0 : _b2.find((a) => a.id == props.current.address_id);
          }
        } else {
          address.value = ((_c2 = addresses.value) == null ? void 0 : _c2.length) ? addresses.value[0] : null;
          form.address_id = (_d2 = address.value) == null ? void 0 : _d2.id;
        }
      });
    }
    return (_ctx, _push, _parent, _attrs) => {
      var _a2, _b2, _c2;
      if (loading.value) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "relative h-64" }, _attrs))}>`);
        _push(ssrRenderComponent(unref(_sfc_main$1), null, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<form${ssrRenderAttrs(_attrs)}><div class="border-b border-gray-200 dark:border-gray-700 px-6 py-4"><div class="sm:flex sm:items-baseline sm:justify-between"><div class="sm:w-0 sm:flex-1"><h1 class="text-base font-semibold text-focus">${ssrInterpolate(((_a2 = __props.current) == null ? void 0 : _a2.id) ? _ctx.$t("Edit {x}", { x: _ctx.$t("Delivery") }) : _ctx.$t("Add {x}", { x: _ctx.$t("Delivery") }))}</h1><p class="mt-1 truncate text-sm text-mute">${ssrInterpolate(_ctx.$t("Please fill the form below to {action} {record}.", {
          record: _ctx.$t("delivery"),
          action: ((_b2 = __props.current) == null ? void 0 : _b2.id) ? _ctx.$t("edit") : _ctx.$t("add")
        }))}</p></div></div></div><div class="p-6 grid grid-cols-6 gap-6"><div class="col-span-6 sm:col-span-3">`);
        _push(ssrRenderComponent(unref(_sfc_main$2), {
          type: "date",
          id: "date",
          onChange: _ctx.saveForm,
          label: _ctx.$t("Date"),
          modelValue: unref(form).date,
          "onUpdate:modelValue": ($event) => unref(form).date = $event,
          error: unref(form).errors.date
        }, null, _parent));
        _push(`</div><div class="col-span-6 sm:col-span-3">`);
        _push(ssrRenderComponent(unref(_sfc_main$3), {
          id: "reference",
          onChange: _ctx.saveForm,
          label: _ctx.$t("Reference"),
          modelValue: unref(form).reference,
          "onUpdate:modelValue": ($event) => unref(form).reference = $event,
          error: unref(form).errors.reference
        }, null, _parent));
        _push(`</div><div class="col-span-6">`);
        if (addresses.value && addresses.value.length) {
          _push(`<fieldset class="-space-y-px rounded-md bg-white dark:bg-gray-950"><!--[-->`);
          ssrRenderList(addresses.value, (a) => {
            _push(`<label${ssrRenderAttr("value", a.id)}${ssrRenderAttr("aria-label", a.name)}${ssrRenderAttr("aria-description", unref($address)(a))} class="group flex cursor-pointer border border-gray-200 dark:border-gray-700 p-4 first:rounded-tl-md first:rounded-tr-md last:rounded-bl-md last:rounded-br-md focus:outline-none has-[:checked]:relative has-[:checked]:border-primary-200 has-[:checked]:bg-primary-50 dark:has-[:checked]:border-primary-800 dark:has-[:checked]:bg-primary-950"><input type="radio"${ssrRenderAttr("value", a.id)}${ssrIncludeBooleanAttr(ssrLooseEqual(unref(form).address_id, a.id)) ? " checked" : ""} class="relative mt-0.5 size-4 shrink-0 appearance-none rounded-full border border-gray-300 bg-white before:absolute before:inset-1 before:rounded-full before:bg-white checked:border-primary-600 checked:bg-primary-600 dark:checked:border-primary-400 dark:checked:bg-primary-400 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-primary-600 disabled:border-gray-300 disabled:bg-gray-100 disabled:before:bg-gray-400 forced-colors:appearance-auto forced-colors:before:hidden [&amp;:not(:checked)]:before:hidden"><div class="ml-3 flex flex-col"><span class="block text-sm font-medium text-focus group-has-[:checked]:text-primary-900 dark:group-has-[:checked]:text-primary-100">${ssrInterpolate(a.name)}</span><span class="block text-sm group-has-[:checked]:text-primary-700 dark:group-has-[:checked]:text-primary-300">${ssrInterpolate(unref($address)(a))}</span>`);
            if (a == null ? void 0 : a.phone) {
              _push(`<div class="text-sm">${ssrInterpolate(_ctx.$t("Phone"))}: ${ssrInterpolate(a == null ? void 0 : a.phone)}</div>`);
            } else {
              _push(`<!---->`);
            }
            if (a == null ? void 0 : a.email) {
              _push(`<div class="text-sm">${ssrInterpolate(_ctx.$t("Email"))}: ${ssrInterpolate(a.email)}</div>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</div></label>`);
          });
          _push(`<!--]--></fieldset>`);
        } else {
          _push(`<!---->`);
        }
        _push(ssrRenderComponent(unref(_sfc_main$4), {
          type: "button",
          onClick: ($event) => _ctx.$emit("address"),
          class: "mt-2"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("Add Address"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("Add Address")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(ssrRenderComponent(unref(_sfc_main$5), {
          message: _ctx.$page.props.errors.address_id,
          class: "mt-2"
        }, null, _parent));
        _push(`</div><div class="col-span-6 sm:col-span-3">`);
        _push(ssrRenderComponent(unref(_sfc_main$6), {
          multiple: "",
          id: "attachments",
          label: _ctx.$t("Attachments"),
          modelValue: unref(form).attachments,
          "onUpdate:modelValue": ($event) => unref(form).attachments = $event,
          error: unref(form).errors.attachments,
          accept: ((_c2 = _ctx.$page.props.settings) == null ? void 0 : _c2.attachment_exts) || ".jpg,.png,.pdf,.xlsx,.docx,.zip"
        }, null, _parent));
        _push(`</div>`);
        if (__props.current && __props.current.attachments && __props.current.attachments.length) {
          _push(`<div class="col-span-full">`);
          _push(ssrRenderComponent(unref(_sfc_main$7), {
            attachments: __props.current.attachments || []
          }, null, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="col-span-full flex flex-col gap-6">`);
        _push(ssrRenderComponent(unref(_sfc_main$8), {
          errors: unref(form).errors,
          custom_fields: __props.custom_fields,
          extra_attributes: unref(form).extra_attributes
        }, null, _parent));
        _push(ssrRenderComponent(unref(_sfc_main$9), {
          label: _ctx.$t("Details"),
          modelValue: unref(form).details,
          "onUpdate:modelValue": ($event) => unref(form).details = $event,
          error: _ctx.$page.props.errors.details
        }, null, _parent));
        _push(ssrRenderComponent(unref(_sfc_main$a), {
          id: "delivered",
          label: _ctx.$t("Mark as delivered"),
          modelValue: unref(form).delivered,
          "onUpdate:modelValue": ($event) => unref(form).delivered = $event
        }, null, _parent));
        _push(`</div>`);
        if (unref(form).delivered) {
          _push(`<!--[--><div class="col-span-6 sm:col-span-3">`);
          _push(ssrRenderComponent(unref(_sfc_main$2), {
            time: "",
            id: "delivered_at",
            label: _ctx.$t("Delivered at"),
            modelValue: unref(form).delivered_at,
            "onUpdate:modelValue": ($event) => unref(form).delivered_at = $event,
            error: unref(form).errors.delivered_at
          }, null, _parent));
          _push(`</div><div class="col-span-6 sm:col-span-3">`);
          _push(ssrRenderComponent(unref(_sfc_main$3), {
            id: "delivered_by",
            onChange: _ctx.saveForm,
            label: _ctx.$t("Delivered by"),
            modelValue: unref(form).delivered_by,
            "onUpdate:modelValue": ($event) => unref(form).delivered_by = $event,
            error: unref(form).errors.delivered_by
          }, null, _parent));
          _push(`</div><div class="col-span-6 sm:col-span-3">`);
          _push(ssrRenderComponent(unref(_sfc_main$3), {
            id: "received_by",
            onChange: _ctx.saveForm,
            label: _ctx.$t("Received by"),
            modelValue: unref(form).received_by,
            "onUpdate:modelValue": ($event) => unref(form).received_by = $event,
            error: unref(form).errors.received_by
          }, null, _parent));
          _push(`</div><!--]-->`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="flex flex-row justify-end px-6 py-4 bg-gray-100 dark:bg-gray-950 text-end">`);
        _push(ssrRenderComponent(unref(_sfc_main$b), { onClick: close }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("Cancel"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("Cancel")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(ssrRenderComponent(unref(_sfc_main$c), {
          class: "ms-3",
          loading: unref(form).processing
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("Save"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div></form>`);
      }
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Order/Delivery/Form.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
