import { unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent } from "vue/server-renderer";
import "../ssr.js";
import { usePage, useForm } from "@inertiajs/vue3";
import "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import { _ as _sfc_main$3 } from "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import { h as _sfc_main$1, b as _sfc_main$2 } from "./http-CDixhmav.js";
import { _ as _sfc_main$4 } from "./LoadingButton-DREeyNQW.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
import "lodash.debounce";
import "dayjs";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
const _sfc_main = {
  __name: "Form",
  __ssrInlineRender: true,
  props: ["current", "parents"],
  emits: ["close", "done"],
  setup(__props, { emit: __emit }) {
    var _a, _b, _c, _d, _e, _f;
    usePage();
    const props = __props;
    const form = useForm({
      _method: ((_a = props.current) == null ? void 0 : _a.id) ? "put" : "post",
      name: (_b = props.current) == null ? void 0 : _b.name,
      code: (_c = props.current) == null ? void 0 : _c.code,
      unit_id: (_d = props.current) == null ? void 0 : _d.unit_id,
      operator: (_e = props.current) == null ? void 0 : _e.operator,
      operation_value: (_f = props.current) == null ? void 0 : _f.operation_value
      //   active: props.current?.id ? props.current?.active == 1 : true,
    });
    return (_ctx, _push, _parent, _attrs) => {
      var _a2, _b2;
      _push(`<form${ssrRenderAttrs(_attrs)}><div class="border-b border-gray-200 dark:border-gray-700 px-6 py-4"><div class="sm:flex sm:items-baseline sm:justify-between"><div class="sm:w-0 sm:flex-1"><h1 class="text-base font-semibold text-focus">${ssrInterpolate(((_a2 = __props.current) == null ? void 0 : _a2.id) ? _ctx.$t("Edit {x}", { x: _ctx.$t("Unit") }) : _ctx.$t("Add {x}", { x: _ctx.$t("Unit") }))}</h1><p class="mt-1 truncate text-sm text-mute">${ssrInterpolate(_ctx.$t("Please fill the form below to {action} {record}.", {
        record: _ctx.$t("unit"),
        action: ((_b2 = __props.current) == null ? void 0 : _b2.id) ? _ctx.$t("edit") : _ctx.$t("add")
      }))}</p></div></div></div><div class="p-6 grid grid-cols-6 gap-6"><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        id: "name",
        label: _ctx.$t("Name"),
        modelValue: unref(form).name,
        "onUpdate:modelValue": ($event) => unref(form).name = $event,
        error: unref(form).errors.name
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        id: "code",
        label: _ctx.$t("Code"),
        modelValue: unref(form).code,
        "onUpdate:modelValue": ($event) => unref(form).code = $event,
        error: unref(form).errors.code
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        json: true,
        id: "unit_id",
        searchable: false,
        suggestions: __props.parents,
        modelValue: unref(form).unit_id,
        "onUpdate:modelValue": ($event) => unref(form).unit_id = $event,
        label: _ctx.$t("Base Unit"),
        error: unref(form).errors.unit_id
      }, null, _parent));
      _push(`</div>`);
      if (unref(form).unit_id) {
        _push(`<!--[--><div class="col-span-6 sm:col-span-3">`);
        _push(ssrRenderComponent(unref(_sfc_main$2), {
          json: true,
          id: "operator",
          searchable: false,
          label: _ctx.$t("Operator"),
          modelValue: unref(form).operator,
          "onUpdate:modelValue": ($event) => unref(form).operator = $event,
          error: unref(form).errors.operator,
          suggestions: [
            { value: "+", label: _ctx.$t("Plus") + " (+)" },
            { value: "-", label: _ctx.$t("Minus") + " (-)" },
            { value: "*", label: _ctx.$t("Multiple") + " (*)" },
            { value: "/", label: _ctx.$t("Divide") + " (/)" }
          ]
        }, null, _parent));
        _push(`</div><div class="col-span-6 sm:col-span-3">`);
        _push(ssrRenderComponent(unref(_sfc_main$1), {
          id: "operation_value",
          label: _ctx.$t("Operation Value"),
          modelValue: unref(form).operation_value,
          "onUpdate:modelValue": ($event) => unref(form).operation_value = $event,
          error: unref(form).errors.operation_value
        }, null, _parent));
        _push(`</div><!--]-->`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="flex flex-row justify-end px-6 py-4 bg-gray-100 dark:bg-gray-950 text-end rounded-b-lg">`);
      _push(ssrRenderComponent(unref(_sfc_main$3), { onClick: _ctx.close }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Cancel"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Cancel")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$4), {
        class: "ms-3",
        loading: unref(form).processing
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Save"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></form>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Product/Unit/Form.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
