import { ref, onMounted, nextTick, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent } from "vue/server-renderer";
import dayjs from "dayjs";
import { T } from "../ssr.js";
import "lodash.debounce";
import { usePage, useForm } from "@inertiajs/vue3";
import { f as $extras, u as $decimal, a as axios, g as _sfc_main$1, h as _sfc_main$2, b as _sfc_main$3, v as _sfc_main$4, i as _sfc_main$5, j as _sfc_main$6, k as _sfc_main$7, l as _sfc_main$8 } from "./http-CDixhmav.js";
import { _ as _sfc_main$a } from "./LoadingButton-DREeyNQW.js";
import "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import { _ as _sfc_main$9 } from "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = {
  __name: "Form",
  __ssrInlineRender: true,
  props: ["current", "customer", "supplier", "sale", "purchase", "custom_fields"],
  emits: ["close", "done"],
  setup(__props, { emit: __emit }) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _i;
    usePage();
    const emits = __emit;
    const props = __props;
    const gift_card = ref(null);
    const form = useForm({
      _method: ((_a = props.current) == null ? void 0 : _a.id) ? "put" : "post",
      attachments: null,
      details: (_b = props.current) == null ? void 0 : _b.details,
      reference: (_c = props.current) == null ? void 0 : _c.reference,
      customer_id: (_d = props.current) == null ? void 0 : _d.customer_id,
      supplier_id: (_e = props.current) == null ? void 0 : _e.supplier_id,
      payment_for: ((_f = props.current) == null ? void 0 : _f.payment_for) || "Customer",
      sale_id: props.current ? props.current.sale_id : (_g = props.sale) == null ? void 0 : _g.id,
      purchase_id: props.current ? props.current.purchase_id : (_h = props.purchase) == null ? void 0 : _h.id,
      date: dayjs((_i = props.current) == null ? void 0 : _i.date).format("YYYY-MM-DD"),
      amount: props.current ? $decimal(props.current.amount) : props.sale ? $decimal(Number(props.sale.grand_total) - Number(props.sale.rounding || 0) - Number(props.sale.paid)) : null,
      method: props.current ? props.current.method : "Cash",
      method_data: props.current ? props.current.method_data : {},
      extra_attributes: props.current ? $extras(props.custom_fields, props.current.extra_attributes) : $extras(props.custom_fields)
    });
    if (props.sale) {
      form.payment_for = "Customer";
      form.customer_id = props.sale.customer_id;
      form.amount = $decimal(props.sale.grand_total - props.sale.rounding - props.sale.paid);
    }
    if (props.purchase) {
      form.payment_for = "Supplier";
      form.supplier_id = props.purchase.supplier_id;
      form.amount = $decimal(props.purchase.grand_total - props.purchase.paid);
    }
    if (props.customer) {
      form.payment_for = "Customer";
      form.customer_id = props.customer.id;
      form.amount = props.customer.balance > 0 ? $decimal(props.customer.balance) : null;
    }
    if (props.supplier) {
      form.payment_for = "Supplier";
      form.supplier_id = props.supplier.id;
      form.amount = props.supplier.balance > 0 ? $decimal(props.supplier.balance) : null;
    }
    onMounted(async () => {
      checkGiftCard();
      await nextTick();
      document.getElementById("payment-form-amount").focus();
    });
    const close = () => {
      form.reset();
      emits("close");
    };
    function checkGiftCard() {
      if (form.method_data.gift_card_no) {
        axios.get(T("gift_cards.details", form.method_data.gift_card_no)).then((res) => gift_card.value = res.data);
      }
    }
    return (_ctx, _push, _parent, _attrs) => {
      var _a2, _b2, _c2, _d2;
      _push(`<form${ssrRenderAttrs(_attrs)}><div class="border-b border-gray-200 dark:border-gray-700 px-6 py-4"><div class="sm:flex sm:items-baseline sm:justify-between"><div class="sm:w-0 sm:flex-1"><h1 class="text-base font-semibold text-focus">${ssrInterpolate(((_a2 = __props.current) == null ? void 0 : _a2.id) ? _ctx.$t("Edit {x}", { x: _ctx.$t("Payment") }) : _ctx.$t("Add {x}", { x: _ctx.$t("Payment") }))}</h1><p class="mt-1 truncate text-sm text-mute">${ssrInterpolate(_ctx.$t("Please fill the form below to {action} {record}.", {
        record: _ctx.$t("payment"),
        action: ((_b2 = __props.current) == null ? void 0 : _b2.id) ? _ctx.$t("edit") : _ctx.$t("add")
      }))}</p></div></div></div><div class="p-6 grid grid-cols-6 gap-6"><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        type: "date",
        id: "date",
        onChange: _ctx.saveForm,
        label: _ctx.$t("Date"),
        modelValue: unref(form).date,
        "onUpdate:modelValue": ($event) => unref(form).date = $event,
        error: unref(form).errors.date
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "reference",
        onChange: _ctx.saveForm,
        label: _ctx.$t("Reference"),
        modelValue: unref(form).reference,
        "onUpdate:modelValue": ($event) => unref(form).reference = $event,
        error: unref(form).errors.reference
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$3), {
        id: "type",
        json: true,
        onChange: _ctx.saveForm,
        searchable: true,
        label: _ctx.$t("For"),
        modelValue: unref(form).payment_for,
        "onUpdate:modelValue": ($event) => unref(form).payment_for = $event,
        error: _ctx.$page.props.errors.payment_for,
        suggestions: [
          { value: "Customer", label: _ctx.$t("Customer") },
          { value: "Supplier", label: _ctx.$t("Supplier") }
        ]
      }, null, _parent));
      _push(`</div>`);
      if (unref(form).payment_for == "Customer") {
        _push(`<div class="col-span-6 sm:col-span-3">`);
        _push(ssrRenderComponent(unref(_sfc_main$3), {
          json: true,
          valueKey: "id",
          id: "customer_id",
          labelKey: "company",
          onChange: _ctx.saveForm,
          searchable: true,
          label: _ctx.$t("Customer"),
          modelValue: unref(form).customer_id,
          "onUpdate:modelValue": ($event) => unref(form).customer_id = $event,
          suggestions: unref(T)("search.customers"),
          error: _ctx.$page.props.errors.customer_id
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(form).payment_for == "Supplier") {
        _push(`<div class="col-span-6 sm:col-span-3">`);
        _push(ssrRenderComponent(unref(_sfc_main$3), {
          json: true,
          valueKey: "id",
          id: "supplier_id",
          labelKey: "company",
          onChange: _ctx.saveForm,
          searchable: true,
          label: _ctx.$t("Supplier"),
          modelValue: unref(form).supplier_id,
          "onUpdate:modelValue": ($event) => unref(form).supplier_id = $event,
          suggestions: unref(T)("search.suppliers"),
          error: _ctx.$page.props.errors.supplier_id
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        type: "number",
        label: _ctx.$t("Amount"),
        modelValue: unref(form).amount,
        "onUpdate:modelValue": ($event) => unref(form).amount = $event,
        id: "payment-form-amount",
        error: _ctx.$page.props.errors.amount,
        readonly: _ctx.edit && ["Card Terminal", "Stripe Terminal"].includes(_ctx.edit.method)
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$3), {
        json: true,
        placement: "top",
        searchable: false,
        label: _ctx.$t("Method"),
        modelValue: unref(form).method,
        "onUpdate:modelValue": ($event) => unref(form).method = $event,
        error: _ctx.$page.props.errors.method,
        suggestions: [
          { value: "Cash", label: _ctx.$t("Cash") },
          { value: "Gift Card", label: _ctx.$t("Gift Card") },
          { value: "Card Terminal", label: _ctx.$t("Card Terminal") },
          { value: "Stripe Terminal", label: _ctx.$t("Stripe Terminal") },
          { value: "Others", label: _ctx.$t("Others") }
        ]
      }, null, _parent));
      _push(`</div>`);
      if (unref(form).method == "Gift Card") {
        _push(`<div class="col-span-full">`);
        _push(ssrRenderComponent(unref(_sfc_main$2), {
          onChange: checkGiftCard,
          label: _ctx.$t("Gift Card Number"),
          modelValue: unref(form).method_data.gift_card_no,
          "onUpdate:modelValue": ($event) => unref(form).method_data.gift_card_no = $event,
          error: _ctx.$page.props.errors["method_data.gift_card_no"] || null
        }, null, _parent));
        if (gift_card.value && unref(form).method_data.gift_card_no) {
          _push(`<div class="mt-2 border border-gray-200 dark:border-gray-700 rounded-md py-2 px-3 text-sm whitespace-pre-wrap"><div>${ssrInterpolate(_ctx.$t("Balance Amount"))}: ${ssrInterpolate(_ctx.$number(Number(gift_card.value.balance) + Number(_ctx.edit ? _ctx.edit.amount : 0)))}</div>`);
          if (gift_card.value.customer) {
            _push(`<div>${ssrInterpolate(_ctx.$t("Customer"))}: ${ssrInterpolate((_c2 = gift_card.value.customer) == null ? void 0 : _c2.name)}</div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(form).method == "Card Terminal") {
        _push(`<div class="col-span-full">`);
        _push(ssrRenderComponent(unref(_sfc_main$4), {
          checked: unref(form).cc_slip,
          "onUpdate:checked": ($event) => unref(form).cc_slip = $event,
          error: _ctx.$page.props.errors.cc_slip,
          label: _ctx.$t("I have collected payment & saved receipt")
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(form).method == "Stripe Terminal") {
        _push(`<div class="col-span-full text-yellow-500 text-center text-sm font-bold"> Work in Progress </div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$5), {
        multiple: "",
        id: "attachments",
        label: _ctx.$t("Attachments"),
        modelValue: unref(form).attachments,
        "onUpdate:modelValue": ($event) => unref(form).attachments = $event,
        error: unref(form).errors.attachments,
        accept: ((_d2 = _ctx.$page.props.settings) == null ? void 0 : _d2.attachment_exts) || ".jpg,.png,.pdf,.xlsx,.docx,.zip"
      }, null, _parent));
      _push(`</div>`);
      if (__props.current && __props.current.attachments && __props.current.attachments.length) {
        _push(`<div class="col-span-full">`);
        _push(ssrRenderComponent(unref(_sfc_main$6), {
          attachments: __props.current.attachments || []
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="col-span-full flex flex-col gap-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$7), {
        errors: unref(form).errors,
        custom_fields: __props.custom_fields,
        extra_attributes: unref(form).extra_attributes
      }, null, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$8), {
        label: _ctx.$t("Details"),
        modelValue: unref(form).details,
        "onUpdate:modelValue": ($event) => unref(form).details = $event,
        error: _ctx.$page.props.errors.details
      }, null, _parent));
      _push(`</div></div><div class="flex flex-row justify-end px-6 py-4 bg-gray-100 dark:bg-gray-950 text-end">`);
      _push(ssrRenderComponent(unref(_sfc_main$9), { onClick: close }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Cancel"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Cancel")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$a), {
        class: "ms-3",
        loading: unref(form).processing
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Save"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></form>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Order/Payment/Form.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
