import { ref, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent, ssrRenderStyle, ssrRenderAttr } from "vue/server-renderer";
import { T } from "../ssr.js";
import { usePage, useForm, router } from "@inertiajs/vue3";
import "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import { a as _sfc_main$3 } from "./InputError-DjBtKS5r.js";
import { _ as _sfc_main$1 } from "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import { _ as _sfc_main$2 } from "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import { h as _sfc_main$4, l as _sfc_main$5, v as _sfc_main$6 } from "./http-CDixhmav.js";
import { _ as _sfc_main$7 } from "./LoadingButton-DREeyNQW.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
import "lodash.debounce";
import "dayjs";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
const _sfc_main = {
  __name: "Form",
  __ssrInlineRender: true,
  props: ["current", "parents"],
  emits: ["close", "done"],
  setup(__props, { emit: __emit }) {
    var _a, _b, _c, _d, _e, _f, _g, _h;
    usePage();
    const emits = __emit;
    const props = __props;
    const photoInput = ref(null);
    const photoPreview = ref(null);
    const form = useForm({
      _method: ((_a = props.current) == null ? void 0 : _a.id) ? "put" : "post",
      photo: null,
      name: (_b = props.current) == null ? void 0 : _b.name,
      slug: (_c = props.current) == null ? void 0 : _c.slug,
      order: (_d = props.current) == null ? void 0 : _d.order,
      title: (_e = props.current) == null ? void 0 : _e.title,
      description: (_f = props.current) == null ? void 0 : _f.description,
      active: ((_g = props.current) == null ? void 0 : _g.id) ? ((_h = props.current) == null ? void 0 : _h.active) == 1 : true
    });
    const close = () => {
      form.reset();
      photoPreview.value = null;
      clearPhotoFileInput();
      emits("close");
    };
    const deletePhoto = (row) => {
      router.delete(T("brands.photo.destroy", { id: row.id }), {
        preserveScroll: true,
        onSuccess: () => {
          photoPreview.value = null;
          clearPhotoFileInput();
        }
      });
    };
    const selectNewPhoto = () => {
      photoInput.value.click();
    };
    const clearPhotoFileInput = () => {
      var _a2;
      if ((_a2 = photoInput.value) == null ? void 0 : _a2.value) {
        photoInput.value.value = null;
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      var _a2, _b2, _c2, _d2, _e2;
      _push(`<form${ssrRenderAttrs(_attrs)}><div class="border-b border-gray-200 dark:border-gray-700 px-6 py-4"><div class="sm:flex sm:items-baseline sm:justify-between"><div class="sm:w-0 sm:flex-1"><h1 class="text-base font-semibold text-focus">${ssrInterpolate(((_a2 = __props.current) == null ? void 0 : _a2.id) ? _ctx.$t("Edit {x}", { x: _ctx.$t("Brand") }) : _ctx.$t("Add {x}", { x: _ctx.$t("Brand") }))}</h1><p class="mt-1 truncate text-sm text-mute">${ssrInterpolate(_ctx.$t("Please fill the form below to {action} {record}.", {
        record: _ctx.$t("brand"),
        action: ((_b2 = __props.current) == null ? void 0 : _b2.id) ? _ctx.$t("edit") : _ctx.$t("add")
      }))}</p></div></div></div><div class="p-6 grid grid-cols-6 gap-6"><div class="col-span-full"><input id="photo" type="file" class="hidden">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        for: "photo",
        value: _ctx.$t("Photo")
      }, null, _parent));
      _push(`<div style="${ssrRenderStyle(!photoPreview.value && ((_c2 = __props.current) == null ? void 0 : _c2.photo) ? null : { display: "none" })}" class="mt-2 p-1 rounded-md"><img${ssrRenderAttr("alt", _ctx.$t("Photo"))}${ssrRenderAttr("src", (_d2 = __props.current) == null ? void 0 : _d2.photo)} class="rounded-md w-full h-full max-w-64 min-h-20 max-h-40 object-contain"></div><div style="${ssrRenderStyle(photoPreview.value ? null : { display: "none" })}" class="mt-2 p-1 rounded-md"><span class="block rounded-md w-full h-full max-w-64 min-h-24 max-h-40 bg-no-repeat bg-contain" style="${ssrRenderStyle("background-image: url('" + photoPreview.value + "');")}"></span></div>`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        class: "mt-2 me-2",
        type: "button",
        onClick: () => selectNewPhoto()
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Select A New Photo"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Select A New Photo")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      if ((_e2 = __props.current) == null ? void 0 : _e2.photo) {
        _push(ssrRenderComponent(unref(_sfc_main$2), {
          type: "button",
          onClick: () => deletePhoto(),
          class: "mt-2 p-1 rounded-md bg-gray-50 flex items-center justify-center"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("Remove Photo"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("Remove Photo")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(unref(_sfc_main$3), {
        message: unref(form).errors.photo,
        class: "mt-2"
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$4), {
        id: "name",
        label: _ctx.$t("Name"),
        modelValue: unref(form).name,
        "onUpdate:modelValue": ($event) => unref(form).name = $event,
        error: unref(form).errors.name
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$4), {
        id: "slug",
        label: _ctx.$t("Slug"),
        modelValue: unref(form).slug,
        "onUpdate:modelValue": ($event) => unref(form).slug = $event,
        error: unref(form).errors.slug
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-2">`);
      _push(ssrRenderComponent(unref(_sfc_main$4), {
        type: "number",
        id: "order",
        label: _ctx.$t("Order"),
        modelValue: unref(form).order,
        "onUpdate:modelValue": ($event) => unref(form).order = $event,
        error: unref(form).errors.order
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-4">`);
      _push(ssrRenderComponent(unref(_sfc_main$4), {
        id: "title",
        max: "50",
        label: _ctx.$t("Title"),
        modelValue: unref(form).title,
        "onUpdate:modelValue": ($event) => unref(form).title = $event,
        error: unref(form).errors.title
      }, null, _parent));
      _push(`</div><div class="col-span-full">`);
      _push(ssrRenderComponent(unref(_sfc_main$5), {
        max: "160",
        id: "description",
        label: _ctx.$t("Description"),
        modelValue: unref(form).description,
        "onUpdate:modelValue": ($event) => unref(form).description = $event,
        error: unref(form).errors.description
      }, null, _parent));
      _push(`</div><div class="col-span-full">`);
      _push(ssrRenderComponent(unref(_sfc_main$6), {
        id: "active",
        error: unref(form).errors.active,
        checked: unref(form).active,
        "onUpdate:checked": ($event) => unref(form).active = $event,
        label: _ctx.$t("Active")
      }, null, _parent));
      _push(`</div></div><div class="flex flex-row justify-end px-6 py-4 bg-gray-100 dark:bg-gray-950 text-end">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), { onClick: close }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Cancel"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Cancel")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$7), {
        class: "ms-3",
        loading: unref(form).processing
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Save"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></form>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Product/Brand/Form.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
