import { unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent } from "vue/server-renderer";
import dayjs from "dayjs";
import { T } from "../ssr.js";
import { usePage, useForm } from "@inertiajs/vue3";
import { h as _sfc_main$1, g as _sfc_main$2, b as _sfc_main$3, l as _sfc_main$4, n as $random } from "./http-CDixhmav.js";
import "lodash.debounce";
import { _ as _sfc_main$6 } from "./LoadingButton-DREeyNQW.js";
import "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import { _ as _sfc_main$5 } from "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = {
  __name: "Form",
  __ssrInlineRender: true,
  props: ["current"],
  emits: ["close", "done"],
  setup(__props, { emit: __emit }) {
    var _a, _b, _c, _d;
    usePage();
    const props = __props;
    const emits = __emit;
    const form = useForm({
      _method: ((_a = props.current) == null ? void 0 : _a.id) ? "put" : "post",
      number: (_b = props.current) == null ? void 0 : _b.number,
      details: (_c = props.current) == null ? void 0 : _c.details,
      customer_id: (_d = props.current) == null ? void 0 : _d.customer_id,
      amount: props.current ? Number(props.current.amount) : null,
      expiry_date: props.current ? props.current.expiry_date : dayjs().add(2, "year").format("YYYY-MM-DD")
    });
    const close = () => {
      form.reset();
      emits("close");
    };
    function generate() {
      form.number = $random(1e11, 1e16);
    }
    return (_ctx, _push, _parent, _attrs) => {
      var _a2, _b2, _c2;
      _push(`<form${ssrRenderAttrs(_attrs)}><div class="border-b border-gray-200 dark:border-gray-700 px-6 py-4"><div class="sm:flex sm:items-baseline sm:justify-between"><div class="sm:w-0 sm:flex-1"><h1 class="text-base font-semibold text-focus">${ssrInterpolate(((_a2 = __props.current) == null ? void 0 : _a2.id) ? _ctx.$t("Edit {x}", { x: _ctx.$t("Gift Card") }) : _ctx.$t("Add {x}", { x: _ctx.$t("Gift Card") }))}</h1><p class="mt-1 truncate text-sm text-mute">${ssrInterpolate(_ctx.$t("Please fill the form below to {action} {record}.", {
        record: _ctx.$t("gift card"),
        action: ((_b2 = __props.current) == null ? void 0 : _b2.id) ? _ctx.$t("edit") : _ctx.$t("add")
      }))}</p></div></div></div><div class="p-6 grid grid-cols-6 gap-6"><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        autofocus: "",
        action: generate,
        onChange: _ctx.saveForm,
        actionText: "Generate",
        label: _ctx.$t("Number"),
        modelValue: unref(form).number,
        "onUpdate:modelValue": ($event) => unref(form).number = $event,
        error: _ctx.$page.props.errors.number
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        id: "amount",
        type: "number",
        onChange: _ctx.saveForm,
        label: _ctx.$t("Amount"),
        modelValue: unref(form).amount,
        "onUpdate:modelValue": ($event) => unref(form).amount = $event,
        readonly: (_c2 = __props.current) == null ? void 0 : _c2.id,
        error: unref(form).errors.amount
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        type: "date",
        id: "expiry_date",
        onChange: _ctx.saveForm,
        label: _ctx.$t("Expiry Date"),
        modelValue: unref(form).expiry_date,
        "onUpdate:modelValue": ($event) => unref(form).expiry_date = $event,
        error: unref(form).errors.expiry_date
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$3), {
        json: true,
        valueKey: "id",
        id: "customer_id",
        labelKey: "company",
        onChange: _ctx.saveForm,
        searchable: true,
        label: _ctx.$t("Customer"),
        modelValue: unref(form).customer_id,
        "onUpdate:modelValue": ($event) => unref(form).customer_id = $event,
        suggestions: unref(T)("search.customers"),
        error: _ctx.$page.props.errors.customer_id
      }, null, _parent));
      _push(`</div><div class="col-span-full">`);
      _push(ssrRenderComponent(unref(_sfc_main$4), {
        label: _ctx.$t("Details"),
        onChange: _ctx.saveForm,
        modelValue: unref(form).details,
        "onUpdate:modelValue": ($event) => unref(form).details = $event,
        error: _ctx.$page.props.errors.details
      }, null, _parent));
      _push(`</div></div><div class="flex flex-row justify-end px-6 py-4 bg-gray-100 dark:bg-gray-950 text-end rounded-b-lg">`);
      _push(ssrRenderComponent(unref(_sfc_main$5), { onClick: close }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Cancel"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Cancel")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$6), {
        class: "ms-3",
        loading: unref(form).processing
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Save"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></form>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Order/GiftCard/Form.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
