import { ref, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent, ssrRenderList, ssrRenderAttr, ssrIncludeBooleanAttr, ssrLooseEqual } from "vue/server-renderer";
import "../ssr.js";
import { usePage, useForm } from "@inertiajs/vue3";
import { f as $extras, h as _sfc_main$1, b as _sfc_main$2, v as _sfc_main$4, k as _sfc_main$5 } from "./http-CDixhmav.js";
import "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import { a as _sfc_main$3 } from "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import { _ as _sfc_main$6 } from "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import { _ as _sfc_main$7 } from "./LoadingButton-DREeyNQW.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "lodash.debounce";
import "dayjs";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = {
  __name: "Form",
  __ssrInlineRender: true,
  props: ["current", "custom_fields", "roles", "stores"],
  emits: ["close", "done"],
  setup(__props, { emit: __emit }) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p, _q;
    usePage();
    const emits = __emit;
    const props = __props;
    const country = ref({ states: [] });
    if (((_a = props.current) == null ? void 0 : _a.id) && ((_b = props.current) == null ? void 0 : _b.country_id)) {
      country.value = props.countries.find((c) => c.id == props.current.country_id);
    }
    const form = useForm({
      _method: ((_c = props.current) == null ? void 0 : _c.id) ? "put" : "post",
      employee: true,
      name: (_d = props.current) == null ? void 0 : _d.name,
      phone: (_e = props.current) == null ? void 0 : _e.phone,
      email: (_f = props.current) == null ? void 0 : _f.email,
      username: (_g = props.current) == null ? void 0 : _g.username,
      settings: (_h = props.current) == null ? void 0 : _h.settings,
      store_id: (_i = props.current) == null ? void 0 : _i.store_id,
      roles: ((_k = (_j = props.current) == null ? void 0 : _j.roles) == null ? void 0 : _k.map((s) => s.id)) || [],
      stores: ((_m = (_l = props.current) == null ? void 0 : _l.stores) == null ? void 0 : _m.map((s) => s.id)) || [],
      //   country_id: props.current?.country_id,
      //   state_id: props.current?.state_id,
      //   lot_no: props.current?.lot_no,
      //   street: props.current?.street,
      //   address_line_1: props.current?.address_line_1,
      //   address_line_2: props.current?.address_line_2,
      //   city: props.current?.city,
      //   postal_code: props.current?.postal_code,
      password: null,
      password_confirmation: null,
      edit_all: ((_n = props.current) == null ? void 0 : _n.edit_all) == 1,
      view_all: ((_o = props.current) == null ? void 0 : _o.view_all) == 1,
      active: ((_p = props.current) == null ? void 0 : _p.id) ? ((_q = props.current) == null ? void 0 : _q.active) == 1 : true,
      extra_attributes: props.current ? $extras(props.custom_fields, props.current.extra_attributes) : $extras(props.custom_fields)
    });
    const close = () => {
      form.reset();
      emits("close");
    };
    return (_ctx, _push, _parent, _attrs) => {
      var _a2, _b2, _c2, _d2, _e2;
      _push(`<form${ssrRenderAttrs(_attrs)}><div class="border-b border-gray-200 dark:border-gray-700 px-6 py-4"><div class="sm:flex sm:items-baseline sm:justify-between"><div class="sm:w-0 sm:flex-1"><h1 class="text-base font-semibold text-focus">${ssrInterpolate(((_a2 = __props.current) == null ? void 0 : _a2.id) ? _ctx.$t("Edit {x}", { x: _ctx.$t("User") }) : _ctx.$t("Add {x}", { x: _ctx.$t("User") }))}</h1><p class="mt-1 truncate text-sm text-mute">${ssrInterpolate(_ctx.$t("Please fill the form below to {action} {record}.", {
        record: _ctx.$t("User"),
        action: ((_b2 = __props.current) == null ? void 0 : _b2.id) ? _ctx.$t("edit") : _ctx.$t("add")
      }))}</p></div></div></div><div class="p-6 grid grid-cols-6 gap-6"><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        id: "name",
        label: _ctx.$t("Name"),
        modelValue: unref(form).name,
        "onUpdate:modelValue": ($event) => unref(form).name = $event,
        error: unref(form).errors.name
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        id: "phone",
        label: _ctx.$t("Phone"),
        modelValue: unref(form).phone,
        "onUpdate:modelValue": ($event) => unref(form).phone = $event,
        error: unref(form).errors.phone
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        id: "username",
        label: _ctx.$t("Username"),
        modelValue: unref(form).username,
        "onUpdate:modelValue": ($event) => unref(form).username = $event,
        error: unref(form).errors.username
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        type: "email",
        id: "email",
        label: _ctx.$t("Email"),
        modelValue: unref(form).email,
        "onUpdate:modelValue": ($event) => unref(form).email = $event,
        error: unref(form).errors.email
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        id: "password",
        type: "password",
        modelValue: unref(form).password,
        "onUpdate:modelValue": ($event) => unref(form).password = $event,
        error: unref(form).errors.password,
        label: _ctx.$t("Password") + (((_c2 = __props.current) == null ? void 0 : _c2.id) ? " (" + _ctx.$t("optional") + ")" : "")
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        id: "password",
        type: "password",
        modelValue: unref(form).password_confirmation,
        "onUpdate:modelValue": ($event) => unref(form).password_confirmation = $event,
        error: unref(form).errors.password_confirmation,
        label: _ctx.$t("Confirm Password") + (((_d2 = __props.current) == null ? void 0 : _d2.id) ? " (" + _ctx.$t("optional") + ")" : "")
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        json: true,
        id: "store_id",
        searchable: false,
        label: _ctx.$t("Store"),
        suggestions: __props.stores,
        modelValue: unref(form).store_id,
        "onUpdate:modelValue": ($event) => unref(form).store_id = $event,
        error: unref(form).errors.store_id
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "stores",
        json: true,
        multiple: true,
        searchable: false,
        label: _ctx.$t("Stores"),
        suggestions: __props.stores,
        modelValue: unref(form).stores,
        "onUpdate:modelValue": ($event) => unref(form).stores = $event,
        error: unref(form).errors.stores
      }, null, _parent));
      _push(`</div><div class="col-span-full">`);
      if (__props.roles && __props.roles.length) {
        _push(`<div class="flex flex-wrap items-center gap-x-6 gap-y-3 mb-6"><label class="block w-full font-medium">${ssrInterpolate(_ctx.$t("Roles"))}</label><!--[-->`);
        ssrRenderList(__props.roles, (role) => {
          _push(`<label${ssrRenderAttr("for", role.id)} class="inline-flex items-center"><input${ssrRenderAttr("id", role.id)} name="roles[]" type="checkbox"${ssrRenderAttr("value", role.id)}${ssrIncludeBooleanAttr(ssrLooseEqual(unref(form).roles, role.id)) ? " checked" : ""}${ssrIncludeBooleanAttr(unref(form).roles.includes(role.id)) ? " checked" : ""} class="rounded border-gray-300 dark:border-gray-700 dark:bg-gray-600 text-primary-600 shadow-sm w-5 h-5 focus:rounded focus:ring-offset-0 focus:ring-primary-200 dark:focus:ring-opacity-50"><span class="ml-2 cursor-default">${role.name ?? ""}</span></label>`);
        });
        _push(`<!--]-->`);
        if (unref(form).errors.roles) {
          _push(ssrRenderComponent(unref(_sfc_main$3), {
            message: (_e2 = unref(form).errors.roles) == null ? void 0 : _e2.split("when")[0],
            class: "w-full -mt-1"
          }, null, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="col-span-full pt-2"><h1 class="font-bold mb-2">${ssrInterpolate(_ctx.$t("Permissions"))}</h1><div class="flex flex-wrap lg:flex-row gap-x-10 gap-y-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$4), {
        id: "view_all",
        checked: unref(form).view_all,
        "onUpdate:checked": ($event) => unref(form).view_all = $event,
        label: _ctx.$t("View all records")
      }, null, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$4), {
        id: "edit_all",
        checked: unref(form).edit_all,
        "onUpdate:checked": ($event) => unref(form).edit_all = $event,
        label: _ctx.$t("Edit all records")
      }, null, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$4), {
        id: "bulk_actions",
        checked: unref(form).bulk_actions,
        "onUpdate:checked": ($event) => unref(form).bulk_actions = $event,
        label: _ctx.$t("Bulk actions")
      }, null, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$4), {
        id: "can_be_impersonated",
        checked: unref(form).can_be_impersonated,
        "onUpdate:checked": ($event) => unref(form).can_be_impersonated = $event,
        label: _ctx.$t("Can be impersonated")
      }, null, _parent));
      _push(`</div></div></div><div class="col-span-full">`);
      _push(ssrRenderComponent(unref(_sfc_main$4), {
        id: "active",
        error: unref(form).errors.active,
        checked: unref(form).active,
        "onUpdate:checked": ($event) => unref(form).active = $event,
        label: _ctx.$t("Active")
      }, null, _parent));
      _push(`</div><div class="col-span-full">`);
      _push(ssrRenderComponent(unref(_sfc_main$5), {
        custom_fields: __props.custom_fields,
        errors: unref(form).errors,
        extra_attributes: unref(form).extra_attributes
      }, null, _parent));
      _push(`</div></div><div class="flex flex-row justify-end px-6 py-4 bg-gray-100 dark:bg-gray-950 text-end rounded-b-lg">`);
      _push(ssrRenderComponent(unref(_sfc_main$6), { onClick: close }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Cancel"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Cancel")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$7), {
        class: "ms-3",
        loading: unref(form).processing
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Save"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></form>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/People/User/Form.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
