import { ref, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent } from "vue/server-renderer";
import "../ssr.js";
import { usePage, useForm } from "@inertiajs/vue3";
import { f as $extras, u as $decimal, h as _sfc_main$1, b as _sfc_main$2, k as _sfc_main$3 } from "./http-CDixhmav.js";
import "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import { _ as _sfc_main$4 } from "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import { _ as _sfc_main$5 } from "./LoadingButton-DREeyNQW.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "lodash.debounce";
import "dayjs";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = {
  __name: "Form",
  __ssrInlineRender: true,
  props: ["current", "customer_groups", "countries", "price_groups", "custom_fields", "pos"],
  emits: ["close", "done"],
  setup(__props, { emit: __emit }) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p, _q, _r, _s, _t;
    usePage();
    const emits = __emit;
    const props = __props;
    const country = ref({ states: [] });
    if (((_a = props.current) == null ? void 0 : _a.id) && ((_b = props.current) == null ? void 0 : _b.country_id)) {
      country.value = props.countries.find((c) => c.id == props.current.country_id);
    }
    const form = useForm({
      _method: ((_c = props.current) == null ? void 0 : _c.id) ? "put" : "post",
      name: (_d = props.current) == null ? void 0 : _d.name,
      company: (_e = props.current) == null ? void 0 : _e.company,
      phone: (_f = props.current) == null ? void 0 : _f.phone,
      email: (_g = props.current) == null ? void 0 : _g.email,
      due_limit: ((_h = props.current) == null ? void 0 : _h.due_limit) ? $decimal((_i = props.current) == null ? void 0 : _i.due_limit) : null,
      opening_balance: $decimal((_j = props.current) == null ? void 0 : _j.opening_balance),
      customer_group_id: (_k = props.current) == null ? void 0 : _k.customer_group_id,
      price_group_id: (_l = props.current) == null ? void 0 : _l.price_group_id,
      country_id: (_m = props.current) == null ? void 0 : _m.country_id,
      state_id: (_n = props.current) == null ? void 0 : _n.state_id,
      lot_no: (_o = props.current) == null ? void 0 : _o.lot_no,
      street: (_p = props.current) == null ? void 0 : _p.street,
      address_line_1: (_q = props.current) == null ? void 0 : _q.address_line_1,
      address_line_2: (_r = props.current) == null ? void 0 : _r.address_line_2,
      city: (_s = props.current) == null ? void 0 : _s.city,
      postal_code: (_t = props.current) == null ? void 0 : _t.postal_code,
      extra_attributes: props.current ? $extras(props.custom_fields, props.current.extra_attributes) : $extras(props.custom_fields)
    });
    const close = () => {
      form.reset();
      emits("close");
    };
    return (_ctx, _push, _parent, _attrs) => {
      var _a2, _b2, _c2;
      _push(`<form${ssrRenderAttrs(_attrs)}><div class="border-b border-gray-200 dark:border-gray-700 px-6 py-4"><div class="sm:flex sm:items-baseline sm:justify-between"><div class="sm:w-0 sm:flex-1"><h1 class="text-base font-semibold text-focus">${ssrInterpolate(((_a2 = __props.current) == null ? void 0 : _a2.id) ? _ctx.$t("Edit {x}", { x: _ctx.$t("Customer") }) : _ctx.$t("Add {x}", { x: _ctx.$t("Customer") }))}</h1><p class="mt-1 truncate text-sm text-mute">${ssrInterpolate(_ctx.$t("Please fill the form below to {action} {record}.", {
        record: _ctx.$t("Customer"),
        action: ((_b2 = __props.current) == null ? void 0 : _b2.id) ? _ctx.$t("edit") : _ctx.$t("add")
      }))}</p></div></div></div><div class="p-6 grid grid-cols-6 gap-6"><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        id: "name",
        label: _ctx.$t("Name"),
        modelValue: unref(form).name,
        "onUpdate:modelValue": ($event) => unref(form).name = $event,
        error: unref(form).errors.name
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        id: "company",
        label: _ctx.$t("Company"),
        modelValue: unref(form).company,
        "onUpdate:modelValue": ($event) => unref(form).company = $event,
        error: unref(form).errors.company
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        id: "phone",
        label: _ctx.$t("Phone"),
        modelValue: unref(form).phone,
        "onUpdate:modelValue": ($event) => unref(form).phone = $event,
        error: unref(form).errors.phone
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        type: "email",
        id: "email",
        label: _ctx.$t("Email"),
        modelValue: unref(form).email,
        "onUpdate:modelValue": ($event) => unref(form).email = $event,
        error: unref(form).errors.email
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        type: "number",
        id: "opening_balance",
        readonly: (_c2 = __props.current) == null ? void 0 : _c2.id,
        label: _ctx.$t("Opening Balance"),
        modelValue: unref(form).opening_balance,
        "onUpdate:modelValue": ($event) => unref(form).opening_balance = $event,
        error: unref(form).errors.opening_balance
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        type: "number",
        id: "due_limit",
        label: _ctx.$t("Due Limit"),
        modelValue: unref(form).due_limit,
        "onUpdate:modelValue": ($event) => unref(form).due_limit = $event,
        error: unref(form).errors.due_limit
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        json: true,
        id: "customer_group_id",
        searchable: false,
        label: _ctx.$t("Customer Group"),
        suggestions: __props.customer_groups,
        modelValue: unref(form).customer_group_id,
        "onUpdate:modelValue": ($event) => unref(form).customer_group_id = $event,
        error: unref(form).errors.customer_group_id
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        json: true,
        searchable: false,
        id: "price_group_id",
        label: _ctx.$t("Price Group"),
        suggestions: __props.price_groups,
        modelValue: unref(form).price_group_id,
        "onUpdate:modelValue": ($event) => unref(form).price_group_id = $event,
        error: unref(form).errors.price_group_id
      }, null, _parent));
      _push(`</div><div class="col-span-full"></div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        json: true,
        id: "country_id",
        label: _ctx.$t("Country"),
        modelValue: unref(form).country_id,
        "onUpdate:modelValue": ($event) => unref(form).country_id = $event,
        error: unref(form).errors.country_id,
        suggestions: __props.countries.map((c) => ({ ...c, value: c.id, label: c.name })),
        onChange: (e) => {
          var _a3;
          country.value = e;
          unref(form).state_id = (_a3 = country.value.states[0]) == null ? void 0 : _a3.id;
        }
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        json: true,
        id: "state_id",
        label: _ctx.$t("State"),
        modelValue: unref(form).state_id,
        "onUpdate:modelValue": ($event) => unref(form).state_id = $event,
        error: unref(form).errors.state_id,
        suggestions: country.value.states.length ? country.value.states.map((s) => ({ ...s, value: s.id, label: s.name })) : [{ value: "0", label: _ctx.$t("N/A") }]
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        id: "lot_no",
        label: _ctx.$t("Lot No."),
        modelValue: unref(form).lot_no,
        "onUpdate:modelValue": ($event) => unref(form).lot_no = $event,
        error: unref(form).errors.lot_no
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        id: "street",
        label: _ctx.$t("Street"),
        modelValue: unref(form).street,
        "onUpdate:modelValue": ($event) => unref(form).street = $event,
        error: unref(form).errors.street
      }, null, _parent));
      _push(`</div><div class="col-span-full">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        id: "address_line_1",
        label: _ctx.$t("Address Line 1"),
        modelValue: unref(form).address_line_1,
        "onUpdate:modelValue": ($event) => unref(form).address_line_1 = $event,
        error: unref(form).errors.address_line_1
      }, null, _parent));
      _push(`</div><div class="col-span-full">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        id: "address_line_2",
        label: _ctx.$t("Address Line 2"),
        modelValue: unref(form).address_line_2,
        "onUpdate:modelValue": ($event) => unref(form).address_line_2 = $event,
        error: unref(form).errors.address_line_2
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        id: "city",
        label: _ctx.$t("City"),
        modelValue: unref(form).city,
        "onUpdate:modelValue": ($event) => unref(form).city = $event,
        error: unref(form).errors.city
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        id: "postal_code",
        label: _ctx.$t("Postal/ZIP Code"),
        modelValue: unref(form).postal_code,
        "onUpdate:modelValue": ($event) => unref(form).postal_code = $event,
        error: unref(form).errors.postal_code
      }, null, _parent));
      _push(`</div><div class="col-span-full">`);
      _push(ssrRenderComponent(unref(_sfc_main$3), {
        custom_fields: __props.custom_fields,
        errors: unref(form).errors,
        extra_attributes: unref(form).extra_attributes
      }, null, _parent));
      _push(`</div></div><div class="flex flex-row justify-end px-6 py-4 bg-gray-100 dark:bg-gray-950 text-end rounded-b-lg">`);
      _push(ssrRenderComponent(unref(_sfc_main$4), { onClick: close }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Cancel"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Cancel")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$5), {
        class: "ms-3",
        loading: unref(form).processing
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Save"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></form>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/People/Customer/Form.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
