import { unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent } from "vue/server-renderer";
import dayjs from "dayjs";
import { T } from "../ssr.js";
import { usePage, useForm } from "@inertiajs/vue3";
import { f as $extras, g as _sfc_main$1, h as _sfc_main$2, b as _sfc_main$3, i as _sfc_main$4, j as _sfc_main$5, k as _sfc_main$6, l as _sfc_main$7 } from "./http-CDixhmav.js";
import "lodash.debounce";
import { _ as _sfc_main$9 } from "./LoadingButton-DREeyNQW.js";
import "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import { _ as _sfc_main$8 } from "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = {
  __name: "Form",
  __ssrInlineRender: true,
  props: ["current", "custom_fields"],
  emits: ["close", "done"],
  setup(__props, { emit: __emit }) {
    var _a, _b, _c, _d, _e;
    usePage();
    const emits = __emit;
    const props = __props;
    const form = useForm({
      _method: ((_a = props.current) == null ? void 0 : _a.id) ? "put" : "post",
      attachments: null,
      reference: (_b = props.current) == null ? void 0 : _b.reference,
      details: (_c = props.current) == null ? void 0 : _c.details,
      supplier_id: (_d = props.current) == null ? void 0 : _d.supplier_id,
      amount: props.current ? Number(props.current.amount) : null,
      date: dayjs((_e = props.current) == null ? void 0 : _e.date).format("YYYY-MM-DD"),
      extra_attributes: props.current ? $extras(props.custom_fields, props.current.extra_attributes) : $extras(props.custom_fields)
    });
    const close = () => {
      form.reset();
      emits("close");
    };
    return (_ctx, _push, _parent, _attrs) => {
      var _a2, _b2, _c2;
      _push(`<form${ssrRenderAttrs(_attrs)}><div class="border-b border-gray-200 dark:border-gray-700 px-6 py-4"><div class="sm:flex sm:items-baseline sm:justify-between"><div class="sm:w-0 sm:flex-1"><h1 class="text-base font-semibold text-focus">${ssrInterpolate(((_a2 = __props.current) == null ? void 0 : _a2.id) ? _ctx.$t("Edit {x}", { x: _ctx.$t("Expanse") }) : _ctx.$t("Add {x}", { x: _ctx.$t("Expanse") }))}</h1><p class="mt-1 truncate text-sm text-mute">${ssrInterpolate(_ctx.$t("Please fill the form below to {action} {record}.", {
        record: _ctx.$t("expense"),
        action: ((_b2 = __props.current) == null ? void 0 : _b2.id) ? _ctx.$t("edit") : _ctx.$t("add")
      }))}</p></div></div></div><div class="p-6 grid grid-cols-6 gap-6"><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        type: "date",
        id: "date",
        onChange: _ctx.saveForm,
        label: _ctx.$t("Date"),
        modelValue: unref(form).date,
        "onUpdate:modelValue": ($event) => unref(form).date = $event,
        error: unref(form).errors.date
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "reference",
        onChange: _ctx.saveForm,
        label: _ctx.$t("Reference"),
        modelValue: unref(form).reference,
        "onUpdate:modelValue": ($event) => unref(form).reference = $event,
        error: unref(form).errors.reference
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$3), {
        json: true,
        valueKey: "id",
        id: "supplier_id",
        labelKey: "company",
        onChange: _ctx.saveForm,
        searchable: true,
        label: _ctx.$t("Supplier"),
        modelValue: unref(form).supplier_id,
        "onUpdate:modelValue": ($event) => unref(form).supplier_id = $event,
        suggestions: unref(T)("search.suppliers"),
        error: _ctx.$page.props.errors.supplier_id
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$4), {
        multiple: "",
        id: "attachments",
        label: _ctx.$t("Attachments"),
        modelValue: unref(form).attachments,
        "onUpdate:modelValue": ($event) => unref(form).attachments = $event,
        error: unref(form).errors.attachments,
        accept: ((_c2 = _ctx.$page.props.settings) == null ? void 0 : _c2.attachment_exts) || ".jpg,.png,.pdf,.xlsx,.docx,.zip"
      }, null, _parent));
      _push(`</div>`);
      if (__props.current && __props.current.attachments && __props.current.attachments.length) {
        _push(`<div class="col-span-full">`);
        _push(ssrRenderComponent(unref(_sfc_main$5), {
          attachments: __props.current.attachments || []
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="col-span-full">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        type: "number",
        id: "amount",
        label: _ctx.$t("Amount"),
        modelValue: unref(form).amount,
        "onUpdate:modelValue": ($event) => unref(form).amount = $event,
        error: unref(form).errors.amount
      }, null, _parent));
      _push(`</div><div class="col-span-full flex flex-col gap-6">`);
      _push(ssrRenderComponent(unref(_sfc_main$6), {
        errors: unref(form).errors,
        custom_fields: __props.custom_fields,
        extra_attributes: unref(form).extra_attributes
      }, null, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$7), {
        label: _ctx.$t("Details"),
        modelValue: unref(form).details,
        "onUpdate:modelValue": ($event) => unref(form).details = $event,
        error: _ctx.$page.props.errors.details
      }, null, _parent));
      _push(`</div></div><div class="flex flex-row justify-end px-6 py-4 bg-gray-100 dark:bg-gray-950 text-end">`);
      _push(ssrRenderComponent(unref(_sfc_main$8), { onClick: close }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Cancel"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Cancel")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$9), {
        class: "ms-3",
        loading: unref(form).processing
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Save"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></form>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Order/Expense/Form.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
