import { resolveComponent, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent, ssrRenderClass, ssrRenderList } from "vue/server-renderer";
import "../ssr.js";
import { usePage, useForm } from "@inertiajs/vue3";
import "lodash.debounce";
import "dayjs";
import { h as _sfc_main$1, b as _sfc_main$2, l as _sfc_main$4, v as _sfc_main$5 } from "./http-CDixhmav.js";
import { _ as _sfc_main$7 } from "./LoadingButton-DREeyNQW.js";
import "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import { a as _sfc_main$3 } from "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import { _ as _sfc_main$6 } from "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = {
  __name: "Form",
  __ssrInlineRender: true,
  props: ["current", "models", "types", "custom_fields"],
  emits: ["close", "done"],
  setup(__props, { emit: __emit }) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _i;
    usePage();
    const emits = __emit;
    const props = __props;
    const form = useForm({
      _method: ((_a = props.current) == null ? void 0 : _a.id) ? "put" : "post",
      name: (_b = props.current) == null ? void 0 : _b.name,
      type: (_c = props.current) == null ? void 0 : _c.type,
      details: (_d = props.current) == null ? void 0 : _d.details,
      order_no: (_e = props.current) == null ? void 0 : _e.order_no,
      options: ((_f = props.current) == null ? void 0 : _f.options) || [""],
      models: (_g = props.current) == null ? void 0 : _g.models.map((m) => m),
      is_required: ((_h = props.current) == null ? void 0 : _h.is_required) == 1,
      show_on_details_view: ((_i = props.current) == null ? void 0 : _i.show_on_details_view) == 1
    });
    return (_ctx, _push, _parent, _attrs) => {
      var _a2, _b2;
      const _component_Icon = resolveComponent("Icon");
      _push(`<form${ssrRenderAttrs(_attrs)}><div class="border-b border-gray-200 dark:border-gray-700 px-6 py-4"><div class="sm:flex sm:items-baseline sm:justify-between"><div class="sm:w-0 sm:flex-1"><h1 class="text-base font-semibold text-focus">${ssrInterpolate(((_a2 = __props.current) == null ? void 0 : _a2.id) ? _ctx.$t("Edit {x}", { x: _ctx.$t("Custom Field") }) : _ctx.$t("Add {x}", { x: _ctx.$t("Custom Field") }))}</h1><p class="mt-1 truncate text-sm text-mute">${ssrInterpolate(_ctx.$t("Please fill the form below to {action} {record}.", {
        record: _ctx.$t("tax"),
        action: ((_b2 = __props.current) == null ? void 0 : _b2.id) ? _ctx.$t("edit") : _ctx.$t("add")
      }))}</p></div></div></div><div class="p-6 grid grid-cols-6 gap-6"><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        id: "name",
        label: _ctx.$t("Name"),
        modelValue: unref(form).name,
        "onUpdate:modelValue": ($event) => unref(form).name = $event,
        error: unref(form).errors.name
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        id: "order_no",
        label: _ctx.$t("Order Number"),
        modelValue: unref(form).order_no,
        "onUpdate:modelValue": ($event) => unref(form).order_no = $event,
        error: unref(form).errors.order_no
      }, null, _parent));
      _push(`</div><div class="col-span-full">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "models",
        json: true,
        multiple: true,
        searchable: false,
        modelValue: unref(form).models,
        "onUpdate:modelValue": ($event) => unref(form).models = $event,
        label: _ctx.$t("Models"),
        error: unref(form).errors.models,
        suggestions: __props.models.map((t) => ({ value: t, label: _ctx.$t(_ctx.$title(t.replace("_", " "))) }))
      }, null, _parent));
      _push(`</div><div class="col-span-full">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "type",
        json: true,
        label: _ctx.$t("Type"),
        searchable: false,
        modelValue: unref(form).type,
        "onUpdate:modelValue": ($event) => unref(form).type = $event,
        error: unref(form).errors.type,
        suggestions: __props.types.map((t) => ({ value: t, label: _ctx.$t(_ctx.$capitalize(t)) }))
      }, null, _parent));
      _push(`</div><span class="sr-only">${ssrInterpolate(_ctx.$t("Text"))} ${ssrInterpolate(_ctx.$t("Select"))} ${ssrInterpolate(_ctx.$t("Checkbox"))} ${ssrInterpolate(_ctx.$t("Radio"))} ${ssrInterpolate(_ctx.$t("Textarea"))} ${ssrInterpolate(_ctx.$t("Date"))} ${ssrInterpolate(_ctx.$t("Time"))} ${ssrInterpolate(_ctx.$t("Number"))} ${ssrInterpolate(_ctx.$t("Email"))} ${ssrInterpolate(_ctx.$t("Url"))}</span>`);
      if (unref(form).type == "select" || unref(form).type == "checkbox" || unref(form).type == "radio") {
        _push(`<div class="${ssrRenderClass([unref(form).errors.options ? "border-red-500 dark:border-red-500" : "dark:border-gray-700", "col-span-full rounded-md border p-4 md:p-6 grid grid-cols-6 gap-6"])}"><div class="col-span-full flex items-center justify-start gap-x-4"><h4 class="font-bold">${ssrInterpolate(_ctx.$t("Options"))}</h4><button type="button" class="rounded-md -m-2 p-2 hover:bg-gray-100 dark:hover:bg-gray-800">`);
        _push(ssrRenderComponent(_component_Icon, { name: "plus" }, null, _parent));
        _push(`</button></div><!--[-->`);
        ssrRenderList(unref(form).options, (option, index) => {
          _push(`<div class="col-span-6 sm:col-span-3">`);
          _push(ssrRenderComponent(unref(_sfc_main$1), {
            modelValue: unref(form).options[index],
            "onUpdate:modelValue": ($event) => unref(form).options[index] = $event,
            label: _ctx.$t("Option") + " " + (index + 1)
          }, null, _parent));
          _push(`</div>`);
        });
        _push(`<!--]-->`);
        if (unref(form).errors.options) {
          _push(`<div class="col-span-full">`);
          _push(ssrRenderComponent(unref(_sfc_main$3), {
            message: unref(form).errors.options
          }, null, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="col-span-full">`);
      _push(ssrRenderComponent(unref(_sfc_main$4), {
        id: "details",
        label: _ctx.$t("Details"),
        modelValue: unref(form).details,
        "onUpdate:modelValue": ($event) => unref(form).details = $event,
        error: unref(form).errors.details
      }, null, _parent));
      _push(`</div><div class="col-span-full">`);
      _push(ssrRenderComponent(unref(_sfc_main$5), {
        id: "is_required",
        error: unref(form).errors.is_required,
        checked: unref(form).is_required,
        "onUpdate:checked": ($event) => unref(form).is_required = $event,
        label: _ctx.$t("Require this field")
      }, null, _parent));
      _push(`</div><div class="col-span-full -mt-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$5), {
        id: "show_on_details_view",
        label: _ctx.$t("Show on details view"),
        error: unref(form).errors.show_on_details_view,
        checked: unref(form).show_on_details_view,
        "onUpdate:checked": ($event) => unref(form).show_on_details_view = $event
      }, null, _parent));
      _push(`</div></div><div class="flex flex-row justify-end px-6 py-4 bg-gray-100 dark:bg-gray-950 text-end">`);
      _push(ssrRenderComponent(unref(_sfc_main$6), {
        onClick: ($event) => emits("close")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Cancel"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Cancel")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$7), {
        class: "ms-3",
        loading: unref(form).processing
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Save"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></form>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Setting/CustomField/Form.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
