import { ref, watch, nextTick, resolveComponent, withCtx, createVNode, toDisplayString, unref, createTextVNode, createBlock, createCommentVNode, openBlock, Fragment, renderList, withDirectives, vShow, withModifiers, withKeys, vModelText, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrIncludeBooleanAttr, ssrRenderList, ssrRenderStyle, ssrRenderClass } from "vue/server-renderer";
import { T } from "../ssr.js";
import { notify } from "notiwind";
import isequal from "lodash.isequal";
import debounce from "lodash.debounce";
import { usePage, useForm, router } from "@inertiajs/vue3";
import { u as $decimal, a as axios, b as _sfc_main$5, h as _sfc_main$6, k as _sfc_main$7, i as _sfc_main$8, l as _sfc_main$c, s as _sfc_main$d, e as _sfc_main$e } from "./http-CDixhmav.js";
import "dayjs";
import { _ as _sfc_main$4 } from "./LoadingButton-DREeyNQW.js";
import { _ as _sfc_main$1 } from "./AdminLayout-DHH3IgME.js";
import { _ as _sfc_main$3 } from "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import { _ as _sfc_main$2 } from "./FormSection-C7JuSy06.js";
import { a as _sfc_main$b } from "./InputError-DjBtKS5r.js";
import { _ as _sfc_main$9 } from "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import { _ as _sfc_main$a } from "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "axios";
import "lodash.throttle";
import "./AppLayout-BRHmSgDa.js";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = /* @__PURE__ */ Object.assign({ layout: _sfc_main$1 }, {
  __name: "Form",
  __ssrInlineRender: true,
  props: ["current", "brands", "categories", "stores", "taxes", "units"],
  setup(__props) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _A, _B, _C, _D, _E, _F, _G, _H, _I, _J, _K, _L, _M, _N, _O, _P, _Q, _R, _S, _T, _U, _V, _W, _X, _Y, _Z, __, _$, _aa, _ba, _ca;
    const page = usePage();
    const props = __props;
    const unit = ref(null);
    const result = ref([]);
    const search = ref(null);
    const category = ref(null);
    const photoInput = ref(null);
    const photoPreview = ref(null);
    if ((_a = props.current) == null ? void 0 : _a.category_id) {
      category.value = props.categories.find((c) => c.id == props.current.category_id);
    }
    if ((_b = props.current) == null ? void 0 : _b.unit_id) {
      unit.value = props.units.find((u) => u.id == props.current.unit_id);
      if (((_c = props.current) == null ? void 0 : _c.unit_prices) && Object.keys(props.current.unit_prices).length) {
        props.current.unit_prices = props.current.unit_prices.reduce((a, i) => {
          a[i.unit_id] = { cost: i.cost ? Number(i.cost) : null, price: i.price ? Number(i.price) : null };
          return a;
        }, {});
      } else if ((_d = unit.value) == null ? void 0 : _d.subunits) {
        props.current.unit_prices = (_e = unit.value.subunits) == null ? void 0 : _e.reduce((a, i) => {
          a[i.id] = { cost: null, price: null };
          return a;
        }, {});
      }
    }
    const form = useForm({
      _method: ((_f = props.current) == null ? void 0 : _f.id) ? "put" : "post",
      photo: null,
      photos: null,
      type: ((_g = props.current) == null ? void 0 : _g.type) || "Standard",
      name: (_h = props.current) == null ? void 0 : _h.name,
      secondary_name: (_i = props.current) == null ? void 0 : _i.secondary_name,
      code: (_j = props.current) == null ? void 0 : _j.code,
      symbology: ((_k = props.current) == null ? void 0 : _k.symbology) || "CODE39",
      category_id: (_l = props.current) == null ? void 0 : _l.category_id,
      subcategory_id: (_m = props.current) == null ? void 0 : _m.subcategory_id,
      brand_id: (_n = props.current) == null ? void 0 : _n.brand_id,
      unit_id: (_o = props.current) == null ? void 0 : _o.unit_id,
      unit_prices: ((_p = props.current) == null ? void 0 : _p.unit_prices) || null,
      cost: ((_q = props.current) == null ? void 0 : _q.cost) ? $decimal((_r = props.current) == null ? void 0 : _r.cost) : "",
      price: ((_s = props.current) == null ? void 0 : _s.price) ? $decimal((_t = props.current) == null ? void 0 : _t.price) : "",
      min_price: ((_u = props.current) == null ? void 0 : _u.min_price) ? $decimal((_v = props.current) == null ? void 0 : _v.min_price) : "",
      max_price: ((_w = props.current) == null ? void 0 : _w.max_price) ? $decimal((_x = props.current) == null ? void 0 : _x.max_price) : "",
      max_discount: ((_y = props.current) == null ? void 0 : _y.max_discount) ? $decimal((_z = props.current) == null ? void 0 : _z.max_discount) : "",
      hsn_number: (_A = props.current) == null ? void 0 : _A.hsn_number,
      sac_number: (_B = props.current) == null ? void 0 : _B.sac_number,
      weight: (_C = props.current) == null ? void 0 : _C.weight,
      dimensions: (_D = props.current) == null ? void 0 : _D.dimensions,
      rack_location: (_E = props.current) == null ? void 0 : _E.rack_location,
      supplier_id: (_F = props.current) == null ? void 0 : _F.supplier_id,
      supplier_part_id: (_G = props.current) == null ? void 0 : _G.supplier_part_id,
      alert_quantity: ((_H = props.current) == null ? void 0 : _H.alert_quantity) ? Number((_I = props.current) == null ? void 0 : _I.alert_quantity) : null,
      taxes: props.current ? (_J = props.current.taxes) == null ? void 0 : _J.map((t) => t.id) : page.props.settings.product_taxes || [],
      products: props.current && props.current.products ? props.current.products.map((p) => ({ id: p.id, code: p.code, name: p.name, quantity: Number(p.pivot.quantity) })) : [],
      stores: props.current && props.current.stores ? props.current.stores.map((s) => {
        var _a2;
        return {
          store_id: s.id,
          price: Number(s.pivot.price),
          quantity: Number(s.pivot.quantity),
          taxes: ((_a2 = s.pivot.taxes) == null ? void 0 : _a2.value) || [],
          alert_quantity: s.pivot.alert_quantity ? Number(s.pivot.alert_quantity) : null
        };
      }) : props.stores.map((s) => ({ store_id: s.id, quantity: null, alert_quantity: null, price: null, taxes: [] })),
      details: (_K = props.current) == null ? void 0 : _K.details,
      video_url: (_L = props.current) == null ? void 0 : _L.video_url,
      file: (_M = props.current) == null ? void 0 : _M.file,
      featured: ((_N = props.current) == null ? void 0 : _N.featured) == 1,
      hide_in_pos: ((_O = props.current) == null ? void 0 : _O.hide_in_pos) == 1,
      hide_in_shop: ((_P = props.current) == null ? void 0 : _P.hide_in_shop) == 1,
      tax_included: ((_Q = props.current) == null ? void 0 : _Q.tax_included) == 1,
      can_edit_price: ((_R = props.current) == null ? void 0 : _R.can_edit_price) == 1,
      has_expiry_date: ((_S = props.current) == null ? void 0 : _S.has_expiry_date) == 1,
      has_variants: ((_T = props.current) == null ? void 0 : _T.has_variants) == 1,
      has_serials: ((_U = props.current) == null ? void 0 : _U.has_serials) == 1,
      dont_track_stock: ((_V = props.current) == null ? void 0 : _V.dont_track_stock) == 1,
      serials: ((_W = props.current) == null ? void 0 : _W.serials) || [{ number: "", till: "" }],
      variants: ((_X = props.current) == null ? void 0 : _X.variants) || [{ name: "", options: [""] }],
      variations: ((_Y = props.current) == null ? void 0 : _Y.variations) || [],
      set_stock: props.current && props.current.stores ? props.current.stores.filter((s) => s.pivot.price) : false,
      slug: (_Z = props.current) == null ? void 0 : _Z.slug,
      title: (__ = props.current) == null ? void 0 : __.title,
      description: (_$ = props.current) == null ? void 0 : _$.description,
      keywords: (_aa = props.current) == null ? void 0 : _aa.keywords,
      noindex: ((_ba = props.current) == null ? void 0 : _ba.noindex) == 1,
      nofollow: ((_ca = props.current) == null ? void 0 : _ca.nofollow) == 1
    });
    watch(search, debounce(searchProduct, 500));
    const selectNewPhoto = () => {
      photoInput.value.click();
    };
    const updatePhotoPreview = () => {
      const photo = photoInput.value.files[0];
      if (!photo) return;
      const reader = new FileReader();
      reader.onload = (e) => {
        photoPreview.value = e.target.result;
      };
      reader.readAsDataURL(photo);
    };
    const deletePhoto = () => {
      router.delete(T("products.photo.destroy"), {
        preserveScroll: true,
        onSuccess: () => {
          photoPreview.value = null;
          clearPhotoFileInput();
        }
      });
    };
    const clearPhotoFileInput = () => {
      var _a2;
      if ((_a2 = photoInput.value) == null ? void 0 : _a2.value) {
        photoInput.value.value = null;
      }
    };
    async function searchProduct(q) {
      await axios.post(T("search.products", { search: q, type: "combo" })).then((res) => {
        if (res.data.length == 1) {
          addProduct(res.data[0]);
        } else {
          result.value = res.data;
        }
      }).catch();
    }
    async function addProduct(product) {
      if (form.products.find((p) => p.id == product.id)) {
        form.products = form.products.map((p) => {
          if (p.id == product.id) {
            p.quantity++;
          }
          return p;
        });
      } else {
        form.products = [...form.products, { ...product, quantity: 1 }];
      }
      await nextTick();
      quantityChanged();
      search.value = "";
      document.getElementById("product-search").focus();
    }
    async function quantityChanged() {
      await nextTick();
      form.cost = $decimal(form.products.reduce((a, i) => a + Number(i.cost) * Number(i.quantity), 0));
      form.price = $decimal(form.products.reduce((a, i) => a + Number(i.price) * Number(i.quantity), 0));
      form.min_price = $decimal(form.products.reduce((a, i) => a + Number(i.min_price) * Number(i.quantity), 0));
      form.max_price = $decimal(form.products.reduce((a, i) => a + Number(i.max_price) * Number(i.quantity), 0));
    }
    function removeItem(product) {
      form.products = [...form.products.filter((i) => i.id != product.id)];
    }
    function countSerials(n1, n2) {
      if (!n1 && !n2) {
        return 0;
      } else if (n1 && !n2) {
        return 1;
      }
      let n3 = n2 - n1;
      return n3 > 0 ? n3 + 1 : n2 == n1 ? 1 : "?";
    }
    async function focusNextSerialInput(e, index) {
      var _a2;
      e.preventDefault();
      if (index == form.serials.length - 1) {
        form.serials.push({ number: "", till: "" });
      }
      await nextTick();
      (_a2 = document.getElementById("serial_" + (index + 1))) == null ? void 0 : _a2.focus();
    }
    async function focusOnNextOption(e, i, index) {
      var _a2;
      e.preventDefault();
      if (i == form.variants[index].options.length - 1) {
        form.variants[index].options = [...form.variants[index].options, ""];
      }
      await nextTick();
      (_a2 = document.getElementById("option_" + index + "_" + (i + 1))) == null ? void 0 : _a2.focus();
    }
    function generateVariations() {
      let variations = [];
      const ev = { code: "", cost: "", price: "", quantity: "", weight: "", dimensions: "" };
      let vo = {};
      form.variants.map((v, vi) => vo[v.name] = v.options);
      if (Object.keys(vo).length == 1) {
        let key = Object.keys(vo)[0];
        vo[key].map((o) => {
          let va = { ...ev, meta: {} };
          va.meta[key] = o;
          variations = [...variations, va];
        });
      } else if (Object.keys(vo).length == 2) {
        let key0 = Object.keys(vo)[0];
        let key1 = Object.keys(vo)[1];
        vo[key0].forEach((v0) => {
          vo[key1].forEach((v1) => {
            let va = { ...ev, meta: {} };
            va.meta[key0] = v0;
            va.meta[key1] = v1;
            variations = [...variations, va];
          });
        });
      } else if (Object.keys(vo).length == 3) {
        let key0 = Object.keys(vo)[0];
        let key1 = Object.keys(vo)[1];
        let key2 = Object.keys(vo)[2];
        vo[key0].forEach((v0) => {
          vo[key1].forEach((v1) => {
            vo[key2].forEach((v2) => {
              let va = { ...ev, meta: {} };
              va.meta[key0] = v0;
              va.meta[key1] = v1;
              va.meta[key2] = v2;
              variations = [...variations, va];
            });
          });
        });
      }
      form.variations = variations.map((v) => {
        let ev2 = form.variations.find((e) => isequal(v.meta, e.meta));
        return ev2 ? ev2 : v;
      });
    }
    function handleSubmit(e, listing = false) {
      var _a2;
      if (photoInput.value) {
        form.photo = photoInput.value.files[0];
      }
      form.transform((data) => {
        let form2 = { ...data };
        form2.stores = form2.set_stock && !form2.dont_track_stock ? form2.stores : [];
        form2.serials = form2.has_serials ? form2.serials.filter((s) => s.number) : [];
        form2.products = ["Combo", "Recipe"].includes(form2.type) ? form2.products : null;
        if (form2.has_variants) {
          form2.variations = form2.variations;
          form2.variants = form2.variants.map((v) => ({ name: v.name, options: v.options.filter((o) => o) }));
        } else {
          form2.variants = null;
          form2.variations = null;
        }
        return form2;
      }).post(((_a2 = props.current) == null ? void 0 : _a2.id) ? T("products.update", props.current.id) : T("products.store"), {
        onSuccess: (page2) => {
          if (listing) {
            router.get(T("products.index"));
          }
        }
      });
    }
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Head = resolveComponent("Head");
      const _component_Link = resolveComponent("Link");
      const _component_Icon = resolveComponent("Icon");
      const _component_fiv = resolveComponent("fiv");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_Head, null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          var _a2, _b2;
          if (_push2) {
            _push2(`<title${_scopeId}>${ssrInterpolate(((_a2 = __props.current) == null ? void 0 : _a2.id) ? _ctx.$t("Edit {x}", { x: _ctx.$t("Product") }) : _ctx.$t("Add {x}", { x: _ctx.$t("Product") }))}</title>`);
          } else {
            return [
              createVNode("title", null, toDisplayString(((_b2 = __props.current) == null ? void 0 : _b2.id) ? _ctx.$t("Edit {x}", { x: _ctx.$t("Product") }) : _ctx.$t("Add {x}", { x: _ctx.$t("Product") })), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<div class="pt-6 pb-0 sm:py-8 px-0 sm:px-6 lg:px-8">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), { onSubmitted: handleSubmit }, {
        title: withCtx((_, _push2, _parent2, _scopeId) => {
          var _a2, _b2;
          if (_push2) {
            _push2(`${ssrInterpolate(((_a2 = __props.current) == null ? void 0 : _a2.id) ? _ctx.$t("Edit {x}", { x: _ctx.$t("Product") }) : _ctx.$t("Add {x}", { x: _ctx.$t("Product") }))}`);
          } else {
            return [
              createTextVNode(toDisplayString(((_b2 = __props.current) == null ? void 0 : _b2.id) ? _ctx.$t("Edit {x}", { x: _ctx.$t("Product") }) : _ctx.$t("Add {x}", { x: _ctx.$t("Product") })), 1)
            ];
          }
        }),
        description: withCtx((_, _push2, _parent2, _scopeId) => {
          var _a2, _b2;
          if (_push2) {
            _push2(`<div class="w-full block sm:flex sm:items-start sm:justify-between lg:block"${_scopeId}><div${_scopeId}>${ssrInterpolate(_ctx.$t("Please fill the form below to {action} {record}.", {
              record: _ctx.$t("product"),
              action: ((_a2 = __props.current) == null ? void 0 : _a2.id) ? _ctx.$t("edit") : _ctx.$t("add")
            }))}</div><div class="mt-6 sm:mt-0 lg:mt-6 me-3"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_Link, {
              class: "link",
              href: unref(T)("products.index")
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("List {x}", { x: _ctx.$t("Products") }))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("List {x}", { x: _ctx.$t("Products") })), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div></div>`);
          } else {
            return [
              createVNode("div", { class: "w-full block sm:flex sm:items-start sm:justify-between lg:block" }, [
                createVNode("div", null, toDisplayString(_ctx.$t("Please fill the form below to {action} {record}.", {
                  record: _ctx.$t("product"),
                  action: ((_b2 = __props.current) == null ? void 0 : _b2.id) ? _ctx.$t("edit") : _ctx.$t("add")
                })), 1),
                createVNode("div", { class: "mt-6 sm:mt-0 lg:mt-6 me-3" }, [
                  createVNode(_component_Link, {
                    class: "link",
                    href: unref(T)("products.index")
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(_ctx.$t("List {x}", { x: _ctx.$t("Products") })), 1)
                    ]),
                    _: 1
                  }, 8, ["href"])
                ])
              ])
            ];
          }
        }),
        form: withCtx((_, _push2, _parent2, _scopeId) => {
          var _a2, _b2, _c2, _d2, _e2, _f2, _g2, _h2, _i2, _j2, _k2, _l2, _m2, _n2;
          if (_push2) {
            _push2(`<div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$5), {
              id: "type",
              json: true,
              label: _ctx.$t("Type"),
              modelValue: unref(form).type,
              "onUpdate:modelValue": ($event) => unref(form).type = $event,
              error: unref(form).errors.type,
              suggestions: [
                { value: "Standard", label: _ctx.$t("Standard") },
                { value: "Service", label: _ctx.$t("Service") },
                { value: "Digital", label: _ctx.$t("Digital") },
                { value: "Combo", label: _ctx.$t("Combo") },
                { value: "Recipe", label: _ctx.$t("Recipe") }
              ]
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}></div>`);
            if (unref(form).type == "Combo") {
              _push2(`<div class="col-span-full p-6 mb-6 rounded border border-gray-200 dark:border-gray-700"${_scopeId}><div class="relative"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                id: "product-search",
                label: "",
                modelValue: search.value,
                "onUpdate:modelValue": ($event) => search.value = $event,
                placeholder: _ctx.$t("Scan barcode or type to search")
              }, null, _parent2, _scopeId));
              if (search.value && result.value && result.value.length) {
                _push2(`<div class="absolute z-10 top-full left-0 right-0 ring-1 bg-white dark:bg-gray-700 rounded-md dark:ring-gray-700 mt-2 py-1"${_scopeId}><!--[-->`);
                ssrRenderList(result.value, (p) => {
                  _push2(`<button type="button" class="w-full text-left py-1.5 px-4 hover:bg-gray-100 dark:hover:bg-gray-900"${_scopeId}>${ssrInterpolate(p.name)}</button>`);
                });
                _push2(`<!--]--></div>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(`</div>`);
              if (unref(form).products && unref(form).products.length) {
                _push2(`<div${_scopeId}><h4 class="text-lg font-bold mt-6 mb-3"${_scopeId}>${ssrInterpolate(_ctx.$t("Combo Products"))}</h4><table class="w-full divide-y dark:divide-gray-700"${_scopeId}><!--[-->`);
                ssrRenderList(unref(form).products, (product, index) => {
                  var _a3;
                  _push2(`<tr${_scopeId}><td class="w-8 py-2"${_scopeId}>${ssrInterpolate(index + 1)}.</td><td class="p-2"${_scopeId}>${ssrInterpolate(product.name)}</td><td class="w-36 py-2"${_scopeId}>`);
                  _push2(ssrRenderComponent(unref(_sfc_main$6), {
                    min: 0,
                    "del-on": 0,
                    type: "number",
                    modelValue: product.quantity,
                    "onUpdate:modelValue": ($event) => product.quantity = $event,
                    onRemove: ($event) => removeItem(product),
                    onChange: ($event) => quantityChanged(),
                    max: product.selected_store && product.selected_store[0] ? (_a3 = product.selected_store[0].pivot) == null ? void 0 : _a3.quantity : null
                  }, null, _parent2, _scopeId));
                  _push2(`</td></tr>`);
                });
                _push2(`<!--]--></table></div>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(`</div>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$6), {
              id: "name",
              label: _ctx.$t("Name"),
              modelValue: unref(form).name,
              "onUpdate:modelValue": ($event) => unref(form).name = $event,
              error: unref(form).errors.name
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$6), {
              id: "secondary_name",
              label: _ctx.$t("Secondary Name"),
              modelValue: unref(form).secondary_name,
              "onUpdate:modelValue": ($event) => unref(form).secondary_name = $event,
              error: unref(form).errors.secondary_name
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$6), {
              id: "code",
              label: _ctx.$t("Code") + " (" + _ctx.$t("barcode") + ")",
              modelValue: unref(form).code,
              "onUpdate:modelValue": ($event) => unref(form).code = $event,
              error: unref(form).errors.code
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$5), {
              id: "symbology",
              label: _ctx.$t("Symbology"),
              modelValue: unref(form).symbology,
              "onUpdate:modelValue": ($event) => unref(form).symbology = $event,
              error: unref(form).errors.symbology,
              suggestions: ["CODE128", "CODE39", "EAN8", "EAN13", "UPC"]
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$5), {
              json: true,
              valueKey: "id",
              labelKey: "name",
              id: "category_id",
              label: _ctx.$t("Category"),
              suggestions: __props.categories,
              modelValue: unref(form).category_id,
              "onUpdate:modelValue": ($event) => unref(form).category_id = $event,
              onChange: (e) => category.value = e,
              error: unref(form).errors.category_id
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$5), {
              json: true,
              valueKey: "id",
              labelKey: "name",
              id: "subcategory_id",
              label: _ctx.$t("Subcategory"),
              modelValue: unref(form).subcategory_id,
              "onUpdate:modelValue": ($event) => unref(form).subcategory_id = $event,
              error: unref(form).errors.subcategory_id,
              suggestions: ((_a2 = category.value) == null ? void 0 : _a2.children) || []
            }, null, _parent2, _scopeId));
            _push2(`</div>`);
            if (unref(form).type == "Standard") {
              _push2(`<div class="col-span-6 sm:col-span-3"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$5), {
                json: true,
                id: "brand_id",
                valueKey: "id",
                labelKey: "name",
                clearable: true,
                label: _ctx.$t("Brand"),
                suggestions: __props.brands,
                modelValue: unref(form).brand_id,
                "onUpdate:modelValue": ($event) => unref(form).brand_id = $event,
                error: unref(form).errors.brand_id
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              _push2(`<!---->`);
            }
            if (unref(form).type == "Standard") {
              _push2(`<!--[--><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$5), {
                json: true,
                id: "unit_id",
                valueKey: "id",
                labelKey: "name",
                clearable: true,
                label: _ctx.$t("Unit"),
                suggestions: __props.units,
                modelValue: unref(form).unit_id,
                "onUpdate:modelValue": ($event) => unref(form).unit_id = $event,
                onChange: (e) => {
                  var _a3;
                  unit.value = e;
                  unref(form).unit_prices = (_a3 = unit.value.subunits) == null ? void 0 : _a3.reduce((a, i) => {
                    a[i.id] = { cost: null, price: null };
                    return a;
                  }, {});
                },
                error: unref(form).errors.unit_id
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
              if (((_b2 = unit.value) == null ? void 0 : _b2.subunits) && unit.value.subunits.length) {
                _push2(`<!--[--><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
                _push2(ssrRenderComponent(unref(_sfc_main$5), {
                  json: true,
                  valueKey: "id",
                  labelKey: "name",
                  clearable: true,
                  id: "sale_unit_id",
                  label: _ctx.$t("Sale Unit"),
                  suggestions: unit.value.subunits,
                  modelValue: unref(form).sale_unit_id,
                  "onUpdate:modelValue": ($event) => unref(form).sale_unit_id = $event,
                  error: unref(form).errors.sale_unit_id
                }, null, _parent2, _scopeId));
                _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
                _push2(ssrRenderComponent(unref(_sfc_main$5), {
                  json: true,
                  valueKey: "id",
                  labelKey: "name",
                  clearable: true,
                  id: "purchase_unit_id",
                  label: _ctx.$t("Purchase Unit"),
                  suggestions: unit.value.subunits,
                  modelValue: unref(form).purchase_unit_id,
                  "onUpdate:modelValue": ($event) => unref(form).purchase_unit_id = $event,
                  error: unref(form).errors.purchase_unit_id
                }, null, _parent2, _scopeId));
                _push2(`</div><!--]-->`);
              } else {
                _push2(`<!---->`);
              }
              _push2(`<!--]-->`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$6), {
              id: "cost",
              type: "number",
              modelValue: unref(form).cost,
              "onUpdate:modelValue": ($event) => unref(form).cost = $event,
              error: unref(form).errors.cost,
              label: _ctx.$t("Purchase Cost"),
              readonly: ["Combo", "Recipe"].includes(unref(form).type)
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$6), {
              id: "price",
              type: "number",
              label: _ctx.$t("Selling Price"),
              modelValue: unref(form).price,
              "onUpdate:modelValue": ($event) => unref(form).price = $event,
              error: unref(form).errors.price
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$6), {
              id: "min_price",
              type: "number",
              label: _ctx.$t("Minimum Price"),
              modelValue: unref(form).min_price,
              "onUpdate:modelValue": ($event) => unref(form).min_price = $event,
              error: unref(form).errors.min_price
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$6), {
              id: "max_price",
              type: "number",
              label: _ctx.$t("Maximum Price"),
              modelValue: unref(form).max_price,
              "onUpdate:modelValue": ($event) => unref(form).max_price = $event,
              error: unref(form).errors.max_price
            }, null, _parent2, _scopeId));
            _push2(`</div>`);
            if (!["Combo", "Recipe"].includes(unref(form).type) && unref(form).unit_prices && ((_d2 = (_c2 = unit.value) == null ? void 0 : _c2.subunits) == null ? void 0 : _d2.length)) {
              _push2(`<!--[-->`);
              ssrRenderList(unit.value.subunits, (subunit) => {
                _push2(`<div class="col-span-full relative grid grid-cols-6 gap-6 rounded-md mt-3 pt-8 pb-4 px-4 border border-gray-200 dark:border-gray-700"${_scopeId}><div class="absolute -top-4 left-4 bg-gray-100 dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-md py-0.5 px-3 font-extrabold text-lg flex items-center gap-x-4"${_scopeId}>${ssrInterpolate(subunit.name)}</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
                _push2(ssrRenderComponent(unref(_sfc_main$6), {
                  id: "cost",
                  type: "number",
                  label: _ctx.$t("Purchase Cost"),
                  modelValue: unref(form).unit_prices[subunit.id].cost,
                  "onUpdate:modelValue": ($event) => unref(form).unit_prices[subunit.id].cost = $event,
                  error: unref(form).errors.unit_prices ? unref(form).errors.unit_prices[subunit.id].cost : null
                }, null, _parent2, _scopeId));
                _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
                _push2(ssrRenderComponent(unref(_sfc_main$6), {
                  id: "price",
                  type: "number",
                  label: _ctx.$t("Selling Price"),
                  modelValue: unref(form).unit_prices[subunit.id].price,
                  "onUpdate:modelValue": ($event) => unref(form).unit_prices[subunit.id].price = $event,
                  error: unref(form).errors.unit_prices ? unref(form).errors.unit_prices[subunit.id].price : null
                }, null, _parent2, _scopeId));
                _push2(`</div></div>`);
              });
              _push2(`<!--]-->`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<div class="col-span-full"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$5), {
              id: "taxes",
              json: true,
              valueKey: "id",
              labelKey: "name",
              multiple: true,
              searchable: false,
              label: _ctx.$t("Taxes"),
              suggestions: __props.taxes,
              modelValue: unref(form).taxes,
              "onUpdate:modelValue": ($event) => unref(form).taxes = $event,
              error: _ctx.$page.props.errors.taxes
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$6), {
              id: "max_discount",
              type: "number",
              label: _ctx.$t("Maximum Discount"),
              modelValue: unref(form).max_discount,
              "onUpdate:modelValue": ($event) => unref(form).max_discount = $event,
              error: unref(form).errors.max_discount
            }, null, _parent2, _scopeId));
            _push2(`</div>`);
            if (["Standard", "Combo", "Recipe"].includes(unref(form).type)) {
              _push2(`<div class="col-span-6 sm:col-span-3"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                id: "rack_location",
                label: _ctx.$t("Rack Location"),
                modelValue: unref(form).rack_location,
                "onUpdate:modelValue": ($event) => unref(form).rack_location = $event,
                error: unref(form).errors.rack_location
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              _push2(`<!---->`);
            }
            if (["Standard", "Combo", "Recipe"].includes(unref(form).type)) {
              _push2(`<div class="col-span-6 sm:col-span-3"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                id: "weight",
                type: "number",
                label: _ctx.$t("Weight"),
                modelValue: unref(form).weight,
                "onUpdate:modelValue": ($event) => unref(form).weight = $event,
                error: unref(form).errors.weight
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              _push2(`<!---->`);
            }
            if (["Standard", "Combo", "Recipe"].includes(unref(form).type)) {
              _push2(`<div class="col-span-6 sm:col-span-3"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                id: "dimensions",
                label: _ctx.$t("Dimensions"),
                modelValue: unref(form).dimensions,
                "onUpdate:modelValue": ($event) => unref(form).dimensions = $event,
                error: unref(form).errors.dimensions
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              _push2(`<!---->`);
            }
            if (["Standard", "Combo", "Recipe"].includes(unref(form).type)) {
              _push2(`<div class="col-span-6 sm:col-span-3"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                id: "hsn_number",
                label: _ctx.$t("HSN Number"),
                modelValue: unref(form).hsn_number,
                "onUpdate:modelValue": ($event) => unref(form).hsn_number = $event,
                error: unref(form).errors.hsn_number
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              _push2(`<!---->`);
            }
            if (unref(form).type == "Service") {
              _push2(`<div class="col-span-6 sm:col-span-3"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                id: "sac_number",
                label: _ctx.$t("SAC Number"),
                modelValue: unref(form).sac_number,
                "onUpdate:modelValue": ($event) => unref(form).sac_number = $event,
                error: unref(form).errors.sac_number
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              _push2(`<!---->`);
            }
            if (unref(form).type == "Standard") {
              _push2(`<div class="col-span-6 sm:col-span-3"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$5), {
                json: true,
                valueKey: "id",
                id: "supplier_id",
                labelKey: "company",
                label: _ctx.$t("Supplier"),
                modelValue: unref(form).supplier_id,
                "onUpdate:modelValue": ($event) => unref(form).supplier_id = $event,
                error: unref(form).errors.supplier_id,
                suggestions: unref(T)("search.suppliers")
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              _push2(`<!---->`);
            }
            if (unref(form).type == "Standard") {
              _push2(`<div class="col-span-6 sm:col-span-3"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                id: "supplier_part_id",
                label: _ctx.$t("Supplier Part Id"),
                modelValue: unref(form).supplier_part_id,
                "onUpdate:modelValue": ($event) => unref(form).supplier_part_id = $event,
                error: unref(form).errors.supplier_part_id
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              _push2(`<!---->`);
            }
            if (unref(form).type == "Standard") {
              _push2(`<div class="col-span-6 sm:col-span-3"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                type: "number",
                id: "alert_quantity",
                label: _ctx.$t("Alert (Low Stock) Quantity"),
                modelValue: unref(form).alert_quantity,
                "onUpdate:modelValue": ($event) => unref(form).alert_quantity = $event,
                error: unref(form).errors.alert_quantity
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<div class="col-span-full"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$7), {
              custom_fields: _ctx.custom_fields,
              errors: unref(form).errors,
              extra_attributes: unref(form).extra_attributes
            }, null, _parent2, _scopeId));
            _push2(`</div>`);
            if (unref(form).type == "Digital") {
              _push2(`<div class="col-span-full"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$8), {
                id: "file",
                multiple: "",
                label: _ctx.$t("File"),
                modelValue: unref(form).file,
                "onUpdate:modelValue": ($event) => unref(form).file = $event,
                error: unref(form).errors.file
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<div class="col-span-full"${_scopeId}><input id="photo" type="file" class="hidden"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$9), {
              for: "photo",
              value: _ctx.$t("Photo")
            }, null, _parent2, _scopeId));
            _push2(`<div style="${ssrRenderStyle(!photoPreview.value && ((_e2 = __props.current) == null ? void 0 : _e2.photo) ? null : { display: "none" })}" class="mt-2 p-1 rounded-md"${_scopeId}><img${ssrRenderAttr("alt", _ctx.$t("Photo"))}${ssrRenderAttr("src", (_f2 = __props.current) == null ? void 0 : _f2.photo)} class="rounded-md w-full h-full max-w-64 min-h-20 max-h-40 object-contain"${_scopeId}></div><div style="${ssrRenderStyle(photoPreview.value ? null : { display: "none" })}" class="mt-2 p-1 rounded-md"${_scopeId}><span class="block rounded-md w-full h-full max-w-64 min-h-24 max-h-40 bg-no-repeat bg-contain" style="${ssrRenderStyle("background-image: url('" + photoPreview.value + "');")}"${_scopeId}></span></div>`);
            _push2(ssrRenderComponent(unref(_sfc_main$a), {
              class: "mt-2 me-2",
              type: "button",
              onClick: () => selectNewPhoto()
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Select A New Photo"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Select A New Photo")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            if ((_g2 = __props.current) == null ? void 0 : _g2.photo) {
              _push2(ssrRenderComponent(unref(_sfc_main$a), {
                type: "button",
                onClick: () => deletePhoto(),
                class: "mt-2 p-1 rounded-md bg-gray-50 flex items-center justify-center"
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(_ctx.$t("Remove Photo"))}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(_ctx.$t("Remove Photo")), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              _push2(`<!---->`);
            }
            _push2(ssrRenderComponent(unref(_sfc_main$b), {
              message: unref(form).errors.photo,
              class: "mt-2"
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-full"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$8), {
              id: "photos",
              multiple: "",
              label: _ctx.$t("Photos"),
              modelValue: unref(form).photos,
              "onUpdate:modelValue": ($event) => unref(form).photos = $event,
              error: unref(form).errors.photos
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-full"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$6), {
              id: "video_url",
              label: _ctx.$t("Video URL"),
              modelValue: unref(form).video_url,
              "onUpdate:modelValue": ($event) => unref(form).video_url = $event,
              error: unref(form).errors.video_url
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-full"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$c), {
              id: "details",
              rows: "5",
              modelValue: unref(form).details,
              "onUpdate:modelValue": ($event) => unref(form).details = $event,
              error: unref(form).errors.details,
              label: _ctx.$t("Product Details")
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-full flex flex-col gap-2 rounded-md p-4 border border-gray-200 dark:border-gray-700 overflow-x-auto"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$d), {
              id: "featured",
              label: _ctx.$t("Featured"),
              modelValue: unref(form).featured,
              "onUpdate:modelValue": ($event) => unref(form).featured = $event
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$d), {
              id: "hide_in_pos",
              label: _ctx.$t("Hide in POS"),
              modelValue: unref(form).hide_in_pos,
              "onUpdate:modelValue": ($event) => unref(form).hide_in_pos = $event
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$d), {
              id: "hide_in_shop",
              label: _ctx.$t("Hide in Shop"),
              modelValue: unref(form).hide_in_shop,
              "onUpdate:modelValue": ($event) => unref(form).hide_in_shop = $event
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$d), {
              id: "tax_included",
              label: _ctx.$t("Tax is included in price"),
              modelValue: unref(form).tax_included,
              "onUpdate:modelValue": ($event) => unref(form).tax_included = $event
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$d), {
              id: "can_edit_price",
              label: _ctx.$t("Allow to change price while selling"),
              modelValue: unref(form).can_edit_price,
              "onUpdate:modelValue": ($event) => unref(form).can_edit_price = $event
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$d), {
              id: "has_expiry_date",
              modelValue: unref(form).has_expiry_date,
              "onUpdate:modelValue": ($event) => unref(form).has_expiry_date = $event,
              label: _ctx.$t("This product has expiry date"),
              text: "(" + _ctx.$t("show expiry date input while purchasing") + ")"
            }, null, _parent2, _scopeId));
            _push2(`</div>`);
            if (unref(form).type == "Standard") {
              _push2(`<!--[--><div class="col-span-full flex flex-col gap-2 rounded-md p-4 border border-gray-200 dark:border-gray-700 overflow-x-auto"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$d), {
                id: "has_variants",
                label: _ctx.$t("This product has variants"),
                modelValue: unref(form).has_variants,
                "onUpdate:modelValue": ($event) => unref(form).has_variants = $event
              }, null, _parent2, _scopeId));
              if (unref(form).has_variants) {
                _push2(`<div class="col-span-full"${_scopeId}><span class="sr-only"${_scopeId}>${ssrInterpolate(_ctx.$t("Color"))}${ssrInterpolate(_ctx.$t("color"))}${ssrInterpolate(_ctx.$t("Size"))}${ssrInterpolate(_ctx.$t("size"))}</span><div class="grid grid-cols-6 gap-6"${_scopeId}><div class="col-span-full mt-6 flex items-center justify-between"${_scopeId}><h4 class="text-lg font-bold"${_scopeId}>${ssrInterpolate(_ctx.$t("Variants"))}</h4><button type="button" class="relative -ml-px inline-flex items-center rounded-md bg-white dark:bg-gray-900 px-2 py-2 text-mute ring-1 ring-inset ring-gray-300 dark:ring-gray-700 hover:bg-gray-50 dark:hover:bg-gray-950 focus:z-10"${_scopeId}>`);
                _push2(ssrRenderComponent(_component_Icon, {
                  name: "add",
                  size: "size-5 sm:mr-2"
                }, null, _parent2, _scopeId));
                _push2(`<span class="hidden sm:block"${_scopeId}>${ssrInterpolate(_ctx.$t("Add {x}", { x: _ctx.$t("Variant") }))}</span></button></div><!--[-->`);
                ssrRenderList(unref(form).variants, (variant, index) => {
                  _push2(`<div class="relative col-span-full grid grid-cols-6 gap-6 rounded-md mt-2 px-6 pt-10 pb-6 border border-gray-200 dark:border-gray-700"${_scopeId}><div class="absolute -top-4 left-4 bg-gray-100 dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-md py-0.5 px-3 font-extrabold text-lg flex items-center gap-x-4"${_scopeId}>${ssrInterpolate(_ctx.$t("Variant {x}", { x: index + 1 }))} <button type="button" class="relative inline-flex items-center rounded-md -mr-2.5 p-1 text-mute hover:text-red-700 hover:bg-red-100 dark:hover:text-red-200 dark:hover:bg-red-950 focus:z-10"${_scopeId}><span class="sr-only"${_scopeId}>${ssrInterpolate(_ctx.$t("Remove"))}</span>`);
                  _push2(ssrRenderComponent(_component_Icon, {
                    name: "trash-o",
                    size: "size-5"
                  }, null, _parent2, _scopeId));
                  _push2(`</button></div><div class="col-span-full flex items-end gap-6"${_scopeId}>`);
                  _push2(ssrRenderComponent(_component_fiv, { class: "flex-1" }, {
                    default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                      if (_push3) {
                        _push3(ssrRenderComponent(unref(_sfc_main$6), {
                          label: _ctx.$t("Name"),
                          modelValue: variant.name,
                          "onUpdate:modelValue": ($event) => variant.name = $event
                        }, null, _parent3, _scopeId2));
                      } else {
                        return [
                          createVNode(unref(_sfc_main$6), {
                            label: _ctx.$t("Name"),
                            modelValue: variant.name,
                            "onUpdate:modelValue": ($event) => variant.name = $event
                          }, null, 8, ["label", "modelValue", "onUpdate:modelValue"])
                        ];
                      }
                    }),
                    _: 2
                  }, _parent2, _scopeId));
                  _push2(`<button type="button" class="relative inline-flex items-center rounded-md bg-white dark:bg-gray-900 p-2.5 text-mute ring-1 ring-inset ring-gray-300 dark:ring-gray-700 hover:bg-gray-50 dark:hover:bg-gray-950 focus:z-10"${_scopeId}>`);
                  _push2(ssrRenderComponent(_component_Icon, {
                    name: "add",
                    size: "size-5 sm:mr-2"
                  }, null, _parent2, _scopeId));
                  _push2(`<span class="hidden sm:block"${_scopeId}>${ssrInterpolate(_ctx.$t("Add {x}", { x: _ctx.$t("Option") }))}</span></button></div><!--[-->`);
                  ssrRenderList(unref(form).variants[index].options, (option, oi) => {
                    _push2(`<div class="col-span-6 sm:col-span-3"${_scopeId}>`);
                    _push2(ssrRenderComponent(unref(_sfc_main$6), {
                      id: "option_" + index + "_" + oi,
                      label: _ctx.$t("Option {x}", { x: oi + 1 }),
                      modelValue: unref(form).variants[index].options[oi],
                      "onUpdate:modelValue": ($event) => unref(form).variants[index].options[oi] = $event,
                      onKeyup: (e) => focusOnNextOption(e, oi, index)
                    }, null, _parent2, _scopeId));
                    _push2(`</div>`);
                  });
                  _push2(`<!--]--></div>`);
                });
                _push2(`<!--]--><div class="col-span-full"${_scopeId}>`);
                _push2(ssrRenderComponent(unref(_sfc_main$e), {
                  type: "button",
                  onClick: generateVariations
                }, {
                  default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                    if (_push3) {
                      _push3(`${ssrInterpolate(_ctx.$t("Generate Variations"))}`);
                    } else {
                      return [
                        createTextVNode(toDisplayString(_ctx.$t("Generate Variations")), 1)
                      ];
                    }
                  }),
                  _: 1
                }, _parent2, _scopeId));
                _push2(`</div><div class="col-span-full -mb-6"${_scopeId}><h4 class="text-lg font-bold"${_scopeId}>${ssrInterpolate(_ctx.$t("All Variations"))}</h4></div><div class="col-span-full overflow-x-auto border-l border-gray-200 dark:border-gray-700"${_scopeId}><div class="inline-block min-w-full align-middle dark:border-gray-700 -ml-px"${_scopeId}><table class="w-full fixed-actions border-separate border-spacing-0"${_scopeId}><thead${_scopeId}><tr class="bg-gray-50 dark:bg-gray-800"${_scopeId}><!--[-->`);
                ssrRenderList(unref(form).variants, (va, vi) => {
                  _push2(`<th class="border-l border-y border-gray-200 dark:border-gray-700"${_scopeId}>`);
                  if (va.options) {
                    _push2(`<span${_scopeId}>${ssrInterpolate(va.name)}</span>`);
                  } else {
                    _push2(`<span${_scopeId}>${ssrInterpolate(va.name)}</span>`);
                  }
                  _push2(`</th>`);
                });
                _push2(`<!--]--><th class="border-l border-y border-gray-200 dark:border-gray-700"${_scopeId}>${ssrInterpolate(_ctx.$t("Code"))}</th><th class="border-l border-y border-gray-200 dark:border-gray-700"${_scopeId}>${ssrInterpolate(_ctx.$t("Cost"))}</th><th class="border-l border-y border-gray-200 dark:border-gray-700"${_scopeId}>${ssrInterpolate(_ctx.$t("Price"))}</th><th class="border-l border-y border-gray-200 dark:border-gray-700"${_scopeId}>${ssrInterpolate(_ctx.$t("Rack"))}</th><th class="border-l border-y border-gray-200 dark:border-gray-700"${_scopeId}>${ssrInterpolate(_ctx.$t("Weight"))}</th><th class="border-l border-y border-gray-200 dark:border-gray-700"${_scopeId}>${ssrInterpolate(_ctx.$t("Dimensions"))}</th><th class="border border-gray-200 dark:border-gray-700"${_scopeId}></th></tr></thead><tbody${_scopeId}><!--[-->`);
                ssrRenderList(unref(form).variations, (variation, index) => {
                  _push2(`<tr class="hover:bg-primary-50 dark:hover:bg-primary-950"${_scopeId}>`);
                  if (unref(form).variations.length) {
                    _push2(`<!--[-->`);
                    ssrRenderList(unref(form).variants, (va, vi) => {
                      _push2(`<td class="border-b border-l border-gray-200 dark:border-gray-700"${_scopeId}>`);
                      if (variation.meta) {
                        _push2(`<div class="py-1 px-2"${_scopeId}>${ssrInterpolate(variation.meta[va.name])}</div>`);
                      } else {
                        _push2(`<!---->`);
                      }
                      _push2(`</td>`);
                    });
                    _push2(`<!--]-->`);
                  } else {
                    _push2(`<!---->`);
                  }
                  _push2(`<td class="border-b border-l border-gray-200 dark:border-gray-700"${_scopeId}><input${ssrRenderAttr("value", variation.code)} class="w-24 py-0 px-2 border-0 bg-transparent focus:ring-0"${_scopeId}></td><td class="border-b border-l border-gray-200 dark:border-gray-700"${_scopeId}><input type="number"${ssrRenderAttr("value", variation.cost)} class="w-24 py-0 pl-2 pr-0 border-0 bg-transparent focus:ring-0"${_scopeId}></td><td class="border-b border-l border-gray-200 dark:border-gray-700"${_scopeId}><input type="number"${ssrRenderAttr("value", variation.price)} class="w-24 py-0 pl-2 pr-0 border-0 bg-transparent focus:ring-0"${_scopeId}></td><td class="border-b border-l border-gray-200 dark:border-gray-700"${_scopeId}><input${ssrRenderAttr("value", variation.rack_location)} class="w-24 py-0 px-2 border-0 bg-transparent focus:ring-0"${_scopeId}></td><td class="border-b border-l border-gray-200 dark:border-gray-700"${_scopeId}><input type="number"${ssrRenderAttr("value", variation.weight)} class="w-24 py-0 pl-2 pr-0 border-0 bg-transparent focus:ring-0"${_scopeId}></td><td class="border-b border-l border-gray-200 dark:border-gray-700"${_scopeId}><input${ssrRenderAttr("value", variation.dimensions)}${ssrRenderAttr("placeholder", _ctx.$t("L x  W x H"))} class="w-24 py-0 px-2 border-0 bg-transparent focus:ring-0"${_scopeId}></td><td class="${ssrRenderClass([variation.highlight ? "bg-yellow-100" : "", "border-b border-l border-r border-gray-200 dark:border-gray-700 text-center"])}"${_scopeId}><button type="button" class="relative inline-flex items-center rounded-md -ml-3 p-1 text-mute hover:text-red-700 hover:bg-red-100 dark:hover:text-red-200 dark:hover:bg-red-950 focus:z-10"${_scopeId}><span class="sr-only"${_scopeId}>${ssrInterpolate(_ctx.$t("Remove"))}</span>`);
                  _push2(ssrRenderComponent(_component_Icon, {
                    name: "trash-o",
                    size: "size-5"
                  }, null, _parent2, _scopeId));
                  _push2(`</button></td></tr>`);
                });
                _push2(`<!--]--></tbody></table></div></div></div></div>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(`</div><div class="col-span-full flex flex-col gap-2 rounded-md p-4 border border-gray-200 dark:border-gray-700 overflow-x-auto"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$d), {
                id: "dont_track_stock",
                label: _ctx.$t("Do not track stock for this product"),
                modelValue: unref(form).dont_track_stock,
                "onUpdate:modelValue": ($event) => unref(form).dont_track_stock = $event
              }, null, _parent2, _scopeId));
              if (!unref(form).dont_track_stock && !unref(form).has_variants) {
                _push2(`<!--[-->`);
                _push2(ssrRenderComponent(unref(_sfc_main$d), {
                  id: "set_stock",
                  label: _ctx.$t("Set different price, quantity & taxes per stores"),
                  modelValue: unref(form).set_stock,
                  "onUpdate:modelValue": ($event) => unref(form).set_stock = $event
                }, null, _parent2, _scopeId));
                if (unref(form).set_stock) {
                  _push2(`<div class="col-span-full flex flex-col gap-8 mt-8"${_scopeId}><!--[-->`);
                  ssrRenderList(__props.stores, (store, index) => {
                    _push2(`<div class="relative grid grid-cols-6 gap-6 px-6 pt-10 pb-6 border border-gray-200 dark:border-gray-700 rounded-md"${_scopeId}><div class="absolute -top-4 left-4 bg-gray-100 dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-md py-0.5 px-3 font-extrabold text-lg"${_scopeId}>${ssrInterpolate(store.name)}</div><div class="col-span-6 sm:col-span-2"${_scopeId}>`);
                    _push2(ssrRenderComponent(unref(_sfc_main$6), {
                      type: "number",
                      label: _ctx.$t("Selling Price"),
                      modelValue: unref(form).stores[index].price,
                      "onUpdate:modelValue": ($event) => unref(form).stores[index].price = $event,
                      error: _ctx.$page.props.errors["stores." + index + ".price"]
                    }, null, _parent2, _scopeId));
                    _push2(`</div>`);
                    if (unref(form).type == "Standard") {
                      _push2(`<div class="col-span-6 sm:col-span-2"${_scopeId}>`);
                      _push2(ssrRenderComponent(unref(_sfc_main$6), {
                        type: "number",
                        label: _ctx.$t("Quantity"),
                        modelValue: unref(form).stores[index].quantity,
                        "onUpdate:modelValue": ($event) => unref(form).stores[index].quantity = $event,
                        error: _ctx.$page.props.errors["stores." + index + ".quantity"]
                      }, null, _parent2, _scopeId));
                      _push2(`</div>`);
                    } else {
                      _push2(`<!---->`);
                    }
                    if (unref(form).type == "Standard") {
                      _push2(`<div class="col-span-6 sm:col-span-2"${_scopeId}>`);
                      _push2(ssrRenderComponent(unref(_sfc_main$6), {
                        type: "number",
                        label: _ctx.$t("Alert (Low Stock) Quantity"),
                        modelValue: unref(form).stores[index].alert_quantity,
                        "onUpdate:modelValue": ($event) => unref(form).stores[index].alert_quantity = $event,
                        error: _ctx.$page.props.errors["stores." + index + ".alert_quantity"]
                      }, null, _parent2, _scopeId));
                      _push2(`</div>`);
                    } else {
                      _push2(`<!---->`);
                    }
                    _push2(`<div class="col-span-full"${_scopeId}>`);
                    _push2(ssrRenderComponent(unref(_sfc_main$5), {
                      id: "taxes",
                      json: true,
                      valueKey: "id",
                      labelKey: "name",
                      multiple: true,
                      searchable: false,
                      label: _ctx.$t("Taxes"),
                      suggestions: __props.taxes,
                      modelValue: unref(form).stores[index].taxes,
                      "onUpdate:modelValue": ($event) => unref(form).stores[index].taxes = $event,
                      error: _ctx.$page.props.errors["stores." + index + ".taxes"]
                    }, null, _parent2, _scopeId));
                    _push2(`</div></div>`);
                  });
                  _push2(`<!--]--></div>`);
                } else {
                  _push2(`<!---->`);
                }
                _push2(`<!--]-->`);
              } else {
                _push2(`<!---->`);
              }
              _push2(`</div>`);
              if (!unref(form).dont_track_stock) {
                _push2(`<div class="col-span-full flex flex-col gap-2 rounded-md p-4 border border-gray-200 dark:border-gray-700 overflow-x-auto"${_scopeId}>`);
                _push2(ssrRenderComponent(unref(_sfc_main$d), {
                  id: "has_serials",
                  label: _ctx.$t("This product has serial numbers"),
                  modelValue: unref(form).has_serials,
                  "onUpdate:modelValue": ($event) => unref(form).has_serials = $event
                }, null, _parent2, _scopeId));
                if (unref(form).has_serials) {
                  _push2(`<div class="col-span-full"${_scopeId}><div class="grid grid-cols-6 gap-6"${_scopeId}><div class="col-span-full mt-6 flex items-center justify-between"${_scopeId}><h4 class="text-lg font-bold"${_scopeId}>${ssrInterpolate(_ctx.$t("Serial Numbers"))}</h4><button type="button" class="relative -ml-px inline-flex items-center rounded-md bg-white dark:bg-gray-900 px-2 py-2 text-mute ring-1 ring-inset ring-gray-300 dark:ring-gray-700 hover:bg-gray-50 dark:hover:bg-gray-950 focus:z-10"${_scopeId}>`);
                  _push2(ssrRenderComponent(_component_Icon, {
                    name: "add",
                    size: "size-5 sm:mr-2"
                  }, null, _parent2, _scopeId));
                  _push2(`<span class="hidden sm:block"${_scopeId}>${ssrInterpolate(_ctx.$t("Add {x}", { x: _ctx.$t("Serial") }))}</span></button></div><!--[-->`);
                  ssrRenderList(unref(form).serials, (serial, index) => {
                    _push2(`<!--[--><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
                    _push2(ssrRenderComponent(unref(_sfc_main$6), {
                      id: "serial_" + index,
                      modelValue: serial.number,
                      "onUpdate:modelValue": ($event) => serial.number = $event,
                      label: _ctx.$t("Serial Number"),
                      onKeyup: (e) => focusNextSerialInput(e, index)
                    }, null, _parent2, _scopeId));
                    _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
                    _push2(ssrRenderComponent(unref(_sfc_main$6), {
                      modelValue: serial.till,
                      "onUpdate:modelValue": ($event) => serial.till = $event,
                      label: _ctx.$t("Till")
                    }, null, _parent2, _scopeId));
                    _push2(`</div>`);
                    if (serial.number || serial.till && serial.number < serial.till) {
                      _push2(`<div class="col-span-full -mt-3"${_scopeId}><strong${_scopeId}>${ssrInterpolate(countSerials(serial.number, serial.till))}</strong> ${ssrInterpolate(_ctx.$t(countSerials(serial.number, serial.till) == 1 ? "Serial Number" : "Serial Numbers"))}</div>`);
                    } else {
                      _push2(`<!---->`);
                    }
                    _push2(`<!--]-->`);
                  });
                  _push2(`<!--]--></div></div>`);
                } else {
                  _push2(`<!---->`);
                }
                _push2(`</div>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(`<!--]-->`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<div class="col-span-full flex flex-col gap-6 p-6 mb-6 rounded border border-gray-200 dark:border-gray-700"${_scopeId}><div class="col-span-full -mt-6 -mb-3"${_scopeId}><h4 class="text-lg font-bold mt-6 mb-3"${_scopeId}>${ssrInterpolate(_ctx.$t("SEO Fields"))}</h4></div><div${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$6), {
              id: "title",
              label: _ctx.$t("Title"),
              modelValue: unref(form).title,
              "onUpdate:modelValue": ($event) => unref(form).title = $event,
              error: unref(form).errors.title
            }, null, _parent2, _scopeId));
            _push2(`</div><div${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$c), {
              id: "description",
              modelValue: unref(form).description,
              "onUpdate:modelValue": ($event) => unref(form).description = $event,
              error: unref(form).errors.description,
              label: _ctx.$t("Description")
            }, null, _parent2, _scopeId));
            _push2(`</div><div${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$c), {
              id: "keywords",
              modelValue: unref(form).keywords,
              "onUpdate:modelValue": ($event) => unref(form).keywords = $event,
              error: unref(form).errors.keywords,
              label: _ctx.$t("Keywords")
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="flex gap-x-12 gap-y-4"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$d), {
              id: "noindex",
              label: _ctx.$t("Noindex"),
              modelValue: unref(form).noindex,
              "onUpdate:modelValue": ($event) => unref(form).noindex = $event
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$d), {
              id: "nofollow",
              label: _ctx.$t("Nofollow"),
              modelValue: unref(form).nofollow,
              "onUpdate:modelValue": ($event) => unref(form).nofollow = $event
            }, null, _parent2, _scopeId));
            _push2(`</div></div>`);
          } else {
            return [
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$5), {
                  id: "type",
                  json: true,
                  label: _ctx.$t("Type"),
                  modelValue: unref(form).type,
                  "onUpdate:modelValue": ($event) => unref(form).type = $event,
                  error: unref(form).errors.type,
                  suggestions: [
                    { value: "Standard", label: _ctx.$t("Standard") },
                    { value: "Service", label: _ctx.$t("Service") },
                    { value: "Digital", label: _ctx.$t("Digital") },
                    { value: "Combo", label: _ctx.$t("Combo") },
                    { value: "Recipe", label: _ctx.$t("Recipe") }
                  ]
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error", "suggestions"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }),
              unref(form).type == "Combo" ? (openBlock(), createBlock("div", {
                key: 0,
                class: "col-span-full p-6 mb-6 rounded border border-gray-200 dark:border-gray-700"
              }, [
                createVNode("div", { class: "relative" }, [
                  createVNode(unref(_sfc_main$6), {
                    id: "product-search",
                    label: "",
                    modelValue: search.value,
                    "onUpdate:modelValue": ($event) => search.value = $event,
                    placeholder: _ctx.$t("Scan barcode or type to search")
                  }, null, 8, ["modelValue", "onUpdate:modelValue", "placeholder"]),
                  search.value && result.value && result.value.length ? (openBlock(), createBlock("div", {
                    key: 0,
                    class: "absolute z-10 top-full left-0 right-0 ring-1 bg-white dark:bg-gray-700 rounded-md dark:ring-gray-700 mt-2 py-1"
                  }, [
                    (openBlock(true), createBlock(Fragment, null, renderList(result.value, (p) => {
                      return openBlock(), createBlock("button", {
                        key: p.id,
                        type: "button",
                        onClick: ($event) => addProduct(p),
                        class: "w-full text-left py-1.5 px-4 hover:bg-gray-100 dark:hover:bg-gray-900"
                      }, toDisplayString(p.name), 9, ["onClick"]);
                    }), 128))
                  ])) : createCommentVNode("", true)
                ]),
                unref(form).products && unref(form).products.length ? (openBlock(), createBlock("div", { key: 0 }, [
                  createVNode("h4", { class: "text-lg font-bold mt-6 mb-3" }, toDisplayString(_ctx.$t("Combo Products")), 1),
                  createVNode("table", { class: "w-full divide-y dark:divide-gray-700" }, [
                    (openBlock(true), createBlock(Fragment, null, renderList(unref(form).products, (product, index) => {
                      var _a3;
                      return openBlock(), createBlock("tr", {
                        key: product.code
                      }, [
                        createVNode("td", { class: "w-8 py-2" }, toDisplayString(index + 1) + ".", 1),
                        createVNode("td", { class: "p-2" }, toDisplayString(product.name), 1),
                        createVNode("td", { class: "w-36 py-2" }, [
                          createVNode(unref(_sfc_main$6), {
                            min: 0,
                            "del-on": 0,
                            type: "number",
                            modelValue: product.quantity,
                            "onUpdate:modelValue": ($event) => product.quantity = $event,
                            onRemove: ($event) => removeItem(product),
                            onChange: ($event) => quantityChanged(),
                            max: product.selected_store && product.selected_store[0] ? (_a3 = product.selected_store[0].pivot) == null ? void 0 : _a3.quantity : null
                          }, null, 8, ["modelValue", "onUpdate:modelValue", "onRemove", "onChange", "max"])
                        ])
                      ]);
                    }), 128))
                  ])
                ])) : createCommentVNode("", true)
              ])) : createCommentVNode("", true),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$6), {
                  id: "name",
                  label: _ctx.$t("Name"),
                  modelValue: unref(form).name,
                  "onUpdate:modelValue": ($event) => unref(form).name = $event,
                  error: unref(form).errors.name
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$6), {
                  id: "secondary_name",
                  label: _ctx.$t("Secondary Name"),
                  modelValue: unref(form).secondary_name,
                  "onUpdate:modelValue": ($event) => unref(form).secondary_name = $event,
                  error: unref(form).errors.secondary_name
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$6), {
                  id: "code",
                  label: _ctx.$t("Code") + " (" + _ctx.$t("barcode") + ")",
                  modelValue: unref(form).code,
                  "onUpdate:modelValue": ($event) => unref(form).code = $event,
                  error: unref(form).errors.code
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$5), {
                  id: "symbology",
                  label: _ctx.$t("Symbology"),
                  modelValue: unref(form).symbology,
                  "onUpdate:modelValue": ($event) => unref(form).symbology = $event,
                  error: unref(form).errors.symbology,
                  suggestions: ["CODE128", "CODE39", "EAN8", "EAN13", "UPC"]
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$5), {
                  json: true,
                  valueKey: "id",
                  labelKey: "name",
                  id: "category_id",
                  label: _ctx.$t("Category"),
                  suggestions: __props.categories,
                  modelValue: unref(form).category_id,
                  "onUpdate:modelValue": ($event) => unref(form).category_id = $event,
                  onChange: (e) => category.value = e,
                  error: unref(form).errors.category_id
                }, null, 8, ["label", "suggestions", "modelValue", "onUpdate:modelValue", "onChange", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$5), {
                  json: true,
                  valueKey: "id",
                  labelKey: "name",
                  id: "subcategory_id",
                  label: _ctx.$t("Subcategory"),
                  modelValue: unref(form).subcategory_id,
                  "onUpdate:modelValue": ($event) => unref(form).subcategory_id = $event,
                  error: unref(form).errors.subcategory_id,
                  suggestions: ((_h2 = category.value) == null ? void 0 : _h2.children) || []
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error", "suggestions"])
              ]),
              unref(form).type == "Standard" ? (openBlock(), createBlock("div", {
                key: 1,
                class: "col-span-6 sm:col-span-3"
              }, [
                createVNode(unref(_sfc_main$5), {
                  json: true,
                  id: "brand_id",
                  valueKey: "id",
                  labelKey: "name",
                  clearable: true,
                  label: _ctx.$t("Brand"),
                  suggestions: __props.brands,
                  modelValue: unref(form).brand_id,
                  "onUpdate:modelValue": ($event) => unref(form).brand_id = $event,
                  error: unref(form).errors.brand_id
                }, null, 8, ["label", "suggestions", "modelValue", "onUpdate:modelValue", "error"])
              ])) : createCommentVNode("", true),
              unref(form).type == "Standard" ? (openBlock(), createBlock(Fragment, { key: 2 }, [
                createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                  createVNode(unref(_sfc_main$5), {
                    json: true,
                    id: "unit_id",
                    valueKey: "id",
                    labelKey: "name",
                    clearable: true,
                    label: _ctx.$t("Unit"),
                    suggestions: __props.units,
                    modelValue: unref(form).unit_id,
                    "onUpdate:modelValue": ($event) => unref(form).unit_id = $event,
                    onChange: (e) => {
                      var _a3;
                      unit.value = e;
                      unref(form).unit_prices = (_a3 = unit.value.subunits) == null ? void 0 : _a3.reduce((a, i) => {
                        a[i.id] = { cost: null, price: null };
                        return a;
                      }, {});
                    },
                    error: unref(form).errors.unit_id
                  }, null, 8, ["label", "suggestions", "modelValue", "onUpdate:modelValue", "onChange", "error"])
                ]),
                ((_i2 = unit.value) == null ? void 0 : _i2.subunits) && unit.value.subunits.length ? (openBlock(), createBlock(Fragment, { key: 0 }, [
                  createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                    createVNode(unref(_sfc_main$5), {
                      json: true,
                      valueKey: "id",
                      labelKey: "name",
                      clearable: true,
                      id: "sale_unit_id",
                      label: _ctx.$t("Sale Unit"),
                      suggestions: unit.value.subunits,
                      modelValue: unref(form).sale_unit_id,
                      "onUpdate:modelValue": ($event) => unref(form).sale_unit_id = $event,
                      error: unref(form).errors.sale_unit_id
                    }, null, 8, ["label", "suggestions", "modelValue", "onUpdate:modelValue", "error"])
                  ]),
                  createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                    createVNode(unref(_sfc_main$5), {
                      json: true,
                      valueKey: "id",
                      labelKey: "name",
                      clearable: true,
                      id: "purchase_unit_id",
                      label: _ctx.$t("Purchase Unit"),
                      suggestions: unit.value.subunits,
                      modelValue: unref(form).purchase_unit_id,
                      "onUpdate:modelValue": ($event) => unref(form).purchase_unit_id = $event,
                      error: unref(form).errors.purchase_unit_id
                    }, null, 8, ["label", "suggestions", "modelValue", "onUpdate:modelValue", "error"])
                  ])
                ], 64)) : createCommentVNode("", true)
              ], 64)) : createCommentVNode("", true),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$6), {
                  id: "cost",
                  type: "number",
                  modelValue: unref(form).cost,
                  "onUpdate:modelValue": ($event) => unref(form).cost = $event,
                  error: unref(form).errors.cost,
                  label: _ctx.$t("Purchase Cost"),
                  readonly: ["Combo", "Recipe"].includes(unref(form).type)
                }, null, 8, ["modelValue", "onUpdate:modelValue", "error", "label", "readonly"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$6), {
                  id: "price",
                  type: "number",
                  label: _ctx.$t("Selling Price"),
                  modelValue: unref(form).price,
                  "onUpdate:modelValue": ($event) => unref(form).price = $event,
                  error: unref(form).errors.price
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$6), {
                  id: "min_price",
                  type: "number",
                  label: _ctx.$t("Minimum Price"),
                  modelValue: unref(form).min_price,
                  "onUpdate:modelValue": ($event) => unref(form).min_price = $event,
                  error: unref(form).errors.min_price
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$6), {
                  id: "max_price",
                  type: "number",
                  label: _ctx.$t("Maximum Price"),
                  modelValue: unref(form).max_price,
                  "onUpdate:modelValue": ($event) => unref(form).max_price = $event,
                  error: unref(form).errors.max_price
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              !["Combo", "Recipe"].includes(unref(form).type) && unref(form).unit_prices && ((_k2 = (_j2 = unit.value) == null ? void 0 : _j2.subunits) == null ? void 0 : _k2.length) ? (openBlock(true), createBlock(Fragment, { key: 3 }, renderList(unit.value.subunits, (subunit) => {
                return openBlock(), createBlock("div", {
                  key: subunit.id,
                  class: "col-span-full relative grid grid-cols-6 gap-6 rounded-md mt-3 pt-8 pb-4 px-4 border border-gray-200 dark:border-gray-700"
                }, [
                  createVNode("div", { class: "absolute -top-4 left-4 bg-gray-100 dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-md py-0.5 px-3 font-extrabold text-lg flex items-center gap-x-4" }, toDisplayString(subunit.name), 1),
                  createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                    createVNode(unref(_sfc_main$6), {
                      id: "cost",
                      type: "number",
                      label: _ctx.$t("Purchase Cost"),
                      modelValue: unref(form).unit_prices[subunit.id].cost,
                      "onUpdate:modelValue": ($event) => unref(form).unit_prices[subunit.id].cost = $event,
                      error: unref(form).errors.unit_prices ? unref(form).errors.unit_prices[subunit.id].cost : null
                    }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
                  ]),
                  createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                    createVNode(unref(_sfc_main$6), {
                      id: "price",
                      type: "number",
                      label: _ctx.$t("Selling Price"),
                      modelValue: unref(form).unit_prices[subunit.id].price,
                      "onUpdate:modelValue": ($event) => unref(form).unit_prices[subunit.id].price = $event,
                      error: unref(form).errors.unit_prices ? unref(form).errors.unit_prices[subunit.id].price : null
                    }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
                  ])
                ]);
              }), 128)) : createCommentVNode("", true),
              createVNode("div", { class: "col-span-full" }, [
                createVNode(unref(_sfc_main$5), {
                  id: "taxes",
                  json: true,
                  valueKey: "id",
                  labelKey: "name",
                  multiple: true,
                  searchable: false,
                  label: _ctx.$t("Taxes"),
                  suggestions: __props.taxes,
                  modelValue: unref(form).taxes,
                  "onUpdate:modelValue": ($event) => unref(form).taxes = $event,
                  error: _ctx.$page.props.errors.taxes
                }, null, 8, ["label", "suggestions", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$6), {
                  id: "max_discount",
                  type: "number",
                  label: _ctx.$t("Maximum Discount"),
                  modelValue: unref(form).max_discount,
                  "onUpdate:modelValue": ($event) => unref(form).max_discount = $event,
                  error: unref(form).errors.max_discount
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              ["Standard", "Combo", "Recipe"].includes(unref(form).type) ? (openBlock(), createBlock("div", {
                key: 4,
                class: "col-span-6 sm:col-span-3"
              }, [
                createVNode(unref(_sfc_main$6), {
                  id: "rack_location",
                  label: _ctx.$t("Rack Location"),
                  modelValue: unref(form).rack_location,
                  "onUpdate:modelValue": ($event) => unref(form).rack_location = $event,
                  error: unref(form).errors.rack_location
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ])) : createCommentVNode("", true),
              ["Standard", "Combo", "Recipe"].includes(unref(form).type) ? (openBlock(), createBlock("div", {
                key: 5,
                class: "col-span-6 sm:col-span-3"
              }, [
                createVNode(unref(_sfc_main$6), {
                  id: "weight",
                  type: "number",
                  label: _ctx.$t("Weight"),
                  modelValue: unref(form).weight,
                  "onUpdate:modelValue": ($event) => unref(form).weight = $event,
                  error: unref(form).errors.weight
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ])) : createCommentVNode("", true),
              ["Standard", "Combo", "Recipe"].includes(unref(form).type) ? (openBlock(), createBlock("div", {
                key: 6,
                class: "col-span-6 sm:col-span-3"
              }, [
                createVNode(unref(_sfc_main$6), {
                  id: "dimensions",
                  label: _ctx.$t("Dimensions"),
                  modelValue: unref(form).dimensions,
                  "onUpdate:modelValue": ($event) => unref(form).dimensions = $event,
                  error: unref(form).errors.dimensions
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ])) : createCommentVNode("", true),
              ["Standard", "Combo", "Recipe"].includes(unref(form).type) ? (openBlock(), createBlock("div", {
                key: 7,
                class: "col-span-6 sm:col-span-3"
              }, [
                createVNode(unref(_sfc_main$6), {
                  id: "hsn_number",
                  label: _ctx.$t("HSN Number"),
                  modelValue: unref(form).hsn_number,
                  "onUpdate:modelValue": ($event) => unref(form).hsn_number = $event,
                  error: unref(form).errors.hsn_number
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ])) : createCommentVNode("", true),
              unref(form).type == "Service" ? (openBlock(), createBlock("div", {
                key: 8,
                class: "col-span-6 sm:col-span-3"
              }, [
                createVNode(unref(_sfc_main$6), {
                  id: "sac_number",
                  label: _ctx.$t("SAC Number"),
                  modelValue: unref(form).sac_number,
                  "onUpdate:modelValue": ($event) => unref(form).sac_number = $event,
                  error: unref(form).errors.sac_number
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ])) : createCommentVNode("", true),
              unref(form).type == "Standard" ? (openBlock(), createBlock("div", {
                key: 9,
                class: "col-span-6 sm:col-span-3"
              }, [
                createVNode(unref(_sfc_main$5), {
                  json: true,
                  valueKey: "id",
                  id: "supplier_id",
                  labelKey: "company",
                  label: _ctx.$t("Supplier"),
                  modelValue: unref(form).supplier_id,
                  "onUpdate:modelValue": ($event) => unref(form).supplier_id = $event,
                  error: unref(form).errors.supplier_id,
                  suggestions: unref(T)("search.suppliers")
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error", "suggestions"])
              ])) : createCommentVNode("", true),
              unref(form).type == "Standard" ? (openBlock(), createBlock("div", {
                key: 10,
                class: "col-span-6 sm:col-span-3"
              }, [
                createVNode(unref(_sfc_main$6), {
                  id: "supplier_part_id",
                  label: _ctx.$t("Supplier Part Id"),
                  modelValue: unref(form).supplier_part_id,
                  "onUpdate:modelValue": ($event) => unref(form).supplier_part_id = $event,
                  error: unref(form).errors.supplier_part_id
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ])) : createCommentVNode("", true),
              unref(form).type == "Standard" ? (openBlock(), createBlock("div", {
                key: 11,
                class: "col-span-6 sm:col-span-3"
              }, [
                createVNode(unref(_sfc_main$6), {
                  type: "number",
                  id: "alert_quantity",
                  label: _ctx.$t("Alert (Low Stock) Quantity"),
                  modelValue: unref(form).alert_quantity,
                  "onUpdate:modelValue": ($event) => unref(form).alert_quantity = $event,
                  error: unref(form).errors.alert_quantity
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ])) : createCommentVNode("", true),
              createVNode("div", { class: "col-span-full" }, [
                createVNode(unref(_sfc_main$7), {
                  custom_fields: _ctx.custom_fields,
                  errors: unref(form).errors,
                  extra_attributes: unref(form).extra_attributes
                }, null, 8, ["custom_fields", "errors", "extra_attributes"])
              ]),
              unref(form).type == "Digital" ? (openBlock(), createBlock("div", {
                key: 12,
                class: "col-span-full"
              }, [
                createVNode(unref(_sfc_main$8), {
                  id: "file",
                  multiple: "",
                  label: _ctx.$t("File"),
                  modelValue: unref(form).file,
                  "onUpdate:modelValue": ($event) => unref(form).file = $event,
                  error: unref(form).errors.file
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ])) : createCommentVNode("", true),
              createVNode("div", { class: "col-span-full" }, [
                createVNode("input", {
                  id: "photo",
                  ref_key: "photoInput",
                  ref: photoInput,
                  type: "file",
                  class: "hidden",
                  onChange: () => updatePhotoPreview()
                }, null, 40, ["onChange"]),
                createVNode(unref(_sfc_main$9), {
                  for: "photo",
                  value: _ctx.$t("Photo")
                }, null, 8, ["value"]),
                withDirectives(createVNode("div", { class: "mt-2 p-1 rounded-md" }, [
                  createVNode("img", {
                    alt: _ctx.$t("Photo"),
                    src: (_l2 = __props.current) == null ? void 0 : _l2.photo,
                    class: "rounded-md w-full h-full max-w-64 min-h-20 max-h-40 object-contain"
                  }, null, 8, ["alt", "src"])
                ], 512), [
                  [vShow, !photoPreview.value && ((_m2 = __props.current) == null ? void 0 : _m2.photo)]
                ]),
                withDirectives(createVNode("div", { class: "mt-2 p-1 rounded-md" }, [
                  createVNode("span", {
                    class: "block rounded-md w-full h-full max-w-64 min-h-24 max-h-40 bg-no-repeat bg-contain",
                    style: "background-image: url('" + photoPreview.value + "');"
                  }, null, 4)
                ], 512), [
                  [vShow, photoPreview.value]
                ]),
                createVNode(unref(_sfc_main$a), {
                  class: "mt-2 me-2",
                  type: "button",
                  onClick: withModifiers(() => selectNewPhoto(), ["prevent"])
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.$t("Select A New Photo")), 1)
                  ]),
                  _: 1
                }, 8, ["onClick"]),
                ((_n2 = __props.current) == null ? void 0 : _n2.photo) ? (openBlock(), createBlock(unref(_sfc_main$a), {
                  key: 0,
                  type: "button",
                  onClick: withModifiers(() => deletePhoto(), ["prevent"]),
                  class: "mt-2 p-1 rounded-md bg-gray-50 flex items-center justify-center"
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.$t("Remove Photo")), 1)
                  ]),
                  _: 1
                }, 8, ["onClick"])) : createCommentVNode("", true),
                createVNode(unref(_sfc_main$b), {
                  message: unref(form).errors.photo,
                  class: "mt-2"
                }, null, 8, ["message"])
              ]),
              createVNode("div", { class: "col-span-full" }, [
                createVNode(unref(_sfc_main$8), {
                  id: "photos",
                  multiple: "",
                  label: _ctx.$t("Photos"),
                  modelValue: unref(form).photos,
                  "onUpdate:modelValue": ($event) => unref(form).photos = $event,
                  error: unref(form).errors.photos
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              createVNode("div", { class: "col-span-full" }, [
                createVNode(unref(_sfc_main$6), {
                  id: "video_url",
                  label: _ctx.$t("Video URL"),
                  modelValue: unref(form).video_url,
                  "onUpdate:modelValue": ($event) => unref(form).video_url = $event,
                  error: unref(form).errors.video_url
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              createVNode("div", { class: "col-span-full" }, [
                createVNode(unref(_sfc_main$c), {
                  id: "details",
                  rows: "5",
                  modelValue: unref(form).details,
                  "onUpdate:modelValue": ($event) => unref(form).details = $event,
                  error: unref(form).errors.details,
                  label: _ctx.$t("Product Details")
                }, null, 8, ["modelValue", "onUpdate:modelValue", "error", "label"])
              ]),
              createVNode("div", { class: "col-span-full flex flex-col gap-2 rounded-md p-4 border border-gray-200 dark:border-gray-700 overflow-x-auto" }, [
                createVNode(unref(_sfc_main$d), {
                  id: "featured",
                  label: _ctx.$t("Featured"),
                  modelValue: unref(form).featured,
                  "onUpdate:modelValue": ($event) => unref(form).featured = $event
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue"]),
                createVNode(unref(_sfc_main$d), {
                  id: "hide_in_pos",
                  label: _ctx.$t("Hide in POS"),
                  modelValue: unref(form).hide_in_pos,
                  "onUpdate:modelValue": ($event) => unref(form).hide_in_pos = $event
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue"]),
                createVNode(unref(_sfc_main$d), {
                  id: "hide_in_shop",
                  label: _ctx.$t("Hide in Shop"),
                  modelValue: unref(form).hide_in_shop,
                  "onUpdate:modelValue": ($event) => unref(form).hide_in_shop = $event
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue"]),
                createVNode(unref(_sfc_main$d), {
                  id: "tax_included",
                  label: _ctx.$t("Tax is included in price"),
                  modelValue: unref(form).tax_included,
                  "onUpdate:modelValue": ($event) => unref(form).tax_included = $event
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue"]),
                createVNode(unref(_sfc_main$d), {
                  id: "can_edit_price",
                  label: _ctx.$t("Allow to change price while selling"),
                  modelValue: unref(form).can_edit_price,
                  "onUpdate:modelValue": ($event) => unref(form).can_edit_price = $event
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue"]),
                createVNode(unref(_sfc_main$d), {
                  id: "has_expiry_date",
                  modelValue: unref(form).has_expiry_date,
                  "onUpdate:modelValue": ($event) => unref(form).has_expiry_date = $event,
                  label: _ctx.$t("This product has expiry date"),
                  text: "(" + _ctx.$t("show expiry date input while purchasing") + ")"
                }, null, 8, ["modelValue", "onUpdate:modelValue", "label", "text"])
              ]),
              unref(form).type == "Standard" ? (openBlock(), createBlock(Fragment, { key: 13 }, [
                createVNode("div", { class: "col-span-full flex flex-col gap-2 rounded-md p-4 border border-gray-200 dark:border-gray-700 overflow-x-auto" }, [
                  createVNode(unref(_sfc_main$d), {
                    id: "has_variants",
                    label: _ctx.$t("This product has variants"),
                    modelValue: unref(form).has_variants,
                    "onUpdate:modelValue": ($event) => unref(form).has_variants = $event
                  }, null, 8, ["label", "modelValue", "onUpdate:modelValue"]),
                  unref(form).has_variants ? (openBlock(), createBlock("div", {
                    key: 0,
                    class: "col-span-full"
                  }, [
                    createVNode("span", { class: "sr-only" }, toDisplayString(_ctx.$t("Color")) + toDisplayString(_ctx.$t("color")) + toDisplayString(_ctx.$t("Size")) + toDisplayString(_ctx.$t("size")), 1),
                    createVNode("div", { class: "grid grid-cols-6 gap-6" }, [
                      createVNode("div", { class: "col-span-full mt-6 flex items-center justify-between" }, [
                        createVNode("h4", { class: "text-lg font-bold" }, toDisplayString(_ctx.$t("Variants")), 1),
                        createVNode("button", {
                          type: "button",
                          onClick: () => unref(form).variants.length < 3 ? unref(form).variants.push({ name: "", options: [""] }) : unref(notify)({ group: "main", type: "error", title: _ctx.$t("You have already added maximum number of variants.") }),
                          class: "relative -ml-px inline-flex items-center rounded-md bg-white dark:bg-gray-900 px-2 py-2 text-mute ring-1 ring-inset ring-gray-300 dark:ring-gray-700 hover:bg-gray-50 dark:hover:bg-gray-950 focus:z-10"
                        }, [
                          createVNode(_component_Icon, {
                            name: "add",
                            size: "size-5 sm:mr-2"
                          }),
                          createVNode("span", { class: "hidden sm:block" }, toDisplayString(_ctx.$t("Add {x}", { x: _ctx.$t("Variant") })), 1)
                        ], 8, ["onClick"])
                      ]),
                      (openBlock(true), createBlock(Fragment, null, renderList(unref(form).variants, (variant, index) => {
                        return openBlock(), createBlock("div", {
                          key: "variant_" + index,
                          class: "relative col-span-full grid grid-cols-6 gap-6 rounded-md mt-2 px-6 pt-10 pb-6 border border-gray-200 dark:border-gray-700"
                        }, [
                          createVNode("div", { class: "absolute -top-4 left-4 bg-gray-100 dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-md py-0.5 px-3 font-extrabold text-lg flex items-center gap-x-4" }, [
                            createTextVNode(toDisplayString(_ctx.$t("Variant {x}", { x: index + 1 })) + " ", 1),
                            createVNode("button", {
                              type: "button",
                              onClick: () => unref(form).variants.splice(index, 1),
                              class: "relative inline-flex items-center rounded-md -mr-2.5 p-1 text-mute hover:text-red-700 hover:bg-red-100 dark:hover:text-red-200 dark:hover:bg-red-950 focus:z-10"
                            }, [
                              createVNode("span", { class: "sr-only" }, toDisplayString(_ctx.$t("Remove")), 1),
                              createVNode(_component_Icon, {
                                name: "trash-o",
                                size: "size-5"
                              })
                            ], 8, ["onClick"])
                          ]),
                          createVNode("div", { class: "col-span-full flex items-end gap-6" }, [
                            createVNode(_component_fiv, { class: "flex-1" }, {
                              default: withCtx(() => [
                                createVNode(unref(_sfc_main$6), {
                                  label: _ctx.$t("Name"),
                                  modelValue: variant.name,
                                  "onUpdate:modelValue": ($event) => variant.name = $event
                                }, null, 8, ["label", "modelValue", "onUpdate:modelValue"])
                              ]),
                              _: 2
                            }, 1024),
                            createVNode("button", {
                              type: "button",
                              onClick: () => unref(form).variants[index].options.push(""),
                              class: "relative inline-flex items-center rounded-md bg-white dark:bg-gray-900 p-2.5 text-mute ring-1 ring-inset ring-gray-300 dark:ring-gray-700 hover:bg-gray-50 dark:hover:bg-gray-950 focus:z-10"
                            }, [
                              createVNode(_component_Icon, {
                                name: "add",
                                size: "size-5 sm:mr-2"
                              }),
                              createVNode("span", { class: "hidden sm:block" }, toDisplayString(_ctx.$t("Add {x}", { x: _ctx.$t("Option") })), 1)
                            ], 8, ["onClick"])
                          ]),
                          (openBlock(true), createBlock(Fragment, null, renderList(unref(form).variants[index].options, (option, oi) => {
                            return openBlock(), createBlock("div", {
                              key: "oc_" + index + "_" + oi,
                              class: "col-span-6 sm:col-span-3"
                            }, [
                              createVNode(unref(_sfc_main$6), {
                                id: "option_" + index + "_" + oi,
                                label: _ctx.$t("Option {x}", { x: oi + 1 }),
                                modelValue: unref(form).variants[index].options[oi],
                                "onUpdate:modelValue": ($event) => unref(form).variants[index].options[oi] = $event,
                                onKeyup: withKeys((e) => focusOnNextOption(e, oi, index), ["enter"])
                              }, null, 8, ["id", "label", "modelValue", "onUpdate:modelValue", "onKeyup"])
                            ]);
                          }), 128))
                        ]);
                      }), 128)),
                      createVNode("div", { class: "col-span-full" }, [
                        createVNode(unref(_sfc_main$e), {
                          type: "button",
                          onClick: generateVariations
                        }, {
                          default: withCtx(() => [
                            createTextVNode(toDisplayString(_ctx.$t("Generate Variations")), 1)
                          ]),
                          _: 1
                        })
                      ]),
                      createVNode("div", { class: "col-span-full -mb-6" }, [
                        createVNode("h4", { class: "text-lg font-bold" }, toDisplayString(_ctx.$t("All Variations")), 1)
                      ]),
                      createVNode("div", { class: "col-span-full overflow-x-auto border-l border-gray-200 dark:border-gray-700" }, [
                        createVNode("div", { class: "inline-block min-w-full align-middle dark:border-gray-700 -ml-px" }, [
                          createVNode("table", { class: "w-full fixed-actions border-separate border-spacing-0" }, [
                            createVNode("thead", null, [
                              createVNode("tr", { class: "bg-gray-50 dark:bg-gray-800" }, [
                                (openBlock(true), createBlock(Fragment, null, renderList(unref(form).variants, (va, vi) => {
                                  return openBlock(), createBlock("th", {
                                    class: "border-l border-y border-gray-200 dark:border-gray-700",
                                    key: "option" + vi
                                  }, [
                                    va.options ? (openBlock(), createBlock("span", { key: 0 }, toDisplayString(va.name), 1)) : (openBlock(), createBlock("span", { key: 1 }, toDisplayString(va.name), 1))
                                  ]);
                                }), 128)),
                                createVNode("th", { class: "border-l border-y border-gray-200 dark:border-gray-700" }, toDisplayString(_ctx.$t("Code")), 1),
                                createVNode("th", { class: "border-l border-y border-gray-200 dark:border-gray-700" }, toDisplayString(_ctx.$t("Cost")), 1),
                                createVNode("th", { class: "border-l border-y border-gray-200 dark:border-gray-700" }, toDisplayString(_ctx.$t("Price")), 1),
                                createVNode("th", { class: "border-l border-y border-gray-200 dark:border-gray-700" }, toDisplayString(_ctx.$t("Rack")), 1),
                                createVNode("th", { class: "border-l border-y border-gray-200 dark:border-gray-700" }, toDisplayString(_ctx.$t("Weight")), 1),
                                createVNode("th", { class: "border-l border-y border-gray-200 dark:border-gray-700" }, toDisplayString(_ctx.$t("Dimensions")), 1),
                                createVNode("th", { class: "border border-gray-200 dark:border-gray-700" })
                              ])
                            ]),
                            createVNode("tbody", null, [
                              (openBlock(true), createBlock(Fragment, null, renderList(unref(form).variations, (variation, index) => {
                                return openBlock(), createBlock("tr", {
                                  key: "variation_" + index,
                                  class: "hover:bg-primary-50 dark:hover:bg-primary-950"
                                }, [
                                  unref(form).variations.length ? (openBlock(true), createBlock(Fragment, { key: 0 }, renderList(unref(form).variants, (va, vi) => {
                                    return openBlock(), createBlock("td", {
                                      class: "border-b border-l border-gray-200 dark:border-gray-700",
                                      key: "option" + vi
                                    }, [
                                      variation.meta ? (openBlock(), createBlock("div", {
                                        key: 0,
                                        class: "py-1 px-2"
                                      }, toDisplayString(variation.meta[va.name]), 1)) : createCommentVNode("", true)
                                    ]);
                                  }), 128)) : createCommentVNode("", true),
                                  createVNode("td", { class: "border-b border-l border-gray-200 dark:border-gray-700" }, [
                                    withDirectives(createVNode("input", {
                                      "onUpdate:modelValue": ($event) => variation.code = $event,
                                      class: "w-24 py-0 px-2 border-0 bg-transparent focus:ring-0"
                                    }, null, 8, ["onUpdate:modelValue"]), [
                                      [vModelText, variation.code]
                                    ])
                                  ]),
                                  createVNode("td", { class: "border-b border-l border-gray-200 dark:border-gray-700" }, [
                                    withDirectives(createVNode("input", {
                                      type: "number",
                                      "onUpdate:modelValue": ($event) => variation.cost = $event,
                                      class: "w-24 py-0 pl-2 pr-0 border-0 bg-transparent focus:ring-0"
                                    }, null, 8, ["onUpdate:modelValue"]), [
                                      [vModelText, variation.cost]
                                    ])
                                  ]),
                                  createVNode("td", { class: "border-b border-l border-gray-200 dark:border-gray-700" }, [
                                    withDirectives(createVNode("input", {
                                      type: "number",
                                      "onUpdate:modelValue": ($event) => variation.price = $event,
                                      class: "w-24 py-0 pl-2 pr-0 border-0 bg-transparent focus:ring-0"
                                    }, null, 8, ["onUpdate:modelValue"]), [
                                      [vModelText, variation.price]
                                    ])
                                  ]),
                                  createVNode("td", { class: "border-b border-l border-gray-200 dark:border-gray-700" }, [
                                    withDirectives(createVNode("input", {
                                      "onUpdate:modelValue": ($event) => variation.rack_location = $event,
                                      class: "w-24 py-0 px-2 border-0 bg-transparent focus:ring-0"
                                    }, null, 8, ["onUpdate:modelValue"]), [
                                      [vModelText, variation.rack_location]
                                    ])
                                  ]),
                                  createVNode("td", { class: "border-b border-l border-gray-200 dark:border-gray-700" }, [
                                    withDirectives(createVNode("input", {
                                      type: "number",
                                      "onUpdate:modelValue": ($event) => variation.weight = $event,
                                      class: "w-24 py-0 pl-2 pr-0 border-0 bg-transparent focus:ring-0"
                                    }, null, 8, ["onUpdate:modelValue"]), [
                                      [vModelText, variation.weight]
                                    ])
                                  ]),
                                  createVNode("td", { class: "border-b border-l border-gray-200 dark:border-gray-700" }, [
                                    withDirectives(createVNode("input", {
                                      "onUpdate:modelValue": ($event) => variation.dimensions = $event,
                                      placeholder: _ctx.$t("L x  W x H"),
                                      class: "w-24 py-0 px-2 border-0 bg-transparent focus:ring-0"
                                    }, null, 8, ["onUpdate:modelValue", "placeholder"]), [
                                      [vModelText, variation.dimensions]
                                    ])
                                  ]),
                                  createVNode("td", {
                                    class: ["border-b border-l border-r border-gray-200 dark:border-gray-700 text-center", variation.highlight ? "bg-yellow-100" : ""]
                                  }, [
                                    createVNode("button", {
                                      type: "button",
                                      onClick: () => unref(form).variations.splice(index, 1),
                                      class: "relative inline-flex items-center rounded-md -ml-3 p-1 text-mute hover:text-red-700 hover:bg-red-100 dark:hover:text-red-200 dark:hover:bg-red-950 focus:z-10"
                                    }, [
                                      createVNode("span", { class: "sr-only" }, toDisplayString(_ctx.$t("Remove")), 1),
                                      createVNode(_component_Icon, {
                                        name: "trash-o",
                                        size: "size-5"
                                      })
                                    ], 8, ["onClick"])
                                  ], 2)
                                ]);
                              }), 128))
                            ])
                          ])
                        ])
                      ])
                    ])
                  ])) : createCommentVNode("", true)
                ]),
                createVNode("div", { class: "col-span-full flex flex-col gap-2 rounded-md p-4 border border-gray-200 dark:border-gray-700 overflow-x-auto" }, [
                  createVNode(unref(_sfc_main$d), {
                    id: "dont_track_stock",
                    label: _ctx.$t("Do not track stock for this product"),
                    modelValue: unref(form).dont_track_stock,
                    "onUpdate:modelValue": ($event) => unref(form).dont_track_stock = $event
                  }, null, 8, ["label", "modelValue", "onUpdate:modelValue"]),
                  !unref(form).dont_track_stock && !unref(form).has_variants ? (openBlock(), createBlock(Fragment, { key: 0 }, [
                    createVNode(unref(_sfc_main$d), {
                      id: "set_stock",
                      label: _ctx.$t("Set different price, quantity & taxes per stores"),
                      modelValue: unref(form).set_stock,
                      "onUpdate:modelValue": ($event) => unref(form).set_stock = $event
                    }, null, 8, ["label", "modelValue", "onUpdate:modelValue"]),
                    unref(form).set_stock ? (openBlock(), createBlock("div", {
                      key: 0,
                      class: "col-span-full flex flex-col gap-8 mt-8"
                    }, [
                      (openBlock(true), createBlock(Fragment, null, renderList(__props.stores, (store, index) => {
                        return openBlock(), createBlock("div", {
                          key: store.id,
                          class: "relative grid grid-cols-6 gap-6 px-6 pt-10 pb-6 border border-gray-200 dark:border-gray-700 rounded-md"
                        }, [
                          createVNode("div", { class: "absolute -top-4 left-4 bg-gray-100 dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-md py-0.5 px-3 font-extrabold text-lg" }, toDisplayString(store.name), 1),
                          createVNode("div", { class: "col-span-6 sm:col-span-2" }, [
                            createVNode(unref(_sfc_main$6), {
                              type: "number",
                              label: _ctx.$t("Selling Price"),
                              modelValue: unref(form).stores[index].price,
                              "onUpdate:modelValue": ($event) => unref(form).stores[index].price = $event,
                              error: _ctx.$page.props.errors["stores." + index + ".price"]
                            }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
                          ]),
                          unref(form).type == "Standard" ? (openBlock(), createBlock("div", {
                            key: 0,
                            class: "col-span-6 sm:col-span-2"
                          }, [
                            createVNode(unref(_sfc_main$6), {
                              type: "number",
                              label: _ctx.$t("Quantity"),
                              modelValue: unref(form).stores[index].quantity,
                              "onUpdate:modelValue": ($event) => unref(form).stores[index].quantity = $event,
                              error: _ctx.$page.props.errors["stores." + index + ".quantity"]
                            }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
                          ])) : createCommentVNode("", true),
                          unref(form).type == "Standard" ? (openBlock(), createBlock("div", {
                            key: 1,
                            class: "col-span-6 sm:col-span-2"
                          }, [
                            createVNode(unref(_sfc_main$6), {
                              type: "number",
                              label: _ctx.$t("Alert (Low Stock) Quantity"),
                              modelValue: unref(form).stores[index].alert_quantity,
                              "onUpdate:modelValue": ($event) => unref(form).stores[index].alert_quantity = $event,
                              error: _ctx.$page.props.errors["stores." + index + ".alert_quantity"]
                            }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
                          ])) : createCommentVNode("", true),
                          createVNode("div", { class: "col-span-full" }, [
                            createVNode(unref(_sfc_main$5), {
                              id: "taxes",
                              json: true,
                              valueKey: "id",
                              labelKey: "name",
                              multiple: true,
                              searchable: false,
                              label: _ctx.$t("Taxes"),
                              suggestions: __props.taxes,
                              modelValue: unref(form).stores[index].taxes,
                              "onUpdate:modelValue": ($event) => unref(form).stores[index].taxes = $event,
                              error: _ctx.$page.props.errors["stores." + index + ".taxes"]
                            }, null, 8, ["label", "suggestions", "modelValue", "onUpdate:modelValue", "error"])
                          ])
                        ]);
                      }), 128))
                    ])) : createCommentVNode("", true)
                  ], 64)) : createCommentVNode("", true)
                ]),
                !unref(form).dont_track_stock ? (openBlock(), createBlock("div", {
                  key: 0,
                  class: "col-span-full flex flex-col gap-2 rounded-md p-4 border border-gray-200 dark:border-gray-700 overflow-x-auto"
                }, [
                  createVNode(unref(_sfc_main$d), {
                    id: "has_serials",
                    label: _ctx.$t("This product has serial numbers"),
                    modelValue: unref(form).has_serials,
                    "onUpdate:modelValue": ($event) => unref(form).has_serials = $event
                  }, null, 8, ["label", "modelValue", "onUpdate:modelValue"]),
                  unref(form).has_serials ? (openBlock(), createBlock("div", {
                    key: 0,
                    class: "col-span-full"
                  }, [
                    createVNode("div", { class: "grid grid-cols-6 gap-6" }, [
                      createVNode("div", { class: "col-span-full mt-6 flex items-center justify-between" }, [
                        createVNode("h4", { class: "text-lg font-bold" }, toDisplayString(_ctx.$t("Serial Numbers")), 1),
                        createVNode("button", {
                          type: "button",
                          onClick: () => unref(form).serials.push({ number: "", till: "" }),
                          class: "relative -ml-px inline-flex items-center rounded-md bg-white dark:bg-gray-900 px-2 py-2 text-mute ring-1 ring-inset ring-gray-300 dark:ring-gray-700 hover:bg-gray-50 dark:hover:bg-gray-950 focus:z-10"
                        }, [
                          createVNode(_component_Icon, {
                            name: "add",
                            size: "size-5 sm:mr-2"
                          }),
                          createVNode("span", { class: "hidden sm:block" }, toDisplayString(_ctx.$t("Add {x}", { x: _ctx.$t("Serial") })), 1)
                        ], 8, ["onClick"])
                      ]),
                      (openBlock(true), createBlock(Fragment, null, renderList(unref(form).serials, (serial, index) => {
                        return openBlock(), createBlock(Fragment, {
                          key: "serial_" + index
                        }, [
                          createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                            createVNode(unref(_sfc_main$6), {
                              id: "serial_" + index,
                              modelValue: serial.number,
                              "onUpdate:modelValue": ($event) => serial.number = $event,
                              label: _ctx.$t("Serial Number"),
                              onKeyup: withKeys(withModifiers((e) => focusNextSerialInput(e, index), ["prevent"]), ["enter"])
                            }, null, 8, ["id", "modelValue", "onUpdate:modelValue", "label", "onKeyup"])
                          ]),
                          createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                            createVNode(unref(_sfc_main$6), {
                              modelValue: serial.till,
                              "onUpdate:modelValue": ($event) => serial.till = $event,
                              label: _ctx.$t("Till")
                            }, null, 8, ["modelValue", "onUpdate:modelValue", "label"])
                          ]),
                          serial.number || serial.till && serial.number < serial.till ? (openBlock(), createBlock("div", {
                            key: 0,
                            class: "col-span-full -mt-3"
                          }, [
                            createVNode("strong", null, toDisplayString(countSerials(serial.number, serial.till)), 1),
                            createTextVNode(" " + toDisplayString(_ctx.$t(countSerials(serial.number, serial.till) == 1 ? "Serial Number" : "Serial Numbers")), 1)
                          ])) : createCommentVNode("", true)
                        ], 64);
                      }), 128))
                    ])
                  ])) : createCommentVNode("", true)
                ])) : createCommentVNode("", true)
              ], 64)) : createCommentVNode("", true),
              createVNode("div", { class: "col-span-full flex flex-col gap-6 p-6 mb-6 rounded border border-gray-200 dark:border-gray-700" }, [
                createVNode("div", { class: "col-span-full -mt-6 -mb-3" }, [
                  createVNode("h4", { class: "text-lg font-bold mt-6 mb-3" }, toDisplayString(_ctx.$t("SEO Fields")), 1)
                ]),
                createVNode("div", null, [
                  createVNode(unref(_sfc_main$6), {
                    id: "title",
                    label: _ctx.$t("Title"),
                    modelValue: unref(form).title,
                    "onUpdate:modelValue": ($event) => unref(form).title = $event,
                    error: unref(form).errors.title
                  }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
                ]),
                createVNode("div", null, [
                  createVNode(unref(_sfc_main$c), {
                    id: "description",
                    modelValue: unref(form).description,
                    "onUpdate:modelValue": ($event) => unref(form).description = $event,
                    error: unref(form).errors.description,
                    label: _ctx.$t("Description")
                  }, null, 8, ["modelValue", "onUpdate:modelValue", "error", "label"])
                ]),
                createVNode("div", null, [
                  createVNode(unref(_sfc_main$c), {
                    id: "keywords",
                    modelValue: unref(form).keywords,
                    "onUpdate:modelValue": ($event) => unref(form).keywords = $event,
                    error: unref(form).errors.keywords,
                    label: _ctx.$t("Keywords")
                  }, null, 8, ["modelValue", "onUpdate:modelValue", "error", "label"])
                ]),
                createVNode("div", { class: "flex gap-x-12 gap-y-4" }, [
                  createVNode(unref(_sfc_main$d), {
                    id: "noindex",
                    label: _ctx.$t("Noindex"),
                    modelValue: unref(form).noindex,
                    "onUpdate:modelValue": ($event) => unref(form).noindex = $event
                  }, null, 8, ["label", "modelValue", "onUpdate:modelValue"]),
                  createVNode(unref(_sfc_main$d), {
                    id: "nofollow",
                    label: _ctx.$t("Nofollow"),
                    modelValue: unref(form).nofollow,
                    "onUpdate:modelValue": ($event) => unref(form).nofollow = $event
                  }, null, 8, ["label", "modelValue", "onUpdate:modelValue"])
                ])
              ])
            ];
          }
        }),
        actions: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex items-center justify-end"${_scopeId}>`);
            if (__props.current) {
              _push2(`<button type="button" class="btn-secondary"${ssrRenderAttr("loading", unref(form).processing)}${ssrIncludeBooleanAttr(unref(form).processing) ? " disabled" : ""}${_scopeId}>${ssrInterpolate(_ctx.$t("Save & go to listing"))}</button>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(ssrRenderComponent(unref(_sfc_main$3), {
              on: unref(form).recentlySuccessful,
              class: "ms-3 me-3"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Saved."))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Saved.")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$4), {
              type: "button",
              onClick: handleSubmit,
              class: { "opacity-25": unref(form).processing },
              loading: unref(form).processing
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Save"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "flex items-center justify-end" }, [
                __props.current ? (openBlock(), createBlock("button", {
                  key: 0,
                  type: "button",
                  class: "btn-secondary",
                  loading: unref(form).processing,
                  disabled: unref(form).processing,
                  onClick: (e) => handleSubmit(e, true)
                }, toDisplayString(_ctx.$t("Save & go to listing")), 9, ["loading", "disabled", "onClick"])) : createCommentVNode("", true),
                createVNode(unref(_sfc_main$3), {
                  on: unref(form).recentlySuccessful,
                  class: "ms-3 me-3"
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.$t("Saved.")), 1)
                  ]),
                  _: 1
                }, 8, ["on"]),
                createVNode(unref(_sfc_main$4), {
                  type: "button",
                  onClick: handleSubmit,
                  class: { "opacity-25": unref(form).processing },
                  loading: unref(form).processing
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
                  ]),
                  _: 1
                }, 8, ["class", "loading"])
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Product/Form.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
