import { unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent } from "vue/server-renderer";
import "../ssr.js";
import { usePage, useForm } from "@inertiajs/vue3";
import { u as $decimal, h as _sfc_main$1, l as _sfc_main$2, v as _sfc_main$3 } from "./http-CDixhmav.js";
import "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import { _ as _sfc_main$4 } from "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import { _ as _sfc_main$5 } from "./LoadingButton-DREeyNQW.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "lodash.debounce";
import "dayjs";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = {
  __name: "Form",
  __ssrInlineRender: true,
  props: ["current", "types"],
  emits: ["close", "done"],
  setup(__props, { emit: __emit }) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j;
    usePage();
    const emits = __emit;
    const props = __props;
    const form = useForm({
      _method: ((_a = props.current) == null ? void 0 : _a.id) ? "put" : "post",
      name: (_b = props.current) == null ? void 0 : _b.name,
      code: (_c = props.current) == null ? void 0 : _c.code,
      number: (_d = props.current) == null ? void 0 : _d.number,
      rate: ((_e = props.current) == null ? void 0 : _e.rate) ? $decimal(props.current.rate) : null,
      details: (_f = props.current) == null ? void 0 : _f.details,
      compound: ((_g = props.current) == null ? void 0 : _g.compound) == 1,
      recoverable: ((_h = props.current) == null ? void 0 : _h.recoverable) == 1,
      state: ((_i = props.current) == null ? void 0 : _i.state) == 1,
      same: ((_j = props.current) == null ? void 0 : _j.same) == 1
    });
    return (_ctx, _push, _parent, _attrs) => {
      var _a2, _b2;
      _push(`<form${ssrRenderAttrs(_attrs)}><div class="border-b border-gray-200 dark:border-gray-700 px-6 py-4"><div class="sm:flex sm:items-baseline sm:justify-between"><div class="sm:w-0 sm:flex-1"><h1 class="text-base font-semibold text-focus">${ssrInterpolate(((_a2 = __props.current) == null ? void 0 : _a2.id) ? _ctx.$t("Edit {x}", { x: _ctx.$t("Tax") }) : _ctx.$t("Add {x}", { x: _ctx.$t("Tax") }))}</h1><p class="mt-1 truncate text-sm text-mute">${ssrInterpolate(_ctx.$t("Please fill the form below to {action} {record}.", {
        record: _ctx.$t("tax"),
        action: ((_b2 = __props.current) == null ? void 0 : _b2.id) ? _ctx.$t("edit") : _ctx.$t("add")
      }))}</p></div></div></div><div class="p-6 grid grid-cols-6 gap-6"><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        id: "name",
        label: _ctx.$t("Name"),
        modelValue: unref(form).name,
        "onUpdate:modelValue": ($event) => unref(form).name = $event,
        error: unref(form).errors.name
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        id: "code",
        label: _ctx.$t("Code"),
        modelValue: unref(form).code,
        "onUpdate:modelValue": ($event) => unref(form).code = $event,
        error: unref(form).errors.code
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        id: "number",
        label: _ctx.$t("Number"),
        modelValue: unref(form).number,
        "onUpdate:modelValue": ($event) => unref(form).number = $event,
        error: unref(form).errors.number
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        id: "rate",
        type: "number",
        label: _ctx.$t("Rate"),
        modelValue: unref(form).rate,
        "onUpdate:modelValue": ($event) => unref(form).rate = $event,
        error: unref(form).errors.rate
      }, null, _parent));
      _push(`</div><div class="col-span-full">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "details",
        label: _ctx.$t("Details"),
        modelValue: unref(form).details,
        "onUpdate:modelValue": ($event) => unref(form).details = $event,
        error: unref(form).errors.details
      }, null, _parent));
      _push(`</div><div class="col-span-full">`);
      _push(ssrRenderComponent(unref(_sfc_main$3), {
        id: "state",
        error: unref(form).errors.state,
        checked: unref(form).state,
        "onUpdate:checked": ($event) => unref(form).state = $event,
        label: _ctx.$t("This is state tax")
      }, null, _parent));
      _push(`</div>`);
      if (unref(form).state) {
        _push(`<div class="col-span-full">`);
        _push(ssrRenderComponent(unref(_sfc_main$3), {
          id: "same",
          error: unref(form).errors.same,
          checked: unref(form).same,
          "onUpdate:checked": ($event) => unref(form).same = $event,
          label: _ctx.$t("Apply to same state customers")
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="col-span-full">`);
      _push(ssrRenderComponent(unref(_sfc_main$3), {
        id: "recoverable",
        error: unref(form).errors.recoverable,
        checked: unref(form).recoverable,
        "onUpdate:checked": ($event) => unref(form).recoverable = $event,
        label: _ctx.$t("This tax is recoverable")
      }, null, _parent));
      _push(`</div><div class="col-span-full">`);
      _push(ssrRenderComponent(unref(_sfc_main$3), {
        id: "compound",
        error: unref(form).errors.compound,
        checked: unref(form).compound,
        "onUpdate:checked": ($event) => unref(form).compound = $event,
        label: _ctx.$t("Compound: this tax should be applied after other taxes")
      }, null, _parent));
      _push(`</div></div><div class="flex flex-row justify-end px-6 py-4 bg-gray-100 dark:bg-gray-950 text-end">`);
      _push(ssrRenderComponent(unref(_sfc_main$4), {
        onClick: ($event) => emits("close")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Cancel"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Cancel")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$5), {
        class: "ms-3",
        loading: unref(form).processing
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Save"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></form>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Setting/Tax/Form.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
