import { unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent } from "vue/server-renderer";
import "../ssr.js";
import { usePage, useForm } from "@inertiajs/vue3";
import { u as $decimal, b as _sfc_main$1, h as _sfc_main$2, l as _sfc_main$3, v as _sfc_main$4 } from "./http-CDixhmav.js";
import "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import { _ as _sfc_main$5 } from "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import { _ as _sfc_main$6 } from "./LoadingButton-DREeyNQW.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "lodash.debounce";
import "dayjs";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = {
  __name: "Form",
  __ssrInlineRender: true,
  props: ["current", "types"],
  emits: ["close", "done"],
  setup(__props, { emit: __emit }) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m;
    usePage();
    const emits = __emit;
    const props = __props;
    const form = useForm({
      _method: ((_a = props.current) == null ? void 0 : _a.id) ? "put" : "post",
      type: (_b = props.current) == null ? void 0 : _b.type,
      title: (_c = props.current) == null ? void 0 : _c.title,
      details: (_d = props.current) == null ? void 0 : _d.details,
      reference: (_e = props.current) == null ? void 0 : _e.reference,
      opening_balance: $decimal((_f = props.current) == null ? void 0 : _f.opening_balance),
      offline: ((_g = props.current) == null ? void 0 : _g.offline) == 1,
      fees: ((_h = props.current) == null ? void 0 : _h.fees) == 1,
      fixed: (_i = props.current) == null ? void 0 : _i.fixed,
      percentage: (_j = props.current) == null ? void 0 : _j.percentage,
      apply_to: (_k = props.current) == null ? void 0 : _k.apply_to,
      active: ((_l = props.current) == null ? void 0 : _l.id) ? ((_m = props.current) == null ? void 0 : _m.active) == 1 : true
    });
    return (_ctx, _push, _parent, _attrs) => {
      var _a2, _b2, _c2;
      _push(`<form${ssrRenderAttrs(_attrs)}><div class="border-b border-gray-200 dark:border-gray-700 px-6 py-4"><div class="sm:flex sm:items-baseline sm:justify-between"><div class="sm:w-0 sm:flex-1"><h1 class="text-base font-semibold text-focus">${ssrInterpolate(((_a2 = __props.current) == null ? void 0 : _a2.id) ? _ctx.$t("Edit {x}", { x: _ctx.$t("Account") }) : _ctx.$t("Add {x}", { x: _ctx.$t("Account") }))}</h1><p class="mt-1 truncate text-sm text-mute">${ssrInterpolate(_ctx.$t("Please fill the form below to {action} {record}.", {
        record: _ctx.$t("account"),
        action: ((_b2 = __props.current) == null ? void 0 : _b2.id) ? _ctx.$t("edit") : _ctx.$t("add")
      }))}</p></div></div></div><div class="p-6 grid grid-cols-6 gap-6"><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        json: true,
        id: "type",
        searchable: false,
        label: _ctx.$t("Type"),
        modelValue: unref(form).type,
        "onUpdate:modelValue": ($event) => unref(form).type = $event,
        error: unref(form).errors.type,
        suggestions: __props.types
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "title",
        label: _ctx.$t("Title"),
        modelValue: unref(form).title,
        "onUpdate:modelValue": ($event) => unref(form).title = $event,
        error: unref(form).errors.title
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        type: "number",
        id: "opening_balance",
        readonly: (_c2 = __props.current) == null ? void 0 : _c2.id,
        label: _ctx.$t("Opening Balance"),
        modelValue: unref(form).opening_balance,
        "onUpdate:modelValue": ($event) => unref(form).opening_balance = $event,
        error: unref(form).errors.opening_balance
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "reference",
        label: _ctx.$t("Reference"),
        modelValue: unref(form).reference,
        "onUpdate:modelValue": ($event) => unref(form).reference = $event,
        error: unref(form).errors.reference
      }, null, _parent));
      _push(`</div><div class="col-span-full">`);
      _push(ssrRenderComponent(unref(_sfc_main$3), {
        id: "details",
        label: _ctx.$t("Details"),
        modelValue: unref(form).details,
        "onUpdate:modelValue": ($event) => unref(form).details = $event,
        error: unref(form).errors.details
      }, null, _parent));
      _push(`</div><div class="col-span-full">`);
      _push(ssrRenderComponent(unref(_sfc_main$4), {
        id: "fees",
        error: unref(form).errors.fees,
        checked: unref(form).fees,
        "onUpdate:checked": ($event) => unref(form).fees = $event,
        label: _ctx.$t("Apply transaction fees")
      }, null, _parent));
      _push(`</div>`);
      if (unref(form).fees) {
        _push(`<!--[--><div class="col-span-6 sm:col-span-3">`);
        _push(ssrRenderComponent(unref(_sfc_main$2), {
          type: "number",
          id: "fixed",
          label: _ctx.$t("Fixed Fees"),
          modelValue: unref(form).fixed,
          "onUpdate:modelValue": ($event) => unref(form).fixed = $event,
          error: unref(form).errors.fixed
        }, null, _parent));
        _push(`</div><div class="col-span-6 sm:col-span-3">`);
        _push(ssrRenderComponent(unref(_sfc_main$2), {
          type: "number",
          id: "percentage",
          label: _ctx.$t("Percentage Fees"),
          modelValue: unref(form).percentage,
          "onUpdate:modelValue": ($event) => unref(form).percentage = $event,
          error: unref(form).errors.percentage
        }, null, _parent));
        _push(`</div><div class="col-span-6 sm:col-span-3">`);
        _push(ssrRenderComponent(unref(_sfc_main$1), {
          json: true,
          id: "apply_to",
          searchable: false,
          label: _ctx.$t("Apply to"),
          modelValue: unref(form).apply_to,
          "onUpdate:modelValue": ($event) => unref(form).apply_to = $event,
          error: unref(form).errors.apply_to,
          suggestions: [
            { value: "Credit", label: _ctx.$t("Credit") },
            { value: "Debit", label: _ctx.$t("Debit") },
            { value: "Both", label: _ctx.$t("Both (credit & debit)") }
          ]
        }, null, _parent));
        _push(`</div><!--]-->`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="col-span-full">`);
      _push(ssrRenderComponent(unref(_sfc_main$4), {
        id: "offline",
        label: _ctx.$t("Show this in offline payments"),
        checked: unref(form).offline,
        "onUpdate:checked": ($event) => unref(form).offline = $event,
        error: unref(form).errors.offline
      }, null, _parent));
      _push(`</div><div class="col-span-full">`);
      _push(ssrRenderComponent(unref(_sfc_main$4), {
        id: "active",
        error: unref(form).errors.active,
        checked: unref(form).active,
        "onUpdate:checked": ($event) => unref(form).active = $event,
        label: _ctx.$t("Active")
      }, null, _parent));
      _push(`</div></div><div class="flex flex-row justify-end px-6 py-4 bg-gray-100 dark:bg-gray-950 text-end">`);
      _push(ssrRenderComponent(unref(_sfc_main$5), {
        onClick: ($event) => emits("close")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Cancel"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Cancel")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$6), {
        class: "ms-3",
        loading: unref(form).processing
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Save"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></form>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Setting/Account/Form.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
