import { ref, onMounted, resolveComponent, withCtx, createVNode, toDisplayString, unref, createTextVNode, createBlock, createCommentVNode, openBlock, Fragment, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate } from "vue/server-renderer";
import dayjs from "dayjs";
import { T } from "../ssr.js";
import { notify } from "notiwind";
import { useI18n } from "vue-i18n";
import "lodash.debounce";
import { usePage, useForm, router } from "@inertiajs/vue3";
import { _ as _sfc_main$1 } from "./AdminLayout-DHH3IgME.js";
import { f as $extras, g as _sfc_main$6, h as _sfc_main$7, b as _sfc_main$8, i as _sfc_main$9, j as _sfc_main$a, k as _sfc_main$b, l as _sfc_main$c, s as _sfc_main$d } from "./http-CDixhmav.js";
import { F as FormHelper, V as VariationSelection } from "./VariationSelection-kl6n6FuS.js";
import { _ as _sfc_main$4 } from "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import { _ as _sfc_main$2 } from "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import { _ as _sfc_main$3 } from "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import { _ as _sfc_main$5 } from "./LoadingButton-DREeyNQW.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "./AppLayout-BRHmSgDa.js";
import "@vuepic/vue-datepicker";
import "lodash.isequal";
import "axios";
import "lodash.throttle";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = /* @__PURE__ */ Object.assign({ layout: _sfc_main$1 }, {
  __name: "Form",
  __ssrInlineRender: true,
  props: ["current", "brands", "categories", "custom_fields"],
  setup(__props) {
    var _a, _b, _c, _d, _e, _f, _g;
    usePage();
    const { t } = useI18n();
    const props = __props;
    ref([]);
    ref(null);
    const finalize = ref(false);
    const form = useForm({
      _method: ((_a = props.current) == null ? void 0 : _a.id) ? "put" : "post",
      file: null,
      date: dayjs((_b = props.current) == null ? void 0 : _b.date).format("YYYY-MM-DD"),
      reference: (_c = props.current) == null ? void 0 : _c.reference,
      type: (_d = props.current) == null ? void 0 : _d.type,
      details: (_e = props.current) == null ? void 0 : _e.details,
      brands: (_f = props.current) == null ? void 0 : _f.brands,
      categories: (_g = props.current) == null ? void 0 : _g.categories,
      extra_attributes: props.current ? $extras(props.custom_fields, props.current.extra_attributes) : $extras(props.custom_fields)
    });
    const { resetForm, saveForm } = FormHelper(form);
    const { currentItem, variantModal, SelectVariant } = VariationSelection();
    onMounted(() => {
      var _a2, _b2;
      if (((_a2 = props.current) == null ? void 0 : _a2.id) && ((_b2 = props.current) == null ? void 0 : _b2.completed_at)) {
        notify({ group: "main", type: "error", title: t("Stock count has already completed.") });
        router.get(T("stock_counts.index"));
      }
    });
    function handleSubmit(e, listing = false) {
      var _a2;
      form.errors = {};
      form.transform((data) => {
        let form2 = { ...data };
        try {
          form2.date = form2.date.toString().includes("T") ? form2.date.toString().split("T")[0] : form2.date;
        } catch (err) {
        }
        return form2;
      }).post(((_a2 = props.current) == null ? void 0 : _a2.id) ? T("stock_counts.update", props.current.id) : T("stock_counts.store"), {
        forceFormData: true,
        onSuccess: (page) => {
          resetForm();
        }
      });
    }
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Head = resolveComponent("Head");
      const _component_Link = resolveComponent("Link");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_Head, null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          var _a2, _b2;
          if (_push2) {
            _push2(`<title${_scopeId}>${ssrInterpolate(((_a2 = __props.current) == null ? void 0 : _a2.id) ? _ctx.$t("Complete Stock Count") : _ctx.$t("Start Stock Count"))}</title>`);
          } else {
            return [
              createVNode("title", null, toDisplayString(((_b2 = __props.current) == null ? void 0 : _b2.id) ? _ctx.$t("Complete Stock Count") : _ctx.$t("Start Stock Count")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<div class="pt-6 pb-0 sm:py-8 px-0 sm:px-6 lg:px-8">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), { onSubmitted: handleSubmit }, {
        title: withCtx((_, _push2, _parent2, _scopeId) => {
          var _a2, _b2;
          if (_push2) {
            _push2(`${ssrInterpolate(((_a2 = __props.current) == null ? void 0 : _a2.id) ? _ctx.$t("Complete Stock Count") : _ctx.$t("Start Stock Count"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(((_b2 = __props.current) == null ? void 0 : _b2.id) ? _ctx.$t("Complete Stock Count") : _ctx.$t("Start Stock Count")), 1)
            ];
          }
        }),
        description: withCtx((_, _push2, _parent2, _scopeId) => {
          var _a2, _b2;
          if (_push2) {
            _push2(`<div class="w-full block sm:flex sm:items-start sm:justify-between lg:block"${_scopeId}><div${_scopeId}>${ssrInterpolate(_ctx.$t("Please fill the form below to {action} {record}.", {
              record: _ctx.$t("stock count"),
              action: ((_a2 = __props.current) == null ? void 0 : _a2.id) ? _ctx.$t("complete") : _ctx.$t("start")
            }))}</div><div class="mt-6 sm:mt-0 lg:mt-6 me-3"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_Link, {
              class: "link",
              href: unref(T)("stock_counts.index")
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("List {x}", { x: _ctx.$t("Stock Counts") }))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("List {x}", { x: _ctx.$t("Stock Counts") })), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div></div>`);
          } else {
            return [
              createVNode("div", { class: "w-full block sm:flex sm:items-start sm:justify-between lg:block" }, [
                createVNode("div", null, toDisplayString(_ctx.$t("Please fill the form below to {action} {record}.", {
                  record: _ctx.$t("stock count"),
                  action: ((_b2 = __props.current) == null ? void 0 : _b2.id) ? _ctx.$t("complete") : _ctx.$t("start")
                })), 1),
                createVNode("div", { class: "mt-6 sm:mt-0 lg:mt-6 me-3" }, [
                  createVNode(_component_Link, {
                    class: "link",
                    href: unref(T)("stock_counts.index")
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(_ctx.$t("List {x}", { x: _ctx.$t("Stock Counts") })), 1)
                    ]),
                    _: 1
                  }, 8, ["href"])
                ])
              ])
            ];
          }
        }),
        form: withCtx((_, _push2, _parent2, _scopeId) => {
          var _a2, _b2, _c2, _d2, _e2, _f2, _g2, _h, _i, _j;
          if (_push2) {
            if (!((_a2 = __props.current) == null ? void 0 : _a2.id) || !finalize.value) {
              _push2(`<!--[--><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                type: "date",
                id: "date",
                onChange: unref(saveForm),
                label: _ctx.$t("Date"),
                modelValue: unref(form).date,
                "onUpdate:modelValue": ($event) => unref(form).date = $event,
                error: unref(form).errors.date
              }, null, _parent2, _scopeId));
              _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$7), {
                id: "reference",
                onChange: unref(saveForm),
                label: _ctx.$t("Reference"),
                modelValue: unref(form).reference,
                "onUpdate:modelValue": ($event) => unref(form).reference = $event,
                error: unref(form).errors.reference
              }, null, _parent2, _scopeId));
              _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$8), {
                id: "type",
                json: true,
                onChange: unref(saveForm),
                label: _ctx.$t("Type"),
                modelValue: unref(form).type,
                "onUpdate:modelValue": ($event) => unref(form).type = $event,
                error: unref(form).errors.type,
                suggestions: [
                  { value: "full", label: _ctx.$t("Full Stock Count") },
                  { value: "partial", label: _ctx.$t("Partial Stock Count") }
                ]
              }, null, _parent2, _scopeId));
              _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$9), {
                multiple: "",
                id: "attachments",
                label: _ctx.$t("Attachments"),
                modelValue: unref(form).attachments,
                "onUpdate:modelValue": ($event) => unref(form).attachments = $event,
                error: unref(form).errors.attachments,
                accept: ((_b2 = _ctx.$page.props.settings) == null ? void 0 : _b2.attachment_exts) || ".jpg,.png,.pdf,.xlsx,.docx,.zip"
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
              if (__props.current && __props.current.attachments && __props.current.attachments.length) {
                _push2(`<div class="col-span-full"${_scopeId}>`);
                _push2(ssrRenderComponent(unref(_sfc_main$a), {
                  attachments: __props.current.attachments || []
                }, null, _parent2, _scopeId));
                _push2(`</div>`);
              } else {
                _push2(`<!---->`);
              }
              if (unref(form).type == "partial") {
                _push2(`<!--[--><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
                _push2(ssrRenderComponent(unref(_sfc_main$8), {
                  json: "",
                  multiple: "",
                  id: "brands",
                  valueKey: "id",
                  labelKey: "name",
                  searchable: false,
                  label: _ctx.$t("Brands"),
                  suggestions: __props.brands,
                  modelValue: unref(form).brands,
                  "onUpdate:modelValue": ($event) => unref(form).brands = $event,
                  error: unref(form).errors.brands
                }, null, _parent2, _scopeId));
                _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
                _push2(ssrRenderComponent(unref(_sfc_main$8), {
                  json: "",
                  multiple: "",
                  valueKey: "id",
                  labelKey: "name",
                  id: "categories",
                  searchable: false,
                  label: _ctx.$t("Categories"),
                  suggestions: __props.categories,
                  modelValue: unref(form).categories,
                  "onUpdate:modelValue": ($event) => unref(form).categories = $event,
                  error: unref(form).errors.categories
                }, null, _parent2, _scopeId));
                _push2(`</div><!--]-->`);
              } else {
                _push2(`<!---->`);
              }
              _push2(`<div class="col-span-full flex flex-col gap-6"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$b), {
                errors: unref(form).errors,
                custom_fields: __props.custom_fields,
                extra_attributes: unref(form).extra_attributes,
                onUpdate: unref(saveForm)
              }, null, _parent2, _scopeId));
              _push2(ssrRenderComponent(unref(_sfc_main$c), {
                onChange: unref(saveForm),
                label: _ctx.$t("Details"),
                modelValue: unref(form).details,
                "onUpdate:modelValue": ($event) => unref(form).details = $event,
                error: _ctx.$page.props.errors.details
              }, null, _parent2, _scopeId));
              _push2(`</div><!--]-->`);
            } else if (((_c2 = __props.current) == null ? void 0 : _c2.id) && finalize.value) {
              _push2(`<!--[-->`);
              if ((_d2 = __props.current) == null ? void 0 : _d2.id) {
                _push2(`<div class="col-span-full"${_scopeId}>`);
                _push2(ssrRenderComponent(unref(_sfc_main$9), {
                  id: "file",
                  accept: ".xlsx",
                  modelValue: unref(form).file,
                  "onUpdate:modelValue": ($event) => unref(form).file = $event,
                  label: _ctx.$t("Final File"),
                  error: unref(form).errors.file
                }, null, _parent2, _scopeId));
                _push2(`</div>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(`<!--]-->`);
            } else {
              _push2(`<!---->`);
            }
            if ((_e2 = __props.current) == null ? void 0 : _e2.id) {
              _push2(`<div class="col-span-full"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$d), {
                id: "finalize",
                label: _ctx.$t("Finalize"),
                modelValue: finalize.value,
                "onUpdate:modelValue": ($event) => finalize.value = $event
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              _push2(`<!---->`);
            }
          } else {
            return [
              !((_f2 = __props.current) == null ? void 0 : _f2.id) || !finalize.value ? (openBlock(), createBlock(Fragment, { key: 0 }, [
                createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                  createVNode(unref(_sfc_main$6), {
                    type: "date",
                    id: "date",
                    onChange: unref(saveForm),
                    label: _ctx.$t("Date"),
                    modelValue: unref(form).date,
                    "onUpdate:modelValue": ($event) => unref(form).date = $event,
                    error: unref(form).errors.date
                  }, null, 8, ["onChange", "label", "modelValue", "onUpdate:modelValue", "error"])
                ]),
                createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                  createVNode(unref(_sfc_main$7), {
                    id: "reference",
                    onChange: unref(saveForm),
                    label: _ctx.$t("Reference"),
                    modelValue: unref(form).reference,
                    "onUpdate:modelValue": ($event) => unref(form).reference = $event,
                    error: unref(form).errors.reference
                  }, null, 8, ["onChange", "label", "modelValue", "onUpdate:modelValue", "error"])
                ]),
                createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                  createVNode(unref(_sfc_main$8), {
                    id: "type",
                    json: true,
                    onChange: unref(saveForm),
                    label: _ctx.$t("Type"),
                    modelValue: unref(form).type,
                    "onUpdate:modelValue": ($event) => unref(form).type = $event,
                    error: unref(form).errors.type,
                    suggestions: [
                      { value: "full", label: _ctx.$t("Full Stock Count") },
                      { value: "partial", label: _ctx.$t("Partial Stock Count") }
                    ]
                  }, null, 8, ["onChange", "label", "modelValue", "onUpdate:modelValue", "error", "suggestions"])
                ]),
                createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                  createVNode(unref(_sfc_main$9), {
                    multiple: "",
                    id: "attachments",
                    label: _ctx.$t("Attachments"),
                    modelValue: unref(form).attachments,
                    "onUpdate:modelValue": ($event) => unref(form).attachments = $event,
                    error: unref(form).errors.attachments,
                    accept: ((_g2 = _ctx.$page.props.settings) == null ? void 0 : _g2.attachment_exts) || ".jpg,.png,.pdf,.xlsx,.docx,.zip"
                  }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error", "accept"])
                ]),
                __props.current && __props.current.attachments && __props.current.attachments.length ? (openBlock(), createBlock("div", {
                  key: 0,
                  class: "col-span-full"
                }, [
                  createVNode(unref(_sfc_main$a), {
                    attachments: __props.current.attachments || []
                  }, null, 8, ["attachments"])
                ])) : createCommentVNode("", true),
                unref(form).type == "partial" ? (openBlock(), createBlock(Fragment, { key: 1 }, [
                  createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                    createVNode(unref(_sfc_main$8), {
                      json: "",
                      multiple: "",
                      id: "brands",
                      valueKey: "id",
                      labelKey: "name",
                      searchable: false,
                      label: _ctx.$t("Brands"),
                      suggestions: __props.brands,
                      modelValue: unref(form).brands,
                      "onUpdate:modelValue": ($event) => unref(form).brands = $event,
                      error: unref(form).errors.brands
                    }, null, 8, ["label", "suggestions", "modelValue", "onUpdate:modelValue", "error"])
                  ]),
                  createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                    createVNode(unref(_sfc_main$8), {
                      json: "",
                      multiple: "",
                      valueKey: "id",
                      labelKey: "name",
                      id: "categories",
                      searchable: false,
                      label: _ctx.$t("Categories"),
                      suggestions: __props.categories,
                      modelValue: unref(form).categories,
                      "onUpdate:modelValue": ($event) => unref(form).categories = $event,
                      error: unref(form).errors.categories
                    }, null, 8, ["label", "suggestions", "modelValue", "onUpdate:modelValue", "error"])
                  ])
                ], 64)) : createCommentVNode("", true),
                createVNode("div", { class: "col-span-full flex flex-col gap-6" }, [
                  createVNode(unref(_sfc_main$b), {
                    errors: unref(form).errors,
                    custom_fields: __props.custom_fields,
                    extra_attributes: unref(form).extra_attributes,
                    onUpdate: unref(saveForm)
                  }, null, 8, ["errors", "custom_fields", "extra_attributes", "onUpdate"]),
                  createVNode(unref(_sfc_main$c), {
                    onChange: unref(saveForm),
                    label: _ctx.$t("Details"),
                    modelValue: unref(form).details,
                    "onUpdate:modelValue": ($event) => unref(form).details = $event,
                    error: _ctx.$page.props.errors.details
                  }, null, 8, ["onChange", "label", "modelValue", "onUpdate:modelValue", "error"])
                ])
              ], 64)) : ((_h = __props.current) == null ? void 0 : _h.id) && finalize.value ? (openBlock(), createBlock(Fragment, { key: 1 }, [
                ((_i = __props.current) == null ? void 0 : _i.id) ? (openBlock(), createBlock("div", {
                  key: 0,
                  class: "col-span-full"
                }, [
                  createVNode(unref(_sfc_main$9), {
                    id: "file",
                    accept: ".xlsx",
                    modelValue: unref(form).file,
                    "onUpdate:modelValue": ($event) => unref(form).file = $event,
                    label: _ctx.$t("Final File"),
                    error: unref(form).errors.file
                  }, null, 8, ["modelValue", "onUpdate:modelValue", "label", "error"])
                ])) : createCommentVNode("", true)
              ], 64)) : createCommentVNode("", true),
              ((_j = __props.current) == null ? void 0 : _j.id) ? (openBlock(), createBlock("div", {
                key: 2,
                class: "col-span-full"
              }, [
                createVNode(unref(_sfc_main$d), {
                  id: "finalize",
                  label: _ctx.$t("Finalize"),
                  modelValue: finalize.value,
                  "onUpdate:modelValue": ($event) => finalize.value = $event
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue"])
              ])) : createCommentVNode("", true)
            ];
          }
        }),
        actions: withCtx((_, _push2, _parent2, _scopeId) => {
          var _a2, _b2;
          if (_push2) {
            _push2(`<div class="w-full flex items-center justify-between"${_scopeId}><div${_scopeId}>`);
            if (!((_a2 = __props.current) == null ? void 0 : _a2.id)) {
              _push2(ssrRenderComponent(unref(_sfc_main$3), {
                type: "button",
                onClick: unref(resetForm),
                class: "me-3"
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(_ctx.$t("Reset"))}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(_ctx.$t("Reset")), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              _push2(`<!---->`);
            }
            _push2(`</div><div class="flex items-center justify-end"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$4), {
              on: unref(form).recentlySuccessful,
              class: "ms-3 me-3"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Saved."))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Saved.")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$5), {
              type: "button",
              onClick: handleSubmit,
              class: { "opacity-25": unref(form).processing },
              loading: unref(form).processing
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Save"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div></div>`);
          } else {
            return [
              createVNode("div", { class: "w-full flex items-center justify-between" }, [
                createVNode("div", null, [
                  !((_b2 = __props.current) == null ? void 0 : _b2.id) ? (openBlock(), createBlock(unref(_sfc_main$3), {
                    key: 0,
                    type: "button",
                    onClick: unref(resetForm),
                    class: "me-3"
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(_ctx.$t("Reset")), 1)
                    ]),
                    _: 1
                  }, 8, ["onClick"])) : createCommentVNode("", true)
                ]),
                createVNode("div", { class: "flex items-center justify-end" }, [
                  createVNode(unref(_sfc_main$4), {
                    on: unref(form).recentlySuccessful,
                    class: "ms-3 me-3"
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(_ctx.$t("Saved.")), 1)
                    ]),
                    _: 1
                  }, 8, ["on"]),
                  createVNode(unref(_sfc_main$5), {
                    type: "button",
                    onClick: handleSubmit,
                    class: { "opacity-25": unref(form).processing },
                    loading: unref(form).processing
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
                    ]),
                    _: 1
                  }, 8, ["class", "loading"])
                ])
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      if (unref(variantModal)) {
        _push(ssrRenderComponent(unref(SelectVariant), {
          item: unref(currentItem),
          show: unref(variantModal),
          onClose: () => {
            unref(currentItem).variations = unref(currentItem).variations.filter((v) => v.id);
            unref(form).items = unref(form).items.map((i) => i.product_id == unref(currentItem).product_id ? unref(currentItem) : i);
            variantModal.value = false;
          },
          onUpdate: (item) => {
            item.variations = item.variations.filter((v) => v.id);
            unref(form).items = unref(form).items.map((i) => i.product_id == item.product_id ? item : i);
            unref(saveForm)();
            variantModal.value = false;
          }
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Product/StockCount/Form.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
