import { ref, watch, nextTick, resolveComponent, withCtx, createVNode, toDisplayString, unref, createTextVNode, createBlock, createCommentVNode, openBlock, Fragment, renderList, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrIncludeBooleanAttr, ssrRenderList, ssrRenderClass } from "vue/server-renderer";
import dayjs from "dayjs";
import { T } from "../ssr.js";
import { notify } from "notiwind";
import debounce from "lodash.debounce";
import { usePage, useForm, router } from "@inertiajs/vue3";
import { _ as _sfc_main$1 } from "./AdminLayout-DHH3IgME.js";
import { s as searchItems } from "./search-h0wKx9lE.js";
import { f as $extras, w as calculate_item, z as check_promotions, g as _sfc_main$6, h as _sfc_main$7, b as _sfc_main$8, i as _sfc_main$9, j as _sfc_main$a, k as _sfc_main$c, l as _sfc_main$d, x as convert_to_base_unit, y as discount_keypress } from "./http-CDixhmav.js";
import { V as VariationSelection, F as FormHelper } from "./VariationSelection-kl6n6FuS.js";
import { _ as _sfc_main$4 } from "./ActionMessage-cgGHxf5V.js";
import { b as _sfc_main$e } from "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import { _ as _sfc_main$2 } from "./FormSection-C7JuSy06.js";
import { a as _sfc_main$b } from "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import { _ as _sfc_main$3 } from "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import { _ as _sfc_main$5 } from "./LoadingButton-DREeyNQW.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "./AppLayout-BRHmSgDa.js";
import "vue-i18n";
import "@vuepic/vue-datepicker";
import "lodash.isequal";
import "axios";
import "lodash.throttle";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = /* @__PURE__ */ Object.assign({ layout: _sfc_main$1 }, {
  __name: "Form",
  __ssrInlineRender: true,
  props: ["current", "custom_fields", "stores", "taxes"],
  setup(__props) {
    var _a, _b, _c, _d, _e, _f, _g;
    const page = usePage();
    const props = __props;
    const result = ref([]);
    const search = ref(null);
    const form = useForm({
      _method: ((_a = props.current) == null ? void 0 : _a.id) ? "put" : "post",
      calculate_on: "price",
      date: dayjs((_b = props.current) == null ? void 0 : _b.date).format("YYYY-MM-DD"),
      reference: (_c = props.current) == null ? void 0 : _c.reference,
      due_date: ((_d = props.current) == null ? void 0 : _d.due_date) ? dayjs((_e = props.current) == null ? void 0 : _e.due_date).format("YYYY-MM-DD") : null,
      customer_id: (_f = props.current) == null ? void 0 : _f.customer_id,
      details: (_g = props.current) == null ? void 0 : _g.details,
      attachments: null,
      items: props.current && props.current.items && props.current.items.length ? props.current.items.map((i) => {
        var _a2;
        let item = calculate_item(
          {
            ...i,
            id: i.id,
            price: Number(i.price),
            discount: i.discount,
            name: i.product.name,
            product_id: i.product_id,
            quantity: Number(i.quantity),
            old_quantity: Number(i.quantity),
            taxes: ((_a2 = i.taxes) == null ? void 0 : _a2.map((t) => t.id)) || [],
            tax_included: i.product.tax_included == 1,
            variations: i.variations.map((v) => {
              var _a3;
              return {
                ...v,
                price: Number(v.pivot.price),
                discount: v.pivot.discount,
                quantity: Number(v.pivot.quantity),
                old_quantity: Number(v.pivot.quantity),
                tax_included: i.product.tax_included == 1,
                taxes: ((_a3 = v.pivot.taxes) == null ? void 0 : _a3.map((t) => Number(t))) || []
              };
            })
          },
          "price"
        );
        return item;
      }) : [],
      extra_attributes: props.current ? $extras(props.custom_fields, props.current.extra_attributes) : $extras(props.custom_fields)
    });
    const { currentItem, emptyVariation, variantModal, SelectVariant } = VariationSelection();
    const { openItemModal, selectItem, selectedItem, removeItem, resetForm, saveForm, updateItem } = FormHelper(form);
    watch(search, debounce(searchProducts, 500));
    async function searchProducts(query) {
      if (query) {
        result.value = await searchItems(query, "sale");
        if (result.value.length == 1) {
          addItem(result.value[0]);
        }
      }
    }
    async function addItem(item) {
      var _a2;
      if (form.items.find((i) => i.product_id == item.id)) {
        form.items = form.items.map((i) => {
          if (i.product_id == item.id) {
            if (i.product.has_variants) {
              i.variations = [...i.variations, emptyVariation(i.product)];
              currentItem.value = i;
              variantModal.value = true;
            } else {
              i.quantity++;
            }
          }
          return i;
        });
      } else {
        let product = await axios.get(T("products.show", { product: item.id, with: "promotions" })).then((r) => r.data);
        currentItem.value = calculate_item(
          {
            ...item,
            id: null,
            quantity: 1,
            cost: Number(product.cost),
            price: Number(product.price),
            taxes: product.taxes.map((t) => t.id),
            tax_included: product.tax_included == 1,
            product_id: product.id,
            unit_id: product.unit_id,
            product
          },
          form.calculate_on
        );
        if (product.has_variants) {
          currentItem.value.variations = [emptyVariation(product)];
          variantModal.value = true;
        }
        form.items = [...form.items, { ...currentItem.value }];
      }
      form.items = await check_promotions(form);
      saveForm();
      await nextTick();
      search.value = "";
      (_a2 = document.getElementById("product-search")) == null ? void 0 : _a2.focus();
    }
    function handleSubmit(e, listing = false) {
      var _a2;
      form.errors = {};
      form.transform((data) => {
        let form2 = { ...data };
        form2.items = form2.items.map((i) => ({
          id: i.id,
          cost: i.cost,
          price: i.price,
          taxes: i.taxes,
          quantity: i.quantity,
          unit_id: i.unit_id,
          discount: i.discount,
          product_id: i.product_id,
          old_quantity: i.old_quantity,
          variations: i.variations && i.variations.length ? i.variations.map((v) => ({
            id: v.id,
            cost: v.cost,
            price: v.price,
            taxes: v.taxes,
            unit_id: v.unit_id,
            discount: v.discount,
            quantity: Number(v.quantity),
            old_quantity: v.old_quantity
          })) : null
        }));
        try {
          form2.date = form2.date ? dayjs(form2.date).format("YYYY-MM-DD") : null;
        } catch (err) {
        }
        try {
          form2.due_date = form2.due_date ? dayjs(form2.due_date).format("YYYY-MM-DD") : null;
        } catch (err) {
        }
        return form2;
      }).post(((_a2 = props.current) == null ? void 0 : _a2.id) ? T("sales.update", props.current.id) : T("sales.store"), {
        forceFormData: true,
        onSuccess: (page2) => {
          resetForm();
          if (listing) {
            router.get(T("sales.index"));
          }
        }
      });
    }
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Head = resolveComponent("Head");
      const _component_Link = resolveComponent("Link");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_Head, null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          var _a2, _b2;
          if (_push2) {
            _push2(`<title${_scopeId}>${ssrInterpolate(((_a2 = __props.current) == null ? void 0 : _a2.id) ? _ctx.$t("Edit {x}", { x: _ctx.$t("Sale") }) : _ctx.$t("Add {x}", { x: _ctx.$t("Sale") }))}</title>`);
          } else {
            return [
              createVNode("title", null, toDisplayString(((_b2 = __props.current) == null ? void 0 : _b2.id) ? _ctx.$t("Edit {x}", { x: _ctx.$t("Sale") }) : _ctx.$t("Add {x}", { x: _ctx.$t("Sale") })), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<div class="pt-6 pb-0 sm:py-8 px-0 sm:px-6 lg:px-8">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), { onSubmitted: handleSubmit }, {
        title: withCtx((_, _push2, _parent2, _scopeId) => {
          var _a2, _b2;
          if (_push2) {
            _push2(`${ssrInterpolate(((_a2 = __props.current) == null ? void 0 : _a2.id) ? _ctx.$t("Edit {x}", { x: _ctx.$t("Sale") }) : _ctx.$t("Add {x}", { x: _ctx.$t("Sale") }))}`);
          } else {
            return [
              createTextVNode(toDisplayString(((_b2 = __props.current) == null ? void 0 : _b2.id) ? _ctx.$t("Edit {x}", { x: _ctx.$t("Sale") }) : _ctx.$t("Add {x}", { x: _ctx.$t("Sale") })), 1)
            ];
          }
        }),
        description: withCtx((_, _push2, _parent2, _scopeId) => {
          var _a2, _b2;
          if (_push2) {
            _push2(`<div class="w-full block sm:flex sm:items-start sm:justify-between lg:block"${_scopeId}><div${_scopeId}>${ssrInterpolate(_ctx.$t("Please fill the form below to {action} {record}.", {
              record: _ctx.$t("sale"),
              action: ((_a2 = __props.current) == null ? void 0 : _a2.id) ? _ctx.$t("edit") : _ctx.$t("add")
            }))}</div><div class="mt-6 sm:mt-0 lg:mt-6 me-3"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_Link, {
              class: "link",
              href: unref(T)("sales.index")
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("List {x}", { x: _ctx.$t("Sales") }))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("List {x}", { x: _ctx.$t("Sales") })), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div></div>`);
          } else {
            return [
              createVNode("div", { class: "w-full block sm:flex sm:items-start sm:justify-between lg:block" }, [
                createVNode("div", null, toDisplayString(_ctx.$t("Please fill the form below to {action} {record}.", {
                  record: _ctx.$t("sale"),
                  action: ((_b2 = __props.current) == null ? void 0 : _b2.id) ? _ctx.$t("edit") : _ctx.$t("add")
                })), 1),
                createVNode("div", { class: "mt-6 sm:mt-0 lg:mt-6 me-3" }, [
                  createVNode(_component_Link, {
                    class: "link",
                    href: unref(T)("sales.index")
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(_ctx.$t("List {x}", { x: _ctx.$t("Sales") })), 1)
                    ]),
                    _: 1
                  }, 8, ["href"])
                ])
              ])
            ];
          }
        }),
        form: withCtx((_, _push2, _parent2, _scopeId) => {
          var _a2, _b2;
          if (_push2) {
            _push2(`<div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$6), {
              type: "date",
              id: "date",
              onChange: unref(saveForm),
              label: _ctx.$t("Date"),
              modelValue: unref(form).date,
              "onUpdate:modelValue": ($event) => unref(form).date = $event,
              error: unref(form).errors.date
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$7), {
              id: "reference",
              onChange: unref(saveForm),
              label: _ctx.$t("Reference"),
              modelValue: unref(form).reference,
              "onUpdate:modelValue": ($event) => unref(form).reference = $event,
              error: unref(form).errors.reference
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$8), {
              json: true,
              valueKey: "id",
              id: "customer_id",
              labelKey: "company",
              onChange: unref(saveForm),
              searchable: true,
              label: _ctx.$t("Customer"),
              modelValue: unref(form).customer_id,
              "onUpdate:modelValue": ($event) => unref(form).customer_id = $event,
              suggestions: unref(T)("search.customers"),
              error: _ctx.$page.props.errors.customer_id
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$6), {
              id: "due_date",
              onChange: unref(saveForm),
              label: _ctx.$t("Due Date"),
              modelValue: unref(form).due_date,
              "onUpdate:modelValue": ($event) => unref(form).due_date = $event,
              error: unref(form).errors.due_date
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$9), {
              multiple: "",
              id: "attachments",
              label: _ctx.$t("Attachments"),
              modelValue: unref(form).attachments,
              "onUpdate:modelValue": ($event) => unref(form).attachments = $event,
              error: unref(form).errors.attachments,
              accept: ((_a2 = _ctx.$page.props.settings) == null ? void 0 : _a2.attachment_exts) || ".jpg,.png,.pdf,.xlsx,.docx,.zip"
            }, null, _parent2, _scopeId));
            _push2(`</div>`);
            if (__props.current && __props.current.attachments && __props.current.attachments.length) {
              _push2(`<div class="col-span-full"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$a), {
                attachments: __props.current.attachments || []
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<div class="col-span-full"${_scopeId}><div class="relative"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$7), {
              label: "",
              modelValue: search.value,
              "onUpdate:modelValue": ($event) => search.value = $event,
              id: "product-search",
              placeholder: _ctx.$t("Scan barcode or type to search")
            }, null, _parent2, _scopeId));
            if (search.value && result.value && result.value.length) {
              _push2(`<div class="absolute z-10 top-full left-0 right-0 ring-1 bg-white dark:bg-gray-700 rounded-md dark:ring-gray-700 mt-2 py-1"${_scopeId}><!--[-->`);
              ssrRenderList(result.value, (p) => {
                _push2(`<button type="button" class="w-full text-left py-1.5 px-4 hover:bg-gray-100 dark:hover:bg-gray-900"${_scopeId}>${ssrInterpolate(p.name)}</button>`);
              });
              _push2(`<!--]--></div>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`</div>`);
            if (unref(form).items && unref(form).items.length) {
              _push2(`<div class="overflow-x-auto"${_scopeId}><h4 class="text-lg font-bold mt-6 pb-2"${_scopeId}>${ssrInterpolate(_ctx.$t("Sale Items"))}</h4><table class="w-full divide-y dark:divide-gray-700 min-w-[500px]"${_scopeId}><thead${_scopeId}><tr${_scopeId}><th class="text-mute"${_scopeId}>#</th><th class="text-mute text-left"${_scopeId}>${ssrInterpolate(_ctx.$t("Product"))}</th><th class="text-mute"${_scopeId}>${ssrInterpolate(_ctx.$t("Price"))}</th><th class="text-mute"${_scopeId}>${ssrInterpolate(_ctx.$t("Quantity"))}</th>`);
              if (unref(page).props.settings.show_tax == 1) {
                _push2(`<th class="text-mute"${_scopeId}>${ssrInterpolate(_ctx.$t("Tax"))}</th>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(`<th class="text-mute"${_scopeId}>${ssrInterpolate(_ctx.$t("Total"))}</th></tr></thead><!--[-->`);
              ssrRenderList(unref(form).items, (item, index) => {
                var _a3, _b3, _c2;
                _push2(`<!--[-->`);
                if (item.product.has_variants && item.variations && item.variations.length) {
                  _push2(`<tbody${_scopeId}><tr${_scopeId}><td class="w-8 px-2 pt-4 pb-2"${_scopeId}>${ssrInterpolate(index + 1)}.</td><td class="p-2 font-bold"${_scopeId}><button type="button" class="link min-w-56 text-left"${_scopeId}>${ssrInterpolate(item.name)}</button></td><td class="p-2"${_scopeId}></td><td class="w-36 p-2"${_scopeId}></td>`);
                  if (unref(page).props.settings.show_tax == 1) {
                    _push2(`<th class="text-mute"${_scopeId}></th>`);
                  } else {
                    _push2(`<!---->`);
                  }
                  _push2(`<th class="text-mute text-right"${_scopeId}></th></tr><!--[-->`);
                  ssrRenderList(item.variations, (variation, vi) => {
                    var _a4, _b4, _c3;
                    _push2(`<!--[--><tr class="${ssrRenderClass(
                      unref(form).errors && (unref(form).errors["items." + index + ".variations." + vi + ".id"] || unref(form).errors["items." + index + ".variations." + vi + ".quantity"]) ? "bg-red-100 dark:bg-red-900" : ""
                    )}"${_scopeId}><td class="w-8 p-2"${_scopeId}></td><td class="p-2"${_scopeId}>${ssrInterpolate(_ctx.$meta(variation.meta))}</td><td class="p-2 w-24 text-right"${_scopeId}>${ssrInterpolate(_ctx.$number(unref(page).props.settings.show_tax == 1 ? variation.net_price : variation.unit_price))}</td><td class="w-36 p-2"${_scopeId}><div class="relative"${_scopeId}>`);
                    _push2(ssrRenderComponent(unref(_sfc_main$7), {
                      min: 0,
                      label: "",
                      "del-on": 0,
                      type: "number",
                      onChange: () => {
                        item.quantity = item.variations.reduce((a, v) => Number(v.quantity) + a, 0);
                        unref(calculate_item)(item, unref(form).calculate_on);
                        unref(saveForm)();
                      },
                      modelValue: variation.quantity,
                      "onUpdate:modelValue": ($event) => variation.quantity = $event,
                      placeholder: _ctx.$t("Quantity"),
                      max: item.selected_store && item.selected_store[0] ? (_a4 = item.selected_store[0].pivot) == null ? void 0 : _a4.quantity : null
                    }, null, _parent2, _scopeId));
                    if (variation.unit_id) {
                      _push2(`<!--[-->`);
                      if (item.product.unit.id == variation.unit_id) {
                        _push2(`<span class="absolute top-0 right-2 py-2 text-mute"${_scopeId}>${ssrInterpolate(item.product.unit.code)}</span>`);
                      } else {
                        _push2(`<span class="absolute top-0 right-2 py-2 text-mute"${_scopeId}>${ssrInterpolate((_c3 = (_b4 = item.product.unit) == null ? void 0 : _b4.subunits) == null ? void 0 : _c3.find((s) => s.id == variation.unit_id).code)}</span>`);
                      }
                      _push2(`<!--]-->`);
                    } else {
                      _push2(`<!---->`);
                    }
                    _push2(`</div></td>`);
                    if (unref(page).props.settings.show_tax == 1) {
                      _push2(`<td class="p-2 w-20 text-right"${_scopeId}>${ssrInterpolate(_ctx.$number(variation.tax_amount))}</td>`);
                    } else {
                      _push2(`<!---->`);
                    }
                    _push2(`<td class="p-2 w-24 text-right"${_scopeId}>${ssrInterpolate(_ctx.$number(variation.total))}</td></tr>`);
                    if (unref(form).errors && (unref(form).errors["items." + index + ".variations." + vi + ".id"] || unref(form).errors["items." + index + ".variations." + vi + ".quantity"])) {
                      _push2(`<tr class="bg-red-100 dark:bg-red-900"${_scopeId}><td colspan="100%"${_scopeId}><div class="py-1 px-4 text-red-500 text-sm"${_scopeId}>`);
                      if (unref(form).errors["items." + index + ".variations." + vi + ".id"]) {
                        _push2(`<div${_scopeId}>${ssrInterpolate(unref(form).errors["items." + index + ".variations." + vi + ".id"].toString().replace(
                          "items." + index + ".variations." + vi + ".id",
                          _ctx.$t("item") + " #" + (index + 1) + " " + _ctx.$t("variation") + " #" + (vi + 1)
                        ))}</div>`);
                      } else {
                        _push2(`<!---->`);
                      }
                      if (unref(form).errors["items." + index + ".variations." + vi + ".quantity"]) {
                        _push2(`<div${_scopeId}>${ssrInterpolate(unref(form).errors["items." + index + ".variations." + vi + ".quantity"].toString().replace(
                          "items." + index + ".variations." + vi + ".quantity",
                          _ctx.$t("item") + " #" + (index + 1) + " " + _ctx.$t("variation") + " #" + (vi + 1) + " " + _ctx.$t("quantity")
                        ).split("when")[0])}</div>`);
                      } else {
                        _push2(`<!---->`);
                      }
                      _push2(`</div></td></tr>`);
                    } else {
                      _push2(`<!---->`);
                    }
                    _push2(`<!--]-->`);
                  });
                  _push2(`<!--]--></tbody>`);
                } else {
                  _push2(`<tbody class="${ssrRenderClass(
                    unref(form).errors && (unref(form).errors["items." + index + ".quantity"] || unref(form).errors["items." + index + ".variations"]) ? "bg-red-100 dark:bg-red-800" : ""
                  )}"${_scopeId}><tr${_scopeId}><td class="w-8 p-2"${_scopeId}>${ssrInterpolate(index + 1)}.</td><td class="p-2"${_scopeId}><button type="button" class="link min-w-56 text-left"${_scopeId}>${ssrInterpolate(item.name)}</button></td><td class="p-2 w-24 text-right"${_scopeId}>${ssrInterpolate(_ctx.$number(unref(page).props.settings.show_tax == 1 ? item.net_price : item.unit_price))}</td><td class="w-36 p-2"${_scopeId}><div class="relative"${_scopeId}>`);
                  _push2(ssrRenderComponent(unref(_sfc_main$7), {
                    min: 0,
                    label: "",
                    "del-on": 0,
                    type: "number",
                    modelValue: item.quantity,
                    "onUpdate:modelValue": ($event) => item.quantity = $event,
                    placeholder: _ctx.$t("Quantity"),
                    onChange: () => {
                      selectedItem.value = item;
                      unref(updateItem)();
                    },
                    max: item.selected_store && item.selected_store[0] ? (_a3 = item.selected_store[0].pivot) == null ? void 0 : _a3.quantity : null
                  }, null, _parent2, _scopeId));
                  if (item.unit_id) {
                    _push2(`<!--[-->`);
                    if (item.product.unit.id == item.unit_id) {
                      _push2(`<span class="absolute top-0 right-2 py-2 text-mute"${_scopeId}>${ssrInterpolate(item.product.unit.code)}</span>`);
                    } else {
                      _push2(`<span class="absolute top-0 right-2 py-2 text-mute"${_scopeId}>${ssrInterpolate((_c2 = (_b3 = item.product.unit) == null ? void 0 : _b3.subunits) == null ? void 0 : _c2.find((s) => s.id == item.unit_id).code)}</span>`);
                    }
                    _push2(`<!--]-->`);
                  } else {
                    _push2(`<!---->`);
                  }
                  _push2(`</div></td>`);
                  if (unref(page).props.settings.show_tax == 1) {
                    _push2(`<td class="p-2 w-20 text-right"${_scopeId}>${ssrInterpolate(_ctx.$number(item.tax_amount))}</td>`);
                  } else {
                    _push2(`<!---->`);
                  }
                  _push2(`<td class="p-2 w-24 text-right"${_scopeId}>${ssrInterpolate(_ctx.$number(item.total))}</td></tr>`);
                  if (unref(form).errors && (unref(form).errors["items." + index + ".quantity"] || unref(form).errors["items." + index + ".variations"])) {
                    _push2(`<tr${_scopeId}><td colspan="100%"${_scopeId}><div class="py-1 px-4 text-red-500 text-sm"${_scopeId}>`);
                    if (unref(form).errors["items." + index + ".quantity"]) {
                      _push2(`<div${_scopeId}>${ssrInterpolate(unref(form).errors["items." + index + ".quantity"].toString().replace("items." + index + ".quantity", _ctx.$t("item") + " #" + (index + 1) + " " + _ctx.$t("quantity")))}</div>`);
                    } else {
                      _push2(`<!---->`);
                    }
                    if (unref(form).errors["items." + index + ".variations"]) {
                      _push2(`<div${_scopeId}>${ssrInterpolate(unref(form).errors["items." + index + ".variations"].toString().replace("items." + index + ".variations", _ctx.$t("item") + " #" + (index + 1) + " " + _ctx.$t("variations")))}</div>`);
                    } else {
                      _push2(`<!---->`);
                    }
                    _push2(`</div></td></tr>`);
                  } else {
                    _push2(`<!---->`);
                  }
                  _push2(`</tbody>`);
                }
                _push2(`<!--]-->`);
              });
              _push2(`<!--]--><tfoot class="divide-y dark:divide-gray-700"${_scopeId}>`);
              if (unref(page).props.settings.show_tax == 1) {
                _push2(`<tr${_scopeId}><th colspan="3" class="p-2 font-bold text-right text-lg"${_scopeId}>${ssrInterpolate(_ctx.$t("Total"))}</th><th class="p-2 font-bold text-right text-lg"${_scopeId}>${ssrInterpolate(_ctx.$decimal_qty(unref(form).items.reduce((a, i) => Number(i.quantity) + a, 0)))}</th><th class="p-2 font-bold text-right text-lg"${_scopeId}>${ssrInterpolate(_ctx.$decimal(unref(form).items.reduce((a, i) => Number(i.total_tax_amount) + a, 0)))}</th><th class="p-2 font-bold text-right text-lg"${_scopeId}>${ssrInterpolate(_ctx.$decimal(unref(form).items.reduce((a, i) => Number(i.total) + a, 0)))}</th><th${_scopeId}></th></tr>`);
              } else {
                _push2(`<!--[-->`);
                if (_ctx.$decimal(
                  unref(form).items.reduce((a, i) => Number(i.total_tax_amount) + a, 0),
                  true
                ) > 0) {
                  _push2(`<!--[--><tr${_scopeId}><th colspan="4" class="p-2 font-bold text-right text-lg"${_scopeId}>${ssrInterpolate(_ctx.$t("Subtotal"))}</th><th class="p-2 font-bold text-right text-lg"${_scopeId}>${ssrInterpolate(_ctx.$decimal(unref(form).items.reduce((a, i) => Number(i.subtotal) + a, 0)))}</th></tr><tr${_scopeId}><th colspan="4" class="p-2 font-bold text-right text-lg"${_scopeId}>${ssrInterpolate(_ctx.$t("Tax"))}</th><th class="p-2 font-bold text-right text-lg"${_scopeId}>${ssrInterpolate(_ctx.$decimal(unref(form).items.reduce((a, i) => Number(i.total_tax_amount) + a, 0)))}</th></tr><!--]-->`);
                } else if (unref(page).props.settings.show_zero_taxes == 1) {
                  _push2(`<tr${_scopeId}><th colspan="4" class="p-2 font-bold text-right text-lg"${_scopeId}>${ssrInterpolate(_ctx.$t("Tax"))}</th><th class="p-2 font-bold text-right text-lg"${_scopeId}>${ssrInterpolate(_ctx.$decimal(unref(form).items.reduce((a, i) => Number(i.total_tax_amount) + a, 0)))}</th></tr>`);
                } else {
                  _push2(`<!---->`);
                }
                _push2(`<tr${_scopeId}><th colspan="4" class="p-2 font-bold text-right text-lg"${_scopeId}>${ssrInterpolate(_ctx.$t("Total"))}</th><th class="p-2 font-bold text-right text-lg"${_scopeId}>${ssrInterpolate(_ctx.$decimal(unref(form).items.reduce((a, i) => Number(i.total) + a, 0)))}</th><th${_scopeId}></th></tr><!--]-->`);
              }
              _push2(`</tfoot></table></div>`);
            } else {
              _push2(`<label for="product-search" class="w-full block mt-4 rounded-md bg-gray-100 dark:bg-gray-800 py-2 px-4 text-primary-600 dark:text-primary-400"${_scopeId}>${ssrInterpolate(_ctx.$t("Please add at least one product."))}</label>`);
            }
            _push2(ssrRenderComponent(unref(_sfc_main$b), {
              message: unref(form).errors.items
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-full flex flex-col gap-6"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$c), {
              errors: unref(form).errors,
              custom_fields: __props.custom_fields,
              extra_attributes: unref(form).extra_attributes,
              onUpdate: unref(saveForm)
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$d), {
              onChange: unref(saveForm),
              label: _ctx.$t("Details"),
              modelValue: unref(form).details,
              "onUpdate:modelValue": ($event) => unref(form).details = $event,
              error: _ctx.$page.props.errors.details
            }, null, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$6), {
                  type: "date",
                  id: "date",
                  onChange: unref(saveForm),
                  label: _ctx.$t("Date"),
                  modelValue: unref(form).date,
                  "onUpdate:modelValue": ($event) => unref(form).date = $event,
                  error: unref(form).errors.date
                }, null, 8, ["onChange", "label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$7), {
                  id: "reference",
                  onChange: unref(saveForm),
                  label: _ctx.$t("Reference"),
                  modelValue: unref(form).reference,
                  "onUpdate:modelValue": ($event) => unref(form).reference = $event,
                  error: unref(form).errors.reference
                }, null, 8, ["onChange", "label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$8), {
                  json: true,
                  valueKey: "id",
                  id: "customer_id",
                  labelKey: "company",
                  onChange: unref(saveForm),
                  searchable: true,
                  label: _ctx.$t("Customer"),
                  modelValue: unref(form).customer_id,
                  "onUpdate:modelValue": ($event) => unref(form).customer_id = $event,
                  suggestions: unref(T)("search.customers"),
                  error: _ctx.$page.props.errors.customer_id
                }, null, 8, ["onChange", "label", "modelValue", "onUpdate:modelValue", "suggestions", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$6), {
                  id: "due_date",
                  onChange: unref(saveForm),
                  label: _ctx.$t("Due Date"),
                  modelValue: unref(form).due_date,
                  "onUpdate:modelValue": ($event) => unref(form).due_date = $event,
                  error: unref(form).errors.due_date
                }, null, 8, ["onChange", "label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$9), {
                  multiple: "",
                  id: "attachments",
                  label: _ctx.$t("Attachments"),
                  modelValue: unref(form).attachments,
                  "onUpdate:modelValue": ($event) => unref(form).attachments = $event,
                  error: unref(form).errors.attachments,
                  accept: ((_b2 = _ctx.$page.props.settings) == null ? void 0 : _b2.attachment_exts) || ".jpg,.png,.pdf,.xlsx,.docx,.zip"
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error", "accept"])
              ]),
              __props.current && __props.current.attachments && __props.current.attachments.length ? (openBlock(), createBlock("div", {
                key: 0,
                class: "col-span-full"
              }, [
                createVNode(unref(_sfc_main$a), {
                  attachments: __props.current.attachments || []
                }, null, 8, ["attachments"])
              ])) : createCommentVNode("", true),
              createVNode("div", { class: "col-span-full" }, [
                createVNode("div", { class: "relative" }, [
                  createVNode(unref(_sfc_main$7), {
                    label: "",
                    modelValue: search.value,
                    "onUpdate:modelValue": ($event) => search.value = $event,
                    id: "product-search",
                    placeholder: _ctx.$t("Scan barcode or type to search")
                  }, null, 8, ["modelValue", "onUpdate:modelValue", "placeholder"]),
                  search.value && result.value && result.value.length ? (openBlock(), createBlock("div", {
                    key: 0,
                    class: "absolute z-10 top-full left-0 right-0 ring-1 bg-white dark:bg-gray-700 rounded-md dark:ring-gray-700 mt-2 py-1"
                  }, [
                    (openBlock(true), createBlock(Fragment, null, renderList(result.value, (p) => {
                      return openBlock(), createBlock("button", {
                        key: p.id,
                        type: "button",
                        onClick: ($event) => addItem(p),
                        class: "w-full text-left py-1.5 px-4 hover:bg-gray-100 dark:hover:bg-gray-900"
                      }, toDisplayString(p.name), 9, ["onClick"]);
                    }), 128))
                  ])) : createCommentVNode("", true)
                ]),
                unref(form).items && unref(form).items.length ? (openBlock(), createBlock("div", {
                  key: 0,
                  class: "overflow-x-auto"
                }, [
                  createVNode("h4", { class: "text-lg font-bold mt-6 pb-2" }, toDisplayString(_ctx.$t("Sale Items")), 1),
                  createVNode("table", { class: "w-full divide-y dark:divide-gray-700 min-w-[500px]" }, [
                    createVNode("thead", null, [
                      createVNode("tr", null, [
                        createVNode("th", { class: "text-mute" }, "#"),
                        createVNode("th", { class: "text-mute text-left" }, toDisplayString(_ctx.$t("Product")), 1),
                        createVNode("th", { class: "text-mute" }, toDisplayString(_ctx.$t("Price")), 1),
                        createVNode("th", { class: "text-mute" }, toDisplayString(_ctx.$t("Quantity")), 1),
                        unref(page).props.settings.show_tax == 1 ? (openBlock(), createBlock("th", {
                          key: 0,
                          class: "text-mute"
                        }, toDisplayString(_ctx.$t("Tax")), 1)) : createCommentVNode("", true),
                        createVNode("th", { class: "text-mute" }, toDisplayString(_ctx.$t("Total")), 1)
                      ])
                    ]),
                    (openBlock(true), createBlock(Fragment, null, renderList(unref(form).items, (item, index) => {
                      var _a3, _b3, _c2;
                      return openBlock(), createBlock(Fragment, {
                        key: item.code
                      }, [
                        item.product.has_variants && item.variations && item.variations.length ? (openBlock(), createBlock("tbody", { key: 0 }, [
                          createVNode("tr", null, [
                            createVNode("td", { class: "w-8 px-2 pt-4 pb-2" }, toDisplayString(index + 1) + ".", 1),
                            createVNode("td", { class: "p-2 font-bold" }, [
                              createVNode("button", {
                                type: "button",
                                onClick: ($event) => unref(selectItem)(item),
                                class: "link min-w-56 text-left"
                              }, toDisplayString(item.name), 9, ["onClick"])
                            ]),
                            createVNode("td", { class: "p-2" }),
                            createVNode("td", { class: "w-36 p-2" }),
                            unref(page).props.settings.show_tax == 1 ? (openBlock(), createBlock("th", {
                              key: 0,
                              class: "text-mute"
                            })) : createCommentVNode("", true),
                            createVNode("th", { class: "text-mute text-right" })
                          ]),
                          (openBlock(true), createBlock(Fragment, null, renderList(item.variations, (variation, vi) => {
                            var _a4, _b4, _c3;
                            return openBlock(), createBlock(Fragment, {
                              key: variation.id
                            }, [
                              createVNode("tr", {
                                class: unref(form).errors && (unref(form).errors["items." + index + ".variations." + vi + ".id"] || unref(form).errors["items." + index + ".variations." + vi + ".quantity"]) ? "bg-red-100 dark:bg-red-900" : ""
                              }, [
                                createVNode("td", { class: "w-8 p-2" }),
                                createVNode("td", { class: "p-2" }, toDisplayString(_ctx.$meta(variation.meta)), 1),
                                createVNode("td", { class: "p-2 w-24 text-right" }, toDisplayString(_ctx.$number(unref(page).props.settings.show_tax == 1 ? variation.net_price : variation.unit_price)), 1),
                                createVNode("td", { class: "w-36 p-2" }, [
                                  createVNode("div", { class: "relative" }, [
                                    createVNode(unref(_sfc_main$7), {
                                      min: 0,
                                      label: "",
                                      "del-on": 0,
                                      type: "number",
                                      onChange: () => {
                                        item.quantity = item.variations.reduce((a, v) => Number(v.quantity) + a, 0);
                                        unref(calculate_item)(item, unref(form).calculate_on);
                                        unref(saveForm)();
                                      },
                                      modelValue: variation.quantity,
                                      "onUpdate:modelValue": ($event) => variation.quantity = $event,
                                      placeholder: _ctx.$t("Quantity"),
                                      max: item.selected_store && item.selected_store[0] ? (_a4 = item.selected_store[0].pivot) == null ? void 0 : _a4.quantity : null
                                    }, null, 8, ["onChange", "modelValue", "onUpdate:modelValue", "placeholder", "max"]),
                                    variation.unit_id ? (openBlock(), createBlock(Fragment, { key: 0 }, [
                                      item.product.unit.id == variation.unit_id ? (openBlock(), createBlock("span", {
                                        key: 0,
                                        class: "absolute top-0 right-2 py-2 text-mute"
                                      }, toDisplayString(item.product.unit.code), 1)) : (openBlock(), createBlock("span", {
                                        key: 1,
                                        class: "absolute top-0 right-2 py-2 text-mute"
                                      }, toDisplayString((_c3 = (_b4 = item.product.unit) == null ? void 0 : _b4.subunits) == null ? void 0 : _c3.find((s) => s.id == variation.unit_id).code), 1))
                                    ], 64)) : createCommentVNode("", true)
                                  ])
                                ]),
                                unref(page).props.settings.show_tax == 1 ? (openBlock(), createBlock("td", {
                                  key: 0,
                                  class: "p-2 w-20 text-right"
                                }, toDisplayString(_ctx.$number(variation.tax_amount)), 1)) : createCommentVNode("", true),
                                createVNode("td", { class: "p-2 w-24 text-right" }, toDisplayString(_ctx.$number(variation.total)), 1)
                              ], 2),
                              unref(form).errors && (unref(form).errors["items." + index + ".variations." + vi + ".id"] || unref(form).errors["items." + index + ".variations." + vi + ".quantity"]) ? (openBlock(), createBlock("tr", {
                                key: 0,
                                class: "bg-red-100 dark:bg-red-900"
                              }, [
                                createVNode("td", { colspan: "100%" }, [
                                  createVNode("div", { class: "py-1 px-4 text-red-500 text-sm" }, [
                                    unref(form).errors["items." + index + ".variations." + vi + ".id"] ? (openBlock(), createBlock("div", { key: 0 }, toDisplayString(unref(form).errors["items." + index + ".variations." + vi + ".id"].toString().replace(
                                      "items." + index + ".variations." + vi + ".id",
                                      _ctx.$t("item") + " #" + (index + 1) + " " + _ctx.$t("variation") + " #" + (vi + 1)
                                    )), 1)) : createCommentVNode("", true),
                                    unref(form).errors["items." + index + ".variations." + vi + ".quantity"] ? (openBlock(), createBlock("div", { key: 1 }, toDisplayString(unref(form).errors["items." + index + ".variations." + vi + ".quantity"].toString().replace(
                                      "items." + index + ".variations." + vi + ".quantity",
                                      _ctx.$t("item") + " #" + (index + 1) + " " + _ctx.$t("variation") + " #" + (vi + 1) + " " + _ctx.$t("quantity")
                                    ).split("when")[0]), 1)) : createCommentVNode("", true)
                                  ])
                                ])
                              ])) : createCommentVNode("", true)
                            ], 64);
                          }), 128))
                        ])) : (openBlock(), createBlock("tbody", {
                          key: 1,
                          class: unref(form).errors && (unref(form).errors["items." + index + ".quantity"] || unref(form).errors["items." + index + ".variations"]) ? "bg-red-100 dark:bg-red-800" : ""
                        }, [
                          createVNode("tr", null, [
                            createVNode("td", { class: "w-8 p-2" }, toDisplayString(index + 1) + ".", 1),
                            createVNode("td", { class: "p-2" }, [
                              createVNode("button", {
                                type: "button",
                                onClick: ($event) => unref(selectItem)(item),
                                class: "link min-w-56 text-left"
                              }, toDisplayString(item.name), 9, ["onClick"])
                            ]),
                            createVNode("td", { class: "p-2 w-24 text-right" }, toDisplayString(_ctx.$number(unref(page).props.settings.show_tax == 1 ? item.net_price : item.unit_price)), 1),
                            createVNode("td", { class: "w-36 p-2" }, [
                              createVNode("div", { class: "relative" }, [
                                createVNode(unref(_sfc_main$7), {
                                  min: 0,
                                  label: "",
                                  "del-on": 0,
                                  type: "number",
                                  modelValue: item.quantity,
                                  "onUpdate:modelValue": ($event) => item.quantity = $event,
                                  placeholder: _ctx.$t("Quantity"),
                                  onChange: () => {
                                    selectedItem.value = item;
                                    unref(updateItem)();
                                  },
                                  max: item.selected_store && item.selected_store[0] ? (_a3 = item.selected_store[0].pivot) == null ? void 0 : _a3.quantity : null
                                }, null, 8, ["modelValue", "onUpdate:modelValue", "placeholder", "onChange", "max"]),
                                item.unit_id ? (openBlock(), createBlock(Fragment, { key: 0 }, [
                                  item.product.unit.id == item.unit_id ? (openBlock(), createBlock("span", {
                                    key: 0,
                                    class: "absolute top-0 right-2 py-2 text-mute"
                                  }, toDisplayString(item.product.unit.code), 1)) : (openBlock(), createBlock("span", {
                                    key: 1,
                                    class: "absolute top-0 right-2 py-2 text-mute"
                                  }, toDisplayString((_c2 = (_b3 = item.product.unit) == null ? void 0 : _b3.subunits) == null ? void 0 : _c2.find((s) => s.id == item.unit_id).code), 1))
                                ], 64)) : createCommentVNode("", true)
                              ])
                            ]),
                            unref(page).props.settings.show_tax == 1 ? (openBlock(), createBlock("td", {
                              key: 0,
                              class: "p-2 w-20 text-right"
                            }, toDisplayString(_ctx.$number(item.tax_amount)), 1)) : createCommentVNode("", true),
                            createVNode("td", { class: "p-2 w-24 text-right" }, toDisplayString(_ctx.$number(item.total)), 1)
                          ]),
                          unref(form).errors && (unref(form).errors["items." + index + ".quantity"] || unref(form).errors["items." + index + ".variations"]) ? (openBlock(), createBlock("tr", { key: 0 }, [
                            createVNode("td", { colspan: "100%" }, [
                              createVNode("div", { class: "py-1 px-4 text-red-500 text-sm" }, [
                                unref(form).errors["items." + index + ".quantity"] ? (openBlock(), createBlock("div", { key: 0 }, toDisplayString(unref(form).errors["items." + index + ".quantity"].toString().replace("items." + index + ".quantity", _ctx.$t("item") + " #" + (index + 1) + " " + _ctx.$t("quantity"))), 1)) : createCommentVNode("", true),
                                unref(form).errors["items." + index + ".variations"] ? (openBlock(), createBlock("div", { key: 1 }, toDisplayString(unref(form).errors["items." + index + ".variations"].toString().replace("items." + index + ".variations", _ctx.$t("item") + " #" + (index + 1) + " " + _ctx.$t("variations"))), 1)) : createCommentVNode("", true)
                              ])
                            ])
                          ])) : createCommentVNode("", true)
                        ], 2))
                      ], 64);
                    }), 128)),
                    createVNode("tfoot", { class: "divide-y dark:divide-gray-700" }, [
                      unref(page).props.settings.show_tax == 1 ? (openBlock(), createBlock("tr", { key: 0 }, [
                        createVNode("th", {
                          colspan: "3",
                          class: "p-2 font-bold text-right text-lg"
                        }, toDisplayString(_ctx.$t("Total")), 1),
                        createVNode("th", { class: "p-2 font-bold text-right text-lg" }, toDisplayString(_ctx.$decimal_qty(unref(form).items.reduce((a, i) => Number(i.quantity) + a, 0))), 1),
                        createVNode("th", { class: "p-2 font-bold text-right text-lg" }, toDisplayString(_ctx.$decimal(unref(form).items.reduce((a, i) => Number(i.total_tax_amount) + a, 0))), 1),
                        createVNode("th", { class: "p-2 font-bold text-right text-lg" }, toDisplayString(_ctx.$decimal(unref(form).items.reduce((a, i) => Number(i.total) + a, 0))), 1),
                        createVNode("th")
                      ])) : (openBlock(), createBlock(Fragment, { key: 1 }, [
                        _ctx.$decimal(
                          unref(form).items.reduce((a, i) => Number(i.total_tax_amount) + a, 0),
                          true
                        ) > 0 ? (openBlock(), createBlock(Fragment, { key: 0 }, [
                          createVNode("tr", null, [
                            createVNode("th", {
                              colspan: "4",
                              class: "p-2 font-bold text-right text-lg"
                            }, toDisplayString(_ctx.$t("Subtotal")), 1),
                            createVNode("th", { class: "p-2 font-bold text-right text-lg" }, toDisplayString(_ctx.$decimal(unref(form).items.reduce((a, i) => Number(i.subtotal) + a, 0))), 1)
                          ]),
                          createVNode("tr", null, [
                            createVNode("th", {
                              colspan: "4",
                              class: "p-2 font-bold text-right text-lg"
                            }, toDisplayString(_ctx.$t("Tax")), 1),
                            createVNode("th", { class: "p-2 font-bold text-right text-lg" }, toDisplayString(_ctx.$decimal(unref(form).items.reduce((a, i) => Number(i.total_tax_amount) + a, 0))), 1)
                          ])
                        ], 64)) : unref(page).props.settings.show_zero_taxes == 1 ? (openBlock(), createBlock("tr", { key: 1 }, [
                          createVNode("th", {
                            colspan: "4",
                            class: "p-2 font-bold text-right text-lg"
                          }, toDisplayString(_ctx.$t("Tax")), 1),
                          createVNode("th", { class: "p-2 font-bold text-right text-lg" }, toDisplayString(_ctx.$decimal(unref(form).items.reduce((a, i) => Number(i.total_tax_amount) + a, 0))), 1)
                        ])) : createCommentVNode("", true),
                        createVNode("tr", null, [
                          createVNode("th", {
                            colspan: "4",
                            class: "p-2 font-bold text-right text-lg"
                          }, toDisplayString(_ctx.$t("Total")), 1),
                          createVNode("th", { class: "p-2 font-bold text-right text-lg" }, toDisplayString(_ctx.$decimal(unref(form).items.reduce((a, i) => Number(i.total) + a, 0))), 1),
                          createVNode("th")
                        ])
                      ], 64))
                    ])
                  ])
                ])) : (openBlock(), createBlock("label", {
                  key: 1,
                  for: "product-search",
                  class: "w-full block mt-4 rounded-md bg-gray-100 dark:bg-gray-800 py-2 px-4 text-primary-600 dark:text-primary-400"
                }, toDisplayString(_ctx.$t("Please add at least one product.")), 1)),
                createVNode(unref(_sfc_main$b), {
                  message: unref(form).errors.items
                }, null, 8, ["message"])
              ]),
              createVNode("div", { class: "col-span-full flex flex-col gap-6" }, [
                createVNode(unref(_sfc_main$c), {
                  errors: unref(form).errors,
                  custom_fields: __props.custom_fields,
                  extra_attributes: unref(form).extra_attributes,
                  onUpdate: unref(saveForm)
                }, null, 8, ["errors", "custom_fields", "extra_attributes", "onUpdate"]),
                createVNode(unref(_sfc_main$d), {
                  onChange: unref(saveForm),
                  label: _ctx.$t("Details"),
                  modelValue: unref(form).details,
                  "onUpdate:modelValue": ($event) => unref(form).details = $event,
                  error: _ctx.$page.props.errors.details
                }, null, 8, ["onChange", "label", "modelValue", "onUpdate:modelValue", "error"])
              ])
            ];
          }
        }),
        actions: withCtx((_, _push2, _parent2, _scopeId) => {
          var _a2, _b2, _c2, _d2;
          if (_push2) {
            _push2(`<div class="w-full"${_scopeId}>`);
            if (unref(form).progress) {
              _push2(`<div class="-mt-6 -mx-6 pb-1.5"${_scopeId}><progress max="100"${ssrRenderAttr("value", (_a2 = unref(form).progress) == null ? void 0 : _a2.percentage)} class="appearance-none w-full h-0.5 rounded-md bg-gray-200 dark:bg-gray-700"${_scopeId}>${ssrInterpolate((_b2 = unref(form).progress) == null ? void 0 : _b2.percentage)}% </progress></div>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<div class="w-full flex items-center justify-between"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$3), {
              type: "button",
              onClick: unref(resetForm),
              class: "me-3"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Reset"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Reset")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`<div class="flex items-center justify-end"${_scopeId}>`);
            if (__props.current) {
              _push2(`<button type="button" class="btn-secondary"${ssrRenderAttr("loading", unref(form).processing)}${ssrIncludeBooleanAttr(unref(form).processing) ? " disabled" : ""}${_scopeId}>${ssrInterpolate(_ctx.$t("Save & go to listing"))}</button>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(ssrRenderComponent(unref(_sfc_main$4), {
              on: unref(form).recentlySuccessful,
              class: "ms-3 me-3"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Saved."))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Saved.")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$5), {
              type: "button",
              onClick: handleSubmit,
              class: { "opacity-25": unref(form).processing },
              loading: unref(form).processing
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Save"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div></div></div>`);
          } else {
            return [
              createVNode("div", { class: "w-full" }, [
                unref(form).progress ? (openBlock(), createBlock("div", {
                  key: 0,
                  class: "-mt-6 -mx-6 pb-1.5"
                }, [
                  createVNode("progress", {
                    max: "100",
                    value: (_c2 = unref(form).progress) == null ? void 0 : _c2.percentage,
                    class: "appearance-none w-full h-0.5 rounded-md bg-gray-200 dark:bg-gray-700"
                  }, toDisplayString((_d2 = unref(form).progress) == null ? void 0 : _d2.percentage) + "% ", 9, ["value"])
                ])) : createCommentVNode("", true),
                createVNode("div", { class: "w-full flex items-center justify-between" }, [
                  createVNode(unref(_sfc_main$3), {
                    type: "button",
                    onClick: unref(resetForm),
                    class: "me-3"
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(_ctx.$t("Reset")), 1)
                    ]),
                    _: 1
                  }, 8, ["onClick"]),
                  createVNode("div", { class: "flex items-center justify-end" }, [
                    __props.current ? (openBlock(), createBlock("button", {
                      key: 0,
                      type: "button",
                      class: "btn-secondary",
                      loading: unref(form).processing,
                      disabled: unref(form).processing,
                      onClick: (e) => handleSubmit(e, true)
                    }, toDisplayString(_ctx.$t("Save & go to listing")), 9, ["loading", "disabled", "onClick"])) : createCommentVNode("", true),
                    createVNode(unref(_sfc_main$4), {
                      on: unref(form).recentlySuccessful,
                      class: "ms-3 me-3"
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(_ctx.$t("Saved.")), 1)
                      ]),
                      _: 1
                    }, 8, ["on"]),
                    createVNode(unref(_sfc_main$5), {
                      type: "button",
                      onClick: handleSubmit,
                      class: { "opacity-25": unref(form).processing },
                      loading: unref(form).processing
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
                      ]),
                      _: 1
                    }, 8, ["class", "loading"])
                  ])
                ])
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      if (unref(variantModal)) {
        _push(ssrRenderComponent(unref(SelectVariant), {
          item: unref(currentItem),
          show: unref(variantModal),
          onClose: () => {
            unref(currentItem).variations = unref(currentItem).variations.filter((v) => v.id);
            unref(form).items = unref(form).items.map((i) => i.product_id == unref(currentItem).product_id ? unref(calculate_item)(unref(currentItem), unref(form).calculate_on) : i);
            variantModal.value = false;
          },
          onUpdate: (item) => {
            item.variations = item.variations.filter((v) => v.id);
            unref(form).items = unref(form).items.map((i) => i.product_id == item.product_id ? unref(calculate_item)(item, unref(form).calculate_on) : i);
            unref(saveForm)();
            variantModal.value = false;
          }
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
      _push(ssrRenderComponent(unref(_sfc_main$e), {
        show: unref(openItemModal),
        "max-width": "xl",
        onClose: ($event) => openItemModal.value = false,
        overflow: true,
        backdrop: false
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          var _a2, _b2, _c2, _d2, _e2, _f2, _g2, _h;
          if (_push2) {
            if (unref(selectedItem)) {
              _push2(`<div${_scopeId}><div class="border-b border-gray-200 dark:border-gray-700 px-4 sm:px-6 py-4"${_scopeId}><div class="sm:flex sm:items-baseline sm:justify-between"${_scopeId}><div class="sm:w-0 sm:flex-1"${_scopeId}><h1 class="text-base font-semibold text-focus"${_scopeId}>${ssrInterpolate(_ctx.$t("Edit {x}", { x: unref(selectedItem).name }))}</h1><p class="mt-1 truncate text-sm text-mute"${_scopeId}>${ssrInterpolate(_ctx.$t("Please update the details below"))}</p></div></div></div><div${_scopeId}>`);
              if (unref(selectedItem).product.has_variants && unref(selectedItem).variations && unref(selectedItem).variations.length) {
                _push2(`<div class="divide-y dark:divide-gray-700"${_scopeId}><!--[-->`);
                ssrRenderList(unref(selectedItem).variations, (v, vi) => {
                  var _a3, _b3, _c3, _d3;
                  _push2(`<div class="p-6 grid grid-cols-6 gap-6"${_scopeId}>`);
                  if (v.code) {
                    _push2(`<!--[--><div class="col-span-full font-bold text-mute"${_scopeId}>${ssrInterpolate(_ctx.$t("Code"))}: <span class="text-focus"${_scopeId}>${ssrInterpolate(v.code)}</span> (${ssrInterpolate(_ctx.$meta(v.meta))}) </div><div class="col-span-6 sm:col-span-2"${_scopeId}>`);
                    _push2(ssrRenderComponent(unref(_sfc_main$7), {
                      type: "number",
                      id: "item-quantity-v" + vi,
                      label: _ctx.$t("Quantity"),
                      modelValue: unref(selectedItem).variations[vi].quantity,
                      "onUpdate:modelValue": ($event) => unref(selectedItem).variations[vi].quantity = $event
                    }, null, _parent2, _scopeId));
                    _push2(`</div>`);
                    if ((_b3 = (_a3 = unref(selectedItem).product.unit) == null ? void 0 : _a3.subunits) == null ? void 0 : _b3.length) {
                      _push2(`<div class="col-span-6 sm:col-span-4"${_scopeId}>`);
                      _push2(ssrRenderComponent(unref(_sfc_main$8), {
                        json: true,
                        "value-key": "id",
                        id: "item-unit",
                        "label-key": "name",
                        searchable: false,
                        label: _ctx.$t("Unit"),
                        modelValue: unref(selectedItem).variations[vi].unit_id,
                        "onUpdate:modelValue": ($event) => unref(selectedItem).variations[vi].unit_id = $event,
                        suggestions: [{ ...unref(selectedItem).product.unit, subunits: null }, ...unref(selectedItem).product.unit.subunits],
                        onChange: () => {
                          var _a4, _b4;
                          if (unref(selectedItem).variations[vi].unit_id == unref(selectedItem).product.unit.id) {
                            unref(selectedItem).variations[vi].price = Number(unref(selectedItem).product.price);
                          } else {
                            unref(selectedItem).variations[vi].price = Number(
                              ((_b4 = (_a4 = unref(selectedItem).product.unit_prices) == null ? void 0 : _a4.find((p) => p.unit_id == unref(selectedItem).variations[vi].unit_id)) == null ? void 0 : _b4.price) || unref(convert_to_base_unit)(
                                unref(selectedItem),
                                unref(selectedItem).variations[vi].unit_id,
                                unref(selectedItem).variations[vi].price || unref(selectedItem).price
                              )
                            );
                          }
                        }
                      }, null, _parent2, _scopeId));
                      _push2(`</div>`);
                    } else {
                      _push2(`<!---->`);
                    }
                    _push2(`<div class="col-span-6 sm:col-span-4"${_scopeId}>`);
                    _push2(ssrRenderComponent(unref(_sfc_main$7), {
                      type: "number",
                      label: _ctx.$t("Price"),
                      id: "item-price-v" + vi,
                      modelValue: unref(selectedItem).variations[vi].price,
                      "onUpdate:modelValue": ($event) => unref(selectedItem).variations[vi].price = $event,
                      readonly: !unref(selectedItem).product.can_edit_price
                    }, null, _parent2, _scopeId));
                    _push2(`</div><div class="col-span-6 sm:col-span-2"${_scopeId}>`);
                    _push2(ssrRenderComponent(unref(_sfc_main$7), {
                      label: _ctx.$t("Discount"),
                      id: "item-discount-v" + vi,
                      onKeypress: unref(discount_keypress),
                      modelValue: unref(selectedItem).variations[vi].discount,
                      "onUpdate:modelValue": ($event) => unref(selectedItem).variations[vi].discount = $event,
                      onChange: (e) => {
                        var _a4;
                        let max_discount = ((_a4 = unref(usePage)().props.settings) == null ? void 0 : _a4.max_discount) || null;
                        if (unref(selectedItem).variations[vi].discount.includes("%")) {
                          if (Number(unref(selectedItem).variations[vi].discount.replace("%", "")) > Number(unref(selectedItem).product.max_discount)) {
                            unref(selectedItem).variations[vi].discount = Number(unref(selectedItem).product.max_discount) + "%";
                            unref(notify)({
                              group: "main",
                              type: "error",
                              title: _ctx.$t("You cannot apply discount more than {x}%", { x: Number(unref(selectedItem).product.max_discount) })
                            });
                          } else if (Number(unref(selectedItem).variations[vi].discount.replace("%", "")) > Number(max_discount)) {
                            unref(selectedItem).variations[vi].discount = Number(max_discount) + "%";
                            unref(notify)({
                              group: "main",
                              type: "error",
                              title: _ctx.$t("You cannot apply discount more than {x}%", { x: Number(max_discount) })
                            });
                          }
                        }
                      }
                    }, null, _parent2, _scopeId));
                    _push2(`</div><div class="${ssrRenderClass(((_d3 = (_c3 = unref(selectedItem).product.unit) == null ? void 0 : _c3.subunits) == null ? void 0 : _d3.length) ? "col-span-full" : "col-span-6 sm:col-span-4")}"${_scopeId}>`);
                    _push2(ssrRenderComponent(unref(_sfc_main$8), {
                      json: true,
                      "value-key": "id",
                      multiple: true,
                      "label-key": "name",
                      searchable: false,
                      suggestions: __props.taxes,
                      label: _ctx.$t("Taxes"),
                      id: "item-taxes-v" + vi,
                      modelValue: unref(selectedItem).variations[vi].taxes,
                      "onUpdate:modelValue": ($event) => unref(selectedItem).variations[vi].taxes = $event,
                      disabled: !unref(selectedItem).product.can_edit_taxes
                    }, null, _parent2, _scopeId));
                    _push2(`</div><!--]-->`);
                  } else {
                    _push2(`<div class="col-span-full"${_scopeId}>`);
                    _push2(ssrRenderComponent(unref(_sfc_main$3), {
                      type: "button",
                      onClick: () => {
                        currentItem.value = unref(selectedItem);
                        variantModal.value = true;
                      }
                    }, {
                      default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                        if (_push3) {
                          _push3(`${ssrInterpolate(_ctx.$t("Select {x}", { x: _ctx.$t("Variation") }))}`);
                        } else {
                          return [
                            createTextVNode(toDisplayString(_ctx.$t("Select {x}", { x: _ctx.$t("Variation") })), 1)
                          ];
                        }
                      }),
                      _: 2
                    }, _parent2, _scopeId));
                    _push2(`</div>`);
                  }
                  _push2(`</div>`);
                });
                _push2(`<!--]--></div>`);
              } else {
                _push2(`<div class="p-6 grid grid-cols-6 gap-6"${_scopeId}><div class="col-span-6 sm:col-span-2"${_scopeId}>`);
                _push2(ssrRenderComponent(unref(_sfc_main$7), {
                  type: "number",
                  id: "item-quantity",
                  label: _ctx.$t("Quantity"),
                  modelValue: unref(selectedItem).quantity,
                  "onUpdate:modelValue": ($event) => unref(selectedItem).quantity = $event
                }, null, _parent2, _scopeId));
                _push2(`</div>`);
                if ((_b2 = (_a2 = unref(selectedItem).product.unit) == null ? void 0 : _a2.subunits) == null ? void 0 : _b2.length) {
                  _push2(`<div class="col-span-6 sm:col-span-4"${_scopeId}>`);
                  _push2(ssrRenderComponent(unref(_sfc_main$8), {
                    json: true,
                    "value-key": "id",
                    id: "item-unit",
                    "label-key": "name",
                    searchable: false,
                    label: _ctx.$t("Unit"),
                    modelValue: unref(selectedItem).unit_id,
                    "onUpdate:modelValue": ($event) => unref(selectedItem).unit_id = $event,
                    suggestions: [{ ...unref(selectedItem).product.unit, subunits: null }, ...unref(selectedItem).product.unit.subunits],
                    onChange: () => {
                      var _a3, _b3;
                      if (unref(selectedItem).unit_id == unref(selectedItem).product.unit.id) {
                        unref(selectedItem).price = Number(unref(selectedItem).product.price);
                      } else {
                        unref(selectedItem).price = Number(
                          ((_b3 = (_a3 = unref(selectedItem).product.unit_prices) == null ? void 0 : _a3.find((p) => p.unit_id == unref(selectedItem).unit_id)) == null ? void 0 : _b3.price) || unref(convert_to_base_unit)(unref(selectedItem), unref(selectedItem).unit_id, unref(selectedItem).price)
                        );
                      }
                    }
                  }, null, _parent2, _scopeId));
                  _push2(`</div>`);
                } else {
                  _push2(`<!---->`);
                }
                _push2(`<div class="col-span-6 sm:col-span-4"${_scopeId}>`);
                _push2(ssrRenderComponent(unref(_sfc_main$7), {
                  type: "number",
                  id: "item-price",
                  label: _ctx.$t("Price"),
                  modelValue: unref(selectedItem).price,
                  "onUpdate:modelValue": ($event) => unref(selectedItem).price = $event,
                  readonly: !unref(selectedItem).product.can_edit_price
                }, null, _parent2, _scopeId));
                _push2(`</div><div class="col-span-6 sm:col-span-2"${_scopeId}>`);
                _push2(ssrRenderComponent(unref(_sfc_main$7), {
                  id: "item-discount",
                  label: _ctx.$t("Discount"),
                  modelValue: unref(selectedItem).discount,
                  "onUpdate:modelValue": ($event) => unref(selectedItem).discount = $event,
                  onKeypress: unref(discount_keypress),
                  onChange: (e) => {
                    var _a3;
                    let max_discount = ((_a3 = unref(usePage)().props.settings) == null ? void 0 : _a3.max_discount) || null;
                    if (unref(selectedItem).discount.includes("%")) {
                      if (Number(unref(selectedItem).discount.replace("%", "")) > Number(unref(selectedItem).product.max_discount)) {
                        unref(selectedItem).discount = Number(unref(selectedItem).product.max_discount) + "%";
                        unref(notify)({
                          group: "main",
                          type: "error",
                          title: _ctx.$t("You cannot apply discount more than {x}%", { x: Number(unref(selectedItem).product.max_discount) })
                        });
                      } else if (Number(unref(selectedItem).discount.replace("%", "")) > Number(max_discount)) {
                        unref(selectedItem).discount = Number(max_discount) + "%";
                        unref(notify)({
                          group: "main",
                          type: "error",
                          title: _ctx.$t("You cannot apply discount more than {x}%", { x: Number(max_discount) })
                        });
                      }
                    }
                  }
                }, null, _parent2, _scopeId));
                _push2(`</div><div class="${ssrRenderClass(((_d2 = (_c2 = unref(selectedItem).product.unit) == null ? void 0 : _c2.subunits) == null ? void 0 : _d2.length) ? "col-span-full" : "col-span-6 sm:col-span-4")}"${_scopeId}>`);
                _push2(ssrRenderComponent(unref(_sfc_main$8), {
                  json: true,
                  "value-key": "id",
                  id: "item-taxes",
                  multiple: true,
                  "label-key": "name",
                  searchable: false,
                  suggestions: __props.taxes,
                  label: _ctx.$t("Taxes"),
                  modelValue: unref(selectedItem).taxes,
                  "onUpdate:modelValue": ($event) => unref(selectedItem).taxes = $event,
                  disabled: !unref(selectedItem).product.can_edit_taxes
                }, null, _parent2, _scopeId));
                _push2(`</div></div>`);
              }
              _push2(`<div class="col-span-full flex items-center justify-between border-t border-gray-200 dark:border-gray-700 px-6 py-4"${_scopeId}><button type="button" class="py-2.5 px-1 rounded-md focus text-red-600 hover:text-red-500"${_scopeId}>${ssrInterpolate(_ctx.$t("Remove"))}</button><button class="btn-primary"${_scopeId}>${ssrInterpolate(_ctx.$t("Update"))}</button></div></div></div>`);
            } else {
              _push2(`<!---->`);
            }
          } else {
            return [
              unref(selectedItem) ? (openBlock(), createBlock("div", { key: 0 }, [
                createVNode("div", { class: "border-b border-gray-200 dark:border-gray-700 px-4 sm:px-6 py-4" }, [
                  createVNode("div", { class: "sm:flex sm:items-baseline sm:justify-between" }, [
                    createVNode("div", { class: "sm:w-0 sm:flex-1" }, [
                      createVNode("h1", { class: "text-base font-semibold text-focus" }, toDisplayString(_ctx.$t("Edit {x}", { x: unref(selectedItem).name })), 1),
                      createVNode("p", { class: "mt-1 truncate text-sm text-mute" }, toDisplayString(_ctx.$t("Please update the details below")), 1)
                    ])
                  ])
                ]),
                createVNode("div", null, [
                  unref(selectedItem).product.has_variants && unref(selectedItem).variations && unref(selectedItem).variations.length ? (openBlock(), createBlock("div", {
                    key: 0,
                    class: "divide-y dark:divide-gray-700"
                  }, [
                    (openBlock(true), createBlock(Fragment, null, renderList(unref(selectedItem).variations, (v, vi) => {
                      var _a3, _b3, _c3, _d3;
                      return openBlock(), createBlock("div", {
                        key: v.id,
                        class: "p-6 grid grid-cols-6 gap-6"
                      }, [
                        v.code ? (openBlock(), createBlock(Fragment, { key: 0 }, [
                          createVNode("div", { class: "col-span-full font-bold text-mute" }, [
                            createTextVNode(toDisplayString(_ctx.$t("Code")) + ": ", 1),
                            createVNode("span", { class: "text-focus" }, toDisplayString(v.code), 1),
                            createTextVNode(" (" + toDisplayString(_ctx.$meta(v.meta)) + ") ", 1)
                          ]),
                          createVNode("div", { class: "col-span-6 sm:col-span-2" }, [
                            createVNode(unref(_sfc_main$7), {
                              type: "number",
                              id: "item-quantity-v" + vi,
                              label: _ctx.$t("Quantity"),
                              modelValue: unref(selectedItem).variations[vi].quantity,
                              "onUpdate:modelValue": ($event) => unref(selectedItem).variations[vi].quantity = $event
                            }, null, 8, ["id", "label", "modelValue", "onUpdate:modelValue"])
                          ]),
                          ((_b3 = (_a3 = unref(selectedItem).product.unit) == null ? void 0 : _a3.subunits) == null ? void 0 : _b3.length) ? (openBlock(), createBlock("div", {
                            key: 0,
                            class: "col-span-6 sm:col-span-4"
                          }, [
                            createVNode(unref(_sfc_main$8), {
                              json: true,
                              "value-key": "id",
                              id: "item-unit",
                              "label-key": "name",
                              searchable: false,
                              label: _ctx.$t("Unit"),
                              modelValue: unref(selectedItem).variations[vi].unit_id,
                              "onUpdate:modelValue": ($event) => unref(selectedItem).variations[vi].unit_id = $event,
                              suggestions: [{ ...unref(selectedItem).product.unit, subunits: null }, ...unref(selectedItem).product.unit.subunits],
                              onChange: () => {
                                var _a4, _b4;
                                if (unref(selectedItem).variations[vi].unit_id == unref(selectedItem).product.unit.id) {
                                  unref(selectedItem).variations[vi].price = Number(unref(selectedItem).product.price);
                                } else {
                                  unref(selectedItem).variations[vi].price = Number(
                                    ((_b4 = (_a4 = unref(selectedItem).product.unit_prices) == null ? void 0 : _a4.find((p) => p.unit_id == unref(selectedItem).variations[vi].unit_id)) == null ? void 0 : _b4.price) || unref(convert_to_base_unit)(
                                      unref(selectedItem),
                                      unref(selectedItem).variations[vi].unit_id,
                                      unref(selectedItem).variations[vi].price || unref(selectedItem).price
                                    )
                                  );
                                }
                              }
                            }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "suggestions", "onChange"])
                          ])) : createCommentVNode("", true),
                          createVNode("div", { class: "col-span-6 sm:col-span-4" }, [
                            createVNode(unref(_sfc_main$7), {
                              type: "number",
                              label: _ctx.$t("Price"),
                              id: "item-price-v" + vi,
                              modelValue: unref(selectedItem).variations[vi].price,
                              "onUpdate:modelValue": ($event) => unref(selectedItem).variations[vi].price = $event,
                              readonly: !unref(selectedItem).product.can_edit_price
                            }, null, 8, ["label", "id", "modelValue", "onUpdate:modelValue", "readonly"])
                          ]),
                          createVNode("div", { class: "col-span-6 sm:col-span-2" }, [
                            createVNode(unref(_sfc_main$7), {
                              label: _ctx.$t("Discount"),
                              id: "item-discount-v" + vi,
                              onKeypress: unref(discount_keypress),
                              modelValue: unref(selectedItem).variations[vi].discount,
                              "onUpdate:modelValue": ($event) => unref(selectedItem).variations[vi].discount = $event,
                              onChange: (e) => {
                                var _a4;
                                let max_discount = ((_a4 = unref(usePage)().props.settings) == null ? void 0 : _a4.max_discount) || null;
                                if (unref(selectedItem).variations[vi].discount.includes("%")) {
                                  if (Number(unref(selectedItem).variations[vi].discount.replace("%", "")) > Number(unref(selectedItem).product.max_discount)) {
                                    unref(selectedItem).variations[vi].discount = Number(unref(selectedItem).product.max_discount) + "%";
                                    unref(notify)({
                                      group: "main",
                                      type: "error",
                                      title: _ctx.$t("You cannot apply discount more than {x}%", { x: Number(unref(selectedItem).product.max_discount) })
                                    });
                                  } else if (Number(unref(selectedItem).variations[vi].discount.replace("%", "")) > Number(max_discount)) {
                                    unref(selectedItem).variations[vi].discount = Number(max_discount) + "%";
                                    unref(notify)({
                                      group: "main",
                                      type: "error",
                                      title: _ctx.$t("You cannot apply discount more than {x}%", { x: Number(max_discount) })
                                    });
                                  }
                                }
                              }
                            }, null, 8, ["label", "id", "onKeypress", "modelValue", "onUpdate:modelValue", "onChange"])
                          ]),
                          createVNode("div", {
                            class: ((_d3 = (_c3 = unref(selectedItem).product.unit) == null ? void 0 : _c3.subunits) == null ? void 0 : _d3.length) ? "col-span-full" : "col-span-6 sm:col-span-4"
                          }, [
                            createVNode(unref(_sfc_main$8), {
                              json: true,
                              "value-key": "id",
                              multiple: true,
                              "label-key": "name",
                              searchable: false,
                              suggestions: __props.taxes,
                              label: _ctx.$t("Taxes"),
                              id: "item-taxes-v" + vi,
                              modelValue: unref(selectedItem).variations[vi].taxes,
                              "onUpdate:modelValue": ($event) => unref(selectedItem).variations[vi].taxes = $event,
                              disabled: !unref(selectedItem).product.can_edit_taxes
                            }, null, 8, ["suggestions", "label", "id", "modelValue", "onUpdate:modelValue", "disabled"])
                          ], 2)
                        ], 64)) : (openBlock(), createBlock("div", {
                          key: 1,
                          class: "col-span-full"
                        }, [
                          createVNode(unref(_sfc_main$3), {
                            type: "button",
                            onClick: () => {
                              currentItem.value = unref(selectedItem);
                              variantModal.value = true;
                            }
                          }, {
                            default: withCtx(() => [
                              createTextVNode(toDisplayString(_ctx.$t("Select {x}", { x: _ctx.$t("Variation") })), 1)
                            ]),
                            _: 1
                          }, 8, ["onClick"])
                        ]))
                      ]);
                    }), 128))
                  ])) : (openBlock(), createBlock("div", {
                    key: 1,
                    class: "p-6 grid grid-cols-6 gap-6"
                  }, [
                    createVNode("div", { class: "col-span-6 sm:col-span-2" }, [
                      createVNode(unref(_sfc_main$7), {
                        type: "number",
                        id: "item-quantity",
                        label: _ctx.$t("Quantity"),
                        modelValue: unref(selectedItem).quantity,
                        "onUpdate:modelValue": ($event) => unref(selectedItem).quantity = $event
                      }, null, 8, ["label", "modelValue", "onUpdate:modelValue"])
                    ]),
                    ((_f2 = (_e2 = unref(selectedItem).product.unit) == null ? void 0 : _e2.subunits) == null ? void 0 : _f2.length) ? (openBlock(), createBlock("div", {
                      key: 0,
                      class: "col-span-6 sm:col-span-4"
                    }, [
                      createVNode(unref(_sfc_main$8), {
                        json: true,
                        "value-key": "id",
                        id: "item-unit",
                        "label-key": "name",
                        searchable: false,
                        label: _ctx.$t("Unit"),
                        modelValue: unref(selectedItem).unit_id,
                        "onUpdate:modelValue": ($event) => unref(selectedItem).unit_id = $event,
                        suggestions: [{ ...unref(selectedItem).product.unit, subunits: null }, ...unref(selectedItem).product.unit.subunits],
                        onChange: () => {
                          var _a3, _b3;
                          if (unref(selectedItem).unit_id == unref(selectedItem).product.unit.id) {
                            unref(selectedItem).price = Number(unref(selectedItem).product.price);
                          } else {
                            unref(selectedItem).price = Number(
                              ((_b3 = (_a3 = unref(selectedItem).product.unit_prices) == null ? void 0 : _a3.find((p) => p.unit_id == unref(selectedItem).unit_id)) == null ? void 0 : _b3.price) || unref(convert_to_base_unit)(unref(selectedItem), unref(selectedItem).unit_id, unref(selectedItem).price)
                            );
                          }
                        }
                      }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "suggestions", "onChange"])
                    ])) : createCommentVNode("", true),
                    createVNode("div", { class: "col-span-6 sm:col-span-4" }, [
                      createVNode(unref(_sfc_main$7), {
                        type: "number",
                        id: "item-price",
                        label: _ctx.$t("Price"),
                        modelValue: unref(selectedItem).price,
                        "onUpdate:modelValue": ($event) => unref(selectedItem).price = $event,
                        readonly: !unref(selectedItem).product.can_edit_price
                      }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "readonly"])
                    ]),
                    createVNode("div", { class: "col-span-6 sm:col-span-2" }, [
                      createVNode(unref(_sfc_main$7), {
                        id: "item-discount",
                        label: _ctx.$t("Discount"),
                        modelValue: unref(selectedItem).discount,
                        "onUpdate:modelValue": ($event) => unref(selectedItem).discount = $event,
                        onKeypress: unref(discount_keypress),
                        onChange: (e) => {
                          var _a3;
                          let max_discount = ((_a3 = unref(usePage)().props.settings) == null ? void 0 : _a3.max_discount) || null;
                          if (unref(selectedItem).discount.includes("%")) {
                            if (Number(unref(selectedItem).discount.replace("%", "")) > Number(unref(selectedItem).product.max_discount)) {
                              unref(selectedItem).discount = Number(unref(selectedItem).product.max_discount) + "%";
                              unref(notify)({
                                group: "main",
                                type: "error",
                                title: _ctx.$t("You cannot apply discount more than {x}%", { x: Number(unref(selectedItem).product.max_discount) })
                              });
                            } else if (Number(unref(selectedItem).discount.replace("%", "")) > Number(max_discount)) {
                              unref(selectedItem).discount = Number(max_discount) + "%";
                              unref(notify)({
                                group: "main",
                                type: "error",
                                title: _ctx.$t("You cannot apply discount more than {x}%", { x: Number(max_discount) })
                              });
                            }
                          }
                        }
                      }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "onKeypress", "onChange"])
                    ]),
                    createVNode("div", {
                      class: ((_h = (_g2 = unref(selectedItem).product.unit) == null ? void 0 : _g2.subunits) == null ? void 0 : _h.length) ? "col-span-full" : "col-span-6 sm:col-span-4"
                    }, [
                      createVNode(unref(_sfc_main$8), {
                        json: true,
                        "value-key": "id",
                        id: "item-taxes",
                        multiple: true,
                        "label-key": "name",
                        searchable: false,
                        suggestions: __props.taxes,
                        label: _ctx.$t("Taxes"),
                        modelValue: unref(selectedItem).taxes,
                        "onUpdate:modelValue": ($event) => unref(selectedItem).taxes = $event,
                        disabled: !unref(selectedItem).product.can_edit_taxes
                      }, null, 8, ["suggestions", "label", "modelValue", "onUpdate:modelValue", "disabled"])
                    ], 2)
                  ])),
                  createVNode("div", { class: "col-span-full flex items-center justify-between border-t border-gray-200 dark:border-gray-700 px-6 py-4" }, [
                    createVNode("button", {
                      type: "button",
                      onClick: ($event) => unref(removeItem)(unref(selectedItem)),
                      class: "py-2.5 px-1 rounded-md focus text-red-600 hover:text-red-500"
                    }, toDisplayString(_ctx.$t("Remove")), 9, ["onClick"]),
                    createVNode("button", {
                      onClick: unref(updateItem),
                      class: "btn-primary"
                    }, toDisplayString(_ctx.$t("Update")), 9, ["onClick"])
                  ])
                ])
              ])) : createCommentVNode("", true)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Order/Sale/Form.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
