import { unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent, ssrRenderAttr, ssrIncludeBooleanAttr, ssrLooseContain, ssrLooseEqual } from "vue/server-renderer";
import dayjs from "dayjs";
import { T } from "../ssr.js";
import { useI18n } from "vue-i18n";
import { usePage, useForm } from "@inertiajs/vue3";
import { u as $decimal, h as _sfc_main$1, b as _sfc_main$2, l as _sfc_main$4, v as _sfc_main$5 } from "./http-CDixhmav.js";
import "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import { _ as _sfc_main$3 } from "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import { _ as _sfc_main$6 } from "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import { _ as _sfc_main$7 } from "./LoadingButton-DREeyNQW.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "lodash.debounce";
import "@vuepic/vue-datepicker";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = {
  __name: "Form",
  __ssrInlineRender: true,
  props: ["current", "types"],
  emits: ["close", "done"],
  setup(__props, { emit: __emit }) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p, _q, _r, _s;
    usePage();
    const { t } = useI18n();
    const emits = __emit;
    const props = __props;
    const promo_types = [
      { value: "simple", label: t("Simple") },
      { value: "advance", label: t("Advance") },
      { value: "BXGY", label: t("Buy X get Y (BXGY)") },
      { value: "SXGD", label: t("Spend X Get Discount (SXGD)") }
    ];
    const form = useForm({
      _method: ((_a = props.current) == null ? void 0 : _a.id) ? "put" : "post",
      name: (_b = props.current) == null ? void 0 : _b.name,
      type: (_c = props.current) == null ? void 0 : _c.type,
      discount: ((_d = props.current) == null ? void 0 : _d.discount) ? $decimal((_e = props.current) == null ? void 0 : _e.discount) : null,
      discount_method: ((_f = props.current) == null ? void 0 : _f.discount_method) || "percentage",
      details: (_g = props.current) == null ? void 0 : _g.details,
      products: (_h = props.current) == null ? void 0 : _h.products,
      categories: (_i = props.current) == null ? void 0 : _i.categories,
      start_date: ((_j = props.current) == null ? void 0 : _j.start_date) ? dayjs(props.current.start_date).format("YYYY-MM-DD") : null,
      end_date: ((_k = props.current) == null ? void 0 : _k.end_date) ? dayjs(props.current.end_date).format("YYYY-MM-DD") : null,
      product_id_to_buy: (_l = props.current) == null ? void 0 : _l.product_id_to_buy,
      product_id_to_get: (_m = props.current) == null ? void 0 : _m.product_id_to_get,
      quantity_to_buy: ((_n = props.current) == null ? void 0 : _n.quantity_to_buy) ? $decimal((_o = props.current) == null ? void 0 : _o.quantity_to_buy) : null,
      quantity_to_get: ((_p = props.current) == null ? void 0 : _p.quantity_to_get) ? $decimal((_q = props.current) == null ? void 0 : _q.quantity_to_get) : null,
      active: ((_r = props.current) == null ? void 0 : _r.id) ? ((_s = props.current) == null ? void 0 : _s.active) == 1 : true
    });
    return (_ctx, _push, _parent, _attrs) => {
      var _a2, _b2;
      _push(`<form${ssrRenderAttrs(_attrs)}><div class="border-b border-gray-200 dark:border-gray-700 px-6 py-4"><div class="sm:flex sm:items-baseline sm:justify-between"><div class="sm:w-0 sm:flex-1"><h1 class="text-base font-semibold text-focus">${ssrInterpolate(((_a2 = __props.current) == null ? void 0 : _a2.id) ? _ctx.$t("Edit {x}", { x: _ctx.$t("Promotion") }) : _ctx.$t("Add {x}", { x: _ctx.$t("Promotion") }))}</h1><p class="mt-1 truncate text-sm text-mute">${ssrInterpolate(_ctx.$t("Please fill the form below to {action} {record}.", {
        record: _ctx.$t("tax"),
        action: ((_b2 = __props.current) == null ? void 0 : _b2.id) ? _ctx.$t("edit") : _ctx.$t("add")
      }))}</p></div></div></div><div class="p-6 grid grid-cols-6 gap-6"><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        id: "name",
        label: _ctx.$t("Name"),
        modelValue: unref(form).name,
        "onUpdate:modelValue": ($event) => unref(form).name = $event,
        error: unref(form).errors.name
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        id: "type",
        json: true,
        label: _ctx.$t("Type"),
        searchable: false,
        modelValue: unref(form).type,
        "onUpdate:modelValue": ($event) => unref(form).type = $event,
        error: unref(form).errors.type,
        suggestions: promo_types
      }, null, _parent));
      _push(`</div><span class="sr-only">${ssrInterpolate(_ctx.$t("Simple"))} ${ssrInterpolate(_ctx.$t("Advance"))} ${ssrInterpolate(_ctx.$t("BXGY"))} ${ssrInterpolate(_ctx.$t("SXGD"))} ${ssrInterpolate(_ctx.$t("Buy X get Y (BXGY)"))} ${ssrInterpolate(_ctx.$t("Spend X Get Discount (SXGD)"))}</span>`);
      if (unref(form).type != "BXGY") {
        _push(`<div class="col-span-6 sm:col-span-3">`);
        _push(ssrRenderComponent(unref(_sfc_main$3), {
          value: _ctx.$t("Discount"),
          class: "mb-1"
        }, null, _parent));
        _push(`<div class="pt-0.5 flex items-center rounded-md bg-white dark:bg-gray-900 outline outline-1 -outline-offset-1 outline-gray-300 dark:outline-gray-700 has-[input:focus-within]:outline-2 has-[input:focus-within]:-outline-offset-2 has-[input:focus-within]:outline-primary-600"><input type="number" id="discount" pattern="[0-9]"${ssrRenderAttr("placeholder", _ctx.$t("Discount"))}${ssrRenderAttr("value", unref(form).discount)} class="grow py-2 border-0 dark:bg-gray-900 dark:text-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-0"><div class="grid shrink-0 grid-cols-1 focus-within:relative"><select id="discount_method" class="col-start-1 row-start-1 w-full text-right appearance-none bg-none border-0 rounded-md py-1.5 px-3 text-base placeholder:text-gray-400 focus:outline-none focus:ring-0 sm:text-sm/6 bg-white dark:bg-gray-900"><option value="fixed"${ssrIncludeBooleanAttr(Array.isArray(unref(form).discount_method) ? ssrLooseContain(unref(form).discount_method, "fixed") : ssrLooseEqual(unref(form).discount_method, "fixed")) ? " selected" : ""}>${ssrInterpolate(_ctx.$t("Fixed"))}</option><option value="percentage"${ssrIncludeBooleanAttr(Array.isArray(unref(form).discount_method) ? ssrLooseContain(unref(form).discount_method, "percentage") : ssrLooseEqual(unref(form).discount_method, "percentage")) ? " selected" : ""}>${ssrInterpolate(_ctx.$t("Percentage"))}</option></select></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(form).type == "advance") {
        _push(`<div class="col-span-6 sm:col-span-3">`);
        _push(ssrRenderComponent(unref(_sfc_main$1), {
          type: "number",
          id: "quantity_to_buy",
          label: _ctx.$t("Quantity to buy"),
          modelValue: unref(form).quantity_to_buy,
          "onUpdate:modelValue": ($event) => unref(form).quantity_to_buy = $event,
          error: unref(form).errors.quantity_to_buy
        }, null, _parent));
        _push(`</div>`);
      } else if (unref(form).type == "SXGD") {
        _push(`<div class="col-span-6 sm:col-span-3">`);
        _push(ssrRenderComponent(unref(_sfc_main$1), {
          type: "number",
          id: "amount_to_spend",
          label: _ctx.$t("Amount to spend"),
          modelValue: unref(form).amount_to_spend,
          "onUpdate:modelValue": ($event) => unref(form).amount_to_spend = $event,
          error: unref(form).errors.amount_to_spend
        }, null, _parent));
        _push(`</div>`);
      } else if (unref(form).type == "BXGY") {
        _push(`<!--[--><div class="col-span-6 sm:col-span-3">`);
        _push(ssrRenderComponent(unref(_sfc_main$2), {
          json: true,
          valueKey: "id",
          labelKey: "name",
          searchable: true,
          id: "product_id_to_buy",
          label: _ctx.$t("Product to buy"),
          modelValue: unref(form).product_id_to_buy,
          "onUpdate:modelValue": ($event) => unref(form).product_id_to_buy = $event,
          error: unref(form).errors.product_id_to_buy,
          suggestions: unref(T)("search.products")
        }, null, _parent));
        _push(`</div><div class="col-span-6 sm:col-span-3">`);
        _push(ssrRenderComponent(unref(_sfc_main$1), {
          type: "number",
          id: "quantity_to_buy",
          label: _ctx.$t("Quantity to buy"),
          modelValue: unref(form).quantity_to_buy,
          "onUpdate:modelValue": ($event) => unref(form).quantity_to_buy = $event,
          error: unref(form).errors.quantity_to_buy
        }, null, _parent));
        _push(`</div><div class="col-span-6 sm:col-span-3">`);
        _push(ssrRenderComponent(unref(_sfc_main$2), {
          json: true,
          valueKey: "id",
          labelKey: "name",
          searchable: true,
          id: "product_id_to_get",
          label: _ctx.$t("Product to get"),
          modelValue: unref(form).product_id_to_get,
          "onUpdate:modelValue": ($event) => unref(form).product_id_to_get = $event,
          error: unref(form).errors.product_id_to_get,
          suggestions: unref(T)("search.products")
        }, null, _parent));
        _push(`</div><div class="col-span-6 sm:col-span-3">`);
        _push(ssrRenderComponent(unref(_sfc_main$1), {
          type: "number",
          id: "quantity_to_get",
          label: _ctx.$t("Quantity to get"),
          modelValue: unref(form).quantity_to_get,
          "onUpdate:modelValue": ($event) => unref(form).quantity_to_get = $event,
          error: unref(form).errors.quantity_to_get
        }, null, _parent));
        _push(`</div><!--]-->`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        type: "date",
        id: "start_date",
        label: _ctx.$t("Start Date"),
        modelValue: unref(form).start_date,
        "onUpdate:modelValue": ($event) => unref(form).start_date = $event,
        error: unref(form).errors.start_date
      }, null, _parent));
      _push(`</div><div class="col-span-6 sm:col-span-3">`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        type: "date",
        id: "end_date",
        label: _ctx.$t("End Date"),
        modelValue: unref(form).end_date,
        "onUpdate:modelValue": ($event) => unref(form).end_date = $event,
        error: unref(form).errors.end_date
      }, null, _parent));
      _push(`</div><div class="col-span-full">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        json: true,
        id: "products",
        multiple: true,
        searchable: true,
        modelValue: unref(form).products,
        "onUpdate:modelValue": ($event) => unref(form).products = $event,
        label: _ctx.$t("Products"),
        error: unref(form).errors.products,
        suggestions: unref(T)("search.products")
      }, null, _parent));
      _push(`</div><div class="col-span-full">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        json: true,
        id: "categories",
        multiple: true,
        searchable: true,
        modelValue: unref(form).categories,
        "onUpdate:modelValue": ($event) => unref(form).categories = $event,
        label: _ctx.$t("Categories"),
        error: unref(form).errors.categories,
        suggestions: unref(T)("search.categories")
      }, null, _parent));
      _push(`</div><div class="col-span-full">`);
      _push(ssrRenderComponent(unref(_sfc_main$4), {
        id: "details",
        label: _ctx.$t("Details"),
        modelValue: unref(form).details,
        "onUpdate:modelValue": ($event) => unref(form).details = $event,
        error: unref(form).errors.details
      }, null, _parent));
      _push(`</div><div class="col-span-full">`);
      _push(ssrRenderComponent(unref(_sfc_main$5), {
        id: "active",
        error: unref(form).errors.active,
        checked: unref(form).active,
        "onUpdate:checked": ($event) => unref(form).active = $event,
        label: _ctx.$t("Active")
      }, null, _parent));
      _push(`</div></div><div class="flex flex-row justify-end px-6 py-4 bg-gray-100 dark:bg-gray-950 text-end">`);
      _push(ssrRenderComponent(unref(_sfc_main$6), {
        onClick: ($event) => emits("close")
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Cancel"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Cancel")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$7), {
        class: "ms-3",
        loading: unref(form).processing
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Save"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></form>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Product/Promotion/Form.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
