import { ref, watch, nextTick, resolveComponent, withCtx, createVNode, toDisplayString, unref, createTextVNode, createBlock, createCommentVNode, openBlock, Fragment, renderList, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrIncludeBooleanAttr, ssrRenderList, ssrRenderClass } from "vue/server-renderer";
import { T } from "../ssr.js";
import "notiwind";
import debounce from "lodash.debounce";
import { usePage, useForm, router } from "@inertiajs/vue3";
import { _ as _sfc_main$1 } from "./AdminLayout-DHH3IgME.js";
import { s as searchItems } from "./search-h0wKx9lE.js";
import { f as $extras, b as _sfc_main$6, h as _sfc_main$7, k as _sfc_main$8, l as _sfc_main$9 } from "./http-CDixhmav.js";
import { F as FormHelper, V as VariationSelection } from "./VariationSelection-kl6n6FuS.js";
import { _ as _sfc_main$4 } from "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import { _ as _sfc_main$2 } from "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import { _ as _sfc_main$3 } from "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import { _ as _sfc_main$5 } from "./LoadingButton-DREeyNQW.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "./AppLayout-BRHmSgDa.js";
import "dayjs";
import "vue-i18n";
import "@vuepic/vue-datepicker";
import "lodash.isequal";
import "axios";
import "lodash.throttle";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = /* @__PURE__ */ Object.assign({ layout: _sfc_main$1 }, {
  __name: "Form",
  __ssrInlineRender: true,
  props: ["current", "custom_fields", "stores"],
  setup(__props) {
    var _a, _b, _c, _d;
    const page = usePage();
    const props = __props;
    const result = ref([]);
    const search = ref(null);
    const form = useForm({
      _method: ((_a = props.current) == null ? void 0 : _a.id) ? "put" : "post",
      to_store_id: (_b = props.current) == null ? void 0 : _b.to_store_id,
      reference: (_c = props.current) == null ? void 0 : _c.reference,
      details: (_d = props.current) == null ? void 0 : _d.details,
      items: props.current && props.current.items ? props.current.items.map((i) => ({
        ...i,
        id: i.id,
        name: i.product.name,
        product_id: i.product_id,
        quantity: Number(i.quantity),
        old_quantity: Number(i.quantity),
        variations: i.variations.map((v) => ({ ...v, quantity: Number(v.pivot.quantity), old_quantity: Number(v.pivot.quantity) }))
      })) : [],
      extra_attributes: props.current ? $extras(props.custom_fields, props.current.extra_attributes) : $extras(props.custom_fields)
    });
    const { removeItem, resetForm, saveForm } = FormHelper(form);
    const { currentItem, deleteVariation, emptyVariation, variantModal, SelectVariant } = VariationSelection();
    watch(search, debounce(searchProducts, 500));
    async function searchProducts(query) {
      if (query) {
        result.value = await searchItems(query, "transfer");
        if (result.value.length == 1) {
          addItem(result.value[0]);
        }
      }
    }
    async function addItem(item) {
      var _a2;
      if (form.items.find((i) => i.product_id == item.id)) {
        form.items = form.items.map((i) => {
          if (i.product_id == item.id) {
            if (i.product.has_variants) {
              i.variations = [...i.variations, emptyVariation()];
              currentItem.value = i;
              variantModal.value = true;
            } else {
              i.quantity++;
            }
          }
          return i;
        });
      } else {
        let product = await axios.get(T("products.show", item.id)).then((r) => r.data);
        currentItem.value = { ...item, id: null, quantity: 1, product_id: item.id, product };
        if (product.has_variants) {
          currentItem.value.variations = [emptyVariation()];
          variantModal.value = true;
        }
        form.items = [...form.items, { ...currentItem.value }];
      }
      saveForm();
      await nextTick();
      search.value = "";
      (_a2 = document.getElementById("product-search")) == null ? void 0 : _a2.focus();
    }
    function handleSubmit(e, listing = false) {
      var _a2;
      form.errors = {};
      form.transform((data) => {
        let form2 = { ...data };
        form2.items = form2.items.map((i) => ({
          id: i.id,
          quantity: i.quantity,
          product_id: i.product_id,
          old_quantity: i.old_quantity,
          variations: i.variations && i.variations.length ? i.variations.map((v) => ({ id: v.id, quantity: Number(v.quantity), old_quantity: v.old_quantity })) : null
        }));
        return form2;
      }).post(((_a2 = props.current) == null ? void 0 : _a2.id) ? T("transfers.update", props.current.id) : T("transfers.store"), {
        onSuccess: (page2) => {
          resetForm();
          if (listing) {
            router.get(T("transfers.index"));
          }
        }
      });
    }
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Head = resolveComponent("Head");
      const _component_Link = resolveComponent("Link");
      const _component_Icon = resolveComponent("Icon");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_Head, null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          var _a2, _b2;
          if (_push2) {
            _push2(`<title${_scopeId}>${ssrInterpolate(((_a2 = __props.current) == null ? void 0 : _a2.id) ? _ctx.$t("Edit {x}", { x: _ctx.$t("Transfer") }) : _ctx.$t("Add {x}", { x: _ctx.$t("Transfer") }))}</title>`);
          } else {
            return [
              createVNode("title", null, toDisplayString(((_b2 = __props.current) == null ? void 0 : _b2.id) ? _ctx.$t("Edit {x}", { x: _ctx.$t("Transfer") }) : _ctx.$t("Add {x}", { x: _ctx.$t("Transfer") })), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<div class="pt-6 pb-0 sm:py-8 px-0 sm:px-6 lg:px-8">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), { onSubmitted: handleSubmit }, {
        title: withCtx((_, _push2, _parent2, _scopeId) => {
          var _a2, _b2;
          if (_push2) {
            _push2(`${ssrInterpolate(((_a2 = __props.current) == null ? void 0 : _a2.id) ? _ctx.$t("Edit {x}", { x: _ctx.$t("Transfer") }) : _ctx.$t("Add {x}", { x: _ctx.$t("Transfer") }))}`);
          } else {
            return [
              createTextVNode(toDisplayString(((_b2 = __props.current) == null ? void 0 : _b2.id) ? _ctx.$t("Edit {x}", { x: _ctx.$t("Transfer") }) : _ctx.$t("Add {x}", { x: _ctx.$t("Transfer") })), 1)
            ];
          }
        }),
        description: withCtx((_, _push2, _parent2, _scopeId) => {
          var _a2, _b2;
          if (_push2) {
            _push2(`<div class="w-full block sm:flex sm:items-start sm:justify-between lg:block"${_scopeId}><div${_scopeId}>${ssrInterpolate(_ctx.$t("Please fill the form below to {action} {record}.", {
              record: _ctx.$t("transfer"),
              action: ((_a2 = __props.current) == null ? void 0 : _a2.id) ? _ctx.$t("edit") : _ctx.$t("add")
            }))}</div><div class="mt-6 sm:mt-0 lg:mt-6 me-3"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_Link, {
              class: "link",
              href: unref(T)("transfers.index")
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("List {x}", { x: _ctx.$t("Transfers") }))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("List {x}", { x: _ctx.$t("Transfers") })), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div></div>`);
          } else {
            return [
              createVNode("div", { class: "w-full block sm:flex sm:items-start sm:justify-between lg:block" }, [
                createVNode("div", null, toDisplayString(_ctx.$t("Please fill the form below to {action} {record}.", {
                  record: _ctx.$t("transfer"),
                  action: ((_b2 = __props.current) == null ? void 0 : _b2.id) ? _ctx.$t("edit") : _ctx.$t("add")
                })), 1),
                createVNode("div", { class: "mt-6 sm:mt-0 lg:mt-6 me-3" }, [
                  createVNode(_component_Link, {
                    class: "link",
                    href: unref(T)("transfers.index")
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(_ctx.$t("List {x}", { x: _ctx.$t("Transfers") })), 1)
                    ]),
                    _: 1
                  }, 8, ["href"])
                ])
              ])
            ];
          }
        }),
        form: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$6), {
              json: true,
              "value-key": "id",
              "label-key": "name",
              id: "to_store_id",
              label: _ctx.$t("To"),
              onChange: unref(saveForm),
              modelValue: unref(form).to_store_id,
              "onUpdate:modelValue": ($event) => unref(form).to_store_id = $event,
              error: unref(form).errors.to_store_id,
              suggestions: __props.stores.filter((s) => s.id != unref(page).props.selected_store)
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$7), {
              id: "reference",
              onChange: unref(saveForm),
              label: _ctx.$t("Reference"),
              modelValue: unref(form).reference,
              "onUpdate:modelValue": ($event) => unref(form).reference = $event,
              error: unref(form).errors.reference
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-full"${_scopeId}><div class="relative"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$7), {
              label: "",
              modelValue: search.value,
              "onUpdate:modelValue": ($event) => search.value = $event,
              id: "product-search",
              placeholder: _ctx.$t("Scan barcode or type to search")
            }, null, _parent2, _scopeId));
            if (search.value && result.value && result.value.length) {
              _push2(`<div class="absolute z-10 top-full left-0 right-0 ring-1 bg-white dark:bg-gray-700 rounded-md dark:ring-gray-700 mt-2 py-1"${_scopeId}><!--[-->`);
              ssrRenderList(result.value, (p) => {
                _push2(`<button type="button" class="w-full text-left py-1.5 px-4 hover:bg-gray-100 dark:hover:bg-gray-900"${_scopeId}>${ssrInterpolate(p.name)}</button>`);
              });
              _push2(`<!--]--></div>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`</div>`);
            if (unref(form).items && unref(form).items.length) {
              _push2(`<div class="border-b border-gray-200 dark:border-gray-700"${_scopeId}><h4 class="text-lg font-bold mt-6 pb-1 border-b border-gray-200 dark:border-gray-700"${_scopeId}>${ssrInterpolate(_ctx.$t("Transfer Items"))}</h4><table class="w-full divide-y dark:divide-gray-700"${_scopeId}><!--[-->`);
              ssrRenderList(unref(form).items, (item, index) => {
                var _a2;
                _push2(`<!--[-->`);
                if (item.product.has_variants && item.variations && item.variations.length) {
                  _push2(`<tbody${_scopeId}><tr${_scopeId}><td class="w-8 px-2 pt-4 pb-2"${_scopeId}>${ssrInterpolate(index + 1)}.</td><td class="p-2 font-bold"${_scopeId}>${ssrInterpolate(item.name)}</td><td class="w-36 p-2"${_scopeId}></td><td class="w-6 p-2 text-right"${_scopeId}></td></tr><!--[-->`);
                  ssrRenderList(item.variations, (variation, vi) => {
                    var _a3;
                    _push2(`<!--[--><tr class="${ssrRenderClass(
                      unref(form).errors && (unref(form).errors["items." + index + ".variations." + vi + ".id"] || unref(form).errors["items." + index + ".variations." + vi + ".quantity"]) ? "bg-red-100 dark:bg-red-900" : ""
                    )}"${_scopeId}><td class="w-8 p-2"${_scopeId}></td><td class="p-2"${_scopeId}>${ssrInterpolate(_ctx.$meta(variation.meta))}</td><td class="w-36 p-2"${_scopeId}>`);
                    _push2(ssrRenderComponent(unref(_sfc_main$7), {
                      min: 0,
                      label: "",
                      "del-on": 0,
                      type: "number",
                      onChange: () => {
                        item.quantity = item.variations.reduce((a, v) => Number(v.quantity) + a, 0);
                        unref(saveForm)();
                      },
                      modelValue: variation.quantity,
                      "onUpdate:modelValue": ($event) => variation.quantity = $event,
                      placeholder: _ctx.$t("Quantity"),
                      max: item.selected_store && item.selected_store[0] ? (_a3 = item.selected_store[0].pivot) == null ? void 0 : _a3.quantity : null
                    }, null, _parent2, _scopeId));
                    _push2(`</td><td class="w-6 p-2 text-right"${_scopeId}><button type="button" class="py-2.5 px-1 rounded-md focus text-red-600 hover:text-red-500"${_scopeId}>`);
                    _push2(ssrRenderComponent(_component_Icon, {
                      name: "trash-o",
                      size: "size-5"
                    }, null, _parent2, _scopeId));
                    _push2(`</button></td></tr>`);
                    if (unref(form).errors && (unref(form).errors["items." + index + ".variations." + vi + ".id"] || unref(form).errors["items." + index + ".variations." + vi + ".quantity"])) {
                      _push2(`<tr class="bg-red-100 dark:bg-red-900"${_scopeId}><td colspan="100%"${_scopeId}><div class="py-1 px-4 text-red-500 text-sm"${_scopeId}>`);
                      if (unref(form).errors["items." + index + ".variations." + vi + ".id"]) {
                        _push2(`<div${_scopeId}>${ssrInterpolate(unref(form).errors["items." + index + ".variations." + vi + ".id"].toString().replace(
                          "items." + index + ".variations." + vi + ".id",
                          _ctx.$t("item") + " #" + (index + 1) + " " + _ctx.$t("variation") + " #" + (vi + 1)
                        ))}</div>`);
                      } else {
                        _push2(`<!---->`);
                      }
                      if (unref(form).errors["items." + index + ".variations." + vi + ".quantity"]) {
                        _push2(`<div${_scopeId}>${ssrInterpolate(unref(form).errors["items." + index + ".variations." + vi + ".quantity"].toString().replace(
                          "items." + index + ".variations." + vi + ".quantity",
                          _ctx.$t("item") + " #" + (index + 1) + " " + _ctx.$t("variation") + " #" + (vi + 1) + " " + _ctx.$t("quantity")
                        ).split("when")[0])}</div>`);
                      } else {
                        _push2(`<!---->`);
                      }
                      _push2(`</div></td></tr>`);
                    } else {
                      _push2(`<!---->`);
                    }
                    _push2(`<!--]-->`);
                  });
                  _push2(`<!--]--></tbody>`);
                } else {
                  _push2(`<tbody class="${ssrRenderClass(
                    unref(form).errors && (unref(form).errors["items." + index + ".quantity"] || unref(form).errors["items." + index + ".variations"]) ? "bg-red-100 dark:bg-red-800" : ""
                  )}"${_scopeId}><tr${_scopeId}><td class="w-8 p-2"${_scopeId}>${ssrInterpolate(index + 1)}.</td><td class="p-2"${_scopeId}>${ssrInterpolate(item.name)}</td><td class="w-36 p-2"${_scopeId}>`);
                  _push2(ssrRenderComponent(unref(_sfc_main$7), {
                    min: 0,
                    label: "",
                    "del-on": 0,
                    type: "number",
                    onChange: unref(saveForm),
                    modelValue: item.quantity,
                    "onUpdate:modelValue": ($event) => item.quantity = $event,
                    placeholder: _ctx.$t("Quantity"),
                    max: item.selected_store && item.selected_store[0] ? (_a2 = item.selected_store[0].pivot) == null ? void 0 : _a2.quantity : null
                  }, null, _parent2, _scopeId));
                  _push2(`</td><td class="w-6 p-2 text-right"${_scopeId}><button type="button" class="py-2.5 px-1 rounded-md focus text-red-600 hover:text-red-500"${_scopeId}>`);
                  _push2(ssrRenderComponent(_component_Icon, {
                    name: "trash-o",
                    size: "size-5"
                  }, null, _parent2, _scopeId));
                  _push2(`</button></td></tr>`);
                  if (unref(form).errors && (unref(form).errors["items." + index + ".quantity"] || unref(form).errors["items." + index + ".variations"])) {
                    _push2(`<tr${_scopeId}><td colspan="100%"${_scopeId}><div class="py-1 px-4 text-red-500 text-sm"${_scopeId}>`);
                    if (unref(form).errors["items." + index + ".quantity"]) {
                      _push2(`<div${_scopeId}>${ssrInterpolate(unref(form).errors["items." + index + ".quantity"].toString().replace("items." + index + ".quantity", _ctx.$t("item") + " #" + (index + 1) + " " + _ctx.$t("quantity")))}</div>`);
                    } else {
                      _push2(`<!---->`);
                    }
                    if (unref(form).errors["items." + index + ".variations"]) {
                      _push2(`<div${_scopeId}>${ssrInterpolate(unref(form).errors["items." + index + ".variations"].toString().replace("items." + index + ".variations", _ctx.$t("item") + " #" + (index + 1) + " " + _ctx.$t("variations")))}</div>`);
                    } else {
                      _push2(`<!---->`);
                    }
                    _push2(`</div></td></tr>`);
                  } else {
                    _push2(`<!---->`);
                  }
                  _push2(`</tbody>`);
                }
                _push2(`<!--]-->`);
              });
              _push2(`<!--]--><tfoot${_scopeId}><tr${_scopeId}><th colspan="2" class="p-2 font-bold text-right text-lg"${_scopeId}>${ssrInterpolate(_ctx.$t("Total quantity"))}</th><th class="p-2 font-bold text-right text-lg"${_scopeId}>${ssrInterpolate(_ctx.$decimal(unref(form).items.reduce((a, i) => Number(i.quantity) + a, 0)))}</th><th${_scopeId}></th></tr></tfoot></table></div>`);
            } else {
              _push2(`<label for="product-search" class="w-full block mt-4 rounded-md bg-gray-100 dark:bg-gray-800 py-2 px-4 text-primary-600 dark:text-primary-400"${_scopeId}>${ssrInterpolate(_ctx.$t("Please add at least one product."))}</label>`);
            }
            _push2(`</div><div class="col-span-full flex flex-col gap-6"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$8), {
              errors: unref(form).errors,
              custom_fields: __props.custom_fields,
              extra_attributes: unref(form).extra_attributes,
              onUpdate: unref(saveForm)
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$9), {
              onChange: unref(saveForm),
              label: _ctx.$t("Details"),
              modelValue: unref(form).details,
              "onUpdate:modelValue": ($event) => unref(form).details = $event,
              error: _ctx.$page.props.errors.details
            }, null, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$6), {
                  json: true,
                  "value-key": "id",
                  "label-key": "name",
                  id: "to_store_id",
                  label: _ctx.$t("To"),
                  onChange: unref(saveForm),
                  modelValue: unref(form).to_store_id,
                  "onUpdate:modelValue": ($event) => unref(form).to_store_id = $event,
                  error: unref(form).errors.to_store_id,
                  suggestions: __props.stores.filter((s) => s.id != unref(page).props.selected_store)
                }, null, 8, ["label", "onChange", "modelValue", "onUpdate:modelValue", "error", "suggestions"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$7), {
                  id: "reference",
                  onChange: unref(saveForm),
                  label: _ctx.$t("Reference"),
                  modelValue: unref(form).reference,
                  "onUpdate:modelValue": ($event) => unref(form).reference = $event,
                  error: unref(form).errors.reference
                }, null, 8, ["onChange", "label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              createVNode("div", { class: "col-span-full" }, [
                createVNode("div", { class: "relative" }, [
                  createVNode(unref(_sfc_main$7), {
                    label: "",
                    modelValue: search.value,
                    "onUpdate:modelValue": ($event) => search.value = $event,
                    id: "product-search",
                    placeholder: _ctx.$t("Scan barcode or type to search")
                  }, null, 8, ["modelValue", "onUpdate:modelValue", "placeholder"]),
                  search.value && result.value && result.value.length ? (openBlock(), createBlock("div", {
                    key: 0,
                    class: "absolute z-10 top-full left-0 right-0 ring-1 bg-white dark:bg-gray-700 rounded-md dark:ring-gray-700 mt-2 py-1"
                  }, [
                    (openBlock(true), createBlock(Fragment, null, renderList(result.value, (p) => {
                      return openBlock(), createBlock("button", {
                        key: p.id,
                        type: "button",
                        onClick: ($event) => addItem(p),
                        class: "w-full text-left py-1.5 px-4 hover:bg-gray-100 dark:hover:bg-gray-900"
                      }, toDisplayString(p.name), 9, ["onClick"]);
                    }), 128))
                  ])) : createCommentVNode("", true)
                ]),
                unref(form).items && unref(form).items.length ? (openBlock(), createBlock("div", {
                  key: 0,
                  class: "border-b border-gray-200 dark:border-gray-700"
                }, [
                  createVNode("h4", { class: "text-lg font-bold mt-6 pb-1 border-b border-gray-200 dark:border-gray-700" }, toDisplayString(_ctx.$t("Transfer Items")), 1),
                  createVNode("table", { class: "w-full divide-y dark:divide-gray-700" }, [
                    (openBlock(true), createBlock(Fragment, null, renderList(unref(form).items, (item, index) => {
                      var _a2;
                      return openBlock(), createBlock(Fragment, {
                        key: item.code
                      }, [
                        item.product.has_variants && item.variations && item.variations.length ? (openBlock(), createBlock("tbody", { key: 0 }, [
                          createVNode("tr", null, [
                            createVNode("td", { class: "w-8 px-2 pt-4 pb-2" }, toDisplayString(index + 1) + ".", 1),
                            createVNode("td", { class: "p-2 font-bold" }, toDisplayString(item.name), 1),
                            createVNode("td", { class: "w-36 p-2" }),
                            createVNode("td", { class: "w-6 p-2 text-right" })
                          ]),
                          (openBlock(true), createBlock(Fragment, null, renderList(item.variations, (variation, vi) => {
                            var _a3;
                            return openBlock(), createBlock(Fragment, {
                              key: variation.id
                            }, [
                              createVNode("tr", {
                                class: unref(form).errors && (unref(form).errors["items." + index + ".variations." + vi + ".id"] || unref(form).errors["items." + index + ".variations." + vi + ".quantity"]) ? "bg-red-100 dark:bg-red-900" : ""
                              }, [
                                createVNode("td", { class: "w-8 p-2" }),
                                createVNode("td", { class: "p-2" }, toDisplayString(_ctx.$meta(variation.meta)), 1),
                                createVNode("td", { class: "w-36 p-2" }, [
                                  createVNode(unref(_sfc_main$7), {
                                    min: 0,
                                    label: "",
                                    "del-on": 0,
                                    type: "number",
                                    onChange: () => {
                                      item.quantity = item.variations.reduce((a, v) => Number(v.quantity) + a, 0);
                                      unref(saveForm)();
                                    },
                                    modelValue: variation.quantity,
                                    "onUpdate:modelValue": ($event) => variation.quantity = $event,
                                    placeholder: _ctx.$t("Quantity"),
                                    max: item.selected_store && item.selected_store[0] ? (_a3 = item.selected_store[0].pivot) == null ? void 0 : _a3.quantity : null
                                  }, null, 8, ["onChange", "modelValue", "onUpdate:modelValue", "placeholder", "max"])
                                ]),
                                createVNode("td", { class: "w-6 p-2 text-right" }, [
                                  createVNode("button", {
                                    type: "button",
                                    onClick: ($event) => unref(deleteVariation)(variation, item),
                                    class: "py-2.5 px-1 rounded-md focus text-red-600 hover:text-red-500"
                                  }, [
                                    createVNode(_component_Icon, {
                                      name: "trash-o",
                                      size: "size-5"
                                    })
                                  ], 8, ["onClick"])
                                ])
                              ], 2),
                              unref(form).errors && (unref(form).errors["items." + index + ".variations." + vi + ".id"] || unref(form).errors["items." + index + ".variations." + vi + ".quantity"]) ? (openBlock(), createBlock("tr", {
                                key: 0,
                                class: "bg-red-100 dark:bg-red-900"
                              }, [
                                createVNode("td", { colspan: "100%" }, [
                                  createVNode("div", { class: "py-1 px-4 text-red-500 text-sm" }, [
                                    unref(form).errors["items." + index + ".variations." + vi + ".id"] ? (openBlock(), createBlock("div", { key: 0 }, toDisplayString(unref(form).errors["items." + index + ".variations." + vi + ".id"].toString().replace(
                                      "items." + index + ".variations." + vi + ".id",
                                      _ctx.$t("item") + " #" + (index + 1) + " " + _ctx.$t("variation") + " #" + (vi + 1)
                                    )), 1)) : createCommentVNode("", true),
                                    unref(form).errors["items." + index + ".variations." + vi + ".quantity"] ? (openBlock(), createBlock("div", { key: 1 }, toDisplayString(unref(form).errors["items." + index + ".variations." + vi + ".quantity"].toString().replace(
                                      "items." + index + ".variations." + vi + ".quantity",
                                      _ctx.$t("item") + " #" + (index + 1) + " " + _ctx.$t("variation") + " #" + (vi + 1) + " " + _ctx.$t("quantity")
                                    ).split("when")[0]), 1)) : createCommentVNode("", true)
                                  ])
                                ])
                              ])) : createCommentVNode("", true)
                            ], 64);
                          }), 128))
                        ])) : (openBlock(), createBlock("tbody", {
                          key: 1,
                          class: unref(form).errors && (unref(form).errors["items." + index + ".quantity"] || unref(form).errors["items." + index + ".variations"]) ? "bg-red-100 dark:bg-red-800" : ""
                        }, [
                          createVNode("tr", null, [
                            createVNode("td", { class: "w-8 p-2" }, toDisplayString(index + 1) + ".", 1),
                            createVNode("td", { class: "p-2" }, toDisplayString(item.name), 1),
                            createVNode("td", { class: "w-36 p-2" }, [
                              createVNode(unref(_sfc_main$7), {
                                min: 0,
                                label: "",
                                "del-on": 0,
                                type: "number",
                                onChange: unref(saveForm),
                                modelValue: item.quantity,
                                "onUpdate:modelValue": ($event) => item.quantity = $event,
                                placeholder: _ctx.$t("Quantity"),
                                max: item.selected_store && item.selected_store[0] ? (_a2 = item.selected_store[0].pivot) == null ? void 0 : _a2.quantity : null
                              }, null, 8, ["onChange", "modelValue", "onUpdate:modelValue", "placeholder", "max"])
                            ]),
                            createVNode("td", { class: "w-6 p-2 text-right" }, [
                              createVNode("button", {
                                type: "button",
                                onClick: ($event) => unref(removeItem)(item),
                                class: "py-2.5 px-1 rounded-md focus text-red-600 hover:text-red-500"
                              }, [
                                createVNode(_component_Icon, {
                                  name: "trash-o",
                                  size: "size-5"
                                })
                              ], 8, ["onClick"])
                            ])
                          ]),
                          unref(form).errors && (unref(form).errors["items." + index + ".quantity"] || unref(form).errors["items." + index + ".variations"]) ? (openBlock(), createBlock("tr", { key: 0 }, [
                            createVNode("td", { colspan: "100%" }, [
                              createVNode("div", { class: "py-1 px-4 text-red-500 text-sm" }, [
                                unref(form).errors["items." + index + ".quantity"] ? (openBlock(), createBlock("div", { key: 0 }, toDisplayString(unref(form).errors["items." + index + ".quantity"].toString().replace("items." + index + ".quantity", _ctx.$t("item") + " #" + (index + 1) + " " + _ctx.$t("quantity"))), 1)) : createCommentVNode("", true),
                                unref(form).errors["items." + index + ".variations"] ? (openBlock(), createBlock("div", { key: 1 }, toDisplayString(unref(form).errors["items." + index + ".variations"].toString().replace("items." + index + ".variations", _ctx.$t("item") + " #" + (index + 1) + " " + _ctx.$t("variations"))), 1)) : createCommentVNode("", true)
                              ])
                            ])
                          ])) : createCommentVNode("", true)
                        ], 2))
                      ], 64);
                    }), 128)),
                    createVNode("tfoot", null, [
                      createVNode("tr", null, [
                        createVNode("th", {
                          colspan: "2",
                          class: "p-2 font-bold text-right text-lg"
                        }, toDisplayString(_ctx.$t("Total quantity")), 1),
                        createVNode("th", { class: "p-2 font-bold text-right text-lg" }, toDisplayString(_ctx.$decimal(unref(form).items.reduce((a, i) => Number(i.quantity) + a, 0))), 1),
                        createVNode("th")
                      ])
                    ])
                  ])
                ])) : (openBlock(), createBlock("label", {
                  key: 1,
                  for: "product-search",
                  class: "w-full block mt-4 rounded-md bg-gray-100 dark:bg-gray-800 py-2 px-4 text-primary-600 dark:text-primary-400"
                }, toDisplayString(_ctx.$t("Please add at least one product.")), 1))
              ]),
              createVNode("div", { class: "col-span-full flex flex-col gap-6" }, [
                createVNode(unref(_sfc_main$8), {
                  errors: unref(form).errors,
                  custom_fields: __props.custom_fields,
                  extra_attributes: unref(form).extra_attributes,
                  onUpdate: unref(saveForm)
                }, null, 8, ["errors", "custom_fields", "extra_attributes", "onUpdate"]),
                createVNode(unref(_sfc_main$9), {
                  onChange: unref(saveForm),
                  label: _ctx.$t("Details"),
                  modelValue: unref(form).details,
                  "onUpdate:modelValue": ($event) => unref(form).details = $event,
                  error: _ctx.$page.props.errors.details
                }, null, 8, ["onChange", "label", "modelValue", "onUpdate:modelValue", "error"])
              ])
            ];
          }
        }),
        actions: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="w-full flex items-center justify-between"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$3), {
              type: "button",
              onClick: unref(resetForm),
              class: "me-3"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Reset"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Reset")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`<div class="flex items-center justify-end"${_scopeId}>`);
            if (__props.current) {
              _push2(`<button type="button" class="btn-secondary"${ssrRenderAttr("loading", unref(form).processing)}${ssrIncludeBooleanAttr(unref(form).processing) ? " disabled" : ""}${_scopeId}>${ssrInterpolate(_ctx.$t("Save & go to listing"))}</button>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(ssrRenderComponent(unref(_sfc_main$4), {
              on: unref(form).recentlySuccessful,
              class: "ms-3 me-3"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Saved."))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Saved.")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$5), {
              type: "button",
              onClick: handleSubmit,
              class: { "opacity-25": unref(form).processing },
              loading: unref(form).processing
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Save"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div></div>`);
          } else {
            return [
              createVNode("div", { class: "w-full flex items-center justify-between" }, [
                createVNode(unref(_sfc_main$3), {
                  type: "button",
                  onClick: unref(resetForm),
                  class: "me-3"
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.$t("Reset")), 1)
                  ]),
                  _: 1
                }, 8, ["onClick"]),
                createVNode("div", { class: "flex items-center justify-end" }, [
                  __props.current ? (openBlock(), createBlock("button", {
                    key: 0,
                    type: "button",
                    class: "btn-secondary",
                    loading: unref(form).processing,
                    disabled: unref(form).processing,
                    onClick: (e) => handleSubmit(e, true)
                  }, toDisplayString(_ctx.$t("Save & go to listing")), 9, ["loading", "disabled", "onClick"])) : createCommentVNode("", true),
                  createVNode(unref(_sfc_main$4), {
                    on: unref(form).recentlySuccessful,
                    class: "ms-3 me-3"
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(_ctx.$t("Saved.")), 1)
                    ]),
                    _: 1
                  }, 8, ["on"]),
                  createVNode(unref(_sfc_main$5), {
                    type: "button",
                    onClick: handleSubmit,
                    class: { "opacity-25": unref(form).processing },
                    loading: unref(form).processing
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
                    ]),
                    _: 1
                  }, 8, ["class", "loading"])
                ])
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      if (unref(variantModal)) {
        _push(ssrRenderComponent(unref(SelectVariant), {
          item: unref(currentItem),
          show: unref(variantModal),
          onClose: () => {
            unref(currentItem).variations = unref(currentItem).variations.filter((v) => v.id);
            unref(form).items = unref(form).items.map((i) => i.product_id == unref(currentItem).product_id ? unref(currentItem) : i);
            variantModal.value = false;
          },
          onUpdate: (item) => {
            item.variations = item.variations.filter((v) => v.id);
            unref(form).items = unref(form).items.map((i) => i.product_id == item.product_id ? item : i);
            unref(saveForm)();
            variantModal.value = false;
          }
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Product/Transfer/Form.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
