import { mergeProps, unref, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderAttr, ssrInterpolate, ssrRenderList, ssrRenderComponent } from "vue/server-renderer";
import { B as _sfc_main$1, C as _sfc_main$2 } from "./http-CDixhmav.js";
import "./LoadingButton-DREeyNQW.js";
import "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./SectionTitle-CrLwNK7a.js";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "@inertiajs/vue3";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./InputError-DjBtKS5r.js";
import "./PrimaryButton-BFULsO35.js";
import "./SecondaryButton-CI1uhr4A.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputLabel-DXl8D0gR.js";
import "../ssr.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "lodash.debounce";
import "dayjs";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
const _sfc_main = {
  __name: "FormItem",
  __ssrInlineRender: true,
  props: ["item"],
  emits: ["edit", "update", "remove"],
  setup(__props, { emit: __emit }) {
    const emit = __emit;
    return (_ctx, _push, _parent, _attrs) => {
      var _a, _b, _c;
      if (((_a = _ctx.$page.props.settings) == null ? void 0 : _a.pos_design) == "Modern") {
        _push(`<li${ssrRenderAttrs(mergeProps({ class: "" }, _attrs))}><div class="bg-white dark:bg-gray-950 rounded-2xl mb-4 p-4 shadow-xl"><div class="min-w-0 grow flex items-start gap-x-3">`);
        if (__props.item.product.photo) {
          _push(`<img alt=""${ssrRenderAttr("src", __props.item.product.photo)} class="h-10 w-10 flex-none rounded-full mr-2 bg-gray-100 dark:bg-gray-800">`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="w-full"><button type="button" class="text-sm leading-6 hover:underline hover:underline-offset-4 font-bold flex items-center">${ssrInterpolate(__props.item.name)}</button>`);
        if (__props.item.variations && __props.item.variations.length) {
          _push(`<!--[-->`);
          ssrRenderList(__props.item.variations, (variation, vi) => {
            var _a2;
            _push(`<!--[--><div class="mt-5">${ssrInterpolate(_ctx.$meta(variation.meta))}</div><div class="text-sm leading-6 print:hidden flex flex-wrap items-center gap-x-2"><span>${ssrInterpolate(_ctx.$t("Price"))}: ${ssrInterpolate(_ctx.$currency(Number(__props.item.net_price)))}</span><span>${ssrInterpolate(_ctx.$t("Tax"))}: ${ssrInterpolate(_ctx.$currency(Number(__props.item.tax_amount)))}</span></div><div class="flex justify-end mt-2">`);
            _push(ssrRenderComponent(unref(_sfc_main$1), {
              min: 0,
              "del-on": 0,
              modelValue: variation.quantity,
              "onUpdate:modelValue": ($event) => variation.quantity = $event,
              onRemove: ($event) => emit("remove", variation),
              onChange: () => {
                __props.item.quantity = __props.item.variations.reduce((a, v) => Number(v.quantity) + a, 0);
                emit("update", __props.item);
              },
              max: variation.selected_store && variation.selected_store[0] ? (_a2 = variation.selected_store[0].pivot) == null ? void 0 : _a2.quantity : null
            }, null, _parent));
            _push(`</div><!--]-->`);
          });
          _push(`<!--]-->`);
        } else {
          _push(`<!--[--><div class="text-sm leading-6 print:hidden flex flex-wrap items-center gap-x-2"><span>${ssrInterpolate(_ctx.$t("Price"))}: ${ssrInterpolate(_ctx.$currency(Number(__props.item.net_price)))}</span><span>${ssrInterpolate(_ctx.$t("Tax"))}: ${ssrInterpolate(_ctx.$currency(Number(__props.item.tax_amount)))}</span></div><div class="flex justify-end mt-2">`);
          _push(ssrRenderComponent(unref(_sfc_main$1), {
            min: 0,
            "del-on": 0,
            modelValue: __props.item.quantity,
            "onUpdate:modelValue": ($event) => __props.item.quantity = $event,
            onRemove: ($event) => emit("remove", __props.item),
            onChange: ($event) => emit("update", __props.item),
            max: __props.item.selected_store && __props.item.selected_store[0] ? (_b = __props.item.selected_store[0].pivot) == null ? void 0 : _b.quantity : null
          }, null, _parent));
          _push(`</div><!--]-->`);
        }
        _push(`</div></div></div></li>`);
      } else {
        _push(`<!--[-->`);
        if (__props.item.product.has_variants && __props.item.variations && __props.item.variations.length) {
          _push(`<!--[--><li class="flex items-end justify-between gap-x-2 pt-2 mb-1"><div class="min-w-0 grow"><div class="flex items-start gap-x-3"><button type="button" class="text-sm leading-6 hover:underline hover:underline-offset-4 font-bold flex items-center">`);
          if (__props.item.product.photo) {
            _push(`<img alt=""${ssrRenderAttr("src", __props.item.product.photo)} class="h-6 w-6 flex-none rounded-full mr-2">`);
          } else {
            _push(`<!---->`);
          }
          _push(` ${ssrInterpolate(__props.item.name)}</button></div></div></li><!--[-->`);
          ssrRenderList(__props.item.variations, (variation, vi) => {
            var _a2;
            _push(`<li class="flex items-end justify-between gap-x-2 py-2 -mt-1 border-none">`);
            if (__props.item.product.photo) {
              _push(`<span class="block w-6"></span>`);
            } else {
              _push(`<!---->`);
            }
            _push(`<div class="min-w-0 grow"><div class="flex items-start gap-x-3">${ssrInterpolate(_ctx.$meta(variation.meta))}</div><div class="text-sm leading-6 print:hidden"><span>${ssrInterpolate(_ctx.$t("Price"))}: ${ssrInterpolate(_ctx.$currency(Number(variation.net_price)))}</span><span class="ml-1">${ssrInterpolate(_ctx.$t("Tax"))}: ${ssrInterpolate(_ctx.$currency(Number(variation.tax_amount)))}</span></div><div class="hidden print:flex text-right text-sm"><div class="w-[80px]">${ssrInterpolate(_ctx.$currency(__props.item.price))}</div><div class="w-[80px]">${ssrInterpolate(__props.item.quantity)}</div><div class="w-[120px]">${ssrInterpolate(_ctx.$currency(__props.item.total))}</div></div></div><div class="flex flex-none items-center gap-x-4 print:hidden mb-1">`);
            _push(ssrRenderComponent(unref(_sfc_main$2), {
              min: 0,
              "del-on": 0,
              modelValue: variation.quantity,
              "onUpdate:modelValue": ($event) => variation.quantity = $event,
              onRemove: ($event) => emit("remove", variation),
              onChange: () => {
                __props.item.quantity = __props.item.variations.reduce((a, v) => Number(v.quantity) + a, 0);
                emit("update", __props.item);
              },
              max: variation.selected_store && variation.selected_store[0] ? (_a2 = variation.selected_store[0].pivot) == null ? void 0 : _a2.quantity : null
            }, null, _parent));
            _push(`</div><div class="hidden print:flex text-right text-sm"><div class="w-[80px]">${ssrInterpolate(_ctx.$currency(variation.price))}</div><div class="w-[80px]">${ssrInterpolate(variation.quantity)}</div><div class="w-[120px]">${ssrInterpolate(_ctx.$currency(variation.total))}</div></div></li>`);
          });
          _push(`<!--]--><!--]-->`);
        } else {
          _push(`<li class="flex items-end justify-between gap-x-2 py-2"><div class="min-w-0 grow"><div class="flex items-start gap-x-3">`);
          if (__props.item.type == "Gift Card") {
            _push(`<div class="flex items-center">${ssrInterpolate(__props.item.name)} <span class="text-xs font-bold ml-1">(${ssrInterpolate(__props.item.code)})</span></div>`);
          } else {
            _push(`<button type="button" class="text-sm leading-6 hover:underline hover:underline-offset-4 font-bold flex items-center">`);
            if (__props.item.product.photo) {
              _push(`<img alt=""${ssrRenderAttr("src", __props.item.product.photo)} class="h-6 w-6 flex-none rounded-full mr-2">`);
            } else {
              _push(`<!---->`);
            }
            _push(` ${ssrInterpolate(__props.item.name)}</button>`);
          }
          if (__props.item == "Standard" && __props.item.selected_store && __props.item.selected_store[0]) {
            _push(`<p class="rounded-md whitespace-nowrap mt-0.5 px-1.5 py-0.5 text-xs font-medium ring-1 ring-inset text-green-700 bg-green-50 ring-green-600/20 print:hidden">${ssrInterpolate(_ctx.$decimal_qty(__props.item.selected_store[0].pivot.quantity))}</p>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div><div class="text-sm leading-6 print:hidden flex flex-wrap items-center gap-x-2">`);
          if (__props.item.product.photo) {
            _push(`<span class="block w-6"></span>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<span>${ssrInterpolate(_ctx.$t("Price"))}: ${ssrInterpolate(_ctx.$currency(Number(__props.item.net_price)))}</span><span>${ssrInterpolate(_ctx.$t("Tax"))}: ${ssrInterpolate(_ctx.$currency(Number(__props.item.tax_amount)))}</span></div></div><div class="flex flex-none items-center gap-x-4 print:hidden mb-1">`);
          _push(ssrRenderComponent(unref(_sfc_main$2), {
            min: 0,
            "del-on": 0,
            modelValue: __props.item.quantity,
            "onUpdate:modelValue": ($event) => __props.item.quantity = $event,
            onRemove: ($event) => emit("remove", __props.item),
            onChange: ($event) => emit("update", __props.item),
            max: __props.item.selected_store && __props.item.selected_store[0] ? (_c = __props.item.selected_store[0].pivot) == null ? void 0 : _c.quantity : null
          }, null, _parent));
          _push(`</div><div class="hidden print:flex text-right text-sm"><div class="w-[80px]">${ssrInterpolate(_ctx.$currency(__props.item.price))}</div><div class="w-[80px]">${ssrInterpolate(__props.item.quantity)}</div><div class="w-[120px]">${ssrInterpolate(_ctx.$currency(__props.item.total))}</div></div></li>`);
        }
        _push(`<!--]-->`);
      }
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Pos/Components/FormItem.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
