import { ref, resolveComponent, unref, withCtx, createTextVNode, toDisplayString, createVNode, createBlock, createCommentVNode, openBlock, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderClass } from "vue/server-renderer";
import { T } from "../ssr.js";
import { useI18n } from "vue-i18n";
import { useForm } from "@inertiajs/vue3";
import "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import { _ as _sfc_main$2 } from "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import "./http-CDixhmav.js";
import { _ as _sfc_main$3 } from "./LoadingButton-DREeyNQW.js";
import { _ as _sfc_main$1 } from "./AdminLayout-DHH3IgME.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
import "lodash.debounce";
import "dayjs";
import "@vuepic/vue-datepicker";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
import "./AppLayout-BRHmSgDa.js";
const _sfc_main = /* @__PURE__ */ Object.assign({ layout: _sfc_main$1 }, {
  __name: "Import",
  __ssrInlineRender: true,
  setup(__props) {
    const file = ref(null);
    const { t } = useI18n({});
    const selected = ref(null);
    const form = useForm({ _method: "POST", excel: null });
    function updateFile(e) {
      selected.value = e.target.files[0].name;
    }
    function submit() {
      if (file.value) {
        form.excel = file.value.files[0];
      }
      form.post(T("suppliers.import.save"), { preserveScroll: true });
    }
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Head = resolveComponent("Head");
      const _component_Link = resolveComponent("Link");
      const _component_Icons = resolveComponent("Icons");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_Head, {
        title: _ctx.$t("Import {x}", { x: unref(t)("Suppliers") })
      }, null, _parent));
      _push(`<div class="pt-6 pb-0 sm:py-8 px-0 sm:px-6 lg:px-8">`);
      _push(ssrRenderComponent(unref(_sfc_main$2), { onSubmitted: submit }, {
        title: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(unref(t)("Import {x}", { x: unref(t)("Suppliers") }))}`);
          } else {
            return [
              createTextVNode(toDisplayString(unref(t)("Import {x}", { x: unref(t)("Suppliers") })), 1)
            ];
          }
        }),
        description: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="w-full block sm:flex sm:items-start sm:justify-between lg:block"${_scopeId}><div${_scopeId}>${ssrInterpolate(unref(t)("Please upload the excel file to import records."))}</div><div class="mt-6 sm:mt-0 lg:mt-6 me-3"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_Link, {
              class: "link",
              href: unref(T)("suppliers.index")
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("List {x}", { x: _ctx.$t("Suppliers") }))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("List {x}", { x: _ctx.$t("Suppliers") })), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div></div>`);
          } else {
            return [
              createVNode("div", { class: "w-full block sm:flex sm:items-start sm:justify-between lg:block" }, [
                createVNode("div", null, toDisplayString(unref(t)("Please upload the excel file to import records.")), 1),
                createVNode("div", { class: "mt-6 sm:mt-0 lg:mt-6 me-3" }, [
                  createVNode(_component_Link, {
                    class: "link",
                    href: unref(T)("suppliers.index")
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(_ctx.$t("List {x}", { x: _ctx.$t("Suppliers") })), 1)
                    ]),
                    _: 1
                  }, 8, ["href"])
                ])
              ])
            ];
          }
        }),
        form: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="col-span-full"${_scopeId}><label for="file-upload" class="block font-medium"${_scopeId}>${ssrInterpolate(unref(t)("Excel File"))}</label><div class="${ssrRenderClass([_ctx.$page.props.errors.excel ? "border-red-500" : "border-gray-300 dark:border-gray-700", "mt-1 flex justify-center px-6 pt-5 pb-6 border-2 border-dashed rounded-md"])}"${_scopeId}><div class="space-y-1 text-center"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_Icons, {
              name: "doc-text",
              className: "mx-auto h-12 w-12 text-gray-400 dark:text-gray-600"
            }, null, _parent2, _scopeId));
            _push2(`<div class="flex items-center justify-center text-gray-600 dark:text-gray-400 py-2"${_scopeId}><label for="file-upload" class="relative cursor-pointer rounded-md font-medium link"${_scopeId}>`);
            if (selected.value) {
              _push2(`<span class="font-semibold"${_scopeId}>${ssrInterpolate(unref(t)("Change file"))}</span>`);
            } else {
              _push2(`<span class="font-semibold"${_scopeId}>${ssrInterpolate(unref(t)("Select file"))}</span>`);
            }
            _push2(`<input type="file" class="sr-only" id="file-upload" name="file-upload" accept=".xls,.xlsx,application/vnd.ms-excel"${_scopeId}></label><p class="pl-1"${_scopeId}>${ssrInterpolate(unref(t)("or drag and drop"))}</p></div><div class="text-xs text-gray-600 dark:text-gray-400"${_scopeId}><div${_scopeId}>${ssrInterpolate(unref(t)(
              "Excel file should have name, phone, email, company, due_limit, lot_no, street, address_line_1, address_line_2, city, postal_code, state and country columns."
            ))}</div><div class="mt-2"${_scopeId}>${ssrInterpolate(unref(t)("System will update the supplier if it has the same name, phone and email otherwise new supplier will be added."))}</div></div>`);
            if (selected.value) {
              _push2(`<div class="inline-block pt-4"${_scopeId}><div class="px-3 py-1 rounded-md border font-bold text-lg"${_scopeId}>${ssrInterpolate(unref(t)("Selected File"))}: ${ssrInterpolate(selected.value)}</div></div>`);
            } else {
              _push2(`<!---->`);
            }
            if (_ctx.$page.props.errors.excel) {
              _push2(`<div class="mt-4 pt-2 text-red-600 rounded-md"${_scopeId}>${ssrInterpolate(_ctx.$page.props.errors.excel)}</div>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`</div></div></div>`);
          } else {
            return [
              createVNode("div", { class: "col-span-full" }, [
                createVNode("label", {
                  for: "file-upload",
                  class: "block font-medium"
                }, toDisplayString(unref(t)("Excel File")), 1),
                createVNode("div", {
                  class: [_ctx.$page.props.errors.excel ? "border-red-500" : "border-gray-300 dark:border-gray-700", "mt-1 flex justify-center px-6 pt-5 pb-6 border-2 border-dashed rounded-md"]
                }, [
                  createVNode("div", { class: "space-y-1 text-center" }, [
                    createVNode(_component_Icons, {
                      name: "doc-text",
                      className: "mx-auto h-12 w-12 text-gray-400 dark:text-gray-600"
                    }),
                    createVNode("div", { class: "flex items-center justify-center text-gray-600 dark:text-gray-400 py-2" }, [
                      createVNode("label", {
                        for: "file-upload",
                        class: "relative cursor-pointer rounded-md font-medium link"
                      }, [
                        selected.value ? (openBlock(), createBlock("span", {
                          key: 0,
                          class: "font-semibold"
                        }, toDisplayString(unref(t)("Change file")), 1)) : (openBlock(), createBlock("span", {
                          key: 1,
                          class: "font-semibold"
                        }, toDisplayString(unref(t)("Select file")), 1)),
                        createVNode("input", {
                          ref_key: "file",
                          ref: file,
                          type: "file",
                          class: "sr-only",
                          id: "file-upload",
                          name: "file-upload",
                          onChange: updateFile,
                          accept: ".xls,.xlsx,application/vnd.ms-excel"
                        }, null, 544)
                      ]),
                      createVNode("p", { class: "pl-1" }, toDisplayString(unref(t)("or drag and drop")), 1)
                    ]),
                    createVNode("div", { class: "text-xs text-gray-600 dark:text-gray-400" }, [
                      createVNode("div", null, toDisplayString(unref(t)(
                        "Excel file should have name, phone, email, company, due_limit, lot_no, street, address_line_1, address_line_2, city, postal_code, state and country columns."
                      )), 1),
                      createVNode("div", { class: "mt-2" }, toDisplayString(unref(t)("System will update the supplier if it has the same name, phone and email otherwise new supplier will be added.")), 1)
                    ]),
                    selected.value ? (openBlock(), createBlock("div", {
                      key: 0,
                      class: "inline-block pt-4"
                    }, [
                      createVNode("div", { class: "px-3 py-1 rounded-md border font-bold text-lg" }, toDisplayString(unref(t)("Selected File")) + ": " + toDisplayString(selected.value), 1)
                    ])) : createCommentVNode("", true),
                    _ctx.$page.props.errors.excel ? (openBlock(), createBlock("div", {
                      key: 1,
                      class: "mt-4 pt-2 text-red-600 rounded-md"
                    }, toDisplayString(_ctx.$page.props.errors.excel), 1)) : createCommentVNode("", true)
                  ])
                ], 2)
              ])
            ];
          }
        }),
        actions: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(unref(_sfc_main$3), {
              loading: unref(form).processing,
              disabled: unref(form).processing
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(unref(t)("Import"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(unref(t)("Import")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(unref(_sfc_main$3), {
                loading: unref(form).processing,
                disabled: unref(form).processing
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(unref(t)("Import")), 1)
                ]),
                _: 1
              }, 8, ["loading", "disabled"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/People/Supplier/Import.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
