import { ref, resolveComponent, withCtx, createVNode, toDisplayString, createTextVNode, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderList } from "vue/server-renderer";
import { usePage, router } from "@inertiajs/vue3";
import _sfc_main$5 from "./Form-pzEnQqqh.js";
import { _ as _sfc_main$1 } from "./AdminLayout-DHH3IgME.js";
import "./ActionMessage-cgGHxf5V.js";
import { b as _sfc_main$4 } from "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import { e as _sfc_main$2, c as _sfc_main$3 } from "./http-CDixhmav.js";
import "./LoadingButton-DREeyNQW.js";
import "dayjs";
import "../ssr.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "vue-i18n";
import "lodash.debounce";
import "@vuepic/vue-datepicker";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
import "./AppLayout-BRHmSgDa.js";
const _sfc_main = /* @__PURE__ */ Object.assign({ layout: _sfc_main$1 }, {
  __name: "Index",
  __ssrInlineRender: true,
  props: ["promotions", "types"],
  setup(__props) {
    usePage();
    const add = ref(false);
    const current = ref(null);
    const deleted = ref(false);
    const deleting = ref(false);
    function editRow(row) {
      current.value = row;
      add.value = true;
    }
    function deleteRow(row) {
      deleting.value = true;
      router.delete(route("promotions.destroy", row.id), {
        preserveScroll: true,
        onSuccess: () => deleted.value = true,
        onFinish: () => deleting.value = false
      });
    }
    function hideForm() {
      current.value = null;
      add.value = false;
    }
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Head = resolveComponent("Head");
      const _component_Header = resolveComponent("Header");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_Head, null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<title${_scopeId}>${ssrInterpolate(_ctx.$t("Promotions"))}</title>`);
          } else {
            return [
              createVNode("title", null, toDisplayString(_ctx.$t("Promotions")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_Header, null, {
        subheading: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Please review the data below"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Please review the data below")), 1)
            ];
          }
        }),
        menu: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(unref(_sfc_main$2), {
              type: "button",
              onClick: ($event) => add.value = true
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Add {x}", { x: _ctx.$t("Promotion") }))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Add {x}", { x: _ctx.$t("Promotion") })), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(unref(_sfc_main$2), {
                type: "button",
                onClick: ($event) => add.value = true
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(_ctx.$t("Add {x}", { x: _ctx.$t("Promotion") })), 1)
                ]),
                _: 1
              }, 8, ["onClick"])
            ];
          }
        }),
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Promotions"))} `);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Promotions")) + " ", 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<div class="px-4 sm:px-6 lg:px-8"><div class="flow-root"><div class="-mx-4 -my-2 overflow-x-auto sm:-mx-6 lg:-mx-8"><div class="inline-block min-w-full py-2 align-middle"><table class="fixed-actions min-w-full divide-y dark:divide-gray-700"><thead><tr><th scope="col" class="py-3.5 pl-4 pr-3 text-left text-sm font-semibold text-focus sm:pl-6 lg:pl-8">${ssrInterpolate(_ctx.$t("Name"))}</th><th scope="col" class="py-3.5 pl-4 pr-3 text-left text-sm font-semibold text-focus sm:pl-6 lg:pl-8">${ssrInterpolate(_ctx.$t("Type"))}</th><th scope="col" class="py-3.5 pl-4 pr-3 text-left text-sm font-semibold text-focus sm:pl-6 lg:pl-8">${ssrInterpolate(_ctx.$t("Discount"))}</th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus">${ssrInterpolate(_ctx.$t("Active"))}</th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus whitespace-nowrap">${ssrInterpolate(_ctx.$t("Start Date"))}</th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus whitespace-nowrap">${ssrInterpolate(_ctx.$t("End Date"))}</th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus whitespace-nowrap">${ssrInterpolate(_ctx.$t("To Buy"))}</th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus whitespace-nowrap">${ssrInterpolate(_ctx.$t("To Get"))}</th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus">${ssrInterpolate(_ctx.$t("Details"))}</th><th scope="col" class="relative py-3.5 pl-3 pr-4 sm:pr-6 lg:pr-8"><span class="sr-only">${ssrInterpolate(_ctx.$t("Actions"))}</span></th></tr></thead><tbody class="divide-y dark:divide-gray-700 bg-white dark:bg-gray-900">`);
      if (__props.promotions && __props.promotions.data && __props.promotions.data.length) {
        _push(`<!--[-->`);
        ssrRenderList(__props.promotions.data, (row) => {
          _push(`<tr><td class="whitespace-nowrap py-4 pl-4 pr-3 text-sm font-medium text-focus sm:pl-6 lg:pl-8">${ssrInterpolate(row.name)}</td><td class="whitespace-nowrap py-4 pl-4 pr-3 text-sm font-medium text-focus sm:pl-6 lg:pl-8">${ssrInterpolate(_ctx.$capitalize(row.type))}</td><td class="whitespace-nowrap px-3 py-4 text-sm text-center">${ssrInterpolate(row.discount != 0 ? _ctx.$number(row.discount) + (row.discount_method == "percentage" ? "%" : "") : "")}</td><td class="whitespace-nowrap px-3 py-4 text-sm"><span>${_ctx.$boolean(row.active, true) ?? ""}</span></td><td class="whitespace-nowrap px-3 py-4 text-sm">${ssrInterpolate(_ctx.$date(row.start_date))}</td><td class="whitespace-nowrap px-3 py-4 text-sm">${ssrInterpolate(_ctx.$date(row.end_date))}</td><td class="whitespace-nowrap px-3 py-4 text-sm w-16 text-center">${ssrInterpolate(row.quantity_to_buy ? _ctx.$t("Qty:") + " " + _ctx.$number(row.quantity_to_buy) : "")}</td><td class="whitespace-nowrap px-3 py-4 text-sm w-16 text-center">${ssrInterpolate(row.product_id_to_get ? row.quantity_to_get ? _ctx.$t("Qty:") + " " + _ctx.$number(row.quantity_to_get) : "" : "")}</td><td class="px-3 py-4 text-sm"><div class="min-w-56 max-w-xs line-clamp-2">${ssrInterpolate(row.details || "")}</div></td><td class="relative whitespace-nowrap py-4 pl-3 pr-4 text-right text-sm font-medium sm:pr-6 lg:pr-8">`);
          _push(ssrRenderComponent(unref(_sfc_main$3), {
            row,
            record: _ctx.$t("Promotion"),
            editRow,
            deleted: deleted.value,
            deleting: deleting.value,
            deleteRow
          }, null, _parent));
          _push(`</td></tr>`);
        });
        _push(`<!--]-->`);
      } else {
        _push(`<tr><td colspan="100%"><div class="whitespace-nowrap pl-4 pr-3 py-3.5 text-sm font-light text-mute sm:pl-2 lg:pl-4">${ssrInterpolate(_ctx.$t("There is no data to display!"))}</div></td></tr>`);
      }
      _push(`</tbody></table></div></div></div>`);
      _push(ssrRenderComponent(unref(_sfc_main$4), {
        show: add.value,
        backdrop: false,
        "max-width": "2xl",
        closeable: true,
        onClose: hideForm
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_sfc_main$5, {
              current: current.value,
              types: __props.types,
              onClose: hideForm,
              onDone: hideForm
            }, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(_sfc_main$5, {
                current: current.value,
                types: __props.types,
                onClose: hideForm,
                onDone: hideForm
              }, null, 8, ["current", "types"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Product/Promotion/Index.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
