import { ref, onMounted, resolveComponent, withCtx, createVNode, toDisplayString, createTextVNode, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderList, ssrRenderAttr } from "vue/server-renderer";
import { usePage, router } from "@inertiajs/vue3";
import _sfc_main$9 from "./QuickView-DaWb2lTv.js";
import { P as PageSearch } from "./PageSearch-CiHIJpyQ.js";
import "./ActionMessage-cgGHxf5V.js";
import { b as _sfc_main$8 } from "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import { _ as _sfc_main$3 } from "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import { _ as _sfc_main$1 } from "./AdminLayout-DHH3IgME.js";
import { e as _sfc_main$2, b as _sfc_main$4, _ as _sfc_main$5, c as _sfc_main$6, d as _sfc_main$7 } from "./http-CDixhmav.js";
import "./LoadingButton-DREeyNQW.js";
import "../ssr.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "lodash.debounce";
import "dayjs";
import "jsbarcode";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
import "./AppLayout-BRHmSgDa.js";
import "notiwind";
import "vue-i18n";
import "@vuepic/vue-datepicker";
import "lodash.isequal";
import "axios";
import "lodash.throttle";
const _sfc_main = /* @__PURE__ */ Object.assign({ layout: _sfc_main$1 }, {
  __name: "Index",
  __ssrInlineRender: true,
  props: ["pagination", "taxes", "selected_store", "stores"],
  setup(__props) {
    const page = usePage();
    const props = __props;
    const view = ref(false);
    const photo = ref(null);
    const current = ref(null);
    const deleted = ref(false);
    const deleting = ref(false);
    const { filters, searching, searchNow } = PageSearch();
    onMounted(() => {
      if (props.selected_store) {
        filters.value.store = page.props.filters.store || props.selected_store;
      }
    });
    function editRow(row) {
      router.visit(route("products.edit", { product: row.id }));
    }
    function deleteRow(row) {
      deleting.value = true;
      router.delete(route("products.destroy", row.id), {
        preserveScroll: true,
        onSuccess: () => deleted.value = true,
        onFinish: () => deleting.value = false
      });
    }
    return (_ctx, _push, _parent, _attrs) => {
      var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p, _q, _r;
      const _component_Head = resolveComponent("Head");
      const _component_Header = resolveComponent("Header");
      const _component_Icon = resolveComponent("Icon");
      const _component_spam = resolveComponent("spam");
      const _component_Link = resolveComponent("Link");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_Head, null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<title${_scopeId}>${ssrInterpolate(_ctx.$t("Products"))}</title>`);
          } else {
            return [
              createVNode("title", null, toDisplayString(_ctx.$t("Products")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_Header, null, {
        subheading: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Please review the data below"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Please review the data below")), 1)
            ];
          }
        }),
        menu: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex items-center justify-center gap-4"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$2), {
              href: _ctx.route("products.create")
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Add {x}", { x: _ctx.$t("Product") }))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Add {x}", { x: _ctx.$t("Product") })), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$3), {
              align: "right",
              width: "56",
              "auto-close": false
            }, {
              trigger: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<button class="flex items-center -m-2 p-2.5 rounded-md transition duration-150 ease-in-out"${_scopeId2}>`);
                  _push3(ssrRenderComponent(_component_Icon, {
                    name: "funnel-o",
                    size: "size-5"
                  }, null, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_spam, { class: "sr-only" }, {
                    default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(`${ssrInterpolate(_ctx.$t("Show Filters"))}`);
                      } else {
                        return [
                          createTextVNode(toDisplayString(_ctx.$t("Show Filters")), 1)
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                  _push3(`</button>`);
                } else {
                  return [
                    createVNode("button", { class: "flex items-center -m-2 p-2.5 rounded-md transition duration-150 ease-in-out" }, [
                      createVNode(_component_Icon, {
                        name: "funnel-o",
                        size: "size-5"
                      }),
                      createVNode(_component_spam, { class: "sr-only" }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(_ctx.$t("Show Filters")), 1)
                        ]),
                        _: 1
                      })
                    ])
                  ];
                }
              }),
              content: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<div class="px-4 py-2"${_scopeId2}><div class="mb-4"${_scopeId2}>`);
                  _push3(ssrRenderComponent(unref(_sfc_main$4), {
                    json: true,
                    id: "store_id",
                    clearable: true,
                    searchable: false,
                    label: _ctx.$t("Store"),
                    onChange: unref(searchNow),
                    suggestions: __props.stores,
                    modelValue: unref(filters).store,
                    "onUpdate:modelValue": ($event) => unref(filters).store = $event
                  }, null, _parent3, _scopeId2));
                  _push3(`</div><div${_scopeId2}>`);
                  _push3(ssrRenderComponent(unref(_sfc_main$4), {
                    json: true,
                    onChange: unref(searchNow),
                    label: _ctx.$t("Trashed"),
                    modelValue: unref(filters).trashed,
                    "onUpdate:modelValue": ($event) => unref(filters).trashed = $event,
                    placeholder: _ctx.$t("With Trashed"),
                    suggestions: [
                      { value: "not", label: _ctx.$t("Not Trashed") },
                      { value: "with", label: _ctx.$t("With Trashed") },
                      { value: "only", label: _ctx.$t("Only Trashed") }
                    ]
                  }, null, _parent3, _scopeId2));
                  _push3(`</div></div>`);
                } else {
                  return [
                    createVNode("div", { class: "px-4 py-2" }, [
                      createVNode("div", { class: "mb-4" }, [
                        createVNode(unref(_sfc_main$4), {
                          json: true,
                          id: "store_id",
                          clearable: true,
                          searchable: false,
                          label: _ctx.$t("Store"),
                          onChange: unref(searchNow),
                          suggestions: __props.stores,
                          modelValue: unref(filters).store,
                          "onUpdate:modelValue": ($event) => unref(filters).store = $event
                        }, null, 8, ["label", "onChange", "suggestions", "modelValue", "onUpdate:modelValue"])
                      ]),
                      createVNode("div", null, [
                        createVNode(unref(_sfc_main$4), {
                          json: true,
                          onChange: unref(searchNow),
                          label: _ctx.$t("Trashed"),
                          modelValue: unref(filters).trashed,
                          "onUpdate:modelValue": ($event) => unref(filters).trashed = $event,
                          placeholder: _ctx.$t("With Trashed"),
                          suggestions: [
                            { value: "not", label: _ctx.$t("Not Trashed") },
                            { value: "with", label: _ctx.$t("With Trashed") },
                            { value: "only", label: _ctx.$t("Only Trashed") }
                          ]
                        }, null, 8, ["onChange", "label", "modelValue", "onUpdate:modelValue", "placeholder", "suggestions"])
                      ])
                    ])
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "flex items-center justify-center gap-4" }, [
                createVNode(unref(_sfc_main$2), {
                  href: _ctx.route("products.create")
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.$t("Add {x}", { x: _ctx.$t("Product") })), 1)
                  ]),
                  _: 1
                }, 8, ["href"]),
                createVNode(unref(_sfc_main$3), {
                  align: "right",
                  width: "56",
                  "auto-close": false
                }, {
                  trigger: withCtx(() => [
                    createVNode("button", { class: "flex items-center -m-2 p-2.5 rounded-md transition duration-150 ease-in-out" }, [
                      createVNode(_component_Icon, {
                        name: "funnel-o",
                        size: "size-5"
                      }),
                      createVNode(_component_spam, { class: "sr-only" }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(_ctx.$t("Show Filters")), 1)
                        ]),
                        _: 1
                      })
                    ])
                  ]),
                  content: withCtx(() => [
                    createVNode("div", { class: "px-4 py-2" }, [
                      createVNode("div", { class: "mb-4" }, [
                        createVNode(unref(_sfc_main$4), {
                          json: true,
                          id: "store_id",
                          clearable: true,
                          searchable: false,
                          label: _ctx.$t("Store"),
                          onChange: unref(searchNow),
                          suggestions: __props.stores,
                          modelValue: unref(filters).store,
                          "onUpdate:modelValue": ($event) => unref(filters).store = $event
                        }, null, 8, ["label", "onChange", "suggestions", "modelValue", "onUpdate:modelValue"])
                      ]),
                      createVNode("div", null, [
                        createVNode(unref(_sfc_main$4), {
                          json: true,
                          onChange: unref(searchNow),
                          label: _ctx.$t("Trashed"),
                          modelValue: unref(filters).trashed,
                          "onUpdate:modelValue": ($event) => unref(filters).trashed = $event,
                          placeholder: _ctx.$t("With Trashed"),
                          suggestions: [
                            { value: "not", label: _ctx.$t("Not Trashed") },
                            { value: "with", label: _ctx.$t("With Trashed") },
                            { value: "only", label: _ctx.$t("Only Trashed") }
                          ]
                        }, null, 8, ["onChange", "label", "modelValue", "onUpdate:modelValue", "placeholder", "suggestions"])
                      ])
                    ])
                  ]),
                  _: 1
                })
              ])
            ];
          }
        }),
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Products"))} `);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Products")) + " ", 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<div class="relative px-4 sm:px-6 lg:px-8 bg-white dark:bg-gray-800 grow self-stretch flex flex-col items-stretch justify-stretch">`);
      if (unref(searching)) {
        _push(ssrRenderComponent(unref(_sfc_main$5), { "circle-size": "w-10 h-10" }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="flow-root grow"><div class="-mx-4 -my-2 overflow-x-auto sm:-mx-6 lg:-mx-8"><div class="inline-block min-w-full my-2 align-middle border-b border-gray-200 dark:border-gray-700"><table class="fixed-actions min-w-full divide-y dark:divide-gray-700"><thead><tr><th scope="col" class="py-3.5 pl-4 pr-3 text-center text-sm font-semibold text-focus sm:pl-6 lg:pl-8 w-16"><span class="sr-only">${ssrInterpolate(_ctx.$t("Photo"))}</span>`);
      _push(ssrRenderComponent(_component_Icon, {
        name: "photo",
        size: "size-5 m-auto"
      }, null, _parent));
      _push(`</th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Name"))} `);
      if ((_b = (_a = unref(filters)) == null ? void 0 : _a.sort) == null ? void 0 : _b.startsWith("name:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "name:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Code"))} `);
      if ((_d = (_c = unref(filters)) == null ? void 0 : _c.sort) == null ? void 0 : _d.startsWith("code:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "code:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Type"))} `);
      if ((_f = (_e = unref(filters)) == null ? void 0 : _e.sort) == null ? void 0 : _f.startsWith("type:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "type:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Brand"))} `);
      if ((_h = (_g = unref(filters)) == null ? void 0 : _g.sort) == null ? void 0 : _h.startsWith("brand.name:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "brand.name:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Category"))} `);
      if ((_j = (_i = unref(filters)) == null ? void 0 : _i.sort) == null ? void 0 : _j.startsWith("category.name:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "category.name:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Supplier"))} `);
      if ((_l = (_k = unref(filters)) == null ? void 0 : _k.sort) == null ? void 0 : _l.startsWith("supplier.company:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "supplier.company:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus">${ssrInterpolate(_ctx.$t("Quantity"))}</th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus">${ssrInterpolate(_ctx.$t("Unit"))}</th>`);
      if (_ctx.$can("show-cost")) {
        _push(`<th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Cost"))} `);
        if ((_n = (_m = unref(filters)) == null ? void 0 : _m.sort) == null ? void 0 : _n.startsWith("cost:")) {
          _push(ssrRenderComponent(_component_Icon, {
            size: "size-3 text-mute",
            name: unref(filters).sort == "cost:desc" ? "c-up" : "c-down"
          }, null, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`</button></th>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Price"))} `);
      if ((_p = (_o = unref(filters)) == null ? void 0 : _o.sort) == null ? void 0 : _p.startsWith("price:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "price:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus">${ssrInterpolate(_ctx.$t("Taxes"))}</th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Rack Location"))} `);
      if ((_r = (_q = unref(filters)) == null ? void 0 : _q.sort) == null ? void 0 : _r.startsWith("rack_location:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "rack_location:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="relative py-3.5 pl-3 pr-4 sm:pr-6 lg:pr-8 w-16"><span class="sr-only">${ssrInterpolate(_ctx.$t("Actions"))}</span></th></tr></thead><tbody class="divide-y dark:divide-gray-700 bg-white dark:bg-gray-900">`);
      if (__props.pagination && __props.pagination.data && __props.pagination.data.length) {
        _push(`<!--[-->`);
        ssrRenderList(__props.pagination.data, (row) => {
          var _a2, _b2, _c2, _d2, _e2, _f2, _g2, _h2, _i2, _j2, _k2, _l2, _m2, _n2, _o2, _p2, _q2, _r2, _s, _t, _u;
          _push(`<tr><td class="whitespace-nowrap py-4 pl-4 pr-3 text-sm font-medium text-focus sm:pl-6 lg:pl-8 w-14">`);
          if (row.photo) {
            _push(`<button type="button" class="-my-4 w-8 h-8 flex items-center justify-center"><img alt=""${ssrRenderAttr("src", row.photo)} class="rounded max-w-full max-h-full"></button>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</td><td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm font-semibold">${ssrInterpolate(row.name)}</td><td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm">${ssrInterpolate(row.code)}</td><td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm">${ssrInterpolate(row.type)}</td><td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm">${ssrInterpolate(((_a2 = row.brand) == null ? void 0 : _a2.name) || "")}</td><td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm">${ssrInterpolate((_b2 = row.category) == null ? void 0 : _b2.name)}</td>`);
          if (_ctx.$can("show-cost")) {
            _push(`<td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm">${ssrInterpolate(((_c2 = row.supplier) == null ? void 0 : _c2.company) || ((_d2 = row.supplier) == null ? void 0 : _d2.name) || "")}</td>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm text-right">${ssrInterpolate(row.dont_track_stock || row.type != "Standard" ? "" : _ctx.$number_qty(
            __props.selected_store || unref(filters).store ? (_f2 = (_e2 = row.stocks) == null ? void 0 : _e2.find((s) => s.store_id == unref(filters).store || __props.selected_store)) == null ? void 0 : _f2.balance : (_g2 = row.stocks) == null ? void 0 : _g2.reduce((a, s) => Number(s.balance) + a, 0)
          ))}</td>`);
          if (_ctx.$can("show-cost")) {
            _push(`<td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm">${ssrInterpolate(((_h2 = row.unit) == null ? void 0 : _h2.name) || "")}</td>`);
          } else {
            _push(`<!---->`);
          }
          if (_ctx.$can("show-cost")) {
            _push(`<td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm text-right">${ssrInterpolate(_ctx.$currency(row.cost))}</td>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm text-right">${ssrInterpolate(_ctx.$currency(__props.selected_store ? ((_k2 = (_j2 = (_i2 = row.stores) == null ? void 0 : _i2.find((s) => s.id == __props.selected_store)) == null ? void 0 : _j2.pivot) == null ? void 0 : _k2.price) || row.price : row.price))}</td><td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm">${ssrInterpolate(__props.selected_store || unref(filters).store ? ((_q2 = (_p2 = (_o2 = (_n2 = (_m2 = (_l2 = row.stores) == null ? void 0 : _l2.find((s) => s.id == __props.selected_store || unref(filters).store)) == null ? void 0 : _m2.pivot) == null ? void 0 : _n2.taxes) == null ? void 0 : _o2.taxes) == null ? void 0 : _p2.map((t) => t.name)) == null ? void 0 : _q2.join(", ")) || ((_s = (_r2 = row.taxes) == null ? void 0 : _r2.map((t) => t.name)) == null ? void 0 : _s.join(", ")) : ((_u = (_t = row.taxes) == null ? void 0 : _t.map((t) => t.name)) == null ? void 0 : _u.join(", ")) || "")}</td><td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm">${ssrInterpolate(row.rack_location || "")}</td><td class="relative whitespace-nowrap py-4 pl-3 pr-4 text-right text-sm font-medium sm:pr-6 lg:pr-8 w-16"><div class="flex items-center justify-end gap-4 text-mute">`);
          if (!row.dont_track_stock && row.type == "Standard") {
            _push(ssrRenderComponent(_component_Link, {
              class: "link",
              href: _ctx.route("products.track", { product: row.id })
            }, {
              default: withCtx((_, _push2, _parent2, _scopeId) => {
                if (_push2) {
                  _push2(ssrRenderComponent(_component_Icon, {
                    name: "d-arrows",
                    size: "size-5"
                  }, null, _parent2, _scopeId));
                } else {
                  return [
                    createVNode(_component_Icon, {
                      name: "d-arrows",
                      size: "size-5"
                    })
                  ];
                }
              }),
              _: 2
            }, _parent));
          } else {
            _push(`<!---->`);
          }
          _push(ssrRenderComponent(unref(_sfc_main$6), {
            row,
            record: _ctx.$t("Product"),
            editRow,
            deleted: deleted.value,
            deleting: deleting.value,
            deleteRow
          }, null, _parent));
          _push(`</div></td></tr>`);
        });
        _push(`<!--]-->`);
      } else {
        _push(`<tr><td colspan="100%"><div class="whitespace-nowrap pl-4 pr-3 py-3.5 text-sm font-light text-mute sm:pl-2 lg:pl-4">${ssrInterpolate(_ctx.$t("There is no data to display!"))}</div></td></tr>`);
      }
      _push(`</tbody></table></div></div></div><div class="-mx-4 sm:-mx-6 lg:-mx-8">`);
      _push(ssrRenderComponent(unref(_sfc_main$7), {
        class: "mt-auto mx-4 sm:mx-6 py-2 text-sm",
        meta: __props.pagination.meta,
        links: __props.pagination.links
      }, null, _parent));
      _push(`</div>`);
      _push(ssrRenderComponent(unref(_sfc_main$8), {
        show: view.value,
        "max-width": "3xl",
        onClose: ($event) => view.value = false
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_sfc_main$9, {
              current: current.value,
              onClose: ($event) => view.value = false,
              editRow
            }, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(_sfc_main$9, {
                current: current.value,
                onClose: ($event) => view.value = false,
                editRow
              }, null, 8, ["current", "onClose"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$8), {
        show: photo.value,
        "max-width": "2xl",
        transparent: true,
        onClose: () => photo.value = null
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex items-center justify-center"${_scopeId}><img alt=""${ssrRenderAttr("src", photo.value)} class="rounded-md w-full h-full max-w-full min-h-24 max-h-screen"${_scopeId}></div>`);
          } else {
            return [
              createVNode("div", { class: "flex items-center justify-center" }, [
                createVNode("img", {
                  alt: "",
                  src: photo.value,
                  class: "rounded-md w-full h-full max-w-full min-h-24 max-h-screen"
                }, null, 8, ["src"])
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Product/Index.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
