import { ref, onMounted, resolveComponent, withCtx, createVNode, toDisplayString, unref, createTextVNode, withDirectives, createBlock, createCommentVNode, vShow, withModifiers, openBlock, vModelRadio, version, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderStyle, ssrRenderAttr, ssrIncludeBooleanAttr, ssrLooseEqual } from "vue/server-renderer";
import { T } from "../ssr.js";
import { useI18n } from "vue-i18n";
import { usePage, useForm, router } from "@inertiajs/vue3";
import { _ as _sfc_main$1 } from "./AdminLayout-DHH3IgME.js";
import { E as _sfc_main$2, h as _sfc_main$9, b as _sfc_main$a, s as _sfc_main$b, l as _sfc_main$d } from "./http-CDixhmav.js";
import { _ as _sfc_main$5 } from "./LoadingButton-DREeyNQW.js";
import { _ as _sfc_main$4 } from "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import { _ as _sfc_main$3 } from "./FormSection-C7JuSy06.js";
import { a as _sfc_main$8, _ as _sfc_main$c } from "./InputError-DjBtKS5r.js";
import { _ as _sfc_main$6 } from "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import { _ as _sfc_main$7 } from "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "./AppLayout-BRHmSgDa.js";
import "notiwind";
import "lodash.debounce";
import "dayjs";
import "@vuepic/vue-datepicker";
import "lodash.isequal";
import "axios";
import "lodash.throttle";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = /* @__PURE__ */ Object.assign({ layout: _sfc_main$1 }, {
  __name: "Index",
  __ssrInlineRender: true,
  props: {
    current: Object,
    accounts: Array,
    categories: Array,
    countries: Array,
    timezones: Array,
    taxes: Array,
    laravel_version: String
  },
  setup(__props) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _A, _B, _C, _D, _E, _F, _G, _H, _I, _J, _K, _L, _M, _N, _O, _P, _Q, _R, _S, _T, _U, _V, _W, _X, _Y, _Z;
    usePage();
    const { t } = useI18n({});
    const props = __props;
    const country = ref({ states: [] });
    if ((_a = props.current) == null ? void 0 : _a.country_id) {
      country.value = props.countries.find((c) => c.id == props.current.country_id);
    }
    const form = useForm({
      _method: ((_b = props.current) == null ? void 0 : _b.id) ? "put" : "post",
      icon: null,
      icon_dark: null,
      logo: null,
      logo_dark: null,
      name: (_c = props.current) == null ? void 0 : _c.name,
      short_name: (_d = props.current) == null ? void 0 : _d.short_name,
      company: (_e = props.current) == null ? void 0 : _e.company,
      reg_no: (_f = props.current) == null ? void 0 : _f.reg_no,
      email: (_g = props.current) == null ? void 0 : _g.email,
      phone: (_h = props.current) == null ? void 0 : _h.phone,
      country_id: (_i = props.current) == null ? void 0 : _i.country_id,
      state_id: (_j = props.current) == null ? void 0 : _j.state_id,
      lot_no: (_k = props.current) == null ? void 0 : _k.lot_no,
      street: (_l = props.current) == null ? void 0 : _l.street,
      address_line_1: (_m = props.current) == null ? void 0 : _m.address_line_1,
      address_line_2: (_n = props.current) == null ? void 0 : _n.address_line_2,
      city: (_o = props.current) == null ? void 0 : _o.city,
      postal_code: (_p = props.current) == null ? void 0 : _p.postal_code,
      timezone_id: (_q = props.current) == null ? void 0 : _q.timezone_id,
      default_account: (_r = props.current) == null ? void 0 : _r.default_account,
      theme: (_s = props.current) == null ? void 0 : _s.theme,
      hide_id: (_t = props.current) == null ? void 0 : _t.hide_id,
      rows_per_page: (_u = props.current) == null ? void 0 : _u.rows_per_page,
      language: (_v = props.current) == null ? void 0 : _v.language,
      date_number_locale: (_w = props.current) == null ? void 0 : _w.date_number_locale,
      date_format: (_x = props.current) == null ? void 0 : _x.date_format,
      fraction: (_y = props.current) == null ? void 0 : _y.fraction,
      quantity_fraction: (_z = props.current) == null ? void 0 : _z.quantity_fraction,
      max_discount: (_A = props.current) == null ? void 0 : _A.max_discount,
      confirmation: (_B = props.current) == null ? void 0 : _B.confirmation,
      dimension_unit: (_C = props.current) == null ? void 0 : _C.dimension_unit,
      weight_unit: (_D = props.current) == null ? void 0 : _D.weight_unit,
      reference: (_E = props.current) == null ? void 0 : _E.reference,
      inventory_accounting: (_F = props.current) == null ? void 0 : _F.inventory_accounting,
      search_delay: (_G = props.current) == null ? void 0 : _G.search_delay,
      stock: ((_H = props.current) == null ? void 0 : _H.stock) == 1,
      overselling: ((_I = props.current) == null ? void 0 : _I.overselling) == 1,
      impersonation: ((_J = props.current) == null ? void 0 : _J.impersonation) == 1,
      require_country: ((_K = props.current) == null ? void 0 : _K.require_country) == 1,
      show_image: ((_L = props.current) == null ? void 0 : _L.show_image) == 1,
      show_tax: ((_M = props.current) == null ? void 0 : _M.show_tax) == 1,
      show_tax_summary: ((_N = props.current) == null ? void 0 : _N.show_tax_summary) == 1,
      show_discount: ((_O = props.current) == null ? void 0 : _O.show_discount) == 1,
      show_zero_taxes: ((_P = props.current) == null ? void 0 : _P.show_zero_taxes) == 1,
      loyalty: ((_Q = props.current) == null ? void 0 : _Q.loyalty) || {
        staff: { spent: null, points: null },
        customer: { spent: null, points: null }
      },
      product_taxes: (_R = props.current) == null ? void 0 : _R.product_taxes,
      inclusive_tax_formula: (_S = props.current) == null ? void 0 : _S.inclusive_tax_formula,
      receipt_header: (_T = props.current) == null ? void 0 : _T.receipt_header,
      receipt_footer: (_U = props.current) == null ? void 0 : _U.receipt_footer,
      support_links: ((_V = props.current) == null ? void 0 : _V.support_links) == 1,
      dark_sidebar: ((_W = props.current) == null ? void 0 : _W.dark_sidebar) == 1,
      dark_topbar: ((_X = props.current) == null ? void 0 : _X.dark_topbar) == 1,
      sidebar_dropdown: ((_Y = props.current) == null ? void 0 : _Y.sidebar_dropdown) == 1,
      sidebar_scroll_to_view: ((_Z = props.current) == null ? void 0 : _Z.sidebar_scroll_to_view) == 1
    });
    const iconInput = ref(null);
    const logoInput = ref(null);
    const app_version = ref(null);
    const iconPreview = ref(null);
    const logoPreview = ref(null);
    const iconDarkInput = ref(null);
    const logoDarkInput = ref(null);
    const iconDarkPreview = ref(null);
    const logoDarkPreview = ref(null);
    ref(false);
    const tab_links = ref([
      { label: t("General Settings"), route: "settings.index", icon: "settings" },
      { label: t("Mail Settings"), route: "settings.mail", icon: "envelope" },
      { label: t("Payment Settings"), route: "settings.payment", icon: "dollar" },
      { label: t("Scale Barcode Settings"), route: "settings.barcode", icon: "scale" }
    ]);
    if (T().has("settings.pos")) {
      tab_links.value.push({ label: t("POS Settings"), route: "settings.pos", icon: "pos" });
    }
    onMounted(async () => {
      let composer = await import("./composer-CZhGkkLH.js");
      app_version.value = composer.version;
    });
    const save = () => {
      if (iconInput.value) {
        form.icon = iconInput.value.files[0];
      }
      if (iconDarkInput.value) {
        form.icon_dark = iconDarkInput.value.files[0];
      }
      if (logoInput.value) {
        form.logo = logoInput.value.files[0];
      }
      if (logoDarkInput.value) {
        form.logo_dark = logoDarkInput.value.files[0];
      }
      form.post(T("settings.store"), {
        onSuccess: () => {
          clearLogoFileInput();
          clearLogoFileInput(true);
        }
      });
    };
    const selectNewIcon = (dark) => {
      if (dark) {
        iconDarkInput.value.click();
      } else {
        iconInput.value.click();
      }
    };
    const selectNewLogo = (dark) => {
      if (dark) {
        logoDarkInput.value.click();
      } else {
        logoInput.value.click();
      }
    };
    const updateIconPreview = (dark) => {
      if (dark) {
        const iconDark = iconDarkInput.value.files[0];
        if (!iconDark) return;
        const reader = new FileReader();
        reader.onload = (e) => {
          iconDarkPreview.value = e.target.result;
        };
        reader.readAsDataURL(iconDark);
      } else {
        const icon = iconInput.value.files[0];
        if (!icon) return;
        const reader = new FileReader();
        reader.onload = (e) => {
          iconPreview.value = e.target.result;
        };
        reader.readAsDataURL(icon);
      }
    };
    const updateLogoPreview = (dark) => {
      if (dark) {
        const logoDark = logoDarkInput.value.files[0];
        if (!logoDark) return;
        const reader = new FileReader();
        reader.onload = (e) => {
          logoDarkPreview.value = e.target.result;
        };
        reader.readAsDataURL(logoDark);
      } else {
        const logo = logoInput.value.files[0];
        if (!logo) return;
        const reader = new FileReader();
        reader.onload = (e) => {
          logoPreview.value = e.target.result;
        };
        reader.readAsDataURL(logo);
      }
    };
    const deleteIcon = (dark) => {
      router.delete(T("settings.icon.destroy", { dark }), {
        preserveScroll: true,
        onSuccess: () => {
          if (dark) {
            iconDarkPreview.value = null;
            clearIconFileInput(dark);
          } else {
            iconPreview.value = null;
            clearIconFileInput();
          }
        }
      });
    };
    const deleteLogo = (dark) => {
      router.delete(T("settings.logo.destroy", { dark }), {
        preserveScroll: true,
        onSuccess: () => {
          if (dark) {
            logoDarkPreview.value = null;
            clearLogoFileInput(dark);
          } else {
            logoPreview.value = null;
            clearLogoFileInput();
          }
        }
      });
    };
    const clearIconFileInput = (dark) => {
      var _a2, _b2;
      if (dark && ((_a2 = iconDarkInput.value) == null ? void 0 : _a2.value)) {
        iconDarkInput.value.value = null;
      } else if ((_b2 = iconInput.value) == null ? void 0 : _b2.value) {
        iconInput.value.value = null;
      }
    };
    const clearLogoFileInput = (dark) => {
      var _a2, _b2;
      if (dark && ((_a2 = logoDarkInput.value) == null ? void 0 : _a2.value)) {
        logoDarkInput.value.value = null;
      } else if ((_b2 = logoInput.value) == null ? void 0 : _b2.value) {
        logoInput.value.value = null;
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Head = resolveComponent("Head");
      const _component_Icon = resolveComponent("Icon");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_Head, null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<title${_scopeId}>${ssrInterpolate(_ctx.$t("Application Settings"))}</title>`);
          } else {
            return [
              createVNode("title", null, toDisplayString(_ctx.$t("Application Settings")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$2), { links: tab_links.value }, null, _parent));
      _push(`<div class="pt-6 pb-0 sm:py-8 px-0 sm:px-6 lg:px-8">`);
      _push(ssrRenderComponent(unref(_sfc_main$3), { onSubmitted: save }, {
        title: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Application Settings"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Application Settings")), 1)
            ];
          }
        }),
        description: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("General settings for the application use and views"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("General settings for the application use and views")), 1)
            ];
          }
        }),
        form: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="col-span-6 sm:col-span-3"${_scopeId}><input id="icon" type="file" class="hidden"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$6), {
              for: "icon",
              value: _ctx.$t("Icon")
            }, null, _parent2, _scopeId));
            _push2(`<div style="${ssrRenderStyle(!iconPreview.value && __props.current.icon ? null : { display: "none" })}" class="mt-2 p-1 rounded-md bg-gray-50"${_scopeId}><img${ssrRenderAttr("alt", _ctx.$t("Icon"))}${ssrRenderAttr("src", __props.current.icon)} class="rounded-md max-h-20 w-full max-w-64"${_scopeId}></div><div style="${ssrRenderStyle(iconPreview.value ? null : { display: "none" })}" class="mt-2 p-1 rounded-md bg-gray-50"${_scopeId}><span class="block rounded-md w-full max-w-64 h-20 bg-no-repeat bg-center" style="${ssrRenderStyle("background-image: url('" + iconPreview.value + "');")}"${_scopeId}></span></div>`);
            _push2(ssrRenderComponent(unref(_sfc_main$7), {
              class: "mt-2 me-2",
              type: "button",
              onClick: () => selectNewIcon()
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Select A New Icon"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Select A New Icon")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            if (__props.current.icon) {
              _push2(ssrRenderComponent(unref(_sfc_main$7), {
                type: "button",
                onClick: () => deleteIcon(),
                class: "mt-2 p-1 rounded-md bg-gray-50"
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(_ctx.$t("Remove Icon"))}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(_ctx.$t("Remove Icon")), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              _push2(`<!---->`);
            }
            _push2(ssrRenderComponent(unref(_sfc_main$8), {
              message: unref(form).errors.icon,
              class: "mt-2"
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}><input id="icon_dark" type="file" class="hidden"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$6), {
              for: "icon_dark",
              value: _ctx.$t("Dark Mode Icon")
            }, null, _parent2, _scopeId));
            _push2(`<div style="${ssrRenderStyle(!iconDarkPreview.value && __props.current.icon_dark ? null : { display: "none" })}" class="mt-2 p-1 rounded-md bg-gray-950"${_scopeId}><img${ssrRenderAttr("alt", _ctx.$t("Dark Mode Icon"))}${ssrRenderAttr("src", __props.current.icon_dark)} class="rounded-md max-h-20 w-full max-w-64"${_scopeId}></div><div style="${ssrRenderStyle(iconDarkPreview.value ? null : { display: "none" })}" class="mt-2 p-1 rounded-md bg-gray-950"${_scopeId}><span class="block rounded-md w-full max-w-64 h-20 bg-no-repeat bg-center" style="${ssrRenderStyle("background-image: url('" + iconDarkPreview.value + "');")}"${_scopeId}></span></div>`);
            _push2(ssrRenderComponent(unref(_sfc_main$7), {
              class: "mt-2 me-2",
              type: "button",
              onClick: () => selectNewIcon(true)
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Select A New Icon"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Select A New Icon")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            if (__props.current.icon_dark) {
              _push2(ssrRenderComponent(unref(_sfc_main$7), {
                type: "button",
                class: "mt-2",
                onClick: () => deleteIcon(true)
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(_ctx.$t("Remove Icon"))}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(_ctx.$t("Remove Icon")), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              _push2(`<!---->`);
            }
            _push2(ssrRenderComponent(unref(_sfc_main$8), {
              message: unref(form).errors.icon_dark,
              class: "mt-2"
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}><input id="logo" type="file" class="hidden"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$6), {
              for: "logo",
              value: _ctx.$t("Logo")
            }, null, _parent2, _scopeId));
            _push2(`<div style="${ssrRenderStyle(!logoPreview.value && __props.current.logo ? null : { display: "none" })}" class="mt-2 p-1 rounded-md bg-gray-50"${_scopeId}><img${ssrRenderAttr("alt", _ctx.$t("Logo"))}${ssrRenderAttr("src", __props.current.logo)} class="rounded-md max-h-20 w-full max-w-64"${_scopeId}></div><div style="${ssrRenderStyle(logoPreview.value ? null : { display: "none" })}" class="mt-2 p-1 rounded-md bg-gray-50"${_scopeId}><span class="block rounded-md w-full max-w-64 h-20 bg-no-repeat bg-center" style="${ssrRenderStyle("background-image: url('" + logoPreview.value + "');")}"${_scopeId}></span></div>`);
            _push2(ssrRenderComponent(unref(_sfc_main$7), {
              class: "mt-2 me-2",
              type: "button",
              onClick: () => selectNewLogo()
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Select A New Logo"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Select A New Logo")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            if (__props.current.logo) {
              _push2(ssrRenderComponent(unref(_sfc_main$7), {
                type: "button",
                class: "mt-2",
                onClick: () => deleteLogo()
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(_ctx.$t("Remove Logo"))}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(_ctx.$t("Remove Logo")), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              _push2(`<!---->`);
            }
            _push2(ssrRenderComponent(unref(_sfc_main$8), {
              message: unref(form).errors.logo,
              class: "mt-2"
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}><input id="logo_dark" type="file" class="hidden"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$6), {
              for: "logo_dark",
              value: _ctx.$t("Dark Mode Logo")
            }, null, _parent2, _scopeId));
            _push2(`<div style="${ssrRenderStyle(!logoDarkPreview.value && __props.current.logo_dark ? null : { display: "none" })}" class="mt-2 p-1 rounded-md bg-gray-950"${_scopeId}><img${ssrRenderAttr("alt", _ctx.$t("Dark Mode Logo"))}${ssrRenderAttr("src", __props.current.logo_dark)} class="rounded-md max-h-20 w-full max-w-64"${_scopeId}></div><div style="${ssrRenderStyle(logoDarkPreview.value ? null : { display: "none" })}" class="mt-2 p-1 rounded-md bg-gray-950"${_scopeId}><span class="block rounded-md w-full max-w-64 h-20 bg-no-repeat bg-center" style="${ssrRenderStyle("background-image: url('" + logoDarkPreview.value + "');")}"${_scopeId}></span></div>`);
            _push2(ssrRenderComponent(unref(_sfc_main$7), {
              class: "mt-2 me-2",
              type: "button",
              onClick: () => selectNewLogo(true)
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Select A New Logo"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Select A New Logo")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            if (__props.current.logo_dark) {
              _push2(ssrRenderComponent(unref(_sfc_main$7), {
                type: "button",
                class: "mt-2",
                onClick: () => deleteLogo(true)
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(_ctx.$t("Remove Logo"))}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(_ctx.$t("Remove Logo")), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              _push2(`<!---->`);
            }
            _push2(ssrRenderComponent(unref(_sfc_main$8), {
              message: unref(form).errors.logo_dark,
              class: "mt-2"
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$9), {
              id: "name",
              label: _ctx.$t("Name"),
              modelValue: unref(form).name,
              "onUpdate:modelValue": ($event) => unref(form).name = $event,
              error: unref(form).errors.name
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$9), {
              id: "short_name",
              label: _ctx.$t("Short Name"),
              modelValue: unref(form).short_name,
              "onUpdate:modelValue": ($event) => unref(form).short_name = $event,
              error: unref(form).errors.short_name
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$9), {
              id: "company",
              label: _ctx.$t("Company"),
              modelValue: unref(form).company,
              "onUpdate:modelValue": ($event) => unref(form).company = $event,
              error: unref(form).errors.company
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$9), {
              id: "reg_no",
              label: _ctx.$t("Registration Number"),
              modelValue: unref(form).reg_no,
              "onUpdate:modelValue": ($event) => unref(form).reg_no = $event,
              error: unref(form).errors.reg_no
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$9), {
              id: "phone",
              label: _ctx.$t("Phone"),
              modelValue: unref(form).phone,
              "onUpdate:modelValue": ($event) => unref(form).phone = $event,
              error: unref(form).errors.phone
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$9), {
              id: "email",
              label: _ctx.$t("Email"),
              type: "email",
              modelValue: unref(form).email,
              "onUpdate:modelValue": ($event) => unref(form).email = $event,
              error: unref(form).errors.email
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-full -mt-6"${_scopeId}></div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$a), {
              json: true,
              id: "country_id",
              label: _ctx.$t("Country"),
              modelValue: unref(form).country_id,
              "onUpdate:modelValue": ($event) => unref(form).country_id = $event,
              error: unref(form).errors.country_id,
              suggestions: __props.countries.map((c) => ({ ...c, value: c.id, label: c.name })),
              onChange: (e) => {
                var _a2, _b2;
                country.value = e;
                unref(form).state_id = (_a2 = country.value.states[0]) == null ? void 0 : _a2.id;
                unref(form).timezone_id = (_b2 = __props.timezones.filter((t2) => {
                  var _a3;
                  return ((_a3 = country.value) == null ? void 0 : _a3.id) ? t2.country_id == country.value.id : true;
                })[0]) == null ? void 0 : _b2.id;
              }
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$a), {
              json: true,
              id: "state_id",
              label: _ctx.$t("State"),
              modelValue: unref(form).state_id,
              "onUpdate:modelValue": ($event) => unref(form).state_id = $event,
              error: unref(form).errors.state_id,
              suggestions: country.value.states.length ? country.value.states.map((s) => ({ ...s, value: s.id, label: s.name })) : [{ value: "0", label: _ctx.$t("N/A") }]
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$9), {
              id: "lot_no",
              label: _ctx.$t("Lot No."),
              modelValue: unref(form).lot_no,
              "onUpdate:modelValue": ($event) => unref(form).lot_no = $event,
              error: unref(form).errors.lot_no
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$9), {
              id: "street",
              label: _ctx.$t("Street"),
              modelValue: unref(form).street,
              "onUpdate:modelValue": ($event) => unref(form).street = $event,
              error: unref(form).errors.street
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-full"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$9), {
              id: "address_line_1",
              label: _ctx.$t("Address Line 1"),
              modelValue: unref(form).address_line_1,
              "onUpdate:modelValue": ($event) => unref(form).address_line_1 = $event,
              error: unref(form).errors.address_line_1
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-full"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$9), {
              id: "address_line_2",
              label: _ctx.$t("Address Line 2"),
              modelValue: unref(form).address_line_2,
              "onUpdate:modelValue": ($event) => unref(form).address_line_2 = $event,
              error: unref(form).errors.address_line_2
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$9), {
              id: "city",
              label: _ctx.$t("City"),
              modelValue: unref(form).city,
              "onUpdate:modelValue": ($event) => unref(form).city = $event,
              error: unref(form).errors.city
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$9), {
              id: "postal_code",
              label: _ctx.$t("Postal/ZIP Code"),
              modelValue: unref(form).postal_code,
              "onUpdate:modelValue": ($event) => unref(form).postal_code = $event,
              error: unref(form).errors.postal_code
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-full -mt-6"${_scopeId}></div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$a), {
              json: true,
              id: "timezone_id",
              label: _ctx.$t("Timezone"),
              modelValue: unref(form).timezone_id,
              "onUpdate:modelValue": ($event) => unref(form).timezone_id = $event,
              error: unref(form).errors.timezone_id,
              suggestions: __props.timezones.filter((t2) => {
                var _a2;
                return ((_a2 = country.value) == null ? void 0 : _a2.id) ? t2.country_id == country.value.id : true;
              }).map((c) => ({ ...c, value: c.id, label: c.name }))
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$a), {
              json: true,
              id: "default_account",
              label: _ctx.$t("Default Account"),
              modelValue: unref(form).default_account,
              "onUpdate:modelValue": ($event) => unref(form).default_account = $event,
              error: unref(form).errors.default_account,
              suggestions: __props.accounts
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$a), {
              json: true,
              id: "language",
              searchable: false,
              modelValue: unref(form).language,
              "onUpdate:modelValue": ($event) => unref(form).language = $event,
              label: _ctx.$t("Language"),
              error: _ctx.$page.props.errors.language,
              suggestions: _ctx.$page.props.languages
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$9), {
              id: "date_number_locale",
              modelValue: unref(form).date_number_locale,
              "onUpdate:modelValue": ($event) => unref(form).date_number_locale = $event,
              label: _ctx.$t("Date & Number Locale"),
              error: unref(form).errors.date_number_locale
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$a), {
              json: true,
              id: "date_format",
              searchable: false,
              modelValue: unref(form).date_format,
              "onUpdate:modelValue": ($event) => unref(form).date_format = $event,
              label: _ctx.$t("Date Format"),
              error: unref(form).errors.date_format,
              suggestions: [
                { value: "php", label: _ctx.$t("On Server Side (PHP)") },
                { value: "js", label: _ctx.$t("In Browser (Javascript)") }
              ]
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$a), {
              json: true,
              id: "reference",
              searchable: false,
              modelValue: unref(form).reference,
              "onUpdate:modelValue": ($event) => unref(form).reference = $event,
              label: _ctx.$t("Reference"),
              error: _ctx.$page.props.errors.reference,
              suggestions: [
                { value: "ulid", label: "ULID - Universally Unique Lexicographically Sortable Identifier" },
                { value: "ai", label: "Auto Increment (MYSQL only)" },
                { value: "uniqid", label: "Uniqid - PHP Generate a Unique ID" },
                { value: "uuid", label: "UUID - Universally Unique Identifier" }
              ]
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$a), {
              json: true,
              searchable: false,
              id: "inventory_accounting",
              modelValue: unref(form).inventory_accounting,
              "onUpdate:modelValue": ($event) => unref(form).inventory_accounting = $event,
              label: _ctx.$t("Inventory Accounting Method"),
              error: _ctx.$page.props.errors.inventory_accounting,
              suggestions: [
                { value: "FIFO", label: "FIFO - First In First Out" },
                { value: "LIFO", label: "LIFO - Last In First Out" },
                { value: "AVCO", label: "AVCO - Average Cost" },
                { value: "EXPF", label: "Items Expiring Soon" },
                { value: "Batch", label: "Use Batch Number", disable: true }
              ]
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$9), {
              min: "10",
              max: "100",
              type: "number",
              id: "rows_per_page",
              label: _ctx.$t("Row Per Page"),
              modelValue: unref(form).rows_per_page,
              "onUpdate:modelValue": ($event) => unref(form).rows_per_page = $event,
              error: unref(form).errors.rows_per_page
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$9), {
              min: "0",
              max: "1000",
              type: "number",
              id: "search_delay",
              label: _ctx.$t("Search Delay") + " (ms)",
              modelValue: unref(form).search_delay,
              "onUpdate:modelValue": ($event) => unref(form).search_delay = $event,
              error: unref(form).errors.search_delay
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$9), {
              min: "0",
              max: "4",
              type: "number",
              id: "fraction",
              modelValue: unref(form).fraction,
              "onUpdate:modelValue": ($event) => unref(form).fraction = $event,
              label: _ctx.$t("Fraction"),
              error: unref(form).errors.fraction
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$9), {
              min: "0",
              max: "4",
              type: "number",
              id: "quantity_fraction",
              modelValue: unref(form).quantity_fraction,
              "onUpdate:modelValue": ($event) => unref(form).quantity_fraction = $event,
              label: _ctx.$t("Quantity Fraction"),
              error: unref(form).errors.quantity_fraction
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$9), {
              min: "0",
              max: "100",
              type: "number",
              id: "max_discount",
              modelValue: unref(form).max_discount,
              "onUpdate:modelValue": ($event) => unref(form).max_discount = $event,
              label: _ctx.$t("Maximum Discount") + " (%)",
              error: unref(form).errors.max_discount
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$a), {
              json: true,
              searchable: false,
              id: "dimension_unit",
              modelValue: unref(form).dimension_unit,
              "onUpdate:modelValue": ($event) => unref(form).dimension_unit = $event,
              label: _ctx.$t("Dimension Unit"),
              error: _ctx.$page.props.errors.dimension_unit,
              suggestions: ["Millimeter", "Centimeter", "Inch", "Foot", "Yard", "Meter"]
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$a), {
              id: "weight_unit",
              modelValue: unref(form).weight_unit,
              "onUpdate:modelValue": ($event) => unref(form).weight_unit = $event,
              label: _ctx.$t("Weight Unit"),
              error: _ctx.$page.props.errors.weight_unit,
              suggestions: ["Gram", "Kilogram", "Ounce", "Pound", "Tonne"]
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-full"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$a), {
              json: true,
              "value-key": "id",
              "label-key": "name",
              multiple: true,
              id: "product_taxes",
              suggestions: __props.taxes,
              modelValue: unref(form).product_taxes,
              "onUpdate:modelValue": ($event) => unref(form).product_taxes = $event,
              label: _ctx.$t("Default Product Taxes"),
              error: _ctx.$page.props.errors.product_taxes
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-full"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$6), {
              for: "inclusive_tax_formula",
              value: _ctx.$t("Inclusive Tax Calculation Formula")
            }, null, _parent2, _scopeId));
            _push2(`<fieldset aria-label="Privacy setting" class="mt-1 -space-y-px rounded-md bg-white dark:bg-gray-900"${_scopeId}><label class="group flex cursor-pointer border border-gray-200 dark:border-gray-700 p-4 first:rounded-tl-md first:rounded-tr-md last:rounded-bl-md last:rounded-br-md focus:outline-none has-[:checked]:relative has-[:checked]:border-primary-200 has-[:checked]:bg-primary-50 dark:has-[:checked]:border-primary-800 dark:has-[:checked]:bg-primary-950"${_scopeId}><input type="radio" value="inclusive" name="inclusive_tax_formula"${ssrIncludeBooleanAttr(ssrLooseEqual(unref(form).inclusive_tax_formula, "inclusive")) ? " checked" : ""} class="relative mt-0.5 size-4 shrink-0 appearance-none rounded-full border border-gray-300 bg-white before:absolute before:inset-1 before:rounded-full before:bg-white checked:border-primary-600 checked:bg-primary-600 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-primary-600 disabled:border-gray-300 disabled:bg-gray-100 disabled:before:bg-gray-400 forced-colors:appearance-auto forced-colors:before:hidden [&amp;:not(:checked)]:before:hidden"${_scopeId}><span class="ml-3 flex flex-col"${_scopeId}><span class="block text-sm font-bold text-focused"${_scopeId}>${ssrInterpolate(_ctx.$t("Inclusive"))}</span><span class="block mt-2 font-mono text-xs"${_scopeId}> 100 * 10 / (100 + 10) = 9.09<br${_scopeId}> ${ssrInterpolate(_ctx.$t("Price * Tax Rate / (100 + Tax Rate) = Tax Amount"))}<br${_scopeId}><span class="block mt-2 font-bold"${_scopeId}>${ssrInterpolate(_ctx.$t("So the net price will be 100 - 9.09 = 90.91"))}</span></span></span></label><label class="group flex cursor-pointer border border-gray-200 dark:border-gray-700 p-4 first:rounded-tl-md first:rounded-tr-md last:rounded-bl-md last:rounded-br-md focus:outline-none has-[:checked]:relative has-[:checked]:border-primary-200 has-[:checked]:bg-primary-50 dark:has-[:checked]:border-primary-800 dark:has-[:checked]:bg-primary-950"${_scopeId}><input type="radio" value="exclusive" name="inclusive_tax_formula"${ssrIncludeBooleanAttr(ssrLooseEqual(unref(form).inclusive_tax_formula, "exclusive")) ? " checked" : ""} class="relative mt-0.5 size-4 shrink-0 appearance-none rounded-full border border-gray-300 bg-white before:absolute before:inset-1 before:rounded-full before:bg-white checked:border-primary-600 checked:bg-primary-600 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-primary-600 disabled:border-gray-300 disabled:bg-gray-100 disabled:before:bg-gray-400 forced-colors:appearance-auto forced-colors:before:hidden [&amp;:not(:checked)]:before:hidden"${_scopeId}><span class="ml-3 flex flex-col"${_scopeId}><span class="block text-sm font-bold text-focused"${_scopeId}>${ssrInterpolate(_ctx.$t("Exclusive"))}</span><span class="block mt-2 font-mono text-xs"${_scopeId}> 100 * 10 / 100 = 10<br${_scopeId}> ${ssrInterpolate(_ctx.$t("Price * Tax Rate / 100 = Tax Amount"))}<br${_scopeId}><span class="block mt-2 font-bold"${_scopeId}>${ssrInterpolate(_ctx.$t("So the net price will be 100 - 10 = 90.00"))}</span></span></span></label></fieldset></div><div class="col-span-full flex flex-col gap-2 rounded-md p-4 border border-gray-200 dark:border-gray-700 overflow-x-auto"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$b), {
              id: "stock",
              label: _ctx.$t("Track stock"),
              modelValue: unref(form).stock,
              "onUpdate:modelValue": ($event) => unref(form).stock = $event
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$b), {
              id: "overselling",
              label: _ctx.$t("Allow overselling"),
              modelValue: unref(form).overselling,
              "onUpdate:modelValue": ($event) => unref(form).overselling = $event
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$b), {
              id: "impersonation",
              label: _ctx.$t("Enable impersonation"),
              modelValue: unref(form).impersonation,
              "onUpdate:modelValue": ($event) => unref(form).impersonation = $event
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$b), {
              id: "require_country",
              modelValue: unref(form).require_country,
              "onUpdate:modelValue": ($event) => unref(form).require_country = $event,
              label: _ctx.$t("Require Country & State"),
              text: "(" + _ctx.$t("you must enable if you have state level taxes") + ")"
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-full flex flex-col gap-2 rounded-md p-4 border border-gray-200 dark:border-gray-700 overflow-x-auto"${_scopeId}><h4 class="text-sm font-bold mb-3"${_scopeId}>${ssrInterpolate(_ctx.$t("Sidebar"))}</h4>`);
            _push2(ssrRenderComponent(unref(_sfc_main$b), {
              label: _ctx.$t("Dark top bar"),
              modelValue: unref(form).dark_topbar,
              "onUpdate:modelValue": ($event) => unref(form).dark_topbar = $event
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$b), {
              label: _ctx.$t("Dark side bar"),
              modelValue: unref(form).dark_sidebar,
              "onUpdate:modelValue": ($event) => unref(form).dark_sidebar = $event
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$b), {
              label: _ctx.$t("Show menus as dropdown"),
              modelValue: unref(form).sidebar_dropdown,
              "onUpdate:modelValue": ($event) => unref(form).sidebar_dropdown = $event
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$b), {
              label: _ctx.$t("Scroll to view on menu & page change"),
              modelValue: unref(form).sidebar_scroll_to_view,
              "onUpdate:modelValue": ($event) => unref(form).sidebar_scroll_to_view = $event
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-full flex flex-col gap-2 rounded-md p-4 border border-gray-200 dark:border-gray-700 overflow-x-auto"${_scopeId}><h4 class="text-sm font-bold mb-3"${_scopeId}>${ssrInterpolate(_ctx.$t("Receipt/Sale View"))}</h4>`);
            _push2(ssrRenderComponent(unref(_sfc_main$b), {
              id: "show_image",
              label: _ctx.$t("Show image"),
              modelValue: unref(form).show_image,
              "onUpdate:modelValue": ($event) => unref(form).show_image = $event
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$b), {
              id: "show_taxes",
              label: _ctx.$t("Show tax column"),
              modelValue: unref(form).show_tax,
              "onUpdate:modelValue": ($event) => unref(form).show_tax = $event
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$b), {
              id: "show_tax_summary",
              label: _ctx.$t("Show tax summary"),
              modelValue: unref(form).show_tax_summary,
              "onUpdate:modelValue": ($event) => unref(form).show_tax_summary = $event
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$b), {
              id: "show_discount",
              label: _ctx.$t("Show discount column"),
              modelValue: unref(form).show_discount,
              "onUpdate:modelValue": ($event) => unref(form).show_discount = $event
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$b), {
              id: "show_zero_taxes",
              label: _ctx.$t("Show taxes with zero value"),
              modelValue: unref(form).show_zero_taxes,
              "onUpdate:modelValue": ($event) => unref(form).show_zero_taxes = $event
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-full rounded-md p-4 border border-gray-200 dark:border-gray-700 overflow-x-auto"${_scopeId}><h4 class="font-bold"${_scopeId}>${ssrInterpolate(_ctx.$t("Loyalty Points"))}</h4><div class="mt-4 text-sm"${_scopeId}><h5 class="font-bold"${_scopeId}>${ssrInterpolate(_ctx.$t("For Customers"))}</h5><div class="flex items-center gap-2"${_scopeId}>${ssrInterpolate(_ctx.$t("Each sale amounting to"))} `);
            _push2(ssrRenderComponent(unref(_sfc_main$c), {
              class: "w-28",
              id: "loyalty_customer_spent",
              type: "number",
              modelValue: unref(form).loyalty.customer.spent,
              "onUpdate:modelValue": ($event) => unref(form).loyalty.customer.spent = $event
            }, null, _parent2, _scopeId));
            _push2(` ${ssrInterpolate(_ctx.$t("will earn"))} `);
            _push2(ssrRenderComponent(unref(_sfc_main$c), {
              class: "w-28",
              id: "loyalty_customer_points",
              type: "number",
              modelValue: unref(form).loyalty.customer.points,
              "onUpdate:modelValue": ($event) => unref(form).loyalty.customer.points = $event
            }, null, _parent2, _scopeId));
            _push2(` ${ssrInterpolate(_ctx.$t("points"))}. </div></div><div class="mt-4 text-sm"${_scopeId}><h5 class="font-bold"${_scopeId}>${ssrInterpolate(_ctx.$t("For Staff"))}</h5><div class="flex items-center gap-2"${_scopeId}>${ssrInterpolate(_ctx.$t("Each sale amounting to"))} `);
            _push2(ssrRenderComponent(unref(_sfc_main$c), {
              class: "w-28",
              id: "loyalty_staff_spent",
              type: "number",
              modelValue: unref(form).loyalty.staff.spent,
              "onUpdate:modelValue": ($event) => unref(form).loyalty.staff.spent = $event
            }, null, _parent2, _scopeId));
            _push2(` ${ssrInterpolate(_ctx.$t("will earn"))} `);
            _push2(ssrRenderComponent(unref(_sfc_main$c), {
              class: "w-28",
              id: "loyalty_staff_points",
              type: "number",
              modelValue: unref(form).loyalty.staff.points,
              "onUpdate:modelValue": ($event) => unref(form).loyalty.staff.points = $event
            }, null, _parent2, _scopeId));
            _push2(` ${ssrInterpolate(_ctx.$t("points"))}. </div></div></div><div class="col-span-full"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$d), {
              id: "receipt_header",
              label: _ctx.$t("Receipt Header"),
              modelValue: unref(form).receipt_header,
              "onUpdate:modelValue": ($event) => unref(form).receipt_header = $event,
              error: unref(form).errors.receipt_header
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-full"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$d), {
              id: "receipt_footer",
              label: _ctx.$t("Receipt Footer"),
              modelValue: unref(form).receipt_footer,
              "onUpdate:modelValue": ($event) => unref(form).receipt_footer = $event,
              error: unref(form).errors.receipt_footer
            }, null, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode("input", {
                  id: "icon",
                  ref_key: "iconInput",
                  ref: iconInput,
                  type: "file",
                  class: "hidden",
                  onChange: () => updateIconPreview()
                }, null, 40, ["onChange"]),
                createVNode(unref(_sfc_main$6), {
                  for: "icon",
                  value: _ctx.$t("Icon")
                }, null, 8, ["value"]),
                withDirectives(createVNode("div", { class: "mt-2 p-1 rounded-md bg-gray-50" }, [
                  createVNode("img", {
                    alt: _ctx.$t("Icon"),
                    src: __props.current.icon,
                    class: "rounded-md max-h-20 w-full max-w-64"
                  }, null, 8, ["alt", "src"])
                ], 512), [
                  [vShow, !iconPreview.value && __props.current.icon]
                ]),
                withDirectives(createVNode("div", { class: "mt-2 p-1 rounded-md bg-gray-50" }, [
                  createVNode("span", {
                    class: "block rounded-md w-full max-w-64 h-20 bg-no-repeat bg-center",
                    style: "background-image: url('" + iconPreview.value + "');"
                  }, null, 4)
                ], 512), [
                  [vShow, iconPreview.value]
                ]),
                createVNode(unref(_sfc_main$7), {
                  class: "mt-2 me-2",
                  type: "button",
                  onClick: withModifiers(() => selectNewIcon(), ["prevent"])
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.$t("Select A New Icon")), 1)
                  ]),
                  _: 1
                }, 8, ["onClick"]),
                __props.current.icon ? (openBlock(), createBlock(unref(_sfc_main$7), {
                  key: 0,
                  type: "button",
                  onClick: withModifiers(() => deleteIcon(), ["prevent"]),
                  class: "mt-2 p-1 rounded-md bg-gray-50"
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.$t("Remove Icon")), 1)
                  ]),
                  _: 1
                }, 8, ["onClick"])) : createCommentVNode("", true),
                createVNode(unref(_sfc_main$8), {
                  message: unref(form).errors.icon,
                  class: "mt-2"
                }, null, 8, ["message"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode("input", {
                  id: "icon_dark",
                  ref_key: "iconDarkInput",
                  ref: iconDarkInput,
                  type: "file",
                  class: "hidden",
                  onChange: () => updateIconPreview(true)
                }, null, 40, ["onChange"]),
                createVNode(unref(_sfc_main$6), {
                  for: "icon_dark",
                  value: _ctx.$t("Dark Mode Icon")
                }, null, 8, ["value"]),
                withDirectives(createVNode("div", { class: "mt-2 p-1 rounded-md bg-gray-950" }, [
                  createVNode("img", {
                    alt: _ctx.$t("Dark Mode Icon"),
                    src: __props.current.icon_dark,
                    class: "rounded-md max-h-20 w-full max-w-64"
                  }, null, 8, ["alt", "src"])
                ], 512), [
                  [vShow, !iconDarkPreview.value && __props.current.icon_dark]
                ]),
                withDirectives(createVNode("div", { class: "mt-2 p-1 rounded-md bg-gray-950" }, [
                  createVNode("span", {
                    class: "block rounded-md w-full max-w-64 h-20 bg-no-repeat bg-center",
                    style: "background-image: url('" + iconDarkPreview.value + "');"
                  }, null, 4)
                ], 512), [
                  [vShow, iconDarkPreview.value]
                ]),
                createVNode(unref(_sfc_main$7), {
                  class: "mt-2 me-2",
                  type: "button",
                  onClick: withModifiers(() => selectNewIcon(true), ["prevent"])
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.$t("Select A New Icon")), 1)
                  ]),
                  _: 1
                }, 8, ["onClick"]),
                __props.current.icon_dark ? (openBlock(), createBlock(unref(_sfc_main$7), {
                  key: 0,
                  type: "button",
                  class: "mt-2",
                  onClick: withModifiers(() => deleteIcon(true), ["prevent"])
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.$t("Remove Icon")), 1)
                  ]),
                  _: 1
                }, 8, ["onClick"])) : createCommentVNode("", true),
                createVNode(unref(_sfc_main$8), {
                  message: unref(form).errors.icon_dark,
                  class: "mt-2"
                }, null, 8, ["message"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode("input", {
                  id: "logo",
                  ref_key: "logoInput",
                  ref: logoInput,
                  type: "file",
                  class: "hidden",
                  onChange: () => updateLogoPreview()
                }, null, 40, ["onChange"]),
                createVNode(unref(_sfc_main$6), {
                  for: "logo",
                  value: _ctx.$t("Logo")
                }, null, 8, ["value"]),
                withDirectives(createVNode("div", { class: "mt-2 p-1 rounded-md bg-gray-50" }, [
                  createVNode("img", {
                    alt: _ctx.$t("Logo"),
                    src: __props.current.logo,
                    class: "rounded-md max-h-20 w-full max-w-64"
                  }, null, 8, ["alt", "src"])
                ], 512), [
                  [vShow, !logoPreview.value && __props.current.logo]
                ]),
                withDirectives(createVNode("div", { class: "mt-2 p-1 rounded-md bg-gray-50" }, [
                  createVNode("span", {
                    class: "block rounded-md w-full max-w-64 h-20 bg-no-repeat bg-center",
                    style: "background-image: url('" + logoPreview.value + "');"
                  }, null, 4)
                ], 512), [
                  [vShow, logoPreview.value]
                ]),
                createVNode(unref(_sfc_main$7), {
                  class: "mt-2 me-2",
                  type: "button",
                  onClick: withModifiers(() => selectNewLogo(), ["prevent"])
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.$t("Select A New Logo")), 1)
                  ]),
                  _: 1
                }, 8, ["onClick"]),
                __props.current.logo ? (openBlock(), createBlock(unref(_sfc_main$7), {
                  key: 0,
                  type: "button",
                  class: "mt-2",
                  onClick: withModifiers(() => deleteLogo(), ["prevent"])
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.$t("Remove Logo")), 1)
                  ]),
                  _: 1
                }, 8, ["onClick"])) : createCommentVNode("", true),
                createVNode(unref(_sfc_main$8), {
                  message: unref(form).errors.logo,
                  class: "mt-2"
                }, null, 8, ["message"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode("input", {
                  id: "logo_dark",
                  ref_key: "logoDarkInput",
                  ref: logoDarkInput,
                  type: "file",
                  class: "hidden",
                  onChange: () => updateLogoPreview(true)
                }, null, 40, ["onChange"]),
                createVNode(unref(_sfc_main$6), {
                  for: "logo_dark",
                  value: _ctx.$t("Dark Mode Logo")
                }, null, 8, ["value"]),
                withDirectives(createVNode("div", { class: "mt-2 p-1 rounded-md bg-gray-950" }, [
                  createVNode("img", {
                    alt: _ctx.$t("Dark Mode Logo"),
                    src: __props.current.logo_dark,
                    class: "rounded-md max-h-20 w-full max-w-64"
                  }, null, 8, ["alt", "src"])
                ], 512), [
                  [vShow, !logoDarkPreview.value && __props.current.logo_dark]
                ]),
                withDirectives(createVNode("div", { class: "mt-2 p-1 rounded-md bg-gray-950" }, [
                  createVNode("span", {
                    class: "block rounded-md w-full max-w-64 h-20 bg-no-repeat bg-center",
                    style: "background-image: url('" + logoDarkPreview.value + "');"
                  }, null, 4)
                ], 512), [
                  [vShow, logoDarkPreview.value]
                ]),
                createVNode(unref(_sfc_main$7), {
                  class: "mt-2 me-2",
                  type: "button",
                  onClick: withModifiers(() => selectNewLogo(true), ["prevent"])
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.$t("Select A New Logo")), 1)
                  ]),
                  _: 1
                }, 8, ["onClick"]),
                __props.current.logo_dark ? (openBlock(), createBlock(unref(_sfc_main$7), {
                  key: 0,
                  type: "button",
                  class: "mt-2",
                  onClick: withModifiers(() => deleteLogo(true), ["prevent"])
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.$t("Remove Logo")), 1)
                  ]),
                  _: 1
                }, 8, ["onClick"])) : createCommentVNode("", true),
                createVNode(unref(_sfc_main$8), {
                  message: unref(form).errors.logo_dark,
                  class: "mt-2"
                }, null, 8, ["message"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$9), {
                  id: "name",
                  label: _ctx.$t("Name"),
                  modelValue: unref(form).name,
                  "onUpdate:modelValue": ($event) => unref(form).name = $event,
                  error: unref(form).errors.name
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$9), {
                  id: "short_name",
                  label: _ctx.$t("Short Name"),
                  modelValue: unref(form).short_name,
                  "onUpdate:modelValue": ($event) => unref(form).short_name = $event,
                  error: unref(form).errors.short_name
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$9), {
                  id: "company",
                  label: _ctx.$t("Company"),
                  modelValue: unref(form).company,
                  "onUpdate:modelValue": ($event) => unref(form).company = $event,
                  error: unref(form).errors.company
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$9), {
                  id: "reg_no",
                  label: _ctx.$t("Registration Number"),
                  modelValue: unref(form).reg_no,
                  "onUpdate:modelValue": ($event) => unref(form).reg_no = $event,
                  error: unref(form).errors.reg_no
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$9), {
                  id: "phone",
                  label: _ctx.$t("Phone"),
                  modelValue: unref(form).phone,
                  "onUpdate:modelValue": ($event) => unref(form).phone = $event,
                  error: unref(form).errors.phone
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$9), {
                  id: "email",
                  label: _ctx.$t("Email"),
                  type: "email",
                  modelValue: unref(form).email,
                  "onUpdate:modelValue": ($event) => unref(form).email = $event,
                  error: unref(form).errors.email
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              createVNode("div", { class: "col-span-full -mt-6" }),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$a), {
                  json: true,
                  id: "country_id",
                  label: _ctx.$t("Country"),
                  modelValue: unref(form).country_id,
                  "onUpdate:modelValue": ($event) => unref(form).country_id = $event,
                  error: unref(form).errors.country_id,
                  suggestions: __props.countries.map((c) => ({ ...c, value: c.id, label: c.name })),
                  onChange: (e) => {
                    var _a2, _b2;
                    country.value = e;
                    unref(form).state_id = (_a2 = country.value.states[0]) == null ? void 0 : _a2.id;
                    unref(form).timezone_id = (_b2 = __props.timezones.filter((t2) => {
                      var _a3;
                      return ((_a3 = country.value) == null ? void 0 : _a3.id) ? t2.country_id == country.value.id : true;
                    })[0]) == null ? void 0 : _b2.id;
                  }
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error", "suggestions", "onChange"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$a), {
                  json: true,
                  id: "state_id",
                  label: _ctx.$t("State"),
                  modelValue: unref(form).state_id,
                  "onUpdate:modelValue": ($event) => unref(form).state_id = $event,
                  error: unref(form).errors.state_id,
                  suggestions: country.value.states.length ? country.value.states.map((s) => ({ ...s, value: s.id, label: s.name })) : [{ value: "0", label: _ctx.$t("N/A") }]
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error", "suggestions"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$9), {
                  id: "lot_no",
                  label: _ctx.$t("Lot No."),
                  modelValue: unref(form).lot_no,
                  "onUpdate:modelValue": ($event) => unref(form).lot_no = $event,
                  error: unref(form).errors.lot_no
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$9), {
                  id: "street",
                  label: _ctx.$t("Street"),
                  modelValue: unref(form).street,
                  "onUpdate:modelValue": ($event) => unref(form).street = $event,
                  error: unref(form).errors.street
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              createVNode("div", { class: "col-span-full" }, [
                createVNode(unref(_sfc_main$9), {
                  id: "address_line_1",
                  label: _ctx.$t("Address Line 1"),
                  modelValue: unref(form).address_line_1,
                  "onUpdate:modelValue": ($event) => unref(form).address_line_1 = $event,
                  error: unref(form).errors.address_line_1
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              createVNode("div", { class: "col-span-full" }, [
                createVNode(unref(_sfc_main$9), {
                  id: "address_line_2",
                  label: _ctx.$t("Address Line 2"),
                  modelValue: unref(form).address_line_2,
                  "onUpdate:modelValue": ($event) => unref(form).address_line_2 = $event,
                  error: unref(form).errors.address_line_2
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$9), {
                  id: "city",
                  label: _ctx.$t("City"),
                  modelValue: unref(form).city,
                  "onUpdate:modelValue": ($event) => unref(form).city = $event,
                  error: unref(form).errors.city
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$9), {
                  id: "postal_code",
                  label: _ctx.$t("Postal/ZIP Code"),
                  modelValue: unref(form).postal_code,
                  "onUpdate:modelValue": ($event) => unref(form).postal_code = $event,
                  error: unref(form).errors.postal_code
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              createVNode("div", { class: "col-span-full -mt-6" }),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$a), {
                  json: true,
                  id: "timezone_id",
                  label: _ctx.$t("Timezone"),
                  modelValue: unref(form).timezone_id,
                  "onUpdate:modelValue": ($event) => unref(form).timezone_id = $event,
                  error: unref(form).errors.timezone_id,
                  suggestions: __props.timezones.filter((t2) => {
                    var _a2;
                    return ((_a2 = country.value) == null ? void 0 : _a2.id) ? t2.country_id == country.value.id : true;
                  }).map((c) => ({ ...c, value: c.id, label: c.name }))
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error", "suggestions"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$a), {
                  json: true,
                  id: "default_account",
                  label: _ctx.$t("Default Account"),
                  modelValue: unref(form).default_account,
                  "onUpdate:modelValue": ($event) => unref(form).default_account = $event,
                  error: unref(form).errors.default_account,
                  suggestions: __props.accounts
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error", "suggestions"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$a), {
                  json: true,
                  id: "language",
                  searchable: false,
                  modelValue: unref(form).language,
                  "onUpdate:modelValue": ($event) => unref(form).language = $event,
                  label: _ctx.$t("Language"),
                  error: _ctx.$page.props.errors.language,
                  suggestions: _ctx.$page.props.languages
                }, null, 8, ["modelValue", "onUpdate:modelValue", "label", "error", "suggestions"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$9), {
                  id: "date_number_locale",
                  modelValue: unref(form).date_number_locale,
                  "onUpdate:modelValue": ($event) => unref(form).date_number_locale = $event,
                  label: _ctx.$t("Date & Number Locale"),
                  error: unref(form).errors.date_number_locale
                }, null, 8, ["modelValue", "onUpdate:modelValue", "label", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$a), {
                  json: true,
                  id: "date_format",
                  searchable: false,
                  modelValue: unref(form).date_format,
                  "onUpdate:modelValue": ($event) => unref(form).date_format = $event,
                  label: _ctx.$t("Date Format"),
                  error: unref(form).errors.date_format,
                  suggestions: [
                    { value: "php", label: _ctx.$t("On Server Side (PHP)") },
                    { value: "js", label: _ctx.$t("In Browser (Javascript)") }
                  ]
                }, null, 8, ["modelValue", "onUpdate:modelValue", "label", "error", "suggestions"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$a), {
                  json: true,
                  id: "reference",
                  searchable: false,
                  modelValue: unref(form).reference,
                  "onUpdate:modelValue": ($event) => unref(form).reference = $event,
                  label: _ctx.$t("Reference"),
                  error: _ctx.$page.props.errors.reference,
                  suggestions: [
                    { value: "ulid", label: "ULID - Universally Unique Lexicographically Sortable Identifier" },
                    { value: "ai", label: "Auto Increment (MYSQL only)" },
                    { value: "uniqid", label: "Uniqid - PHP Generate a Unique ID" },
                    { value: "uuid", label: "UUID - Universally Unique Identifier" }
                  ]
                }, null, 8, ["modelValue", "onUpdate:modelValue", "label", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$a), {
                  json: true,
                  searchable: false,
                  id: "inventory_accounting",
                  modelValue: unref(form).inventory_accounting,
                  "onUpdate:modelValue": ($event) => unref(form).inventory_accounting = $event,
                  label: _ctx.$t("Inventory Accounting Method"),
                  error: _ctx.$page.props.errors.inventory_accounting,
                  suggestions: [
                    { value: "FIFO", label: "FIFO - First In First Out" },
                    { value: "LIFO", label: "LIFO - Last In First Out" },
                    { value: "AVCO", label: "AVCO - Average Cost" },
                    { value: "EXPF", label: "Items Expiring Soon" },
                    { value: "Batch", label: "Use Batch Number", disable: true }
                  ]
                }, null, 8, ["modelValue", "onUpdate:modelValue", "label", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$9), {
                  min: "10",
                  max: "100",
                  type: "number",
                  id: "rows_per_page",
                  label: _ctx.$t("Row Per Page"),
                  modelValue: unref(form).rows_per_page,
                  "onUpdate:modelValue": ($event) => unref(form).rows_per_page = $event,
                  error: unref(form).errors.rows_per_page
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$9), {
                  min: "0",
                  max: "1000",
                  type: "number",
                  id: "search_delay",
                  label: _ctx.$t("Search Delay") + " (ms)",
                  modelValue: unref(form).search_delay,
                  "onUpdate:modelValue": ($event) => unref(form).search_delay = $event,
                  error: unref(form).errors.search_delay
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$9), {
                  min: "0",
                  max: "4",
                  type: "number",
                  id: "fraction",
                  modelValue: unref(form).fraction,
                  "onUpdate:modelValue": ($event) => unref(form).fraction = $event,
                  label: _ctx.$t("Fraction"),
                  error: unref(form).errors.fraction
                }, null, 8, ["modelValue", "onUpdate:modelValue", "label", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$9), {
                  min: "0",
                  max: "4",
                  type: "number",
                  id: "quantity_fraction",
                  modelValue: unref(form).quantity_fraction,
                  "onUpdate:modelValue": ($event) => unref(form).quantity_fraction = $event,
                  label: _ctx.$t("Quantity Fraction"),
                  error: unref(form).errors.quantity_fraction
                }, null, 8, ["modelValue", "onUpdate:modelValue", "label", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$9), {
                  min: "0",
                  max: "100",
                  type: "number",
                  id: "max_discount",
                  modelValue: unref(form).max_discount,
                  "onUpdate:modelValue": ($event) => unref(form).max_discount = $event,
                  label: _ctx.$t("Maximum Discount") + " (%)",
                  error: unref(form).errors.max_discount
                }, null, 8, ["modelValue", "onUpdate:modelValue", "label", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$a), {
                  json: true,
                  searchable: false,
                  id: "dimension_unit",
                  modelValue: unref(form).dimension_unit,
                  "onUpdate:modelValue": ($event) => unref(form).dimension_unit = $event,
                  label: _ctx.$t("Dimension Unit"),
                  error: _ctx.$page.props.errors.dimension_unit,
                  suggestions: ["Millimeter", "Centimeter", "Inch", "Foot", "Yard", "Meter"]
                }, null, 8, ["modelValue", "onUpdate:modelValue", "label", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$a), {
                  id: "weight_unit",
                  modelValue: unref(form).weight_unit,
                  "onUpdate:modelValue": ($event) => unref(form).weight_unit = $event,
                  label: _ctx.$t("Weight Unit"),
                  error: _ctx.$page.props.errors.weight_unit,
                  suggestions: ["Gram", "Kilogram", "Ounce", "Pound", "Tonne"]
                }, null, 8, ["modelValue", "onUpdate:modelValue", "label", "error"])
              ]),
              createVNode("div", { class: "col-span-full" }, [
                createVNode(unref(_sfc_main$a), {
                  json: true,
                  "value-key": "id",
                  "label-key": "name",
                  multiple: true,
                  id: "product_taxes",
                  suggestions: __props.taxes,
                  modelValue: unref(form).product_taxes,
                  "onUpdate:modelValue": ($event) => unref(form).product_taxes = $event,
                  label: _ctx.$t("Default Product Taxes"),
                  error: _ctx.$page.props.errors.product_taxes
                }, null, 8, ["suggestions", "modelValue", "onUpdate:modelValue", "label", "error"])
              ]),
              createVNode("div", { class: "col-span-full" }, [
                createVNode(unref(_sfc_main$6), {
                  for: "inclusive_tax_formula",
                  value: _ctx.$t("Inclusive Tax Calculation Formula")
                }, null, 8, ["value"]),
                createVNode("fieldset", {
                  "aria-label": "Privacy setting",
                  class: "mt-1 -space-y-px rounded-md bg-white dark:bg-gray-900"
                }, [
                  createVNode("label", { class: "group flex cursor-pointer border border-gray-200 dark:border-gray-700 p-4 first:rounded-tl-md first:rounded-tr-md last:rounded-bl-md last:rounded-br-md focus:outline-none has-[:checked]:relative has-[:checked]:border-primary-200 has-[:checked]:bg-primary-50 dark:has-[:checked]:border-primary-800 dark:has-[:checked]:bg-primary-950" }, [
                    withDirectives(createVNode("input", {
                      type: "radio",
                      value: "inclusive",
                      name: "inclusive_tax_formula",
                      "onUpdate:modelValue": ($event) => unref(form).inclusive_tax_formula = $event,
                      class: "relative mt-0.5 size-4 shrink-0 appearance-none rounded-full border border-gray-300 bg-white before:absolute before:inset-1 before:rounded-full before:bg-white checked:border-primary-600 checked:bg-primary-600 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-primary-600 disabled:border-gray-300 disabled:bg-gray-100 disabled:before:bg-gray-400 forced-colors:appearance-auto forced-colors:before:hidden [&:not(:checked)]:before:hidden"
                    }, null, 8, ["onUpdate:modelValue"]), [
                      [vModelRadio, unref(form).inclusive_tax_formula]
                    ]),
                    createVNode("span", { class: "ml-3 flex flex-col" }, [
                      createVNode("span", { class: "block text-sm font-bold text-focused" }, toDisplayString(_ctx.$t("Inclusive")), 1),
                      createVNode("span", { class: "block mt-2 font-mono text-xs" }, [
                        createTextVNode(" 100 * 10 / (100 + 10) = 9.09"),
                        createVNode("br"),
                        createTextVNode(" " + toDisplayString(_ctx.$t("Price * Tax Rate / (100 + Tax Rate) = Tax Amount")), 1),
                        createVNode("br"),
                        createVNode("span", { class: "block mt-2 font-bold" }, toDisplayString(_ctx.$t("So the net price will be 100 - 9.09 = 90.91")), 1)
                      ])
                    ])
                  ]),
                  createVNode("label", { class: "group flex cursor-pointer border border-gray-200 dark:border-gray-700 p-4 first:rounded-tl-md first:rounded-tr-md last:rounded-bl-md last:rounded-br-md focus:outline-none has-[:checked]:relative has-[:checked]:border-primary-200 has-[:checked]:bg-primary-50 dark:has-[:checked]:border-primary-800 dark:has-[:checked]:bg-primary-950" }, [
                    withDirectives(createVNode("input", {
                      type: "radio",
                      value: "exclusive",
                      name: "inclusive_tax_formula",
                      "onUpdate:modelValue": ($event) => unref(form).inclusive_tax_formula = $event,
                      class: "relative mt-0.5 size-4 shrink-0 appearance-none rounded-full border border-gray-300 bg-white before:absolute before:inset-1 before:rounded-full before:bg-white checked:border-primary-600 checked:bg-primary-600 focus-visible:outline focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-primary-600 disabled:border-gray-300 disabled:bg-gray-100 disabled:before:bg-gray-400 forced-colors:appearance-auto forced-colors:before:hidden [&:not(:checked)]:before:hidden"
                    }, null, 8, ["onUpdate:modelValue"]), [
                      [vModelRadio, unref(form).inclusive_tax_formula]
                    ]),
                    createVNode("span", { class: "ml-3 flex flex-col" }, [
                      createVNode("span", { class: "block text-sm font-bold text-focused" }, toDisplayString(_ctx.$t("Exclusive")), 1),
                      createVNode("span", { class: "block mt-2 font-mono text-xs" }, [
                        createTextVNode(" 100 * 10 / 100 = 10"),
                        createVNode("br"),
                        createTextVNode(" " + toDisplayString(_ctx.$t("Price * Tax Rate / 100 = Tax Amount")), 1),
                        createVNode("br"),
                        createVNode("span", { class: "block mt-2 font-bold" }, toDisplayString(_ctx.$t("So the net price will be 100 - 10 = 90.00")), 1)
                      ])
                    ])
                  ])
                ])
              ]),
              createVNode("div", { class: "col-span-full flex flex-col gap-2 rounded-md p-4 border border-gray-200 dark:border-gray-700 overflow-x-auto" }, [
                createVNode(unref(_sfc_main$b), {
                  id: "stock",
                  label: _ctx.$t("Track stock"),
                  modelValue: unref(form).stock,
                  "onUpdate:modelValue": ($event) => unref(form).stock = $event
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue"]),
                createVNode(unref(_sfc_main$b), {
                  id: "overselling",
                  label: _ctx.$t("Allow overselling"),
                  modelValue: unref(form).overselling,
                  "onUpdate:modelValue": ($event) => unref(form).overselling = $event
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue"]),
                createVNode(unref(_sfc_main$b), {
                  id: "impersonation",
                  label: _ctx.$t("Enable impersonation"),
                  modelValue: unref(form).impersonation,
                  "onUpdate:modelValue": ($event) => unref(form).impersonation = $event
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue"]),
                createVNode(unref(_sfc_main$b), {
                  id: "require_country",
                  modelValue: unref(form).require_country,
                  "onUpdate:modelValue": ($event) => unref(form).require_country = $event,
                  label: _ctx.$t("Require Country & State"),
                  text: "(" + _ctx.$t("you must enable if you have state level taxes") + ")"
                }, null, 8, ["modelValue", "onUpdate:modelValue", "label", "text"])
              ]),
              createVNode("div", { class: "col-span-full flex flex-col gap-2 rounded-md p-4 border border-gray-200 dark:border-gray-700 overflow-x-auto" }, [
                createVNode("h4", { class: "text-sm font-bold mb-3" }, toDisplayString(_ctx.$t("Sidebar")), 1),
                createVNode(unref(_sfc_main$b), {
                  label: _ctx.$t("Dark top bar"),
                  modelValue: unref(form).dark_topbar,
                  "onUpdate:modelValue": ($event) => unref(form).dark_topbar = $event
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue"]),
                createVNode(unref(_sfc_main$b), {
                  label: _ctx.$t("Dark side bar"),
                  modelValue: unref(form).dark_sidebar,
                  "onUpdate:modelValue": ($event) => unref(form).dark_sidebar = $event
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue"]),
                createVNode(unref(_sfc_main$b), {
                  label: _ctx.$t("Show menus as dropdown"),
                  modelValue: unref(form).sidebar_dropdown,
                  "onUpdate:modelValue": ($event) => unref(form).sidebar_dropdown = $event
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue"]),
                createVNode(unref(_sfc_main$b), {
                  label: _ctx.$t("Scroll to view on menu & page change"),
                  modelValue: unref(form).sidebar_scroll_to_view,
                  "onUpdate:modelValue": ($event) => unref(form).sidebar_scroll_to_view = $event
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue"])
              ]),
              createVNode("div", { class: "col-span-full flex flex-col gap-2 rounded-md p-4 border border-gray-200 dark:border-gray-700 overflow-x-auto" }, [
                createVNode("h4", { class: "text-sm font-bold mb-3" }, toDisplayString(_ctx.$t("Receipt/Sale View")), 1),
                createVNode(unref(_sfc_main$b), {
                  id: "show_image",
                  label: _ctx.$t("Show image"),
                  modelValue: unref(form).show_image,
                  "onUpdate:modelValue": ($event) => unref(form).show_image = $event
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue"]),
                createVNode(unref(_sfc_main$b), {
                  id: "show_taxes",
                  label: _ctx.$t("Show tax column"),
                  modelValue: unref(form).show_tax,
                  "onUpdate:modelValue": ($event) => unref(form).show_tax = $event
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue"]),
                createVNode(unref(_sfc_main$b), {
                  id: "show_tax_summary",
                  label: _ctx.$t("Show tax summary"),
                  modelValue: unref(form).show_tax_summary,
                  "onUpdate:modelValue": ($event) => unref(form).show_tax_summary = $event
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue"]),
                createVNode(unref(_sfc_main$b), {
                  id: "show_discount",
                  label: _ctx.$t("Show discount column"),
                  modelValue: unref(form).show_discount,
                  "onUpdate:modelValue": ($event) => unref(form).show_discount = $event
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue"]),
                createVNode(unref(_sfc_main$b), {
                  id: "show_zero_taxes",
                  label: _ctx.$t("Show taxes with zero value"),
                  modelValue: unref(form).show_zero_taxes,
                  "onUpdate:modelValue": ($event) => unref(form).show_zero_taxes = $event
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue"])
              ]),
              createVNode("div", { class: "col-span-full rounded-md p-4 border border-gray-200 dark:border-gray-700 overflow-x-auto" }, [
                createVNode("h4", { class: "font-bold" }, toDisplayString(_ctx.$t("Loyalty Points")), 1),
                createVNode("div", { class: "mt-4 text-sm" }, [
                  createVNode("h5", { class: "font-bold" }, toDisplayString(_ctx.$t("For Customers")), 1),
                  createVNode("div", { class: "flex items-center gap-2" }, [
                    createTextVNode(toDisplayString(_ctx.$t("Each sale amounting to")) + " ", 1),
                    createVNode(unref(_sfc_main$c), {
                      class: "w-28",
                      id: "loyalty_customer_spent",
                      type: "number",
                      modelValue: unref(form).loyalty.customer.spent,
                      "onUpdate:modelValue": ($event) => unref(form).loyalty.customer.spent = $event
                    }, null, 8, ["modelValue", "onUpdate:modelValue"]),
                    createTextVNode(" " + toDisplayString(_ctx.$t("will earn")) + " ", 1),
                    createVNode(unref(_sfc_main$c), {
                      class: "w-28",
                      id: "loyalty_customer_points",
                      type: "number",
                      modelValue: unref(form).loyalty.customer.points,
                      "onUpdate:modelValue": ($event) => unref(form).loyalty.customer.points = $event
                    }, null, 8, ["modelValue", "onUpdate:modelValue"]),
                    createTextVNode(" " + toDisplayString(_ctx.$t("points")) + ". ", 1)
                  ])
                ]),
                createVNode("div", { class: "mt-4 text-sm" }, [
                  createVNode("h5", { class: "font-bold" }, toDisplayString(_ctx.$t("For Staff")), 1),
                  createVNode("div", { class: "flex items-center gap-2" }, [
                    createTextVNode(toDisplayString(_ctx.$t("Each sale amounting to")) + " ", 1),
                    createVNode(unref(_sfc_main$c), {
                      class: "w-28",
                      id: "loyalty_staff_spent",
                      type: "number",
                      modelValue: unref(form).loyalty.staff.spent,
                      "onUpdate:modelValue": ($event) => unref(form).loyalty.staff.spent = $event
                    }, null, 8, ["modelValue", "onUpdate:modelValue"]),
                    createTextVNode(" " + toDisplayString(_ctx.$t("will earn")) + " ", 1),
                    createVNode(unref(_sfc_main$c), {
                      class: "w-28",
                      id: "loyalty_staff_points",
                      type: "number",
                      modelValue: unref(form).loyalty.staff.points,
                      "onUpdate:modelValue": ($event) => unref(form).loyalty.staff.points = $event
                    }, null, 8, ["modelValue", "onUpdate:modelValue"]),
                    createTextVNode(" " + toDisplayString(_ctx.$t("points")) + ". ", 1)
                  ])
                ])
              ]),
              createVNode("div", { class: "col-span-full" }, [
                createVNode(unref(_sfc_main$d), {
                  id: "receipt_header",
                  label: _ctx.$t("Receipt Header"),
                  modelValue: unref(form).receipt_header,
                  "onUpdate:modelValue": ($event) => unref(form).receipt_header = $event,
                  error: unref(form).errors.receipt_header
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              createVNode("div", { class: "col-span-full" }, [
                createVNode(unref(_sfc_main$d), {
                  id: "receipt_footer",
                  label: _ctx.$t("Receipt Footer"),
                  modelValue: unref(form).receipt_footer,
                  "onUpdate:modelValue": ($event) => unref(form).receipt_footer = $event,
                  error: unref(form).errors.receipt_footer
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ])
            ];
          }
        }),
        actions: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(unref(_sfc_main$4), {
              on: unref(form).recentlySuccessful,
              class: "me-3"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Saved."))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Saved.")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$5), {
              class: { "opacity-25": unref(form).processing },
              loading: unref(form).processing
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Save"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(unref(_sfc_main$4), {
                on: unref(form).recentlySuccessful,
                class: "me-3"
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(_ctx.$t("Saved.")), 1)
                ]),
                _: 1
              }, 8, ["on"]),
              createVNode(unref(_sfc_main$5), {
                class: { "opacity-25": unref(form).processing },
                loading: unref(form).processing
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
                ]),
                _: 1
              }, 8, ["class", "loading"])
            ];
          }
        }),
        _: 1
      }, _parent));
      if (app_version.value) {
        _push(`<div class="mt-8 mb-2 sm:-mb-4 flex flex-wrap items-center justify-center gap-x-8 gap-y-2"><div> App: <span class="font-bold">${ssrInterpolate(app_version.value)}</span></div><div>`);
        _push(ssrRenderComponent(unref(_sfc_main$b), {
          label: _ctx.$t("Support Links"),
          modelValue: unref(form).support_links,
          "onUpdate:modelValue": ($event) => unref(form).support_links = $event
        }, null, _parent));
        _push(`</div><div> Laravel: <span class="font-bold">${ssrInterpolate(__props.laravel_version)}</span></div><div> Vue: <span class="font-bold">${ssrInterpolate(version)}</span></div><div class="flex items-center gap-2"> Docs: <a target="_blank" href="/documentation.pdf" class="font-bold mr-4 group relative"> PDF `);
        _push(ssrRenderComponent(_component_Icon, {
          name: "a-blank",
          class: "h-4 w-4 ml-1 hidden group-hover:block absolute top-0.5 left-full"
        }, null, _parent));
        _push(`</a><a target="_blank" href="https://docs.tec.sh/sma" class="text-sm font-bold group relative"> Online Version `);
        _push(ssrRenderComponent(_component_Icon, {
          name: "a-blank",
          class: "h-4 w-4 ml-1 hidden group-hover:block absolute top-0 left-full"
        }, null, _parent));
        _push(`</a></div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Setting/Index.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
