import { ref, onMounted, resolveComponent, withCtx, createVNode, toDisplayString, createTextVNode, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderList, ssrRenderAttr } from "vue/server-renderer";
import { usePage, router } from "@inertiajs/vue3";
import _sfc_main$9 from "./QuickView-BlIx_eJI.js";
import { P as PageSearch } from "./PageSearch-CiHIJpyQ.js";
import { _ as _sfc_main$1 } from "./AdminLayout-DHH3IgME.js";
import "./ActionMessage-cgGHxf5V.js";
import { b as _sfc_main$8 } from "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import { _ as _sfc_main$3 } from "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import { _ as _sfc_main$a } from "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import { e as _sfc_main$2, b as _sfc_main$4, _ as _sfc_main$5, c as _sfc_main$6, d as _sfc_main$7 } from "./http-CDixhmav.js";
import { _ as _sfc_main$b } from "./LoadingButton-DREeyNQW.js";
import "../ssr.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "lodash.debounce";
import "dayjs";
import "./AppLayout-BRHmSgDa.js";
import "notiwind";
import "vue-i18n";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
import "@vuepic/vue-datepicker";
import "lodash.isequal";
import "axios";
import "lodash.throttle";
const _sfc_main = /* @__PURE__ */ Object.assign({ layout: _sfc_main$1 }, {
  __name: "Index",
  __ssrInlineRender: true,
  props: ["pagination", "custom_fields"],
  setup(__props) {
    usePage();
    const view = ref(false);
    ref(null);
    const current = ref(null);
    const deleted = ref(false);
    const deleting = ref(false);
    const adjusting = ref(false);
    const confirming = ref(false);
    const { filters, searching, searchNow } = PageSearch();
    onMounted(() => {
      var _a;
      if ((_a = route().params) == null ? void 0 : _a.id) {
        viewRow({ id: route().params.id });
      }
    });
    function viewRow(row) {
      current.value = row;
      view.value = true;
    }
    function adjustNow() {
      adjusting.value = true;
      router.visit(route("stock_counts.adjust", current.value.id), {
        method: "post",
        onFinish: () => adjusting.value = false,
        preserveState: (page) => {
          var _a;
          return (_a = page.props.flash) == null ? void 0 : _a.error;
        }
      });
    }
    function editRow(row) {
      router.visit(route("stock_counts.edit", { stock_count: row.id }));
    }
    function deleteRow(row) {
      deleting.value = true;
      router.delete(route("stock_counts.destroy", row.id), {
        preserveScroll: true,
        onSuccess: () => deleted.value = true,
        onFinish: () => deleting.value = false
      });
    }
    return (_ctx, _push, _parent, _attrs) => {
      var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l;
      const _component_Head = resolveComponent("Head");
      const _component_Header = resolveComponent("Header");
      const _component_Icon = resolveComponent("Icon");
      const _component_spam = resolveComponent("spam");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_Head, null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<title${_scopeId}>${ssrInterpolate(_ctx.$t("Stock Counts"))}</title>`);
          } else {
            return [
              createVNode("title", null, toDisplayString(_ctx.$t("Stock Counts")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_Header, null, {
        subheading: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Please review the data below"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Please review the data below")), 1)
            ];
          }
        }),
        menu: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex items-center justify-center gap-4"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$2), {
              href: _ctx.route("stock_counts.create")
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Start Stock Count"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Start Stock Count")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$3), {
              align: "right",
              width: "56",
              "auto-close": false
            }, {
              trigger: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<button class="flex items-center -m-2 p-2.5 rounded-md transition duration-150 ease-in-out"${_scopeId2}>`);
                  _push3(ssrRenderComponent(_component_Icon, {
                    name: "funnel-o",
                    size: "size-5"
                  }, null, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_spam, { class: "sr-only" }, {
                    default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(`${ssrInterpolate(_ctx.$t("Show Filters"))}`);
                      } else {
                        return [
                          createTextVNode(toDisplayString(_ctx.$t("Show Filters")), 1)
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                  _push3(`</button>`);
                } else {
                  return [
                    createVNode("button", { class: "flex items-center -m-2 p-2.5 rounded-md transition duration-150 ease-in-out" }, [
                      createVNode(_component_Icon, {
                        name: "funnel-o",
                        size: "size-5"
                      }),
                      createVNode(_component_spam, { class: "sr-only" }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(_ctx.$t("Show Filters")), 1)
                        ]),
                        _: 1
                      })
                    ])
                  ];
                }
              }),
              content: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<div class="px-4 py-2"${_scopeId2}><div${_scopeId2}>`);
                  _push3(ssrRenderComponent(unref(_sfc_main$4), {
                    json: true,
                    onChange: unref(searchNow),
                    label: _ctx.$t("Trashed"),
                    modelValue: unref(filters).trashed,
                    "onUpdate:modelValue": ($event) => unref(filters).trashed = $event,
                    placeholder: _ctx.$t("With Trashed"),
                    suggestions: [
                      { value: "not", label: _ctx.$t("Not Trashed") },
                      { value: "with", label: _ctx.$t("With Trashed") },
                      { value: "only", label: _ctx.$t("Only Trashed") }
                    ]
                  }, null, _parent3, _scopeId2));
                  _push3(`</div></div>`);
                } else {
                  return [
                    createVNode("div", { class: "px-4 py-2" }, [
                      createVNode("div", null, [
                        createVNode(unref(_sfc_main$4), {
                          json: true,
                          onChange: unref(searchNow),
                          label: _ctx.$t("Trashed"),
                          modelValue: unref(filters).trashed,
                          "onUpdate:modelValue": ($event) => unref(filters).trashed = $event,
                          placeholder: _ctx.$t("With Trashed"),
                          suggestions: [
                            { value: "not", label: _ctx.$t("Not Trashed") },
                            { value: "with", label: _ctx.$t("With Trashed") },
                            { value: "only", label: _ctx.$t("Only Trashed") }
                          ]
                        }, null, 8, ["onChange", "label", "modelValue", "onUpdate:modelValue", "placeholder", "suggestions"])
                      ])
                    ])
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "flex items-center justify-center gap-4" }, [
                createVNode(unref(_sfc_main$2), {
                  href: _ctx.route("stock_counts.create")
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.$t("Start Stock Count")), 1)
                  ]),
                  _: 1
                }, 8, ["href"]),
                createVNode(unref(_sfc_main$3), {
                  align: "right",
                  width: "56",
                  "auto-close": false
                }, {
                  trigger: withCtx(() => [
                    createVNode("button", { class: "flex items-center -m-2 p-2.5 rounded-md transition duration-150 ease-in-out" }, [
                      createVNode(_component_Icon, {
                        name: "funnel-o",
                        size: "size-5"
                      }),
                      createVNode(_component_spam, { class: "sr-only" }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(_ctx.$t("Show Filters")), 1)
                        ]),
                        _: 1
                      })
                    ])
                  ]),
                  content: withCtx(() => [
                    createVNode("div", { class: "px-4 py-2" }, [
                      createVNode("div", null, [
                        createVNode(unref(_sfc_main$4), {
                          json: true,
                          onChange: unref(searchNow),
                          label: _ctx.$t("Trashed"),
                          modelValue: unref(filters).trashed,
                          "onUpdate:modelValue": ($event) => unref(filters).trashed = $event,
                          placeholder: _ctx.$t("With Trashed"),
                          suggestions: [
                            { value: "not", label: _ctx.$t("Not Trashed") },
                            { value: "with", label: _ctx.$t("With Trashed") },
                            { value: "only", label: _ctx.$t("Only Trashed") }
                          ]
                        }, null, 8, ["onChange", "label", "modelValue", "onUpdate:modelValue", "placeholder", "suggestions"])
                      ])
                    ])
                  ]),
                  _: 1
                })
              ])
            ];
          }
        }),
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Stock Counts"))} `);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Stock Counts")) + " ", 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<div class="relative px-4 sm:px-6 lg:px-8 bg-white dark:bg-gray-800 grow self-stretch flex flex-col items-stretch justify-stretch">`);
      if (unref(searching)) {
        _push(ssrRenderComponent(unref(_sfc_main$5), { "circle-size": "w-10 h-10" }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="flow-root grow"><div class="-mx-4 -my-2 overflow-x-auto sm:-mx-6 lg:-mx-8"><div class="inline-block min-w-full my-2 align-middle border-b border-gray-200 dark:border-gray-700"><table class="fixed-actions min-w-full divide-y dark:divide-gray-700"><thead><tr><th scope="col" class="py-3.5 pl-4 pr-3 text-center text-sm font-semibold text-focus sm:pl-6 lg:pl-8 w-16"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Date"))} `);
      if ((_b = (_a = unref(filters)) == null ? void 0 : _a.sort) == null ? void 0 : _b.startsWith("date:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "date:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Reference"))} `);
      if ((_d = (_c = unref(filters)) == null ? void 0 : _c.sort) == null ? void 0 : _d.startsWith("reference:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "reference:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Type"))} `);
      if ((_f = (_e = unref(filters)) == null ? void 0 : _e.sort) == null ? void 0 : _f.startsWith("type:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "type:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Details"))} `);
      if ((_h = (_g = unref(filters)) == null ? void 0 : _g.sort) == null ? void 0 : _h.startsWith("details:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "details:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="py-3.5 pl-4 pr-3 text-center text-sm font-semibold text-focus sm:pl-6 lg:pl-8 w-16"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Created at"))} `);
      if ((_j = (_i = unref(filters)) == null ? void 0 : _i.sort) == null ? void 0 : _j.startsWith("created_at:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "created_at:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="py-3.5 pl-4 pr-3 text-center text-sm font-semibold text-focus sm:pl-6 lg:pl-8 w-16"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Completed at"))} `);
      if ((_l = (_k = unref(filters)) == null ? void 0 : _k.sort) == null ? void 0 : _l.startsWith("completed_at:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "completed_at:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="relative py-3.5 pl-3 pr-4 sm:pr-6 lg:pr-8 w-16"><span class="sr-only">${ssrInterpolate(_ctx.$t("Actions"))}</span></th></tr></thead><tbody class="divide-y dark:divide-gray-700 bg-white dark:bg-gray-900">`);
      if (__props.pagination && __props.pagination.data && __props.pagination.data.length) {
        _push(`<!--[-->`);
        ssrRenderList(__props.pagination.data, (row) => {
          _push(`<tr><td class="cursor-pointer whitespace-nowrap py-4 pl-4 pr-3 text-sm font-medium text-focus sm:pl-6 lg:pl-8 w-14">${ssrInterpolate(_ctx.$date(row.date))}</td><td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm">${ssrInterpolate(row.reference)}</td><td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm">${ssrInterpolate(row.type == "full" ? _ctx.$t("Full") : _ctx.$t("Partial"))}</td><td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm"><div class="-my-2 min-w-64 line-clamp-2">${ssrInterpolate(row.details || "")}</div></td><td class="cursor-pointer whitespace-nowrap py-4 pl-4 pr-3 text-sm font-medium text-focus sm:pl-6 lg:pl-8 w-14">${ssrInterpolate(_ctx.$datetime(row.created_at))}</td><td class="cursor-pointer whitespace-nowrap py-4 pl-4 pr-3 text-sm font-medium text-focus sm:pl-6 lg:pl-8 w-14">${ssrInterpolate(_ctx.$datetime(row.completed_at))}</td><td class="relative whitespace-nowrap py-4 pl-3 pr-4 text-right text-sm font-medium sm:pr-6 lg:pr-8 w-16"><div class="flex items-center justify-start gap-4 text-mute"><button type="button" class="link">`);
          _push(ssrRenderComponent(_component_Icon, {
            name: "eye",
            size: "size-5"
          }, null, _parent));
          _push(`</button>`);
          if (!row.completed_at) {
            _push(`<a target="_blank" class="link"${ssrRenderAttr("href", _ctx.route("stock_counts.export", row.id))}>`);
            _push(ssrRenderComponent(_component_Icon, {
              name: "download-o",
              size: "size-5"
            }, null, _parent));
            _push(`</a>`);
          } else {
            _push(`<a target="_blank" class="link"${ssrRenderAttr("href", _ctx.route("stock_counts.download", row.id))}>`);
            _push(ssrRenderComponent(_component_Icon, {
              name: "download-o",
              size: "size-5 text-success-500"
            }, null, _parent));
            _push(`</a>`);
          }
          if (row.completed_at) {
            _push(`<!--[-->`);
            if (row.adjusted_at) {
              _push(ssrRenderComponent(_component_Icon, {
                name: "tick",
                size: "size-5 text-success-500"
              }, null, _parent));
            } else {
              _push(`<button type="button" class="link">`);
              _push(ssrRenderComponent(_component_Icon, {
                name: "adjust-v",
                size: "size-5"
              }, null, _parent));
              _push(`</button>`);
            }
            _push(`<!--]-->`);
          } else {
            _push(`<!---->`);
          }
          _push(ssrRenderComponent(unref(_sfc_main$6), {
            row,
            record: _ctx.$t("Stock Count"),
            deleted: deleted.value,
            deleting: deleting.value,
            editRow: row.completed_at ? false : editRow,
            deleteRow: row.completed_at ? false : deleteRow
          }, null, _parent));
          _push(`</div></td></tr>`);
        });
        _push(`<!--]-->`);
      } else {
        _push(`<tr><td colspan="100%"><div class="whitespace-nowrap pl-4 pr-3 py-3.5 text-sm font-light text-mute sm:pl-2 lg:pl-4">${ssrInterpolate(_ctx.$t("There is no data to display!"))}</div></td></tr>`);
      }
      _push(`</tbody></table></div></div></div><div class="-mx-4 sm:-mx-6 lg:-mx-8">`);
      _push(ssrRenderComponent(unref(_sfc_main$7), {
        class: "mt-auto mx-4 sm:mx-6 py-2 text-sm",
        meta: __props.pagination.meta,
        links: __props.pagination.links
      }, null, _parent));
      _push(`</div>`);
      _push(ssrRenderComponent(unref(_sfc_main$8), {
        show: view.value,
        "max-width": "3xl",
        onClose: ($event) => view.value = false
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_sfc_main$9, {
              current: current.value,
              fields: __props.custom_fields,
              onClose: ($event) => view.value = false,
              editRow: current.value.completed_at ? false : editRow
            }, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(_sfc_main$9, {
                current: current.value,
                fields: __props.custom_fields,
                onClose: ($event) => view.value = false,
                editRow: current.value.completed_at ? false : editRow
              }, null, 8, ["current", "fields", "onClose", "editRow"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$8), {
        show: confirming.value,
        "max-width": "lg",
        onClose: ($event) => confirming.value = false,
        closeable: !adjusting.value
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="p-6"${_scopeId}><div class="sm:flex sm:items-start"${_scopeId}><div class="mx-auto flex size-12 shrink-0 items-center justify-center rounded-full bg-red-100 sm:mx-0 sm:size-10"${_scopeId}>`);
            _push2(ssrRenderComponent(_component_Icon, {
              name: "disclaimer",
              class: "size-6 text-red-600"
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="mt-3 text-center sm:ml-4 sm:mt-0 sm:text-left"${_scopeId}><h3 class="text-base font-semibold text-focus" id="modal-title"${_scopeId}>${ssrInterpolate(_ctx.$t("Adjust Store Stock?"))}</h3><div class="mt-2"${_scopeId}><div class="text-sm"${_scopeId}>${ssrInterpolate(_ctx.$t("Are you sure you want to perform stock adjustments?"))} ${ssrInterpolate(_ctx.$t("All of your data will be permanently changed."))} <div class="text-error-500 mt-4"${_scopeId}>${ssrInterpolate(_ctx.$t("This action cannot be undone."))}</div></div></div></div></div><div class="mt-6 flex justify-center md:justify-end gap-4"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$a), {
              type: "button",
              onClick: ($event) => confirming.value = false,
              disabled: adjusting.value
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Cancel"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Cancel")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$b), {
              class: ["md:w-full justify-center", { "opacity-25": adjusting.value }],
              onClick: ($event) => adjustNow(),
              loading: adjusting.value
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Initiate Adjustments"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Initiate Adjustments")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div></div>`);
          } else {
            return [
              createVNode("div", { class: "p-6" }, [
                createVNode("div", { class: "sm:flex sm:items-start" }, [
                  createVNode("div", { class: "mx-auto flex size-12 shrink-0 items-center justify-center rounded-full bg-red-100 sm:mx-0 sm:size-10" }, [
                    createVNode(_component_Icon, {
                      name: "disclaimer",
                      class: "size-6 text-red-600"
                    })
                  ]),
                  createVNode("div", { class: "mt-3 text-center sm:ml-4 sm:mt-0 sm:text-left" }, [
                    createVNode("h3", {
                      class: "text-base font-semibold text-focus",
                      id: "modal-title"
                    }, toDisplayString(_ctx.$t("Adjust Store Stock?")), 1),
                    createVNode("div", { class: "mt-2" }, [
                      createVNode("div", { class: "text-sm" }, [
                        createTextVNode(toDisplayString(_ctx.$t("Are you sure you want to perform stock adjustments?")) + " " + toDisplayString(_ctx.$t("All of your data will be permanently changed.")) + " ", 1),
                        createVNode("div", { class: "text-error-500 mt-4" }, toDisplayString(_ctx.$t("This action cannot be undone.")), 1)
                      ])
                    ])
                  ])
                ]),
                createVNode("div", { class: "mt-6 flex justify-center md:justify-end gap-4" }, [
                  createVNode(unref(_sfc_main$a), {
                    type: "button",
                    onClick: ($event) => confirming.value = false,
                    disabled: adjusting.value
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(_ctx.$t("Cancel")), 1)
                    ]),
                    _: 1
                  }, 8, ["onClick", "disabled"]),
                  createVNode(unref(_sfc_main$b), {
                    class: ["md:w-full justify-center", { "opacity-25": adjusting.value }],
                    onClick: ($event) => adjustNow(),
                    loading: adjusting.value
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(_ctx.$t("Initiate Adjustments")), 1)
                    ]),
                    _: 1
                  }, 8, ["onClick", "loading", "class"])
                ])
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Product/StockCount/Index.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
