import { ref, resolveComponent, withCtx, createVNode, toDisplayString, createTextVNode, unref, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderList, ssrRenderClass } from "vue/server-renderer";
import { usePage, router } from "@inertiajs/vue3";
import _sfc_main$9 from "./Form-BdoAm-O9.js";
import _sfc_main$8 from "./QuickView-GBt1iy0h.js";
import { P as PageSearch } from "./PageSearch-CiHIJpyQ.js";
import "./ActionMessage-cgGHxf5V.js";
import { b as _sfc_main$7 } from "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import { _ as _sfc_main$2 } from "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import { _ as _sfc_main$1 } from "./AdminLayout-DHH3IgME.js";
import { b as _sfc_main$3, _ as _sfc_main$4, c as _sfc_main$5, d as _sfc_main$6 } from "./http-CDixhmav.js";
import "./LoadingButton-DREeyNQW.js";
import "dayjs";
import "../ssr.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "lodash.debounce";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
import "./AppLayout-BRHmSgDa.js";
import "notiwind";
import "vue-i18n";
import "@vuepic/vue-datepicker";
import "lodash.isequal";
import "axios";
import "lodash.throttle";
const _sfc_main = /* @__PURE__ */ Object.assign({ layout: _sfc_main$1 }, {
  __name: "Index",
  __ssrInlineRender: true,
  props: ["pagination", "custom_fields", "address_fields"],
  setup(__props) {
    usePage();
    const add = ref(false);
    const view = ref(false);
    const current = ref(null);
    const deleted = ref(false);
    const deleting = ref(false);
    const { filters, searching, searchNow } = PageSearch();
    function editRow(row) {
      current.value = row;
      view.value = false;
      add.value = true;
    }
    function deleteRow(row) {
      deleting.value = true;
      router.delete(route("deliveries.destroy", row.id), {
        preserveScroll: true,
        onSuccess: () => deleted.value = row.id,
        onFinish: () => deleting.value = false
      });
    }
    function hideForm() {
      current.value = null;
      add.value = false;
    }
    return (_ctx, _push, _parent, _attrs) => {
      var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n;
      const _component_Head = resolveComponent("Head");
      const _component_Header = resolveComponent("Header");
      const _component_Icon = resolveComponent("Icon");
      const _component_spam = resolveComponent("spam");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_Head, null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<title${_scopeId}>${ssrInterpolate(_ctx.$t("Deliveries"))}</title>`);
          } else {
            return [
              createVNode("title", null, toDisplayString(_ctx.$t("Deliveries")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_Header, null, {
        subheading: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Please review the data below"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Please review the data below")), 1)
            ];
          }
        }),
        menu: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex items-center justify-center gap-4"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$2), {
              align: "right",
              width: "56",
              "auto-close": false
            }, {
              trigger: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<button class="flex items-center -m-2 p-2.5 rounded-md transition duration-150 ease-in-out"${_scopeId2}>`);
                  _push3(ssrRenderComponent(_component_Icon, {
                    name: "funnel-o",
                    size: "size-5"
                  }, null, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_spam, { class: "sr-only" }, {
                    default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(`${ssrInterpolate(_ctx.$t("Show Filters"))}`);
                      } else {
                        return [
                          createTextVNode(toDisplayString(_ctx.$t("Show Filters")), 1)
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                  _push3(`</button>`);
                } else {
                  return [
                    createVNode("button", { class: "flex items-center -m-2 p-2.5 rounded-md transition duration-150 ease-in-out" }, [
                      createVNode(_component_Icon, {
                        name: "funnel-o",
                        size: "size-5"
                      }),
                      createVNode(_component_spam, { class: "sr-only" }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(_ctx.$t("Show Filters")), 1)
                        ]),
                        _: 1
                      })
                    ])
                  ];
                }
              }),
              content: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<div class="px-4 py-2"${_scopeId2}><div${_scopeId2}>`);
                  _push3(ssrRenderComponent(unref(_sfc_main$3), {
                    json: true,
                    onChange: unref(searchNow),
                    label: _ctx.$t("Trashed"),
                    modelValue: unref(filters).trashed,
                    "onUpdate:modelValue": ($event) => unref(filters).trashed = $event,
                    placeholder: _ctx.$t("With Trashed"),
                    suggestions: [
                      { value: "not", label: _ctx.$t("Not Trashed") },
                      { value: "with", label: _ctx.$t("With Trashed") },
                      { value: "only", label: _ctx.$t("Only Trashed") }
                    ]
                  }, null, _parent3, _scopeId2));
                  _push3(`</div></div>`);
                } else {
                  return [
                    createVNode("div", { class: "px-4 py-2" }, [
                      createVNode("div", null, [
                        createVNode(unref(_sfc_main$3), {
                          json: true,
                          onChange: unref(searchNow),
                          label: _ctx.$t("Trashed"),
                          modelValue: unref(filters).trashed,
                          "onUpdate:modelValue": ($event) => unref(filters).trashed = $event,
                          placeholder: _ctx.$t("With Trashed"),
                          suggestions: [
                            { value: "not", label: _ctx.$t("Not Trashed") },
                            { value: "with", label: _ctx.$t("With Trashed") },
                            { value: "only", label: _ctx.$t("Only Trashed") }
                          ]
                        }, null, 8, ["onChange", "label", "modelValue", "onUpdate:modelValue", "placeholder", "suggestions"])
                      ])
                    ])
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "flex items-center justify-center gap-4" }, [
                createVNode(unref(_sfc_main$2), {
                  align: "right",
                  width: "56",
                  "auto-close": false
                }, {
                  trigger: withCtx(() => [
                    createVNode("button", { class: "flex items-center -m-2 p-2.5 rounded-md transition duration-150 ease-in-out" }, [
                      createVNode(_component_Icon, {
                        name: "funnel-o",
                        size: "size-5"
                      }),
                      createVNode(_component_spam, { class: "sr-only" }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(_ctx.$t("Show Filters")), 1)
                        ]),
                        _: 1
                      })
                    ])
                  ]),
                  content: withCtx(() => [
                    createVNode("div", { class: "px-4 py-2" }, [
                      createVNode("div", null, [
                        createVNode(unref(_sfc_main$3), {
                          json: true,
                          onChange: unref(searchNow),
                          label: _ctx.$t("Trashed"),
                          modelValue: unref(filters).trashed,
                          "onUpdate:modelValue": ($event) => unref(filters).trashed = $event,
                          placeholder: _ctx.$t("With Trashed"),
                          suggestions: [
                            { value: "not", label: _ctx.$t("Not Trashed") },
                            { value: "with", label: _ctx.$t("With Trashed") },
                            { value: "only", label: _ctx.$t("Only Trashed") }
                          ]
                        }, null, 8, ["onChange", "label", "modelValue", "onUpdate:modelValue", "placeholder", "suggestions"])
                      ])
                    ])
                  ]),
                  _: 1
                })
              ])
            ];
          }
        }),
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Deliveries"))} `);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Deliveries")) + " ", 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<div class="relative px-4 sm:px-6 lg:px-8 bg-white dark:bg-gray-800 grow self-stretch flex flex-col items-stretch justify-stretch">`);
      if (unref(searching)) {
        _push(ssrRenderComponent(unref(_sfc_main$4), { "circle-size": "w-10 h-10" }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="flow-root grow"><div class="-mx-4 -my-2 overflow-x-auto sm:-mx-6 lg:-mx-8"><div class="inline-block min-w-full my-2 align-middle border-b border-gray-200 dark:border-gray-700"><table class="fixed-actions min-w-full divide-y dark:divide-gray-700"><thead><tr><th scope="col" class="pl-4 pr-3 sm:pl-6 lg:pl-8 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Date"))} `);
      if ((_b = (_a = unref(filters)) == null ? void 0 : _a.sort) == null ? void 0 : _b.startsWith("date:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "date:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Reference"))} `);
      if ((_d = (_c = unref(filters)) == null ? void 0 : _c.sort) == null ? void 0 : _d.startsWith("reference:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "reference:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Sale Reference"))} `);
      if ((_f = (_e = unref(filters)) == null ? void 0 : _e.sort) == null ? void 0 : _f.startsWith("sale.reference:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "sale.reference:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Customer"))} `);
      if ((_h = (_g = unref(filters)) == null ? void 0 : _g.sort) == null ? void 0 : _h.startsWith("customer:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "customer:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus">${ssrInterpolate(_ctx.$t("Address"))}</th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Delivered at"))} `);
      if ((_j = (_i = unref(filters)) == null ? void 0 : _i.sort) == null ? void 0 : _j.startsWith("delivered_at:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "delivered_at:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Delivered by"))} `);
      if ((_l = (_k = unref(filters)) == null ? void 0 : _k.sort) == null ? void 0 : _l.startsWith("delivered_by:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "delivered_by:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Received by"))} `);
      if ((_n = (_m = unref(filters)) == null ? void 0 : _m.sort) == null ? void 0 : _n.startsWith("received_by:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "received_by:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="relative py-3.5 pl-3 pr-4 sm:pr-6 lg:pr-8 w-16"><span class="sr-only">${ssrInterpolate(_ctx.$t("Actions"))}</span></th></tr></thead><tbody class="divide-y dark:divide-gray-700 bg-white dark:bg-gray-900">`);
      if (__props.pagination && __props.pagination.data && __props.pagination.data.length) {
        _push(`<!--[-->`);
        ssrRenderList(__props.pagination.data, (row) => {
          var _a2, _b2;
          _push(`<tr class="${ssrRenderClass(row.deleted_at ? "bg-red-100 dark:bg-red-950" : "")}"><td class="cursor-pointer whitespace-nowrap pl-4 pr-3 sm:pl-6 lg:pl-8 py-4 text-sm">${ssrInterpolate(_ctx.$date(row.date))}</td><td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm">${ssrInterpolate(row.reference)}</td><td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm">${ssrInterpolate(row.sale.reference)}</td><td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm">${ssrInterpolate(((_a2 = row.customer) == null ? void 0 : _a2.company) || ((_b2 = row.customer) == null ? void 0 : _b2.name) || "")}</td><td class="cursor-pointer px-3 py-4 text-sm"><div class="-my-2 min-w-64 line-clamp-2">${ssrInterpolate(_ctx.$address(row.address))}</div></td><td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm">${ssrInterpolate(row.delivered_at ? _ctx.$datetime(row.delivered_at) : "")}</td><td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm">${ssrInterpolate(row.delivered_by || "")}</td><td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm">${ssrInterpolate(row.received_by || "")}</td><td class="${ssrRenderClass([row.deleted_at ? "deleted" : "", "relative whitespace-nowrap py-4 pl-3 pr-4 text-right text-sm font-medium sm:pr-6 lg:pr-8 w-16"])}">`);
          _push(ssrRenderComponent(unref(_sfc_main$5), {
            row,
            record: _ctx.$t("Delivery"),
            editRow,
            deleted: deleted.value,
            deleting: deleting.value,
            deleteRow
          }, null, _parent));
          _push(`</td></tr>`);
        });
        _push(`<!--]-->`);
      } else {
        _push(`<tr><td colspan="100%"><div class="whitespace-nowrap pl-4 pr-3 py-3.5 text-sm font-light text-mute sm:pl-2 lg:pl-4">${ssrInterpolate(_ctx.$t("There is no data to display!"))}</div></td></tr>`);
      }
      _push(`</tbody></table></div></div></div><div class="-mx-4 sm:-mx-6 lg:-mx-8">`);
      _push(ssrRenderComponent(unref(_sfc_main$6), {
        class: "mt-auto mx-4 sm:mx-6 py-2 text-sm",
        meta: __props.pagination.meta,
        links: __props.pagination.links
      }, null, _parent));
      _push(`</div>`);
      _push(ssrRenderComponent(unref(_sfc_main$7), {
        show: view.value,
        "max-width": "2xl",
        onClose: ($event) => view.value = false
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_sfc_main$8, {
              current: current.value,
              fields: __props.custom_fields,
              onClose: ($event) => view.value = false,
              editRow
            }, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(_sfc_main$8, {
                current: current.value,
                fields: __props.custom_fields,
                onClose: ($event) => view.value = false,
                editRow
              }, null, 8, ["current", "fields", "onClose"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$7), {
        show: add.value,
        backdrop: false,
        "max-width": "2xl",
        closeable: true,
        onClose: hideForm
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          var _a2, _b2;
          if (_push2) {
            _push2(ssrRenderComponent(_sfc_main$9, {
              current: current.value,
              customer: (_a2 = current.value) == null ? void 0 : _a2.customer,
              address_fields: __props.address_fields,
              custom_fields: __props.custom_fields,
              onClose: hideForm,
              onDone: hideForm
            }, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(_sfc_main$9, {
                current: current.value,
                customer: (_b2 = current.value) == null ? void 0 : _b2.customer,
                address_fields: __props.address_fields,
                custom_fields: __props.custom_fields,
                onClose: hideForm,
                onDone: hideForm
              }, null, 8, ["current", "customer", "address_fields", "custom_fields"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Order/Delivery/Index.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
