import { ref, resolveComponent, withCtx, createVNode, toDisplayString, createTextVNode, unref, createBlock, createCommentVNode, openBlock, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderList } from "vue/server-renderer";
import { usePage, router } from "@inertiajs/vue3";
import _sfc_main$b from "./Form-D9AgRz9v.js";
import _sfc_main$a from "./View-BUMyrz8i.js";
import { P as PageSearch } from "./PageSearch-CiHIJpyQ.js";
import { _ as _sfc_main$1 } from "./AdminLayout-DHH3IgME.js";
import _sfc_main$c from "./Form-BpdwWw3G.js";
import "./ActionMessage-cgGHxf5V.js";
import { b as _sfc_main$9 } from "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import { _ as _sfc_main$3, b as _sfc_main$4 } from "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import { e as _sfc_main$2, b as _sfc_main$5, _ as _sfc_main$6, c as _sfc_main$7, d as _sfc_main$8 } from "./http-CDixhmav.js";
import "./LoadingButton-DREeyNQW.js";
import "../ssr.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "lodash.debounce";
import "dayjs";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
import "./AppLayout-BRHmSgDa.js";
const _sfc_main = /* @__PURE__ */ Object.assign({ layout: _sfc_main$1 }, {
  __name: "Index",
  __ssrInlineRender: true,
  props: ["pagination", "countries", "custom_fields", "payment_fields"],
  setup(__props) {
    const page = usePage();
    const add = ref(false);
    const view = ref(false);
    const current = ref(null);
    const payment = ref(false);
    const deleted = ref(false);
    const deleting = ref(false);
    const { filters, searching, searchNow } = PageSearch();
    function editRow(row) {
      current.value = row;
      add.value = true;
    }
    function deleteRow(row) {
      deleting.value = true;
      router.delete(route("suppliers.destroy", row.id), {
        preserveScroll: true,
        onSuccess: () => deleted.value = true,
        onFinish: () => deleting.value = false
      });
    }
    function hideForm() {
      if (!view.value) {
        current.value = null;
      }
      add.value = false;
    }
    return (_ctx, _push, _parent, _attrs) => {
      var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j;
      const _component_Head = resolveComponent("Head");
      const _component_Header = resolveComponent("Header");
      const _component_Icon = resolveComponent("Icon");
      const _component_spam = resolveComponent("spam");
      const _component_Link = resolveComponent("Link");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_Head, null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<title${_scopeId}>${ssrInterpolate(_ctx.$t("Suppliers"))}</title>`);
          } else {
            return [
              createVNode("title", null, toDisplayString(_ctx.$t("Suppliers")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_Header, null, {
        subheading: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Please review the data below"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Please review the data below")), 1)
            ];
          }
        }),
        menu: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex items-center justify-center gap-4"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$2), {
              type: "button",
              onClick: ($event) => add.value = true
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Add {x}", { x: _ctx.$t("Supplier") }))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Add {x}", { x: _ctx.$t("Supplier") })), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$3), {
              align: "right",
              width: "40",
              "auto-close": false
            }, {
              trigger: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<button class="flex items-center -m-2 p-2.5 rounded-md transition duration-150 ease-in-out"${_scopeId2}>`);
                  _push3(ssrRenderComponent(_component_Icon, {
                    name: "v-arrows",
                    size: "size-6"
                  }, null, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_spam, { class: "sr-only" }, {
                    default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(`${ssrInterpolate(_ctx.$t("Import/Export"))}`);
                      } else {
                        return [
                          createTextVNode(toDisplayString(_ctx.$t("Import/Export")), 1)
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                  _push3(`</button>`);
                } else {
                  return [
                    createVNode("button", { class: "flex items-center -m-2 p-2.5 rounded-md transition duration-150 ease-in-out" }, [
                      createVNode(_component_Icon, {
                        name: "v-arrows",
                        size: "size-6"
                      }),
                      createVNode(_component_spam, { class: "sr-only" }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(_ctx.$t("Import/Export")), 1)
                        ]),
                        _: 1
                      })
                    ])
                  ];
                }
              }),
              content: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<div${_scopeId2}><div class="block px-4 py-2 text-xs text-gray-400"${_scopeId2}>${ssrInterpolate(_ctx.$t("Import/Export"))}</div>`);
                  if (_ctx.route().has("suppliers.import")) {
                    _push3(ssrRenderComponent(unref(_sfc_main$4), {
                      href: _ctx.route("suppliers.import")
                    }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`${ssrInterpolate(_ctx.$t("Import {x}", { x: _ctx.$t("Suppliers") }))}`);
                        } else {
                          return [
                            createTextVNode(toDisplayString(_ctx.$t("Import {x}", { x: _ctx.$t("Suppliers") })), 1)
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                  } else {
                    _push3(`<!---->`);
                  }
                  if (_ctx.route().has("suppliers.export")) {
                    _push3(ssrRenderComponent(unref(_sfc_main$4), {
                      as: "a",
                      href: _ctx.route("suppliers.export")
                    }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`${ssrInterpolate(_ctx.$t("Export {x}", { x: _ctx.$t("Suppliers") }))}`);
                        } else {
                          return [
                            createTextVNode(toDisplayString(_ctx.$t("Export {x}", { x: _ctx.$t("Suppliers") })), 1)
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                  } else {
                    _push3(`<!---->`);
                  }
                  _push3(`</div>`);
                } else {
                  return [
                    createVNode("div", null, [
                      createVNode("div", { class: "block px-4 py-2 text-xs text-gray-400" }, toDisplayString(_ctx.$t("Import/Export")), 1),
                      _ctx.route().has("suppliers.import") ? (openBlock(), createBlock(unref(_sfc_main$4), {
                        key: 0,
                        href: _ctx.route("suppliers.import")
                      }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(_ctx.$t("Import {x}", { x: _ctx.$t("Suppliers") })), 1)
                        ]),
                        _: 1
                      }, 8, ["href"])) : createCommentVNode("", true),
                      _ctx.route().has("suppliers.export") ? (openBlock(), createBlock(unref(_sfc_main$4), {
                        key: 1,
                        as: "a",
                        href: _ctx.route("suppliers.export")
                      }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(_ctx.$t("Export {x}", { x: _ctx.$t("Suppliers") })), 1)
                        ]),
                        _: 1
                      }, 8, ["href"])) : createCommentVNode("", true)
                    ])
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$3), {
              align: "right",
              width: "56",
              "auto-close": false
            }, {
              trigger: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<button class="flex items-center -m-2 p-2.5 rounded-md transition duration-150 ease-in-out"${_scopeId2}>`);
                  _push3(ssrRenderComponent(_component_Icon, {
                    name: "funnel-o",
                    size: "size-5"
                  }, null, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_spam, { class: "sr-only" }, {
                    default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(`${ssrInterpolate(_ctx.$t("Show Filters"))}`);
                      } else {
                        return [
                          createTextVNode(toDisplayString(_ctx.$t("Show Filters")), 1)
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                  _push3(`</button>`);
                } else {
                  return [
                    createVNode("button", { class: "flex items-center -m-2 p-2.5 rounded-md transition duration-150 ease-in-out" }, [
                      createVNode(_component_Icon, {
                        name: "funnel-o",
                        size: "size-5"
                      }),
                      createVNode(_component_spam, { class: "sr-only" }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(_ctx.$t("Show Filters")), 1)
                        ]),
                        _: 1
                      })
                    ])
                  ];
                }
              }),
              content: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<div class="px-4 py-2"${_scopeId2}><div${_scopeId2}>`);
                  _push3(ssrRenderComponent(unref(_sfc_main$5), {
                    json: true,
                    onChange: unref(searchNow),
                    label: _ctx.$t("Trashed"),
                    modelValue: unref(filters).trashed,
                    "onUpdate:modelValue": ($event) => unref(filters).trashed = $event,
                    placeholder: _ctx.$t("With Trashed"),
                    suggestions: [
                      { value: "not", label: _ctx.$t("Not Trashed") },
                      { value: "with", label: _ctx.$t("With Trashed") },
                      { value: "only", label: _ctx.$t("Only Trashed") }
                    ]
                  }, null, _parent3, _scopeId2));
                  _push3(`</div></div>`);
                } else {
                  return [
                    createVNode("div", { class: "px-4 py-2" }, [
                      createVNode("div", null, [
                        createVNode(unref(_sfc_main$5), {
                          json: true,
                          onChange: unref(searchNow),
                          label: _ctx.$t("Trashed"),
                          modelValue: unref(filters).trashed,
                          "onUpdate:modelValue": ($event) => unref(filters).trashed = $event,
                          placeholder: _ctx.$t("With Trashed"),
                          suggestions: [
                            { value: "not", label: _ctx.$t("Not Trashed") },
                            { value: "with", label: _ctx.$t("With Trashed") },
                            { value: "only", label: _ctx.$t("Only Trashed") }
                          ]
                        }, null, 8, ["onChange", "label", "modelValue", "onUpdate:modelValue", "placeholder", "suggestions"])
                      ])
                    ])
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "flex items-center justify-center gap-4" }, [
                createVNode(unref(_sfc_main$2), {
                  type: "button",
                  onClick: ($event) => add.value = true
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.$t("Add {x}", { x: _ctx.$t("Supplier") })), 1)
                  ]),
                  _: 1
                }, 8, ["onClick"]),
                createVNode(unref(_sfc_main$3), {
                  align: "right",
                  width: "40",
                  "auto-close": false
                }, {
                  trigger: withCtx(() => [
                    createVNode("button", { class: "flex items-center -m-2 p-2.5 rounded-md transition duration-150 ease-in-out" }, [
                      createVNode(_component_Icon, {
                        name: "v-arrows",
                        size: "size-6"
                      }),
                      createVNode(_component_spam, { class: "sr-only" }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(_ctx.$t("Import/Export")), 1)
                        ]),
                        _: 1
                      })
                    ])
                  ]),
                  content: withCtx(() => [
                    createVNode("div", null, [
                      createVNode("div", { class: "block px-4 py-2 text-xs text-gray-400" }, toDisplayString(_ctx.$t("Import/Export")), 1),
                      _ctx.route().has("suppliers.import") ? (openBlock(), createBlock(unref(_sfc_main$4), {
                        key: 0,
                        href: _ctx.route("suppliers.import")
                      }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(_ctx.$t("Import {x}", { x: _ctx.$t("Suppliers") })), 1)
                        ]),
                        _: 1
                      }, 8, ["href"])) : createCommentVNode("", true),
                      _ctx.route().has("suppliers.export") ? (openBlock(), createBlock(unref(_sfc_main$4), {
                        key: 1,
                        as: "a",
                        href: _ctx.route("suppliers.export")
                      }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(_ctx.$t("Export {x}", { x: _ctx.$t("Suppliers") })), 1)
                        ]),
                        _: 1
                      }, 8, ["href"])) : createCommentVNode("", true)
                    ])
                  ]),
                  _: 1
                }),
                createVNode(unref(_sfc_main$3), {
                  align: "right",
                  width: "56",
                  "auto-close": false
                }, {
                  trigger: withCtx(() => [
                    createVNode("button", { class: "flex items-center -m-2 p-2.5 rounded-md transition duration-150 ease-in-out" }, [
                      createVNode(_component_Icon, {
                        name: "funnel-o",
                        size: "size-5"
                      }),
                      createVNode(_component_spam, { class: "sr-only" }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(_ctx.$t("Show Filters")), 1)
                        ]),
                        _: 1
                      })
                    ])
                  ]),
                  content: withCtx(() => [
                    createVNode("div", { class: "px-4 py-2" }, [
                      createVNode("div", null, [
                        createVNode(unref(_sfc_main$5), {
                          json: true,
                          onChange: unref(searchNow),
                          label: _ctx.$t("Trashed"),
                          modelValue: unref(filters).trashed,
                          "onUpdate:modelValue": ($event) => unref(filters).trashed = $event,
                          placeholder: _ctx.$t("With Trashed"),
                          suggestions: [
                            { value: "not", label: _ctx.$t("Not Trashed") },
                            { value: "with", label: _ctx.$t("With Trashed") },
                            { value: "only", label: _ctx.$t("Only Trashed") }
                          ]
                        }, null, 8, ["onChange", "label", "modelValue", "onUpdate:modelValue", "placeholder", "suggestions"])
                      ])
                    ])
                  ]),
                  _: 1
                })
              ])
            ];
          }
        }),
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Suppliers"))} `);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Suppliers")) + " ", 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<div class="relative px-4 sm:px-6 lg:px-8 bg-white dark:bg-gray-800 grow self-stretch flex flex-col items-stretch justify-stretch">`);
      if (unref(searching)) {
        _push(ssrRenderComponent(unref(_sfc_main$6), { "circle-size": "w-10 h-10" }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="flow-root grow"><div class="-mx-4 -my-2 overflow-x-auto sm:-mx-6 lg:-mx-8"><div class="inline-block min-w-full my-2 align-middle border-b border-gray-200 dark:border-gray-700"><table class="fixed-actions min-w-full divide-y dark:divide-gray-700"><thead><tr><th scope="col" class="whitespace-nowrap pl-6 pr-3 sm:pl-6 lg:pl-8 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Name"))} `);
      if ((_b = (_a = unref(filters)) == null ? void 0 : _a.sort) == null ? void 0 : _b.startsWith("name:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "name:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="whitespace-nowrap px-3 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Company"))} `);
      if ((_d = (_c = unref(filters)) == null ? void 0 : _c.sort) == null ? void 0 : _d.startsWith("company:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "company:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="whitespace-nowrap px-3 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Phone"))} `);
      if ((_f = (_e = unref(filters)) == null ? void 0 : _e.sort) == null ? void 0 : _f.startsWith("phone:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "phone:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="whitespace-nowrap px-3 py-3.5 text-left text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Email"))} `);
      if ((_h = (_g = unref(filters)) == null ? void 0 : _g.sort) == null ? void 0 : _h.startsWith("email:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "email:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="whitespace-nowrap px-3 py-3.5 text-center text-sm font-semibold text-focus">${ssrInterpolate(_ctx.$t("Due"))}</th><th scope="col" class="whitespace-nowrap px-3 py-3.5 text-center text-sm font-semibold text-focus"><button type="button" class="flex items-center gap-2 whitespace-nowrap">${ssrInterpolate(_ctx.$t("Due Limit"))} `);
      if ((_j = (_i = unref(filters)) == null ? void 0 : _i.sort) == null ? void 0 : _j.startsWith("due_limit:")) {
        _push(ssrRenderComponent(_component_Icon, {
          size: "size-3 text-mute",
          name: unref(filters).sort == "due_limit:desc" ? "c-up" : "c-down"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></th><th scope="col" class="whitespace-nowrap px-3 py-3.5 text-left text-sm font-semibold text-focus">${ssrInterpolate(_ctx.$t("Address"))}</th><th scope="col" class="relative py-3.5 pl-3 pr-4 sm:pr-6 lg:pr-8 w-16"><span class="sr-only">${ssrInterpolate(_ctx.$t("Actions"))}</span></th></tr></thead><tbody class="divide-y dark:divide-gray-700 bg-white dark:bg-gray-900">`);
      if (__props.pagination && __props.pagination.data && __props.pagination.data.length) {
        _push(`<!--[-->`);
        ssrRenderList(__props.pagination.data, (row) => {
          _push(`<tr><td class="cursor-pointer whitespace-nowrap pl-4 pr-3 sm:pl-6 lg:pl-8 py-4 text-sm">${ssrInterpolate(row.name)}</td><td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm">${ssrInterpolate(row.company || "")}</td><td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm">${ssrInterpolate(row.phone || "")}</td><td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm">${ssrInterpolate(row.email || "")}</td><td class="whitespace-nowrap px-3 py-4 text-sm text-right">`);
          if (unref(page).props.selected_store) {
            _push(`<button type="button" class="link">`);
            if (row.balance < 0) {
              _push(`<!--[-->${ssrInterpolate(_ctx.$t("Adv"))}: ${ssrInterpolate(_ctx.$currency(0 - row.balance))}<!--]-->`);
            } else {
              _push(`<!--[-->${ssrInterpolate(_ctx.$currency(row.balance))}<!--]-->`);
            }
            _push(`</button>`);
          } else {
            _push(`<!--[-->`);
            if (row.balance < 0) {
              _push(`<!--[-->${ssrInterpolate(_ctx.$t("Adv"))}: ${ssrInterpolate(_ctx.$currency(0 - row.balance))}<!--]-->`);
            } else {
              _push(`<!--[-->${ssrInterpolate(_ctx.$currency(row.balance))}<!--]-->`);
            }
            _push(`<!--]-->`);
          }
          _push(`</td><td class="cursor-pointer whitespace-nowrap px-3 py-4 text-sm text-right">${ssrInterpolate(row.due_limit ? _ctx.$number(row.due_limit) : "")}</td><td class="cursor-pointer px-3 py-4 text-sm"><div class="-my-2 min-w-64 max-w-xs line-clamp-2">${ssrInterpolate(_ctx.$address(row))}</div></td><td class="relative whitespace-nowrap py-4 pl-3 pr-4 text-right text-sm font-medium sm:pr-6 lg:pr-8 w-16"><div class="flex items-center gap-4 text-mute">`);
          _push(ssrRenderComponent(_component_Link, {
            href: _ctx.route("suppliers.statement", row.id),
            class: "link"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(ssrRenderComponent(_component_Icon, {
                  name: "bars",
                  class: "size-5"
                }, null, _parent2, _scopeId));
              } else {
                return [
                  createVNode(_component_Icon, {
                    name: "bars",
                    class: "size-5"
                  })
                ];
              }
            }),
            _: 2
          }, _parent));
          _push(ssrRenderComponent(unref(_sfc_main$7), {
            row,
            record: _ctx.$t("Supplier"),
            editRow,
            deleted: deleted.value,
            deleting: deleting.value,
            deleteRow
          }, null, _parent));
          _push(`</div></td></tr>`);
        });
        _push(`<!--]-->`);
      } else {
        _push(`<tr><td colspan="100%"><div class="whitespace-nowrap pl-4 pr-3 py-3.5 text-sm font-light text-mute sm:pl-2 lg:pl-4">${ssrInterpolate(_ctx.$t("There is no data to display!"))}</div></td></tr>`);
      }
      _push(`</tbody></table></div></div></div><div class="-mx-4 sm:-mx-6 lg:-mx-8">`);
      _push(ssrRenderComponent(unref(_sfc_main$8), {
        class: "mt-auto mx-4 sm:mx-6 py-2 text-sm",
        meta: __props.pagination.meta,
        links: __props.pagination.links
      }, null, _parent));
      _push(`</div>`);
      _push(ssrRenderComponent(unref(_sfc_main$9), {
        show: view.value,
        backdrop: false,
        "max-width": "3xl",
        closeable: true,
        onClose: ($event) => view.value = false
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_sfc_main$a, {
              current: current.value,
              onClose: ($event) => view.value = false,
              editRow
            }, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(_sfc_main$a, {
                current: current.value,
                onClose: ($event) => view.value = false,
                editRow
              }, null, 8, ["current", "onClose"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$9), {
        show: add.value,
        backdrop: false,
        overflow: true,
        "max-width": "2xl",
        closeable: true,
        onClose: hideForm
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_sfc_main$b, {
              current: current.value,
              onClose: hideForm,
              onDone: hideForm,
              countries: __props.countries,
              custom_fields: __props.custom_fields
            }, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(_sfc_main$b, {
                current: current.value,
                onClose: hideForm,
                onDone: hideForm,
                countries: __props.countries,
                custom_fields: __props.custom_fields
              }, null, 8, ["current", "countries", "custom_fields"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$9), {
        show: payment.value,
        backdrop: false,
        overflow: true,
        "max-width": "2xl",
        closeable: true,
        onClose: ($event) => payment.value = false
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_sfc_main$c, {
              current: null,
              supplier: current.value,
              custom_fields: __props.payment_fields,
              onClose: ($event) => payment.value = false,
              onDone: ($event) => payment.value = false
            }, null, _parent2, _scopeId));
          } else {
            return [
              createVNode(_sfc_main$c, {
                current: null,
                supplier: current.value,
                custom_fields: __props.payment_fields,
                onClose: ($event) => payment.value = false,
                onDone: ($event) => payment.value = false
              }, null, 8, ["supplier", "custom_fields", "onClose", "onDone"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/People/Supplier/Index.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
