import { ref, watch, onMounted, nextTick, resolveComponent, withCtx, createVNode, toDisplayString, unref, createTextVNode, createBlock, createCommentVNode, openBlock, Fragment, renderList, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderList, ssrRenderStyle, ssrRenderAttr, ssrRenderClass } from "vue/server-renderer";
import { T } from "../ssr.js";
import JsBarcode from "jsbarcode";
import { notify } from "notiwind";
import { useI18n } from "vue-i18n";
import debounce from "lodash.debounce";
import { usePage } from "@inertiajs/vue3";
import { _ as _sfc_main$1 } from "./AdminLayout-DHH3IgME.js";
import { a as axios, F as $number, h as _sfc_main$5, b as _sfc_main$6, s as _sfc_main$7, G as chunkArray } from "./http-CDixhmav.js";
import "dayjs";
import { _ as _sfc_main$4 } from "./LoadingButton-DREeyNQW.js";
import "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import { _ as _sfc_main$2 } from "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import { _ as _sfc_main$3 } from "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "./AppLayout-BRHmSgDa.js";
import "@vuepic/vue-datepicker";
import "lodash.isequal";
import "axios";
import "lodash.throttle";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = /* @__PURE__ */ Object.assign({ layout: _sfc_main$1 }, {
  __name: "Label",
  __ssrInlineRender: true,
  props: ["brand", "category"],
  setup(__props) {
    const page = usePage();
    const { t } = useI18n();
    const labels = ref([]);
    const result = ref([]);
    const search = ref(null);
    const products = ref([]);
    const loaded = ref(false);
    ref(null);
    const selected_template = ref({});
    const options = ref({
      template: null,
      label_width: null,
      label_heigh: null,
      page_break: false,
      barcode_height: 30,
      check_promo: false,
      show_site_name: true,
      show_product_name: false,
      show_product_price: true,
      show_product_image: false
    });
    const templates = [
      {
        value: "40",
        label: t("40 per sheet (A4) (1.799in x 1.003in)"),
        width: 1.799 * 96,
        height: 1.003 * 96,
        page: "A4",
        barcode_height: 25,
        vertical_gap: 15
      },
      {
        value: "30",
        label: t("30 per sheet (2.625in x 1in)"),
        width: 2.625 * 96,
        height: 1 * 96,
        page: "A4",
        barcode_height: 25,
        vertical_gap: 15
      },
      {
        value: "24",
        label: t("24 per sheet (A4) (2.48in x 1.334in)"),
        width: 2.48 * 96,
        height: 1.334 * 96,
        page: "A4",
        barcode_height: 40,
        vertical_gap: 10
      },
      {
        value: "20",
        label: t("20 per sheet (4in x 1in)"),
        width: 4 * 96,
        height: 1 * 96,
        page: "A4",
        barcode_height: 25,
        vertical_gap: 15
      },
      {
        value: "18",
        label: t("18 per sheet (A4) (2.5in x 1.835in)"),
        width: 2.5 * 96,
        height: 1.835 * 96,
        page: "A4",
        barcode_height: 40,
        vertical_gap: 10
      },
      {
        value: "12",
        label: t("12 per sheet (A4) (2.5in x 2.834in)"),
        width: 2.5 * 96,
        height: 2.834 * 96,
        page: "A4",
        barcode_height: 60,
        vertical_gap: 5
      },
      {
        value: "10",
        label: t("10 per sheet (4in x 2in)"),
        width: 4 * 96,
        height: 2 * 96,
        page: "A4",
        barcode_height: 50,
        vertical_gap: 30
      },
      { value: "1", label: t("Custom") }
    ];
    watch(search, debounce(searchProduct, 500));
    onMounted(() => {
      let form = localStorage.getItem("labels.form");
      if (form) {
        form = JSON.parse(form);
        products.value = [...form.products];
        options.value = { ...form.options };
      } else {
        options.value.template = "24";
      }
    });
    async function saveForm() {
      let form = { products: [...products.value], options: { ...options.value } };
      localStorage.setItem("labels.form", JSON.stringify(form));
    }
    async function searchProduct(q) {
      await axios.post(T("search.products", { search: q, type: "sale" })).then((res) => {
        if (res.data.length == 1) {
          addProduct(res.data[0]);
        } else {
          result.value = res.data;
        }
      }).catch();
    }
    async function addProduct(product) {
      var _a;
      if (!products.value.find((p) => p.id == product.id)) {
        product = await axios.get(T("products.show", product.id)).then((r) => r.data);
        products.value = [
          ...products.value,
          {
            id: product.id,
            code: product.code,
            name: product.name,
            symbology: product.symbology,
            price: $number(product.price),
            quantity: ((_a = product.stocks) == null ? void 0 : _a.reduce((a, s) => Number(s.balance) + a, 0)) || 1
          }
        ];
      }
      saveForm();
      await nextTick();
      search.value = "";
      document.getElementById("product-search").focus();
    }
    function removeItem(product) {
      products.value = [...products.value.filter((i) => i.id != product.id)];
      saveForm();
    }
    function reset() {
      loaded.value = false;
      products.value = [];
      options.value = {
        template: null,
        label_width: null,
        label_heigh: null,
        page_break: false,
        check_promo: false,
        show_site_name: true,
        show_product_name: false,
        show_product_price: true,
        show_product_image: false
      };
      saveForm();
    }
    async function load() {
      if (products.value.length < 1) {
        notify({ group: "main", type: "error", title: t("Please add at least one product!") });
        return;
      }
      if (!options.value.template) {
        notify({ group: "main", type: "error", title: t("Please select template!") });
        return;
      }
      if (products.value.reduce((a, p) => Number(p.quantity) + a, 0) > 1e3) {
        notify({ group: "main", type: "error", title: t("Maximum 1000 labels can be printed at a time!") });
        return;
      }
      selected_template.value = templates.find((t2) => t2.value == options.value.template);
      loaded.value = true;
      labels.value = [];
      products.value.forEach((p) => {
        for (let i = 0; i < p.quantity; i++) {
          labels.value = [...labels.value, p];
        }
      });
      if (options.value.template && options.value.template != "1") {
        labels.value = chunkArray(labels.value, Number(options.value.template));
      }
      await nextTick();
      JsBarcode(".barcode").init();
    }
    function print() {
      window.print();
    }
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Head = resolveComponent("Head");
      const _component_Icon = resolveComponent("Icon");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_Head, null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<title${_scopeId}>${ssrInterpolate(_ctx.$t("Product Labels"))}</title>`);
          } else {
            return [
              createVNode("title", null, toDisplayString(_ctx.$t("Product Labels")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<div class="pt-6 pb-0 sm:py-8 px-0 sm:px-6 lg:px-8">`);
      if (!loaded.value) {
        _push(ssrRenderComponent(unref(_sfc_main$2), { onSubmitted: load }, {
          title: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("Product Labels"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("Product Labels")), 1)
              ];
            }
          }),
          description: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("Please add products the below to print label."))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("Please add products the below to print label.")), 1)
              ];
            }
          }),
          form: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<div class="col-span-full p-6 rounded border border-gray-200 dark:border-gray-700"${_scopeId}><div class="relative"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$5), {
                id: "product-search",
                label: "",
                modelValue: search.value,
                "onUpdate:modelValue": ($event) => search.value = $event,
                placeholder: _ctx.$t("Scan barcode or type to search")
              }, null, _parent2, _scopeId));
              if (search.value && result.value && result.value.length) {
                _push2(`<div class="absolute z-10 top-full left-0 right-0 ring-1 bg-white dark:bg-gray-700 rounded-md dark:ring-gray-700 mt-2 py-1"${_scopeId}><!--[-->`);
                ssrRenderList(result.value, (p) => {
                  _push2(`<button type="button" class="w-full text-left py-1.5 px-4 hover:bg-gray-100 dark:hover:bg-gray-900"${_scopeId}>${ssrInterpolate(p.name)}</button>`);
                });
                _push2(`<!--]--></div>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(`</div>`);
              if (products.value && products.value.length) {
                _push2(`<div${_scopeId}><h4 class="text-lg font-bold mt-6 mb-3"${_scopeId}>${ssrInterpolate(_ctx.$t("Products"))}</h4><table class="w-full divide-y dark:divide-gray-700"${_scopeId}><!--[-->`);
                ssrRenderList(products.value, (product, index) => {
                  _push2(`<tr class="hover:bg-gray-50 dark:hover:bg-gray-800"${_scopeId}><td class="p-2"${_scopeId}>${ssrInterpolate(product.name)}</td><td class="w-36 px-2 py-1.5"${_scopeId}>`);
                  _push2(ssrRenderComponent(unref(_sfc_main$5), {
                    min: 1,
                    type: "number",
                    modelValue: products.value[index].quantity,
                    "onUpdate:modelValue": ($event) => products.value[index].quantity = $event,
                    onChange: saveForm
                  }, null, _parent2, _scopeId));
                  _push2(`</td><td class="w-6 pl-4 py-1 pr-2"${_scopeId}><button type="button" class="text-red-500 hover:text-red-700"${_scopeId}>`);
                  _push2(ssrRenderComponent(_component_Icon, { name: "trash" }, null, _parent2, _scopeId));
                  _push2(`</button></td></tr>`);
                });
                _push2(`<!--]--></table></div>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(`</div><div class="col-span-full"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                json: "",
                id: "template",
                onChange: saveForm,
                label: _ctx.$t("Template"),
                suggestions: templates,
                modelValue: options.value.template,
                "onUpdate:modelValue": ($event) => options.value.template = $event
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
              if (options.value.template == "1") {
                _push2(`<!--[--><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
                _push2(ssrRenderComponent(unref(_sfc_main$5), {
                  onChange: saveForm,
                  label: _ctx.$t("Label Width") + " (in)",
                  min: 0.05,
                  type: "number",
                  modelValue: options.value.label_width,
                  "onUpdate:modelValue": ($event) => options.value.label_width = $event
                }, null, _parent2, _scopeId));
                _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
                _push2(ssrRenderComponent(unref(_sfc_main$5), {
                  onChange: saveForm,
                  label: _ctx.$t("Label Height") + " (in)",
                  min: 0.05,
                  type: "number",
                  modelValue: options.value.label_height,
                  "onUpdate:modelValue": ($event) => options.value.label_height = $event
                }, null, _parent2, _scopeId));
                _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
                _push2(ssrRenderComponent(unref(_sfc_main$5), {
                  min: 10,
                  max: 60,
                  type: "number",
                  onChange: saveForm,
                  modelValue: options.value.barcode_height,
                  "onUpdate:modelValue": ($event) => options.value.barcode_height = $event,
                  label: _ctx.$t("Barcode Height") + " (pixel)"
                }, null, _parent2, _scopeId));
                _push2(`</div><div class="col-span-full"${_scopeId}>`);
                _push2(ssrRenderComponent(unref(_sfc_main$7), {
                  id: "page_break",
                  modelValue: options.value.page_break,
                  "onUpdate:modelValue": ($event) => options.value.page_break = $event,
                  label: _ctx.$t("Add page break after each label"),
                  onChange: saveForm
                }, null, _parent2, _scopeId));
                _push2(`</div><!--]-->`);
              } else {
                _push2(`<!---->`);
              }
              _push2(`<div class="col-span-full flex flex-wrap gap-x-10 gap-y-4 rounded-md p-4 border border-gray-200 dark:border-gray-700 overflow-x-auto"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$7), {
                onChange: saveForm,
                id: "show_site_name",
                label: _ctx.$t("Show Site Name"),
                modelValue: options.value.show_site_name,
                "onUpdate:modelValue": ($event) => options.value.show_site_name = $event
              }, null, _parent2, _scopeId));
              _push2(ssrRenderComponent(unref(_sfc_main$7), {
                onChange: saveForm,
                id: "show_product_price",
                label: _ctx.$t("Show Product Price"),
                modelValue: options.value.show_product_price,
                "onUpdate:modelValue": ($event) => options.value.show_product_price = $event
              }, null, _parent2, _scopeId));
              _push2(ssrRenderComponent(unref(_sfc_main$7), {
                onChange: saveForm,
                id: "show_product_name",
                label: _ctx.$t("Show Product Name"),
                modelValue: options.value.show_product_name,
                "onUpdate:modelValue": ($event) => options.value.show_product_name = $event
              }, null, _parent2, _scopeId));
              _push2(ssrRenderComponent(unref(_sfc_main$7), {
                onChange: saveForm,
                id: "check_promo",
                label: _ctx.$t("Check for Promotions"),
                modelValue: options.value.check_promo,
                "onUpdate:modelValue": ($event) => options.value.check_promo = $event
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              return [
                createVNode("div", { class: "col-span-full p-6 rounded border border-gray-200 dark:border-gray-700" }, [
                  createVNode("div", { class: "relative" }, [
                    createVNode(unref(_sfc_main$5), {
                      id: "product-search",
                      label: "",
                      modelValue: search.value,
                      "onUpdate:modelValue": ($event) => search.value = $event,
                      placeholder: _ctx.$t("Scan barcode or type to search")
                    }, null, 8, ["modelValue", "onUpdate:modelValue", "placeholder"]),
                    search.value && result.value && result.value.length ? (openBlock(), createBlock("div", {
                      key: 0,
                      class: "absolute z-10 top-full left-0 right-0 ring-1 bg-white dark:bg-gray-700 rounded-md dark:ring-gray-700 mt-2 py-1"
                    }, [
                      (openBlock(true), createBlock(Fragment, null, renderList(result.value, (p) => {
                        return openBlock(), createBlock("button", {
                          key: p.id,
                          type: "button",
                          onClick: ($event) => addProduct(p),
                          class: "w-full text-left py-1.5 px-4 hover:bg-gray-100 dark:hover:bg-gray-900"
                        }, toDisplayString(p.name), 9, ["onClick"]);
                      }), 128))
                    ])) : createCommentVNode("", true)
                  ]),
                  products.value && products.value.length ? (openBlock(), createBlock("div", { key: 0 }, [
                    createVNode("h4", { class: "text-lg font-bold mt-6 mb-3" }, toDisplayString(_ctx.$t("Products")), 1),
                    createVNode("table", { class: "w-full divide-y dark:divide-gray-700" }, [
                      (openBlock(true), createBlock(Fragment, null, renderList(products.value, (product, index) => {
                        return openBlock(), createBlock("tr", {
                          key: product.code,
                          class: "hover:bg-gray-50 dark:hover:bg-gray-800"
                        }, [
                          createVNode("td", { class: "p-2" }, toDisplayString(product.name), 1),
                          createVNode("td", { class: "w-36 px-2 py-1.5" }, [
                            createVNode(unref(_sfc_main$5), {
                              min: 1,
                              type: "number",
                              modelValue: products.value[index].quantity,
                              "onUpdate:modelValue": ($event) => products.value[index].quantity = $event,
                              onChange: saveForm
                            }, null, 8, ["modelValue", "onUpdate:modelValue"])
                          ]),
                          createVNode("td", { class: "w-6 pl-4 py-1 pr-2" }, [
                            createVNode("button", {
                              type: "button",
                              onClick: ($event) => removeItem(product),
                              class: "text-red-500 hover:text-red-700"
                            }, [
                              createVNode(_component_Icon, { name: "trash" })
                            ], 8, ["onClick"])
                          ])
                        ]);
                      }), 128))
                    ])
                  ])) : createCommentVNode("", true)
                ]),
                createVNode("div", { class: "col-span-full" }, [
                  createVNode(unref(_sfc_main$6), {
                    json: "",
                    id: "template",
                    onChange: saveForm,
                    label: _ctx.$t("Template"),
                    suggestions: templates,
                    modelValue: options.value.template,
                    "onUpdate:modelValue": ($event) => options.value.template = $event
                  }, null, 8, ["label", "modelValue", "onUpdate:modelValue"])
                ]),
                options.value.template == "1" ? (openBlock(), createBlock(Fragment, { key: 0 }, [
                  createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                    createVNode(unref(_sfc_main$5), {
                      onChange: saveForm,
                      label: _ctx.$t("Label Width") + " (in)",
                      min: 0.05,
                      type: "number",
                      modelValue: options.value.label_width,
                      "onUpdate:modelValue": ($event) => options.value.label_width = $event
                    }, null, 8, ["label", "modelValue", "onUpdate:modelValue"])
                  ]),
                  createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                    createVNode(unref(_sfc_main$5), {
                      onChange: saveForm,
                      label: _ctx.$t("Label Height") + " (in)",
                      min: 0.05,
                      type: "number",
                      modelValue: options.value.label_height,
                      "onUpdate:modelValue": ($event) => options.value.label_height = $event
                    }, null, 8, ["label", "modelValue", "onUpdate:modelValue"])
                  ]),
                  createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                    createVNode(unref(_sfc_main$5), {
                      min: 10,
                      max: 60,
                      type: "number",
                      onChange: saveForm,
                      modelValue: options.value.barcode_height,
                      "onUpdate:modelValue": ($event) => options.value.barcode_height = $event,
                      label: _ctx.$t("Barcode Height") + " (pixel)"
                    }, null, 8, ["modelValue", "onUpdate:modelValue", "label"])
                  ]),
                  createVNode("div", { class: "col-span-full" }, [
                    createVNode(unref(_sfc_main$7), {
                      id: "page_break",
                      modelValue: options.value.page_break,
                      "onUpdate:modelValue": ($event) => options.value.page_break = $event,
                      label: _ctx.$t("Add page break after each label"),
                      onChange: saveForm
                    }, null, 8, ["modelValue", "onUpdate:modelValue", "label"])
                  ])
                ], 64)) : createCommentVNode("", true),
                createVNode("div", { class: "col-span-full flex flex-wrap gap-x-10 gap-y-4 rounded-md p-4 border border-gray-200 dark:border-gray-700 overflow-x-auto" }, [
                  createVNode(unref(_sfc_main$7), {
                    onChange: saveForm,
                    id: "show_site_name",
                    label: _ctx.$t("Show Site Name"),
                    modelValue: options.value.show_site_name,
                    "onUpdate:modelValue": ($event) => options.value.show_site_name = $event
                  }, null, 8, ["label", "modelValue", "onUpdate:modelValue"]),
                  createVNode(unref(_sfc_main$7), {
                    onChange: saveForm,
                    id: "show_product_price",
                    label: _ctx.$t("Show Product Price"),
                    modelValue: options.value.show_product_price,
                    "onUpdate:modelValue": ($event) => options.value.show_product_price = $event
                  }, null, 8, ["label", "modelValue", "onUpdate:modelValue"]),
                  createVNode(unref(_sfc_main$7), {
                    onChange: saveForm,
                    id: "show_product_name",
                    label: _ctx.$t("Show Product Name"),
                    modelValue: options.value.show_product_name,
                    "onUpdate:modelValue": ($event) => options.value.show_product_name = $event
                  }, null, 8, ["label", "modelValue", "onUpdate:modelValue"]),
                  createVNode(unref(_sfc_main$7), {
                    onChange: saveForm,
                    id: "check_promo",
                    label: _ctx.$t("Check for Promotions"),
                    modelValue: options.value.check_promo,
                    "onUpdate:modelValue": ($event) => options.value.check_promo = $event
                  }, null, 8, ["label", "modelValue", "onUpdate:modelValue"])
                ])
              ];
            }
          }),
          actions: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<div class="w-full flex items-center justify-between"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$3), {
                type: "button",
                onClick: reset
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(_ctx.$t("Reset"))}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(_ctx.$t("Reset")), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(ssrRenderComponent(unref(_sfc_main$4), {
                type: "button",
                onClick: load,
                loading: loaded.value
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(_ctx.$t("Load"))}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(_ctx.$t("Load")), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              return [
                createVNode("div", { class: "w-full flex items-center justify-between" }, [
                  createVNode(unref(_sfc_main$3), {
                    type: "button",
                    onClick: reset
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(_ctx.$t("Reset")), 1)
                    ]),
                    _: 1
                  }),
                  createVNode(unref(_sfc_main$4), {
                    type: "button",
                    onClick: load,
                    loading: loaded.value
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(_ctx.$t("Load")), 1)
                    ]),
                    _: 1
                  }, 8, ["loading"])
                ])
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<!---->`);
      }
      if (loaded.value) {
        _push(`<div class="flex flex-col gap-6 text-black"><div class="hidden"><div class="mb-[1px]"></div><div class="mb-[5px]"></div><div class="mb-[10px]"></div><div class="mb-[15px]"></div><div class="mb-[20px]"></div><div class="mb-[25px]"></div><div class="mb-[30px]"></div></div>`);
        if (options.value.template == "1" && options.value.page_break) {
          _push(`<!--[-->`);
          ssrRenderList(labels.value, (label) => {
            var _a;
            _push(`<div style="${ssrRenderStyle({
              width: options.value.label_width * 96 + "px",
              height: options.value.label_height * 96 + "px"
            })}" class="flex flex-col items-center p-1 rounded-sm overflow-hidden break-inside-avoid bg-white text-sm mx-auto break-after-page">`);
            if (options.value.show_site_name) {
              _push(`<div class="font-extrabold">${ssrInterpolate((_a = unref(page).props.settings) == null ? void 0 : _a.name)}</div>`);
            } else {
              _push(`<!---->`);
            }
            if (options.value.show_product_name) {
              _push(`<div>${ssrInterpolate(label.name)}</div>`);
            } else {
              _push(`<!---->`);
            }
            _push(`<svg class="barcode"${ssrRenderAttr("jsbarcode-width", 1)}${ssrRenderAttr("jsbarcode-margin", 0)}${ssrRenderAttr("jsbarcode-fontsize", 12)}${ssrRenderAttr("jsbarcode-textmargin", 0)} jsbarcode-fontoptions="bold"${ssrRenderAttr("jsbarcode-value", label.code)}${ssrRenderAttr("jsbarcode-format", label.symbology)}${ssrRenderAttr("jsbarcode-height", options.value.barcode_height || 30)}></svg>`);
            if (options.value.show_product_price) {
              _push(`<div>${ssrInterpolate(unref(t)("Price"))}: ${ssrInterpolate(_ctx.$currency(label.price))}</div>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</div>`);
          });
          _push(`<!--]-->`);
        } else if (options.value.template == "1") {
          _push(`<div style="${ssrRenderStyle({ width: "794px" })}" class="col-span-full w-full flex place-content-start gap-px flex-wrap items-start justify-between mx-auto p-px text-black overflow-hidden print:w-full print:h-full break-after-page"><!--[-->`);
          ssrRenderList(labels.value, (label) => {
            var _a;
            _push(`<div style="${ssrRenderStyle({
              width: options.value.label_width * 96 + "px",
              height: options.value.label_height * 96 + "px"
            })}" class="flex flex-col items-center p-1 rounded-sm overflow-hidden break-inside-avoid bg-white text-sm mb-px">`);
            if (options.value.show_site_name) {
              _push(`<div class="font-extrabold">${ssrInterpolate((_a = unref(page).props.settings) == null ? void 0 : _a.name)}</div>`);
            } else {
              _push(`<!---->`);
            }
            if (options.value.show_product_name) {
              _push(`<div>${ssrInterpolate(label.name)}</div>`);
            } else {
              _push(`<!---->`);
            }
            _push(`<svg class="barcode"${ssrRenderAttr("jsbarcode-width", 1)}${ssrRenderAttr("jsbarcode-margin", 0)}${ssrRenderAttr("jsbarcode-fontsize", 12)}${ssrRenderAttr("jsbarcode-textmargin", 0)} jsbarcode-fontoptions="bold"${ssrRenderAttr("jsbarcode-value", label.code)}${ssrRenderAttr("jsbarcode-format", label.symbology)}${ssrRenderAttr("jsbarcode-height", options.value.barcode_height || 30)}></svg>`);
            if (options.value.show_product_price) {
              _push(`<div>${ssrInterpolate(unref(t)("Price"))}: ${ssrInterpolate(_ctx.$currency(label.price))}</div>`);
            } else {
              _push(`<!---->`);
            }
            _push(`</div>`);
          });
          _push(`<!--]--></div>`);
        } else {
          _push(`<!--[-->`);
          ssrRenderList(labels.value, (group, gi) => {
            _push(`<div style="${ssrRenderStyle({ width: 794 + 32 + "px", height: 1127 + 32 + "px" })}" class="mx-auto col-span-full p-4 rounded-md border border-gray-200 dark:border-gray-700 print:p-0 print:border-0"><div style="${ssrRenderStyle({ width: "794px", height: "1123px" })}" class="col-span-full w-full flex place-content-start gap-px flex-wrap items-start justify-between mx-auto p-px text-black overflow-hidden print:w-full print:h-full break-after-page"><!--[-->`);
            ssrRenderList(group, (label) => {
              var _a, _b, _c, _d;
              _push(`<div style="${ssrRenderStyle({
                width: ((_a = selected_template.value) == null ? void 0 : _a.width) + "px",
                height: selected_template.value.height + "px"
              })}" class="${ssrRenderClass([`mb-[${((_b = selected_template.value) == null ? void 0 : _b.vertical_gap) || 1}px]`, "flex flex-col items-center p-1 rounded-sm overflow-hidden break-inside-avoid bg-white text-sm"])}">`);
              if (options.value.show_site_name) {
                _push(`<div class="font-extrabold">${ssrInterpolate((_c = unref(page).props.settings) == null ? void 0 : _c.name)}</div>`);
              } else {
                _push(`<!---->`);
              }
              if (options.value.show_product_name) {
                _push(`<div>${ssrInterpolate(label.name)}</div>`);
              } else {
                _push(`<!---->`);
              }
              _push(`<svg class="barcode"${ssrRenderAttr("jsbarcode-width", 1)}${ssrRenderAttr("jsbarcode-margin", 0)}${ssrRenderAttr("jsbarcode-fontsize", 12)}${ssrRenderAttr("jsbarcode-textmargin", 0)} jsbarcode-fontoptions="bold"${ssrRenderAttr("jsbarcode-value", label.code)}${ssrRenderAttr("jsbarcode-format", label.symbology)}${ssrRenderAttr("jsbarcode-height", ((_d = selected_template.value) == null ? void 0 : _d.barcode_height) || 30)}></svg>`);
              if (options.value.show_product_price) {
                _push(`<div>${ssrInterpolate(unref(t)("Price"))}: ${ssrInterpolate(_ctx.$currency(label.price))}</div>`);
              } else {
                _push(`<!---->`);
              }
              _push(`</div>`);
            });
            _push(`<!--]--></div><div class="text-center text-xs text-gray-700 dark:text-gray-300 print:hidden">${ssrInterpolate(_ctx.$t("Page"))} ${ssrInterpolate(gi + 1)}</div></div>`);
          });
          _push(`<!--]-->`);
        }
        _push(`<div class="w-full flex items-center justify-center gap-4 mt-6 print:hidden">`);
        _push(ssrRenderComponent(unref(_sfc_main$3), {
          type: "button",
          onClick: ($event) => loaded.value = false
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("Form"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("Form")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(ssrRenderComponent(unref(_sfc_main$4), {
          type: "button",
          onClick: print
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("Print"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("Print")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Product/Label.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
