import { ref, resolveComponent, withCtx, createVNode, toDisplayString, unref, createTextVNode, createBlock, createCommentVNode, openBlock, Fragment, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate } from "vue/server-renderer";
import { T } from "../ssr.js";
import { useI18n } from "vue-i18n";
import { usePage, useForm } from "@inertiajs/vue3";
import { _ as _sfc_main$1 } from "./AdminLayout-DHH3IgME.js";
import { _ as _sfc_main$4 } from "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import { _ as _sfc_main$3 } from "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import { E as _sfc_main$2, h as _sfc_main$6, v as _sfc_main$7, b as _sfc_main$8 } from "./http-CDixhmav.js";
import { _ as _sfc_main$5 } from "./LoadingButton-DREeyNQW.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "./AppLayout-BRHmSgDa.js";
import "notiwind";
import "lodash.debounce";
import "dayjs";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
import "@vuepic/vue-datepicker";
import "lodash.isequal";
import "axios";
import "lodash.throttle";
const _sfc_main = /* @__PURE__ */ Object.assign({ layout: _sfc_main$1 }, {
  __name: "Mail",
  __ssrInlineRender: true,
  props: { current: Object },
  setup(__props) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _A, _B, _C, _D, _E, _F, _G, _H, _I, _J, _K, _L, _M, _N, _O, _P, _Q, _R, _S, _T, _U, _V, _W, _X, _Y, _Z, __, _$, _aa, _ba, _ca;
    usePage();
    const { t } = useI18n({});
    const props = __props;
    const tab_links = ref([
      { label: t("General Settings"), route: "settings.index", icon: "settings" },
      { label: t("Mail Settings"), route: "settings.mail", icon: "envelope" },
      { label: t("Payment Settings"), route: "settings.payment", icon: "dollar" },
      { label: t("Scale Barcode Settings"), route: "settings.barcode", icon: "scale" }
    ]);
    if (T().has("settings.pos")) {
      tab_links.value.push({ label: t("POS Settings"), route: "settings.pos", icon: "pos" });
    }
    const form = useForm({
      prefer_biller_email: ((_a = props.current) == null ? void 0 : _a.prefer_biller_email) || false,
      mail: {
        from: {
          name: ((_d = (_c = (_b = props.current) == null ? void 0 : _b.mail) == null ? void 0 : _c.from) == null ? void 0 : _d.name) || "",
          address: ((_g = (_f = (_e = props.current) == null ? void 0 : _e.mail) == null ? void 0 : _f.from) == null ? void 0 : _g.address) || ""
        },
        default: ((_i = (_h = props.current) == null ? void 0 : _h.mail) == null ? void 0 : _i.default) || "log",
        mailers: {
          smtp: {
            host: ((_m = (_l = (_k = (_j = props.current) == null ? void 0 : _j.mail) == null ? void 0 : _k.mailers) == null ? void 0 : _l.smtp) == null ? void 0 : _m.host) || null,
            port: ((_q = (_p = (_o = (_n = props.current) == null ? void 0 : _n.mail) == null ? void 0 : _o.mailers) == null ? void 0 : _p.smtp) == null ? void 0 : _q.port) || null,
            username: ((_u = (_t = (_s = (_r = props.current) == null ? void 0 : _r.mail) == null ? void 0 : _s.mailers) == null ? void 0 : _t.smtp) == null ? void 0 : _u.username) || null,
            password: ((_y = (_x = (_w = (_v = props.current) == null ? void 0 : _v.mail) == null ? void 0 : _w.mailers) == null ? void 0 : _x.smtp) == null ? void 0 : _y.password) || null,
            encryption: ((_C = (_B = (_A = (_z = props.current) == null ? void 0 : _z.mail) == null ? void 0 : _A.mailers) == null ? void 0 : _B.smtp) == null ? void 0 : _C.encryption) || null
          },
          sendmail: {
            path: ((_G = (_F = (_E = (_D = props.current) == null ? void 0 : _D.mail) == null ? void 0 : _E.mailers) == null ? void 0 : _F.sendmail) == null ? void 0 : _G.path) || null
          }
        }
      },
      services: {
        mailgun: {
          domain: ((_J = (_I = (_H = props.current) == null ? void 0 : _H.services) == null ? void 0 : _I.mailgun) == null ? void 0 : _J.domain) || null,
          secret: ((_M = (_L = (_K = props.current) == null ? void 0 : _K.services) == null ? void 0 : _L.mailgun) == null ? void 0 : _M.secret) || null,
          endpoint: ((_P = (_O = (_N = props.current) == null ? void 0 : _N.services) == null ? void 0 : _O.mailgun) == null ? void 0 : _P.endpoint) || "api.mailgun.net"
        },
        postmark: {
          token: ((_S = (_R = (_Q = props.current) == null ? void 0 : _Q.services) == null ? void 0 : _R.postmark) == null ? void 0 : _S.token) || null
        },
        ses: {
          key: ((_V = (_U = (_T = props.current) == null ? void 0 : _T.services) == null ? void 0 : _U.ses) == null ? void 0 : _V.key) || null,
          secret: ((_Y = (_X = (_W = props.current) == null ? void 0 : _W.services) == null ? void 0 : _X.ses) == null ? void 0 : _Y.secret) || null,
          region: ((_$ = (__ = (_Z = props.current) == null ? void 0 : _Z.services) == null ? void 0 : __.ses) == null ? void 0 : _$.region) || "us-east-1"
        },
        resend: {
          key: ((_ca = (_ba = (_aa = props.current) == null ? void 0 : _aa.services) == null ? void 0 : _ba.resend) == null ? void 0 : _ca.key) || null
        }
      },
      "mailersend-driver": {
        api_key: props.current && props.current["mailersend-driver"] ? props.current["mailersend-driver"]["api_key"] : null
      }
    });
    function save() {
      form.post(T("settings.mail.store"));
    }
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Head = resolveComponent("Head");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_Head, null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<title${_scopeId}>${ssrInterpolate(_ctx.$t("Mail Settings"))}</title>`);
          } else {
            return [
              createVNode("title", null, toDisplayString(_ctx.$t("Mail Settings")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$2), { links: tab_links.value }, null, _parent));
      _push(`<div class="pt-6 pb-0 sm:py-8 px-0 sm:px-6 lg:px-8">`);
      _push(ssrRenderComponent(unref(_sfc_main$3), { onSubmitted: save }, {
        title: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Mail Settings"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Mail Settings")), 1)
            ];
          }
        }),
        description: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Please configure the mail driver and settings."))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Please configure the mail driver and settings.")), 1)
            ];
          }
        }),
        form: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$6), {
              label: _ctx.$t("Mail From Name"),
              modelValue: unref(form).mail.from.name,
              "onUpdate:modelValue": ($event) => unref(form).mail.from.name = $event,
              error: unref(form).errors["mail.from.name"] ? unref(form).errors["mail.from.name"].replace("mail.", "") : null
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$6), {
              type: "email",
              modelValue: unref(form).mail.from.address,
              "onUpdate:modelValue": ($event) => unref(form).mail.from.address = $event,
              label: _ctx.$t("Mail From Email Address"),
              error: unref(form).errors["mail.from.address"] ? unref(form).errors["mail.from.address"].replace("mail.", "") : null
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-full"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$7), {
              id: "prefer_biller_email",
              error: unref(form).errors.prefer_biller_email,
              checked: unref(form).prefer_biller_email,
              "onUpdate:checked": ($event) => unref(form).prefer_biller_email = $event,
              label: _ctx.$t("Please prefer biller name and email")
            }, null, _parent2, _scopeId));
            _push2(`<p class="mt-1 text-sm text-yellow-700 dark:text-yellow-500"${_scopeId}>${ssrInterpolate(_ctx.$t("This could result in email failure depending on your mail server and biller email address."))}</p></div><div class="col-span-full"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$8), {
              json: true,
              id: "default",
              searchable: false,
              label: _ctx.$t("Mail Driver"),
              modelValue: unref(form).mail.default,
              "onUpdate:modelValue": ($event) => unref(form).mail.default = $event,
              error: unref(form).errors["mail.default"] ? unref(form).errors["mail.default"].replace("mail.", "") : null,
              suggestions: [
                { value: "log", label: "Log to File" },
                { value: "smtp", label: "SMTP" },
                { value: "sendmail", label: "SendMail" },
                { value: "ses", label: "AWS SES" },
                { value: "mailgun", label: "Mailgun" },
                { value: "postmark", label: "Postmark" },
                { value: "resend", label: "Resend" }
                // { value: 'mailersend', label: 'MailerSend' },
              ]
            }, null, _parent2, _scopeId));
            _push2(`</div>`);
            if (unref(form).mail.default == "smtp") {
              _push2(`<!--[--><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                label: _ctx.$t("SMTP Host"),
                modelValue: unref(form).mail.mailers.smtp.host,
                "onUpdate:modelValue": ($event) => unref(form).mail.mailers.smtp.host = $event,
                error: unref(form).errors["mail.mailers.smtp.host"] ? unref(form).errors["mail.mailers.smtp.host"].replace("mail.mailers.", "") : null
              }, null, _parent2, _scopeId));
              _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                label: _ctx.$t("SMTP Port"),
                modelValue: unref(form).mail.mailers.smtp.port,
                "onUpdate:modelValue": ($event) => unref(form).mail.mailers.smtp.port = $event,
                error: unref(form).errors["mail.mailers.smtp.port"] ? unref(form).errors["mail.mailers.smtp.port"].replace("mail.mailers.", "") : null
              }, null, _parent2, _scopeId));
              _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                label: _ctx.$t("SMTP Username"),
                modelValue: unref(form).mail.mailers.smtp.username,
                "onUpdate:modelValue": ($event) => unref(form).mail.mailers.smtp.username = $event,
                error: unref(form).errors["mail.mailers.smtp.username"] ? unref(form).errors["mail.mailers.smtp.username"].replace("mail.mailers.", "") : null
              }, null, _parent2, _scopeId));
              _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                label: _ctx.$t("SMTP Password"),
                modelValue: unref(form).mail.mailers.smtp.password,
                "onUpdate:modelValue": ($event) => unref(form).mail.mailers.smtp.password = $event,
                error: unref(form).errors["mail.mailers.smtp.password"] ? unref(form).errors["mail.mailers.smtp.password"].replace("mail.mailers.", "") : null
              }, null, _parent2, _scopeId));
              _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                label: _ctx.$t("SMTP Encryption"),
                modelValue: unref(form).mail.mailers.smtp.encryption,
                "onUpdate:modelValue": ($event) => unref(form).mail.mailers.smtp.encryption = $event,
                error: unref(form).errors["mail.mailers.smtp.encryption"] ? unref(form).errors["mail.mailers.smtp.encryption"].replace("mail.mailers.", "") : null
              }, null, _parent2, _scopeId));
              _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}></div><!--]-->`);
            } else if (unref(form).mail.default == "ses") {
              _push2(`<!--[--><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                label: _ctx.$t("AWS SES Key"),
                modelValue: unref(form).services.ses.key,
                "onUpdate:modelValue": ($event) => unref(form).services.ses.key = $event,
                error: unref(form).errors["services.ses.key"] ? unref(form).errors["services.ses.key"].replace("services.", "") : null
              }, null, _parent2, _scopeId));
              _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                label: _ctx.$t("AWS SES Secret"),
                modelValue: unref(form).services.ses.secret,
                "onUpdate:modelValue": ($event) => unref(form).services.ses.secret = $event,
                error: unref(form).errors["services.ses.secret"] ? unref(form).errors["services.ses.secret"].replace("services.", "") : null
              }, null, _parent2, _scopeId));
              _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                label: _ctx.$t("AWS SES Region"),
                modelValue: unref(form).services.ses.region,
                "onUpdate:modelValue": ($event) => unref(form).services.ses.region = $event,
                error: unref(form).errors["services.ses.region"] ? unref(form).errors["services.ses.region"].replace("services.", "") : null
              }, null, _parent2, _scopeId));
              _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}></div><!--]-->`);
            } else if (unref(form).mail.default == "mailgun") {
              _push2(`<!--[--><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                label: _ctx.$t("Mailgun Domain"),
                modelValue: unref(form).services.mailgun.domain,
                "onUpdate:modelValue": ($event) => unref(form).services.mailgun.domain = $event,
                error: unref(form).errors["services.mailgun.domain"] ? unref(form).errors["services.mailgun.domain"].replace("services.", "") : null
              }, null, _parent2, _scopeId));
              _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                label: _ctx.$t("Mailgun Secret"),
                modelValue: unref(form).services.mailgun.secret,
                "onUpdate:modelValue": ($event) => unref(form).services.mailgun.secret = $event,
                error: unref(form).errors["services.mailgun.secret"] ? unref(form).errors["services.mailgun.secret"].replace("services.", "") : null
              }, null, _parent2, _scopeId));
              _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                label: _ctx.$t("Mailgun Endpoint"),
                modelValue: unref(form).services.mailgun.endpoint,
                "onUpdate:modelValue": ($event) => unref(form).services.mailgun.endpoint = $event,
                error: unref(form).errors["services.mailgun.endpoint"] ? unref(form).errors["services.mailgun.endpoint"].replace("services.", "") : null
              }, null, _parent2, _scopeId));
              _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}></div><!--]-->`);
            } else if (unref(form).mail.default == "postmark") {
              _push2(`<div class="col-span-full"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                label: _ctx.$t("Postmark Token"),
                modelValue: unref(form).services.postmark.token,
                "onUpdate:modelValue": ($event) => unref(form).services.postmark.token = $event,
                error: unref(form).errors["services.postmark.token"] ? unref(form).errors["services.postmark.token"].replace("services.", "") : null
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else if (unref(form).mail.default == "resend") {
              _push2(`<div class="col-span-full"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                label: _ctx.$t("Resend Key"),
                modelValue: unref(form).services.resend.key,
                "onUpdate:modelValue": ($event) => unref(form).services.resend.key = $event,
                error: unref(form).errors["services.resend.key"] ? unref(form).errors["services.resend.key"].replace("services.", "") : null
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else if (unref(form).mail.default == "mailersend") {
              _push2(`<div class="col-span-full"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                label: _ctx.$t("MailerSend API Key"),
                modelValue: unref(form)["mailersend-driver"].api_key,
                "onUpdate:modelValue": ($event) => unref(form)["mailersend-driver"].api_key = $event,
                error: unref(form).errors["mailersend-driver.api_key"] ? unref(form).errors["mailersend-driver.api_key"] : null
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else if (unref(form).mail.default == "sendmail") {
              _push2(`<div class="col-span-full"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                label: _ctx.$t("SendMail Path"),
                modelValue: unref(form).mail.mailers.sendmail.path,
                "onUpdate:modelValue": ($event) => unref(form).mail.mailers.sendmail.path = $event,
                error: unref(form).errors["mail.mailers.sendmail.path"] ? unref(form).errors["mail.mailers.sendmail.path"].replace("mail.mailers.", "") : null
              }, null, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              _push2(`<!---->`);
            }
          } else {
            return [
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$6), {
                  label: _ctx.$t("Mail From Name"),
                  modelValue: unref(form).mail.from.name,
                  "onUpdate:modelValue": ($event) => unref(form).mail.from.name = $event,
                  error: unref(form).errors["mail.from.name"] ? unref(form).errors["mail.from.name"].replace("mail.", "") : null
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$6), {
                  type: "email",
                  modelValue: unref(form).mail.from.address,
                  "onUpdate:modelValue": ($event) => unref(form).mail.from.address = $event,
                  label: _ctx.$t("Mail From Email Address"),
                  error: unref(form).errors["mail.from.address"] ? unref(form).errors["mail.from.address"].replace("mail.", "") : null
                }, null, 8, ["modelValue", "onUpdate:modelValue", "label", "error"])
              ]),
              createVNode("div", { class: "col-span-full" }, [
                createVNode(unref(_sfc_main$7), {
                  id: "prefer_biller_email",
                  error: unref(form).errors.prefer_biller_email,
                  checked: unref(form).prefer_biller_email,
                  "onUpdate:checked": ($event) => unref(form).prefer_biller_email = $event,
                  label: _ctx.$t("Please prefer biller name and email")
                }, null, 8, ["error", "checked", "onUpdate:checked", "label"]),
                createVNode("p", { class: "mt-1 text-sm text-yellow-700 dark:text-yellow-500" }, toDisplayString(_ctx.$t("This could result in email failure depending on your mail server and biller email address.")), 1)
              ]),
              createVNode("div", { class: "col-span-full" }, [
                createVNode(unref(_sfc_main$8), {
                  json: true,
                  id: "default",
                  searchable: false,
                  label: _ctx.$t("Mail Driver"),
                  modelValue: unref(form).mail.default,
                  "onUpdate:modelValue": ($event) => unref(form).mail.default = $event,
                  error: unref(form).errors["mail.default"] ? unref(form).errors["mail.default"].replace("mail.", "") : null,
                  suggestions: [
                    { value: "log", label: "Log to File" },
                    { value: "smtp", label: "SMTP" },
                    { value: "sendmail", label: "SendMail" },
                    { value: "ses", label: "AWS SES" },
                    { value: "mailgun", label: "Mailgun" },
                    { value: "postmark", label: "Postmark" },
                    { value: "resend", label: "Resend" }
                    // { value: 'mailersend', label: 'MailerSend' },
                  ]
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              unref(form).mail.default == "smtp" ? (openBlock(), createBlock(Fragment, { key: 0 }, [
                createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                  createVNode(unref(_sfc_main$6), {
                    label: _ctx.$t("SMTP Host"),
                    modelValue: unref(form).mail.mailers.smtp.host,
                    "onUpdate:modelValue": ($event) => unref(form).mail.mailers.smtp.host = $event,
                    error: unref(form).errors["mail.mailers.smtp.host"] ? unref(form).errors["mail.mailers.smtp.host"].replace("mail.mailers.", "") : null
                  }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
                ]),
                createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                  createVNode(unref(_sfc_main$6), {
                    label: _ctx.$t("SMTP Port"),
                    modelValue: unref(form).mail.mailers.smtp.port,
                    "onUpdate:modelValue": ($event) => unref(form).mail.mailers.smtp.port = $event,
                    error: unref(form).errors["mail.mailers.smtp.port"] ? unref(form).errors["mail.mailers.smtp.port"].replace("mail.mailers.", "") : null
                  }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
                ]),
                createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                  createVNode(unref(_sfc_main$6), {
                    label: _ctx.$t("SMTP Username"),
                    modelValue: unref(form).mail.mailers.smtp.username,
                    "onUpdate:modelValue": ($event) => unref(form).mail.mailers.smtp.username = $event,
                    error: unref(form).errors["mail.mailers.smtp.username"] ? unref(form).errors["mail.mailers.smtp.username"].replace("mail.mailers.", "") : null
                  }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
                ]),
                createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                  createVNode(unref(_sfc_main$6), {
                    label: _ctx.$t("SMTP Password"),
                    modelValue: unref(form).mail.mailers.smtp.password,
                    "onUpdate:modelValue": ($event) => unref(form).mail.mailers.smtp.password = $event,
                    error: unref(form).errors["mail.mailers.smtp.password"] ? unref(form).errors["mail.mailers.smtp.password"].replace("mail.mailers.", "") : null
                  }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
                ]),
                createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                  createVNode(unref(_sfc_main$6), {
                    label: _ctx.$t("SMTP Encryption"),
                    modelValue: unref(form).mail.mailers.smtp.encryption,
                    "onUpdate:modelValue": ($event) => unref(form).mail.mailers.smtp.encryption = $event,
                    error: unref(form).errors["mail.mailers.smtp.encryption"] ? unref(form).errors["mail.mailers.smtp.encryption"].replace("mail.mailers.", "") : null
                  }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
                ]),
                createVNode("div", { class: "col-span-6 sm:col-span-3" })
              ], 64)) : unref(form).mail.default == "ses" ? (openBlock(), createBlock(Fragment, { key: 1 }, [
                createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                  createVNode(unref(_sfc_main$6), {
                    label: _ctx.$t("AWS SES Key"),
                    modelValue: unref(form).services.ses.key,
                    "onUpdate:modelValue": ($event) => unref(form).services.ses.key = $event,
                    error: unref(form).errors["services.ses.key"] ? unref(form).errors["services.ses.key"].replace("services.", "") : null
                  }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
                ]),
                createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                  createVNode(unref(_sfc_main$6), {
                    label: _ctx.$t("AWS SES Secret"),
                    modelValue: unref(form).services.ses.secret,
                    "onUpdate:modelValue": ($event) => unref(form).services.ses.secret = $event,
                    error: unref(form).errors["services.ses.secret"] ? unref(form).errors["services.ses.secret"].replace("services.", "") : null
                  }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
                ]),
                createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                  createVNode(unref(_sfc_main$6), {
                    label: _ctx.$t("AWS SES Region"),
                    modelValue: unref(form).services.ses.region,
                    "onUpdate:modelValue": ($event) => unref(form).services.ses.region = $event,
                    error: unref(form).errors["services.ses.region"] ? unref(form).errors["services.ses.region"].replace("services.", "") : null
                  }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
                ]),
                createVNode("div", { class: "col-span-6 sm:col-span-3" })
              ], 64)) : unref(form).mail.default == "mailgun" ? (openBlock(), createBlock(Fragment, { key: 2 }, [
                createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                  createVNode(unref(_sfc_main$6), {
                    label: _ctx.$t("Mailgun Domain"),
                    modelValue: unref(form).services.mailgun.domain,
                    "onUpdate:modelValue": ($event) => unref(form).services.mailgun.domain = $event,
                    error: unref(form).errors["services.mailgun.domain"] ? unref(form).errors["services.mailgun.domain"].replace("services.", "") : null
                  }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
                ]),
                createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                  createVNode(unref(_sfc_main$6), {
                    label: _ctx.$t("Mailgun Secret"),
                    modelValue: unref(form).services.mailgun.secret,
                    "onUpdate:modelValue": ($event) => unref(form).services.mailgun.secret = $event,
                    error: unref(form).errors["services.mailgun.secret"] ? unref(form).errors["services.mailgun.secret"].replace("services.", "") : null
                  }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
                ]),
                createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                  createVNode(unref(_sfc_main$6), {
                    label: _ctx.$t("Mailgun Endpoint"),
                    modelValue: unref(form).services.mailgun.endpoint,
                    "onUpdate:modelValue": ($event) => unref(form).services.mailgun.endpoint = $event,
                    error: unref(form).errors["services.mailgun.endpoint"] ? unref(form).errors["services.mailgun.endpoint"].replace("services.", "") : null
                  }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
                ]),
                createVNode("div", { class: "col-span-6 sm:col-span-3" })
              ], 64)) : unref(form).mail.default == "postmark" ? (openBlock(), createBlock("div", {
                key: 3,
                class: "col-span-full"
              }, [
                createVNode(unref(_sfc_main$6), {
                  label: _ctx.$t("Postmark Token"),
                  modelValue: unref(form).services.postmark.token,
                  "onUpdate:modelValue": ($event) => unref(form).services.postmark.token = $event,
                  error: unref(form).errors["services.postmark.token"] ? unref(form).errors["services.postmark.token"].replace("services.", "") : null
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ])) : unref(form).mail.default == "resend" ? (openBlock(), createBlock("div", {
                key: 4,
                class: "col-span-full"
              }, [
                createVNode(unref(_sfc_main$6), {
                  label: _ctx.$t("Resend Key"),
                  modelValue: unref(form).services.resend.key,
                  "onUpdate:modelValue": ($event) => unref(form).services.resend.key = $event,
                  error: unref(form).errors["services.resend.key"] ? unref(form).errors["services.resend.key"].replace("services.", "") : null
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ])) : unref(form).mail.default == "mailersend" ? (openBlock(), createBlock("div", {
                key: 5,
                class: "col-span-full"
              }, [
                createVNode(unref(_sfc_main$6), {
                  label: _ctx.$t("MailerSend API Key"),
                  modelValue: unref(form)["mailersend-driver"].api_key,
                  "onUpdate:modelValue": ($event) => unref(form)["mailersend-driver"].api_key = $event,
                  error: unref(form).errors["mailersend-driver.api_key"] ? unref(form).errors["mailersend-driver.api_key"] : null
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ])) : unref(form).mail.default == "sendmail" ? (openBlock(), createBlock("div", {
                key: 6,
                class: "col-span-full"
              }, [
                createVNode(unref(_sfc_main$6), {
                  label: _ctx.$t("SendMail Path"),
                  modelValue: unref(form).mail.mailers.sendmail.path,
                  "onUpdate:modelValue": ($event) => unref(form).mail.mailers.sendmail.path = $event,
                  error: unref(form).errors["mail.mailers.sendmail.path"] ? unref(form).errors["mail.mailers.sendmail.path"].replace("mail.mailers.", "") : null
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ])) : createCommentVNode("", true)
            ];
          }
        }),
        actions: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(unref(_sfc_main$4), {
              on: unref(form).recentlySuccessful,
              class: "me-3"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Saved."))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Saved.")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$5), {
              class: { "opacity-25": unref(form).processing },
              loading: unref(form).processing
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Save"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(unref(_sfc_main$4), {
                on: unref(form).recentlySuccessful,
                class: "me-3"
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(_ctx.$t("Saved.")), 1)
                ]),
                _: 1
              }, 8, ["on"]),
              createVNode(unref(_sfc_main$5), {
                class: { "opacity-25": unref(form).processing },
                loading: unref(form).processing
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
                ]),
                _: 1
              }, 8, ["class", "loading"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Setting/Mail.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
