import { ref, onMounted, resolveComponent, withCtx, createTextVNode, toDisplayString, createBlock, openBlock, createVNode, unref, createCommentVNode, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrInterpolate, ssrRenderAttr } from "vue/server-renderer";
import { useI18n } from "vue-i18n";
import "@inertiajs/vue3";
import { _ as _sfc_main$1 } from "./AdminLayout-DHH3IgME.js";
import "./ActionMessage-cgGHxf5V.js";
import { b as _sfc_main$2 } from "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import "./AppLayout-BRHmSgDa.js";
import "notiwind";
import "./http-CDixhmav.js";
import "../ssr.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "lodash.debounce";
import "dayjs";
import "./LoadingButton-DREeyNQW.js";
import "@vuepic/vue-datepicker";
import "lodash.isequal";
import "axios";
import "lodash.throttle";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = /* @__PURE__ */ Object.assign({ layout: _sfc_main$1 }, {
  __name: "MonthlySales",
  __ssrInlineRender: true,
  props: ["data", "html", "current_year", "prev_year_link", "next_year_link"],
  setup(__props) {
    const { t } = useI18n({});
    const year = ref(null);
    const show = ref(false);
    const yearData = ref(null);
    const props = __props;
    year.value = props.current_year;
    onMounted(async () => {
      document.querySelectorAll(".amount").forEach((item) => {
        item.addEventListener("click", (event) => {
          yearData.value = props.data[event.target.dataset.month] || {};
          if (yearData.value.month) {
            show.value = true;
          }
        });
      });
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Head = resolveComponent("Head");
      const _component_Header = resolveComponent("Header");
      const _component_Link = resolveComponent("Link");
      _push(`<div${ssrRenderAttrs(_attrs)}>`);
      _push(ssrRenderComponent(_component_Head, {
        title: _ctx.$t("Monthly Sales")
      }, null, _parent));
      _push(ssrRenderComponent(_component_Header, null, {
        subheading: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Please review the data below"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Please review the data below")), 1)
            ];
          }
        }),
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("{x} Report", { x: _ctx.$t("Monthly Sales") }))} `);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("{x} Report", { x: _ctx.$t("Monthly Sales") })) + " ", 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<div class="relative px-4 sm:px-6 lg:px-8 bg-white dark:bg-gray-800 grow self-stretch flex flex-col items-stretch justify-stretch"><div class="flow-root grow"><div class="-mx-4 -my-2 overflow-x-auto sm:-mx-6 lg:-mx-8"><div class="bg-white dark:bg-gray-900 mt-2 min-w-[640px]"><div class="flex items-center justify-between px-4 pt-4">`);
      _push(ssrRenderComponent(_component_Link, {
        href: __props.prev_year_link,
        class: "block p-2 hover:bg-gray-200 dark:hover:bg-gray-700 rounded"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-5 h-5"${_scopeId}><path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5L8.25 12l7.5-7.5"${_scopeId}></path></svg>`);
          } else {
            return [
              (openBlock(), createBlock("svg", {
                xmlns: "http://www.w3.org/2000/svg",
                fill: "none",
                viewBox: "0 0 24 24",
                "stroke-width": "1.5",
                stroke: "currentColor",
                class: "w-5 h-5"
              }, [
                createVNode("path", {
                  "stroke-linecap": "round",
                  "stroke-linejoin": "round",
                  d: "M15.75 19.5L8.25 12l7.5-7.5"
                })
              ]))
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`<input step="1" id="year" min="1900" max="2099" name="year" type="number"${ssrRenderAttr("value", __props.current_year)} class="appearance-none min-w-20 rounded-md border-0 w-auto max-w-full bg-white dark:bg-gray-900 text-gray-700 dark:text-gray-300 text-lg font-bold py-1 px-2 focus:outline-none focus:ring-1 focus:ring-inset focus:ring-primary-500">`);
      _push(ssrRenderComponent(_component_Link, {
        href: __props.next_year_link,
        class: "block p-2 hover:bg-gray-200 dark:hover:bg-gray-700 rounded"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-5 h-5"${_scopeId}><path stroke-linecap="round" stroke-linejoin="round" d="M8.25 4.5l7.5 7.5-7.5 7.5"${_scopeId}></path></svg>`);
          } else {
            return [
              (openBlock(), createBlock("svg", {
                xmlns: "http://www.w3.org/2000/svg",
                fill: "none",
                viewBox: "0 0 24 24",
                "stroke-width": "1.5",
                stroke: "currentColor",
                class: "w-5 h-5"
              }, [
                createVNode("path", {
                  "stroke-linecap": "round",
                  "stroke-linejoin": "round",
                  d: "M8.25 4.5l7.5 7.5-7.5 7.5"
                })
              ]))
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div>${__props.html ?? ""}</div></div></div></div></div>`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        show: show.value,
        closeable: true,
        onClose: ($event) => show.value = false,
        maxWidth: "sm"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="bg-gray-100 dark:bg-gray-800 rounded-lg"${_scopeId}><div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700 text-lg font-bold capitalize"${_scopeId}>${ssrInterpolate(_ctx.$month(new Date(yearData.value.year, yearData.value.month - 1)))}</div><div class="p-4 py-4 print:px-0"${_scopeId}><div class=""${_scopeId}><table class="w-full divide-y dark:divide-gray-700"${_scopeId}><tbody${_scopeId}><tr${_scopeId}><td class="px-2 py-1.5"${_scopeId}>${ssrInterpolate(unref(t)("Total"))}</td><td class="text-right"${_scopeId}>${ssrInterpolate(_ctx.$number(yearData.value.total))}</td></tr><tr${_scopeId}><td class="px-2 py-1.5"${_scopeId}>${ssrInterpolate(unref(t)("Tax"))}</td><td class="text-right"${_scopeId}>${ssrInterpolate(_ctx.$number(yearData.value.total_tax_amount))}</td></tr><tr class="font-bold"${_scopeId}><td class="px-2 py-1.5"${_scopeId}>${ssrInterpolate(unref(t)("Grand Total"))}</td><td class="text-right"${_scopeId}>${ssrInterpolate(_ctx.$number(yearData.value.grand_total))}</td></tr><tr${_scopeId}><td class="px-2 py-1.5"${_scopeId}>${ssrInterpolate(unref(t)("Received"))}</td><td class="text-right"${_scopeId}>${ssrInterpolate(_ctx.$number(yearData.value.paid))}</td></tr><tr class="font-bold"${_scopeId}><td class="px-2 py-1.5"${_scopeId}>${ssrInterpolate(unref(t)("Balance"))}</td><td class="text-right"${_scopeId}>${ssrInterpolate(_ctx.$number(yearData.value.grand_total - yearData.value.paid))}</td></tr></tbody></table></div></div>`);
            if (_ctx.$super) {
              _push2(`<div class="flex flex-wrap justify-between font-bold border-t border-gray-200 dark:border-gray-700 px-5 py-4"${_scopeId}><div${_scopeId}><div${_scopeId}>${ssrInterpolate(unref(t)("Estimated Profit"))}</div><div class="text-mute text-sm"${_scopeId}>(${ssrInterpolate(unref(t)("after all payments"))})</div></div><div${_scopeId}>${ssrInterpolate(_ctx.$number(Number(yearData.value.grand_total) - Number(yearData.value.cost)))}</div></div>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "bg-gray-100 dark:bg-gray-800 rounded-lg" }, [
                createVNode("div", { class: "px-6 py-4 border-b border-gray-200 dark:border-gray-700 text-lg font-bold capitalize" }, toDisplayString(_ctx.$month(new Date(yearData.value.year, yearData.value.month - 1))), 1),
                createVNode("div", { class: "p-4 py-4 print:px-0" }, [
                  createVNode("div", { class: "" }, [
                    createVNode("table", { class: "w-full divide-y dark:divide-gray-700" }, [
                      createVNode("tbody", null, [
                        createVNode("tr", null, [
                          createVNode("td", { class: "px-2 py-1.5" }, toDisplayString(unref(t)("Total")), 1),
                          createVNode("td", { class: "text-right" }, toDisplayString(_ctx.$number(yearData.value.total)), 1)
                        ]),
                        createVNode("tr", null, [
                          createVNode("td", { class: "px-2 py-1.5" }, toDisplayString(unref(t)("Tax")), 1),
                          createVNode("td", { class: "text-right" }, toDisplayString(_ctx.$number(yearData.value.total_tax_amount)), 1)
                        ]),
                        createVNode("tr", { class: "font-bold" }, [
                          createVNode("td", { class: "px-2 py-1.5" }, toDisplayString(unref(t)("Grand Total")), 1),
                          createVNode("td", { class: "text-right" }, toDisplayString(_ctx.$number(yearData.value.grand_total)), 1)
                        ]),
                        createVNode("tr", null, [
                          createVNode("td", { class: "px-2 py-1.5" }, toDisplayString(unref(t)("Received")), 1),
                          createVNode("td", { class: "text-right" }, toDisplayString(_ctx.$number(yearData.value.paid)), 1)
                        ]),
                        createVNode("tr", { class: "font-bold" }, [
                          createVNode("td", { class: "px-2 py-1.5" }, toDisplayString(unref(t)("Balance")), 1),
                          createVNode("td", { class: "text-right" }, toDisplayString(_ctx.$number(yearData.value.grand_total - yearData.value.paid)), 1)
                        ])
                      ])
                    ])
                  ])
                ]),
                _ctx.$super ? (openBlock(), createBlock("div", {
                  key: 0,
                  class: "flex flex-wrap justify-between font-bold border-t border-gray-200 dark:border-gray-700 px-5 py-4"
                }, [
                  createVNode("div", null, [
                    createVNode("div", null, toDisplayString(unref(t)("Estimated Profit")), 1),
                    createVNode("div", { class: "text-mute text-sm" }, "(" + toDisplayString(unref(t)("after all payments")) + ")", 1)
                  ]),
                  createVNode("div", null, toDisplayString(_ctx.$number(Number(yearData.value.grand_total) - Number(yearData.value.cost))), 1)
                ])) : createCommentVNode("", true)
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div>`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Report/MonthlySales.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
