import { ref, onMounted, resolveComponent, unref, mergeProps, withCtx, createTextVNode, toDisplayString, createVNode, withModifiers, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate } from "vue/server-renderer";
import dayjs from "dayjs";
import { usePage } from "@inertiajs/vue3";
import { h as _sfc_main$2, n as $random } from "./http-CDixhmav.js";
import "../ssr.js";
import "lodash.debounce";
import { _ as _sfc_main$3 } from "./LoadingButton-DREeyNQW.js";
import "./ActionMessage-cgGHxf5V.js";
import { b as _sfc_main$1 } from "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = {
  __name: "OpenOrder",
  __ssrInlineRender: true,
  props: ["show"],
  emits: ["close", "showOpenOrders", "viewRegisterDetails"],
  setup(__props, { emit: __emit }) {
    const page = usePage();
    const emit = __emit;
    const details = ref({});
    const loading = ref(false);
    const reference = ref(null);
    onMounted(() => {
      reference.value = getNewReference();
    });
    function getNewReference() {
      let no = localStorage.getItem("pos_order_number");
      if (!no) {
        no = 1;
        localStorage.setItem("pos_order_number", no);
      }
      return "Order " + dayjs().format("M.D") + "." + (no < 10 ? "00" + no : no < 100 ? "0" + no : no).toString();
    }
    async function openOrderNow() {
      loading.value = true;
      if (reference.value) {
        details.value.tendered = 0;
        details.value.discount = 0;
        details.value.reference = reference.value;
        details.value.user_id = page.props.auth.user.id;
        details.value.customer_id = page.props.settings.default_customer;
        details.value.payments = [{ amount: null, method: "Cash", method_data: {} }];
        details.value.number = dayjs().format("YYMD") + "-" + String($random(0, 9999)).padStart(4, "0");
        let no = localStorage.getItem("pos_order_number");
        localStorage.setItem("pos_order_number", Number(no) + 1);
        emit("close", details.value);
      }
      loading.value = false;
    }
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Link = resolveComponent("Link");
      _push(ssrRenderComponent(unref(_sfc_main$1), mergeProps({
        show: __props.show,
        maxWidth: "sm",
        closeable: true,
        onClose: ($event) => emit("close")
      }, _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="print:hidden"${_scopeId}><div class="border-b border-gray-200 dark:border-gray-700 p-4 sm:px-6"${_scopeId}><h3 class="text-base font-semibold leading-6 text-gray-900 dark:text-gray-100"${_scopeId}>${ssrInterpolate(_ctx.$t("Open New Order"))}</h3><p class="mt-1 text-sm"${_scopeId}>${ssrInterpolate(_ctx.$t("Please type the reference to open form."))}</p></div><div class="p-6 bg-gray-100 dark:bg-gray-800 rounded-b-lg"${_scopeId}><form autocomplete="off" class="flex flex-col gap-4 items-stretch"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$2), {
              modelValue: reference.value,
              "onUpdate:modelValue": ($event) => reference.value = $event,
              id: "order-reference"
            }, null, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$3), {
              class: "justify-center",
              loading: loading.value
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Open"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Open")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</form><div class="mt-6 grid grid-cols-2 gap-2"${_scopeId}><button type="button" class="btn-secondary justify-center"${_scopeId}>${ssrInterpolate(_ctx.$t("Opened Orders"))}</button><button type="button" class="btn-secondary justify-center"${_scopeId}>${ssrInterpolate(_ctx.$t("Register Details"))}</button>`);
            _push2(ssrRenderComponent(_component_Link, {
              href: _ctx.route("dashboard"),
              class: "btn-secondary justify-center"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Dashboard"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Dashboard")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(ssrRenderComponent(_component_Link, {
              href: _ctx.route("sales.index"),
              class: "btn-secondary justify-center"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("List Sales"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("List Sales")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div></div></div>`);
          } else {
            return [
              createVNode("div", { class: "print:hidden" }, [
                createVNode("div", { class: "border-b border-gray-200 dark:border-gray-700 p-4 sm:px-6" }, [
                  createVNode("h3", { class: "text-base font-semibold leading-6 text-gray-900 dark:text-gray-100" }, toDisplayString(_ctx.$t("Open New Order")), 1),
                  createVNode("p", { class: "mt-1 text-sm" }, toDisplayString(_ctx.$t("Please type the reference to open form.")), 1)
                ]),
                createVNode("div", { class: "p-6 bg-gray-100 dark:bg-gray-800 rounded-b-lg" }, [
                  createVNode("form", {
                    onSubmit: withModifiers(openOrderNow, ["prevent"]),
                    autocomplete: "off",
                    class: "flex flex-col gap-4 items-stretch"
                  }, [
                    createVNode(unref(_sfc_main$2), {
                      modelValue: reference.value,
                      "onUpdate:modelValue": ($event) => reference.value = $event,
                      id: "order-reference"
                    }, null, 8, ["modelValue", "onUpdate:modelValue"]),
                    createVNode(unref(_sfc_main$3), {
                      class: "justify-center",
                      loading: loading.value
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(_ctx.$t("Open")), 1)
                      ]),
                      _: 1
                    }, 8, ["loading"])
                  ], 32),
                  createVNode("div", { class: "mt-6 grid grid-cols-2 gap-2" }, [
                    createVNode("button", {
                      type: "button",
                      onClick: ($event) => emit("showOpenOrders"),
                      class: "btn-secondary justify-center"
                    }, toDisplayString(_ctx.$t("Opened Orders")), 9, ["onClick"]),
                    createVNode("button", {
                      type: "button",
                      onClick: ($event) => emit("viewRegisterDetails"),
                      class: "btn-secondary justify-center"
                    }, toDisplayString(_ctx.$t("Register Details")), 9, ["onClick"]),
                    createVNode(_component_Link, {
                      href: _ctx.route("dashboard"),
                      class: "btn-secondary justify-center"
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(_ctx.$t("Dashboard")), 1)
                      ]),
                      _: 1
                    }, 8, ["href"]),
                    createVNode(_component_Link, {
                      href: _ctx.route("sales.index"),
                      class: "btn-secondary justify-center"
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(_ctx.$t("List Sales")), 1)
                      ]),
                      _: 1
                    }, 8, ["href"])
                  ])
                ])
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Pos/Components/OpenOrder.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
