import { ref, resolveComponent, unref, mergeProps, withCtx, createTextVNode, toDisplayString, createBlock, openBlock, createVNode, createCommentVNode, withModifiers, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderClass } from "vue/server-renderer";
import { T } from "../ssr.js";
import { notify } from "notiwind";
import { usePage, router } from "@inertiajs/vue3";
import "./ActionMessage-cgGHxf5V.js";
import { b as _sfc_main$1 } from "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import { h as _sfc_main$2 } from "./http-CDixhmav.js";
import { _ as _sfc_main$3 } from "./LoadingButton-DREeyNQW.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
import "lodash.debounce";
import "dayjs";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "lodash.isequal";
import "axios";
import "lodash.throttle";
const _sfc_main = {
  __name: "OpenRegister",
  __ssrInlineRender: true,
  props: ["show"],
  emits: ["close"],
  setup(__props, { emit: __emit }) {
    const page = usePage();
    const emit = __emit;
    const loading = ref(false);
    const cash_in_hand = ref(0);
    async function openRegisterNow() {
      loading.value = true;
      await router.post(
        T("pos.register"),
        { cash_in_hand: cash_in_hand.value },
        {
          onSuccess: () => {
            emit("close");
          },
          onFinish: () => loading.value = false
        }
      );
    }
    function selectStore() {
      router.visit(T("stores.select", { store: page.props.opened_register.store_id }), {
        method: "post",
        onSuccess: (p) => {
          if (p.props.opened_register && p.props.opened_register.store_id != p.props.selected_store) {
            notify({
              group: "main",
              type: "success",
              title: "Success!",
              text: t("The store has been selected!")
            });
            page.props.select_store = false;
            emit("close");
          }
        }
      });
    }
    return (_ctx, _push, _parent, _attrs) => {
      var _a;
      const _component_Link = resolveComponent("Link");
      _push(ssrRenderComponent(unref(_sfc_main$1), mergeProps({
        show: __props.show,
        maxWidth: "sm",
        closeable: false,
        round: ((_a = _ctx.$page.props.settings) == null ? void 0 : _a.pos_design) == "Modern"
      }, _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          var _a2, _b;
          if (_push2) {
            if (unref(page).props.opened_register) {
              _push2(`<div class="p-6"${_scopeId}><div${_scopeId}><h3 class="text-base font-semibold leading-6 text-gray-900 dark:text-gray-100"${_scopeId}>${ssrInterpolate(_ctx.$t("Register already opened!"))}</h3><p class="mt-1 text-sm"${_scopeId}>${ssrInterpolate(_ctx.$t("You already have opened register at {x}.", { x: unref(page).props.opened_register.store.name }))}</p></div><div class="mt-6 flex justify-between gap-4"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_Link, {
                href: unref(T)("dashboard"),
                class: "link"
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(_ctx.$t("Go to {x}", { x: _ctx.$t("Dashboard") }))}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(_ctx.$t("Go to {x}", { x: _ctx.$t("Dashboard") })), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              if (!unref(page).props.auth.user.store_id && !unref(page).props.order) {
                _push2(`<button type="button" class="link"${_scopeId}>${ssrInterpolate(_ctx.$t("Select {x}", { x: unref(page).props.opened_register.store.name }))}</button>`);
              } else {
                _push2(`<!---->`);
              }
              if (unref(page).props.order) {
                _push2(ssrRenderComponent(_component_Link, {
                  href: unref(T)("orders.index"),
                  class: "link"
                }, {
                  default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                    if (_push3) {
                      _push3(`${ssrInterpolate(_ctx.$t("Go to {x}", { x: _ctx.$t("Orders") }))}`);
                    } else {
                      return [
                        createTextVNode(toDisplayString(_ctx.$t("Go to {x}", { x: _ctx.$t("Orders") })), 1)
                      ];
                    }
                  }),
                  _: 1
                }, _parent2, _scopeId));
              } else {
                _push2(`<!---->`);
              }
              _push2(`</div></div>`);
            } else {
              _push2(`<div${_scopeId}><div class="relative border-b border-gray-200 dark:border-gray-700 p-4 sm:px-6"${_scopeId}><h3 class="text-base font-semibold leading-6 text-gray-900 dark:text-gray-100"${_scopeId}>${ssrInterpolate(_ctx.$t("Open Register"))}</h3><p class="mt-1 text-sm"${_scopeId}>${ssrInterpolate(_ctx.$t("Please type the cash in hand to open register."))}</p></div><div class="${ssrRenderClass([((_a2 = _ctx.$page.props.settings) == null ? void 0 : _a2.pos_design) == "Modern" ? "rounded-b-2xl" : "rounded-b-lg", "p-6 bg-gray-100 dark:bg-gray-800"])}"${_scopeId}><form autocomplete="off" class="flex flex-col gap-4 items-stretch"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$2), {
                placeholder: _ctx.$t("Cash in hand"),
                type: "number",
                step: "1",
                modelValue: cash_in_hand.value,
                "onUpdate:modelValue": ($event) => cash_in_hand.value = $event,
                id: "register-cash-in-hand"
              }, null, _parent2, _scopeId));
              _push2(ssrRenderComponent(unref(_sfc_main$3), {
                class: "justify-center",
                loading: loading.value
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(_ctx.$t("Open"))}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(_ctx.$t("Open")), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_Link, {
                href: unref(T)("dashboard"),
                class: "link"
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(_ctx.$t("Go to {x}", { x: _ctx.$t("Dashboard") }))}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(_ctx.$t("Go to {x}", { x: _ctx.$t("Dashboard") })), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(`</form></div></div>`);
            }
          } else {
            return [
              unref(page).props.opened_register ? (openBlock(), createBlock("div", {
                key: 0,
                class: "p-6"
              }, [
                createVNode("div", null, [
                  createVNode("h3", { class: "text-base font-semibold leading-6 text-gray-900 dark:text-gray-100" }, toDisplayString(_ctx.$t("Register already opened!")), 1),
                  createVNode("p", { class: "mt-1 text-sm" }, toDisplayString(_ctx.$t("You already have opened register at {x}.", { x: unref(page).props.opened_register.store.name })), 1)
                ]),
                createVNode("div", { class: "mt-6 flex justify-between gap-4" }, [
                  createVNode(_component_Link, {
                    href: unref(T)("dashboard"),
                    class: "link"
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(_ctx.$t("Go to {x}", { x: _ctx.$t("Dashboard") })), 1)
                    ]),
                    _: 1
                  }, 8, ["href"]),
                  !unref(page).props.auth.user.store_id && !unref(page).props.order ? (openBlock(), createBlock("button", {
                    key: 0,
                    type: "button",
                    onClick: selectStore,
                    class: "link"
                  }, toDisplayString(_ctx.$t("Select {x}", { x: unref(page).props.opened_register.store.name })), 1)) : createCommentVNode("", true),
                  unref(page).props.order ? (openBlock(), createBlock(_component_Link, {
                    key: 1,
                    href: unref(T)("orders.index"),
                    class: "link"
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(_ctx.$t("Go to {x}", { x: _ctx.$t("Orders") })), 1)
                    ]),
                    _: 1
                  }, 8, ["href"])) : createCommentVNode("", true)
                ])
              ])) : (openBlock(), createBlock("div", { key: 1 }, [
                createVNode("div", { class: "relative border-b border-gray-200 dark:border-gray-700 p-4 sm:px-6" }, [
                  createVNode("h3", { class: "text-base font-semibold leading-6 text-gray-900 dark:text-gray-100" }, toDisplayString(_ctx.$t("Open Register")), 1),
                  createVNode("p", { class: "mt-1 text-sm" }, toDisplayString(_ctx.$t("Please type the cash in hand to open register.")), 1)
                ]),
                createVNode("div", {
                  class: ["p-6 bg-gray-100 dark:bg-gray-800", ((_b = _ctx.$page.props.settings) == null ? void 0 : _b.pos_design) == "Modern" ? "rounded-b-2xl" : "rounded-b-lg"]
                }, [
                  createVNode("form", {
                    onSubmit: withModifiers(openRegisterNow, ["prevent"]),
                    autocomplete: "off",
                    class: "flex flex-col gap-4 items-stretch"
                  }, [
                    createVNode(unref(_sfc_main$2), {
                      placeholder: _ctx.$t("Cash in hand"),
                      type: "number",
                      step: "1",
                      modelValue: cash_in_hand.value,
                      "onUpdate:modelValue": ($event) => cash_in_hand.value = $event,
                      id: "register-cash-in-hand"
                    }, null, 8, ["placeholder", "modelValue", "onUpdate:modelValue"]),
                    createVNode(unref(_sfc_main$3), {
                      class: "justify-center",
                      loading: loading.value
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(_ctx.$t("Open")), 1)
                      ]),
                      _: 1
                    }, 8, ["loading"]),
                    createVNode(_component_Link, {
                      href: unref(T)("dashboard"),
                      class: "link"
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(_ctx.$t("Go to {x}", { x: _ctx.$t("Dashboard") })), 1)
                      ]),
                      _: 1
                    }, 8, ["href"])
                  ], 32)
                ], 2)
              ]))
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Pos/Components/OpenRegister.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
