import { ref, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent } from "vue/server-renderer";
import "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "@inertiajs/vue3";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import { h as _sfc_main$1, y as discount_keypress } from "./http-CDixhmav.js";
import "../ssr.js";
import "lodash.debounce";
import "dayjs";
import { _ as _sfc_main$2 } from "./LoadingButton-DREeyNQW.js";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
import "@vuepic/vue-datepicker";
import "vue-i18n";
import "lodash.isequal";
import "axios";
import "notiwind";
import "lodash.throttle";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
const _sfc_main = {
  __name: "OrderDiscount",
  __ssrInlineRender: true,
  props: ["show"],
  emits: ["close"],
  setup(__props, { emit: __emit }) {
    const discount = ref(null);
    const emit = __emit;
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(_attrs)}><div class="border-b border-gray-200 dark:border-gray-700 p-4 sm:px-6"><h3 class="text-base font-semibold leading-6 text-gray-900 dark:text-gray-100">${ssrInterpolate(_ctx.$t("Order Discount"))}</h3><p class="mt-1 text-sm">${ssrInterpolate(_ctx.$t("Please fill the discount below to apply to form."))}</p></div><div class="flex flex-col gap-6 m-6"><div>`);
      _push(ssrRenderComponent(unref(_sfc_main$1), {
        modelValue: discount.value,
        "onUpdate:modelValue": ($event) => discount.value = $event,
        onKeypress: unref(discount_keypress),
        id: "order-discount",
        label: "Discount (5 or 5%)"
      }, null, _parent));
      _push(`</div><p class="-mt-3">${ssrInterpolate(_ctx.$t("This discount will override any products discount."))}</p>`);
      _push(ssrRenderComponent(unref(_sfc_main$2), {
        class: "justify-center",
        onClick: ($event) => emit("apply", discount.value)
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Apply"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Apply")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Pos/Components/OrderDiscount.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
