import { mergeProps, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrInterpolate } from "vue/server-renderer";
const _sfc_main = {
  __name: "OrderSummary",
  __ssrInlineRender: true,
  props: ["form"],
  emits: ["discount"],
  setup(__props, { emit: __emit }) {
    return (_ctx, _push, _parent, _attrs) => {
      var _a;
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: ["flex flex-col gap-1 print:shadow-none print:border-t", ((_a = _ctx.$page.props.settings) == null ? void 0 : _a.pos_design) == "Modern" ? "" : "px-3 py-2 rounded-md shadow-inner bg-gray-100 dark:bg-gray-800"]
      }, _attrs))}><div class="flex items-center justify-between text-xs">${ssrInterpolate(_ctx.$t("Items"))} <span>${ssrInterpolate(__props.form.items.length)} (${ssrInterpolate(_ctx.$decimal_qty(__props.form.items.reduce((a, i) => Number(i.quantity) + a, 0)))}) </span></div><div class="flex items-center justify-between text-xs">${ssrInterpolate(_ctx.$t("Subtotal"))} <span>${ssrInterpolate(_ctx.$currency(__props.form.items.reduce((a, i) => Number(i.subtotal) + a, 0)))}</span></div><div class="flex items-center justify-between text-xs"><button type="button" class="link">${ssrInterpolate(_ctx.$t("Discount"))}</button><span>${ssrInterpolate(_ctx.$currency(__props.form.items.reduce((a, i) => Number(i.total_discount_amount) + a, 0)))}</span></div><div class="flex items-center justify-between text-xs">${ssrInterpolate(_ctx.$t("Tax"))} <span>${ssrInterpolate(_ctx.$currency(__props.form.items.reduce((a, i) => Number(i.total_tax_amount) + a, 0)))}</span></div><div class="border-t-2 dark:border-gray-500 mt-1 border-dashed print:border-solid"></div><div class="flex items-center justify-between text-sm font-bold">${ssrInterpolate(_ctx.$t("Payable"))} <span class="font-bold text-lg">${ssrInterpolate(_ctx.$currency(__props.form.items.reduce((a, i) => Number(i.total) + a, 0)))}</span></div></div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Pos/Components/OrderSummary.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
