import { resolveComponent, mergeProps, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrRenderList, ssrRenderAttrs } from "vue/server-renderer";
const _sfc_main = {
  __name: "PackingList",
  __ssrInlineRender: true,
  props: ["sale"],
  emits: ["close"],
  setup(__props, { emit: __emit }) {
    return (_ctx, _push, _parent, _attrs) => {
      var _a, _b, _c, _d, _e, _f, _g, _h, _i;
      const _component_Icon = resolveComponent("Icon");
      if (__props.sale) {
        _push(`<!--[--><span class="print:hidden absolute top-4 right-12 sm:right-14 inline-flex items-center gap-x-4"><button type="button" class="link -m-2 p-2">`);
        _push(ssrRenderComponent(_component_Icon, {
          name: "print-o",
          class: "size-5"
        }, null, _parent));
        _push(`</button></span><div class="print:hidden border-b border-gray-200 dark:border-gray-700 px-4 sm:px-6 py-4"><div class="sm:flex sm:items-baseline sm:justify-between"><div class="sm:w-0 sm:flex-1"><h1 class="text-base font-semibold text-focus">${ssrInterpolate(_ctx.$t("Packing List"))} ${ssrInterpolate(_ctx.$t("Sale"))} #${ssrInterpolate((_a = __props.sale) == null ? void 0 : _a.id)} (${ssrInterpolate((_b = __props.sale) == null ? void 0 : _b.reference)}) </h1><p class="mt-1 truncate text-sm text-mute">${ssrInterpolate(_ctx.$t("Please view the details below"))}</p></div></div></div><div class="mt-4 px-6 py-4 print:py-0 print:m-0"><div class="max-h-16 max-w-[250px] mb-1">`);
        if (__props.sale.store.logo) {
          _push(`<img class="max-w-full h-16"${ssrRenderAttr("src", __props.sale.store.logo)}${ssrRenderAttr("alt", __props.sale.store.name)}>`);
        } else {
          _push(`<!--[-->`);
          if ((_c = _ctx.$page.props.settings) == null ? void 0 : _c.logo) {
            _push(`<img class="max-w-full h-16 dark:hidden"${ssrRenderAttr("src", (_d = _ctx.$page.props.settings) == null ? void 0 : _d.logo)}${ssrRenderAttr("alt", (_e = _ctx.$page.props.settings) == null ? void 0 : _e.name)}>`);
          } else {
            _push(`<!---->`);
          }
          if ((_f = _ctx.$page.props.settings) == null ? void 0 : _f.logo_dark) {
            _push(`<img class="max-w-full h-16 hidden dark:block"${ssrRenderAttr("src", (_g = _ctx.$page.props.settings) == null ? void 0 : _g.logo_dark)}${ssrRenderAttr("alt", (_h = _ctx.$page.props.settings) == null ? void 0 : _h.name)}>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<!--]-->`);
        }
        _push(`</div><div class="flex items-start justify-between gap-3 mb-8"><div class="flex flex-col w-3/5"><div class="font-semibold text-lg">${ssrInterpolate(__props.sale.store.name)}</div><div class="text-sm">${ssrInterpolate(_ctx.$address(__props.sale.store))}</div>`);
        if (__props.sale.store.phone) {
          _push(`<div class="text-sm">${ssrInterpolate(_ctx.$t("Phone"))}: ${ssrInterpolate(__props.sale.store.phone)}</div>`);
        } else {
          _push(`<!---->`);
        }
        if (__props.sale.store.email) {
          _push(`<div class="text-sm">${ssrInterpolate(_ctx.$t("Email"))}: ${ssrInterpolate(__props.sale.store.email)}</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="w-2/5"><div class="font-extrabold uppercase text-lg mb-1">${ssrInterpolate(_ctx.$t("Sale"))}</div><div class="text-sm">${ssrInterpolate(_ctx.$t("Sale No. {x}", { x: (_i = __props.sale) == null ? void 0 : _i.id }))}</div><div class="text-sm">${ssrInterpolate(_ctx.$t("Date"))}: ${ssrInterpolate(_ctx.$date(__props.sale.date))}</div><div class="text-sm">${ssrInterpolate(_ctx.$t("Created at"))}: ${ssrInterpolate(_ctx.$datetime(__props.sale.created_at))}</div><div class="text-sm flex gap-1">${ssrInterpolate(_ctx.$t("Reference"))}: <p class="truncate hover:text-clip print:text-clip print:block" dir="rtl">${ssrInterpolate(__props.sale.reference)}</p></div></div></div><div class="overflow-x-auto"><table class="w-full divide-y dark:divide-gray-700 print:divide-gray-400 dark:print:divide-gray-400"><thead><tr><th class="font-bold text-center uppercase p-2 w-7">#</th><th class="font-bold text-left uppercase p-2">${ssrInterpolate(_ctx.$t("Description"))}</th><th class="font-bold text-left uppercase p-2">${ssrInterpolate(_ctx.$t("Rack"))}</th><th class="font-bold text-center uppercase p-2 w-[80px]">${ssrInterpolate(_ctx.$t("Qty"))}</th></tr></thead><!--[-->`);
        ssrRenderList(__props.sale.items, (item, index) => {
          _push(`<!--[-->`);
          if (item.variations && item.variations.length) {
            _push(`<tbody><tr><td class="p-2 w-7 text-right">${ssrInterpolate(index + 1)}</td><td class="p-2">${ssrInterpolate(item.product.name)}</td><td class="p-2"></td><td class="p-2"></td></tr><!--[-->`);
            ssrRenderList(item.variations, (variation) => {
              _push(`<tr><td class="w-7"></td><td class="p-2">${ssrInterpolate(_ctx.$meta(variation.meta))}</td><td class="p-2 font-bold">${ssrInterpolate(variation.pivot.rack_location || item.product.rack_location || "")}</td><td class="p-2 text-right">${ssrInterpolate(_ctx.$number_qty(variation.pivot.quantity))}</td></tr>`);
            });
            _push(`<!--]--></tbody>`);
          } else {
            _push(`<tbody class="divide-y dark:divide-gray-700 border-y border-gray-200 dark:border-gray-700 print:divide-gray-400 dark:print:divide-gray-400"><tr><td class="p-2 w-7 text-right">${ssrInterpolate(index + 1)}</td><td class="p-2">${ssrInterpolate(item.product.name)}</td><td class="p-2 font-bold">${ssrInterpolate(item.product.type == "Service" ? "" : item.product.rack_location || "")}</td><td class="p-2 text-right">${ssrInterpolate(_ctx.$number_qty(item.quantity))}</td></tr></tbody>`);
          }
          _push(`<!--]-->`);
        });
        _push(`<!--]--><tfoot class="divide-y dark:divide-gray-700"><tr><th colspan="3" class="p-2 font-bold text-right text-lg">${ssrInterpolate(_ctx.$t("Total Items"))}</th><th class="p-2 font-bold text-right text-lg">${ssrInterpolate(_ctx.$decimal_qty(__props.sale.items.reduce((a, i) => Number(i.quantity) + a, 0)))}</th></tr></tfoot></table></div></div><!--]-->`);
      } else {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex items-center justify-center p-6 min-h-64 text-lg font-thin" }, _attrs))}>${ssrInterpolate(_ctx.$t("No data found, the record might not belong to the selected store."))}</div>`);
      }
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Order/Sale/PackingList.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
