import { T } from "../ssr.js";
import debounce from "lodash.debounce";
import { ref, onMounted, watch } from "vue";
import { usePage, useForm, router } from "@inertiajs/vue3";
const PageSearch = () => {
  const page = usePage();
  const search = useForm({});
  const filters = ref({});
  const searching = ref(false);
  onMounted(() => {
    const queryString = window.location.search;
    const urlParams = new URLSearchParams(queryString);
    filters.value = urlParams.has("filters") ? urlParams.get("filters") : page.props.filters;
  });
  watch(
    () => page.props.filters.search,
    debounce((search2) => {
      filters.value.search = search2;
      searchNow();
    }, 500)
  );
  const searchNow = () => {
    let form = Object.entries(filters.value).reduce((a, [k, v]) => v ? (a[k] = v, a) : a, {});
    router.visit(T(T().current(), Object.keys(form).length ? { filters: form } : ""), {
      //   only: ['pagination'],
      replace: true,
      preserveScroll: true,
      onStart: () => searching.value = true,
      onFinish: () => searching.value = false
    });
  };
  const sortBy = (sort) => {
    filters.value.sort = sort;
    searchNow();
  };
  const resetSearch = () => {
    search.reset();
    filters.value = { search: "", sort: "latest" };
    searchNow();
  };
  return { filters, resetSearch, search, searching, searchNow, sortBy };
};
export {
  PageSearch as P
};
