import { ref, resolveComponent, withCtx, createVNode, toDisplayString, unref, createTextVNode, createBlock, createCommentVNode, openBlock, Fragment, useSSRContext } from "vue";
import { ssrRenderComponent, ssrInterpolate } from "vue/server-renderer";
import { T } from "../ssr.js";
import { useI18n } from "vue-i18n";
import { usePage, useForm } from "@inertiajs/vue3";
import { _ as _sfc_main$1 } from "./AdminLayout-DHH3IgME.js";
import { _ as _sfc_main$4 } from "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import { _ as _sfc_main$3 } from "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import { E as _sfc_main$2, h as _sfc_main$6, b as _sfc_main$7, v as _sfc_main$8 } from "./http-CDixhmav.js";
import { _ as _sfc_main$5 } from "./LoadingButton-DREeyNQW.js";
import "@inertiajs/vue3/server";
import "@vue/server-renderer";
import "./AppLayout-BRHmSgDa.js";
import "notiwind";
import "lodash.debounce";
import "dayjs";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
import "@vuepic/vue-datepicker";
import "lodash.isequal";
import "axios";
import "lodash.throttle";
const _sfc_main = /* @__PURE__ */ Object.assign({ layout: _sfc_main$1 }, {
  __name: "Payment",
  __ssrInlineRender: true,
  props: { current: Object },
  setup(__props) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _A, _B, _C, _D, _E, _F, _G, _H, _I, _J, _K, _L, _M, _N, _O, _P, _Q, _R, _S, _T, _U, _V;
    usePage();
    const { t } = useI18n({});
    const props = __props;
    const tab_links = ref([
      { label: t("General Settings"), route: "settings.index", icon: "settings" },
      { label: t("Mail Settings"), route: "settings.mail", icon: "envelope" },
      { label: t("Payment Settings"), route: "settings.payment", icon: "dollar" },
      { label: t("Scale Barcode Settings"), route: "settings.barcode", icon: "scale" }
    ]);
    if (T().has("settings.pos")) {
      tab_links.value.push({ label: t("POS Settings"), route: "settings.pos", icon: "pos" });
    }
    const form = useForm({
      gateway: ((_a = props.current) == null ? void 0 : _a.gateway) || null,
      default_currency: ((_b = props.current) == null ? void 0 : _b.default_currency) || "USD",
      stripe_terminal: ((_c = props.current) == null ? void 0 : _c.stripe_terminal) == 1 || false,
      services: {
        paypal: {
          enabled: ((_f = (_e = (_d = props.current) == null ? void 0 : _d.services) == null ? void 0 : _e.paypal) == null ? void 0 : _f.enabled) || false,
          client_id: ((_i = (_h = (_g = props.current) == null ? void 0 : _g.services) == null ? void 0 : _h.paypal) == null ? void 0 : _i.client_id) || null,
          secret: ((_l = (_k = (_j = props.current) == null ? void 0 : _j.services) == null ? void 0 : _k.paypal) == null ? void 0 : _l.secret) || null,
          fixed: ((_o = (_n = (_m = props.current) == null ? void 0 : _m.services) == null ? void 0 : _n.paypal) == null ? void 0 : _o.fixed) || null,
          same_country: ((_r = (_q = (_p = props.current) == null ? void 0 : _p.services) == null ? void 0 : _q.paypal) == null ? void 0 : _r.same_country) || null,
          other_countries: ((_u = (_t = (_s = props.current) == null ? void 0 : _s.services) == null ? void 0 : _t.paypal) == null ? void 0 : _u.other_countries) || null
        },
        stripe: {
          key: ((_x = (_w = (_v = props.current) == null ? void 0 : _v.services) == null ? void 0 : _w.stripe) == null ? void 0 : _x.key) || null,
          secret: ((_A = (_z = (_y = props.current) == null ? void 0 : _y.services) == null ? void 0 : _z.stripe) == null ? void 0 : _A.secret) || null,
          fixed: ((_D = (_C = (_B = props.current) == null ? void 0 : _B.services) == null ? void 0 : _C.stripe) == null ? void 0 : _D.fixed) || null,
          same_country: ((_G = (_F = (_E = props.current) == null ? void 0 : _E.services) == null ? void 0 : _F.stripe) == null ? void 0 : _G.same_country) || null,
          other_countries: ((_J = (_I = (_H = props.current) == null ? void 0 : _H.services) == null ? void 0 : _I.stripe) == null ? void 0 : _J.other_countries) || null
        },
        paymes: {
          public_key: ((_M = (_L = (_K = props.current) == null ? void 0 : _K.services) == null ? void 0 : _L.paymes) == null ? void 0 : _M.public_key) || null,
          secret_key: ((_P = (_O = (_N = props.current) == null ? void 0 : _N.services) == null ? void 0 : _O.paymes) == null ? void 0 : _P.secret_key) || null
        },
        authorize: {
          login: ((_S = (_R = (_Q = props.current) == null ? void 0 : _Q.services) == null ? void 0 : _R.authorize) == null ? void 0 : _S.login) || null,
          transaction_key: ((_V = (_U = (_T = props.current) == null ? void 0 : _T.services) == null ? void 0 : _U.authorize) == null ? void 0 : _V.transaction_key) || null
        }
      }
    });
    function save() {
      form.post(T("settings.payment.store"));
    }
    return (_ctx, _push, _parent, _attrs) => {
      const _component_Head = resolveComponent("Head");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_Head, null, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<title${_scopeId}>${ssrInterpolate(_ctx.$t("Payment Settings"))}</title>`);
          } else {
            return [
              createVNode("title", null, toDisplayString(_ctx.$t("Payment Settings")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(unref(_sfc_main$2), { links: tab_links.value }, null, _parent));
      _push(`<div class="pt-6 pb-0 sm:py-8 px-0 sm:px-6 lg:px-8">`);
      _push(ssrRenderComponent(unref(_sfc_main$3), { onSubmitted: save }, {
        title: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Payment Settings"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Payment Settings")), 1)
            ];
          }
        }),
        description: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("Please configure the payment settings."))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("Please configure the payment settings.")), 1)
            ];
          }
        }),
        form: withCtx((_, _push2, _parent2, _scopeId) => {
          var _a2, _b2, _c2, _d2;
          if (_push2) {
            _push2(`<div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$6), {
              modelValue: unref(form).default_currency,
              "onUpdate:modelValue": ($event) => unref(form).default_currency = $event,
              error: unref(form).errors.default_currency,
              label: _ctx.$t("Default Currency")
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-6 sm:col-span-3"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$7), {
              json: true,
              id: "gateway",
              searchable: false,
              label: _ctx.$t("Credit Card Gateway"),
              modelValue: unref(form).gateway,
              "onUpdate:modelValue": ($event) => unref(form).gateway = $event,
              error: unref(form).errors.gateway,
              suggestions: [
                { value: "Authorize.net", label: "Authorize.net" },
                { value: "Paymes", label: "Paymes" },
                // { value: 'PayPal Pro', label: 'PayPal Pro' },
                { value: "PayPal Rest", label: "PayPal Rest" },
                { value: "Stripe", label: "Stripe" }
              ]
            }, null, _parent2, _scopeId));
            _push2(`</div>`);
            if (unref(form).gateway == "Paymes") {
              _push2(`<!--[--><div class="col-span-full"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                label: _ctx.$t("Paymes Public Key"),
                modelValue: unref(form).services.paymes.public_key,
                "onUpdate:modelValue": ($event) => unref(form).services.paymes.public_key = $event,
                error: unref(form).errors["services.paymes.public_key"] ? unref(form).errors["services.paymes.public_key"].replace("services.", "") : null
              }, null, _parent2, _scopeId));
              _push2(`</div><div class="col-span-full"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                label: _ctx.$t("Paymes Secret Key"),
                modelValue: unref(form).services.paymes.secret_key,
                "onUpdate:modelValue": ($event) => unref(form).services.paymes.secret_key = $event,
                error: unref(form).errors["services.paymes.secret_key"] ? unref(form).errors["services.paymes.secret_key"].replace("services.", "") : null
              }, null, _parent2, _scopeId));
              _push2(`</div><!--]-->`);
            } else {
              _push2(`<!---->`);
            }
            if (unref(form).gateway == "Authorize.net") {
              _push2(`<!--[--><div class="col-span-full"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                label: _ctx.$t("Authorize.net Login"),
                modelValue: unref(form).services.authorize.login,
                "onUpdate:modelValue": ($event) => unref(form).services.authorize.login = $event,
                error: unref(form).errors["services.authorize.login"] ? unref(form).errors["services.authorize.login"].replace("services.", "") : null
              }, null, _parent2, _scopeId));
              _push2(`</div><div class="col-span-full"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                label: _ctx.$t("Authorize.net Transaction Key"),
                modelValue: unref(form).services.authorize.transaction_key,
                "onUpdate:modelValue": ($event) => unref(form).services.authorize.transaction_key = $event,
                error: unref(form).errors["services.authorize.transaction_key"] ? unref(form).errors["services.authorize.transaction_key"].replace("services.", "") : null
              }, null, _parent2, _scopeId));
              _push2(`</div><!--]-->`);
            } else {
              _push2(`<!---->`);
            }
            if (unref(form).services.paypal.enabled || unref(form).gateway == "PayPal Rest") {
              _push2(`<!--[--><div class="col-span-full"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                label: _ctx.$t("PayPal Client Id"),
                modelValue: unref(form).services.paypal.client_id,
                "onUpdate:modelValue": ($event) => unref(form).services.paypal.client_id = $event,
                error: unref(form).errors["services.paypal.client_id"] ? unref(form).errors["services.paypal.client_id"].replace("services.", "") : null
              }, null, _parent2, _scopeId));
              _push2(`</div><div class="col-span-full"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                label: _ctx.$t("PayPal Secret"),
                modelValue: unref(form).services.paypal.secret,
                "onUpdate:modelValue": ($event) => unref(form).services.paypal.secret = $event,
                error: unref(form).errors["services.paypal.secret"] ? unref(form).errors["services.paypal.secret"].replace("services.", "") : null
              }, null, _parent2, _scopeId));
              _push2(`</div><!--]-->`);
            } else {
              _push2(`<!---->`);
            }
            if (unref(form).stripe_terminal || unref(form).gateway == "Stripe") {
              _push2(`<!--[--><div class="col-span-full"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                label: _ctx.$t("Stripe Publishable Key"),
                modelValue: unref(form).services.stripe.key,
                "onUpdate:modelValue": ($event) => unref(form).services.stripe.key = $event,
                error: unref(form).errors["services.stripe.key"] ? unref(form).errors["services.stripe.key"].replace("services.", "") : null
              }, null, _parent2, _scopeId));
              _push2(`</div><div class="col-span-full"${_scopeId}>`);
              _push2(ssrRenderComponent(unref(_sfc_main$6), {
                label: _ctx.$t("Stripe Secret Key"),
                modelValue: unref(form).services.stripe.secret,
                "onUpdate:modelValue": ($event) => unref(form).services.stripe.secret = $event,
                error: unref(form).errors["services.stripe.secret"] ? unref(form).errors["services.stripe.secret"].replace("services.", "") : null
              }, null, _parent2, _scopeId));
              _push2(`</div><!--]-->`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<div class="col-span-full"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$8), {
              id: "paypal-enabled",
              label: _ctx.$t("Enable PayPal Payments"),
              checked: unref(form).services.paypal.enabled,
              "onUpdate:checked": ($event) => unref(form).services.paypal.enabled = $event,
              error: (_b2 = (_a2 = unref(form).errors.services) == null ? void 0 : _a2.paypal) == null ? void 0 : _b2.enabled
            }, null, _parent2, _scopeId));
            _push2(`</div><div class="col-span-full"${_scopeId}>`);
            _push2(ssrRenderComponent(unref(_sfc_main$8), {
              id: "stripe-terminal",
              label: _ctx.$t("Enable Stripe Terminal"),
              checked: unref(form).stripe_terminal,
              "onUpdate:checked": ($event) => unref(form).stripe_terminal = $event,
              error: unref(form).errors.stripe_terminal
            }, null, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$6), {
                  modelValue: unref(form).default_currency,
                  "onUpdate:modelValue": ($event) => unref(form).default_currency = $event,
                  error: unref(form).errors.default_currency,
                  label: _ctx.$t("Default Currency")
                }, null, 8, ["modelValue", "onUpdate:modelValue", "error", "label"])
              ]),
              createVNode("div", { class: "col-span-6 sm:col-span-3" }, [
                createVNode(unref(_sfc_main$7), {
                  json: true,
                  id: "gateway",
                  searchable: false,
                  label: _ctx.$t("Credit Card Gateway"),
                  modelValue: unref(form).gateway,
                  "onUpdate:modelValue": ($event) => unref(form).gateway = $event,
                  error: unref(form).errors.gateway,
                  suggestions: [
                    { value: "Authorize.net", label: "Authorize.net" },
                    { value: "Paymes", label: "Paymes" },
                    // { value: 'PayPal Pro', label: 'PayPal Pro' },
                    { value: "PayPal Rest", label: "PayPal Rest" },
                    { value: "Stripe", label: "Stripe" }
                  ]
                }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
              ]),
              unref(form).gateway == "Paymes" ? (openBlock(), createBlock(Fragment, { key: 0 }, [
                createVNode("div", { class: "col-span-full" }, [
                  createVNode(unref(_sfc_main$6), {
                    label: _ctx.$t("Paymes Public Key"),
                    modelValue: unref(form).services.paymes.public_key,
                    "onUpdate:modelValue": ($event) => unref(form).services.paymes.public_key = $event,
                    error: unref(form).errors["services.paymes.public_key"] ? unref(form).errors["services.paymes.public_key"].replace("services.", "") : null
                  }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
                ]),
                createVNode("div", { class: "col-span-full" }, [
                  createVNode(unref(_sfc_main$6), {
                    label: _ctx.$t("Paymes Secret Key"),
                    modelValue: unref(form).services.paymes.secret_key,
                    "onUpdate:modelValue": ($event) => unref(form).services.paymes.secret_key = $event,
                    error: unref(form).errors["services.paymes.secret_key"] ? unref(form).errors["services.paymes.secret_key"].replace("services.", "") : null
                  }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
                ])
              ], 64)) : createCommentVNode("", true),
              unref(form).gateway == "Authorize.net" ? (openBlock(), createBlock(Fragment, { key: 1 }, [
                createVNode("div", { class: "col-span-full" }, [
                  createVNode(unref(_sfc_main$6), {
                    label: _ctx.$t("Authorize.net Login"),
                    modelValue: unref(form).services.authorize.login,
                    "onUpdate:modelValue": ($event) => unref(form).services.authorize.login = $event,
                    error: unref(form).errors["services.authorize.login"] ? unref(form).errors["services.authorize.login"].replace("services.", "") : null
                  }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
                ]),
                createVNode("div", { class: "col-span-full" }, [
                  createVNode(unref(_sfc_main$6), {
                    label: _ctx.$t("Authorize.net Transaction Key"),
                    modelValue: unref(form).services.authorize.transaction_key,
                    "onUpdate:modelValue": ($event) => unref(form).services.authorize.transaction_key = $event,
                    error: unref(form).errors["services.authorize.transaction_key"] ? unref(form).errors["services.authorize.transaction_key"].replace("services.", "") : null
                  }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
                ])
              ], 64)) : createCommentVNode("", true),
              unref(form).services.paypal.enabled || unref(form).gateway == "PayPal Rest" ? (openBlock(), createBlock(Fragment, { key: 2 }, [
                createVNode("div", { class: "col-span-full" }, [
                  createVNode(unref(_sfc_main$6), {
                    label: _ctx.$t("PayPal Client Id"),
                    modelValue: unref(form).services.paypal.client_id,
                    "onUpdate:modelValue": ($event) => unref(form).services.paypal.client_id = $event,
                    error: unref(form).errors["services.paypal.client_id"] ? unref(form).errors["services.paypal.client_id"].replace("services.", "") : null
                  }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
                ]),
                createVNode("div", { class: "col-span-full" }, [
                  createVNode(unref(_sfc_main$6), {
                    label: _ctx.$t("PayPal Secret"),
                    modelValue: unref(form).services.paypal.secret,
                    "onUpdate:modelValue": ($event) => unref(form).services.paypal.secret = $event,
                    error: unref(form).errors["services.paypal.secret"] ? unref(form).errors["services.paypal.secret"].replace("services.", "") : null
                  }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
                ])
              ], 64)) : createCommentVNode("", true),
              unref(form).stripe_terminal || unref(form).gateway == "Stripe" ? (openBlock(), createBlock(Fragment, { key: 3 }, [
                createVNode("div", { class: "col-span-full" }, [
                  createVNode(unref(_sfc_main$6), {
                    label: _ctx.$t("Stripe Publishable Key"),
                    modelValue: unref(form).services.stripe.key,
                    "onUpdate:modelValue": ($event) => unref(form).services.stripe.key = $event,
                    error: unref(form).errors["services.stripe.key"] ? unref(form).errors["services.stripe.key"].replace("services.", "") : null
                  }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
                ]),
                createVNode("div", { class: "col-span-full" }, [
                  createVNode(unref(_sfc_main$6), {
                    label: _ctx.$t("Stripe Secret Key"),
                    modelValue: unref(form).services.stripe.secret,
                    "onUpdate:modelValue": ($event) => unref(form).services.stripe.secret = $event,
                    error: unref(form).errors["services.stripe.secret"] ? unref(form).errors["services.stripe.secret"].replace("services.", "") : null
                  }, null, 8, ["label", "modelValue", "onUpdate:modelValue", "error"])
                ])
              ], 64)) : createCommentVNode("", true),
              createVNode("div", { class: "col-span-full" }, [
                createVNode(unref(_sfc_main$8), {
                  id: "paypal-enabled",
                  label: _ctx.$t("Enable PayPal Payments"),
                  checked: unref(form).services.paypal.enabled,
                  "onUpdate:checked": ($event) => unref(form).services.paypal.enabled = $event,
                  error: (_d2 = (_c2 = unref(form).errors.services) == null ? void 0 : _c2.paypal) == null ? void 0 : _d2.enabled
                }, null, 8, ["label", "checked", "onUpdate:checked", "error"])
              ]),
              createVNode("div", { class: "col-span-full" }, [
                createVNode(unref(_sfc_main$8), {
                  id: "stripe-terminal",
                  label: _ctx.$t("Enable Stripe Terminal"),
                  checked: unref(form).stripe_terminal,
                  "onUpdate:checked": ($event) => unref(form).stripe_terminal = $event,
                  error: unref(form).errors.stripe_terminal
                }, null, 8, ["label", "checked", "onUpdate:checked", "error"])
              ])
            ];
          }
        }),
        actions: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(unref(_sfc_main$4), {
              on: unref(form).recentlySuccessful,
              class: "me-3"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Saved."))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Saved.")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(ssrRenderComponent(unref(_sfc_main$5), {
              class: { "opacity-25": unref(form).processing },
              loading: unref(form).processing
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("Save"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(unref(_sfc_main$4), {
                on: unref(form).recentlySuccessful,
                class: "me-3"
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(_ctx.$t("Saved.")), 1)
                ]),
                _: 1
              }, 8, ["on"]),
              createVNode(unref(_sfc_main$5), {
                class: { "opacity-25": unref(form).processing },
                loading: unref(form).processing
              }, {
                default: withCtx(() => [
                  createTextVNode(toDisplayString(_ctx.$t("Save")), 1)
                ]),
                _: 1
              }, 8, ["class", "loading"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><!--]-->`);
    };
  }
});
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Setting/Payment.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
