import dayjs from "dayjs";
import "ulid";
import { T } from "../ssr.js";
import { s as searchItems } from "./search-h0wKx9lE.js";
import { f as $extras, D as useClickOutside, n as $random, a as axios, w as calculate_item, z as check_promotions } from "./http-CDixhmav.js";
import "lodash.debounce";
import { ref, watch, onMounted, nextTick, onBeforeUnmount } from "vue";
import { usePage, useForm } from "@inertiajs/vue3";
import { V as VariationSelection, F as FormHelper } from "./VariationSelection-kl6n6FuS.js";
import { notify } from "notiwind";
import { useI18n } from "vue-i18n";
import debounce from "lodash/debounce.js";
import _sfc_main$f from "./Form-D8PGJU9a.js";
import _sfc_main$e from "./View-CVQ8Ytyo.js";
import _sfc_main$d from "./FormItem-DBCP8LnQ.js";
import _sfc_main$c from "./OpenOrder-Cjnx2lb5.js";
import _sfc_main$b from "./PrintBill-Djpc2mSI.js";
import _sfc_main$a from "./PrintOrder-BMjjb3g2.js";
import _sfc_main$9 from "./ShowOrders-Dr8JTqPS.js";
import _sfc_main$8 from "./AddGiftCard-DxPs7W3X.js";
import _sfc_main$7 from "./FormActions-BktKGYje.js";
import _sfc_main$6 from "./FinalizeSale-Cwjg4qiT.js";
import _sfc_main$5 from "./OpenRegister-CjTG8z1b.js";
import _sfc_main$4 from "./OrderSummary-B6dWEyEN.js";
import _sfc_main$3 from "./PrintReceipt-BJEx3z3f.js";
import _sfc_main$2 from "./OrderDiscount-CJED5TjQ.js";
import _sfc_main$1 from "./UpdateFormItem-Drx9dwJa.js";
import _sfc_main from "./RegisterDetails-CioZFg03.js";
const PosHelper = (props) => {
  var _a;
  const page = usePage();
  const { t } = useI18n({});
  const grid = ref([]);
  const cId = ref(null);
  const search = ref("");
  const result = ref([]);
  const errors = ref({});
  const receipt = ref(null);
  const loading = ref(false);
  const customer = ref(null);
  const finalize = ref(false);
  const itemsHeight = ref(200);
  const showOrder = ref(false);
  const orderItems = ref(null);
  const printBill = ref(false);
  const printOrder = ref(false);
  const showOrders = ref(false);
  const loadingPage = ref(false);
  const orderActions = ref(null);
  const orderDetails = ref(null);
  const orderSummary = ref(null);
  const showReceipt = ref(false);
  const delete_order = ref(false);
  const giftCardModal = ref(null);
  const orderCustomer = ref(null);
  const showCustomer = ref(false);
  const closeRegister = ref(false);
  const loadingOrders = ref(false);
  const menusContainer = ref(null);
  const open_register = ref(false);
  const orderContainer = ref(null);
  const showOrderItem = ref(false);
  const view_register = ref(false);
  const order_discount = ref(false);
  const showMobileMenu = ref(false);
  const closingRegister = ref(false);
  ref(false);
  const loadingRegister = ref(false);
  const addCustomerModal = ref(false);
  const mobileMenuContainer = ref(null);
  const form = useForm({
    _method: "post",
    calculate_on: "price",
    items: [],
    date: dayjs().format("YYYY-MM-DD"),
    customer_id: ((_a = props.customer) == null ? void 0 : _a.id) || page.props.settings.default_customer,
    details: null,
    due_date: null,
    reference: null,
    attachments: null,
    extra_attributes: $extras(props.custom_fields)
  });
  const { currentItem, deleteVariation, emptyVariation, variantModal, SelectVariant } = VariationSelection();
  const { openItemModal, selectItem, selectedItem, removeItem, resetForm, saveForm, updateItem } = FormHelper(form);
  watch(search, debounce(searchProducts, 500));
  watch(
    () => props.customer,
    (customer2) => {
      if (customer2) {
        form.customer = customer2;
        form.customer_id = customer2.id;
        saveForm();
      }
    }
  );
  watch(
    () => props.sale,
    (sale) => {
      if (sale) {
        resetForm();
        form.reference = "f";
        receipt.value = sale;
        showReceipt.value = true;
      }
    }
  );
  useClickOutside(orderContainer, () => showOrder.value = false, menusContainer);
  useClickOutside(mobileMenuContainer, () => showMobileMenu.value = false, menusContainer);
  onMounted(async () => {
    var _a2, _b, _c, _d;
    let pond = localStorage.getItem("pos_order_number_date");
    if (!dayjs().isSame(pond, "day")) {
      localStorage.setItem("pos_order_number", 1);
      localStorage.setItem("pos_order_number_date", dayjs().format("YYYY-MM-DD"));
    }
    if (page.props.open_register) {
      open_register.value = true;
      await nextTick();
      setTimeout(() => {
        document.getElementById("register-cash-in-hand").focus();
        document.getElementById("register-cash-in-hand").select();
      }, 500);
    }
    if (page.props.opened_register && page.props.opened_register.store_id != page.props.selected_store) {
      notify(
        {
          group: "main",
          type: "error",
          title: "Error!",
          text: t("You have already opened register at another store.!")
        },
        1e4
      );
      open_register.value = true;
    }
    grid.value = [...props.products];
    cId.value = (_a2 = page.props.settings) == null ? void 0 : _a2.default_category;
    window.addEventListener("resize", orderItemsHeight);
    await nextTick();
    orderItemsHeight();
    (_b = document.getElementById("product-search")) == null ? void 0 : _b.focus();
    let saved_order = localStorage.getItem("pos.form");
    if (saved_order) {
      let order = JSON.parse(saved_order);
      if (!order.store_id || order.store_id == page.props.selected_store) {
        Object.keys(order).forEach((k) => form[k] = order[k]);
      }
    }
    if (props.customer) {
      form.customer = props.customer;
      form.customer_id = props.customer.id;
      saveForm();
    }
    if (!form.number) {
      form.customer_id = page.props.settings.default_customer;
      form.number = dayjs().format("YYMD") + "-" + String($random(0, 9999)).padStart(4, "0");
      saveForm();
    }
    setTimeout(() => orderItems.value.scrollTop = orderItems.value.scrollHeight, 250);
    if (!form.reference || form.reference == "f") {
      await nextTick();
      (_c = document.getElementById("order-reference")) == null ? void 0 : _c.focus();
      (_d = document.getElementById("order-reference")) == null ? void 0 : _d.select();
    }
    if (props.sale) {
      form.reference = "f";
      receipt.value = props.sale;
      showReceipt.value = true;
    }
    if (props.order) {
      loadOrder(props.order);
    }
  });
  onBeforeUnmount(() => {
    window.removeEventListener("resize", orderItemsHeight);
    if (form.reference && form.reference != "f" && form.number) {
      holdOrder();
      saveForm();
    }
  });
  function openOrder(details) {
    if (details && details.reference) {
      Object.keys(details).map((k) => form[k] = details[k]);
      saveForm();
    } else {
      form.reset();
      form.number = null;
      form.reference = "f";
    }
    orderItemsHeight();
  }
  function playErrorSound() {
    const audio = new Audio("/sounds/error.mp3");
    audio.play();
  }
  function playSuccessSound() {
    const audio = new Audio("/sounds/success.mp3");
    audio.play();
  }
  function orderItemsHeight() {
    var _a2, _b, _c, _d, _e;
    if (form.reference && form.reference != "f" && form.number) {
      itemsHeight.value = (((_a2 = orderContainer.value) == null ? void 0 : _a2.clientHeight) || 0) - ((((_b = orderDetails.value) == null ? void 0 : _b.clientHeight) || 0) + (((_c = orderCustomer.value) == null ? void 0 : _c.clientHeight) || 0) + (((_d = orderSummary.value) == null ? void 0 : _d.clientHeight) || 0) + (((_e = orderActions.value) == null ? void 0 : _e.clientHeight) || 0)) + 8;
      orderItems.value.scrollTop = orderItems.value.scrollHeight;
    }
  }
  async function holdOrder(e, dont_hide = false) {
    var _a2;
    if (page.props.opened_register && form.reference && form.reference != "f" && form.number && ((_a2 = form.items) == null ? void 0 : _a2.length)) {
      loadingPage.value = true;
      form.total_items = form.items.length;
      form.total = form.items.reduce((a, i) => Number(i.total) + a, 0);
      form.total_quantity = form.items.reduce((a, i) => Number(i.quantity) + a, 0);
      await axios.post(T("pos.orders.store"), form).then((res) => {
        var _a3, _b;
        if (dont_hide) {
          loadingPage.value = false;
          return;
        }
        form.reset();
        form.items = [];
        form.reference = "";
        form.customer_id = page.props.settings.default_customer;
        form.number = dayjs().format("YYMD") + "-" + String(randomNumber(0, 9999)).padStart(4, "0");
        saveForm();
        loadingPage.value = false;
        (_a3 = document.getElementById("order-reference")) == null ? void 0 : _a3.focus();
        (_b = document.getElementById("order-reference")) == null ? void 0 : _b.select();
        notify({
          group: "main",
          type: "success",
          title: "Success!",
          text: t("The order has been saved!")
        });
      }).catch(() => {
        loadingPage.value = false;
      });
    }
  }
  async function showPaymentModal() {
    let hasItem = form.items && form.items.length;
    if (hasItem) {
      saveForm();
      holdOrder({}, true);
    }
    finalize.value = true;
    if (hasItem) {
      await nextTick();
      if (document.getElementById("tender-amount")) {
        document.getElementById("tender-amount").focus();
        document.getElementById("tender-amount").select();
      }
    }
  }
  function print() {
    window.print();
  }
  async function loadOrder(selected) {
    if (form && form.reference && form.number && form.items && form.items.length) {
      await holdOrder();
    }
    showOrders.value = false;
    loadingPage.value = true;
    if (!selected.store_id || selected.store_id == page.props.selected_store) {
      Object.keys(selected.data).map((k) => form[k] = selected.data[k]);
      form.store_id = selected.store_id;
      form.order_id = selected.id;
      saveForm();
    } else {
      form.reset();
      form.number = null;
      form.reference = "f";
      open_register.value = true;
    }
    loadingPage.value = false;
    await nextTick();
    orderItemsHeight();
  }
  async function showOrderDiscount() {
    var _a2;
    order_discount.value = true;
    await nextTick();
    (_a2 = document.getElementById("order-discount")) == null ? void 0 : _a2.focus();
  }
  async function applyOrderDiscount(discount) {
    if (!discount.includes("%")) {
      discount += "%";
    }
    form.items = form.items.map((p) => {
      var _a2;
      let max_discount = ((_a2 = page.props.settings) == null ? void 0 : _a2.max_discount) || null;
      if (Number(discount.replace("%", "")) > Number(p.product.max_discount)) {
        p.discount = Number(p.product.max_discount) + "%";
        if (p.variations && p.variations.length) {
          p.variations = p.variations.map((v) => {
            v.discount = p.discount;
            return v;
          });
        }
        notify({
          group: "main",
          type: "error",
          title: t("You cannot apply discount more than {x}%", { x: Number(p.product.max_discount) })
        });
      } else if (Number(discount.replace("%", "")) > Number(max_discount)) {
        p.discount = Number(max_discount) + "%";
        if (p.variations && p.variations.length) {
          p.variations = p.variations.map((v) => {
            v.discount = p.discount;
            return v;
          });
        }
        notify({
          group: "main",
          type: "error",
          title: t("You cannot apply discount more than {x}%", { x: Number(max_discount) })
        });
      } else {
        p.discount = discount;
        if (p.variations && p.variations.length) {
          p.variations = p.variations.map((v) => {
            v.discount = p.discount;
            return v;
          });
        }
      }
      return calculate_item(p);
    });
    saveForm();
    order_discount.value = false;
  }
  async function updatedOrderItem(item) {
    selectedItem.value = { ...item };
    updateItem();
    openItemModal.value = false;
  }
  async function showOrderDetails() {
    showOrder.value = true;
    await nextTick();
    orderItemsHeight();
  }
  async function searchProducts(query) {
    if (query) {
      result.value = await searchItems(query, "sale");
      if (result.value.length == 1) {
        addItem(result.value[0]);
      }
    }
  }
  async function addItem(item) {
    var _a2, _b, _c, _d;
    if (form.reference == "f") {
      form.reference = "";
      await nextTick();
      (_a2 = document.getElementById("order-reference")) == null ? void 0 : _a2.focus();
      (_b = document.getElementById("order-reference")) == null ? void 0 : _b.select();
      return false;
    }
    if (form.items.find((i) => i.product_id == item.id)) {
      form.items = form.items.map((i) => {
        if (i.product_id == item.id) {
          if (i.product.has_variants) {
            i.variations = [...i.variations, emptyVariation(i.product)];
            currentItem.value = i;
            variantModal.value = true;
          } else {
            i.quantity++;
          }
        }
        return i;
      });
    } else {
      let product = await axios.get(T("products.show", { product: item.id, with: "promotions" })).then((r) => r.data);
      currentItem.value = calculate_item({
        ...item,
        id: null,
        quantity: 1,
        cost: Number(product.cost),
        price: Number(product.price),
        taxes: product.taxes.map((t2) => t2.id),
        tax_included: product.tax_included == 1,
        product_id: product.id,
        unit_id: product.unit_id,
        product
      });
      if (product.has_variants) {
        currentItem.value.variations = [emptyVariation(product)];
        variantModal.value = true;
      }
      form.items = [...form.items, { ...currentItem.value }];
    }
    form.items = await check_promotions(form);
    saveForm();
    await nextTick();
    search.value = "";
    orderItemsHeight();
    if (!variantModal.value && ((_c = page.props.settings) == null ? void 0 : _c.play_sound) == 1) {
      playSuccessSound();
    } else if (variantModal.value) {
      playErrorSound();
    }
    (_d = document.getElementById("product-search")) == null ? void 0 : _d.focus();
    notify({ group: "mobile", type: "success", text: t("{x} added to order.", { x: item.name }) }, 2e3);
  }
  async function addProduct(p) {
    var _a2, _b;
    if (form.reference == "f") {
      form.reference = "";
      await nextTick();
      (_a2 = document.getElementById("order-reference")) == null ? void 0 : _a2.focus();
      (_b = document.getElementById("order-reference")) == null ? void 0 : _b.select();
      return false;
    }
    searchProducts(p.code);
  }
  async function quantityChanged(p) {
    if (p.quantity < 0) {
      p.quantity = 0;
      return false;
    }
    selectedItem.value = p;
    updateItem(p);
  }
  async function deleteOrder(id) {
    loading.value = true;
    await axios.delete(T("pos.orders.destroy", { order: id })).then((res) => {
      if (res.data.success) {
        showOrders.value = false;
        delete_order.value = false;
        notify({
          group: "main",
          type: "success",
          title: "Success!",
          text: t("The order has been deleted!")
        });
      }
    }).catch().finally(() => loading.value = false);
  }
  function getProducts(category) {
    if (cId.value != category) {
      cId.value = category;
      loading.value = true;
      axios.get(T("pos.products", { category })).then((res) => grid.value = res.data).catch().finally(() => loading.value = false);
    }
  }
  async function showCustomerDetails() {
    var _a2;
    if (((_a2 = customer.value) == null ? void 0 : _a2.id) != form.customer_id) {
      axios.get(T("customers.show", form.customer_id)).then((res) => customer.value = res.data).catch();
    }
    showCustomer.value = true;
  }
  async function addCustomer(e) {
    var _a2;
    addCustomerModal.value = true;
    await nextTick();
    (_a2 = document.getElementById("customer-name")) == null ? void 0 : _a2.focus();
  }
  function handleSubmit(e) {
    form.errors = {};
    if (e && e.number) {
      Object.keys(e).map((k) => form[k] = e[k]);
    }
    form.transform((data) => {
      let form2 = { ...data };
      form2.payments = e.payments;
      form2.tendered = e.tendered;
      form2.order_number = e.number;
      form2.order_reference = e.reference;
      form2.change_returned = e.change_returned;
      form2.reference = null;
      form2.items = form2.items.map((i) => ({
        id: i.id,
        cost: i.cost,
        price: i.price,
        taxes: i.taxes,
        quantity: i.quantity,
        unit_id: i.unit_id,
        discount: i.discount,
        product_id: i.product_id,
        old_quantity: i.old_quantity,
        type: i.type,
        expiry_date: i.expiry_date,
        customer_id: i.customer_id,
        variations: i.variations && i.variations.length ? i.variations.map((v) => ({
          id: v.id,
          cost: v.cost,
          price: v.price,
          taxes: v.taxes,
          unit_id: v.unit_id,
          discount: v.discount,
          quantity: Number(v.quantity),
          old_quantity: v.old_quantity
        })) : null
      }));
      try {
        form2.date = form2.date ? dayjs(form2.date).format("YYYY-MM-DD") : null;
      } catch (err) {
      }
      try {
        form2.due_date = form2.due_date ? dayjs(form2.due_date).format("YYYY-MM-DD") : null;
      } catch (err) {
      }
      return form2;
    }).post(T("sales.store", { to_pos: 1 }), {
      forceFormData: true,
      onSuccess: (page2) => {
        form.reset();
        form.items = [];
        form.number = null;
        form.reference = "f";
        finalize.value = false;
        if (page2.props.flash.sale) {
          showReceiptToPrint(page2.props.flash.sale);
        }
      }
    });
  }
  return {
    grid,
    cId,
    search,
    result,
    errors,
    receipt,
    loading,
    customer,
    finalize,
    itemsHeight,
    showOrder,
    orderItems,
    printBill,
    printOrder,
    showOrders,
    loadingPage,
    orderActions,
    orderDetails,
    orderSummary,
    showReceipt,
    delete_order,
    giftCardModal,
    orderCustomer,
    showCustomer,
    closeRegister,
    loadingOrders,
    menusContainer,
    open_register,
    orderContainer,
    showOrderItem,
    view_register,
    order_discount,
    showMobileMenu,
    closingRegister,
    loadingRegister,
    addCustomerModal,
    mobileMenuContainer,
    form,
    currentItem,
    deleteVariation,
    emptyVariation,
    variantModal,
    SelectVariant,
    openItemModal,
    selectItem,
    selectedItem,
    saveForm,
    resetForm,
    removeItem,
    updateItem,
    openOrder,
    orderItemsHeight,
    holdOrder,
    showPaymentModal,
    print,
    loadOrder,
    showOrderDiscount,
    applyOrderDiscount,
    updatedOrderItem,
    showOrderDetails,
    searchProducts,
    addItem,
    addProduct,
    quantityChanged,
    deleteOrder,
    getProducts,
    showCustomerDetails,
    addCustomer,
    handleSubmit,
    CustomerForm: _sfc_main$f,
    ViewCustomer: _sfc_main$e,
    FormItem: _sfc_main$d,
    OpenOrder: _sfc_main$c,
    PrintBill: _sfc_main$b,
    PrintOrder: _sfc_main$a,
    ShowOrders: _sfc_main$9,
    AddGiftCard: _sfc_main$8,
    FormActions: _sfc_main$7,
    FinalizeSale: _sfc_main$6,
    OpenRegister: _sfc_main$5,
    OrderSummary: _sfc_main$4,
    PrintReceipt: _sfc_main$3,
    OrderDiscount: _sfc_main$2,
    UpdateFormItem: _sfc_main$1,
    RegisterDetails: _sfc_main,
    playSuccessSound,
    playErrorSound
  };
};
export {
  PosHelper as P
};
