import { onMounted, resolveComponent, unref, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent, ssrRenderAttr, ssrRenderList } from "vue/server-renderer";
import { usePage } from "@inertiajs/vue3";
import "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = {
  __name: "PrintOrder",
  __ssrInlineRender: true,
  props: ["form", "show"],
  emits: ["close"],
  setup(__props, { emit: __emit }) {
    const page = usePage();
    onMounted(() => {
      var _a;
      if (((_a = page.props.settings) == null ? void 0 : _a.print_dialog) == 1) {
        setTimeout(print, 500);
      }
    });
    function print() {
      window.print();
    }
    return (_ctx, _push, _parent, _attrs) => {
      var _a, _b, _c, _d, _e, _f, _g;
      const _component_Icon = resolveComponent("Icon");
      _push(`<div${ssrRenderAttrs(_attrs)}><div class="border-b border-gray-200 dark:border-gray-700 p-4 sm:px-6 print:hidden"><div class="absolute right-8 top-0 pr-4 pt-4 flex items-center gap-3"><button type="button" class="relative rounded-md text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 focus"><span class="absolute -inset-2.5"></span><span class="sr-only">${ssrInterpolate(_ctx.$t("Print"))}</span>`);
      _push(ssrRenderComponent(_component_Icon, {
        name: "print-o",
        className: "size-6"
      }, null, _parent));
      _push(`</button></div><div><h3 class="text-base font-semibold leading-6 text-gray-900 dark:text-gray-100">${ssrInterpolate(_ctx.$t("Print Order"))}</h3></div></div>`);
      if (__props.form.items && __props.form.items.filter((i) => i.quantity).length) {
        _push(`<div class="flex flex-col gap-4 m-6">`);
        if (unref(page).props.opened_register.store.logo) {
          _push(`<img class="h-8 max-w-[200pc]"${ssrRenderAttr("src", unref(page).props.opened_register.store.logo)} alt="Logo">`);
        } else {
          _push(`<h2 class="text-center text-lg font-bold">${ssrInterpolate(unref(page).props.opened_register.store.name || _ctx.settings.name)}</h2>`);
        }
        _push(`<h2 class="text-center text-lg font-bold">${ssrInterpolate(_ctx.$t("Order"))}</h2><div>`);
        if (__props.form.id) {
          _push(`<div>${ssrInterpolate(_ctx.$t("Id"))}: ${ssrInterpolate(__props.form.id)}</div>`);
        } else {
          _push(`<!---->`);
        }
        if (__props.form.customer) {
          _push(`<div>${ssrInterpolate(_ctx.$t("Customer"))}: ${ssrInterpolate(((_a = __props.form.customer) == null ? void 0 : _a.company) || ((_b = __props.form.customer) == null ? void 0 : _b.name) || "")}</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div>${ssrInterpolate(_ctx.$t("Order Ref"))}: ${ssrInterpolate(__props.form.reference)}</div><div>${ssrInterpolate(_ctx.$t("Order Number"))}: ${ssrInterpolate(__props.form.number)}</div><div>${ssrInterpolate(_ctx.$t("Created at"))}: ${ssrInterpolate(__props.form.created_at ? _ctx.$datetime(__props.form.created_at) : _ctx.$datetime((/* @__PURE__ */ new Date()).toISOString(), null, null, true))}</div><div>${ssrInterpolate(_ctx.$t("Created  by"))}: ${ssrInterpolate(((_c = __props.form.user) == null ? void 0 : _c.name) || ((_e = (_d = unref(page).props.auth) == null ? void 0 : _d.user) == null ? void 0 : _e.name) || "")}</div></div><div class="-mx-2"><table class="w-full divide-y dark:divide-gray-700 print:divide-gray-400 dark:print:divide-gray-400"><thead><tr><th class="px-2 py-0.5 text-left">${ssrInterpolate(_ctx.$t("Description"))}</th><th class="px-2 py-0.5 text-center w-10">${ssrInterpolate(_ctx.$t("Qty"))}</th></tr></thead><!--[-->`);
        ssrRenderList(__props.form.items, (item) => {
          _push(`<!--[-->`);
          if (item.variations && item.variations.length) {
            _push(`<tbody><tr><td class="px-2 py-0.5 text-left">${ssrInterpolate(item.name)}</td><td class="px-2 py-0.5 text-center w-10"></td></tr><!--[-->`);
            ssrRenderList(item.variations, (variation) => {
              _push(`<tr><td class="px-2 py-0.5 text-left">${ssrInterpolate(_ctx.$meta(variation.meta))}</td><td class="px-2 py-0.5 text-center w-10">${ssrInterpolate(_ctx.$number_qty(variation.quantity))}</td></tr>`);
            });
            _push(`<!--]--></tbody>`);
          } else {
            _push(`<!--[-->`);
            if (item.quantity > 0) {
              _push(`<tbody><tr><td class="px-2 py-0.5 text-left">${ssrInterpolate(item.name)}</td><td class="px-2 py-0.5 text-center w-10">${ssrInterpolate(_ctx.$decimal_qty(item.quantity))}</td></tr></tbody>`);
            } else {
              _push(`<!---->`);
            }
            _push(`<!--]-->`);
          }
          _push(`<!--]-->`);
        });
        _push(`<!--]--></table></div><div><div>${ssrInterpolate(_ctx.$t("Sent at"))}: ${ssrInterpolate(_ctx.$datetime((/* @__PURE__ */ new Date()).toISOString(), null, null, true))}</div><div>${ssrInterpolate(_ctx.$t("Sent by"))}: ${ssrInterpolate(((_g = (_f = unref(page).props.auth) == null ? void 0 : _f.user) == null ? void 0 : _g.name) || "")}</div></div></div>`);
      } else {
        _push(`<div class="flex flex-col gap-4 m-6 text-yellow-600">${ssrInterpolate(_ctx.$t("Please add at least one item to form."))}</div>`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Pos/Components/PrintOrder.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
