import { ref, onMounted, resolveComponent, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent, ssrRenderAttr, ssrRenderList } from "vue/server-renderer";
import { usePage } from "@inertiajs/vue3";
import "./ActionMessage-cgGHxf5V.js";
import "./ActionSection-DLY4AkI5.js";
import "./AuthenticationCardLogo-BUP7R51z.js";
import "./ThemeSwitch-BH8JZmuF.js";
import "./AuthenticationCard-DZUcA5eO.js";
import "./Checkbox-C8_DVKYJ.js";
import "./ConfirmationModal-D2gnpuXK.js";
import "./ConfirmsPassword-mDregivA.js";
import "./DangerButton-C-9IxBUH.js";
import "./FormSection-C7JuSy06.js";
import "./InputError-DjBtKS5r.js";
import "./InputLabel-DXl8D0gR.js";
import "./PrimaryButton-BFULsO35.js";
import "./SecondaryButton-CI1uhr4A.js";
import "./SectionTitle-CrLwNK7a.js";
import "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main = {
  __name: "PrintReceipt",
  __ssrInlineRender: true,
  props: ["receipt", "show"],
  emits: ["close"],
  setup(__props, { emit: __emit }) {
    const page = usePage();
    ref(false);
    onMounted(() => {
      var _a;
      if (((_a = page.props.settings) == null ? void 0 : _a.print_dialog) == 1) {
        setTimeout(print, 500);
      }
    });
    function print() {
      window.print();
    }
    return (_ctx, _push, _parent, _attrs) => {
      var _a, _b, _c, _d, _e, _f, _g;
      const _component_Icon = resolveComponent("Icon");
      _push(`<div${ssrRenderAttrs(_attrs)}><div class="border-b border-gray-200 dark:border-gray-700 p-4 sm:px-6 print:hidden"><div class="absolute right-8 top-0 pr-4 pt-4 flex items-center gap-3"><button type="button" class="relative rounded-md text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200 focus"><span class="absolute -inset-2.5"></span><span class="sr-only">${ssrInterpolate(_ctx.$t("Print"))}</span>`);
      _push(ssrRenderComponent(_component_Icon, {
        name: "print-o",
        className: "size-6"
      }, null, _parent));
      _push(`</button></div><div><h3 class="text-base font-semibold leading-6 text-gray-900 dark:text-gray-100">${ssrInterpolate(_ctx.$t("Print Receipt"))}</h3></div></div>`);
      if (__props.receipt && __props.receipt.items && __props.receipt.items.length) {
        _push(`<div class="flex flex-col gap-4 m-6"><div class="text-center">`);
        if (__props.receipt.store.logo) {
          _push(`<img class="h-8 max-w-[200pc]"${ssrRenderAttr("src", __props.receipt.store.logo)} alt="Logo">`);
        } else {
          _push(`<h2 class="text-center text-lg font-bold">${ssrInterpolate(__props.receipt.store.name || _ctx.settings.name)}</h2>`);
        }
        if ((_a = __props.receipt.store) == null ? void 0 : _a.address) {
          _push(`<div>${ssrInterpolate(__props.receipt.store.address || "")}</div>`);
        } else {
          _push(`<!---->`);
        }
        if ((_b = __props.receipt.store) == null ? void 0 : _b.phone) {
          _push(`<div>${ssrInterpolate(_ctx.$t("Phone"))}: ${ssrInterpolate(__props.receipt.store.phone || "")}</div>`);
        } else {
          _push(`<!---->`);
        }
        if ((_c = __props.receipt.store) == null ? void 0 : _c.email) {
          _push(`<div>${ssrInterpolate(_ctx.$t("Email"))}: ${ssrInterpolate(__props.receipt.store.email || "")}</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
        if ((_d = __props.receipt.store) == null ? void 0 : _d.receipt_header) {
          _push(`<div class="text-center">${ssrInterpolate(__props.receipt.store.receipt_header || "")}</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<h2 class="text-center text-lg font-bold">${ssrInterpolate(_ctx.$t("Receipt"))}</h2><div><div>${ssrInterpolate(_ctx.$t("Sale No."))}: ${ssrInterpolate(__props.receipt.id || "")}</div><div>${ssrInterpolate(_ctx.$t("Customer"))}: ${ssrInterpolate(((_e = __props.receipt.customer) == null ? void 0 : _e.name) || "")}</div><div>${ssrInterpolate(_ctx.$t("Reference"))}: ${ssrInterpolate(__props.receipt.reference)}</div><div>${ssrInterpolate(_ctx.$t("Order Number"))}: #${ssrInterpolate(__props.receipt.order_number)}</div><div>${ssrInterpolate(_ctx.$t("Created at"))}: ${ssrInterpolate(__props.receipt.created_at ? _ctx.$datetime(__props.receipt.created_at) : _ctx.$datetime((/* @__PURE__ */ new Date()).toISOString(), null, null, true))}</div><div>${ssrInterpolate(_ctx.$t("Created  by"))}: ${ssrInterpolate(((_f = __props.receipt.user) == null ? void 0 : _f.name) || "")}</div></div><div class="-mx-2"><table class="w-full divide-y dark:divide-gray-700 print:divide-gray-400 dark:print:divide-gray-400"><thead><tr><th class="px-2 py-0.5 text-left">${ssrInterpolate(_ctx.$t("Description"))}</th><th class="px-2 py-0.5 text-center w-10">${ssrInterpolate(_ctx.$t("Qty"))}</th><th class="px-2 py-0.5 text-center w-10">${ssrInterpolate(_ctx.$t("Price"))}</th><th class="px-2 py-0.5 text-center w-10">${ssrInterpolate(_ctx.$t("Total"))}</th></tr></thead><!--[-->`);
        ssrRenderList(__props.receipt.items, (item) => {
          var _a2, _b2;
          _push(`<!--[-->`);
          if (item.variations && item.variations.length) {
            _push(`<tbody><tr><td class="px-2 py-0.5 text-left">${ssrInterpolate(item.product.name)}</td><td class="px-2 py-0.5 text-center w-10"></td><td class="px-2 py-0.5 text-right w-10"></td><td class="px-2 p&lt;/template&gt;y-0.5 text-right w-10"></td></tr><!--[-->`);
            ssrRenderList(item.variations, (variation) => {
              var _a3, _b3;
              _push(`<tr><td class="px-2 py-0.5 text-left">${ssrInterpolate(_ctx.$meta(variation.meta))}</td><td class="px-2 py-0.5 text-center w-10"><div class="flex">${ssrInterpolate(_ctx.$number_qty(variation.pivot.quantity))}${ssrInterpolate(((_b3 = (_a3 = variation.pivot) == null ? void 0 : _a3.unit) == null ? void 0 : _b3.code) || "")}</div></td><td class="px-2 py-0.5 text-right w-10">${ssrInterpolate(_ctx.$number(variation.pivot.price))}</td><td class="px-2 p&lt;/template&gt;y-0.5 text-right w-10">${ssrInterpolate(_ctx.$number(variation.pivot.total))}</td></tr>`);
            });
            _push(`<!--]--></tbody>`);
          } else {
            _push(`<!--[-->`);
            if (item.quantity > 0) {
              _push(`<tbody><tr><td class="px-2 py-0.5 text-left">`);
              if (item.type == "Gift Card") {
                _push(`<div class="flex items-center">${ssrInterpolate(_ctx.$t("Gift Card"))} <span class="text-xs font-bold ml-1">(${ssrInterpolate(item.code)})</span></div>`);
              } else {
                _push(`<!--[-->${ssrInterpolate((_a2 = item.product) == null ? void 0 : _a2.name)}<!--]-->`);
              }
              _push(`</td><td class="px-2 py-0.5 text-center w-10"><div class="flex">${ssrInterpolate(_ctx.$number_qty(item.quantity))}${ssrInterpolate(((_b2 = item.unit) == null ? void 0 : _b2.code) || "")}</div></td><td class="px-2 py-0.5 text-right w-10">${ssrInterpolate(_ctx.$number(item.price))}</td><td class="px-2 py-0.5 text-right w-10">${ssrInterpolate(_ctx.$number(item.total))}</td></tr></tbody>`);
            } else {
              _push(`<!---->`);
            }
            _push(`<!--]-->`);
          }
          _push(`<!--]-->`);
        });
        _push(`<!--]--><tfoot><tr><th colspan="3" class="px-2 py-0.5 text-right">${ssrInterpolate(_ctx.$t("Total"))}</th><th class="px-2 py-0.5 text-right whitespace-nowrap w-10">${ssrInterpolate(_ctx.$number(__props.receipt.total))}</th></tr>`);
        if (__props.receipt.discount_amount > 0) {
          _push(`<tr><th colspan="3" class="px-2 py-0.5 text-right">${ssrInterpolate(_ctx.$t("Discount"))}</th><th class="px-2 py-0.5 text-right whitespace-nowrap w-10">${ssrInterpolate(_ctx.$number(__props.receipt.discount_amount))}</th></tr>`);
        } else {
          _push(`<!---->`);
        }
        if (__props.receipt.total_tax_amount > 0) {
          _push(`<tr><th colspan="3" class="px-2 py-0.5 text-right">${ssrInterpolate(_ctx.$t("Tax"))}</th><th class="px-2 py-0.5 text-right whitespace-nowrap w-10">${ssrInterpolate(_ctx.$number(__props.receipt.total_tax_amount))}</th></tr>`);
        } else {
          _push(`<!---->`);
        }
        if (Number(__props.receipt.total_tax_amount) > 0 || Number(__props.receipt.discount_amount) > 0 || Number(__props.receipt.total) != Number(__props.receipt.grand_total)) {
          _push(`<tr><th colspan="3" class="px-2 py-0.5 text-right">${ssrInterpolate(_ctx.$t("Grand Total"))}</th><th class="px-2 py-0.5 text-right whitespace-nowrap w-10">${ssrInterpolate(_ctx.$number(__props.receipt.grand_total))}</th></tr>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<tr><th colspan="3" class="px-2 py-0.5 text-right">${ssrInterpolate(_ctx.$t("Paid"))}</th><th class="px-2 py-0.5 text-right whitespace-nowrap w-10">${ssrInterpolate(_ctx.$number(__props.receipt.paid))}</th></tr><tr><th colspan="3" class="px-2 py-0.5 text-right">${ssrInterpolate(_ctx.$t("Balance"))}</th><th class="px-2 py-0.5 text-right whitespace-nowrap w-10">${ssrInterpolate(_ctx.$number(__props.receipt.grand_total - __props.receipt.paid))}</th></tr></tfoot></table></div>`);
        if (Number(__props.receipt.tendered) > 0) {
          _push(`<div><div>${ssrInterpolate(_ctx.$t("Tender Amount"))}: ${ssrInterpolate(_ctx.$number(__props.receipt.tendered))}</div><div>${ssrInterpolate(_ctx.$t("Return Amount"))}: ${ssrInterpolate(_ctx.$number(__props.receipt.change_returned))}</div></div>`);
        } else {
          _push(`<!---->`);
        }
        if (__props.receipt.details) {
          _push(`<div class="text-center">${ssrInterpolate(__props.receipt.details || "")}</div>`);
        } else {
          _push(`<!---->`);
        }
        if ((_g = __props.receipt.store) == null ? void 0 : _g.receipt_footer) {
          _push(`<div class="text-center">${ssrInterpolate(__props.receipt.store.receipt_footer || "")}</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Sma/Pos/Components/PrintReceipt.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
export {
  _sfc_main as default
};
